#ifndef WRITEODFCONFIG_H
#define WRITEODFCONFIG_H
#include "writeodf.h"
namespace writeodf {
class config_config_item : public OdfWriter {
public:
    config_config_item(OdfWriter* x, const QString& config_name, const QString& config_type) :OdfWriter(x, "config:config-item", false) {
        addAttribute("config:name", config_name);
        addAttribute("config:type", config_type);
    }
    config_config_item(KoXmlWriter* x, const QString& config_name, const QString& config_type) :OdfWriter(x, "config:config-item", false) {
        addAttribute("config:name", config_name);
        addAttribute("config:type", config_type);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class config_config_item_map_indexed : public OdfWriter, public group_config_config_item_map_entry {
public:
    config_config_item_map_indexed(OdfWriter* x, const QString& config_name) :OdfWriter(x, "config:config-item-map-indexed", true), group_config_config_item_map_entry(*static_cast<OdfWriter*>(this)) {
        addAttribute("config:name", config_name);
    }
    config_config_item_map_indexed(KoXmlWriter* x, const QString& config_name) :OdfWriter(x, "config:config-item-map-indexed", true), group_config_config_item_map_entry(*static_cast<OdfWriter*>(this)) {
        addAttribute("config:name", config_name);
    }
};
class config_config_item_map_named : public OdfWriter, public group_config_config_item_map_entry {
public:
    config_config_item_map_named(OdfWriter* x, const QString& config_name) :OdfWriter(x, "config:config-item-map-named", true), group_config_config_item_map_entry(*static_cast<OdfWriter*>(this)) {
        addAttribute("config:name", config_name);
    }
    config_config_item_map_named(KoXmlWriter* x, const QString& config_name) :OdfWriter(x, "config:config-item-map-named", true), group_config_config_item_map_entry(*static_cast<OdfWriter*>(this)) {
        addAttribute("config:name", config_name);
    }
};
class config_config_item_set : public OdfWriter, public group_config_items {
public:
    config_config_item_set(OdfWriter* x, const QString& config_name) :OdfWriter(x, "config:config-item-set", true), group_config_items(*static_cast<OdfWriter*>(this)) {
        addAttribute("config:name", config_name);
    }
    config_config_item_set(KoXmlWriter* x, const QString& config_name) :OdfWriter(x, "config:config-item-set", true), group_config_items(*static_cast<OdfWriter*>(this)) {
        addAttribute("config:name", config_name);
    }
};
class config_config_item_map_entry : public OdfWriter, public group_config_items {
public:
    config_config_item_map_entry(OdfWriter* x) :OdfWriter(x, "config:config-item-map-entry", true), group_config_items(*static_cast<OdfWriter*>(this)) {
    }
    config_config_item_map_entry(KoXmlWriter* x) :OdfWriter(x, "config:config-item-map-entry", true), group_config_items(*static_cast<OdfWriter*>(this)) {
    }
    void set_config_name(const QString& value) {
        addAttribute("config:name", value);
    }
};
}
inline writeodf::config_config_item_map_entry
writeodf::group_config_config_item_map_entry::add_config_config_item_map_entry() {
    return writeodf::config_config_item_map_entry(&xml);
}
inline writeodf::config_config_item_set
writeodf::group_config_config_item_set::add_config_config_item_set(const QString& config_name) {
    return writeodf::config_config_item_set(&xml, config_name);
}
inline writeodf::config_config_item
writeodf::group_config_items::add_config_config_item(const QString& config_name, const QString& config_type) {
    return writeodf::config_config_item(&xml, config_name, config_type);
}
inline writeodf::config_config_item_map_indexed
writeodf::group_config_items::add_config_config_item_map_indexed(const QString& config_name) {
    return writeodf::config_config_item_map_indexed(&xml, config_name);
}
inline writeodf::config_config_item_map_named
writeodf::group_config_items::add_config_config_item_map_named(const QString& config_name) {
    return writeodf::config_config_item_map_named(&xml, config_name);
}
#endif
