#ifndef WRITEODFMETA_H
#define WRITEODFMETA_H
#include "writeodf.h"
namespace writeodf {
class meta_auto_reload : public OdfWriter {
public:
    meta_auto_reload(OdfWriter* x) :OdfWriter(x, "meta:auto-reload", false) {
    }
    meta_auto_reload(KoXmlWriter* x) :OdfWriter(x, "meta:auto-reload", false) {
    }
    void set_meta_delay(Duration value) {
        addAttribute("meta:delay", value);
    }
    template<class T>
    void set_xlink_actuate(const T& value) {
        addAttribute("xlink:actuate", value);
    }
    void set_xlink_href(const QUrl& value) {
        addAttribute("xlink:href", value);
    }
    template<class T>
    void set_xlink_show(const T& value) {
        addAttribute("xlink:show", value);
    }
    template<class T>
    void set_xlink_type(const T& value) {
        addAttribute("xlink:type", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_print_date : public OdfWriter {
public:
    meta_print_date(OdfWriter* x) :OdfWriter(x, "meta:print-date", false) {
    }
    meta_print_date(KoXmlWriter* x) :OdfWriter(x, "meta:print-date", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_template : public OdfWriter {
public:
    meta_template(OdfWriter* x, const QUrl& xlink_href) :OdfWriter(x, "meta:template", false) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    meta_template(KoXmlWriter* x, const QUrl& xlink_href) :OdfWriter(x, "meta:template", false) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    void set_meta_date(const QDateTime& value) {
        addAttribute("meta:date", value);
    }
    template<class T>
    void set_xlink_actuate(const T& value) {
        addAttribute("xlink:actuate", value);
    }
    void set_xlink_title(const QString& value) {
        addAttribute("xlink:title", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_editing_cycles : public OdfWriter {
public:
    meta_editing_cycles(OdfWriter* x) :OdfWriter(x, "meta:editing-cycles", false) {
    }
    meta_editing_cycles(KoXmlWriter* x) :OdfWriter(x, "meta:editing-cycles", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_creation_date : public OdfWriter {
public:
    meta_creation_date(OdfWriter* x) :OdfWriter(x, "meta:creation-date", false) {
    }
    meta_creation_date(KoXmlWriter* x) :OdfWriter(x, "meta:creation-date", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_document_statistic : public OdfWriter {
public:
    meta_document_statistic(OdfWriter* x) :OdfWriter(x, "meta:document-statistic", false) {
    }
    meta_document_statistic(KoXmlWriter* x) :OdfWriter(x, "meta:document-statistic", false) {
    }
    void set_meta_cell_count(quint64 value) {
        addAttribute("meta:cell-count", value);
    }
    void set_meta_character_count(quint64 value) {
        addAttribute("meta:character-count", value);
    }
    void set_meta_draw_count(quint64 value) {
        addAttribute("meta:draw-count", value);
    }
    void set_meta_frame_count(quint64 value) {
        addAttribute("meta:frame-count", value);
    }
    void set_meta_image_count(quint64 value) {
        addAttribute("meta:image-count", value);
    }
    void set_meta_non_whitespace_character_count(quint64 value) {
        addAttribute("meta:non-whitespace-character-count", value);
    }
    void set_meta_object_count(quint64 value) {
        addAttribute("meta:object-count", value);
    }
    void set_meta_ole_object_count(quint64 value) {
        addAttribute("meta:ole-object-count", value);
    }
    void set_meta_page_count(quint64 value) {
        addAttribute("meta:page-count", value);
    }
    void set_meta_paragraph_count(quint64 value) {
        addAttribute("meta:paragraph-count", value);
    }
    void set_meta_row_count(quint64 value) {
        addAttribute("meta:row-count", value);
    }
    void set_meta_sentence_count(quint64 value) {
        addAttribute("meta:sentence-count", value);
    }
    void set_meta_syllable_count(quint64 value) {
        addAttribute("meta:syllable-count", value);
    }
    void set_meta_table_count(quint64 value) {
        addAttribute("meta:table-count", value);
    }
    void set_meta_word_count(quint64 value) {
        addAttribute("meta:word-count", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_editing_duration : public OdfWriter {
public:
    meta_editing_duration(OdfWriter* x) :OdfWriter(x, "meta:editing-duration", false) {
    }
    meta_editing_duration(KoXmlWriter* x) :OdfWriter(x, "meta:editing-duration", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_hyperlink_behaviour : public OdfWriter {
public:
    meta_hyperlink_behaviour(OdfWriter* x) :OdfWriter(x, "meta:hyperlink-behaviour", false) {
    }
    meta_hyperlink_behaviour(KoXmlWriter* x) :OdfWriter(x, "meta:hyperlink-behaviour", false) {
    }
    template<class T>
    void set_office_target_frame_name(const T& value) {
        addAttribute("office:target-frame-name", value);
    }
    template<class T>
    void set_xlink_show(const T& value) {
        addAttribute("xlink:show", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_keyword : public OdfWriter {
public:
    meta_keyword(OdfWriter* x) :OdfWriter(x, "meta:keyword", false) {
    }
    meta_keyword(KoXmlWriter* x) :OdfWriter(x, "meta:keyword", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_user_defined : public OdfWriter {
public:
    meta_user_defined(OdfWriter* x, const QString& meta_name) :OdfWriter(x, "meta:user-defined", false) {
        addAttribute("meta:name", meta_name);
    }
    meta_user_defined(KoXmlWriter* x, const QString& meta_name) :OdfWriter(x, "meta:user-defined", false) {
        addAttribute("meta:name", meta_name);
    }
    template<class T>
    void set_meta_value_type(const T& value) {
        addAttribute("meta:value-type", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_generator : public OdfWriter {
public:
    meta_generator(OdfWriter* x) :OdfWriter(x, "meta:generator", false) {
    }
    meta_generator(KoXmlWriter* x) :OdfWriter(x, "meta:generator", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_printed_by : public OdfWriter {
public:
    meta_printed_by(OdfWriter* x) :OdfWriter(x, "meta:printed-by", false) {
    }
    meta_printed_by(KoXmlWriter* x) :OdfWriter(x, "meta:printed-by", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_initial_creator : public OdfWriter {
public:
    meta_initial_creator(OdfWriter* x) :OdfWriter(x, "meta:initial-creator", false) {
    }
    meta_initial_creator(KoXmlWriter* x) :OdfWriter(x, "meta:initial-creator", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class meta_date_string : public OdfWriter {
public:
    meta_date_string(OdfWriter* x) :OdfWriter(x, "meta:date-string", false) {
    }
    meta_date_string(KoXmlWriter* x) :OdfWriter(x, "meta:date-string", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
}
#endif
