// This file is generated by kconfig_compiler_kf6 from qalculatebackend.kcfg.
// All changes you do to this file will be lost.
#ifndef QALCULATESETTINGS_H
#define QALCULATESETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class QalculateSettings : public KConfigSkeleton
{
  public:
    enum AngleUnit { ANGLE_UNIT_NONE, ANGLE_UNIT_RADIANS, ANGLE_UNIT_DEGREES, ANGLE_UNIT_GRADIANS };
    enum StructuringMode { STRUCTURING_NONE, STRUCTURING_SIMPLIFY, STRUCTURING_FACTORIZE };
    enum NumberFractionFormat { FRACTION_DECIMAL, FRACTION_DECIMAL_EXACT, FRACTION_FRACTIONAL, FRACTION_COMBINED };
    enum ExpMode { EXP_NONE, EXP_PURE, EXP_SCIENTIFIC, EXP_PRECISION };
    enum SmoothingMode { SMOOTHING_NONE, SMOOTHING_UNIQUE, SMOOTHING_CSPLINES, SMOOTHING_BEZIER, SMOOTHING_SBEZIER };
    enum PlotStyle { STYLE_LINES, STYLE_POINTS, STYLE_LINES_POINTS, STYLE_BOXES, STYLE_HISTOGRAM, STYLE_STEPS, STYLE_CANDLESTICKS, STYLE_DOTS };
    enum LegendPosition { LEGEND_NONE, LEGEND_TOP_LEFT, LEGEND_TOP_RIGHT, LEGEND_BOTTOM_LEFT, LEGEND_BOTTOM_RIGHT, LEGEND_BELOW, LEGEND_OUTSIDE };

    static QalculateSettings *self();
    ~QalculateSettings() override;

    /**
      Get Path to the Qalculate! executable
    */
    static
    QUrl path()
    {
      return self()->mPath;
    }

    /**
      Is Path to the Qalculate! executable Immutable
    */
    static
    bool isPathImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Path" ) );
    }

    /**
      Get If and how units will be automatically converted. If true, convert to the best suited SI units (the least amount of units).
    */
    static
    bool postConversion()
    {
      return self()->mPostConversion;
    }

    /**
      Is If and how units will be automatically converted. If true, convert to the best suited SI units (the least amount of units). Immutable
    */
    static
    bool isPostConversionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "postConversion" ) );
    }

    /**
      Get Default angle unit for trigonometric functions.
    */
    static
    int angleUnit()
    {
      return self()->mAngleUnit;
    }

    /**
      Is Default angle unit for trigonometric functions. Immutable
    */
    static
    bool isAngleUnitImmutable()
    {
      return self()->isImmutable( QStringLiteral( "angleUnit" ) );
    }

    /**
      Get Base of parsed and evaluated numbers.
    */
    static
    int base()
    {
      return self()->mBase;
    }

    /**
      Is Base of parsed and evaluated numbers. Immutable
    */
    static
    bool isBaseImmutable()
    {
      return self()->isImmutable( QStringLiteral( "base" ) );
    }

    /**
      Get If the evaluation result will be simplified or factorized.
    */
    static
    int structuring()
    {
      return self()->mStructuring;
    }

    /**
      Is If the evaluation result will be simplified or factorized. Immutable
    */
    static
    bool isStructuringImmutable()
    {
      return self()->isImmutable( QStringLiteral( "structuring" ) );
    }

    /**
      Get If rational numbers will be displayed with decimals, as a fraction, or something in between.
    */
    static
    int fractionFormat()
    {
      return self()->mFractionFormat;
    }

    /**
      Is If rational numbers will be displayed with decimals, as a fraction, or something in between. Immutable
    */
    static
    bool isFractionFormatImmutable()
    {
      return self()->isImmutable( QStringLiteral( "fractionFormat" ) );
    }

    /**
      Get Show that the digit series of a number continues forever with three dots, instead of rounding (ex. 2/3 displays as 0.666666... instead of 0.666667).
    */
    static
    bool indicateInfiniteSeries()
    {
      return self()->mIndicateInfiniteSeries;
    }

    /**
      Is Show that the digit series of a number continues forever with three dots, instead of rounding (ex. 2/3 displays as 0.666666... instead of 0.666667). Immutable
    */
    static
    bool isIndicateInfiniteSeriesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "indicateInfiniteSeries" ) );
    }

    /**
      Get Use all decimal SI prefixes. If false, prefixes which is not a multiple of thousand (centi, deci, deca, hecto) will not be used automatically.
    */
    static
    bool useAllPrefixes()
    {
      return self()->mUseAllPrefixes;
    }

    /**
      Is Use all decimal SI prefixes. If false, prefixes which is not a multiple of thousand (centi, deci, deca, hecto) will not be used automatically. Immutable
    */
    static
    bool isUseAllPrefixesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "useAllPrefixes" ) );
    }

    /**
      Get If true, negative exponents will be used instead of division (ex. 5/x^2 becomes 5*x^-2).
    */
    static
    bool negativeExponents()
    {
      return self()->mNegativeExponents;
    }

    /**
      Is If true, negative exponents will be used instead of division (ex. 5/x^2 becomes 5*x^-2). Immutable
    */
    static
    bool isNegativeExponentsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "negativeExponents" ) );
    }

    /**
      Get Numerical display.
    */
    static
    int minExp()
    {
      return self()->mMinExp;
    }

    /**
      Is Numerical display. Immutable
    */
    static
    bool isMinExpImmutable()
    {
      return self()->isImmutable( QStringLiteral( "minExp" ) );
    }

    /**
      Get If true, plots will be displayed inside the worksheet. If not they appear in a separate window.
    */
    static
    bool inlinePlot()
    {
      return self()->mInlinePlot;
    }

    /**
      Is If true, plots will be displayed inside the worksheet. If not they appear in a separate window. Immutable
    */
    static
    bool isInlinePlotImmutable()
    {
      return self()->isImmutable( QStringLiteral( "inlinePlot" ) );
    }

    /**
      Get Whether colors should be used in plots.
    */
    static
    bool coloredPlot()
    {
      return self()->mColoredPlot;
    }

    /**
      Is Whether colors should be used in plots. Immutable
    */
    static
    bool isColoredPlotImmutable()
    {
      return self()->isImmutable( QStringLiteral( "coloredPlot" ) );
    }

    /**
      Get Whether a grid should be plotted.
    */
    static
    bool plotGrid()
    {
      return self()->mPlotGrid;
    }

    /**
      Is Whether a grid should be plotted. Immutable
    */
    static
    bool isPlotGridImmutable()
    {
      return self()->isImmutable( QStringLiteral( "plotGrid" ) );
    }

    /**
      Get Whether full borders should be drawn around the plot.
    */
    static
    bool plotBorder()
    {
      return self()->mPlotBorder;
    }

    /**
      Is Whether full borders should be drawn around the plot. Immutable
    */
    static
    bool isPlotBorderImmutable()
    {
      return self()->isImmutable( QStringLiteral( "plotBorder" ) );
    }

    /**
      Get Width of lines, in pixels.
    */
    static
    int plotLineWidth()
    {
      return self()->mPlotLineWidth;
    }

    /**
      Is Width of lines, in pixels. Immutable
    */
    static
    bool isPlotLineWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "plotLineWidth" ) );
    }

    /**
      Get Number of interpolation steps to be used in plotting.
    */
    static
    int plotSteps()
    {
      return self()->mPlotSteps;
    }

    /**
      Is Number of interpolation steps to be used in plotting. Immutable
    */
    static
    bool isPlotStepsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "plotSteps" ) );
    }

    /**
      Get Smoothing mode in plots.
    */
    static
    int plotSmoothing()
    {
      return self()->mPlotSmoothing;
    }

    /**
      Is Smoothing mode in plots. Immutable
    */
    static
    bool isPlotSmoothingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "plotSmoothing" ) );
    }

    /**
      Get Style of plots.
    */
    static
    int plotStyle()
    {
      return self()->mPlotStyle;
    }

    /**
      Is Style of plots. Immutable
    */
    static
    bool isPlotStyleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "plotStyle" ) );
    }

    /**
      Get Legend position in plots.
    */
    static
    int plotLegend()
    {
      return self()->mPlotLegend;
    }

    /**
      Is Legend position in plots. Immutable
    */
    static
    bool isPlotLegendImmutable()
    {
      return self()->isImmutable( QStringLiteral( "plotLegend" ) );
    }

    /**
      Get List of scripts to autorun at the beginning of session
    */
    static
    QStringList autorunScripts()
    {
      return self()->mAutorunScripts;
    }

    /**
      Is List of scripts to autorun at the beginning of session Immutable
    */
    static
    bool isAutorunScriptsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "autorunScripts" ) );
    }

  protected:
    QalculateSettings();
    friend class QalculateSettingsHelper;


    // QalculateBackend
    QUrl mPath;
    bool mPostConversion;
    int mAngleUnit;
    int mBase;
    int mStructuring;
    int mFractionFormat;
    bool mIndicateInfiniteSeries;
    bool mUseAllPrefixes;
    bool mNegativeExponents;
    int mMinExp;
    bool mInlinePlot;
    bool mColoredPlot;
    bool mPlotGrid;
    bool mPlotBorder;
    int mPlotLineWidth;
    int mPlotSteps;
    int mPlotSmoothing;
    int mPlotStyle;
    int mPlotLegend;
    QStringList mAutorunScripts;

  private:
};

#endif

