// Code generated by typeshare 1.13.2. DO NOT EDIT.
package onepassword

import (
	"encoding/json"
	"time"
)

type ErrorMessage string

// Additional attributes for OTP fields.
type AddressFieldDetails struct {
	// The street address
	Street string `json:"street"`
	// The city
	City string `json:"city"`
	// The country
	Country string `json:"country"`
	// The ZIP code
	Zip string `json:"zip"`
	// The state
	State string `json:"state"`
}
type DocumentCreateParams struct {
	// The name of the file
	Name string `json:"name"`
	// The content of the file
	Content []byte `json:"content"`
}
type FileAttributes struct {
	// The name of the file
	Name string `json:"name"`
	// The ID of the file retrieved from the server
	ID string `json:"id"`
	// The size of the file in bytes
	Size uint32 `json:"size"`
}
type FileCreateParams struct {
	// The name of the file
	Name string `json:"name"`
	// The content of the file
	Content []byte `json:"content"`
	// The section id where the file should be stored
	SectionID string `json:"sectionId"`
	// The field id where the file should be stored
	FieldID string `json:"fieldId"`
}

// For future use, if we want to return more information about the generated password.
// Currently, it only returns the password itself.
type GeneratePasswordResponse struct {
	// The generated password.
	Password string `json:"password"`
}
type ItemCategory string

const (
	ItemCategoryLogin                ItemCategory = "Login"
	ItemCategorySecureNote           ItemCategory = "SecureNote"
	ItemCategoryCreditCard           ItemCategory = "CreditCard"
	ItemCategoryCryptoWallet         ItemCategory = "CryptoWallet"
	ItemCategoryIdentity             ItemCategory = "Identity"
	ItemCategoryPassword             ItemCategory = "Password"
	ItemCategoryDocument             ItemCategory = "Document"
	ItemCategoryAPICredentials       ItemCategory = "ApiCredentials"
	ItemCategoryBankAccount          ItemCategory = "BankAccount"
	ItemCategoryDatabase             ItemCategory = "Database"
	ItemCategoryDriverLicense        ItemCategory = "DriverLicense"
	ItemCategoryEmail                ItemCategory = "Email"
	ItemCategoryMedicalRecord        ItemCategory = "MedicalRecord"
	ItemCategoryMembership           ItemCategory = "Membership"
	ItemCategoryOutdoorLicense       ItemCategory = "OutdoorLicense"
	ItemCategoryPassport             ItemCategory = "Passport"
	ItemCategoryRewards              ItemCategory = "Rewards"
	ItemCategoryRouter               ItemCategory = "Router"
	ItemCategoryServer               ItemCategory = "Server"
	ItemCategorySSHKey               ItemCategory = "SshKey"
	ItemCategorySocialSecurityNumber ItemCategory = "SocialSecurityNumber"
	ItemCategorySoftwareLicense      ItemCategory = "SoftwareLicense"
	ItemCategoryPerson               ItemCategory = "Person"
	ItemCategoryUnsupported          ItemCategory = "Unsupported"
)

type ItemFieldType string

const (
	ItemFieldTypeText             ItemFieldType = "Text"
	ItemFieldTypeConcealed        ItemFieldType = "Concealed"
	ItemFieldTypeCreditCardType   ItemFieldType = "CreditCardType"
	ItemFieldTypeCreditCardNumber ItemFieldType = "CreditCardNumber"
	ItemFieldTypePhone            ItemFieldType = "Phone"
	ItemFieldTypeURL              ItemFieldType = "Url"
	ItemFieldTypeTOTP             ItemFieldType = "Totp"
	ItemFieldTypeEmail            ItemFieldType = "Email"
	ItemFieldTypeReference        ItemFieldType = "Reference"
	ItemFieldTypeSSHKey           ItemFieldType = "SshKey"
	ItemFieldTypeMenu             ItemFieldType = "Menu"
	ItemFieldTypeMonthYear        ItemFieldType = "MonthYear"
	ItemFieldTypeAddress          ItemFieldType = "Address"
	ItemFieldTypeDate             ItemFieldType = "Date"
	ItemFieldTypeUnsupported      ItemFieldType = "Unsupported"
)

// Field type-specific attributes.
type ItemFieldDetailsTypes string

const (
	// The computed OTP code and other details
	ItemFieldDetailsTypeVariantOTP ItemFieldDetailsTypes = "Otp"
	// Computed SSH Key attributes
	ItemFieldDetailsTypeVariantSSHKey ItemFieldDetailsTypes = "SshKey"
	// Address components
	ItemFieldDetailsTypeVariantAddress ItemFieldDetailsTypes = "Address"
)

type ItemFieldDetails struct {
	Type    ItemFieldDetailsTypes `json:"type"`
	content interface{}
}

func (i *ItemFieldDetails) UnmarshalJSON(data []byte) error {
	var enum struct {
		Tag     ItemFieldDetailsTypes `json:"type"`
		Content json.RawMessage       `json:"content"`
	}
	if err := json.Unmarshal(data, &enum); err != nil {
		return err
	}

	i.Type = enum.Tag
	switch i.Type {
	case ItemFieldDetailsTypeVariantOTP:
		var res OTPFieldDetails
		i.content = &res
	case ItemFieldDetailsTypeVariantSSHKey:
		var res *SSHKeyAttributes
		i.content = &res
	case ItemFieldDetailsTypeVariantAddress:
		var res *AddressFieldDetails
		i.content = &res

	}
	if err := json.Unmarshal(enum.Content, &i.content); err != nil {
		return err
	}

	return nil
}

func (i ItemFieldDetails) MarshalJSON() ([]byte, error) {
	var enum struct {
		Tag     ItemFieldDetailsTypes `json:"type"`
		Content interface{}           `json:"content,omitempty"`
	}
	enum.Tag = i.Type
	enum.Content = i.content
	return json.Marshal(enum)
}

func (i ItemFieldDetails) OTP() *OTPFieldDetails {
	res, _ := i.content.(*OTPFieldDetails)
	return res
}
func (i ItemFieldDetails) SSHKey() *SSHKeyAttributes {
	res, _ := i.content.(**SSHKeyAttributes)
	return *res
}
func (i ItemFieldDetails) Address() *AddressFieldDetails {
	res, _ := i.content.(**AddressFieldDetails)
	return *res
}

func NewItemFieldDetailsTypeVariantOTP(content *OTPFieldDetails) ItemFieldDetails {
	return ItemFieldDetails{
		Type:    ItemFieldDetailsTypeVariantOTP,
		content: content,
	}
}
func NewItemFieldDetailsTypeVariantSSHKey(content *SSHKeyAttributes) ItemFieldDetails {
	return ItemFieldDetails{
		Type:    ItemFieldDetailsTypeVariantSSHKey,
		content: &content,
	}
}
func NewItemFieldDetailsTypeVariantAddress(content *AddressFieldDetails) ItemFieldDetails {
	return ItemFieldDetails{
		Type:    ItemFieldDetailsTypeVariantAddress,
		content: &content,
	}
}

// Represents a field within an item.
type ItemField struct {
	// The field's ID
	ID string `json:"id"`
	// The field's title
	Title string `json:"title"`
	// The ID of the section containing the field. Built-in fields such as usernames and passwords don't require a section.
	SectionID *string `json:"sectionId,omitempty"`
	// The field's type
	FieldType ItemFieldType `json:"fieldType"`
	// The string representation of the field's value
	Value string `json:"value"`
	// Field type-specific attributes.
	Details *ItemFieldDetails `json:"details,omitempty"`
}

// A section groups together multiple fields in an item.
type ItemSection struct {
	// The section's unique ID
	ID string `json:"id"`
	// The section's title
	Title string `json:"title"`
}

// Controls the auto-fill behavior of a website.
//
// For more information, visit https://support.1password.com/autofill-behavior/
type AutofillBehavior string

const (
	// Auto-fill any page that’s part of the website, including subdomains
	AutofillBehaviorAnywhereOnWebsite AutofillBehavior = "AnywhereOnWebsite"
	// Auto-fill only if the domain (hostname and port) is an exact match.
	AutofillBehaviorExactDomain AutofillBehavior = "ExactDomain"
	// Never auto-fill on this website
	AutofillBehaviorNever AutofillBehavior = "Never"
)

type Website struct {
	// The website URL
	URL string `json:"url"`
	// The label of the website, e.g. 'website', 'sign-in address'
	Label string `json:"label"`
	// The auto-fill behavior of the website
	//
	// For more information, visit https://support.1password.com/autofill-behavior/
	AutofillBehavior AutofillBehavior `json:"autofillBehavior"`
}
type ItemFile struct {
	// the attributes of the file
	Attributes FileAttributes `json:"attributes"`
	// the section id where the file should be stored
	SectionID string `json:"sectionId"`
	// the field id where the file should be stored
	FieldID string `json:"fieldId"`
}

// Represents an active 1Password item.
type Item struct {
	// The item's ID
	ID string `json:"id"`
	// The item's title
	Title string `json:"title"`
	// The item's category
	Category ItemCategory `json:"category"`
	// The ID of the vault where the item is saved
	VaultID string `json:"vaultId"`
	// The item's fields
	Fields []ItemField `json:"fields"`
	// The item's sections
	Sections []ItemSection `json:"sections"`
	// The notes of the item
	Notes string `json:"notes"`
	// The item's tags
	Tags []string `json:"tags"`
	// The websites used for autofilling for items of the Login and Password categories.
	Websites []Website `json:"websites"`
	// The item's version
	Version uint32 `json:"version"`
	// The item's file fields
	Files []ItemFile `json:"files"`
	// The document file for the Document item category
	Document *FileAttributes `json:"document,omitempty"`
	// The time the item was created at
	CreatedAt time.Time `json:"createdAt"`
	// The time the item was updated at
	UpdatedAt time.Time `json:"updatedAt"`
}
type ItemCreateParams struct {
	// The item's category
	Category ItemCategory `json:"category"`
	// The ID of the vault where the item is saved
	VaultID string `json:"vaultId"`
	// The item's title
	Title string `json:"title"`
	// The item's fields
	Fields []ItemField `json:"fields,omitempty"`
	// The item's sections
	Sections []ItemSection `json:"sections,omitempty"`
	// The item's notes
	Notes *string `json:"notes,omitempty"`
	// The item's tags
	Tags []string `json:"tags,omitempty"`
	// The websites used for autofilling for items of the Login and Password categories.
	Websites []Website `json:"websites,omitempty"`
	// The item's files stored as fields
	Files []FileCreateParams `json:"files,omitempty"`
	// The document file for the Document item type. Empty when the item isn't of Document type.
	Document *DocumentCreateParams `json:"document,omitempty"`
}

// Represents the state of an item in the SDK.
type ItemState string

const (
	// The item is active
	ItemStateActive ItemState = "active"
	// The item is archived meaning it's hidden from regular view and stored in the archive.
	ItemStateArchived ItemState = "archived"
)

// Represents a decrypted 1Password item overview.
type ItemOverview struct {
	// The item's ID
	ID string `json:"id"`
	// The item's title
	Title string `json:"title"`
	// The item's category
	Category ItemCategory `json:"category"`
	// The ID of the vault where the item is saved
	VaultID string `json:"vaultId"`
	// The websites used for autofilling for items of the Login and Password categories.
	Websites []Website `json:"websites"`
	// The item tags
	Tags []string `json:"tags"`
	// The time the item was created at
	CreatedAt time.Time `json:"createdAt"`
	// The time the item was updated at
	UpdatedAt time.Time `json:"updatedAt"`
	// Indicates the state of the item
	State ItemState `json:"state"`
}

// The valid duration options for sharing an item
type ItemShareDuration string

const (
	// The share will expire in one hour
	ItemShareDurationOneHour ItemShareDuration = "OneHour"
	// The share will expire in one day
	ItemShareDurationOneDay ItemShareDuration = "OneDay"
	// The share will expire in seven days
	ItemShareDurationSevenDays ItemShareDuration = "SevenDays"
	// The share will expire in fourteen days
	ItemShareDurationFourteenDays ItemShareDuration = "FourteenDays"
	// The share will expire in thirty days
	ItemShareDurationThirtyDays ItemShareDuration = "ThirtyDays"
)

// The allowed types of item sharing, enforced by account policy
type AllowedType string

const (
	// Allows creating share links with specific recipients
	AllowedTypeAuthenticated AllowedType = "Authenticated"
	// Allows creating public share links
	AllowedTypePublic AllowedType = "Public"
)

// The allowed recipient types of item sharing, enforced by account policy
type AllowedRecipientType string

const (
	// Recipients can be specified by email address
	AllowedRecipientTypeEmail AllowedRecipientType = "Email"
	// Recipients can be specified by domain
	AllowedRecipientTypeDomain AllowedRecipientType = "Domain"
)

// The file sharing policy
type ItemShareFiles struct {
	// Whether files can be included in item shares
	Allowed bool `json:"allowed"`
	// The maximum encrypted size (in bytes) an included file can be
	MaxSize uint32 `json:"maxSize"`
	// The allowed types of item sharing - either "Authenticated" (share to specific users) or "Public" (share to anyone with a link)
	AllowedTypes []AllowedType `json:"allowedTypes,omitempty"`
	// The allowed recipient types of item sharing - either "Email" or "Domain"
	AllowedRecipientTypes []AllowedRecipientType `json:"allowedRecipientTypes,omitempty"`
	// The maximum duration that an item can be shared for
	MaxExpiry *ItemShareDuration `json:"maxExpiry,omitempty"`
	// The default duration that an item is shared for
	DefaultExpiry *ItemShareDuration `json:"defaultExpiry,omitempty"`
	// The maximum number of times an item can be viewed. A null value means unlimited views
	MaxViews *uint32 `json:"maxViews,omitempty"`
}

// The account policy for sharing items, set by your account owner/admin
// This policy is enforced server-side when sharing items
type ItemShareAccountPolicy struct {
	// The maximum duration that an item can be shared for
	MaxExpiry ItemShareDuration `json:"maxExpiry"`
	// The default duration that an item is shared for
	DefaultExpiry ItemShareDuration `json:"defaultExpiry"`
	// The maximum number of times an item can be viewed. A null value means unlimited views
	MaxViews *uint32 `json:"maxViews,omitempty"`
	// The allowed types of item sharing - either "Authenticated" (share to specific users) or "Public" (share to anyone with a link)
	AllowedTypes []AllowedType `json:"allowedTypes"`
	// The allowed recipient types of item sharing - either "Email" or "Domain"
	AllowedRecipientTypes []AllowedRecipientType `json:"allowedRecipientTypes"`
	// The file sharing policy
	Files ItemShareFiles `json:"files"`
}

// Generated type representing the anonymous struct variant `Email` of the `ValidRecipient` Rust enum
type ValidRecipientEmailInner struct {
	Email string `json:"email"`
}

// Generated type representing the anonymous struct variant `Domain` of the `ValidRecipient` Rust enum
type ValidRecipientDomainInner struct {
	Domain string `json:"domain"`
}

// The validated recipient of an item share
type ValidRecipientTypes string

const (
	// This exact email address
	ValidRecipientTypeVariantEmail ValidRecipientTypes = "Email"
	// Anyone with an email address from the specified domain
	ValidRecipientTypeVariantDomain ValidRecipientTypes = "Domain"
)

type ValidRecipient struct {
	Type       ValidRecipientTypes `json:"type"`
	parameters interface{}
}

func (v *ValidRecipient) UnmarshalJSON(data []byte) error {
	var enum struct {
		Tag     ValidRecipientTypes `json:"type"`
		Content json.RawMessage     `json:"parameters"`
	}
	if err := json.Unmarshal(data, &enum); err != nil {
		return err
	}

	v.Type = enum.Tag
	switch v.Type {
	case ValidRecipientTypeVariantEmail:
		var res ValidRecipientEmailInner
		v.parameters = &res
	case ValidRecipientTypeVariantDomain:
		var res ValidRecipientDomainInner
		v.parameters = &res

	}
	if err := json.Unmarshal(enum.Content, &v.parameters); err != nil {
		return err
	}

	return nil
}

func (v ValidRecipient) MarshalJSON() ([]byte, error) {
	var enum struct {
		Tag     ValidRecipientTypes `json:"type"`
		Content interface{}         `json:"parameters,omitempty"`
	}
	enum.Tag = v.Type
	enum.Content = v.parameters
	return json.Marshal(enum)
}

func (v ValidRecipient) Email() *ValidRecipientEmailInner {
	res, _ := v.parameters.(*ValidRecipientEmailInner)
	return res
}
func (v ValidRecipient) Domain() *ValidRecipientDomainInner {
	res, _ := v.parameters.(*ValidRecipientDomainInner)
	return res
}

func NewValidRecipientTypeVariantEmail(content *ValidRecipientEmailInner) ValidRecipient {
	return ValidRecipient{
		Type:       ValidRecipientTypeVariantEmail,
		parameters: content,
	}
}
func NewValidRecipientTypeVariantDomain(content *ValidRecipientDomainInner) ValidRecipient {
	return ValidRecipient{
		Type:       ValidRecipientTypeVariantDomain,
		parameters: content,
	}
}

// The configuration options for sharing an item
// These must respect the account policy on item sharing
type ItemShareParams struct {
	// Emails or domains of the item share recipients. If not provided, everyone with the share link will have access
	Recipients []ValidRecipient `json:"recipients,omitempty"`
	// The duration of the share in seconds. If not provided, defaults to the account policy's default expiry
	ExpireAfter *ItemShareDuration `json:"expireAfter,omitempty"`
	// Whether the item can only be viewed once per recipient
	OneTimeOnly bool `json:"oneTimeOnly"`
}

// Additional attributes for OTP fields.
type OTPFieldDetails struct {
	// The OTP code, if successfully computed
	Code *string `json:"code,omitempty"`
	// The error message, if the OTP code could not be computed
	ErrorMessage *string `json:"errorMessage,omitempty"`
}
type Response[T any, E any] struct {
	Content *T `json:"content,omitempty"`
	Error   *E `json:"error,omitempty"`
}
type ResolvedReference struct {
	Secret  string `json:"secret"`
	ItemID  string `json:"itemId"`
	VaultID string `json:"vaultId"`
}
type ResolveReferenceErrorTypes string

const (
	// Error parsing the secret reference
	ResolveReferenceErrorTypeVariantParsing ResolveReferenceErrorTypes = "parsing"
	// The specified reference cannot be found within the item
	ResolveReferenceErrorTypeVariantFieldNotFound ResolveReferenceErrorTypes = "fieldNotFound"
	// No vault matched the secret reference query
	ResolveReferenceErrorTypeVariantVaultNotFound ResolveReferenceErrorTypes = "vaultNotFound"
	// More than one vault matched the secret reference query
	ResolveReferenceErrorTypeVariantTooManyVaults ResolveReferenceErrorTypes = "tooManyVaults"
	// No item matched the secret reference query
	ResolveReferenceErrorTypeVariantItemNotFound ResolveReferenceErrorTypes = "itemNotFound"
	// More than one item matched the secret reference query
	ResolveReferenceErrorTypeVariantTooManyItems ResolveReferenceErrorTypes = "tooManyItems"
	// More than one field matched the provided secret reference
	ResolveReferenceErrorTypeVariantTooManyMatchingFields ResolveReferenceErrorTypes = "tooManyMatchingFields"
	// No section found within the item for the provided identifier
	ResolveReferenceErrorTypeVariantNoMatchingSections ResolveReferenceErrorTypes = "noMatchingSections"
	// Incompatiable TOTP query parameters
	ResolveReferenceErrorTypeVariantIncompatibleTOTPQueryParameterField ResolveReferenceErrorTypes = "incompatibleTOTPQueryParameterField"
	// The totp was not able to be generated
	ResolveReferenceErrorTypeVariantUnableToGenerateTOTPCode ResolveReferenceErrorTypes = "unableToGenerateTotpCode"
	// Couldn't find attributes specific to an SSH Key field
	ResolveReferenceErrorTypeVariantSSHKeyMetadataNotFound ResolveReferenceErrorTypes = "sSHKeyMetadataNotFound"
	// Currently only support text files
	ResolveReferenceErrorTypeVariantUnsupportedFileFormat ResolveReferenceErrorTypes = "unsupportedFileFormat"
	// Trying to convert a non-private key to a private key format
	ResolveReferenceErrorTypeVariantIncompatibleSSHKeyQueryParameterField ResolveReferenceErrorTypes = "incompatibleSshKeyQueryParameterField"
	// Unable to properly parse a private key string to convert to an internal Private Key type
	ResolveReferenceErrorTypeVariantUnableToParsePrivateKey ResolveReferenceErrorTypes = "unableToParsePrivateKey"
	// Unable to format a private key to OpenSSH format
	ResolveReferenceErrorTypeVariantUnableToFormatPrivateKeyToOpenSSH ResolveReferenceErrorTypes = "unableToFormatPrivateKeyToOpenSsh"
	// Other type
	ResolveReferenceErrorTypeVariantOther ResolveReferenceErrorTypes = "other"
)

type ResolveReferenceError struct {
	Type    ResolveReferenceErrorTypes `json:"type"`
	message interface{}
}

func (r *ResolveReferenceError) UnmarshalJSON(data []byte) error {
	var enum struct {
		Tag     ResolveReferenceErrorTypes `json:"type"`
		Content json.RawMessage            `json:"message"`
	}
	if err := json.Unmarshal(data, &enum); err != nil {
		return err
	}

	r.Type = enum.Tag
	switch r.Type {
	case ResolveReferenceErrorTypeVariantParsing:
		var res ErrorMessage
		r.message = &res
	case ResolveReferenceErrorTypeVariantFieldNotFound:
		return nil
	case ResolveReferenceErrorTypeVariantVaultNotFound:
		return nil
	case ResolveReferenceErrorTypeVariantTooManyVaults:
		return nil
	case ResolveReferenceErrorTypeVariantItemNotFound:
		return nil
	case ResolveReferenceErrorTypeVariantTooManyItems:
		return nil
	case ResolveReferenceErrorTypeVariantTooManyMatchingFields:
		return nil
	case ResolveReferenceErrorTypeVariantNoMatchingSections:
		return nil
	case ResolveReferenceErrorTypeVariantIncompatibleTOTPQueryParameterField:
		return nil
	case ResolveReferenceErrorTypeVariantUnableToGenerateTOTPCode:
		var res ErrorMessage
		r.message = &res
	case ResolveReferenceErrorTypeVariantSSHKeyMetadataNotFound:
		return nil
	case ResolveReferenceErrorTypeVariantUnsupportedFileFormat:
		return nil
	case ResolveReferenceErrorTypeVariantIncompatibleSSHKeyQueryParameterField:
		return nil
	case ResolveReferenceErrorTypeVariantUnableToParsePrivateKey:
		return nil
	case ResolveReferenceErrorTypeVariantUnableToFormatPrivateKeyToOpenSSH:
		return nil
	case ResolveReferenceErrorTypeVariantOther:
		return nil

	}
	if err := json.Unmarshal(enum.Content, &r.message); err != nil {
		return err
	}

	return nil
}

func (r ResolveReferenceError) MarshalJSON() ([]byte, error) {
	var enum struct {
		Tag     ResolveReferenceErrorTypes `json:"type"`
		Content interface{}                `json:"message,omitempty"`
	}
	enum.Tag = r.Type
	enum.Content = r.message
	return json.Marshal(enum)
}

func (r ResolveReferenceError) Parsing() ErrorMessage {
	res, _ := r.message.(*ErrorMessage)
	return *res
}
func (r ResolveReferenceError) UnableToGenerateTOTPCode() ErrorMessage {
	res, _ := r.message.(*ErrorMessage)
	return *res
}

func NewResolveReferenceErrorTypeVariantParsing(content ErrorMessage) ResolveReferenceError {
	return ResolveReferenceError{
		Type:    ResolveReferenceErrorTypeVariantParsing,
		message: &content,
	}
}
func NewResolveReferenceErrorTypeVariantFieldNotFound() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantFieldNotFound,
	}
}
func NewResolveReferenceErrorTypeVariantVaultNotFound() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantVaultNotFound,
	}
}
func NewResolveReferenceErrorTypeVariantTooManyVaults() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantTooManyVaults,
	}
}
func NewResolveReferenceErrorTypeVariantItemNotFound() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantItemNotFound,
	}
}
func NewResolveReferenceErrorTypeVariantTooManyItems() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantTooManyItems,
	}
}
func NewResolveReferenceErrorTypeVariantTooManyMatchingFields() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantTooManyMatchingFields,
	}
}
func NewResolveReferenceErrorTypeVariantNoMatchingSections() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantNoMatchingSections,
	}
}
func NewResolveReferenceErrorTypeVariantIncompatibleTOTPQueryParameterField() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantIncompatibleTOTPQueryParameterField,
	}
}
func NewResolveReferenceErrorTypeVariantUnableToGenerateTOTPCode(content ErrorMessage) ResolveReferenceError {
	return ResolveReferenceError{
		Type:    ResolveReferenceErrorTypeVariantUnableToGenerateTOTPCode,
		message: &content,
	}
}
func NewResolveReferenceErrorTypeVariantSSHKeyMetadataNotFound() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantSSHKeyMetadataNotFound,
	}
}
func NewResolveReferenceErrorTypeVariantUnsupportedFileFormat() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantUnsupportedFileFormat,
	}
}
func NewResolveReferenceErrorTypeVariantIncompatibleSSHKeyQueryParameterField() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantIncompatibleSSHKeyQueryParameterField,
	}
}
func NewResolveReferenceErrorTypeVariantUnableToParsePrivateKey() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantUnableToParsePrivateKey,
	}
}
func NewResolveReferenceErrorTypeVariantUnableToFormatPrivateKeyToOpenSSH() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantUnableToFormatPrivateKeyToOpenSSH,
	}
}
func NewResolveReferenceErrorTypeVariantOther() ResolveReferenceError {
	return ResolveReferenceError{
		Type: ResolveReferenceErrorTypeVariantOther,
	}
}

type ResolveAllResponse struct {
	IndividualResponses map[string]Response[ResolvedReference, ResolveReferenceError] `json:"individualResponses"`
}
type SSHKeyAttributes struct {
	// The public part of the SSH Key
	PublicKey string `json:"publicKey"`
	// The fingerprint of the SSH Key
	Fingerprint string `json:"fingerprint"`
	// The key type ("Ed25519" or "RSA, {length}-bit")
	KeyType string `json:"keyType"`
}

// Represents a decrypted 1Password vault.
type VaultOverview struct {
	// The vault's ID
	ID string `json:"id"`
	// The vault's title
	Title string `json:"title"`
	// The time the vault was created at
	CreatedAt time.Time `json:"createdAt"`
	// The time the vault was updated at
	UpdatedAt time.Time `json:"updatedAt"`
}

// Generated type representing the anonymous struct variant `ByState` of the `ItemListFilter` Rust enum
type ItemListFilterByStateInner struct {
	Active   bool `json:"active"`
	Archived bool `json:"archived"`
}
type ItemListFilterTypes string

const (
	ItemListFilterTypeVariantByState ItemListFilterTypes = "ByState"
)

type ItemListFilter struct {
	Type    ItemListFilterTypes `json:"type"`
	content interface{}
}

func (i *ItemListFilter) UnmarshalJSON(data []byte) error {
	var enum struct {
		Tag     ItemListFilterTypes `json:"type"`
		Content json.RawMessage     `json:"content"`
	}
	if err := json.Unmarshal(data, &enum); err != nil {
		return err
	}

	i.Type = enum.Tag
	switch i.Type {
	case ItemListFilterTypeVariantByState:
		var res ItemListFilterByStateInner
		i.content = &res

	}
	if err := json.Unmarshal(enum.Content, &i.content); err != nil {
		return err
	}

	return nil
}

func (i ItemListFilter) MarshalJSON() ([]byte, error) {
	var enum struct {
		Tag     ItemListFilterTypes `json:"type"`
		Content interface{}         `json:"content,omitempty"`
	}
	enum.Tag = i.Type
	enum.Content = i.content
	return json.Marshal(enum)
}

func (i ItemListFilter) ByState() *ItemListFilterByStateInner {
	res, _ := i.content.(*ItemListFilterByStateInner)
	return res
}

func NewItemListFilterTypeVariantByState(content *ItemListFilterByStateInner) ItemListFilter {
	return ItemListFilter{
		Type:    ItemListFilterTypeVariantByState,
		content: content,
	}
}

// Generated type representing the anonymous struct variant `Memorable` of the `PasswordRecipe` Rust enum
type PasswordRecipeMemorableInner struct {
	// The type of separator between chunks.
	SeparatorType SeparatorType `json:"separatorType"`
	// Uppercase one randomly selected chunk.
	Capitalize bool `json:"capitalize"`
	// The type of word list used.
	WordListType WordListType `json:"wordListType"`
	// The number of "words" (words or syllables).
	WordCount uint32 `json:"wordCount"`
}

// Generated type representing the anonymous struct variant `Pin` of the `PasswordRecipe` Rust enum
type PasswordRecipePinInner struct {
	// Number of digits in the PIN.
	Length uint32 `json:"length"`
}

// Generated type representing the anonymous struct variant `Random` of the `PasswordRecipe` Rust enum
type PasswordRecipeRandomInner struct {
	// Include at least one digit in the password.
	IncludeDigits bool `json:"includeDigits"`
	// Include at least one symbol in the password.
	IncludeSymbols bool `json:"includeSymbols"`
	// The length of the password.
	Length uint32 `json:"length"`
}
type PasswordRecipeTypes string

const (
	PasswordRecipeTypeVariantMemorable PasswordRecipeTypes = "Memorable"
	PasswordRecipeTypeVariantPin       PasswordRecipeTypes = "Pin"
	PasswordRecipeTypeVariantRandom    PasswordRecipeTypes = "Random"
)

type PasswordRecipe struct {
	Type       PasswordRecipeTypes `json:"type"`
	parameters interface{}
}

func (p *PasswordRecipe) UnmarshalJSON(data []byte) error {
	var enum struct {
		Tag     PasswordRecipeTypes `json:"type"`
		Content json.RawMessage     `json:"parameters"`
	}
	if err := json.Unmarshal(data, &enum); err != nil {
		return err
	}

	p.Type = enum.Tag
	switch p.Type {
	case PasswordRecipeTypeVariantMemorable:
		var res PasswordRecipeMemorableInner
		p.parameters = &res
	case PasswordRecipeTypeVariantPin:
		var res PasswordRecipePinInner
		p.parameters = &res
	case PasswordRecipeTypeVariantRandom:
		var res PasswordRecipeRandomInner
		p.parameters = &res

	}
	if err := json.Unmarshal(enum.Content, &p.parameters); err != nil {
		return err
	}

	return nil
}

func (p PasswordRecipe) MarshalJSON() ([]byte, error) {
	var enum struct {
		Tag     PasswordRecipeTypes `json:"type"`
		Content interface{}         `json:"parameters,omitempty"`
	}
	enum.Tag = p.Type
	enum.Content = p.parameters
	return json.Marshal(enum)
}

func (p PasswordRecipe) Memorable() *PasswordRecipeMemorableInner {
	res, _ := p.parameters.(*PasswordRecipeMemorableInner)
	return res
}
func (p PasswordRecipe) Pin() *PasswordRecipePinInner {
	res, _ := p.parameters.(*PasswordRecipePinInner)
	return res
}
func (p PasswordRecipe) Random() *PasswordRecipeRandomInner {
	res, _ := p.parameters.(*PasswordRecipeRandomInner)
	return res
}

func NewPasswordRecipeTypeVariantMemorable(content *PasswordRecipeMemorableInner) PasswordRecipe {
	return PasswordRecipe{
		Type:       PasswordRecipeTypeVariantMemorable,
		parameters: content,
	}
}
func NewPasswordRecipeTypeVariantPin(content *PasswordRecipePinInner) PasswordRecipe {
	return PasswordRecipe{
		Type:       PasswordRecipeTypeVariantPin,
		parameters: content,
	}
}
func NewPasswordRecipeTypeVariantRandom(content *PasswordRecipeRandomInner) PasswordRecipe {
	return PasswordRecipe{
		Type:       PasswordRecipeTypeVariantRandom,
		parameters: content,
	}
}

type SeparatorType string

const (
	// Randomly selected digits.
	// E.g, "`correct4horse0battery1staple`"
	SeparatorTypeDigits SeparatorType = "digits"
	// Randomly selected digits and symbols.
	// This is useful to get word-based passwords to meet complexity requirements
	// E.g, "`correct4horse-battery1staple`"
	SeparatorTypeDigitsAndSymbols SeparatorType = "digitsAndSymbols"
	// Spaces, like the original Diceware.
	// Great for mobile keyboards, not so great when people can overhear you type the password.
	// E.g, "`correct horse battery staple`"
	SeparatorTypeSpaces SeparatorType = "spaces"
	// Hyphens "`-`".
	// E.g, "`correct-horse-battery-staple`"
	SeparatorTypeHyphens SeparatorType = "hyphens"
	// "`_`".
	// E.g, "`correct_horse_battery_staple`"
	SeparatorTypeUnderscores SeparatorType = "underscores"
	// Period (full stop) "`.`".
	// E.g, "`correct.horse.battery.staple`"
	SeparatorTypePeriods SeparatorType = "periods"
	// Comma "`,`".
	// E.g, "`correct,horse,battery,staple`"
	SeparatorTypeCommas SeparatorType = "commas"
)

type WordListType string

const (
	// Agile wordlist
	WordListTypeFullWords WordListType = "fullWords"
	// English-like syllables
	WordListTypeSyllables WordListType = "syllables"
	// Three (random) letter "words"
	WordListTypeThreeLetters WordListType = "threeLetters"
)
