// This file was generated by qtwaylandscanner
// source file is //usr/share/wayland-protocols/unstable/xdg-foreign/xdg-foreign-unstable-v2.xml

#ifndef QT_WAYLAND_SERVER_XDG_FOREIGN_UNSTABLE_V2
#define QT_WAYLAND_SERVER_XDG_FOREIGN_UNSTABLE_V2

#include "wayland-server-core.h"
#include "wayland-xdg-foreign-unstable-v2-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  zxdg_exporter_v2
    {
    public:
        zxdg_exporter_v2(struct ::wl_client *client, int id, int version);
        zxdg_exporter_v2(struct ::wl_display *display, int version);
        zxdg_exporter_v2(struct ::wl_resource *resource);
        zxdg_exporter_v2();

        virtual ~zxdg_exporter_v2();

        class Resource
        {
        public:
            Resource() : zxdg_exporter_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            zxdg_exporter_v2 *zxdg_exporter_v2_object;
            zxdg_exporter_v2 *object() { return zxdg_exporter_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_invalid_surface = 0, // surface is not an xdg_toplevel
        };

    protected:
        virtual Resource *zxdg_exporter_v2_allocate();

        virtual void zxdg_exporter_v2_destroy_global();

        virtual void zxdg_exporter_v2_bind_resource(Resource *resource);
        virtual void zxdg_exporter_v2_destroy_resource(Resource *resource);

        virtual void zxdg_exporter_v2_destroy(Resource *resource);
        virtual void zxdg_exporter_v2_export_toplevel(Resource *resource, uint32_t id, struct ::wl_resource *surface);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::zxdg_exporter_v2_interface m_zxdg_exporter_v2_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_export_toplevel(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *surface);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            zxdg_exporter_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  zxdg_importer_v2
    {
    public:
        zxdg_importer_v2(struct ::wl_client *client, int id, int version);
        zxdg_importer_v2(struct ::wl_display *display, int version);
        zxdg_importer_v2(struct ::wl_resource *resource);
        zxdg_importer_v2();

        virtual ~zxdg_importer_v2();

        class Resource
        {
        public:
            Resource() : zxdg_importer_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            zxdg_importer_v2 *zxdg_importer_v2_object;
            zxdg_importer_v2 *object() { return zxdg_importer_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


    protected:
        virtual Resource *zxdg_importer_v2_allocate();

        virtual void zxdg_importer_v2_destroy_global();

        virtual void zxdg_importer_v2_bind_resource(Resource *resource);
        virtual void zxdg_importer_v2_destroy_resource(Resource *resource);

        virtual void zxdg_importer_v2_destroy(Resource *resource);
        virtual void zxdg_importer_v2_import_toplevel(Resource *resource, uint32_t id, const QString &handle);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::zxdg_importer_v2_interface m_zxdg_importer_v2_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_import_toplevel(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            const char *handle);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            zxdg_importer_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  zxdg_exported_v2
    {
    public:
        zxdg_exported_v2(struct ::wl_client *client, int id, int version);
        zxdg_exported_v2(struct ::wl_display *display, int version);
        zxdg_exported_v2(struct ::wl_resource *resource);
        zxdg_exported_v2();

        virtual ~zxdg_exported_v2();

        class Resource
        {
        public:
            Resource() : zxdg_exported_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            zxdg_exported_v2 *zxdg_exported_v2_object;
            zxdg_exported_v2 *object() { return zxdg_exported_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_handle(const QString &handle);
        void send_handle(struct ::wl_resource *resource, const QString &handle);

    protected:
        virtual Resource *zxdg_exported_v2_allocate();

        virtual void zxdg_exported_v2_destroy_global();

        virtual void zxdg_exported_v2_bind_resource(Resource *resource);
        virtual void zxdg_exported_v2_destroy_resource(Resource *resource);

        virtual void zxdg_exported_v2_destroy(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::zxdg_exported_v2_interface m_zxdg_exported_v2_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            zxdg_exported_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  zxdg_imported_v2
    {
    public:
        zxdg_imported_v2(struct ::wl_client *client, int id, int version);
        zxdg_imported_v2(struct ::wl_display *display, int version);
        zxdg_imported_v2(struct ::wl_resource *resource);
        zxdg_imported_v2();

        virtual ~zxdg_imported_v2();

        class Resource
        {
        public:
            Resource() : zxdg_imported_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            zxdg_imported_v2 *zxdg_imported_v2_object;
            zxdg_imported_v2 *object() { return zxdg_imported_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_invalid_surface = 0, // surface is not an xdg_toplevel
        };

        void send_destroyed();
        void send_destroyed(struct ::wl_resource *resource);

    protected:
        virtual Resource *zxdg_imported_v2_allocate();

        virtual void zxdg_imported_v2_destroy_global();

        virtual void zxdg_imported_v2_bind_resource(Resource *resource);
        virtual void zxdg_imported_v2_destroy_resource(Resource *resource);

        virtual void zxdg_imported_v2_destroy(Resource *resource);
        virtual void zxdg_imported_v2_set_parent_of(Resource *resource, struct ::wl_resource *surface);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::zxdg_imported_v2_interface m_zxdg_imported_v2_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_parent_of(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *surface);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            zxdg_imported_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
