#line 1 "/build/doxygen/src/build/generated_src/configimpl_intermediate.cpp"
#include <stdint.h>

#line 4 "/build/doxygen/src/build/generated_src/configimpl_intermediate.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer configimplYY_create_buffer
#define yy_delete_buffer configimplYY_delete_buffer
#define yy_scan_buffer configimplYY_scan_buffer
#define yy_scan_string configimplYY_scan_string
#define yy_scan_bytes configimplYY_scan_bytes
#define yy_init_buffer configimplYY_init_buffer
#define yy_flush_buffer configimplYY_flush_buffer
#define yy_load_buffer_state configimplYY_load_buffer_state
#define yy_switch_to_buffer configimplYY_switch_to_buffer
#define yypush_buffer_state configimplYYpush_buffer_state
#define yypop_buffer_state configimplYYpop_buffer_state
#define yyensure_buffer_stack configimplYYensure_buffer_stack
#define yy_flex_debug configimplYY_flex_debug
#define yyin configimplYYin
#define yyleng configimplYYleng
#define yylex configimplYYlex
#define yylineno configimplYYlineno
#define yyout configimplYYout
#define yyrestart configimplYYrestart
#define yytext configimplYYtext
#define yywrap configimplYYwrap
#define yyalloc configimplYYalloc
#define yyrealloc configimplYYrealloc
#define yyfree configimplYYfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define configimplYY_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer configimplYY_create_buffer
#endif

#ifdef yy_delete_buffer
#define configimplYY_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer configimplYY_delete_buffer
#endif

#ifdef yy_scan_buffer
#define configimplYY_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer configimplYY_scan_buffer
#endif

#ifdef yy_scan_string
#define configimplYY_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string configimplYY_scan_string
#endif

#ifdef yy_scan_bytes
#define configimplYY_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes configimplYY_scan_bytes
#endif

#ifdef yy_init_buffer
#define configimplYY_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer configimplYY_init_buffer
#endif

#ifdef yy_flush_buffer
#define configimplYY_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer configimplYY_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define configimplYY_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state configimplYY_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define configimplYY_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer configimplYY_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define configimplYYpush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state configimplYYpush_buffer_state
#endif

#ifdef yypop_buffer_state
#define configimplYYpop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state configimplYYpop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define configimplYYensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack configimplYYensure_buffer_stack
#endif

#ifdef yylex
#define configimplYYlex_ALREADY_DEFINED
#else
#define yylex configimplYYlex
#endif

#ifdef yyrestart
#define configimplYYrestart_ALREADY_DEFINED
#else
#define yyrestart configimplYYrestart
#endif

#ifdef yylex_init
#define configimplYYlex_init_ALREADY_DEFINED
#else
#define yylex_init configimplYYlex_init
#endif

#ifdef yylex_init_extra
#define configimplYYlex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra configimplYYlex_init_extra
#endif

#ifdef yylex_destroy
#define configimplYYlex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy configimplYYlex_destroy
#endif

#ifdef yyget_debug
#define configimplYYget_debug_ALREADY_DEFINED
#else
#define yyget_debug configimplYYget_debug
#endif

#ifdef yyset_debug
#define configimplYYset_debug_ALREADY_DEFINED
#else
#define yyset_debug configimplYYset_debug
#endif

#ifdef yyget_extra
#define configimplYYget_extra_ALREADY_DEFINED
#else
#define yyget_extra configimplYYget_extra
#endif

#ifdef yyset_extra
#define configimplYYset_extra_ALREADY_DEFINED
#else
#define yyset_extra configimplYYset_extra
#endif

#ifdef yyget_in
#define configimplYYget_in_ALREADY_DEFINED
#else
#define yyget_in configimplYYget_in
#endif

#ifdef yyset_in
#define configimplYYset_in_ALREADY_DEFINED
#else
#define yyset_in configimplYYset_in
#endif

#ifdef yyget_out
#define configimplYYget_out_ALREADY_DEFINED
#else
#define yyget_out configimplYYget_out
#endif

#ifdef yyset_out
#define configimplYYset_out_ALREADY_DEFINED
#else
#define yyset_out configimplYYset_out
#endif

#ifdef yyget_leng
#define configimplYYget_leng_ALREADY_DEFINED
#else
#define yyget_leng configimplYYget_leng
#endif

#ifdef yyget_text
#define configimplYYget_text_ALREADY_DEFINED
#else
#define yyget_text configimplYYget_text
#endif

#ifdef yyget_lineno
#define configimplYYget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno configimplYYget_lineno
#endif

#ifdef yyset_lineno
#define configimplYYset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno configimplYYset_lineno
#endif

#ifdef yywrap
#define configimplYYwrap_ALREADY_DEFINED
#else
#define yywrap configimplYYwrap
#endif

#ifdef yyalloc
#define configimplYYalloc_ALREADY_DEFINED
#else
#define yyalloc configimplYYalloc
#endif

#ifdef yyrealloc
#define configimplYYrealloc_ALREADY_DEFINED
#else
#define yyrealloc configimplYYrealloc
#endif

#ifdef yyfree
#define configimplYYfree_ALREADY_DEFINED
#else
#define yyfree configimplYYfree
#endif

#ifdef yytext
#define configimplYYtext_ALREADY_DEFINED
#else
#define yytext configimplYYtext
#endif

#ifdef yyleng
#define configimplYYleng_ALREADY_DEFINED
#else
#define yyleng configimplYYleng
#endif

#ifdef yyin
#define configimplYYin_ALREADY_DEFINED
#else
#define yyin configimplYYin
#endif

#ifdef yyout
#define configimplYYout_ALREADY_DEFINED
#else
#define yyout configimplYYout
#endif

#ifdef yy_flex_debug
#define configimplYY_flex_debug_ALREADY_DEFINED
#else
#define yy_flex_debug configimplYY_flex_debug
#endif

#ifdef yylineno
#define configimplYYlineno_ALREADY_DEFINED
#else
#define yylineno configimplYYlineno
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define configimplYYwrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 33
#define YY_END_OF_BUFFER 34
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[125] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   34,   32,   30,   31,   32,   32,
       32,   32,   12,   32,   12,   28,   28,   25,   27,   28,
       20,   20,   17,   19,   20,   24,   24,   21,   23,   24,
       11,   32,   11,   11,   16,   16,   13,   15,   16,    0,
       29,    0,    0,    3,    0,    0,   12,    0,    0,    0,
        0,   12,    4,   28,    0,   26,   28,   20,    0,   18,
       20,   24,    0,   22,   24,   11,    0,   11,   16,    0,
       14,   16,    0,    0,    2,    0,    0,   10,    0,    5,
       28,   20,   24,   11,   11,   16,    1,    0,    8,    0,

        0,    1,    1,    1,    1,    1,    0,    0,    0,    0,
        0,    9,    0,    0,    0,    7,    0,    0,    0,    0,
        0,    0,    6,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    6,    7,    1,    1,    1,    8,
        9,    1,   10,    1,   11,   11,    1,   12,   13,   13,
       13,   13,   13,   13,   13,   13,   13,    1,    1,    1,
       14,    1,    1,   15,   16,   17,   18,   19,   20,   17,
       17,   21,   22,   17,   17,   23,   17,   24,   17,   25,
       17,   17,   17,   26,   27,   17,   17,   17,   17,   17,
        1,   28,    1,    1,   29,    1,   17,   17,   17,   30,

       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   31,
       17,   17,    1,    1,    1,    1,    1,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,

       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32
    } ;

static const YY_CHAR yy_meta[34] =
    {   0,
        1,    2,    3,    4,    5,    1,    1,    6,    7,    8,
        7,    9,    9,    8,   10,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   12,   11,   11,
       11,   13,    1
    } ;

static const flex_int16_t yy_base[147] =
    {   0,
        0,   32,   65,    0,   97,  129,  161,  193,  225,  257,
      289,  321,  353,  385,  167,  643,  643,  643,    3,  135,
        5,  153,    0,  138,    7,    0,    0,  643,   10,  128,
        0,    0,  643,   16,  127,    0,    0,  643,   20,  125,
        0,    0,   23,  124,    0,    0,  643,   27,  123,   35,
      643,  141,  149,  643,  148,    0,    0,  135,   17,   38,
      135,   40,  643,    0,   41,  643,  136,    0,   53,  643,
      135,    0,   59,  643,  134,    0,  140,  132,    0,  100,
      643,  131,  112,  138,  643,    7,  125,  643,   31,  643,
      109,  108,  107,  643,  104,   97,  643,    0,  643,   50,

       90,    0,    0,    0,    0,    0,  117,   91,  114,    1,
       32,  643,   92,  106,  108,  643,   94,   99,   38,   96,
      114,  122,  643,  643,  418,  431,  444,  457,  470,  483,
      496,  501,  502,  514,  525,  538,  551,  564,  577,  590,
      603,  606,  611,  619,  622,  629
    } ;

static const flex_int16_t yy_def[147] =
    {   0,
      125,  125,  124,    3,  126,  126,  127,  127,  128,  128,
      129,  129,  130,  130,  124,  124,  124,  124,  124,  124,
      131,  124,  132,  133,  134,  135,  135,  124,  124,  135,
      136,  136,  124,  124,  136,  137,  137,  124,  124,  137,
      138,  139,  138,  138,  140,  140,  124,  124,  140,  124,
      124,  124,  131,  124,  141,  142,  132,  143,  143,  124,
      124,  134,  124,  135,  124,  124,  135,  136,  124,  124,
      136,  137,  124,  124,  137,  138,  139,  138,  140,  124,
      124,  140,  124,  141,  124,  144,  143,  124,  143,  124,
      135,  136,  137,  124,  138,  140,  124,  145,  124,  144,

      143,  135,  136,  137,  138,  140,  146,  143,  124,  146,
      143,  124,  143,  143,  124,  124,  143,  143,  143,  143,
      143,  124,  124,    0,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124
    } ;

static const flex_int16_t yy_nxt[677] =
    {   0,
      124,   17,   18,   17,   50,   51,   50,   54,   60,  109,
       55,   65,   66,   65,   98,   99,   61,   69,   70,   69,
       63,   73,   74,   73,   50,   51,   50,   19,   80,   81,
       80,   88,   20,   17,   18,   17,   50,   51,   50,   60,
       89,   60,   65,   66,   65,   88,   88,   61,  101,   61,
      113,   63,   88,   63,   69,   70,   69,   98,   99,   19,
       73,   74,   73,  120,   20,   16,   17,   18,   17,   16,
       21,   22,   16,   16,   16,   16,   23,   23,   16,   24,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   19,   25,   25,   25,   16,   20,   27,   28,

       27,   80,   81,   80,   88,   88,   88,  115,   88,  115,
       88,  114,  108,   88,  119,  122,  121,  111,  118,  116,
       88,  116,  112,  122,   29,  109,  106,  123,   88,   30,
       27,   28,   27,  105,  117,  123,  104,  103,  102,   88,
       85,   97,   96,   95,   94,   93,   92,   91,   90,   88,
       85,   54,   83,   82,   78,   75,   29,   71,   67,   59,
       56,   30,   32,   33,   32,   52,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,   34,  124,
      124,  124,  124,   35,   32,   33,   32,  124,  124,  124,

      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
       34,  124,  124,  124,  124,   35,   37,   38,   37,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,   39,  124,  124,  124,  124,   40,   37,   38,
       37,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,   39,  124,  124,  124,  124,   40,
       17,   18,   17,   42,  124,  124,  124,  124,  124,  124,

      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,   43,  124,  124,  124,
      124,   44,   17,   18,   17,   42,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,   43,  124,
      124,  124,  124,   44,   46,   47,   46,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
       48,  124,  124,  124,  124,   49,   46,   47,   46,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,

      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,   48,  124,  124,  124,  124,   49,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   31,   31,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   36,   36,   36,
       36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   45,   45,   45,   45,   45,   45,   45,
       45,   45,   45,   45,   45,   45,   53,   53,   53,   53,

       53,   53,   53,   53,   53,   53,   53,   53,   53,   57,
      124,   57,   58,  124,   58,   62,  124,  124,  124,  124,
      124,   62,   62,  124,   62,   64,   64,  124,   64,   64,
       64,   64,   64,   64,   64,   64,  124,   64,   68,   68,
      124,   68,   68,   68,   68,   68,   68,   68,   68,  124,
       68,   72,   72,  124,   72,   72,   72,   72,   72,   72,
       72,   72,  124,   72,   76,  124,  124,  124,  124,   76,
       76,   76,   76,   76,   76,   76,   76,   77,   77,  124,
       77,  124,   77,   77,   77,   77,   77,   77,   77,   77,
       79,   79,  124,   79,   79,   79,   79,   79,   79,   79,

       79,  124,   79,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   86,  124,   86,   87,
       87,   87,  124,   87,  100,  100,  124,  100,  124,  100,
      124,  100,  107,  124,  107,  110,  124,  110,  124,  110,
      124,  110,   15,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124
    } ;

static const flex_int16_t yy_chk[677] =
    {   0,
        0,    1,    1,    1,   19,   19,   19,   21,   25,  110,
       21,   29,   29,   29,   86,   86,   25,   34,   34,   34,
       25,   39,   39,   39,   43,   43,   43,    1,   48,   48,
       48,   59,    1,    2,    2,    2,   50,   50,   50,   60,
       59,   62,   65,   65,   65,   89,  111,   60,   89,   62,
      111,   60,  119,   62,   69,   69,   69,  100,  100,    2,
       73,   73,   73,  119,    2,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    5,    5,

        5,   80,   80,   80,  101,  108,  113,  114,  117,  115,
      120,  113,  101,  118,  118,  121,  120,  108,  117,  114,
      114,  115,  109,  122,    5,  107,   96,  121,  121,    5,
        6,    6,    6,   95,  114,  122,   93,   92,   91,   87,
       84,   83,   82,   78,   77,   75,   71,   67,   61,   58,
       55,   53,   52,   49,   44,   40,    6,   35,   30,   24,
       22,    6,    7,    7,    7,   20,   15,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    7,    0,
        0,    0,    0,    7,    8,    8,    8,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        8,    0,    0,    0,    0,    8,    9,    9,    9,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    9,    0,    0,    0,    0,    9,   10,   10,
       10,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   10,    0,    0,    0,    0,   10,
       11,   11,   11,   11,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   11,    0,    0,    0,
        0,   11,   12,   12,   12,   12,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   12,    0,
        0,    0,    0,   12,   13,   13,   13,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       13,    0,    0,    0,    0,   13,   14,   14,   14,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   14,    0,    0,    0,    0,   14,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  126,  126,  126,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  127,  127,  127,  127,  127,  127,
      127,  127,  127,  127,  127,  127,  127,  128,  128,  128,
      128,  128,  128,  128,  128,  128,  128,  128,  128,  128,
      129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  129,  129,  130,  130,  130,  130,  130,  130,  130,
      130,  130,  130,  130,  130,  130,  131,  131,  131,  131,

      131,  131,  131,  131,  131,  131,  131,  131,  131,  132,
        0,  132,  133,    0,  133,  134,    0,    0,    0,    0,
        0,  134,  134,    0,  134,  135,  135,    0,  135,  135,
      135,  135,  135,  135,  135,  135,    0,  135,  136,  136,
        0,  136,  136,  136,  136,  136,  136,  136,  136,    0,
      136,  137,  137,    0,  137,  137,  137,  137,  137,  137,
      137,  137,    0,  137,  138,    0,    0,    0,    0,  138,
      138,  138,  138,  138,  138,  138,  138,  139,  139,    0,
      139,    0,  139,  139,  139,  139,  139,  139,  139,  139,
      140,  140,    0,  140,  140,  140,  140,  140,  140,  140,

      140,    0,  140,  141,  141,  141,  141,  141,  141,  141,
      141,  141,  141,  141,  141,  141,  142,    0,  142,  143,
      143,  143,    0,  143,  144,  144,    0,  144,    0,  144,
        0,  144,  145,    0,  145,  146,    0,  146,    0,  146,
        0,  146,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "/build/doxygen/src/build/generated_src/configimpl.l"
/******************************************************************************
 *
 * Copyright (C) 1997-2020 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby
 * granted. No representations are made about the suitability of this software
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 */

#line 19 "/build/doxygen/src/build/generated_src/configimpl.l"

/*
 *      includes
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <ctype.h>
#include <stdarg.h>
#include <errno.h>
#include <thread>
#include <algorithm>
#include <iostream>
#include <iomanip>
#include <cstdint>

#include "config.h"
#include "regex.h"
#include "configimpl.h"
#include "version.h"
#include "portable.h"
#include "language.h"
#include "configoptions.h"
#include "fileinfo.h"
#include "dir.h"
#include "textstream.h"
#include "dotattributes.h"
#include "debug.h"

#define YY_NO_INPUT 1
#define YY_NO_UNISTD_H 1

// For debugging
#define SHOW_INCLUDES 0

[[maybe_unused]] static const char *stateToString(int state);

static const char *warning_str = "warning: ";
static const char *error_str = "error: ";

void ConfigImpl::config_err_(fmt::string_view fmt, fmt::format_args args)
{
  fmt::print(stderr,"{}{}",error_str,fmt::vformat(fmt,args));
}

void ConfigImpl::config_term_(fmt::string_view fmt, fmt::format_args args)
{
  fmt::print(stderr,"{}{}",error_str,fmt::vformat(fmt,args));
  fmt::print(stderr,"{}\n", "Exiting...");
  exit(1);
}

void ConfigImpl::config_warn_(fmt::string_view fmt, fmt::format_args args)
{
  fmt::print(stderr,"{}{}",warning_str,fmt::vformat(fmt,args));
}

static QCString configStringRecode(
    const QCString &str,
    const QCString &fromEncoding,
    const QCString &toEncoding);

static bool containsEnvVar(QCString &str);

#define MAX_INCLUDE_DEPTH 10
#define YY_NEVER_INTERACTIVE 1

/* -----------------------------------------------------------------
 */
static QCString convertToComment(const QCString &s, const QCString &u)
{
  //printf("convertToComment(%s)=%s\n",qPrint(s),qPrint(u));
  QCString result;
  if (!s.isEmpty())
  {
    QCString tmp=s.stripWhiteSpace();
    const char *p=tmp.data();
    char c = 0;
    if (p)
    {
      result+="#";
      if (*p && *p!='\n')
      {
        result+=" ";
      }
      while ((c=*p++))
      {
        if (c=='\n')
        {
          result+="\n#";
          if (*p && *p!='\n')
          {
            result+=" ";
          }
        }
        else result+=c;
      }
      result+='\n';
    }
  }
  if (!u.isEmpty())
  {
    if (!result.isEmpty()) result+='\n';
    result+= u;
  }
  return result;
}

void ConfigOption::writeBoolValue(TextStream &t,bool v,bool initSpace)
{
  if (initSpace) t << " ";
  if (v) t << "YES"; else t << "NO";
}

void ConfigOption::writeIntValue(TextStream &t,int i,bool initSpace)
{
  if (initSpace) t << " ";
  t << i;
}

void ConfigOption::writeStringValue(TextStream &t,const QCString &s,bool initSpace, bool wasQuoted)
{
  char c = 0;
  bool needsEscaping=wasQuoted;
  // convert the string back to it original g_encoding
  QCString se = configStringRecode(s,"UTF-8",m_encoding);
  if (se.isEmpty()) return;
  const char *p=se.data();
  if (p)
  {
    if (initSpace) t << " ";
    while ((c=*p++)!=0 && !needsEscaping)
      needsEscaping = (c==' ' || c== ',' || c=='\n' || c=='\t' || c=='"' || c=='#');
    if (needsEscaping)
    {
      t << "\"";
      p=se.data();
      while (*p)
      {
        if (*p==' ' && *(p+1)=='\0') break; // skip inserted space at the end
        if (*p=='"') t << "\\"; // escape quotes
        t << *p++;
      }
      t << "\"";
    }
    else
    {
      t << se;
    }
  }
}

void ConfigOption::writeStringList(TextStream &t,const StringVector &l)
{
  bool first=TRUE;
  for (const auto &p : l)
  {
    if (!first) t << " \\\n";
    QCString s=p.c_str();
    if (!first)
      t << "                        ";
    bool wasQuoted = ((s.at(0)=='"') && (s.at(s.length()-1)=='"'));
    if (wasQuoted)
    {
      s = s.mid(1,s.length()-2);
    }
    writeStringValue(t,s,true,wasQuoted);
    first=FALSE;
  }
}

/* -----------------------------------------------------------------
 */

std::unique_ptr<ConfigImpl> ConfigImpl::m_instance;

void ConfigInt::convertStrToVal(Config::CompareMode compareMode)
{
  if (!m_valueString.isEmpty())
  {
    if (compareMode == Config::CompareMode::CompressedNoEnv)
    {
       if (containsEnvVar(m_valueString)) return;
    }
    bool ok = false;
    int val = m_valueString.toInt(&ok);
    if (!ok || val<m_minVal || val>m_maxVal)
    {
      ConfigImpl::config_warn("argument '{}' for option {} is not a valid number in the range [{}..{}]!\n"
                "Using the default: {}!\n",m_valueString,m_name,m_minVal,m_maxVal,m_value);
    }
    else
    {
      m_value=val;
    }
  }
}

static bool convertStringToBool(const QCString &str,bool &isValid)
{
  isValid=false;
  QCString val = str.stripWhiteSpace().lower();
  if (!val.isEmpty())
  {
    if (val=="yes" || val=="true" || val=="1" || val=="all")
    {
      isValid=true;
      return true;
    }
    else if (val=="no" || val=="false" || val=="0" || val=="none")
    {
      isValid=true;
      return false;
    }
  }
  return false;
}

void ConfigBool::convertStrToVal(Config::CompareMode compareMode)
{
  if (!m_valueString.stripWhiteSpace().isEmpty())
  {
    if (compareMode == Config::CompareMode::CompressedNoEnv)
    {
       if (containsEnvVar(m_valueString)) return;
    }
    bool isValid=false;
    bool b = convertStringToBool(m_valueString,isValid);
    if (isValid)
    {
      m_value=b;
    }
    else
    {
      ConfigImpl::config_warn("argument '{}' for option {} is not a valid boolean value\n"
          "Using the default: {}!\n",m_valueString,m_name,m_value?"YES":"NO");
    }
  }
}

void ConfigEnum::convertStrToVal(Config::CompareMode compareMode)
{
  if (m_value.isEmpty())
  {
    m_value = m_defValue;
    return;
  }
  if (compareMode == Config::CompareMode::CompressedNoEnv)
  {
     if (containsEnvVar(m_value)) return;
  }
  QCString val = m_value.stripWhiteSpace().lower();
  for (const auto &s : m_valueRange)
  {
    if (s.lower() == val)
    {
       m_value = s;
       return;
    }
  }

  ConfigImpl::config_warn("argument '{}' for option {} is not a valid enum value\n"
              "Using the default: {}!\n",m_value,m_name,m_defValue);
  m_value = m_defValue;
}

QCString &ConfigImpl::getString(const char *fileName,int num,const char *name) const
{
  auto it = m_dict.find(name);
  if (it==m_dict.end())
  {
    config_term("{}<{}>: Internal error: Requested unknown option {}!\n",fileName,num,name);
  }
  else if (it->second->kind()!=ConfigOption::O_String)
  {
    config_term("{}<{}>: Internal error: Requested option {} not of string type!\n",fileName,num,name);
  }
  return *(dynamic_cast<ConfigString *>(it->second))->valueRef();
}

StringVector &ConfigImpl::getList(const char *fileName,int num,const char *name) const
{
  auto it = m_dict.find(name);
  if (it==m_dict.end())
  {
    config_term("{}<{}>: Internal error: Requested unknown option {}!\n",fileName,num,name);
  }
  else if (it->second->kind()!=ConfigOption::O_List)
  {
    config_term("{}<{}>: Internal error: Requested option {} not of list type!\n",fileName,num,name);
  }
  return *(dynamic_cast<ConfigList *>(it->second))->valueRef();
}

QCString &ConfigImpl::getEnum(const char *fileName,int num,const char *name) const
{
  auto it = m_dict.find(name);
  if (it==m_dict.end())
  {
    config_term("{}<{}>: Internal error: Requested unknown option {}!\n",fileName,num,name);
  }
  else if (it->second->kind()!=ConfigOption::O_Enum)
  {
    config_term("{}<{}>: Internal error: Requested option {} not of enum type!\n",fileName,num,name);
  }
  return *(dynamic_cast<ConfigEnum *>(it->second))->valueRef();
}

int &ConfigImpl::getInt(const char *fileName,int num,const char *name) const
{
  auto it = m_dict.find(name);
  if (it==m_dict.end())
  {
    config_term("{}<{}>: Internal error: Requested unknown option {}!\n",fileName,num,name);
  }
  else if (it->second->kind()!=ConfigOption::O_Int)
  {
    config_term("{}<{}>: Internal error: Requested option {} not of integer type!\n",fileName,num,name);
  }
  return *(dynamic_cast<ConfigInt *>(it->second))->valueRef();
}

bool &ConfigImpl::getBool(const char *fileName,int num,const char *name) const
{
  auto it = m_dict.find(name);
  if (it==m_dict.end())
  {
    config_term("{}<{}>: Internal error: Requested unknown option {}!\n",fileName,num,name);
  }
  else if (it->second->kind()!=ConfigOption::O_Bool)
  {
    config_term("{}<{}>: Internal error: Requested option {} not of boolean type!\n",fileName,num,name);
  }
  return *(dynamic_cast<ConfigBool *>(it->second))->valueRef();
}

/* ------------------------------------------ */

void ConfigInfo::writeTemplate(TextStream &t, bool sl,bool)
{
  if (!sl)
  {
    t << "\n";
  }
  t << "#---------------------------------------------------------------------------\n";
  t << "# " << m_doc << "\n";
  t << "#---------------------------------------------------------------------------\n";
}

void ConfigList::writeTemplate(TextStream &t,bool sl,bool)
{
  if (!sl)
  {
    t << "\n";
    t << convertToComment(m_doc, m_userComment);
    t << "\n";
  }
  else if (!m_userComment.isEmpty())
  {
    t << convertToComment("", m_userComment);
  }
  t << m_name << m_spaces.left(MAX_OPTION_LENGTH-m_name.length()) << "=";
  writeStringList(t,m_value);
  t << "\n";
}

bool ConfigList::isDefault()
{
  auto get_stripped = [](const std::string &s)             { return QCString(s.c_str()).stripWhiteSpace(); };
  auto is_not_empty = [get_stripped](const std::string &s) { return !get_stripped(s).isEmpty();            };
  size_t defCnt = std::count_if(       m_value.begin(),       m_value.end(),is_not_empty);
  size_t valCnt = std::count_if(m_defaultValue.begin(),m_defaultValue.end(),is_not_empty);
  if ( valCnt != defCnt)
  {
    return false;
  }
  auto it1 = m_value.begin();
  auto it2 = m_defaultValue.begin();
  while (it1!=m_value.end() && it2!=m_defaultValue.end())
  {
    // skip over empty values
    while (it1!=m_value.end() && !is_not_empty(*it1))
    {
      ++it1;
    }
    if (it1!=m_value.end()) // non-empty value
    {
      if (get_stripped(*it1) != get_stripped(*it2)) // not the default, write as difference
      {
        return false;
      }
      ++it1;
      ++it2;
    }
  }
  return true;
}

void ConfigList::compareDoxyfile(TextStream &t, Config::CompareMode)
{
  if (!isDefault()) writeTemplate(t,TRUE,TRUE);
}

void ConfigList::writeXMLDoxyfile(TextStream &t)
{
  t << "  <option  id='" << m_name << "'";
  t << " default='" << (isDefault() ? "yes" : "no") << "'";
  t << " type='stringlist'";
  t << ">";
  t << "\n";
  for (const auto &p : m_value)
  {
    QCString s=p.c_str();
    t << "    <value>";
    t << "<![CDATA[";
    writeStringValue(t,s,false);
    t << "]]>";
    t << "</value>\n";
  }
  t << "  </option>\n";
}

void ConfigList::writeXSDDoxyfile(TextStream &t)
{
  t << "      <xsd:enumeration value=\"" << m_name << "\"/>\n";
}

void ConfigEnum::writeTemplate(TextStream &t,bool sl,bool)
{
  if (!sl)
  {
    t << "\n";
    t << convertToComment(m_doc, m_userComment);
    t << "\n";
  }
  else if (!m_userComment.isEmpty())
  {
    t << convertToComment("", m_userComment);
  }
  t << m_name << m_spaces.left(MAX_OPTION_LENGTH-m_name.length()) << "=";
  writeStringValue(t,m_value);
  t << "\n";
}

void ConfigEnum::compareDoxyfile(TextStream &t, Config::CompareMode)
{
  if (!isDefault()) writeTemplate(t,TRUE,TRUE);
}

void ConfigEnum::writeXMLDoxyfile(TextStream &t)
{
  t << "  <option  id='" << m_name << "'";
  t << " default='" << (isDefault() ? "yes" : "no") << "'";
  t << " type='string'";
  t << ">";
  t << "<value>";
  writeStringValue(t,m_value,false);
  t << "</value>";
  t << "</option>\n";
}

void ConfigEnum::writeXSDDoxyfile(TextStream &t)
{
  t << "      <xsd:enumeration value=\"" << m_name << "\"/>\n";
}

void ConfigString::writeTemplate(TextStream &t,bool sl,bool)
{
  if (!sl)
  {
    t << "\n";
    t << convertToComment(m_doc, m_userComment);
    t << "\n";
  }
  else if (!m_userComment.isEmpty())
  {
    t << convertToComment("", m_userComment);
  }
  t << m_name << m_spaces.left(MAX_OPTION_LENGTH-m_name.length()) << "=";
  writeStringValue(t,m_value);
  t << "\n";
}

void ConfigString::compareDoxyfile(TextStream &t, Config::CompareMode)
{
  if (!isDefault()) writeTemplate(t,TRUE,TRUE);
}

void ConfigString::writeXMLDoxyfile(TextStream &t)
{
  t << "  <option  id='" << m_name << "'";
  t << " default='" << (isDefault() ? "yes" : "no") << "'";
  t << " type='string'";
  t << ">";
  t << "<value>";
  t << "<![CDATA[";
  writeStringValue(t,m_value,false);
  t << "]]>";
  t << "</value>";
  t << "</option>\n";
}

void ConfigString::writeXSDDoxyfile(TextStream &t)
{
  t << "      <xsd:enumeration value=\"" << m_name << "\"/>\n";
}

void ConfigInt::writeTemplate(TextStream &t,bool sl,bool upd)
{
  if (!sl)
  {
    t << "\n";
    t << convertToComment(m_doc, m_userComment);
    t << "\n";
  }
  else if (!m_userComment.isEmpty())
  {
    t << convertToComment("", m_userComment);
  }
  t << m_name << m_spaces.left(MAX_OPTION_LENGTH-m_name.length()) << "=";
  if (upd && !m_valueString.isEmpty())
  {
    writeStringValue(t,m_valueString);
  }
  else
  {
    writeIntValue(t,m_value);
  }
  t << "\n";
}

void ConfigInt::compareDoxyfile(TextStream &t,Config::CompareMode compareMode)
{
  if (!isDefault() || ((compareMode == Config::CompareMode::CompressedNoEnv) && containsEnvVar(m_valueString))) writeTemplate(t,TRUE,TRUE);
}

void ConfigInt::writeXMLDoxyfile(TextStream &t)
{
  t << "  <option  id='" << m_name << "'";
  t << " default='" << (isDefault() ? "yes" : "no") << "'";
  t << " type='int'";
  t << ">";
  t << "<value>";
  writeIntValue(t,m_value,false);
  t << "</value>";
  t << "</option>\n";
}

void ConfigInt::writeXSDDoxyfile(TextStream &t)
{
  t << "      <xsd:enumeration value=\"" << m_name << "\"/>\n";
}

void ConfigBool::writeTemplate(TextStream &t,bool sl,bool upd)
{
  if (!sl)
  {
    t << "\n";
    t << convertToComment(m_doc, m_userComment);
    t << "\n";
  }
  else if (!m_userComment.isEmpty())
  {
    t << convertToComment("", m_userComment);
  }
  QCString spaces = m_spaces.left(MAX_OPTION_LENGTH-m_name.length());
  t << m_name << spaces << "=";
  if (upd && !m_valueString.isEmpty())
  {
    writeStringValue(t,m_valueString);
  }
  else
  {
    writeBoolValue(t,m_value);
  }
  t << "\n";
}

void ConfigBool::compareDoxyfile(TextStream &t,Config::CompareMode compareMode)
{
  if (!isDefault() || ((compareMode == Config::CompareMode::CompressedNoEnv) && containsEnvVar(m_valueString))) writeTemplate(t,TRUE,TRUE);
}

void ConfigBool::writeXMLDoxyfile(TextStream &t)
{
  t << "  <option  id='" << m_name << "'";
  t << " default='" << (isDefault() ? "yes" : "no") << "'";
  t << " type='bool'";
  t << ">";
  t << "<value>";
  writeBoolValue(t,m_value,false);
  t << "</value>";
  t << "</option>\n";
}

void ConfigBool::writeXSDDoxyfile(TextStream &t)
{
  t << "      <xsd:enumeration value=\"" << m_name << "\"/>\n";
}

void ConfigObsolete::writeTemplate(TextStream &,bool,bool) {}

void ConfigDisabled::writeTemplate(TextStream &,bool,bool) {}
void ConfigDisabled::writeXSDDoxyfile(TextStream &t)
{
  t << "      <xsd:enumeration value=\"" << m_name << "\"/>\n";
}

/* -----------------------------------------------------------------
 *
 *      static variables
 */

struct ConfigFileState
{
  int lineNr = 1;
  FILE *filePtr = nullptr;
  YY_BUFFER_STATE oldState;
  YY_BUFFER_STATE newState;
  QCString fileName;
};

static const char       *g_inputString = nullptr;
static int               g_inputPosition = 0;
static int               g_yyLineNr = 1;
static QCString          g_yyFileName;
static QCString          g_cmd;
static QCString         *g_string = nullptr;
static StringVector     *g_list = nullptr;
static QCString          g_listStr;
static StringVector      g_includePathList;
static std::vector< std::unique_ptr<ConfigFileState> > g_includeStack;
static bool              g_configUpdate = FALSE;
static QCString          g_encoding;
static ConfigImpl       *g_config = nullptr;
static Config::CompareMode g_compareMode = Config::CompareMode::Full;
static QCString          g_localStoreRepl;

#define unput_string(yytext,yyleng) do { for (int i=(int)yyleng-1;i>=0;i--) unput(yytext[i]); } while(0)
/* -----------------------------------------------------------------
 */
#undef  YY_INPUT
#define YY_INPUT(buf,result,max_size) result=yyread(buf,max_size);

// otherwise the filename would be the name of the converted file (*.cpp instead of *.l)
static inline const char *getLexerFILE() {return __FILE__;}
#define LEX_NO_REENTRANT
#include "doxygen_lex.h"

static int yyread(char *buf,int max_size)
{
  // no file included
  if (g_includeStack.empty())
  {
    int c=0;
    if (g_inputString==0) return c;
    while( c < max_size && g_inputString[g_inputPosition] )
    {
      *buf = g_inputString[g_inputPosition++] ;
      c++; buf++;
    }
    return c;
  }
  else
  {
    //assert(g_includeStack.current()->newState==YY_CURRENT_BUFFER);
    return static_cast<int>(fread(buf,1,max_size,g_includeStack.back()->filePtr));
  }
}


static QCString configStringRecode(
    const QCString &str,
    const QCString &inputEncoding,
    const QCString &outputEncoding)
{
  if (inputEncoding.isEmpty() || outputEncoding.isEmpty() || inputEncoding==outputEncoding) return str;
  size_t inputSize=str.length();
  size_t outputSize=inputSize*4;
  QCString output(outputSize, QCString::ExplicitSize);
  void *cd = portable_iconv_open(outputEncoding.data(),inputEncoding.data());
  if (cd==reinterpret_cast<void *>(-1))
  {
    ConfigImpl::config_term("Error: unsupported character conversion: '{}'->'{}'\n"
                "Check the 'DOXYFILE_ENCODING' setting in the config file!\n",
        inputEncoding,outputEncoding);
  }
  size_t iLeft=inputSize;
  size_t oLeft=outputSize;
  const char *inputPtr  = str.data();
  char *outputPtr = output.rawData();
  if (!portable_iconv(cd, &inputPtr, &iLeft, &outputPtr, &oLeft))
  {
    outputSize-=oLeft;
    output.resize(outputSize);
    output.at(outputSize)='\0';
    //printf("iconv: input size=%d output size=%d\n[%s]\n",size,newSize,qPrint(srcBuf));
  }
  else
  {
    ConfigImpl::config_term("Error: failed to translate characters from {} to {}: {}\n",
        inputEncoding,outputEncoding,strerror(errno));
  }
  portable_iconv_close(cd);
  return output;
}

static void checkEncoding()
{
  ConfigString *option = dynamic_cast<ConfigString*>(g_config->get("DOXYFILE_ENCODING"));
  g_encoding = *option->valueRef();
}

static QCString stripComment(const QCString &s)
{
  // check if there is a comment at the end of the string
  bool insideQuote=false;
  size_t l = s.length();
  for (size_t i=0;i<l;i++)
  {
    char c = s.at(i);
    if (c=='\\') // skip over escaped characters
    {
      i++;
    }
    else if (c=='"') // toggle inside/outside quotation
    {
      insideQuote=!insideQuote;
    }
    else if (!insideQuote && c=='#') // found start of a comment
    {
      if (i<l-1 && s.at(i+1)=='#') // ## -> user comment
      {
        g_config->appendUserComment(s.mid(i)+"\n");
      }
      return s.left(i).stripWhiteSpace();
    }
  }
  return s;
}

static void processStoreRepl(QCString &storeReplStr)
{
  // strip leading and trailing whitespace
  QCString s = stripComment(storeReplStr.stripWhiteSpace());
  // recode the string
  storeReplStr=configStringRecode(s,g_encoding,"UTF-8");
}

static void processString()
{
  // strip leading and trailing whitespace
  QCString s = stripComment(g_string->stripWhiteSpace());
  size_t l = s.length();

  // remove surrounding quotes if present (and not escaped)
  if (l>=2 && s.at(0)=='"' && s.at(l-1)=='"' && // remove quotes
      (s.at(l-2)!='\\' || (s.at(l-2)=='\\' && s.at(l-3)=='\\')))
  {
    s=s.mid(1,s.length()-2);
    l=s.length();
  }

  // check for invalid and/or escaped quotes
  bool warned=false;
  QCString result;
  for (size_t i=0;i<l;i++)
  {
    char c = s.at(i);
    if (c=='\\') // escaped character
    {
      if (i<l-1 && s.at(i+1)=='"') // unescape the quote character
      {
        result+='"';
      }
      else // keep other escaped characters in escaped form
      {
        result+=c;
        if (i<l-1)
        {
          result+=s.at(i+1);
        }
      }
      i++; // skip over the escaped character
    }
    else if (c=='"') // unescaped quote
    {
      if (!warned)
      {
        ConfigImpl::config_warn("Invalid value for '{}' tag at line {}, file {}: Value '{}' is not properly quoted\n",
                    g_cmd,g_yyLineNr,g_yyFileName,g_string->stripWhiteSpace());
      }
      warned=true;
    }
    else // normal character
    {
      result+=c;
    }
  }

  // recode the string
  *g_string=configStringRecode(result,g_encoding,"UTF-8");

  // update encoding
  checkEncoding();

  //printf("Processed string '%s'\n",qPrint(g_string));
}

static void processList()
{
  bool allowCommaAsSeparator = g_cmd!="PREDEFINED";

  QCString s = stripComment(g_listStr.stripWhiteSpace());
  size_t l = s.length();

  QCString elemStr;
  bool wasQuote=false;

  // helper to push elemStr to the list and clear it
  auto addElem = [&elemStr,&wasQuote]()
  {
    if (!elemStr.isEmpty())
    {
      QCString e = configStringRecode(elemStr,g_encoding,"UTF-8");
      //printf("Processed list element '%s'\n",qPrint(e));
      if (wasQuote) e = "\""+e+"\"";
      wasQuote = false;
      g_list->push_back(e.str());
      elemStr="";
    }
  };

  bool needsSeparator=false;
  bool insideQuote=false;
  bool warned=false;
  for (size_t i=0;i<l;i++)
  {
    char c = s.at(i);
    if (!needsSeparator && c=='\\') // escaped character
    {
      if (i<l-1 && s.at(i+1)=='"') // unescape the quote character
      {
        elemStr+='"';
      }
      else // keep other escaped characters in escaped form
      {
        elemStr+=c;
        if (i<l-1)
        {
          elemStr+=s.at(i+1);
        }
      }
      i++; // skip over the escaped character
    }
    else if (!needsSeparator && c=='"') // quote character
    {
      if (!insideQuote)
      {
        insideQuote=true;
        wasQuote=true;
      }
      else // this quote ends an element
      {
        insideQuote=false;
        needsSeparator=true;
      }
    }
    else if (!insideQuote && ((c==',' && allowCommaAsSeparator) || isspace(c))) // separator
    {
      needsSeparator=false;
      addElem();
    }
    else // normal content character
    {
      if (needsSeparator)
      {
        if (!warned)
        {
          ConfigImpl::config_warn("Invalid value for '{}' tag at line {}, file {}: Values in list '{}' are not properly space {}separated\n",
                    g_cmd,g_yyLineNr,g_yyFileName,g_listStr.stripWhiteSpace(),allowCommaAsSeparator?"or comma ":"");
          warned=true;
        }
        needsSeparator=false;
        i--; // try the character again as part of a new element
        addElem();
      }
      else
      {
        elemStr+=c;
      }
    }
  }
  // add last part
  addElem();
  if (insideQuote)
  {
    ConfigImpl::config_warn("Invalid value for '{}' tag at line {}, file {}: Values in list '{}' are not properly quoted\n",
                g_cmd,g_yyLineNr,g_yyFileName,g_listStr.stripWhiteSpace());
  }
}

static FILE *tryPath(const QCString &path,const QCString &fileName)
{
  QCString absName=(!path.isEmpty() ? path+"/"+fileName : fileName);
  FileInfo fi(absName.str());
  if (fi.exists() && fi.isFile())
  {
    FILE *f=Portable::fopen(absName,"r");
    if (!f) ConfigImpl::config_err("could not open file {} for reading\n",absName);
    return f;
  }
  return 0;
}

static void substEnvVarsInStrList(StringVector &sl);
static void substEnvVarsInString(QCString &s);

static FILE *findFile(const QCString &fileName)
{
  if (fileName.isEmpty())
  {
    return 0;
  }
  if (Portable::isAbsolutePath(fileName))
  {
    return tryPath(QCString(), fileName);
  }
  substEnvVarsInStrList(g_includePathList);
  for (const auto &s : g_includePathList)
  {
    FILE *f = tryPath(s.c_str(),fileName);
    if (f) return f;
  }
  // try cwd if g_includePathList fails
  return tryPath(".",fileName);
}

static void readIncludeFile(const QCString &incName)
{
  if (g_includeStack.size()==MAX_INCLUDE_DEPTH) {
    ConfigImpl::config_term("maximum include depth ({:d}) reached, {} is not included. Aborting...\n",
        MAX_INCLUDE_DEPTH,incName);
  }

  QCString inc = incName;
  substEnvVarsInString(inc);
  inc = inc.stripWhiteSpace();
  size_t incLen = inc.length();
  if (incLen>0 && inc.at(0)=='"' && inc.at(incLen-1)=='"') // strip quotes
  {
    inc=inc.mid(1,incLen-2);
  }

  FILE *f;

  if ((f=findFile(inc))) // see if the include file can be found
  {
    // For debugging
#if SHOW_INCLUDES
    for (size_t i=0;i<g_includeStack.size();i++) msg("  ");
    msg("@INCLUDE = {}: parsing...\n",inc);
#endif

    // store the state of the old file
    ConfigFileState *fs=new ConfigFileState;
    fs->oldState=YY_CURRENT_BUFFER;
    fs->lineNr=g_yyLineNr;
    fs->fileName=g_yyFileName;
    fs->filePtr=f;
    // push the state on the stack
    g_includeStack.push_back(std::unique_ptr<ConfigFileState>(fs));
    // set the scanner to the include file
    yy_switch_to_buffer(yy_create_buffer(f, YY_BUF_SIZE));
    fs->newState=YY_CURRENT_BUFFER;
    g_yyFileName=inc;
  }
  else
  {
    ConfigImpl::config_term("@INCLUDE = {}: not found!\n",inc);
  }
}


#line 1893 "/build/doxygen/src/build/generated_src/configimpl_intermediate.cpp"

#line 1895 "/build/doxygen/src/build/generated_src/configimpl_intermediate.cpp"

#define INITIAL 0
#define Start 1
#define SkipInvalid 2
#define GetString 3
#define GetStrList 4
#define Include 5
#define StoreRepl 6

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 1017 "/build/doxygen/src/build/generated_src/configimpl.l"


#line 2121 "/build/doxygen/src/build/generated_src/configimpl_intermediate.cpp"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 125 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 124 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 1019 "/build/doxygen/src/build/generated_src/configimpl.l"

	YY_BREAK
/*-------------- Comments ---------------*/
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 1023 "/build/doxygen/src/build/generated_src/configimpl.l"
{
                                           g_config->appendUserComment(yytext);
                                           g_yyLineNr++;
                                         }
	YY_BREAK
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 1027 "/build/doxygen/src/build/generated_src/configimpl.l"
{ /* normal comment */
                                           g_yyLineNr++;
                                         }
	YY_BREAK
/*-------------- TAG start ---------------*/
case 4:
YY_RULE_SETUP
#line 1033 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_cmd=yytext;
                                           g_cmd=g_cmd.left(g_cmd.length()-1).stripWhiteSpace();
                                           ConfigOption *option = g_config->get(g_cmd);
                                           if (option==0) // oops not known
                                           {
                                             ConfigImpl::config_warn("ignoring unsupported tag '{}' at line {}, file {}\n",
                                                 g_cmd,g_yyLineNr,g_yyFileName);
                                             BEGIN(SkipInvalid);
                                           }
                                           else // known tag
                                           {
                                             option->setUserComment(g_config->takeUserComment());
                                             option->setEncoding(g_encoding);
                                             switch(option->kind())
                                             {
                                               case ConfigOption::O_Info:
                                                 // shouldn't get here!
                                                 BEGIN(SkipInvalid);
                                                 break;
                                               case ConfigOption::O_List:
                                                 g_list = dynamic_cast<ConfigList *>(option)->valueRef();
                                                 g_list->clear();
                                                 g_listStr="";
                                                 BEGIN(GetStrList);
                                                 break;
                                               case ConfigOption::O_Enum:
                                                 g_string = dynamic_cast<ConfigEnum *>(option)->valueRef();
                                                 g_string->clear();
                                                 BEGIN(GetString);
                                                 break;
                                               case ConfigOption::O_String:
                                                 g_string = dynamic_cast<ConfigString *>(option)->valueRef();
                                                 g_string->clear();
                                                 BEGIN(GetString);
                                                 break;
                                               case ConfigOption::O_Int:
                                                 g_string = dynamic_cast<ConfigInt *>(option)->valueStringRef();
                                                 g_string->clear();
                                                 BEGIN(GetString);
                                                 break;
                                               case ConfigOption::O_Bool:
                                                 g_string = dynamic_cast<ConfigBool *>(option)->valueStringRef();
                                                 g_string->clear();
                                                 BEGIN(GetString);
                                                 break;
                                               case ConfigOption::O_Obsolete:
                                                 if (g_configUpdate)
                                                 {
                                                   ConfigImpl::config_warn("Tag '{}' at line {} of file '{}' has become obsolete.\n"
                                                              "         This tag has been removed.\n", g_cmd,g_yyLineNr,g_yyFileName);
                                                 }
                                                 else
                                                 {
                                                   ConfigImpl::config_warn("Tag '{}' at line {} of file '{}' has become obsolete.\n"
                                                              "         To avoid this warning please remove this line from your configuration "
                                                              "file or upgrade it using \"doxygen -u\"\n", g_cmd,g_yyLineNr,g_yyFileName);
                                                 }
                                                 dynamic_cast<ConfigObsolete*>(option)->markAsPresent();
                                                 if (dynamic_cast<ConfigObsolete*>(option)->orgType()==ConfigOption::O_List)
                                                 {
                                                   g_list = dynamic_cast<ConfigObsolete*>(option)->valueListRef();
                                                   g_list->clear();
                                                   g_listStr="";
                                                   BEGIN(GetStrList);
                                                 }
                                                 else
                                                 {
                                                   g_string = dynamic_cast<ConfigObsolete*>(option)->valueStringRef();
                                                   g_string->clear();
                                                   BEGIN(GetString);
                                                 }
                                                 break;
                                               case ConfigOption::O_Disabled:
                                                 if (g_configUpdate)
                                                 {
                                                   ConfigImpl::config_warn("Tag '{}' at line {} of file '{}' belongs to an option that was not enabled at compile time.\n"
                                                              "         This tag has been removed.\n", g_cmd,g_yyLineNr,g_yyFileName);
                                                 }
                                                 else
                                                 {
                                                   ConfigImpl::config_warn("Tag '{}' at line {} of file '{}' belongs to an option that was not enabled at compile time.\n"
                                                              "         To avoid this warning please remove this line from your configuration "
                                                            "file or upgrade it using \"doxygen -u\", or recompile doxygen with this feature enabled.\n", g_cmd,g_yyLineNr,g_yyFileName);
                                                 }
                                                 BEGIN(SkipInvalid);
                                                 break;
                                             }
                                           }
                                        }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 1122 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_cmd=yytext;
                                          g_cmd=g_cmd.left(g_cmd.length()-2).stripWhiteSpace();
                                          ConfigOption *option = g_config->get(g_cmd);
                                          if (option==0) // oops not known
                                          {
                                            ConfigImpl::config_warn("ignoring unsupported tag '{}' at line {}, file {}\n",
                                                g_cmd,g_yyLineNr,g_yyFileName);
                                            BEGIN(SkipInvalid);
                                          }
                                          else // known tag
                                          {
                                            option->setUserComment(g_config->takeUserComment());
                                            switch(option->kind())
                                            {
                                              case ConfigOption::O_Info:
                                                // shouldn't get here!
                                                BEGIN(SkipInvalid);
                                                break;
                                              case ConfigOption::O_List:
                                                g_list = dynamic_cast<ConfigList *>(option)->valueRef();
                                                g_listStr="";
                                                BEGIN(GetStrList);
                                                break;
                                              case ConfigOption::O_Enum:
                                              case ConfigOption::O_String:
                                              case ConfigOption::O_Int:
                                              case ConfigOption::O_Bool:
                                                ConfigImpl::config_warn("operator += not supported for '{}'. Ignoring line at line {}, file {}\n",
                                                    yytext,g_yyLineNr,g_yyFileName);
                                                BEGIN(SkipInvalid);
                                                break;
                                               case ConfigOption::O_Obsolete:
                                                ConfigImpl::config_warn("Tag '{}' at line {} of file {} has become obsolete.\n"
                                                            "To avoid this warning please update your configuration "
                                                            "file using \"doxygen -u\"\n", g_cmd,g_yyLineNr,g_yyFileName);
                                                 if (dynamic_cast<ConfigObsolete*>(option)->orgType()==ConfigOption::O_List)
                                                 {
                                                   g_list = dynamic_cast<ConfigObsolete*>(option)->valueListRef();
                                                   g_listStr="";
                                                   BEGIN(GetStrList);
                                                 }
                                                 else
                                                 {
                                                   BEGIN(SkipInvalid);
                                                 }
                                                 break;
                                               case ConfigOption::O_Disabled:
                                                 ConfigImpl::config_warn("Tag '{}' at line {} of file {} belongs to an option that was not enabled at compile time.\n"
                                                            "To avoid this warning please remove this line from your configuration "
                                                            "file, upgrade it using \"doxygen -u\", or recompile doxygen with this feature enabled.\n", 
                                                            g_cmd,g_yyLineNr,g_yyFileName);
                                                 BEGIN(SkipInvalid);
                                                 break;
                                             }
                                           }
                                        }
	YY_BREAK
/*-------------- INCLUDE* ---------------*/
case 6:
YY_RULE_SETUP
#line 1181 "/build/doxygen/src/build/generated_src/configimpl.l"
{ BEGIN(GetStrList); g_list=&g_includePathList; g_list->clear(); g_listStr=""; }
	YY_BREAK
/* include a g_config file */
case 7:
YY_RULE_SETUP
#line 1183 "/build/doxygen/src/build/generated_src/configimpl.l"
{ BEGIN(Include);}
	YY_BREAK
case 8:
#line 1185 "/build/doxygen/src/build/generated_src/configimpl.l"
case 9:
YY_RULE_SETUP
#line 1185 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // e.g. $(PROGRAMFILES(X86))
                                          g_localStoreRepl = yytext;
                                          if (g_compareMode == Config::CompareMode::CompressedNoEnv) // the x_noenv
                                          {
                                            BEGIN(StoreRepl);
                                          }
                                          else
                                          {
                                            substEnvVarsInString(g_localStoreRepl);
                                            unput_string(g_localStoreRepl.data(),g_localStoreRepl.length());
                                          }
                                        }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 1197 "/build/doxygen/src/build/generated_src/configimpl.l"
{
                                          if (g_compareMode == Config::CompareMode::CompressedNoEnv) // the x_noenv
                                          {
                                            g_localStoreRepl = yytext;
                                            BEGIN(StoreRepl);
                                          }
                                          else
                                          {
                                            ConfigImpl::config_warn("ignoring unknown '{}' at line {}, file {}\n",
                                                        yytext,g_yyLineNr,g_yyFileName);
                                          }
                                        }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 1209 "/build/doxygen/src/build/generated_src/configimpl.l"
{
                                          readIncludeFile(configStringRecode(yytext,g_encoding,"UTF-8"));
                                          BEGIN(Start);
                                        }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(Start):
case YY_STATE_EOF(SkipInvalid):
case YY_STATE_EOF(GetString):
case YY_STATE_EOF(GetStrList):
case YY_STATE_EOF(Include):
case YY_STATE_EOF(StoreRepl):
#line 1213 "/build/doxygen/src/build/generated_src/configimpl.l"
{
                                          //printf("End of include file\n");
                                          //printf("Include stack depth=%d\n",g_includeStack.count());
                                          if (g_includeStack.empty())
                                          {
                                            //printf("Terminating scanner!\n");
                                            yyterminate();
                                          }
                                          else
                                          {
                                            auto &fs=g_includeStack.back();
                                            fclose(fs->filePtr);
                                            YY_BUFFER_STATE oldBuf = YY_CURRENT_BUFFER;
                                            yy_switch_to_buffer( fs->oldState );
                                            yy_delete_buffer( oldBuf );
                                            g_yyLineNr=fs->lineNr;
                                            g_yyFileName=fs->fileName;
                                            g_includeStack.pop_back();
                                          }
                                        }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 1234 "/build/doxygen/src/build/generated_src/configimpl.l"
{ ConfigImpl::config_warn("ignoring unknown tag '{}' at line {}, file {}\n",yytext,g_yyLineNr,g_yyFileName); }
	YY_BREAK
/*-------------- GetString ---------------*/
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 1237 "/build/doxygen/src/build/generated_src/configimpl.l"
{
                                          g_localStoreRepl += yytext;
                                          processStoreRepl(g_localStoreRepl);
                                          g_config->appendStoreRepl(g_localStoreRepl + "\n");
                                          g_localStoreRepl.clear();
                                          g_yyLineNr++; // end of string
                                          BEGIN(Start);
                                        }
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 1245 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_yyLineNr++; // line continuation
                                          g_localStoreRepl += yytext;
                                        }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 1248 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // escape character
                                          g_localStoreRepl += yytext;
                                        }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 1251 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // string part without escape characters
                                          g_localStoreRepl += yytext;
                                        }
	YY_BREAK
/*-------------- GetString ---------------*/
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 1256 "/build/doxygen/src/build/generated_src/configimpl.l"
{ processString();
                                          g_yyLineNr++; // end of string
                                          BEGIN(Start);
                                        }
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 1260 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_yyLineNr++; // line continuation
                                          *g_string+=' ';
                                        }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 1263 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // escape character
                                          *g_string+=yytext;
                                        }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 1266 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // string part without escape characters
                                          *g_string+=yytext;
                                        }
	YY_BREAK
/*-------------- GetStrList --------------*/
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 1272 "/build/doxygen/src/build/generated_src/configimpl.l"
{ processList();
                                          g_yyLineNr++; // end of list
                                          BEGIN(Start);
                                        }
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 1276 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_yyLineNr++; // line continuation
                                          g_listStr+=' ';
                                        }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 1279 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // escape character
                                          g_listStr+=yytext;
                                        }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 1282 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // string part without escape characters
                                          g_listStr+=yytext;
                                        }
	YY_BREAK
/*-------------- SkipInvalid --------------*/
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 1288 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_yyLineNr++; // end of list
                                          BEGIN(Start);
                                        }
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 1291 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_yyLineNr++; // line continuation
                                        }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 1293 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // escape character
                                        }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 1295 "/build/doxygen/src/build/generated_src/configimpl.l"
{ // string part without escape characters
                                        }
	YY_BREAK
/*-------------- fall through -------------*/
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 1300 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_yyLineNr++; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 1301 "/build/doxygen/src/build/generated_src/configimpl.l"

	YY_BREAK
case 31:
/* rule 31 can match eol */
YY_RULE_SETUP
#line 1302 "/build/doxygen/src/build/generated_src/configimpl.l"
{ g_yyLineNr++ ; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 1303 "/build/doxygen/src/build/generated_src/configimpl.l"
{ ConfigImpl::config_warn("ignoring unknown character '{:c}' at line {}, file {}\n",yytext[0],g_yyLineNr,g_yyFileName); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 1305 "/build/doxygen/src/build/generated_src/configimpl.l"
ECHO;
	YY_BREAK
#line 2595 "/build/doxygen/src/build/generated_src/configimpl_intermediate.cpp"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 33);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 125 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 33;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 125 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 124);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1305 "/build/doxygen/src/build/generated_src/configimpl.l"


/*@ ----------------------------------------------------------------------------
 */

void ConfigImpl::writeTemplate(TextStream &t,bool sl,bool upd)
{
  /* print first lines of user comment that were at the beginning of the file, might have special meaning for editors */
  if (!m_startComment.isEmpty())
  {
    t << takeStartComment() << "\n";
  }
  t << "# Doxyfile " << getDoxygenVersion() << "\n\n";
  if (!sl)
  {
    t << convertToComment(m_header,"");
  }
  for (const auto &option : m_options)
  {
    option->writeTemplate(t,sl,upd);
  }
  /* print last lines of user comment that were at the end of the file */
  if (!m_userComment.isEmpty())
  {
    t << "\n";
    t << takeUserComment();
  }
}

void ConfigImpl::compareDoxyfile(TextStream &t,Config::CompareMode compareMode)
{
  t << "# Difference with default Doxyfile " << getFullVersion();
  t << "\n";
  for (const auto &option : m_options)
  {
    option->m_userComment = "";
    option->compareDoxyfile(t,compareMode);
  }
  if (!m_storeRepl.isEmpty())
  {
    t << "\n";
    t << takeStoreRepl() << "\n";
  }
}

void ConfigImpl::writeXMLDoxyfile(TextStream &t)
{
  t << "<?xml version='1.0' encoding='UTF-8' standalone='no'?>\n";
  t << "<doxyfile xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"doxyfile.xsd\" version=\"" << getDoxygenVersion() << "\" xml:lang=\"" <<  theTranslator->trISOLang() << "\">\n";
  for (const auto &option : m_options)
  {
    option->writeXMLDoxyfile(t);
  }
  t << "</doxyfile>\n";
}

void ConfigImpl::writeXSDDoxyfile(TextStream &t)
{
  for (const auto &option : m_options)
  {
    option->writeXSDDoxyfile(t);
  }
  for (const auto &option : m_disabled)
  {
    option->writeXSDDoxyfile(t);
  }
}

void ConfigImpl::convertStrToVal(Config::CompareMode compareMode)
{
  for (const auto &option : m_options)
  {
    option->convertStrToVal(compareMode);
  }
}
void ConfigImpl::emptyValueToDefault()
{
  for (const auto &option : m_options)
  {
    option->emptyValueToDefault();
  }
}

static const reg::Ex reEnvVar(R"(\$\((\a[\w.-]*)\))");                 // e.g. $(HOME)
static const reg::Ex reEnvVarExt(R"(\$\((\a[\w.-]*\(\a[\w.-]*\))\))"); // e.g. $(PROGRAMFILES(X86))
static const reg::Ex reEnvVarCMake(R"(@\a\w*@)");                      // CMake type replacement (@...@)
static const reg::Ex reEnvVar1CMake(R"(\${\a\w*})");                   // CMake type replacement (${...})

static bool containsEnvVar(QCString &str)
{
  reg::Match m;
  std::string s = str.str();
  return reg::search(s,m,reEnvVar) || reg::search(s,m,reEnvVarExt) || reg::search(s,m,reEnvVarCMake) || reg::search(s,m,reEnvVar1CMake);
}

static void substEnvVarsInString(QCString &str)
{
  if (str.isEmpty()) return;
  auto replace = [](const std::string &s, const reg::Ex &re) -> std::string
  {
    reg::Iterator it(s,re);
    reg::Iterator end;
    std::string result;
    size_t p = 0;
    for (; it!=end ; ++it)
    {
      const auto &match = *it;
      size_t i = match.position();
      size_t l = match.length();
      result+=s.substr(p,i-p);
      std::string matchContents = match[1].str();
      QCString env=Portable::getenv(matchContents.c_str()); // get content of $(..) match
      substEnvVarsInString(env); // recursively expand variables if needed.
      result+=env.str();
      p=i+l;
    }
    result+=s.substr(p);
    return result;
  };

  str = QCString(replace(replace(str.str(),reEnvVar),reEnvVarExt)).stripWhiteSpace();
}

static void substEnvVarsInStrList(StringVector &sl)
{
  StringVector results;
  for (const auto &s : sl)
  {
    QCString result = s.c_str();
    bool wasQuoted = ((result.at(0)=='"') && (result.at(result.length()-1)=='"'));
    if (wasQuoted)
    {
      result = result.mid(1,result.length()-2);
    }
    else
    {
      wasQuoted = (result.find(' ')!=-1) || (result.find('\t')!=-1) || (result.find('"')!=-1);
    }
    // here we strip the quote again
    substEnvVarsInString(result);

    //printf("Result %s was quoted=%d\n",qPrint(result),wasQuoted);

    if (!wasQuoted) /* as a result of the expansion, a single string
                       may have expanded into a list, which we'll
                       add to sl. If the original string already
                       contained multiple elements no further
                       splitting is done to allow quoted items with spaces! */
    {
      int l = static_cast<int>(result.length());
      int p = 0;
      // skip spaces
      // search for a "word"
      for (int i=0;i<l;i++)
      {
        char c=0;
        // skip until start of new word
        while (i<l && ((c=result.at(i))==' ' || c=='\t')) i++;
        p=i; // p marks the start index of the word
        // skip until end of a word
        while (i<l && ((c=result.at(i))!=' ' && c!='\t' && c!='"')) i++;
        if (i<l) // not at the end of the string
        {
          if (c=='"') // word within quotes
          {
            p=i+1;
            for (i++;i<l;i++)
            {
              c=result.at(i);
              if (c=='"') // end quote
              {
                results.push_back(result.mid(p,i-p).str());
                p=i+1;
                break;
              }
              else if (c=='\\') // skip escaped stuff
              {
                i++;
              }
            }
          }
          else if (c==' ' || c=='\t') // separator
          {
            if (i>p) results.push_back(result.mid(p,i-p).str());
            p=i+1;
          }
        }
      }
      if (p!=l) // add the leftover as a string
      {
        results.push_back(result.right(l-p).str());
      }
    }
    else // just goto the next element in the list
    {
      if (!result.isEmpty()) results.push_back(result.str());
    }
  }
  sl = results;
}

void ConfigString::substEnvVars()
{
  substEnvVarsInString(m_value);
}

void ConfigList::substEnvVars()
{
  substEnvVarsInStrList(m_value);
}

void ConfigBool::substEnvVars()
{
  substEnvVarsInString(m_valueString);
}

void ConfigInt::substEnvVars()
{
  substEnvVarsInString(m_valueString);
}

void ConfigEnum::substEnvVars()
{
  substEnvVarsInString(m_value);
}

//---------------------------------------------

void ConfigImpl::substituteEnvironmentVars()
{
  for (const auto &option : m_options)
  {
    option->substEnvVars();
  }
}

void ConfigImpl::init()
{
  for (const auto &option : m_options)
  {
    option->init();
  }

  // sanity check if all depends relations are valid
  for (const auto &option : m_options)
  {
    QCString depName = option->dependsOn();
    if (!depName.isEmpty())
    {
      ConfigOption * opt = ConfigImpl::instance()->get(depName);
      if (opt==0)
      {
        config_term("Config option '{}' has invalid depends relation on unknown option '{}'\n",
            option->name(),depName);
      }
    }
  }
}

ConfigImpl::ConfigImpl()
{
  addConfigOptions(this);
}

static QCString configFileToString(const QCString &name)
{
  if (name.isEmpty()) return QCString();

  auto stream2string = [](std::istream &in) -> std::string
  {
    std::string ret;
    char buffer[4096];
    while (in.read(buffer, sizeof(buffer))) ret.append(buffer, sizeof(buffer));
    ret.append(buffer, static_cast<uint32_t>(in.gcount()));
    if (!ret.empty() && ret[ret.length()-1]!='\n') ret+='\n'; // to help the scanner
    return ret;
  };

  if (name=="-") // read from stdin
  {
    // read contents from stdin into contents string
    return stream2string(std::cin);
  }
  else // read from file
  {
    std::ifstream f = Portable::openInputStream(name);
    if (!f.is_open())
    {
      ConfigImpl::config_term("file '{}' not found or could not be opened\n",name);
      return "";
    }
    return stream2string(f);
  }
}

bool ConfigImpl::parseString(const QCString &fn,const QCString &str,bool update)
{
#ifdef FLEX_DEBUG
  configimplYYset_debug(Debug::isFlagSet(Debug::Lex_configimpl)?1:0);
#endif
  g_config = ConfigImpl::instance();
  g_inputString   = str.data();
  g_inputPosition = 0;
  g_yyFileName    = fn;
  g_yyLineNr      = 1;
  g_includeStack.clear();
  configimplYYrestart( configimplYYin );
  BEGIN( Start );
  g_configUpdate = update;
  configimplYYlex();
  g_configUpdate = FALSE;
  g_inputString = 0;
  return TRUE;
}

bool ConfigImpl::parse(const QCString &fn,bool update)
{
  g_encoding = "UTF-8";
  DebugLex debugLex(Debug::Lex_configimpl, __FILE__, qPrint(fn));
  bool retval =  parseString(fn,configFileToString(fn), update);
  return retval;
}

//----------------------------------------------------------------------

static void cleanUpPaths(StringVector &str)
{
  for (size_t i=0;i<str.size();i++)
  {
    std::string path = str[i];
    std::replace(path.begin(),path.end(),'\\','/');
    if ((path[0]!='/' && (path.size()<=2 || path[1]!=':')) || path[path.size()-1]!='/')
    {
      FileInfo fi(path);
      if (fi.exists() && fi.isDir())
      {
        path = fi.absFilePath();
        if (path[path.size()-1]!='/') path+='/';
      }
    }
    str[i]=path;
  }
}

static bool checkFileName(const QCString &s,const char *optionName)
{
  QCString val = s.stripWhiteSpace().lower();
  if ((val=="yes" || val=="true"  || val=="1" || val=="all") ||
      (val=="no"  || val=="false" || val=="0" || val=="none"))
  {
    err("file name expected for option {}, got {} instead. Ignoring...\n",optionName,s);
    return false;
  }
  return true;
}


void Config::init()
{
  ConfigImpl::instance()->init();
}

static void checkList(const StringVector &list,const char *name, bool equalRequired,bool valueRequired)
{
  for (const auto &s: list)
  {
    QCString item=s.c_str();
    item=item.stripWhiteSpace();
    int i=item.find('=');
    if (i==-1 && equalRequired)
    {
      err("Illegal format for option {}, no equal sign ('=') specified for item '{}'\n",name,item);
    }
    if (i!=-1)
    {
      QCString myName=item.left(i).stripWhiteSpace();
      if (myName.isEmpty())
      {
        err("Illegal format for option {}, no name specified for item '{}'\n",name,item);
      }
      else if (valueRequired)
      {
        QCString myValue=item.right(item.length()-i-1).stripWhiteSpace();
        if (myValue.isEmpty())
        {
          err("Illegal format for option {}, no value specified for item '{}'\n",name,item);
        }
      }
    }
  }
}

static void adjustBoolSetting(const char *depOption, const char *optionName,bool expectedValue)
{
  // lookup option by name
  const ConfigValues::Info *option = ConfigValues::instance().get(optionName);
  if (option && option->type==ConfigValues::Info::Bool) // safety check
  {
    if (ConfigValues::instance().*(option->value.b)!=expectedValue) // current value differs from expectation
    {
      err("When enabling {} the {} option should be {}. I'll adjust it for you.\n",depOption,optionName,expectedValue? "enabled" : "disabled");
      ConfigValues::instance().*(option->value.b)=expectedValue; // adjust option
    }
  }
}

static void adjustStringSetting(const char *depOption, const char *optionName,const QCString &expectedValue)
{
  // lookup option by name
  const ConfigValues::Info *option = ConfigValues::instance().get(optionName);
  if (option && option->type==ConfigValues::Info::String) // safety check
  {
    if (ConfigValues::instance().*(option->value.s)!=expectedValue) // current value differs from expectation
    {
      err("When enabling {} the {} option should have value '{}'. I'll adjust it for you.\n",depOption,optionName,expectedValue);
      ConfigValues::instance().*(option->value.s)=expectedValue; // adjust option
    }
  }
}

static void adjustColorStyleSetting(const char *depOption)
{
  auto updateColorStyle = [&depOption](HTML_COLORSTYLE_t curStyle,HTML_COLORSTYLE_t newStyle)
  {
    err("When enabling '{}' the 'HTML_COLORSTYLE' option should be either 'LIGHT' or 'DARK' but has value '{}'. I'll adjust it for you to '{}'.\n",
        depOption,
        HTML_COLORSTYLE_enum2str(curStyle),
        HTML_COLORSTYLE_enum2str(newStyle));
    Config_updateEnum(HTML_COLORSTYLE,newStyle);
  };
  auto colorStyle = Config_getEnum(HTML_COLORSTYLE);
  switch (colorStyle)
  {
    case HTML_COLORSTYLE_t::LIGHT:
    case HTML_COLORSTYLE_t::DARK:
      // no adjustment needed
      break;
    case HTML_COLORSTYLE_t::AUTO_LIGHT:
    case HTML_COLORSTYLE_t::TOGGLE:
      updateColorStyle(colorStyle,HTML_COLORSTYLE_t::LIGHT);
      break;
    case HTML_COLORSTYLE_t::AUTO_DARK:
      updateColorStyle(colorStyle,HTML_COLORSTYLE_t::DARK);
      break;
  }
}


void Config::checkAndCorrect(bool quiet, const bool check)
{
  ConfigValues::instance().init();

  Config_updateBool(QUIET,quiet || Config_getBool(QUIET));
  //------------------------
  // check WARN_FORMAT
  QCString warnFormat = Config_getString(WARN_FORMAT);
  if (warnFormat.find("$file")==-1)
  {
    warn_uncond("warning format does not contain a $file tag!\n");
  }
  if (warnFormat.find("$line")==-1)
  {
    warn_uncond("warning format does not contain a $line tag!\n");
  }
  if (warnFormat.find("$text")==-1)
  {
    warn_uncond("warning format does not contain a $text tag!\n");
  }

  //------------------------
  // check and correct PAPER_TYPE
  QCString paperType = Config_getEnumAsString(PAPER_TYPE);
  paperType=paperType.lower().stripWhiteSpace();
  if (paperType.isEmpty() || paperType=="a4wide")
  {
    // use a4
    Config_updateEnum(PAPER_TYPE,PAPER_TYPE_t::a4);
  }
  else if (paperType!="a4" && paperType!="letter" &&
           paperType!="legal" && paperType!="executive")
  {
    err("Unknown page type '{}' specified\n",paperType);
    Config_updateEnum(PAPER_TYPE,PAPER_TYPE_t::a4);
  }

  //------------------------
  // check & correct STRIP_FROM_PATH
  StringVector stripFromPath = Config_getList(STRIP_FROM_PATH);
  if (stripFromPath.empty()) // by default use the current path
  {
    std::string p = Dir::currentDirPath()+"/";
    stripFromPath.push_back(p);
  }
  else
  {
    cleanUpPaths(stripFromPath);
  }
  Config_updateList(STRIP_FROM_PATH,stripFromPath);

  //------------------------
  // check & correct STRIP_FROM_INC_PATH
  StringVector stripFromIncPath = Config_getList(STRIP_FROM_INC_PATH);
  cleanUpPaths(stripFromIncPath);
  Config_updateList(STRIP_FROM_INC_PATH,stripFromIncPath);

  //------------------------
  // Test to see if HTML header is valid
  QCString headerFile = Config_getString(HTML_HEADER);
  if (check && !headerFile.isEmpty())
  {
    FileInfo fi(headerFile.str());
    if (!fi.exists())
    {
      ConfigImpl::config_term("tag HTML_HEADER: header file '{}' "
          "does not exist\n",headerFile);
    }
  }

  //------------------------
  // Test to see if HTML footer is valid
  QCString footerFile = Config_getString(HTML_FOOTER);
  if (check && !footerFile.isEmpty())
  {
    FileInfo fi(footerFile.str());
    if (!fi.exists())
    {
      ConfigImpl::config_term("tag HTML_FOOTER: footer file '{}' "
          "does not exist\n",footerFile);
    }
  }

  //------------------------
  // Test to see if MathJax code file is valid
  if (Config_getBool(USE_MATHJAX))
  {
    auto mathJaxFormat = Config_getEnum(MATHJAX_FORMAT);
    auto mathjaxVersion = Config_getEnum(MATHJAX_VERSION);
    if (mathjaxVersion == MATHJAX_VERSION_t::MathJax_2)
    {
      if (mathJaxFormat==MATHJAX_FORMAT_t::chtml)
      {
        Config_updateEnum(MATHJAX_FORMAT,MATHJAX_FORMAT_t::HTML_CSS);
      }
    }
    else
    {
      if (mathJaxFormat==MATHJAX_FORMAT_t::HTML_CSS || mathJaxFormat==MATHJAX_FORMAT_t::NativeMML)
      {
        Config_updateEnum(MATHJAX_FORMAT,MATHJAX_FORMAT_t::chtml);
      }
    }

    QCString mathJaxCodefile = Config_getString(MATHJAX_CODEFILE);
    if (check && !mathJaxCodefile.isEmpty())
    {
      FileInfo fi(mathJaxCodefile.str());
      if (!fi.exists())
      {
        ConfigImpl::config_term("tag MATHJAX_CODEFILE file '{}' "
            "does not exist\n",mathJaxCodefile);
      }
    }
    QCString path = Config_getString(MATHJAX_RELPATH);
    if (path.isEmpty())
    {
      path = "https://cdn.jsdelivr.net/npm/mathjax@";
      switch (mathjaxVersion)
      {
        case MATHJAX_VERSION_t::MathJax_2: path += "2"; break;
        case MATHJAX_VERSION_t::MathJax_3: path += "3"; break;
      }
    }

    if (path.at(path.length()-1)!='/')
    {
      path+="/";
    }
    Config_updateString(MATHJAX_RELPATH,path);
  }

  //------------------------
  // Test to see if LaTeX header is valid
  QCString latexHeaderFile = Config_getString(LATEX_HEADER);
  if (check && !latexHeaderFile.isEmpty())
  {
    FileInfo fi(latexHeaderFile.str());
    if (!fi.exists())
    {
      ConfigImpl::config_term("tag LATEX_HEADER: header file '{}' "
          "does not exist\n",latexHeaderFile);
    }
  }

  //------------------------
  // Test to see if LaTeX footer is valid
  QCString latexFooterFile = Config_getString(LATEX_FOOTER);
  if (check && !latexFooterFile.isEmpty())
  {
    FileInfo fi(latexFooterFile.str());
    if (!fi.exists())
    {
      ConfigImpl::config_term("tag LATEX_FOOTER: footer file '{}' "
          "does not exist\n",latexFooterFile);
    }
  }

  //------------------------
  // check include path
  const StringVector &includePath = Config_getList(INCLUDE_PATH);
  for (const auto &s : includePath)
  {
    FileInfo fi(s);
    if (!fi.exists())
    {
      warn_uncond("tag INCLUDE_PATH: include path '{}' does not exist\n",s);
    }
  }

  //------------------------
  // check PREDEFINED
  if (Config_getBool(ENABLE_PREPROCESSING))
  {
    const StringVector &predefList = Config_getList(PREDEFINED);
    for (const auto &s : predefList)
    {
      QCString predef=s.c_str();
      predef=predef.stripWhiteSpace();
      int i_equals=predef.find('=');
      int i_obrace=predef.find('(');
      if ((i_obrace==0) || (i_equals==0) || (i_equals==1 && predef.at(i_equals-1)==':'))
      {
        err("Illegal PREDEFINED format '{}', no define name specified\n",predef);
      }
    }
  }

  //------------------------
  // check EXTENSION_MAPPING
  checkList(Config_getList(EXTENSION_MAPPING),"EXTENSION_MAPPING",TRUE,TRUE);

  //------------------------
  // check FILTER_PATTERNS
  checkList(Config_getList(FILTER_PATTERNS),"FILTER_PATTERNS",TRUE,TRUE);

  //------------------------
  // check FILTER_SOURCE_PATTERNS
  checkList(Config_getList(FILTER_SOURCE_PATTERNS),"FILTER_SOURCE_PATTERNS",FALSE,FALSE);

  //------------------------
  // check INPUT_FILE_ENCODING
  checkList(Config_getList(INPUT_FILE_ENCODING),"INPUT_FILE_ENCODING",TRUE,TRUE);

  //------------------------
  // check TAGFILES
  checkList(Config_getList(TAGFILES),"TAGFILES",FALSE,TRUE);

  //------------------------
  // check EXTRA_SEARCH_MAPPINGS
  if (Config_getBool(SEARCHENGINE) && Config_getBool(GENERATE_HTML))
  {
    checkList(Config_getList(EXTRA_SEARCH_MAPPINGS),"EXTRA_SEARCH_MAPPING",TRUE,TRUE);
  }

  int numThreads = Config_getInt(NUM_PROC_THREADS);
  if (numThreads==0)
  {
     numThreads = static_cast<int>(std::thread::hardware_concurrency());
     Config_updateInt(NUM_PROC_THREADS,numThreads);
  }

  //------------------------

  // check for settings that are inconsistent with having GENERATE_HTMLHELP enabled
  if (Config_getBool(GENERATE_HTMLHELP))
  {
    const char *depOption = "GENERATE_HTMLHELP";
    adjustBoolSetting(  depOption, "GENERATE_TREEVIEW",    false  );
    adjustBoolSetting(  depOption, "SEARCHENGINE",         false  );
    adjustBoolSetting(  depOption, "HTML_DYNAMIC_MENUS",   false  );
    adjustBoolSetting(  depOption, "HTML_DYNAMIC_SECTIONS",false  );
    adjustBoolSetting(  depOption, "HTML_COPY_CLIPBOARD",  false  );
    adjustStringSetting(depOption, "HTML_FILE_EXTENSION", ".html");
    adjustColorStyleSetting(depOption);
    const StringVector &tagFileList = Config_getList(TAGFILES);
    StringVector filteredTagFileList;
    for (const auto &s : tagFileList)
    {
      bool validUrl = false;
      size_t eqPos = s.find('=');
      if (eqPos!=std::string::npos) // tag command contains a destination
      {
        QCString url = QCString(s.substr(eqPos+1)).stripWhiteSpace().lower();
        validUrl = url.startsWith("http:") || url.startsWith("https:");
      }
      if (validUrl)
      {
        filteredTagFileList.push_back(s);
      }
      else
      {
        err("When enabling GENERATE_HTMLHELP the TAGFILES option should only contain destinations "
            "with https / http addresses (not: {}). I'll adjust it for you.\n",s);
      }
    }
    Config_updateList(TAGFILES,filteredTagFileList);
  }

  // check for settings that are inconsistent with having INLINE_GROUPED_CLASSES enabled
  if (Config_getBool(INLINE_GROUPED_CLASSES))
  {
    const char *depOption = "INLINE_GROUPED_CLASSES";
    adjustBoolSetting(depOption, "SEPARATE_MEMBER_PAGES", false);
  }

  //------------------------
  // clip number of threads
  int dotNumThreads = Config_getInt(DOT_NUM_THREADS);
  if (dotNumThreads>32)
  {
    dotNumThreads=32;
  }
  else if (dotNumThreads<=0)
  {
    dotNumThreads=std::max(2u,std::thread::hardware_concurrency()+1);
  }
  Config_updateInt(DOT_NUM_THREADS,dotNumThreads);

  //------------------------
  // check plantuml path
  QCString plantumlJarPath = Config_getString(PLANTUML_JAR_PATH);
  if (!plantumlJarPath.isEmpty())
  {
    FileInfo pu(plantumlJarPath.str());
    if (pu.exists() && pu.isDir()) // PLANTUML_JAR_PATH is directory
    {
      QCString plantumlJar = plantumlJarPath+Portable::pathSeparator()+"plantuml.jar";
      FileInfo jar(plantumlJar.str());
      if (jar.exists() && jar.isFile())
      {
        plantumlJarPath = plantumlJar;
      }
      else
      {
        err("Jar file 'plantuml.jar' not found at location specified via PLANTUML_JAR_PATH: '{}'\n",plantumlJarPath);
        plantumlJarPath="";
      }
    }
    else if (pu.exists() && pu.isFile()) // PLANTUML_JAR_PATH is file
    {
      // Nothing to be done
    }
    else
    {
      err("PLANTUML_JAR_PATH is not a directory with a 'plantuml.jar' file or is not an existing file: {}\n",plantumlJarPath);
      plantumlJarPath="";
    }
    Config_updateString(PLANTUML_JAR_PATH,plantumlJarPath);
  }

  //------------------------
  // check dia path
  QCString diaPath = Config_getString(DIA_PATH);
  if (!diaPath.isEmpty())
  {
    QCString diaExe = diaPath+"/dia"+Portable::commandExtension();
    FileInfo dp(diaExe.str());
    if (!dp.exists() || !dp.isFile())
    {
      warn_uncond("dia could not be found at {}\n",diaPath);
      diaPath="";
    }
    else
    {
      diaPath=dp.dirPath(TRUE)+"/";
#if defined(_WIN32) // convert slashes
      size_t i=0,l=diaPath.length();
      for (i=0;i<l;i++) if (diaPath.at(i)=='/') diaPath.at(i)='\\';
#endif
    }
    Config_updateString(DIA_PATH,diaPath);
  }

  //------------------------
  // check INPUT
  StringVector inputSources=Config_getList(INPUT);
  if (inputSources.empty())
  {
    // use current dir as the default
    inputSources.push_back(Dir::currentDirPath());
  }
  else
  {
    for (const auto &s : inputSources)
    {
      FileInfo fi(s.c_str());
      if (!fi.exists())
      {
        warn_uncond("tag INPUT: input source '{}' does not exist\n",s);
      }
    }
  }
  Config_updateList(INPUT,inputSources);

  //------------------------
  // if no output format is enabled, warn the user
  if (!Config_getBool(GENERATE_HTML)    &&
      !Config_getBool(GENERATE_LATEX)   &&
      !Config_getBool(GENERATE_MAN)     &&
      !Config_getBool(GENERATE_RTF)     &&
      !Config_getBool(GENERATE_XML)     &&
      !Config_getBool(GENERATE_PERLMOD) &&
      !Config_getBool(GENERATE_RTF)     &&
      !Config_getBool(GENERATE_DOCBOOK) &&
      !Config_getBool(GENERATE_AUTOGEN_DEF) &&
      Config_getString(GENERATE_TAGFILE).isEmpty()
     )
  {
    warn_uncond("No output formats selected! Set at least one of the main GENERATE_* options to YES.\n");
  }

  //------------------------
  // check HTMLHELP creation requirements
  if (!Config_getBool(GENERATE_HTML) &&
      Config_getBool(GENERATE_HTMLHELP))
  {
    warn_uncond("GENERATE_HTMLHELP=YES requires GENERATE_HTML=YES.\n");
  }

  //------------------------
  // check sitemap creation requirements
  if (!Config_getBool(GENERATE_HTML) &&
      !Config_getString(SITEMAP_URL).isEmpty())
  {
    warn_uncond("Setting SITEMAP_URL requires GENERATE_HTML=YES.\n");
  }

  //------------------------
  // check QHP creation requirements
  if (Config_getBool(GENERATE_QHP))
  {
    if (!Config_getBool(GENERATE_HTML))
    {
      warn_uncond("GENERATE_QHP=YES requires GENERATE_HTML=YES.\n");
    }
    if (Config_getString(QHP_NAMESPACE).isEmpty())
    {
      err("GENERATE_QHP=YES requires QHP_NAMESPACE to be set. Using 'org.doxygen.doc' as default!.\n");
      Config_updateString(QHP_NAMESPACE,"org.doxygen.doc");
    }

    if (Config_getString(QHP_VIRTUAL_FOLDER).isEmpty())
    {
      err("GENERATE_QHP=YES requires QHP_VIRTUAL_FOLDER to be set. Using 'doc' as default!\n");
      Config_updateString(QHP_VIRTUAL_FOLDER,"doc");
    }
    const StringVector &tagFileList = Config_getList(TAGFILES);
    if (!tagFileList.empty())
    {
      err("When enabling GENERATE_QHP the TAGFILES option should be empty. I'll adjust it for you.\n");
      Config_updateList(TAGFILES,StringVector());
    }
  }

  //------------------------
  if (Config_getBool(OPTIMIZE_OUTPUT_JAVA) && Config_getBool(INLINE_INFO))
  {
    // don't show inline info for Java output, since Java has no inline
    // concept.
    Config_updateBool(INLINE_INFO,FALSE);
  }

  //------------------------
  int depth = Config_getInt(MAX_DOT_GRAPH_DEPTH);
  if (depth==0)
  {
    Config_updateInt(MAX_DOT_GRAPH_DEPTH,1000);
  }

  //------------------------
  if (Config_getBool(INTERACTIVE_SVG))
  {
    // issue 11308
    if ((Config_getEnum(DOT_IMAGE_FORMAT) == DOT_IMAGE_FORMAT_t::svg_cairo) ||
        (Config_getEnum(DOT_IMAGE_FORMAT) == DOT_IMAGE_FORMAT_t::svg_cairo_cairo))
    {
      err("When using DOT_IMAGE_FORMAT with {} the INTERACTIVE_SVG option should be disabled. I'll adjust it for you.\n",
          Config_getEnumAsString(DOT_IMAGE_FORMAT));
      Config_updateBool(INTERACTIVE_SVG,FALSE);
    }
  }

  //------------------------
  // check for settings that are inconsistent with having OPTIMIZED_OUTPUT_VHDL enabled
  if (Config_getBool(OPTIMIZE_OUTPUT_VHDL))
  {
    const char *depOption = "OPTIMIZE_OUTPUT_VHDL";
    adjustBoolSetting(depOption,"INLINE_INHERITED_MEMB",false);
    adjustBoolSetting(depOption,"INHERIT_DOCS",         false);
    adjustBoolSetting(depOption,"HIDE_SCOPE_NAMES",     true );
    adjustBoolSetting(depOption,"EXTRACT_PRIVATE",      true );
    adjustBoolSetting(depOption,"ENABLE_PREPROCESSING", false);
    adjustBoolSetting(depOption,"EXTRACT_PACKAGE",      true );
  }

  if (!checkFileName(Config_getString(GENERATE_TAGFILE),"GENERATE_TAGFILE"))
  {
    Config_updateString(GENERATE_TAGFILE,"");
  }

#if 0 // TODO: this breaks test 25; SOURCEBROWSER = NO and SOURCE_TOOLTIPS = YES.
      // So this and other regressions should be analyzed and fixed before this can be enabled
  // disable any boolean options that depend on disabled options
  for (const auto &option : m_options)
  {
    QCString depName = option->dependsOn(); // option has a dependency
    if (!depName.isEmpty())
    {
      ConfigOption * dep = Config::instance()->get(depName);
      if (dep->kind()==ConfigOption::O_Bool &&
          ConfigImpl_getBool("depName")==FALSE) // dependent option is disabled
      {
        if (option->kind()==ConfigOption::O_Bool)
        {
          printf("disabling option %s\n",qPrint(option->name()));
          ConfigImpl_getBool("option->name("))=FALSE; // also disable this option
        }
      }
    }
  }
#endif

}

static void updateAttribute(DotAttributes& attr, QCString name, ConfigObsolete* value)
{
  attr.updateValue(name,*value->valueStringRef());
}

void Config::updateObsolete()
{
  //------------------------
  // check for presence of obsolete CLASS_DIAGRAM option and correct CLASS_GRAPH if needed
  ConfigOption *classDiagramsOpt = ConfigImpl::instance()->get("CLASS_DIAGRAMS");
  ConfigOption *haveDotOpt       = ConfigImpl::instance()->get("HAVE_DOT");
  ConfigOption *classGraphOpt    = ConfigImpl::instance()->get("CLASS_GRAPH");
  if (classDiagramsOpt && classDiagramsOpt->kind()==ConfigOption::O_Obsolete &&
      haveDotOpt && classGraphOpt)
  {
    ConfigObsolete *classDiagramsOpt_ = dynamic_cast<ConfigObsolete*>(classDiagramsOpt);
    ConfigBool     *haveDotOpt_       = dynamic_cast<ConfigBool*>(haveDotOpt);
    ConfigEnum     *classGraphOpt_    = dynamic_cast<ConfigEnum*>(classGraphOpt);
    if (classDiagramsOpt_ && haveDotOpt_ && classGraphOpt_ &&
        classDiagramsOpt_->isPresent() && classDiagramsOpt_->orgType()==ConfigOption::O_Bool)
    {
      QCString classDiagramValue = *classDiagramsOpt_->valueStringRef();
      QCString haveDotValue      = *haveDotOpt_->valueStringRef();
      QCString &classGraphValue  = *classGraphOpt_->valueRef();
      bool isValid1=true, isValid2=true;
      bool bClassDiagrams = convertStringToBool(classDiagramValue,isValid1);
      bool bHaveDot       = haveDotValue.isEmpty() ? false : convertStringToBool(haveDotValue,     isValid2);
      if (isValid1 && isValid2 && !bClassDiagrams && !bHaveDot && classGraphValue.lower()=="yes")
      {
        warn_uncond("Changing CLASS_GRAPH option to TEXT because obsolete option CLASS_DIAGRAM was found and set to NO.\n");
        classGraphValue="TEXT";
      }
    }
  }

  // update TIMESTAMP based on HTML_TIMESTAMP and LATEX_TIMESTAMP
  ConfigOption *HtmlTimestamp = ConfigImpl::instance()->get("HTML_TIMESTAMP");
  ConfigOption *timestampOpt    = ConfigImpl::instance()->get("TIMESTAMP");
  bool reset = false;
  if (HtmlTimestamp && HtmlTimestamp->kind()==ConfigOption::O_Obsolete && timestampOpt)
  {
    ConfigObsolete *htmlTimestamp_ = dynamic_cast<ConfigObsolete*>(HtmlTimestamp);
    ConfigEnum     *timestampOpt_ = dynamic_cast<ConfigEnum*>(timestampOpt);
    if (htmlTimestamp_ && timestampOpt_ &&
        htmlTimestamp_->isPresent() && htmlTimestamp_->orgType()==ConfigOption::O_Bool)
    {
      QCString &timestampValue  = *timestampOpt_->valueRef();
      QCString htmlTimestampValue = *htmlTimestamp_->valueStringRef();
      bool isValid=true;
      bool bTimestamp = convertStringToBool(htmlTimestampValue,isValid);
      if (isValid && bTimestamp)
      {
        reset = true;
        timestampValue = "YES";
      }
    }
  }
  ConfigOption *LatexTimestamp = ConfigImpl::instance()->get("LATEX_TIMESTAMP");
  if (!reset && LatexTimestamp && LatexTimestamp->kind()==ConfigOption::O_Obsolete && timestampOpt)
  {
    ConfigObsolete *latexTimestamp_ = dynamic_cast<ConfigObsolete*>(LatexTimestamp);
    ConfigEnum     *timestampOpt_ = dynamic_cast<ConfigEnum*>(timestampOpt);
    if (latexTimestamp_ && timestampOpt_ &&
        latexTimestamp_->isPresent() && latexTimestamp_->orgType()==ConfigOption::O_Bool)
    {
      QCString &timestampValue  = *timestampOpt_->valueRef();
      QCString latexTimestampValue = *latexTimestamp_->valueStringRef();
      bool isValid=true;
      bool bTimestamp = convertStringToBool(latexTimestampValue,isValid);
      if (isValid && bTimestamp) timestampValue = "YES";
    }
  }

  auto fontname = dynamic_cast<ConfigObsolete*>(ConfigImpl::instance()->get("DOT_FONTNAME"));
  auto fontsize = dynamic_cast<ConfigObsolete*>(ConfigImpl::instance()->get("DOT_FONTSIZE"));

  // correct DOT_FONTNAME if needed
  if (fontname &&
      (*fontname->valueStringRef() == "FreeSans"
      || *fontname->valueStringRef() == "FreeSans.ttf"))
    warn_uncond("doxygen no longer ships with the FreeSans font.\n"
               "  You may want to clear or change DOT_FONTNAME.\n"
               "  Otherwise you run the risk that the wrong font is being used for dot generated graphs.\n");

  auto commonAttrOpt = dynamic_cast<ConfigString*>(ConfigImpl::instance()->get("DOT_COMMON_ATTR"));
  if (commonAttrOpt)
  {
    QCString& commonAttrStr = *commonAttrOpt->valueRef();
    DotAttributes commonAttr(commonAttrStr);
    updateAttribute(commonAttr, "fontname", fontname);
    updateAttribute(commonAttr, "fontsize", fontsize);
    commonAttrStr = commonAttr.str();
  }

  auto edgeAttrOpt = dynamic_cast<ConfigString*>(ConfigImpl::instance()->get("DOT_EDGE_ATTR"));
  if (edgeAttrOpt)
  {
    QCString& edgeAttrStr = *edgeAttrOpt->valueRef();
    DotAttributes edgeAttr(edgeAttrStr);
    updateAttribute(edgeAttr, "labelfontname", fontname);
    updateAttribute(edgeAttr, "labelfontsize", fontsize);
    edgeAttrStr = edgeAttr.str();
  }
}

void Config::writeTemplate(TextStream &t,bool shortList,bool update)
{
  ConfigImpl::instance()->writeTemplate(t,shortList,update);
}

void Config::compareDoxyfile(TextStream &t,Config::CompareMode compareMode)
{
  postProcess(FALSE, compareMode);
  ConfigImpl::instance()->compareDoxyfile(t, compareMode);
}

void Config::writeXMLDoxyfile(TextStream &t)
{
  ConfigImpl::instance()->writeXMLDoxyfile(t);
}

void Config::writeXSDDoxyfile(TextStream &t)
{
  ConfigImpl::instance()->writeXSDDoxyfile(t);
}

bool Config::parse(const QCString &fileName,bool update, Config::CompareMode compareMode)
{
  g_compareMode = compareMode;
  bool parseRes = ConfigImpl::instance()->parse(fileName,update);
  if (!parseRes) return parseRes;

  // Internally we use the default format UTF-8 and
  // when updating etc. the output is in this format as well and not in the read format
  ConfigString *option = dynamic_cast<ConfigString*>(g_config->get("DOXYFILE_ENCODING"));
  option->init();

  return parseRes;
}

void Config::postProcess(bool clearHeaderAndFooter, Config::CompareMode compareMode)
{
  auto configInst = ConfigImpl::instance();
  if (compareMode != CompareMode::CompressedNoEnv) configInst->substituteEnvironmentVars();
  if (compareMode == CompareMode::Full)            configInst->emptyValueToDefault();
  configInst->convertStrToVal(compareMode);

  // avoid bootstrapping issues when the g_config file already
  // refers to the files that we are supposed to parse.
  if (clearHeaderAndFooter)
  {
    Config_updateString(HTML_HEADER ,"");
    Config_updateString(HTML_FOOTER ,"");
    Config_updateString(LATEX_HEADER,"");
    Config_updateString(LATEX_FOOTER,"");
  }
}

void Config::deinit()
{
  ConfigImpl::instance()->deleteInstance();
}

#include "configimpl.l.h"

