// This file is generated by kconfig_compiler_kf6 from easyeffects_db_maximizer.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_MAXIMIZER_H
#define DB_MAXIMIZER_H

#include <kconfig_base_ee.hpp>

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace db {

class Maximizer : public KConfigBaseEE
{
  Q_OBJECT
  public:

    Maximizer( const QString & masterGroup, const QString & instanceIndex );
    ~Maximizer() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set release
    */
    void setRelease( double v )
    {
      if (v < 1)
      {
        qDebug() << "setRelease: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 100)
      {
        qDebug() << "setRelease: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (v != mRelease && !isReleaseImmutable()) {
        mRelease = v;
        Q_EMIT releaseChanged();
      }
    }

    Q_PROPERTY(double release READ release WRITE setRelease NOTIFY releaseChanged)
    Q_PROPERTY(bool isReleaseImmutable READ isReleaseImmutable CONSTANT)
    Q_PROPERTY(double defaultReleaseValue READ defaultReleaseValue CONSTANT)
    /**
      Get release
    */
    double release() const
    {
      return mRelease;
    }

    /**
      Is release Immutable
    */
    bool isReleaseImmutable() const
    {
      return isImmutable( QStringLiteral( "release" ) );
    }

    /**
      Get release default value
    */
    double defaultReleaseValue() const
    {
        return defaultReleaseValue_helper();
    }

    /**
      Set threshold
    */
    void setThreshold( double v )
    {
      if (v < -30)
      {
        qDebug() << "setThreshold: value " << v << " is less than the minimum value of -30";
        v = -30;
      }

      if (v > 0)
      {
        qDebug() << "setThreshold: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mThreshold && !isThresholdImmutable()) {
        mThreshold = v;
        Q_EMIT thresholdChanged();
      }
    }

    Q_PROPERTY(double threshold READ threshold WRITE setThreshold NOTIFY thresholdChanged)
    Q_PROPERTY(bool isThresholdImmutable READ isThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultThresholdValue READ defaultThresholdValue CONSTANT)
    /**
      Get threshold
    */
    double threshold() const
    {
      return mThreshold;
    }

    /**
      Is threshold Immutable
    */
    bool isThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "threshold" ) );
    }

    /**
      Get threshold default value
    */
    double defaultThresholdValue() const
    {
        return defaultThresholdValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalReleaseChanged = 4,
      signalThresholdChanged = 5
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void releaseChanged();

    void thresholdChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // Maximizer#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    double mRelease;
    double defaultReleaseValue_helper() const;
    double mThreshold;
    double defaultThresholdValue_helper() const;

  private:
};

}

#endif

