// This file is generated by kconfig_compiler_kf6 from easyeffects_db_rnnoise.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_RNNOISE_H
#define DB_RNNOISE_H

#include "kconfig_base_ee.hpp"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace db {

class RNNoise : public KConfigBaseEE
{
  Q_OBJECT
  public:

    RNNoise( const QString & masterGroup, const QString & instanceIndex );
    ~RNNoise() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set modelName
    */
    void setModelName( const QString & v )
    {
      if (v != mModelName && !isModelNameImmutable()) {
        mModelName = v;
        Q_EMIT modelNameChanged();
      }
    }

    Q_PROPERTY(QString modelName READ modelName WRITE setModelName NOTIFY modelNameChanged)
    Q_PROPERTY(bool isModelNameImmutable READ isModelNameImmutable CONSTANT)
    Q_PROPERTY(QString defaultModelNameValue READ defaultModelNameValue CONSTANT)
    /**
      Get modelName
    */
    QString modelName() const
    {
      return mModelName;
    }

    /**
      Is modelName Immutable
    */
    bool isModelNameImmutable() const
    {
      return isImmutable( QStringLiteral( "modelName" ) );
    }

    /**
      Get modelName default value
    */
    QString defaultModelNameValue() const
    {
        return defaultModelNameValue_helper();
    }

    /**
      Set useStandardModel
    */
    void setUseStandardModel( bool v )
    {
      if (v != mUseStandardModel && !isUseStandardModelImmutable()) {
        mUseStandardModel = v;
        Q_EMIT useStandardModelChanged();
      }
    }

    Q_PROPERTY(bool useStandardModel READ useStandardModel WRITE setUseStandardModel NOTIFY useStandardModelChanged)
    Q_PROPERTY(bool isUseStandardModelImmutable READ isUseStandardModelImmutable CONSTANT)
    Q_PROPERTY(bool defaultUseStandardModelValue READ defaultUseStandardModelValue CONSTANT)
    /**
      Get useStandardModel
    */
    bool useStandardModel() const
    {
      return mUseStandardModel;
    }

    /**
      Is useStandardModel Immutable
    */
    bool isUseStandardModelImmutable() const
    {
      return isImmutable( QStringLiteral( "useStandardModel" ) );
    }

    /**
      Get useStandardModel default value
    */
    bool defaultUseStandardModelValue() const
    {
        return defaultUseStandardModelValue_helper();
    }

    /**
      Set enableVad
    */
    void setEnableVad( bool v )
    {
      if (v != mEnableVad && !isEnableVadImmutable()) {
        mEnableVad = v;
        Q_EMIT enableVadChanged();
      }
    }

    Q_PROPERTY(bool enableVad READ enableVad WRITE setEnableVad NOTIFY enableVadChanged)
    Q_PROPERTY(bool isEnableVadImmutable READ isEnableVadImmutable CONSTANT)
    Q_PROPERTY(bool defaultEnableVadValue READ defaultEnableVadValue CONSTANT)
    /**
      Get enableVad
    */
    bool enableVad() const
    {
      return mEnableVad;
    }

    /**
      Is enableVad Immutable
    */
    bool isEnableVadImmutable() const
    {
      return isImmutable( QStringLiteral( "enableVad" ) );
    }

    /**
      Get enableVad default value
    */
    bool defaultEnableVadValue() const
    {
        return defaultEnableVadValue_helper();
    }

    /**
      Set vadThres
    */
    void setVadThres( double v )
    {
      if (v < 0)
      {
        qDebug() << "setVadThres: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 100)
      {
        qDebug() << "setVadThres: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (v != mVadThres && !isVadThresImmutable()) {
        mVadThres = v;
        Q_EMIT vadThresChanged();
      }
    }

    Q_PROPERTY(double vadThres READ vadThres WRITE setVadThres NOTIFY vadThresChanged)
    Q_PROPERTY(bool isVadThresImmutable READ isVadThresImmutable CONSTANT)
    Q_PROPERTY(double defaultVadThresValue READ defaultVadThresValue CONSTANT)
    /**
      Get vadThres
    */
    double vadThres() const
    {
      return mVadThres;
    }

    /**
      Is vadThres Immutable
    */
    bool isVadThresImmutable() const
    {
      return isImmutable( QStringLiteral( "vadThres" ) );
    }

    /**
      Get vadThres default value
    */
    double defaultVadThresValue() const
    {
        return defaultVadThresValue_helper();
    }

    /**
      Set wet
    */
    void setWet( double v )
    {
      if (v < -100)
      {
        qDebug() << "setWet: value " << v << " is less than the minimum value of -100";
        v = -100;
      }

      if (v > 20)
      {
        qDebug() << "setWet: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mWet && !isWetImmutable()) {
        mWet = v;
        Q_EMIT wetChanged();
      }
    }

    Q_PROPERTY(double wet READ wet WRITE setWet NOTIFY wetChanged)
    Q_PROPERTY(bool isWetImmutable READ isWetImmutable CONSTANT)
    Q_PROPERTY(double defaultWetValue READ defaultWetValue CONSTANT)
    /**
      Get wet
    */
    double wet() const
    {
      return mWet;
    }

    /**
      Is wet Immutable
    */
    bool isWetImmutable() const
    {
      return isImmutable( QStringLiteral( "wet" ) );
    }

    /**
      Get wet default value
    */
    double defaultWetValue() const
    {
        return defaultWetValue_helper();
    }

    /**
      Set release
    */
    void setRelease( double v )
    {
      if (v < 0)
      {
        qDebug() << "setRelease: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 20000)
      {
        qDebug() << "setRelease: value " << v << " is greater than the maximum value of 20000";
        v = 20000;
      }

      if (v != mRelease && !isReleaseImmutable()) {
        mRelease = v;
        Q_EMIT releaseChanged();
      }
    }

    Q_PROPERTY(double release READ release WRITE setRelease NOTIFY releaseChanged)
    Q_PROPERTY(bool isReleaseImmutable READ isReleaseImmutable CONSTANT)
    Q_PROPERTY(double defaultReleaseValue READ defaultReleaseValue CONSTANT)
    /**
      Get release
    */
    double release() const
    {
      return mRelease;
    }

    /**
      Is release Immutable
    */
    bool isReleaseImmutable() const
    {
      return isImmutable( QStringLiteral( "release" ) );
    }

    /**
      Get release default value
    */
    double defaultReleaseValue() const
    {
        return defaultReleaseValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalModelNameChanged = 4,
      signalUseStandardModelChanged = 5,
      signalEnableVadChanged = 6,
      signalVadThresChanged = 7,
      signalWetChanged = 8,
      signalReleaseChanged = 9
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void modelNameChanged();

    void useStandardModelChanged();

    void enableVadChanged();

    void vadThresChanged();

    void wetChanged();

    void releaseChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // RNNoise#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    QString mModelName;
    QString defaultModelNameValue_helper() const;
    bool mUseStandardModel;
    bool defaultUseStandardModelValue_helper() const;
    bool mEnableVad;
    bool defaultEnableVadValue_helper() const;
    double mVadThres;
    double defaultVadThresValue_helper() const;
    double mWet;
    double defaultWetValue_helper() const;
    double mRelease;
    double defaultReleaseValue_helper() const;
};

}

#endif

