/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  Anonymous236,
  Anonymous085,
  Anonymous376,
  ExtensionPolicy,
  Anonymous033,
  Anonymous156,
  Anonymous168,
  Anonymous353,
  Anonymous407,
  Anonymous056,
  Anonymous129,
  Anonymous428,
  Anonymous080,
  Anonymous294,
  PlacesPreviewsHelper,
  Anonymous079,
  Anonymous302,
  Anonymous073,
  Anonymous364,
  Anonymous257,
  Anonymous057,
  Anonymous180,
  Anonymous412,
  Anonymous329,
  Anonymous446,
  Anonymous130,
  Anonymous355,
  Anonymous013,
  Anonymous146,
  Anonymous211,
  Anonymous071,
  Anonymous002,
  Anonymous151,
  Anonymous395,
  Anonymous441,
  Anonymous400,
  Anonymous162,
  Anonymous178,
  Observer,
  Anonymous083,
  Anonymous442,
  Anonymous332,
  Anonymous293,
  Anonymous047,
  Anonymous457,
  IdentityCredentialPromptService,
  Predictor,
  Anonymous299,
  ContentSecurityManager,
  Anonymous096,
  Anonymous176,
  Anonymous099,
  Anonymous023,
  Anonymous237,
  Anonymous367,
  Anonymous331,
  Anonymous403,
  Anonymous316,
  Anonymous027,
  Anonymous343,
  Anonymous116,
  Anonymous184,
  Anonymous241,
  Anonymous432,
  Anonymous064,
  Anonymous109,
  Anonymous276,
  Anonymous280,
  Anonymous291,
  Anonymous234,
  Anonymous366,
  Anonymous239,
  Anonymous198,
  Anonymous262,
  Anonymous134,
  XULRuntime,
  Locale,
  Anonymous032,
  Anonymous231,
  Anonymous333,
  CookieBannerService,
  Anonymous399,
  Anonymous419,
  Anonymous434,
  Anonymous124,
  AsyncShutdown,
  Anonymous268,
  StringBundle,
  Anonymous000,
  Anonymous378,
  Anonymous025,
  Anonymous190,
  Anonymous133,
  Anonymous282,
  Anonymous090,
  Anonymous199,
  Anonymous015,
  Anonymous383,
  Anonymous258,
  Anonymous225,
  GfxInfo,
  IDN,
  Anonymous338,
  Anonymous183,
  UrlClassifierUtils,
  Anonymous287,
  Anonymous393,
  Anonymous340,
  Anonymous200,
  Anonymous370,
  Anonymous053,
  Anonymous379,
  Anonymous272,
  Anonymous290,
  Anonymous307,
  Anonymous143,
  Anonymous361,
  Anonymous409,
  Anonymous172,
  DownloadPlatform,
  Anonymous112,
  Anonymous444,
  Anonymous008,
  Anonymous117,
  Anonymous235,
  CategoryManager,
  Anonymous005,
  Anonymous405,
  Anonymous264,
  Anonymous045,
  Anonymous334,
  Anonymous043,
  Anonymous374,
  Anonymous384,
  Anonymous390,
  Anonymous044,
  Anonymous204,
  Anonymous191,
  Anonymous372,
  Anonymous217,
  Anonymous010,
  Console,
  Anonymous396,
  Anonymous271,
  Anonymous149,
  Anonymous084,
  Anonymous408,
  Anonymous036,
  Anonymous253,
  Anonymous065,
  Anonymous365,
  Anonymous171,
  Anonymous122,
  Anonymous314,
  AddonContentPolicy,
  Anonymous255,
  Anonymous249,
  Anonymous185,
  Anonymous246,
  Anonymous391,
  Anonymous230,
  Anonymous326,
  CORSPreflightCache,
  Anonymous196,
  History,
  Anonymous362,
  Anonymous279,
  Anonymous328,
  DocLoader,
  AlertNotification,
  Anonymous459,
  Anonymous082,
  Anonymous158,
  Anonymous389,
  Anonymous210,
  Anonymous059,
  Anonymous078,
  Anonymous455,
  Anonymous140,
  WifiMonitor,
  Anonymous131,
  Anonymous426,
  Anonymous197,
  Anonymous218,
  Anonymous081,
  Anonymous288,
  Anonymous228,
  Anonymous060,
  Anonymous324,
  Anonymous300,
  Anonymous402,
  Anonymous153,
  Anonymous024,
  Anonymous166,
  Anonymous061,
  Anonymous274,
  Anonymous179,
  Anonymous147,
  Anonymous223,
  Anonymous330,
  Anonymous003,
  PageThumbsStorage,
  Anonymous219,
  Anonymous072,
  Anonymous050,
  EffectiveTLD,
  Anonymous386,
  Anonymous173,
  Anonymous347,
  Anonymous018,
  Anonymous373,
  URLQueryStringStripper,
  Anonymous034,
  Anonymous297,
  Anonymous263,
  Anonymous335,
  Anonymous448,
  Anonymous232,
  Anonymous165,
  Anonymous281,
  Anonymous308,
  Anonymous101,
  Anonymous286,
  Anonymous415,
  Anonymous004,
  ChromeRegistry,
  Anonymous447,
  Anonymous266,
  Anonymous216,
  Anonymous001,
  Anonymous111,
  Anonymous352,
  HttpActivityDistributor,
  Anonymous049,
  Anonymous206,
  Anonymous397,
  Anonymous169,
  Anonymous092,
  Anonymous252,
  Anonymous265,
  Prefetch,
  Anonymous385,
  StreamTransport,
  PermissionManager,
  Anonymous086,
  Anonymous030,
  Anonymous189,
  Anonymous174,
  Anonymous406,
  Anonymous106,
  Anonymous244,
  Anonymous213,
  Anonymous320,
  Anonymous410,
  Anonymous242,
  Anonymous357,
  Anonymous285,
  Anonymous222,
  Anonymous401,
  Anonymous021,
  Anonymous227,
  SocketTransport,
  Anonymous212,
  Anonymous349,
  Anonymous118,
  Anonymous038,
  Anonymous413,
  Anonymous259,
  Anonymous138,
  Anonymous145,
  Anonymous094,
  Anonymous192,
  Anonymous014,
  CaptivePortal,
  Anonymous160,
  Anonymous170,
  Anonymous278,
  Anonymous207,
  Anonymous037,
  Anonymous256,
  FindService,
  Anonymous301,
  AppStartup,
  Anonymous229,
  ThirdPartyUtil,
  Anonymous205,
  Anonymous269,
  Anonymous098,
  StreamConverter,
  Anonymous318,
  TypeAheadFind,
  Anonymous317,
  Anonymous453,
  Anonymous181,
  Anonymous417,
  Anonymous201,
  PrivateAttribution,
  Anonymous431,
  Anonymous254,
  Anonymous188,
  Anonymous110,
  ScriptSecurityManager,
  Anonymous020,
  Anonymous440,
  NetworkErrorLogging,
  Anonymous351,
  Anonymous067,
  Anonymous119,
  DBusHandlerApp,
  Anonymous028,
  Anonymous460,
  Anonymous040,
  Anonymous120,
  Anonymous292,
  Anonymous247,
  Anonymous062,
  Anonymous388,
  Anonymous202,
  UrlClassifierPrefixSet,
  Anonymous416,
  Anonymous250,
  Anonymous088,
  Anonymous226,
  Anonymous311,
  Anonymous377,
  Anonymous382,
  Anonymous141,
  NSSCertificateDB,
  Anonymous322,
  Anonymous392,
  Anonymous315,
  Anonymous051,
  Anonymous380,
  MimeHeaderParam,
  Anonymous354,
  Anonymous283,
  Anonymous325,
  DNS,
  Anonymous261,
  Anonymous224,
  ApplicationReputation,
  ProtocolProxy,
  Anonymous074,
  Anonymous007,
  Anonymous026,
  BounceTrackingProtection,
  Anonymous270,
  Anonymous450,
  UrlClassifierDB,
  Anonymous309,
  Anonymous055,
  Anonymous221,
  ServiceWorkerManager,
  CacheStorage,
  Anonymous144,
  Anonymous182,
  Anonymous284,
  Anonymous435,
  Anonymous108,
  Anonymous304,
  Anonymous203,
  Anonymous095,
  Anonymous458,
  Anonymous019,
  Anonymous113,
  Anonymous433,
  CredentialChooserService,
  Anonymous163,
  Anonymous012,
  URILoader,
  Anonymous087,
  Anonymous161,
  WindowWatcher,
  Anonymous097,
  Anonymous337,
  Anonymous091,
  Anonymous035,
  URIFixup,
  Anonymous105,
  IO,
  Anonymous104,
  Anonymous454,
  Anonymous321,
  Anonymous058,
  Anonymous066,
  TextToSubURI,
  Anonymous414,
  Anonymous422,
  Anonymous323,
  Anonymous215,
  Anonymous394,
  Anonymous052,
  Preferences,
  Anonymous251,
  Anonymous313,
  Anonymous359,
  NSSErrors,
  Anonymous148,
  Anonymous115,
  Anonymous157,
  Anonymous152,
  Anonymous445,
  Anonymous339,
  UrlClassifierStreamUpdater,
  Anonymous136,
  Anonymous295,
  Anonymous100,
  Anonymous194,
  NSSComponent,
  Anonymous069,
  Anonymous102,
  Anonymous075,
  Anonymous411,
  Anonymous029,
  Dashboard,
  Anonymous436,
  Anonymous063,
  Anonymous289,
  AuthPromptAdapter,
  Anonymous070,
  Anonymous341,
  Anonymous277,
  IdentityCredentialStorageService,
  Anonymous177,
  Anonymous363,
  Anonymous048,
  Anonymous121,
  Anonymous132,
  Anonymous041,
  Anonymous139,
  Anonymous154,
  Anonymous187,
  Anonymous193,
  Anonymous068,
  Anonymous451,
  Anonymous371,
  Anonymous381,
  Anonymous398,
  Anonymous427,
  HttpHandler,
  Anonymous208,
  Anonymous233,
  Anonymous273,
  Anonymous439,
  Anonymous456,
  Anonymous275,
  Anonymous006,
  Anonymous142,
  Anonymous103,
  Anonymous310,
  Anonymous016,
  RandomGenerator,
  FileProtocolHandler,
  Anonymous125,
  Anonymous126,
  Anonymous011,
  Anonymous437,
  SystemInfo,
  Anonymous186,
  Anonymous238,
  Anonymous128,
  Anonymous356,
  Anonymous089,
  Anonymous375,
  Alerts,
  Anonymous305,
  Anonymous164,
  SiteSecurity,
  Anonymous167,
  Anonymous245,
  ExternalProtocolHandler,
  Anonymous298,
  Anonymous344,
  Anonymous418,
  Anonymous017,
  Anonymous449,
  Anonymous346,
  Anonymous360,
  Anonymous424,
  Anonymous319,
  Anonymous159,
  Anonymous054,
  Anonymous123,
  Anonymous420,
  Anonymous421,
  Anonymous350,
  Anonymous404,
  Anonymous076,
  Anonymous342,
  Anonymous452,
  Anonymous429,
  Anonymous348,
  Anonymous443,
  Anonymous042,
  UrlClassifierTestUtils,
  Anonymous368,
  Anonymous387,
  Anonymous175,
  Anonymous127,
  Anonymous369,
  Anonymous260,
  Directory,
  Anonymous107,
  Anonymous303,
  nsIContentAnalysis,
  Anonymous327,
  Anonymous039,
  Anonymous425,
  Anonymous009,
  Anonymous267,
  Anonymous345,
  Anonymous022,
  Anonymous336,
  Anonymous114,
  Anonymous430,
  Anonymous312,
  Anonymous243,
  RFPService,
  Anonymous214,
  Anonymous031,
  Anonymous220,
  Anonymous248,
  Anonymous423,
  Anonymous209,
  Anonymous358,
  Anonymous077,
  Anonymous306,
  Anonymous093,
  Anonymous155,
  Anonymous438,
  Anonymous240,
  UUIDGenerator,
  Anonymous150,
  Anonymous137,
  Anonymous195,
  Anonymous046,
  Anonymous296,
  Anonymous135,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace AuthPromptAdapter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AuthPromptAdapter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}
}  // namespace AuthPromptAdapter

namespace BounceTrackingProtection {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::BounceTrackingProtection);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::BounceTrackingProtection, aRv};
}
}  // namespace BounceTrackingProtection

namespace CORSPreflightCache {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CORSPreflightCache);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CORSPreflightCache, aRv};
}
}  // namespace CORSPreflightCache

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace CaptivePortal {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CaptivePortal);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CaptivePortal, aRv};
}
}  // namespace CaptivePortal

namespace CategoryManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CategoryManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}
}  // namespace CategoryManager

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace Console {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Console);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}
}  // namespace Console

namespace ContentSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ContentSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}
}  // namespace ContentSecurityManager

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace CredentialChooserService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CredentialChooserService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}
}  // namespace CredentialChooserService

namespace DBusHandlerApp {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DBusHandlerApp);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DBusHandlerApp, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DBusHandlerApp, aRv};
}
}  // namespace DBusHandlerApp

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Dashboard {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Dashboard);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}
}  // namespace Dashboard

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace EffectiveTLD {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::EffectiveTLD);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::EffectiveTLD, aRv};
}
}  // namespace EffectiveTLD

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FileProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FileProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FileProtocolHandler, aRv};
}
}  // namespace FileProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace HttpHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpHandler, aRv};
}
}  // namespace HttpHandler

namespace IDN {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IDN);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}
}  // namespace IDN

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace Locale {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Locale);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Locale, aRv};
}
}  // namespace Locale

namespace MimeHeaderParam {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::MimeHeaderParam);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}
}  // namespace MimeHeaderParam

namespace NSSCertificateDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSCertificateDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}
}  // namespace NSSCertificateDB

namespace NSSComponent {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSComponent);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}
}  // namespace NSSComponent

namespace NSSErrors {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSErrors);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}
}  // namespace NSSErrors

namespace NetworkErrorLogging {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NetworkErrorLogging);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NetworkErrorLogging, aRv};
}
}  // namespace NetworkErrorLogging

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PageThumbsStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PageThumbsStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}
}  // namespace PageThumbsStorage

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace PlacesPreviewsHelper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PlacesPreviewsHelper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}
}  // namespace PlacesPreviewsHelper

namespace Predictor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Predictor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Predictor, aRv};
}
}  // namespace Predictor

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace PrivateAttribution {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PrivateAttribution);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}
}  // namespace PrivateAttribution

namespace ProtocolProxy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ProtocolProxy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ProtocolProxy, aRv};
}
}  // namespace ProtocolProxy

namespace RFPService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RFPService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RFPService, aRv};
}
}  // namespace RFPService

namespace RandomGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RandomGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}
}  // namespace RandomGenerator

namespace ScriptSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ScriptSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}
}  // namespace ScriptSecurityManager

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SiteSecurity {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SiteSecurity);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}
}  // namespace SiteSecurity

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamConverter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamConverter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}
}  // namespace StreamConverter

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace SystemInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SystemInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}
}  // namespace SystemInfo

namespace TextToSubURI {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TextToSubURI);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}
}  // namespace TextToSubURI

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierTestUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierTestUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierTestUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierTestUtils, aRv};
}
}  // namespace UrlClassifierTestUtils

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace WifiMonitor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WifiMonitor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WifiMonitor, aRv};
}
}  // namespace WifiMonitor

namespace WindowWatcher {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WindowWatcher);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}
}  // namespace WindowWatcher

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

namespace nsIContentAnalysis {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::nsIContentAnalysis);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}
}  // namespace nsIContentAnalysis

}  // namespace components

}  // namespace mozilla

#endif
