//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PFileSystemRequestChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/FileSystemTaskBase.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PFileSystemRequestChild::PFileSystemRequestChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PFileSystemRequestChild);
}

PFileSystemRequestChild::~PFileSystemRequestChild()
{
    MOZ_COUNT_DTOR(PFileSystemRequestChild);
}

auto PFileSystemRequestChild::ActorAlloc() -> void
{
    AddRef();
}

auto PFileSystemRequestChild::ActorDealloc() -> void
{
    Release();
}

auto PFileSystemRequestChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PFileSystemRequestChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PFileSystemRequestChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PFileSystemRequestChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PFileSystemRequestChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PFileSystemRequestChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PFileSystemRequestChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PFileSystemRequestChild::OnMessageReceived(const Message& msg__) -> PFileSystemRequestChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PFileSystemRequest::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemRequest", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemRequestChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemRequest::Msg___delete__", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__response = IPC::ReadParam<FileSystemResponseValue>((&(reader__)));
            if (!maybe__response) {
                FatalError("Error deserializing 'FileSystemResponseValue'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!(((&(reader__)))->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemResponseValue'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemTaskChildBase*>(this))->Recv__delete__(std::move(response));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PFileSystemRequestChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PFileSystemRequestChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PFileSystemRequestChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PFileSystemRequest'
    (aWriter)->WriteSentinel(1111557951);
}

auto ParamTraits<::mozilla::dom::PFileSystemRequestChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PFileSystemRequest actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PFileSystemRequest'
    if ((!((aReader)->ReadSentinel(1111557951)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PFileSystemRequest actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PFileSystemRequestMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PFileSystemRequest)");

        return {};
    }
    return static_cast<::mozilla::dom::PFileSystemRequestChild*>(actor);
}

} // namespace IPC
