/* THIS FILE IS AUTOGENERATED FROM StylePropertyMap.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_STYLEPROPERTYMAPBINDING_H_
#define DOM_STYLEPROPERTYMAPBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class CSSStyleValue;
struct NativePropertyHooks;
class OwningCSSStyleValueOrUTF8String;
class ProtoAndIfaceCache;
class StylePropertyMap;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningCSSStyleValueOrUTF8String& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningCSSStyleValueOrUTF8String& aUnion);


class CSSStyleValueOrUTF8String : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eCSSStyleValue,
    eUTF8String
  };
public:
  enum class Type
  {
    eCSSStyleValue = TypeOrUninit::eCSSStyleValue,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CSSStyleValue> > mCSSStyleValue;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  CSSStyleValueOrUTF8String(const CSSStyleValueOrUTF8String&) = delete;
  CSSStyleValueOrUTF8String& operator=(const CSSStyleValueOrUTF8String&) = delete;
public:
  explicit inline CSSStyleValueOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~CSSStyleValueOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CSSStyleValue>&
  RawSetAsCSSStyleValue()
  {
    if (mType == eCSSStyleValue) {
      return mValue.mCSSStyleValue.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCSSStyleValue;
    return mValue.mCSSStyleValue.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CSSStyleValue>&
  SetAsCSSStyleValue()
  {
    if (mType == eCSSStyleValue) {
      return mValue.mCSSStyleValue.Value();
    }
    Uninit();
    mType = eCSSStyleValue;
    return mValue.mCSSStyleValue.SetValue();
  }

  inline bool
  IsCSSStyleValue() const
  {
    return mType == eCSSStyleValue;
  }

  inline NonNull<mozilla::dom::CSSStyleValue>&
  GetAsCSSStyleValue()
  {
    MOZ_RELEASE_ASSERT(IsCSSStyleValue(), "Wrong type!");
    return mValue.mCSSStyleValue.Value();
  }

  inline mozilla::dom::CSSStyleValue&
  GetAsCSSStyleValue() const
  {
    MOZ_RELEASE_ASSERT(IsCSSStyleValue(), "Wrong type!");
    return mValue.mCSSStyleValue.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eCSSStyleValue: {
        DestroyCSSStyleValue();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCSSStyleValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCSSStyleValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCSSStyleValue()
  {
    MOZ_RELEASE_ASSERT(IsCSSStyleValue(), "Wrong type!");
    mValue.mCSSStyleValue.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};


class OwningCSSStyleValueOrUTF8String : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningCSSStyleValueOrUTF8String& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eCSSStyleValue,
    eUTF8String
  };
public:
  enum class Type
  {
    eCSSStyleValue = TypeOrUninit::eCSSStyleValue,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CSSStyleValue> > mCSSStyleValue;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningCSSStyleValueOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningCSSStyleValueOrUTF8String(OwningCSSStyleValueOrUTF8String&& aOther);

  explicit inline OwningCSSStyleValueOrUTF8String(const OwningCSSStyleValueOrUTF8String& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningCSSStyleValueOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CSSStyleValue>&
  RawSetAsCSSStyleValue();

  [[nodiscard]] OwningNonNull<mozilla::dom::CSSStyleValue>&
  SetAsCSSStyleValue();

  inline bool
  IsCSSStyleValue() const
  {
    return mType == eCSSStyleValue;
  }

  inline OwningNonNull<mozilla::dom::CSSStyleValue>&
  GetAsCSSStyleValue()
  {
    MOZ_RELEASE_ASSERT(IsCSSStyleValue(), "Wrong type!");
    return mValue.mCSSStyleValue.Value();
  }

  inline OwningNonNull<mozilla::dom::CSSStyleValue> const &
  GetAsCSSStyleValue() const
  {
    MOZ_RELEASE_ASSERT(IsCSSStyleValue(), "Wrong type!");
    return mValue.mCSSStyleValue.Value();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningCSSStyleValueOrUTF8String&
  operator=(OwningCSSStyleValueOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningCSSStyleValueOrUTF8String&
  operator=(const OwningCSSStyleValueOrUTF8String& aOther);

private:
  bool
  TrySetToCSSStyleValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCSSStyleValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCSSStyleValue();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};


namespace StylePropertyMap_Binding {

  typedef mozilla::dom::StylePropertyMap NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::StylePropertyMap* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::StylePropertyMap,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace StylePropertyMap_Binding



} // namespace mozilla::dom

#endif // DOM_STYLEPROPERTYMAPBINDING_H_
