//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/media/PMediaParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/media/MediaChild.h"

#include "mozilla/dom/PContentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace media {


MOZ_IMPLICIT PMediaParent::PMediaParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PMediaParent);
}

PMediaParent::~PMediaParent()
{
    MOZ_COUNT_DTOR(PMediaParent);
}

auto PMediaParent::ActorAlloc() -> void
{
}

auto PMediaParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PMediaParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PMediaParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PMediaParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PMediaParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PMediaParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PMediaParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PMediaParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PMediaParent::Send__delete__(PMediaParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PMedia::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PMedia", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMedia::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PMediaParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PMediaParent::OnMessageReceived(const Message& msg__) -> PMediaParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PMedia::Msg_GetPrincipalKey__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMedia", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMedia::Msg_GetPrincipalKey", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPrincipal = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__aPrincipal) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& aPrincipal = *maybe__aPrincipal;
            // Sentinel = 'aPrincipal'
            if ((!(((&(reader__)))->ReadSentinel(364381188)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__aPersist = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aPersist) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aPersist = *maybe__aPersist;
            // Sentinel = 'aPersist'
            if ((!(((&(reader__)))->ReadSentinel(238617420)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PMedia::Reply_GetPrincipalKey(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetPrincipalKeyResolver resolver = [resolver__ = std::move(resolver__)](const nsACString& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aKey'
                    ((&(writer__)))->WriteSentinel(61604235);

                    if (mozilla::ipc::LoggingEnabledFor("PMedia", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PMediaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetPrincipalKey(std::move(aPrincipal), std::move(aPersist), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMedia::Msg_SanitizeOriginKeys__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMedia", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMedia::Msg_SanitizeOriginKeys", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSinceWhen = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aSinceWhen) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aSinceWhen = *maybe__aSinceWhen;
            // Sentinel = 'aSinceWhen'
            if ((!(((&(reader__)))->ReadSentinel(354419686)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aOnlyPrivateBrowsing = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aOnlyPrivateBrowsing) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aOnlyPrivateBrowsing = *maybe__aOnlyPrivateBrowsing;
            // Sentinel = 'aOnlyPrivateBrowsing'
            if ((!(((&(reader__)))->ReadSentinel(1416300586)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSanitizeOriginKeys(std::move(aSinceWhen), std::move(aOnlyPrivateBrowsing));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMedia::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PMediaParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PMediaParent::Result
{
    return MsgNotKnown;
}



} // namespace media
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::media::PMediaParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PMedia'
    (aWriter)->WriteSentinel(123339313);
}

auto ParamTraits<::mozilla::media::PMediaParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PMedia actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PMedia'
    if ((!((aReader)->ReadSentinel(123339313)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PMedia actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PMediaMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PMedia)");

        return {};
    }
    return static_cast<::mozilla::media::PMediaParent*>(actor);
}

} // namespace IPC
