#include "AbortControllerBinding.h"
#include "AbortSignalBinding.h"
#include "AudioWorkletGlobalScopeBinding.h"
#include "AudioWorkletProcessorBinding.h"
#include "CSSColorBinding.h"
#include "CSSColorValueBinding.h"
#include "CSSHSLBinding.h"
#include "CSSHWBBinding.h"
#include "CSSImageValueBinding.h"
#include "CSSKeywordValueBinding.h"
#include "CSSLCHBinding.h"
#include "CSSLabBinding.h"
#include "CSSMathClampBinding.h"
#include "CSSMathInvertBinding.h"
#include "CSSMathMaxBinding.h"
#include "CSSMathMinBinding.h"
#include "CSSMathNegateBinding.h"
#include "CSSMathProductBinding.h"
#include "CSSMathSumBinding.h"
#include "CSSMathValueBinding.h"
#include "CSSNumericArrayBinding.h"
#include "CSSNumericValueBinding.h"
#include "CSSOKLCHBinding.h"
#include "CSSOKLabBinding.h"
#include "CSSRGBBinding.h"
#include "CSSStyleValueBinding.h"
#include "CSSUnitValueBinding.h"
#include "CSSUnparsedValueBinding.h"
#include "CSSVariableReferenceValueBinding.h"
#include "CompressionStreamBinding.h"
#include "ConsoleBinding.h"
#include "ConsoleInstanceBinding.h"
#include "DecompressionStreamBinding.h"
#include "EventBinding.h"
#include "EventTargetBinding.h"
#include "MessageEventBinding.h"
#include "MessagePortBinding.h"
#include "PaintWorkletGlobalScopeBinding.h"
#include "QueuingStrategyBinding.h"
#include "ReadableByteStreamControllerBinding.h"
#include "ReadableStreamBYOBReaderBinding.h"
#include "ReadableStreamBYOBRequestBinding.h"
#include "ReadableStreamBinding.h"
#include "ReadableStreamDefaultControllerBinding.h"
#include "ReadableStreamDefaultReaderBinding.h"
#include "StructuredCloneHolderBinding.h"
#include "StylePropertyMapReadOnlyBinding.h"
#include "TextDecoderStreamBinding.h"
#include "TextEncoderStreamBinding.h"
#include "TransformStreamBinding.h"
#include "TransformStreamDefaultControllerBinding.h"
#include "WorkletGlobalScopeBinding.h"
#include "WritableStreamBinding.h"
#include "WritableStreamDefaultControllerBinding.h"
#include "WritableStreamDefaultWriterBinding.h"

namespace mozilla::dom {
bool
RegisterWorkletBindings(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  if (!AbortController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!AbortSignal_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!AudioWorkletGlobalScope_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!AudioWorkletProcessor_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ByteLengthQueuingStrategy_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSColor_Binding::ConstructorEnabled(aCx, aObj) && !CSSColor_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSColorValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSColorValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSHSL_Binding::ConstructorEnabled(aCx, aObj) && !CSSHSL_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSHWB_Binding::ConstructorEnabled(aCx, aObj) && !CSSHWB_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSImageValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSImageValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSKeywordValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSKeywordValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSLCH_Binding::ConstructorEnabled(aCx, aObj) && !CSSLCH_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSLab_Binding::ConstructorEnabled(aCx, aObj) && !CSSLab_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathClamp_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathClamp_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathInvert_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathInvert_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathMax_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathMax_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathMin_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathMin_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathNegate_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathNegate_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathProduct_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathProduct_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathSum_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathSum_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSNumericArray_Binding::ConstructorEnabled(aCx, aObj) && !CSSNumericArray_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSNumericValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSNumericValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSOKLCH_Binding::ConstructorEnabled(aCx, aObj) && !CSSOKLCH_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSOKLab_Binding::ConstructorEnabled(aCx, aObj) && !CSSOKLab_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSRGB_Binding::ConstructorEnabled(aCx, aObj) && !CSSRGB_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSStyleValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSStyleValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSUnitValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSUnitValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSUnparsedValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSUnparsedValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSVariableReferenceValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSVariableReferenceValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CompressionStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ConsoleInstance_Binding::ConstructorEnabled(aCx, aObj) && !ConsoleInstance_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CountQueuingStrategy_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DecompressionStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Event_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!EventTarget_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!MessageEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!MessagePort_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!PaintWorkletGlobalScope_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableByteStreamController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamBYOBReader_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamBYOBRequest_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamDefaultReader_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (StructuredCloneHolder_Binding::ConstructorEnabled(aCx, aObj) && !StructuredCloneHolder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (StylePropertyMapReadOnly_Binding::ConstructorEnabled(aCx, aObj) && !StylePropertyMapReadOnly_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextDecoderStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextEncoderStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TransformStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TransformStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WorkletGlobalScope_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStreamDefaultWriter_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!console_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  return true;
}

} // namespace mozilla::dom

