// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDocshellMetrics_h
#define mozilla_GleanDocshellMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace bfcache {
  /**
   * generated from bfcache.combo
   */
  enum class ComboLabel: uint16_t {
    eBfcacheSuccess = 0,
    eSuccessNotToplevel = 1,
    eUnload = 2,
    eUnloadReq = 3,
    eReq = 4,
    eUnloadReqPeer = 5,
    eUnloadReqPeerMse = 6,
    eUnloadReqMse = 7,
    eSpdUnloadReqPeer = 8,
    eRemoteSubframes = 9,
    eBeforeunload = 10,
    eOther = 11,
    e__Other__,
  };
  /**
   * The common combinations of BFCacheStatus when we determine whether the page can be BFCached or not; If it's BFCached, we record BFCache_Success; Success_Not_Toplevel represents the number of not the only top level document in BrowsingContextGroup's documents that are BFCached, and BFCache_Success includes Success_Not_Toplevel; If it's not and it falls under common failure reasons combinations, we record the corresponding combination; Otherwise, we record Other to indicate this is not a common failure
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram BFCACHE_COMBO.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ComboLabel> combo(1278);

  /**
   * generated from bfcache.page_restored
   */
  enum class PageRestoredLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether bfcache is used when loading a page from session history
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram BFCACHE_PAGE_RESTORED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, PageRestoredLabel> page_restored(1279);
}

namespace page {
  /**
   * generated from page.load_error
   * Page load errors. Match values with type of error in nsDocShellTelemetryUtils.cpp
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram PAGE_LOAD_ERROR.
   */
  constexpr impl::DualLabeledCounterMetric load_error(1280);
}

namespace performance_page {
  /**
   * generated from performance.page.total_content_page_load
   * Time to load all of a page's resources and render. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric total_content_page_load(1281);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDocshellMetrics_h
