// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanUrlClassifierMetrics_h
#define mozilla_GleanUrlClassifierMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace urlclassifier {
  /**
   * generated from urlclassifier.async_classifylocal_time
   * Time spent per AsyncClassifyLocalWithTables (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_ASYNC_CLASSIFYLOCAL_TIME.
   */
  constexpr impl::TimingDistributionMetric async_classifylocal_time(5826);

  /**
   * generated from urlclassifier.cl_check_time
   * Time spent per classifier lookup (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_CL_CHECK_TIME.
   */
  constexpr impl::TimingDistributionMetric cl_check_time(5827);

  /**
   * generated from urlclassifier.cl_keyed_update_time
   * Time spent per classifier update (ms), keyed by the name of the provider.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_CL_KEYED_UPDATE_TIME.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> cl_keyed_update_time(5828);

  /**
   * generated from urlclassifier.complete_remote_status2
   * Server HTTP status code from remote SafeBrowsing gethash lookups. (0=1xx, 1=200, 2=2xx, 3=204, 4=3xx, 5=400, 6=4xx, 7=403, 8=404, 9=408, 10=413, 11=5xx, 12=502|504|511, 13=503, 14=505, 15=Other). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_COMPLETE_REMOTE_STATUS2.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> complete_remote_status2(5829);

  /**
   * generated from urlclassifier.complete_server_response_time
   * Server response time to getHash request (ms). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_COMPLETE_SERVER_RESPONSE_TIME.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> complete_server_response_time(5830);

  /**
   * generated from urlclassifier.complete_timeout
   * This metric is recorded every time a gethash lookup is performed, `true` is recorded if the lookup times out. Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram URLCLASSIFIER_COMPLETE_TIMEOUT2.
   */
  constexpr impl::DualLabeledCounterMetric complete_timeout(5831);

  /**
   * generated from urlclassifier.completion
   */
  struct CompletionExtra {
    mozilla::Maybe<bool> hit;
    mozilla::Maybe<nsCString> tableName;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hit) {
        extraKeys.AppendElement()->AssignASCII("hit");
        extraValues.AppendElement()->AssignASCII(hit.value() ? "true" : "false");
      }
      if (tableName) {
        extraKeys.AppendElement()->AssignASCII("table_name");
        extraValues.EmplaceBack(tableName.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records each completion attempt and whether it resulted in a hit.
   */
  constexpr impl::EventMetric<CompletionExtra> completion(5832);

  /**
   * generated from urlclassifier.completion_error
   * SafeBrowsing v4 hash completion error (0 = success, 1 = parsing failure, 2 = unknown threat type)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_COMPLETION_ERROR.
   */
  constexpr impl::CustomDistributionMetric completion_error(5833);

  /**
   * generated from urlclassifier.lookup_hit
   */
  enum class LookupHitLabel: uint16_t {
    eGoogPhishProto = 0,
    eGoogpubPhishProto = 1,
    eGoogMalwareProto = 2,
    eGoogUnwantedProto = 3,
    eGoogHarmfulProto = 4,
    eGoogBadbinurlProto = 5,
    eGoogDownloadwhiteProto = 6,
    eBaseTrackDigest256 = 7,
    eMozstdTrackwhiteDigest256 = 8,
    eGoogleTrackwhiteDigest256 = 9,
    eContentTrackDigest256 = 10,
    eMozpluginBlockDigest256 = 11,
    eAdsTrackDigest256 = 12,
    eSocialTrackDigest256 = 13,
    eAnalyticsTrackDigest256 = 14,
    eBaseFingerprintingTrackDigest256 = 15,
    eContentFingerprintingTrackDigest256 = 16,
    eBaseCryptominingTrackDigest256 = 17,
    eContentCryptominingTrackDigest256 = 18,
    eSocialTrackingProtectionDigest256 = 19,
    eSocialTrackingProtectionFacebookDigest256 = 20,
    eSocialTrackingProtectionLinkedinDigest256 = 21,
    eSocialTrackingProtectionTwitterDigest256 = 22,
    eBaseEmailTrackDigest256 = 23,
    eContentEmailTrackDigest256 = 24,
    eConsentManagerTrackDigest256 = 25,
    eAntiFraudTrackDigest256 = 26,
    eTestMalwareSimple = 27,
    eTestUnwantedSimple = 28,
    e__Other__,
  };
  /**
   * Counts the number of times that a lookup hits a table. Keyed by table name.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LookupHitLabel> lookup_hit(5834);

  /**
   * generated from urlclassifier.lookup_miss
   */
  enum class LookupMissLabel: uint16_t {
    eGoogPhishProto = 0,
    eGoogpubPhishProto = 1,
    eGoogMalwareProto = 2,
    eGoogUnwantedProto = 3,
    eGoogHarmfulProto = 4,
    eGoogBadbinurlProto = 5,
    eGoogDownloadwhiteProto = 6,
    eBaseTrackDigest256 = 7,
    eMozstdTrackwhiteDigest256 = 8,
    eGoogleTrackwhiteDigest256 = 9,
    eContentTrackDigest256 = 10,
    eMozpluginBlockDigest256 = 11,
    eAdsTrackDigest256 = 12,
    eSocialTrackDigest256 = 13,
    eAnalyticsTrackDigest256 = 14,
    eBaseFingerprintingTrackDigest256 = 15,
    eContentFingerprintingTrackDigest256 = 16,
    eBaseCryptominingTrackDigest256 = 17,
    eContentCryptominingTrackDigest256 = 18,
    eSocialTrackingProtectionDigest256 = 19,
    eSocialTrackingProtectionFacebookDigest256 = 20,
    eSocialTrackingProtectionLinkedinDigest256 = 21,
    eSocialTrackingProtectionTwitterDigest256 = 22,
    eBaseEmailTrackDigest256 = 23,
    eContentEmailTrackDigest256 = 24,
    eConsentManagerTrackDigest256 = 25,
    eAntiFraudTrackDigest256 = 26,
    eTestMalwareSimple = 27,
    eTestUnwantedSimple = 28,
    e__Other__,
  };
  /**
   * Counts the number of times that a lookup misses a table. Keyed by table name.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LookupMissLabel> lookup_miss(5835);

  /**
   * generated from urlclassifier.lookup_time_2
   * Time spent per dbservice lookup (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_LOOKUP_TIME_2.
   */
  constexpr impl::TimingDistributionMetric lookup_time_2(5836);

  /**
   * generated from urlclassifier.shutdown_time
   * Time spent per dbservice shutdown (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_SHUTDOWN_TIME.
   */
  constexpr impl::TimingDistributionMetric shutdown_time(5837);

  /**
   * generated from urlclassifier.threathit_network_error
   * Whether or not an error was encountered while sending a Safe Browsing ThreatHit report. (0=sucess, 1=unknown error, 2=already connected, 3=not connected, 4=connection refused,5=net timeout, 6=offline, 7=port access not allowed, 8=net reset, 9=net interrupt, 10=proxy connection refused, 11=partial transfer, 12=inadequate security, 13=unknown host, 14=dns lookup queue full, 15=unknown proxy host)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_THREATHIT_NETWORK_ERROR.
   */
  constexpr impl::CustomDistributionMetric threathit_network_error(5838);

  /**
   * generated from urlclassifier.threathit_remote_status
   * Server HTTP status code from Safe Browsing ThreatHit report. (0=1xx, 1=200, 2=2xx, 3=204, 4=3xx, 5=400, 6=4xx, 7=403, 8=404, 9=408, 10=413, 11=5xx, 12=502|504|511, 13=503, 14=505, 15=Other)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_THREATHIT_REMOTE_STATUS.
   */
  constexpr impl::CustomDistributionMetric threathit_remote_status(5839);

  /**
   * generated from urlclassifier.ui_events
   * URL CLassifier-related (aka Safe Browsing) UI events. See nsIUrlClassifierUITelemetry.idl for the specific values.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UI_EVENTS.
   */
  constexpr impl::CustomDistributionMetric ui_events(5840);

  /**
   * generated from urlclassifier.update_error
   * Whether or not an error was encountered while processing a Safe Browsing update (0 = success, 1 = unspecified error, 2 = addition of an already existing prefix, 3 = parser got into an infinite loop, 4 = removal index out of bounds, 5 = checksum mismatch, 6 = missing checksum, 7 = update while shutdown, 8 = cannot find table, 9 = build prefix failure, 10 = write disk failure, 11 = protocol parser error). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UPDATE_ERROR.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> update_error(5841);

  /**
   * generated from urlclassifier.update_remote_network_error
   * Network error from SafeBrowsing database updates. (0=sucess, 1=unknown error, 2=already connected, 3=not connected, 4=connection refused,5=net timeout, 6=offline, 7=port access not allowed, 8=net reset, 9=net interrupt, 10=proxy connection refused,11=partial transfer,12=inadequate security,13=unknown host,14=dns lookup queue full,15=unknown proxy host
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UPDATE_REMOTE_NETWORK_ERROR.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> update_remote_network_error(5842);

  /**
   * generated from urlclassifier.update_remote_status2
   * Server HTTP status code from SafeBrowsing database updates. (0=1xx, 1=200, 2=2xx, 3=204, 4=3xx, 5=400, 6=4xx, 7=403, 8=404, 9=408, 10=413, 11=5xx, 12=502|504|511, 13=503, 14=505, 15=Other). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UPDATE_REMOTE_STATUS2.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> update_remote_status2(5843);

  /**
   * generated from urlclassifier.update_server_response_time
   * Server response time to update request (ms). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_UPDATE_SERVER_RESPONSE_TIME.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> update_server_response_time(5844);

  /**
   * generated from urlclassifier.update_timeout
   * Whether or not an update timed out (0 = no timeout, 1 = server respond
   * timeout, 2 = overall timeout). Keyed by provider This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UPDATE_TIMEOUT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> update_timeout(5845);

  /**
   * generated from urlclassifier.vlps_construct_time
   * Time spent constructing Variable-Length PrefixSet from file (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_VLPS_CONSTRUCT_TIME.
   */
  constexpr impl::TimingDistributionMetric vlps_construct_time(5846);

  /**
   * generated from urlclassifier.vlps_fallocate_time
   * Time spent fallocating Variable-Length PrefixSet (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_VLPS_FALLOCATE_TIME.
   */
  constexpr impl::TimingDistributionMetric vlps_fallocate_time(5847);

  /**
   * generated from urlclassifier.vlps_fileload_time
   * Time spent loading Variable-Length PrefixSet from file (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_VLPS_FILELOAD_TIME.
   */
  constexpr impl::TimingDistributionMetric vlps_fileload_time(5848);

  /**
   * generated from urlclassifier.vlps_metadata_corrupt
   */
  enum class VlpsMetadataCorruptLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether or not the metadata for a variable-length prefix set loaded from disk is corrupted (true = file corrupted).
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram URLCLASSIFIER_VLPS_METADATA_CORRUPT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, VlpsMetadataCorruptLabel> vlps_metadata_corrupt(5849);
}

} // namespace mozilla::glean

#endif // mozilla_GleanUrlClassifierMetrics_h
