/* THIS FILE IS AUTOGENERATED FROM WebXR.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_WEBXRBINDING_H_
#define DOM_WEBXRBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/dom/XRWebGLLayer.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {

class ClientWebGLContext;

namespace dom {

struct NativePropertyHooks;
class OwningWebGLRenderingContextOrWebGL2RenderingContext;
class ProtoAndIfaceCache;
class XRBoundedReferenceSpace;
class XRFrame;
class XRFrameRequestCallback;
class XRInputSource;
class XRInputSourceArray;
class XRPose;
class XRReferenceSpace;
class XRRenderState;
struct XRRenderStateInitAtoms;
class XRRigidTransform;
class XRSession;
struct XRSessionInitAtoms;
class XRSpace;
class XRSystem;
class XRView;
class XRViewerPose;
class XRViewport;
class XRWebGLLayer;
struct XRWebGLLayerInitAtoms;

} // namespace dom

} // namespace mozilla

namespace mozilla {

namespace dom {

enum class XRSessionMode : uint8_t {
  Inline,
  Immersive_vr,
  Immersive_ar,
};

namespace binding_detail {
template <> struct EnumStrings<XRSessionMode> {
  static constexpr nsLiteralCString Values[3] {
    "inline"_ns,
    "immersive-vr"_ns,
    "immersive-ar"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, XRSessionMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class XRVisibilityState : uint8_t {
  Visible,
  Visible_blurred,
  Hidden,
};

namespace binding_detail {
template <> struct EnumStrings<XRVisibilityState> {
  static constexpr nsLiteralCString Values[3] {
    "visible"_ns,
    "visible-blurred"_ns,
    "hidden"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, XRVisibilityState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class XRReferenceSpaceType : uint8_t {
  Viewer,
  Local,
  Local_floor,
  Bounded_floor,
  Unbounded,
};

namespace binding_detail {
template <> struct EnumStrings<XRReferenceSpaceType> {
  static constexpr nsLiteralCString Values[5] {
    "viewer"_ns,
    "local"_ns,
    "local-floor"_ns,
    "bounded-floor"_ns,
    "unbounded"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, XRReferenceSpaceType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class XREye : uint8_t {
  None,
  Left,
  Right,
};

namespace binding_detail {
template <> struct EnumStrings<XREye> {
  static constexpr nsLiteralCString Values[3] {
    "none"_ns,
    "left"_ns,
    "right"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, XREye aArgument, JS::MutableHandle<JS::Value> aValue);


enum class XRHandedness : uint8_t {
  None,
  Left,
  Right,
};

namespace binding_detail {
template <> struct EnumStrings<XRHandedness> {
  static constexpr nsLiteralCString Values[3] {
    "none"_ns,
    "left"_ns,
    "right"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, XRHandedness aArgument, JS::MutableHandle<JS::Value> aValue);


enum class XRTargetRayMode : uint8_t {
  Gaze,
  Tracked_pointer,
  Screen,
};

namespace binding_detail {
template <> struct EnumStrings<XRTargetRayMode> {
  static constexpr nsLiteralCString Values[3] {
    "gaze"_ns,
    "tracked-pointer"_ns,
    "screen"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, XRTargetRayMode aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningWebGLRenderingContextOrWebGL2RenderingContext& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningWebGLRenderingContextOrWebGL2RenderingContext& aUnion);


class WebGLRenderingContextOrWebGL2RenderingContext : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eWebGLRenderingContext,
    eWebGL2RenderingContext
  };
public:
  enum class Type
  {
    eWebGLRenderingContext = TypeOrUninit::eWebGLRenderingContext,
    eWebGL2RenderingContext = TypeOrUninit::eWebGL2RenderingContext
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::ClientWebGLContext> > mWebGLRenderingContext;
    UnionMember<NonNull<mozilla::ClientWebGLContext> > mWebGL2RenderingContext;

  };

  TypeOrUninit mType;
  Value mValue;

  WebGLRenderingContextOrWebGL2RenderingContext(const WebGLRenderingContextOrWebGL2RenderingContext&) = delete;
  WebGLRenderingContextOrWebGL2RenderingContext& operator=(const WebGLRenderingContextOrWebGL2RenderingContext&) = delete;
public:
  explicit inline WebGLRenderingContextOrWebGL2RenderingContext()
    : mType(eUninitialized)
  {
  }

  inline ~WebGLRenderingContextOrWebGL2RenderingContext()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::ClientWebGLContext>&
  RawSetAsWebGLRenderingContext()
  {
    if (mType == eWebGLRenderingContext) {
      return mValue.mWebGLRenderingContext.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWebGLRenderingContext;
    return mValue.mWebGLRenderingContext.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::ClientWebGLContext>&
  SetAsWebGLRenderingContext()
  {
    if (mType == eWebGLRenderingContext) {
      return mValue.mWebGLRenderingContext.Value();
    }
    Uninit();
    mType = eWebGLRenderingContext;
    return mValue.mWebGLRenderingContext.SetValue();
  }

  inline bool
  IsWebGLRenderingContext() const
  {
    return mType == eWebGLRenderingContext;
  }

  inline NonNull<mozilla::ClientWebGLContext>&
  GetAsWebGLRenderingContext()
  {
    MOZ_RELEASE_ASSERT(IsWebGLRenderingContext(), "Wrong type!");
    return mValue.mWebGLRenderingContext.Value();
  }

  inline mozilla::ClientWebGLContext&
  GetAsWebGLRenderingContext() const
  {
    MOZ_RELEASE_ASSERT(IsWebGLRenderingContext(), "Wrong type!");
    return mValue.mWebGLRenderingContext.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::ClientWebGLContext>&
  RawSetAsWebGL2RenderingContext()
  {
    if (mType == eWebGL2RenderingContext) {
      return mValue.mWebGL2RenderingContext.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWebGL2RenderingContext;
    return mValue.mWebGL2RenderingContext.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::ClientWebGLContext>&
  SetAsWebGL2RenderingContext()
  {
    if (mType == eWebGL2RenderingContext) {
      return mValue.mWebGL2RenderingContext.Value();
    }
    Uninit();
    mType = eWebGL2RenderingContext;
    return mValue.mWebGL2RenderingContext.SetValue();
  }

  inline bool
  IsWebGL2RenderingContext() const
  {
    return mType == eWebGL2RenderingContext;
  }

  inline NonNull<mozilla::ClientWebGLContext>&
  GetAsWebGL2RenderingContext()
  {
    MOZ_RELEASE_ASSERT(IsWebGL2RenderingContext(), "Wrong type!");
    return mValue.mWebGL2RenderingContext.Value();
  }

  inline mozilla::ClientWebGLContext&
  GetAsWebGL2RenderingContext() const
  {
    MOZ_RELEASE_ASSERT(IsWebGL2RenderingContext(), "Wrong type!");
    return mValue.mWebGL2RenderingContext.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eWebGLRenderingContext: {
        DestroyWebGLRenderingContext();
        break;
      }
      case eWebGL2RenderingContext: {
        DestroyWebGL2RenderingContext();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToWebGLRenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWebGLRenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyWebGLRenderingContext()
  {
    MOZ_RELEASE_ASSERT(IsWebGLRenderingContext(), "Wrong type!");
    mValue.mWebGLRenderingContext.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToWebGL2RenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWebGL2RenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyWebGL2RenderingContext()
  {
    MOZ_RELEASE_ASSERT(IsWebGL2RenderingContext(), "Wrong type!");
    mValue.mWebGL2RenderingContext.Destroy();
    mType = eUninitialized;
  }
};


class OwningWebGLRenderingContextOrWebGL2RenderingContext : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningWebGLRenderingContextOrWebGL2RenderingContext& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eWebGLRenderingContext,
    eWebGL2RenderingContext
  };
public:
  enum class Type
  {
    eWebGLRenderingContext = TypeOrUninit::eWebGLRenderingContext,
    eWebGL2RenderingContext = TypeOrUninit::eWebGL2RenderingContext
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::ClientWebGLContext> > mWebGLRenderingContext;
    UnionMember<OwningNonNull<mozilla::ClientWebGLContext> > mWebGL2RenderingContext;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningWebGLRenderingContextOrWebGL2RenderingContext()
    : mType(eUninitialized)
  {
  }

  OwningWebGLRenderingContextOrWebGL2RenderingContext(OwningWebGLRenderingContextOrWebGL2RenderingContext&& aOther);

  explicit inline OwningWebGLRenderingContextOrWebGL2RenderingContext(const OwningWebGLRenderingContextOrWebGL2RenderingContext& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningWebGLRenderingContextOrWebGL2RenderingContext()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::ClientWebGLContext>&
  RawSetAsWebGLRenderingContext();

  [[nodiscard]] OwningNonNull<mozilla::ClientWebGLContext>&
  SetAsWebGLRenderingContext();

  inline bool
  IsWebGLRenderingContext() const
  {
    return mType == eWebGLRenderingContext;
  }

  inline OwningNonNull<mozilla::ClientWebGLContext>&
  GetAsWebGLRenderingContext()
  {
    MOZ_RELEASE_ASSERT(IsWebGLRenderingContext(), "Wrong type!");
    return mValue.mWebGLRenderingContext.Value();
  }

  inline OwningNonNull<mozilla::ClientWebGLContext> const &
  GetAsWebGLRenderingContext() const
  {
    MOZ_RELEASE_ASSERT(IsWebGLRenderingContext(), "Wrong type!");
    return mValue.mWebGLRenderingContext.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::ClientWebGLContext>&
  RawSetAsWebGL2RenderingContext();

  [[nodiscard]] OwningNonNull<mozilla::ClientWebGLContext>&
  SetAsWebGL2RenderingContext();

  inline bool
  IsWebGL2RenderingContext() const
  {
    return mType == eWebGL2RenderingContext;
  }

  inline OwningNonNull<mozilla::ClientWebGLContext>&
  GetAsWebGL2RenderingContext()
  {
    MOZ_RELEASE_ASSERT(IsWebGL2RenderingContext(), "Wrong type!");
    return mValue.mWebGL2RenderingContext.Value();
  }

  inline OwningNonNull<mozilla::ClientWebGLContext> const &
  GetAsWebGL2RenderingContext() const
  {
    MOZ_RELEASE_ASSERT(IsWebGL2RenderingContext(), "Wrong type!");
    return mValue.mWebGL2RenderingContext.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningWebGLRenderingContextOrWebGL2RenderingContext&
  operator=(OwningWebGLRenderingContextOrWebGL2RenderingContext&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningWebGLRenderingContextOrWebGL2RenderingContext&
  operator=(const OwningWebGLRenderingContextOrWebGL2RenderingContext& aOther);

private:
  bool
  TrySetToWebGLRenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWebGLRenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyWebGLRenderingContext();

  bool
  TrySetToWebGL2RenderingContext(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWebGL2RenderingContext(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyWebGL2RenderingContext();
};


class XRFrameRequestCallback : public CallbackFunction
{
public:
  explicit inline XRFrameRequestCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline XRFrameRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline XRFrameRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline XRFrameRequestCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, double time, XRFrame& frame, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "XRFrameRequestCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, time, frame, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(double time, XRFrame& frame, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "XRFrameRequestCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, time, frame, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, double time, XRFrame& frame, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, time, frame, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(double time, XRFrame& frame, const char* aExecutionReason = nullptr)
  {
    return Call(time, frame, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const XRFrameRequestCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, double time, XRFrame& frame, ErrorResult& aRv);
};


namespace binding_detail {
class FastXRFrameRequestCallback : public XRFrameRequestCallback
{
public:
  explicit inline FastXRFrameRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : XRFrameRequestCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    XRFrameRequestCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    XRFrameRequestCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct XRRenderStateInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<RefPtr<mozilla::dom::XRWebGLLayer>> mBaseLayer;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mDepthFar;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mDepthNear;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mInlineVerticalFieldOfView;

  XRRenderStateInit();

  explicit inline XRRenderStateInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  XRRenderStateInit(XRRenderStateInit&& aOther) = default;

  explicit inline XRRenderStateInit(const XRRenderStateInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBaseLayer, "mBaseLayer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBaseLayer);
  }

  XRRenderStateInit&
  operator=(const XRRenderStateInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, XRRenderStateInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastXRRenderStateInit : public XRRenderStateInit
{
  inline FastXRRenderStateInit()
    : XRRenderStateInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct XRSessionInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mOptionalFeatures;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mRequiredFeatures;

  XRSessionInit();

  explicit inline XRSessionInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  XRSessionInit(XRSessionInit&& aOther) = default;

  explicit inline XRSessionInit(const XRSessionInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  XRSessionInit&
  operator=(const XRSessionInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, XRSessionInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastXRSessionInit : public XRSessionInit
{
  inline FastXRSessionInit()
    : XRSessionInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct XRWebGLLayerInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAlpha;
  MOZ_INIT_OUTSIDE_CTOR bool mAntialias;
  MOZ_INIT_OUTSIDE_CTOR bool mDepth;
  MOZ_INIT_OUTSIDE_CTOR double mFramebufferScaleFactor;
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreDepthValues;
  MOZ_INIT_OUTSIDE_CTOR bool mStencil;

  XRWebGLLayerInit();

  explicit inline XRWebGLLayerInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  XRWebGLLayerInit(XRWebGLLayerInit&& aOther) = default;

  explicit inline XRWebGLLayerInit(const XRWebGLLayerInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  XRWebGLLayerInit&
  operator=(const XRWebGLLayerInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, XRWebGLLayerInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastXRWebGLLayerInit : public XRWebGLLayerInit
{
  inline FastXRWebGLLayerInit()
    : XRWebGLLayerInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace XRBoundedReferenceSpace_Binding {

  typedef mozilla::dom::XRBoundedReferenceSpace NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRBoundedReferenceSpace* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedBoundsGeometryValue(mozilla::dom::XRBoundedReferenceSpace* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRBoundedReferenceSpace,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRBoundedReferenceSpace_Binding



namespace XRFrame_Binding {

  typedef mozilla::dom::XRFrame NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRFrame* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRFrame,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRFrame_Binding



namespace XRInputSource_Binding {

  typedef mozilla::dom::XRInputSource NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRInputSource* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRInputSource,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRInputSource_Binding



namespace XRInputSourceArray_Binding {

  typedef mozilla::dom::XRInputSourceArray NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRInputSourceArray* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRInputSourceArray,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRInputSourceArray_Binding



namespace XRPose_Binding {

  typedef mozilla::dom::XRPose NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRPose* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRPose,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRPose_Binding



namespace XRReferenceSpace_Binding {

  typedef mozilla::dom::XRReferenceSpace NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRReferenceSpace* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRReferenceSpace,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRReferenceSpace_Binding



namespace XRRenderState_Binding {

  typedef mozilla::dom::XRRenderState NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRRenderState* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRRenderState,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRRenderState_Binding



namespace XRRigidTransform_Binding {

  typedef mozilla::dom::XRRigidTransform NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRRigidTransform* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRRigidTransform,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRRigidTransform_Binding



namespace XRSession_Binding {

  typedef mozilla::dom::XRSession NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRSession* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRSession,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRSession_Binding



namespace XRSpace_Binding {

  typedef mozilla::dom::XRSpace NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRSpace* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRSpace,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRSpace_Binding



namespace XRSystem_Binding {

  typedef mozilla::dom::XRSystem NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRSystem* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRSystem,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRSystem_Binding



namespace XRView_Binding {

  typedef mozilla::dom::XRView NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRView* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRView,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRView_Binding



namespace XRViewerPose_Binding {

  typedef mozilla::dom::XRViewerPose NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRViewerPose* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRViewerPose,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRViewerPose_Binding



namespace XRViewport_Binding {

  typedef mozilla::dom::XRViewport NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRViewport* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRViewport,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRViewport_Binding



namespace XRWebGLLayer_Binding {

  typedef mozilla::dom::XRWebGLLayer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XRWebGLLayer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XRWebGLLayer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XRWebGLLayer_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::XRSessionMode>
{
  static constexpr dom::XRSessionMode value = dom::XRSessionMode::Immersive_ar;

  static_assert(static_cast<uint8_t>(dom::XRSessionMode::Inline) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::XRSessionMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::XRVisibilityState>
{
  static constexpr dom::XRVisibilityState value = dom::XRVisibilityState::Hidden;

  static_assert(static_cast<uint8_t>(dom::XRVisibilityState::Visible) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::XRVisibilityState>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::XRReferenceSpaceType>
{
  static constexpr dom::XRReferenceSpaceType value = dom::XRReferenceSpaceType::Unbounded;

  static_assert(static_cast<uint8_t>(dom::XRReferenceSpaceType::Viewer) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::XRReferenceSpaceType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::XREye>
{
  static constexpr dom::XREye value = dom::XREye::Right;

  static_assert(static_cast<uint8_t>(dom::XREye::None) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::XREye>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::XRHandedness>
{
  static constexpr dom::XRHandedness value = dom::XRHandedness::Right;

  static_assert(static_cast<uint8_t>(dom::XRHandedness::None) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::XRHandedness>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::XRTargetRayMode>
{
  static constexpr dom::XRTargetRayMode value = dom::XRTargetRayMode::Screen;

  static_assert(static_cast<uint8_t>(dom::XRTargetRayMode::Gaze) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::XRTargetRayMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_WEBXRBINDING_H_
