/* THIS FILE IS AUTOGENERATED FROM DeviceMotionEvent.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "DeviceMotionEventBinding.h"
#include "EventBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_device.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DeviceMotionEvent.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsGlobalWindowInner.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



DeviceAccelerationInit::DeviceAccelerationInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
DeviceAccelerationInit::InitIds(JSContext* cx, DeviceAccelerationInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->z_id.init(cx, "z") ||
      !atomsCache->y_id.init(cx, "y") ||
      !atomsCache->x_id.init(cx, "x")) {
    return false;
  }
  return true;
}

bool
DeviceAccelerationInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  DeviceAccelerationInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<DeviceAccelerationInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->x_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mX.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'x' member of DeviceAccelerationInit", &mX.SetValue())) {
    return false;
  } else if (!std::isfinite(mX.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("'x' member of DeviceAccelerationInit");
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->y_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mY.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'y' member of DeviceAccelerationInit", &mY.SetValue())) {
    return false;
  } else if (!std::isfinite(mY.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("'y' member of DeviceAccelerationInit");
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->z_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mZ.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'z' member of DeviceAccelerationInit", &mZ.SetValue())) {
    return false;
  } else if (!std::isfinite(mZ.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("'z' member of DeviceAccelerationInit");
    return false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
DeviceAccelerationInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
DeviceAccelerationInit::TraceDictionary(JSTracer* trc)
{
}

DeviceAccelerationInit&
DeviceAccelerationInit::operator=(const DeviceAccelerationInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mX = aOther.mX;
  mY = aOther.mY;
  mZ = aOther.mZ;
  return *this;
}



DeviceRotationRateInit::DeviceRotationRateInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
DeviceRotationRateInit::InitIds(JSContext* cx, DeviceRotationRateInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->gamma_id.init(cx, "gamma") ||
      !atomsCache->beta_id.init(cx, "beta") ||
      !atomsCache->alpha_id.init(cx, "alpha")) {
    return false;
  }
  return true;
}

bool
DeviceRotationRateInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  DeviceRotationRateInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<DeviceRotationRateInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->alpha_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mAlpha.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'alpha' member of DeviceRotationRateInit", &mAlpha.SetValue())) {
    return false;
  } else if (!std::isfinite(mAlpha.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("'alpha' member of DeviceRotationRateInit");
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->beta_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mBeta.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'beta' member of DeviceRotationRateInit", &mBeta.SetValue())) {
    return false;
  } else if (!std::isfinite(mBeta.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("'beta' member of DeviceRotationRateInit");
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->gamma_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mGamma.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'gamma' member of DeviceRotationRateInit", &mGamma.SetValue())) {
    return false;
  } else if (!std::isfinite(mGamma.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("'gamma' member of DeviceRotationRateInit");
    return false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
DeviceRotationRateInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
DeviceRotationRateInit::TraceDictionary(JSTracer* trc)
{
}

DeviceRotationRateInit&
DeviceRotationRateInit::operator=(const DeviceRotationRateInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mAlpha = aOther.mAlpha;
  mBeta = aOther.mBeta;
  mGamma = aOther.mGamma;
  return *this;
}



DeviceMotionEventInit::DeviceMotionEventInit()
  : EventInit(FastDictionaryInitializer()),
    mAcceleration(FastDictionaryInitializer()),
    mAccelerationIncludingGravity(FastDictionaryInitializer()),
    mRotationRate(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
DeviceMotionEventInit::InitIds(JSContext* cx, DeviceMotionEventInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->rotationRate_id.init(cx, "rotationRate") ||
      !atomsCache->interval_id.init(cx, "interval") ||
      !atomsCache->accelerationIncludingGravity_id.init(cx, "accelerationIncludingGravity") ||
      !atomsCache->acceleration_id.init(cx, "acceleration")) {
    return false;
  }
  return true;
}

bool
DeviceMotionEventInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  DeviceMotionEventInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<DeviceMotionEventInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!EventInit::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->acceleration_id, temp.ptr())) {
      return false;
    }
  }
  if (!mAcceleration.Init(cx, (!isNull && !temp->isUndefined()) ? temp.ref() : JS::NullHandleValue, "'acceleration' member of DeviceMotionEventInit", passedToJSImpl)) {
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->accelerationIncludingGravity_id, temp.ptr())) {
      return false;
    }
  }
  if (!mAccelerationIncludingGravity.Init(cx, (!isNull && !temp->isUndefined()) ? temp.ref() : JS::NullHandleValue, "'accelerationIncludingGravity' member of DeviceMotionEventInit", passedToJSImpl)) {
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->interval_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mInterval.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'interval' member of DeviceMotionEventInit", &mInterval.SetValue())) {
    return false;
  } else if (!std::isfinite(mInterval.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("'interval' member of DeviceMotionEventInit");
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->rotationRate_id, temp.ptr())) {
      return false;
    }
  }
  if (!mRotationRate.Init(cx, (!isNull && !temp->isUndefined()) ? temp.ref() : JS::NullHandleValue, "'rotationRate' member of DeviceMotionEventInit", passedToJSImpl)) {
    return false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
DeviceMotionEventInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
DeviceMotionEventInit::TraceDictionary(JSTracer* trc)
{
  EventInit::TraceDictionary(trc);
}

DeviceMotionEventInit&
DeviceMotionEventInit::operator=(const DeviceMotionEventInit& aOther)
{
  EventInit::operator=(aOther);
  mAcceleration = aOther.mAcceleration;
  mAccelerationIncludingGravity = aOther.mAccelerationIncludingGravity;
  mInterval = aOther.mInterval;
  mRotationRate = aOther.mRotationRate;
  return *this;
}


namespace DeviceAcceleration_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_x(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceAcceleration", "x", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceAcceleration*>(void_self);
  Nullable<double> result(MOZ_KnownLive(self)->GetX());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().set(JS_NumberValue(double(result.Value())));
  return true;
}

static const JSJitInfo x_getterinfo = {
  { get_x },
  { prototypes::id::DeviceAcceleration },
  { PrototypeTraits<prototypes::id::DeviceAcceleration>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_y(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceAcceleration", "y", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceAcceleration*>(void_self);
  Nullable<double> result(MOZ_KnownLive(self)->GetY());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().set(JS_NumberValue(double(result.Value())));
  return true;
}

static const JSJitInfo y_getterinfo = {
  { get_y },
  { prototypes::id::DeviceAcceleration },
  { PrototypeTraits<prototypes::id::DeviceAcceleration>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_z(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceAcceleration", "z", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceAcceleration*>(void_self);
  Nullable<double> result(MOZ_KnownLive(self)->GetZ());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().set(JS_NumberValue(double(result.Value())));
  return true;
}

static const JSJitInfo z_getterinfo = {
  { get_z },
  { prototypes::id::DeviceAcceleration },
  { PrototypeTraits<prototypes::id::DeviceAcceleration>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::DeviceAcceleration* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::DeviceAcceleration>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::DeviceAcceleration>(self);
  }
}

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("x", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &x_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("y", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &y_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("z", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &z_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sNativeProperties_propertyInfos[3];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sNativeProperties_sortedPropertyIndices,
  {
    { sAttributes, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::DeviceAcceleration,
  constructors::id::_ID_Count,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "DeviceAccelerationPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::DeviceAcceleration,
  PrototypeTraits<prototypes::id::DeviceAcceleration>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "DeviceAcceleration",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::DeviceAcceleration>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::DeviceAcceleration, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::DeviceAcceleration>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::DeviceAcceleration>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::DeviceAcceleration>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::DeviceAcceleration>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::DeviceAcceleration* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::DeviceAcceleration>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::DeviceAcceleration*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::DeviceAcceleration> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::DeviceAcceleration);
  JS::Heap<JSObject*>* interfaceCache = nullptr;

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              nullptr, nullptr, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "DeviceAcceleration",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::DeviceAcceleration,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

} // namespace DeviceAcceleration_Binding



namespace DeviceMotionEvent_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<Event_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_acceleration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceMotionEvent", "acceleration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceMotionEvent*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::DeviceAcceleration>(MOZ_KnownLive(self)->GetAcceleration()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo acceleration_getterinfo = {
  { get_acceleration },
  { prototypes::id::DeviceMotionEvent },
  { PrototypeTraits<prototypes::id::DeviceMotionEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_accelerationIncludingGravity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceMotionEvent", "accelerationIncludingGravity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceMotionEvent*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::DeviceAcceleration>(MOZ_KnownLive(self)->GetAccelerationIncludingGravity()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo accelerationIncludingGravity_getterinfo = {
  { get_accelerationIncludingGravity },
  { prototypes::id::DeviceMotionEvent },
  { PrototypeTraits<prototypes::id::DeviceMotionEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_rotationRate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceMotionEvent", "rotationRate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceMotionEvent*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::DeviceRotationRate>(MOZ_KnownLive(self)->GetRotationRate()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo rotationRate_getterinfo = {
  { get_rotationRate },
  { prototypes::id::DeviceMotionEvent },
  { PrototypeTraits<prototypes::id::DeviceMotionEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_interval(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceMotionEvent", "interval", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceMotionEvent*>(void_self);
  Nullable<double> result(MOZ_KnownLive(self)->GetInterval());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().set(JS_NumberValue(double(result.Value())));
  return true;
}

static const JSJitInfo interval_getterinfo = {
  { get_interval },
  { prototypes::id::DeviceMotionEvent },
  { PrototypeTraits<prototypes::id::DeviceMotionEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
initDeviceMotionEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "DeviceMotionEvent.initDeviceMotionEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceMotionEvent", "initDeviceMotionEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceMotionEvent*>(void_self);
  if (!args.requireAtLeast(cx, "DeviceMotionEvent.initDeviceMotionEvent", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  binding_detail::FastDeviceAccelerationInit arg3;
  if (!arg3.Init(cx, (args.hasDefined(3)) ? args[3] : JS::NullHandleValue, "Argument 4", false)) {
    return false;
  }
  binding_detail::FastDeviceAccelerationInit arg4;
  if (!arg4.Init(cx, (args.hasDefined(4)) ? args[4] : JS::NullHandleValue, "Argument 5", false)) {
    return false;
  }
  binding_detail::FastDeviceRotationRateInit arg5;
  if (!arg5.Init(cx, (args.hasDefined(5)) ? args[5] : JS::NullHandleValue, "Argument 6", false)) {
    return false;
  }
  Nullable<double> arg6;
  if (!(args.hasDefined(6)) || args[6].isNullOrUndefined()) {
    arg6.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, args[6], "Argument 7", &arg6.SetValue())) {
    return false;
  } else if (!std::isfinite(arg6.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 7");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->InitDeviceMotionEvent(NonNullHelper(Constify(arg0)), arg1, arg2, Constify(arg3), Constify(arg4), Constify(arg5), Constify(arg6)))>, "Should be returning void here");
  MOZ_KnownLive(self)->InitDeviceMotionEvent(NonNullHelper(Constify(arg0)), arg1, arg2, Constify(arg3), Constify(arg4), Constify(arg5), Constify(arg6));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo initDeviceMotionEvent_methodinfo = {
  { (JSJitGetterOp)initDeviceMotionEvent },
  { prototypes::id::DeviceMotionEvent },
  { PrototypeTraits<prototypes::id::DeviceMotionEvent>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isTrusted(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceMotionEvent", "isTrusted", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceMotionEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->IsTrusted());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isTrusted_getterinfo = {
  { get_isTrusted },
  { prototypes::id::DeviceMotionEvent },
  { PrototypeTraits<prototypes::id::DeviceMotionEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::DeviceMotionEvent* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::DeviceMotionEvent>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::DeviceMotionEvent>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("initDeviceMotionEvent", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&initDeviceMotionEvent_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("acceleration", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &acceleration_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("accelerationIncludingGravity", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &accelerationIncludingGravity_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("rotationRate", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &rotationRate_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("interval", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &interval_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sUnforgeableAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("isTrusted", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isTrusted_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sUnforgeableAttributes[] = {
  { nullptr, &sUnforgeableAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[6];
static PropertyInfo sNativeProperties_propertyInfos[6];

static const NativePropertiesN<3> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  true,  2 /* sUnforgeableAttributes */,
  false, 0,
  -1,
  6,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[1] },
    { sUnforgeableAttributes, &sNativeProperties_propertyInfos[5] }
  }
};
static_assert(6 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::DeviceMotionEvent,
  constructors::id::DeviceMotionEvent,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "DeviceMotionEvent constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceMotionEvent", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "DeviceMotionEvent");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::DeviceMotionEvent,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "DeviceMotionEvent constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FastDeviceMotionEventInit arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  auto result(StrongOrRawPtr<mozilla::dom::DeviceMotionEvent>(mozilla::dom::DeviceMotionEvent::Constructor(global, NonNullHelper(Constify(arg0)), Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  Event_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::DeviceMotionEvent>::Depth,
  prototypes::id::DeviceMotionEvent,
  true,
  1,
  "DeviceMotionEvent",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "DeviceMotionEventPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE + 1 /* slot for the JSObject holding the unforgeable properties */),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::DeviceMotionEvent,
  PrototypeTraits<prototypes::id::DeviceMotionEvent>::Depth,
  &sNativePropertyHooks,
  Event_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::device_sensors_motion_enabled() &&
         nsGlobalWindowInner::DeviceSensorsEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "DeviceMotionEvent",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_SKIP_NURSERY_FINALIZE | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::DeviceMotionEvent>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Event, prototypes::id::DeviceMotionEvent, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::DeviceMotionEvent>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::DeviceMotionEvent>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::DeviceMotionEvent>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::DeviceMotionEvent>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::DeviceMotionEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::DeviceMotionEvent>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::DeviceMotionEvent*>);
  MOZ_ASSERT(static_cast<mozilla::dom::Event*>(aObject) ==
             reinterpret_cast<mozilla::dom::Event*>(aObject),
             "Multiple inheritance for mozilla::dom::Event is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::DeviceMotionEvent> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);

  // Important: do unforgeable property setup after we have handed
  // over ownership of the C++ object to obj as needed, so that if
  // we fail and it ends up GCed it won't have problems in the
  // finalizer trying to drop its ownership of the C++ object.
  JS::Rooted<JSObject*> unforgeableHolder(aCx,
    &JS::GetReservedSlot(canonicalProto, DOM_INTERFACE_PROTO_SLOTS_BASE).toObject());
  if (!JS_InitializePropertiesFromCompatibleNativeObject(aCx, aReflector, unforgeableHolder)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::DeviceMotionEvent);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::DeviceMotionEvent);

  JS::Handle<JSObject*> parentProto(Event_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(Event_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "DeviceMotionEvent",
                              ShouldExpose<DeviceMotionEvent_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  JS::Rooted<JSObject*> unforgeableHolder(
      aCx, JS_NewObjectWithoutMetadata(aCx, sClass.ToJSClass(), proto));
  if (!unforgeableHolder) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (!DefineLegacyUnforgeableAttributes(aCx, unforgeableHolder, sUnforgeableAttributes)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (*protoCache) {
    JS::SetReservedSlot(*protoCache, DOM_INTERFACE_PROTO_SLOTS_BASE,
                        JS::ObjectValue(*unforgeableHolder));
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::DeviceMotionEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::DeviceMotionEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace DeviceMotionEvent_Binding



namespace DeviceRotationRate_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_alpha(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceRotationRate", "alpha", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceRotationRate*>(void_self);
  Nullable<double> result(MOZ_KnownLive(self)->GetAlpha());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().set(JS_NumberValue(double(result.Value())));
  return true;
}

static const JSJitInfo alpha_getterinfo = {
  { get_alpha },
  { prototypes::id::DeviceRotationRate },
  { PrototypeTraits<prototypes::id::DeviceRotationRate>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_beta(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceRotationRate", "beta", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceRotationRate*>(void_self);
  Nullable<double> result(MOZ_KnownLive(self)->GetBeta());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().set(JS_NumberValue(double(result.Value())));
  return true;
}

static const JSJitInfo beta_getterinfo = {
  { get_beta },
  { prototypes::id::DeviceRotationRate },
  { PrototypeTraits<prototypes::id::DeviceRotationRate>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gamma(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DeviceRotationRate", "gamma", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DeviceRotationRate*>(void_self);
  Nullable<double> result(MOZ_KnownLive(self)->GetGamma());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().set(JS_NumberValue(double(result.Value())));
  return true;
}

static const JSJitInfo gamma_getterinfo = {
  { get_gamma },
  { prototypes::id::DeviceRotationRate },
  { PrototypeTraits<prototypes::id::DeviceRotationRate>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::DeviceRotationRate* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::DeviceRotationRate>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::DeviceRotationRate>(self);
  }
}

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("alpha", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &alpha_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("beta", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &beta_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("gamma", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &gamma_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sNativeProperties_propertyInfos[3];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sNativeProperties_sortedPropertyIndices,
  {
    { sAttributes, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::DeviceRotationRate,
  constructors::id::_ID_Count,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "DeviceRotationRatePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::DeviceRotationRate,
  PrototypeTraits<prototypes::id::DeviceRotationRate>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "DeviceRotationRate",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::DeviceRotationRate>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::DeviceRotationRate, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::DeviceRotationRate>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::DeviceRotationRate>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::DeviceRotationRate>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::DeviceRotationRate>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::DeviceRotationRate* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::DeviceRotationRate>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::DeviceRotationRate*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::DeviceRotationRate> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::DeviceRotationRate);
  JS::Heap<JSObject*>* interfaceCache = nullptr;

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              nullptr, nullptr, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "DeviceRotationRate",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::DeviceRotationRate,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

} // namespace DeviceRotationRate_Binding



} // namespace mozilla::dom
