#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "uae/memory.h"
#include "custom.h"
#include "events.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#define CPUFUNC(x) x##_ff
#define SET_CFLG_ALWAYS(x) SET_CFLG(x)
#define SET_NFLG_ALWAYS(x) SET_NFLG(x)
#ifdef NOFLAGS
#include "noflags.h"
#endif

#ifdef CPUEMU_13

#pragma GCC diagnostic ignored "-Wunused-variable"
#if !defined __clang_analyzer__

#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
/* OR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0000_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* OR.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0010_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* OR.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0018_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* OR.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0020_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* OR.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0028_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* OR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0030_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* OR.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0038_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* OR.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0039_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
} /* 24 (5/1) */

/* ORSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_003c_13)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce000_prefetch (4);
	src &= 0xFF;
	do_cycles_ce000_internal (8);
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	regs.sr |= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
}}return;
} /* 20 (3/0) */

/* OR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0040_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* OR.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0050_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130011;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130011: ;
return;
} /* 16 (3/1) */

/* OR.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0058_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130012;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130012: ;
return;
} /* 16 (3/1) */

/* OR.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0060_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130013;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130013: ;
return;
} /* 18 (3/1) */

/* OR.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0068_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130014;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130014: ;
return;
} /* 20 (4/1) */

/* OR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0070_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130015;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130015: ;
return;
} /* 22 (4/1) */

/* OR.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0078_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130016;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130016: ;
return;
} /* 20 (4/1) */

/* OR.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0079_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130017;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (8);
l_130017: ;
return;
} /* 24 (5/1) */

/* ORSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_007c_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130018; }
{	MakeSR ();
{	uae_s16 src = get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (8);
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	regs.sr |= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
}}}l_130018: ;
return;
} /* 20 (3/0) */

/* OR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0080_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* OR.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0090_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130020;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130020: ;
return;
} /* 28 (5/2) */

/* OR.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0098_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130021;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130021: ;
return;
} /* 28 (5/2) */

/* OR.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_00a0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130022;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130022: ;
return;
} /* 30 (5/2) */

/* OR.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_00a8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130023;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130023: ;
return;
} /* 32 (6/2) */

/* OR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_00b0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130024;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130024: ;
return;
} /* 34 (6/2) */

/* OR.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_00b8_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130025;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130025: ;
return;
} /* 32 (6/2) */

/* OR.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_00b9_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= get_word_ce000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130026;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (12);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (10);
l_130026: ;
return;
} /* 36 (7/2) */

/* BTST.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 31;
	do_cycles_ce000_internal (2);
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* MVPMR.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_0108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_u16 val = ((x_get_byte (memp) & 0xff) << 8) + (x_get_byte (memp + 2) & 0xff);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}	m68k_incpci (4);
return;
} /* 16 (4/0) */

/* BTST.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* BTST.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* BTST.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_0120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (2);
return;
} /* 10 (2/0) */

/* BTST.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* BTST.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* BTST.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_0138_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* BTST.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_0139_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* BTST.B Dn,(d16,PC) */
void REGPARAM2 CPUFUNC(op_013a_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_getpci () + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* BTST.B Dn,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_013b_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* BTST.B Dn,#<data>.B */
void REGPARAM2 CPUFUNC(op_013c_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = (uae_u8)get_word_ce000_prefetch (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* BCHG.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 31;
	do_cycles_ce000_internal (2);
	if (src > 15) do_cycles_ce000_internal (2);
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* MVPMR.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_0148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_u32 val = ((x_get_byte (memp) & 0xff) << 24) + ((x_get_byte (memp + 2) & 0xff) << 16)
              + ((x_get_byte (memp + 4) & 0xff) << 8) + (x_get_byte (memp + 6) & 0xff);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (val);
}}	m68k_incpci (4);
return;
} /* 24 (6/0) */

/* BCHG.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* BCHG.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* BCHG.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_0160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* BCHG.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BCHG.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* BCHG.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_0178_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BCHG.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_0179_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* BCLR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 31;
	do_cycles_ce000_internal (2);
	if (src > 15) do_cycles_ce000_internal (2);
	do_cycles_ce000_internal (2);
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* MVPRM.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0188_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	x_put_byte (memp, src >> 8);
	x_put_byte (memp + 2, src);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}	m68k_incpci (4);
return;
} /* 16 (2/2) */

/* BCLR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* BCLR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* BCLR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_01a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* BCLR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BCLR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_01b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* BCLR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_01b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BCLR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_01b9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* BSET.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_01c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 31;
	do_cycles_ce000_internal (2);
	if (src > 15) do_cycles_ce000_internal (2);
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* MVPRM.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	x_put_byte (memp, src >> 24);
	x_put_byte (memp + 2, src >> 16);
	x_put_byte (memp + 4, src >> 8);
	x_put_byte (memp + 6, src);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}	m68k_incpci (4);
return;
} /* 24 (2/4) */

/* BSET.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_01d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* BSET.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_01d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* BSET.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_01e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* BSET.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BSET.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_01f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* BSET.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_01f8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BSET.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_01f9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* AND.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0200_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* AND.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0210_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* AND.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0218_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* AND.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0220_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* AND.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0228_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* AND.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0230_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* AND.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0238_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* AND.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0239_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
} /* 24 (5/1) */

/* ANDSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_023c_13)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce000_prefetch (4);
	src |= 0xFF00;
	do_cycles_ce000_internal (8);
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	regs.sr &= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
}}return;
} /* 20 (3/0) */

/* AND.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0240_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* AND.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0250_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130076;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130076: ;
return;
} /* 16 (3/1) */

/* AND.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0258_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130077;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130077: ;
return;
} /* 16 (3/1) */

/* AND.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0260_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130078;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130078: ;
return;
} /* 18 (3/1) */

/* AND.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0268_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130079;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130079: ;
return;
} /* 20 (4/1) */

/* AND.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0270_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130080;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130080: ;
return;
} /* 22 (4/1) */

/* AND.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0278_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130081;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130081: ;
return;
} /* 20 (4/1) */

/* AND.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0279_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130082;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (8);
l_130082: ;
return;
} /* 24 (5/1) */

/* ANDSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_027c_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130083; }
{	MakeSR ();
{	uae_s16 src = get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (8);
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	regs.sr &= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
}}}l_130083: ;
return;
} /* 20 (3/0) */

/* AND.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0280_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* AND.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0290_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130085;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130085: ;
return;
} /* 28 (5/2) */

/* AND.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0298_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130086;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130086: ;
return;
} /* 28 (5/2) */

/* AND.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_02a0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130087;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130087: ;
return;
} /* 30 (5/2) */

/* AND.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_02a8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130088;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130088: ;
return;
} /* 32 (6/2) */

/* AND.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_02b0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130089;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130089: ;
return;
} /* 34 (6/2) */

/* AND.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_02b8_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130090;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130090: ;
return;
} /* 32 (6/2) */

/* AND.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_02b9_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= get_word_ce000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130091;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (12);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (10);
l_130091: ;
return;
} /* 36 (7/2) */

/* SUB.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0400_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* SUB.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0410_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* SUB.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0418_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* SUB.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0420_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* SUB.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0428_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* SUB.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0430_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* SUB.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0438_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* SUB.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0439_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
} /* 24 (5/1) */

/* SUB.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0440_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* SUB.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0450_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130101;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130101: ;
return;
} /* 16 (3/1) */

/* SUB.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0458_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130102;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130102: ;
return;
} /* 16 (3/1) */

/* SUB.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0460_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130103;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130103: ;
return;
} /* 18 (3/1) */

/* SUB.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0468_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130104;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_130104: ;
return;
} /* 20 (4/1) */

/* SUB.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0470_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130105;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_130105: ;
return;
} /* 22 (4/1) */

/* SUB.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0478_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130106;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_130106: ;
return;
} /* 20 (4/1) */

/* SUB.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0479_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130107;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (8);
l_130107: ;
return;
} /* 24 (5/1) */

/* SUB.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0480_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* SUB.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0490_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130109;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_130109: ;
return;
} /* 28 (5/2) */

/* SUB.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0498_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130110;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_130110: ;
return;
} /* 28 (5/2) */

/* SUB.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_04a0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130111;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_130111: ;
return;
} /* 30 (5/2) */

/* SUB.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_04a8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130112;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_130112: ;
return;
} /* 32 (6/2) */

/* SUB.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_04b0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130113;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_130113: ;
return;
} /* 34 (6/2) */

/* SUB.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_04b8_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130114;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_130114: ;
return;
} /* 32 (6/2) */

/* SUB.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_04b9_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= get_word_ce000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130115;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (12);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (10);
l_130115: ;
return;
} /* 36 (7/2) */

/* ADD.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0600_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* ADD.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0610_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* ADD.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0618_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* ADD.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0620_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* ADD.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0628_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* ADD.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0630_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* ADD.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0638_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* ADD.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0639_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
} /* 24 (5/1) */

/* ADD.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0640_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* ADD.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0650_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130125;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130125: ;
return;
} /* 16 (3/1) */

/* ADD.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0658_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130126;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130126: ;
return;
} /* 16 (3/1) */

/* ADD.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0660_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130127;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130127: ;
return;
} /* 18 (3/1) */

/* ADD.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0668_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130128;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_130128: ;
return;
} /* 20 (4/1) */

/* ADD.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0670_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130129;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_130129: ;
return;
} /* 22 (4/1) */

/* ADD.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0678_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130130;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_130130: ;
return;
} /* 20 (4/1) */

/* ADD.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0679_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130131;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (8);
l_130131: ;
return;
} /* 24 (5/1) */

/* ADD.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0680_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* ADD.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0690_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130133;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_130133: ;
return;
} /* 28 (5/2) */

/* ADD.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0698_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130134;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_130134: ;
return;
} /* 28 (5/2) */

/* ADD.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_06a0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130135;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_130135: ;
return;
} /* 30 (5/2) */

/* ADD.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_06a8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130136;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_130136: ;
return;
} /* 32 (6/2) */

/* ADD.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_06b0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130137;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_130137: ;
return;
} /* 34 (6/2) */

/* ADD.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_06b8_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130138;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_130138: ;
return;
} /* 32 (6/2) */

/* ADD.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_06b9_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= get_word_ce000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130139;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (12);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (10);
l_130139: ;
return;
} /* 36 (7/2) */

/* BTST.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0800_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 31;
	do_cycles_ce000_internal (2);
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}	m68k_incpci (4);
return;
} /* 10 (2/0) */

/* BTST.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0810_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* BTST.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0818_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* BTST.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0820_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* BTST.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0828_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* BTST.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0830_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return;
} /* 18 (4/0) */

/* BTST.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0838_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* BTST.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0839_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (8);
return;
} /* 20 (5/0) */

/* BTST.B #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_083a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* BTST.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_083b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpci () + 4;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return;
} /* 18 (4/0) */

/* BCHG.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0840_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 31;
	do_cycles_ce000_internal (2);
	if (src > 15) do_cycles_ce000_internal (2);
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
} /* 10+ (2/0) */

/* BCHG.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0850_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BCHG.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0858_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BCHG.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0860_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* BCHG.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0868_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* BCHG.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0870_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* BCHG.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0878_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* BCHG.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0879_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
} /* 24 (5/1) */

/* BCLR.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0880_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 31;
	do_cycles_ce000_internal (2);
	if (src > 15) do_cycles_ce000_internal (2);
	do_cycles_ce000_internal (2);
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
} /* 12+ (2/0) */

/* BCLR.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0890_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BCLR.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0898_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BCLR.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_08a0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* BCLR.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_08a8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* BCLR.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_08b0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* BCLR.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_08b8_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* BCLR.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_08b9_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
} /* 24 (5/1) */

/* BSET.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_08c0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 31;
	do_cycles_ce000_internal (2);
	if (src > 15) do_cycles_ce000_internal (2);
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
} /* 10+ (2/0) */

/* BSET.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_08d0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BSET.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_08d8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* BSET.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_08e0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* BSET.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_08e8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* BSET.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_08f0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* BSET.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_08f8_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* BSET.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_08f9_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	ipl_fetch ();
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
} /* 24 (5/1) */

/* EOR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0a00_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* EOR.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0a10_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* EOR.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0a18_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* EOR.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0a20_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* EOR.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0a28_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* EOR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0a30_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* EOR.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0a38_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* EOR.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0a39_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
} /* 24 (5/1) */

/* EORSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_0a3c_13)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce000_prefetch (4);
	src &= 0xFF;
	do_cycles_ce000_internal (8);
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	regs.sr ^= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
}}return;
} /* 20 (3/0) */

/* EOR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0a40_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* EOR.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0a50_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130184;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130184: ;
return;
} /* 16 (3/1) */

/* EOR.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0a58_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130185;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130185: ;
return;
} /* 16 (3/1) */

/* EOR.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0a60_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130186;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_130186: ;
return;
} /* 18 (3/1) */

/* EOR.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0a68_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130187;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130187: ;
return;
} /* 20 (4/1) */

/* EOR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0a70_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130188;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130188: ;
return;
} /* 22 (4/1) */

/* EOR.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0a78_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130189;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_130189: ;
return;
} /* 20 (4/1) */

/* EOR.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0a79_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130190;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (8);
l_130190: ;
return;
} /* 24 (5/1) */

/* EORSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_0a7c_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130191; }
{	MakeSR ();
{	uae_s16 src = get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (8);
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	regs.sr ^= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
}}}l_130191: ;
return;
} /* 20 (3/0) */

/* EOR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0a80_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* EOR.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0a90_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130193;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130193: ;
return;
} /* 28 (5/2) */

/* EOR.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0a98_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130194;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130194: ;
return;
} /* 28 (5/2) */

/* EOR.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_0aa0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130195;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_130195: ;
return;
} /* 30 (5/2) */

/* EOR.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_0aa8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130196;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130196: ;
return;
} /* 32 (6/2) */

/* EOR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0ab0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130197;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130197: ;
return;
} /* 34 (6/2) */

/* EOR.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_0ab8_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130198;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_130198: ;
return;
} /* 32 (6/2) */

/* EOR.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_0ab9_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= get_word_ce000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130199;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (12);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (10);
l_130199: ;
return;
} /* 36 (7/2) */

#endif

#ifdef PART_2
/* CMP.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0c00_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* CMP.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0c10_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* CMP.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0c18_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* CMP.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0c20_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* CMP.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0c28_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* CMP.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0c30_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
} /* 18 (4/0) */

/* CMP.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0c38_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* CMP.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0c39_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
} /* 20 (5/0) */

/* CMP.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0c40_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* CMP.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0c50_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130209;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_130209: ;
return;
} /* 12 (3/0) */

/* CMP.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0c58_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130210;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_130210: ;
return;
} /* 12 (3/0) */

/* CMP.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0c60_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130211;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_130211: ;
return;
} /* 14 (3/0) */

/* CMP.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0c68_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130212;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_130212: ;
return;
} /* 16 (4/0) */

/* CMP.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0c70_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130213;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_130213: ;
return;
} /* 18 (4/0) */

/* CMP.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0c78_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130214;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_130214: ;
return;
} /* 16 (4/0) */

/* CMP.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0c79_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130215;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (8);
l_130215: ;
return;
} /* 20 (5/0) */

/* CMP.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0c80_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (6);
return;
} /* 14 (3/0) */

/* CMP.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0c90_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130217;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_130217: ;
return;
} /* 20 (5/0) */

/* CMP.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0c98_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130218;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_130218: ;
return;
} /* 20 (5/0) */

/* CMP.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_0ca0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130219;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_130219: ;
return;
} /* 22 (5/0) */

/* CMP.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_0ca8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130220;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (8);
l_130220: ;
return;
} /* 24 (6/0) */

/* CMP.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0cb0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130221;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (8);
l_130221: ;
return;
} /* 26 (6/0) */

/* CMP.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_0cb8_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130222;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (8);
l_130222: ;
return;
} /* 24 (6/0) */

/* CMP.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_0cb9_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= get_word_ce000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130223;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (12);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (10);
l_130223: ;
return;
} /* 28 (7/0) */

/* MOVE.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_1000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVE.B (An),Dn */
void REGPARAM2 CPUFUNC(op_1010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 8 (2/0) */

/* MOVE.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_1018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 8 (2/0) */

/* MOVE.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_1020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 10 (2/0) */

/* MOVE.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_1028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 12 (3/0) */

/* MOVE.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_1030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 14 (3/0) */

/* MOVE.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_1038_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 12 (3/0) */

/* MOVE.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_1039_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (4/0) */

/* MOVE.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_103a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 12 (3/0) */

/* MOVE.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_103b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 14 (3/0) */

/* MOVE.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_103c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 8 (2/0) */

/* MOVE.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_1080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 8 (1/1) */

/* MOVE.B (An),(An) */
void REGPARAM2 CPUFUNC(op_1090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 12 (2/1) */

/* MOVE.B (An)+,(An) */
void REGPARAM2 CPUFUNC(op_1098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 12 (2/1) */

/* MOVE.B -(An),(An) */
void REGPARAM2 CPUFUNC(op_10a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 14 (2/1) */

/* MOVE.B (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_10a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_10b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_10b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_10b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_10ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_10bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_10bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 12 (2/1) */

/* MOVE.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_10c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 8 (1/1) */

/* MOVE.B (An),(An)+ */
void REGPARAM2 CPUFUNC(op_10d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 12 (2/1) */

/* MOVE.B (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_10d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 12 (2/1) */

/* MOVE.B -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_10e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 14 (2/1) */

/* MOVE.B (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_10e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_10f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_10f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_10f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_10fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_10fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_10fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 12 (2/1) */

/* MOVE.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_1100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}return;
} /* 8 (1/1) */

/* MOVE.B (An),-(An) */
void REGPARAM2 CPUFUNC(op_1110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
} /* 12 (2/1) */

/* MOVE.B (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_1118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
} /* 12 (2/1) */

/* MOVE.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_1120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
} /* 14 (2/1) */

/* MOVE.B (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_1128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_1130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_1138_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_1139_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_113a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_113b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_113c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
} /* 12 (2/1) */

/* MOVE.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_1140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 12 (2/1) */

/* MOVE.B (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_1158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_1170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 22 (4/1) */

/* MOVE.B (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_1178_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_1179_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 24 (5/1) */

/* MOVE.B (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_117a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_117b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 22 (4/1) */

/* MOVE.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_117c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 16 (3/1) */

/* MOVE.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 14 (2/1) */

/* MOVE.B (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (3/1) */

/* MOVE.B (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 22 (4/1) */

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 24 (4/1) */

/* MOVE.B (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 22 (4/1) */

/* MOVE.B (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 26 (5/1) */

/* MOVE.B (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 22 (4/1) */

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 24 (4/1) */

/* MOVE.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 18 (3/1) */

/* MOVE.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_11c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 12 (2/1) */

/* MOVE.B (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_11d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 16 (3/1) */

/* MOVE.B -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 18 (3/1) */

/* MOVE.B (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_11f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 22 (4/1) */

/* MOVE.B (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_11f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_11f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 24 (5/1) */

/* MOVE.B (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_11fa_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_11fb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 22 (4/1) */

/* MOVE.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_11fc_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 16 (3/1) */

/* MOVE.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_13c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 16 (3/1) */

/* MOVE.B (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_13d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 20 (4/1) */

/* MOVE.B -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 22 (4/1) */

/* MOVE.B (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 24 (5/1) */

/* MOVE.B (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_13f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 26 (5/1) */

/* MOVE.B (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_13f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 24 (5/1) */

/* MOVE.B (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_13f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (10);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 28 (6/1) */

/* MOVE.B (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_13fa_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 24 (5/1) */

/* MOVE.B (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_13fb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}return;
} /* 26 (5/1) */

/* MOVE.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_13fc_13)(uae_u32 opcode)
{
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	x_put_byte (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 20 (4/1) */

/* MOVE.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_2000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVE.L An,Dn */
void REGPARAM2 CPUFUNC(op_2008_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVE.L (An),Dn */
void REGPARAM2 CPUFUNC(op_2010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130314;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130314: ;
return;
} /* 12 (3/0) */

/* MOVE.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_2018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130315;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130315: ;
return;
} /* 12 (3/0) */

/* MOVE.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_2020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130316;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130316: ;
return;
} /* 14 (3/0) */

/* MOVE.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_2028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130317;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130317: ;
return;
} /* 16 (4/0) */

/* MOVE.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_2030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130318;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130318: ;
return;
} /* 18 (4/0) */

/* MOVE.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_2038_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130319;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130319: ;
return;
} /* 16 (4/0) */

/* MOVE.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_2039_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130320;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130320: ;
return;
} /* 20 (5/0) */

/* MOVE.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_203a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130321;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130321: ;
return;
} /* 16 (4/0) */

/* MOVE.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_203b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130322;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130322: ;
return;
} /* 18 (4/0) */

/* MOVE.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_203c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 12 (3/0) */

/* MOVEA.L Dn,An */
void REGPARAM2 CPUFUNC(op_2040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVEA.L An,An */
void REGPARAM2 CPUFUNC(op_2048_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVEA.L (An),An */
void REGPARAM2 CPUFUNC(op_2050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130326;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130326: ;
return;
} /* 12 (3/0) */

/* MOVEA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_2058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130327;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130327: ;
return;
} /* 12 (3/0) */

/* MOVEA.L -(An),An */
void REGPARAM2 CPUFUNC(op_2060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130328;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130328: ;
return;
} /* 14 (3/0) */

/* MOVEA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_2068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130329;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130329: ;
return;
} /* 16 (4/0) */

/* MOVEA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_2070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130330;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130330: ;
return;
} /* 18 (4/0) */

/* MOVEA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_2078_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130331;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130331: ;
return;
} /* 16 (4/0) */

/* MOVEA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_2079_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130332;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130332: ;
return;
} /* 20 (5/0) */

/* MOVEA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_207a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130333;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130333: ;
return;
} /* 16 (4/0) */

/* MOVEA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_207b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130334;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130334: ;
return;
} /* 18 (4/0) */

/* MOVEA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_207c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 12 (3/0) */

/* MOVE.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_2080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130336;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130336: ;
return;
} /* 12 (1/2) */

/* MOVE.L An,(An) */
void REGPARAM2 CPUFUNC(op_2088_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130337;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130337: ;
return;
} /* 12 (1/2) */

/* MOVE.L (An),(An) */
void REGPARAM2 CPUFUNC(op_2090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130338;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130338;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130338: ;
return;
} /* 20 (3/2) */

/* MOVE.L (An)+,(An) */
void REGPARAM2 CPUFUNC(op_2098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130339;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130339;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130339: ;
return;
} /* 20 (3/2) */

/* MOVE.L -(An),(An) */
void REGPARAM2 CPUFUNC(op_20a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130340;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130340;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130340: ;
return;
} /* 22 (3/2) */

/* MOVE.L (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_20a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130341;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130341;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130341: ;
return;
} /* 24 (4/2) */

/* MOVE.L (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_20b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130342;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130342;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130342: ;
return;
} /* 26 (4/2) */

/* MOVE.L (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_20b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130343;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130343;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130343: ;
return;
} /* 24 (4/2) */

/* MOVE.L (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_20b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130344;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130344;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130344: ;
return;
} /* 28 (5/2) */

/* MOVE.L (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_20ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130345;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130345;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130345: ;
return;
} /* 24 (4/2) */

/* MOVE.L (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_20bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130346;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130346;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130346: ;
return;
} /* 26 (4/2) */

/* MOVE.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_20bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130347;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130347: ;
return;
} /* 20 (3/2) */

/* MOVE.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_20c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130348;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130348: ;
return;
} /* 12 (1/2) */

/* MOVE.L An,(An)+ */
void REGPARAM2 CPUFUNC(op_20c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130349;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130349: ;
return;
} /* 12 (1/2) */

/* MOVE.L (An),(An)+ */
void REGPARAM2 CPUFUNC(op_20d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130350;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130350;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130350: ;
return;
} /* 20 (3/2) */

/* MOVE.L (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_20d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130351;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130351;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130351: ;
return;
} /* 20 (3/2) */

/* MOVE.L -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_20e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130352;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130352;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130352: ;
return;
} /* 22 (3/2) */

/* MOVE.L (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_20e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130353;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130353;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130353: ;
return;
} /* 24 (4/2) */

/* MOVE.L (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_20f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130354;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130354;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130354: ;
return;
} /* 26 (4/2) */

/* MOVE.L (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_20f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130355;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130355;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130355: ;
return;
} /* 24 (4/2) */

/* MOVE.L (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_20f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130356;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130356;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130356: ;
return;
} /* 28 (5/2) */

/* MOVE.L (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_20fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130357;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130357;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130357: ;
return;
} /* 24 (4/2) */

/* MOVE.L (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_20fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130358;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130358;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130358: ;
return;
} /* 26 (4/2) */

/* MOVE.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_20fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130359;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130359: ;
return;
} /* 20 (3/2) */

/* MOVE.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_2100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130360;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
}}}}l_130360: ;
return;
} /* 12 (1/2) */

/* MOVE.L An,-(An) */
void REGPARAM2 CPUFUNC(op_2108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130361;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
}}}}l_130361: ;
return;
} /* 12 (1/2) */

/* MOVE.L (An),-(An) */
void REGPARAM2 CPUFUNC(op_2110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130362;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130362;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
}}}}}}l_130362: ;
return;
} /* 20 (3/2) */

/* MOVE.L (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_2118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130363;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130363;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
}}}}}}l_130363: ;
return;
} /* 20 (3/2) */

/* MOVE.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_2120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130364;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130364;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (2);
}}}}}}l_130364: ;
return;
} /* 22 (3/2) */

/* MOVE.L (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_2128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130365;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130365;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_130365: ;
return;
} /* 24 (4/2) */

/* MOVE.L (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_2130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130366;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130366;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_130366: ;
return;
} /* 26 (4/2) */

/* MOVE.L (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_2138_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130367;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130367;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_130367: ;
return;
} /* 24 (4/2) */

/* MOVE.L (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_2139_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130368;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130368;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
}}}}}}l_130368: ;
return;
} /* 28 (5/2) */

/* MOVE.L (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_213a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130369;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130369;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_130369: ;
return;
} /* 24 (4/2) */

/* MOVE.L (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_213b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130370;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130370;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_130370: ;
return;
} /* 26 (4/2) */

/* MOVE.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_213c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130371;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
}}}}l_130371: ;
return;
} /* 20 (3/2) */

/* MOVE.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_2140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130372;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130372: ;
return;
} /* 16 (2/2) */

/* MOVE.L An,(d16,An) */
void REGPARAM2 CPUFUNC(op_2148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130373;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130373: ;
return;
} /* 16 (2/2) */

/* MOVE.L (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130374;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130374;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130374: ;
return;
} /* 24 (4/2) */

/* MOVE.L (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_2158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130375;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130375;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130375: ;
return;
} /* 24 (4/2) */

/* MOVE.L -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130376;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130376;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130376: ;
return;
} /* 26 (4/2) */

/* MOVE.L (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130377;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130377;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130377: ;
return;
} /* 28 (5/2) */

/* MOVE.L (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_2170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130378;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130378;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130378: ;
return;
} /* 30 (5/2) */

/* MOVE.L (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_2178_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130379;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130379;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130379: ;
return;
} /* 28 (5/2) */

/* MOVE.L (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_2179_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130380;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130380;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130380: ;
return;
} /* 32 (6/2) */

/* MOVE.L (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_217a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130381;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130381;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130381: ;
return;
} /* 28 (5/2) */

/* MOVE.L (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_217b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130382;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130382;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130382: ;
return;
} /* 30 (5/2) */

/* MOVE.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_217c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130383;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}}l_130383: ;
return;
} /* 24 (4/2) */

/* MOVE.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130384;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130384: ;
return;
} /* 18 (2/2) */

/* MOVE.L An,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2188_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130385;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130385: ;
return;
} /* 18 (2/2) */

/* MOVE.L (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130386;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130386;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130386: ;
return;
} /* 26 (4/2) */

/* MOVE.L (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130387;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130387;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130387: ;
return;
} /* 26 (4/2) */

#endif

#ifdef PART_3
/* MOVE.L -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130388;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130388;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130388: ;
return;
} /* 28 (4/2) */

/* MOVE.L (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130389;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130389;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130389: ;
return;
} /* 30 (5/2) */

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130390;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130390;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130390: ;
return;
} /* 32 (5/2) */

/* MOVE.L (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130391;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130391;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130391: ;
return;
} /* 30 (5/2) */

/* MOVE.L (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130392;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130392;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130392: ;
return;
} /* 34 (6/2) */

/* MOVE.L (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130393;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130393;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130393: ;
return;
} /* 30 (5/2) */

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130394;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130394;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130394: ;
return;
} /* 32 (5/2) */

/* MOVE.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130395;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130395: ;
return;
} /* 26 (4/2) */

/* MOVE.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_21c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130396;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130396: ;
return;
} /* 16 (2/2) */

/* MOVE.L An,(xxx).W */
void REGPARAM2 CPUFUNC(op_21c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130397;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130397: ;
return;
} /* 16 (2/2) */

/* MOVE.L (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130398;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130398;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130398: ;
return;
} /* 24 (4/2) */

/* MOVE.L (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_21d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130399;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130399;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130399: ;
return;
} /* 24 (4/2) */

/* MOVE.L -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130400;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130400;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130400: ;
return;
} /* 26 (4/2) */

/* MOVE.L (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130401;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130401;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130401: ;
return;
} /* 28 (5/2) */

/* MOVE.L (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_21f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130402;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130402;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130402: ;
return;
} /* 30 (5/2) */

/* MOVE.L (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_21f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130403;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130403;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130403: ;
return;
} /* 28 (5/2) */

/* MOVE.L (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_21f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130404;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130404;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130404: ;
return;
} /* 32 (6/2) */

/* MOVE.L (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_21fa_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130405;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130405;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130405: ;
return;
} /* 28 (5/2) */

/* MOVE.L (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_21fb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130406;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130406;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130406: ;
return;
} /* 30 (5/2) */

/* MOVE.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_21fc_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130407;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130407: ;
return;
} /* 24 (4/2) */

/* MOVE.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_23c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130408;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130408: ;
return;
} /* 20 (3/2) */

/* MOVE.L An,(xxx).L */
void REGPARAM2 CPUFUNC(op_23c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130409;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130409: ;
return;
} /* 20 (3/2) */

/* MOVE.L (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130410;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130410;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130410: ;
return;
} /* 28 (5/2) */

/* MOVE.L (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_23d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130411;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130411;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130411: ;
return;
} /* 28 (5/2) */

/* MOVE.L -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130412;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130412;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130412: ;
return;
} /* 30 (5/2) */

/* MOVE.L (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130413;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130413;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130413: ;
return;
} /* 32 (6/2) */

/* MOVE.L (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_23f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130414;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130414;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130414: ;
return;
} /* 34 (6/2) */

/* MOVE.L (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_23f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130415;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130415;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130415: ;
return;
} /* 32 (6/2) */

/* MOVE.L (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_23f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130416;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (10);
		exception3_write(opcode, dsta);
		goto l_130416;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (10);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130416: ;
return;
} /* 36 (7/2) */

/* MOVE.L (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_23fa_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130417;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130417;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130417: ;
return;
} /* 32 (6/2) */

/* MOVE.L (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_23fb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130418;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130418;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130418: ;
return;
} /* 34 (6/2) */

/* MOVE.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_23fc_13)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= get_word_ce000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (10);
		exception3_write(opcode, dsta);
		goto l_130419;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	x_put_word (dsta, src >> 16);
	x_put_word (dsta + 2, src);
	m68k_incpci (10);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130419: ;
return;
} /* 28 (5/2) */

/* MOVE.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_3000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVE.W An,Dn */
void REGPARAM2 CPUFUNC(op_3008_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVE.W (An),Dn */
void REGPARAM2 CPUFUNC(op_3010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130422;
	}
{{	uae_s16 src = x_get_word (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130422: ;
return;
} /* 8 (2/0) */

/* MOVE.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_3018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130423;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130423: ;
return;
} /* 8 (2/0) */

/* MOVE.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_3020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130424;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130424: ;
return;
} /* 10 (2/0) */

/* MOVE.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_3028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130425;
	}
{{	uae_s16 src = x_get_word (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130425: ;
return;
} /* 12 (3/0) */

/* MOVE.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_3030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130426;
	}
{{	uae_s16 src = x_get_word (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130426: ;
return;
} /* 14 (3/0) */

/* MOVE.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_3038_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130427;
	}
{{	uae_s16 src = x_get_word (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130427: ;
return;
} /* 12 (3/0) */

/* MOVE.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_3039_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130428;
	}
{{	uae_s16 src = x_get_word (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130428: ;
return;
} /* 16 (4/0) */

/* MOVE.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_303a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130429;
	}
{{	uae_s16 src = x_get_word (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130429: ;
return;
} /* 12 (3/0) */

/* MOVE.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_303b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130430;
	}
{{	uae_s16 src = x_get_word (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130430: ;
return;
} /* 14 (3/0) */

/* MOVE.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_303c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 8 (2/0) */

/* MOVEA.W Dn,An */
void REGPARAM2 CPUFUNC(op_3040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVEA.W An,An */
void REGPARAM2 CPUFUNC(op_3048_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* MOVEA.W (An),An */
void REGPARAM2 CPUFUNC(op_3050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130434;
	}
{{	uae_s16 src = x_get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130434: ;
return;
} /* 8 (2/0) */

/* MOVEA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_3058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130435;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130435: ;
return;
} /* 8 (2/0) */

/* MOVEA.W -(An),An */
void REGPARAM2 CPUFUNC(op_3060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130436;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130436: ;
return;
} /* 10 (2/0) */

/* MOVEA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_3068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130437;
	}
{{	uae_s16 src = x_get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130437: ;
return;
} /* 12 (3/0) */

/* MOVEA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_3070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130438;
	}
{{	uae_s16 src = x_get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130438: ;
return;
} /* 14 (3/0) */

/* MOVEA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_3078_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130439;
	}
{{	uae_s16 src = x_get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130439: ;
return;
} /* 12 (3/0) */

/* MOVEA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_3079_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130440;
	}
{{	uae_s16 src = x_get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130440: ;
return;
} /* 16 (4/0) */

/* MOVEA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_307a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130441;
	}
{{	uae_s16 src = x_get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130441: ;
return;
} /* 12 (3/0) */

/* MOVEA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_307b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130442;
	}
{{	uae_s16 src = x_get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130442: ;
return;
} /* 14 (3/0) */

/* MOVEA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_307c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 8 (2/0) */

/* MOVE.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_3080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130444;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130444: ;
return;
} /* 8 (1/1) */

/* MOVE.W An,(An) */
void REGPARAM2 CPUFUNC(op_3088_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130445;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130445: ;
return;
} /* 8 (1/1) */

/* MOVE.W (An),(An) */
void REGPARAM2 CPUFUNC(op_3090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130446;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130446;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130446: ;
return;
} /* 12 (2/1) */

/* MOVE.W (An)+,(An) */
void REGPARAM2 CPUFUNC(op_3098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130447;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130447;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130447: ;
return;
} /* 12 (2/1) */

/* MOVE.W -(An),(An) */
void REGPARAM2 CPUFUNC(op_30a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130448;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130448;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130448: ;
return;
} /* 14 (2/1) */

/* MOVE.W (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_30a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130449;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130449;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130449: ;
return;
} /* 16 (3/1) */

/* MOVE.W (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_30b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130450;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130450;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130450: ;
return;
} /* 18 (3/1) */

/* MOVE.W (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_30b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130451;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130451;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130451: ;
return;
} /* 16 (3/1) */

/* MOVE.W (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_30b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130452;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130452;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130452: ;
return;
} /* 20 (4/1) */

/* MOVE.W (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_30ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130453;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130453;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130453: ;
return;
} /* 16 (3/1) */

/* MOVE.W (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_30bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130454;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130454;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130454: ;
return;
} /* 18 (3/1) */

/* MOVE.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_30bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130455;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130455: ;
return;
} /* 12 (2/1) */

/* MOVE.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_30c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130456;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130456: ;
return;
} /* 8 (1/1) */

/* MOVE.W An,(An)+ */
void REGPARAM2 CPUFUNC(op_30c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130457;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130457: ;
return;
} /* 8 (1/1) */

/* MOVE.W (An),(An)+ */
void REGPARAM2 CPUFUNC(op_30d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130458;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130458;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130458: ;
return;
} /* 12 (2/1) */

/* MOVE.W (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_30d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130459;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130459;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130459: ;
return;
} /* 12 (2/1) */

/* MOVE.W -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_30e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130460;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130460;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130460: ;
return;
} /* 14 (2/1) */

/* MOVE.W (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_30e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130461;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130461;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130461: ;
return;
} /* 16 (3/1) */

/* MOVE.W (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_30f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130462;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130462;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130462: ;
return;
} /* 18 (3/1) */

/* MOVE.W (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_30f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130463;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130463;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130463: ;
return;
} /* 16 (3/1) */

/* MOVE.W (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_30f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130464;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130464;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130464: ;
return;
} /* 20 (4/1) */

/* MOVE.W (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_30fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130465;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130465;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130465: ;
return;
} /* 16 (3/1) */

/* MOVE.W (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_30fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130466;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130466;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130466: ;
return;
} /* 18 (3/1) */

/* MOVE.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_30fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130467;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130467: ;
return;
} /* 12 (2/1) */

/* MOVE.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_3100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130468;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}l_130468: ;
return;
} /* 8 (1/1) */

/* MOVE.W An,-(An) */
void REGPARAM2 CPUFUNC(op_3108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130469;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}l_130469: ;
return;
} /* 8 (1/1) */

/* MOVE.W (An),-(An) */
void REGPARAM2 CPUFUNC(op_3110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130470;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130470;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}}l_130470: ;
return;
} /* 12 (2/1) */

/* MOVE.W (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_3118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130471;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130471;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}}l_130471: ;
return;
} /* 12 (2/1) */

/* MOVE.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_3120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130472;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130472;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}}l_130472: ;
return;
} /* 14 (2/1) */

/* MOVE.W (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_3128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130473;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130473;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}}l_130473: ;
return;
} /* 16 (3/1) */

/* MOVE.W (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_3130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130474;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130474;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}}l_130474: ;
return;
} /* 18 (3/1) */

/* MOVE.W (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_3138_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130475;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130475;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}}l_130475: ;
return;
} /* 16 (3/1) */

/* MOVE.W (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_3139_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130476;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130476;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}}}l_130476: ;
return;
} /* 20 (4/1) */

/* MOVE.W (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_313a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130477;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130477;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}}l_130477: ;
return;
} /* 16 (3/1) */

/* MOVE.W (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_313b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130478;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130478;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}}l_130478: ;
return;
} /* 18 (3/1) */

/* MOVE.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_313c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130479;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	ipl_fetch ();
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}l_130479: ;
return;
} /* 12 (2/1) */

/* MOVE.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_3140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130480;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130480: ;
return;
} /* 12 (2/1) */

/* MOVE.W An,(d16,An) */
void REGPARAM2 CPUFUNC(op_3148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130481;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130481: ;
return;
} /* 12 (2/1) */

/* MOVE.W (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130482;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130482;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130482: ;
return;
} /* 16 (3/1) */

/* MOVE.W (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_3158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130483;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130483;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130483: ;
return;
} /* 16 (3/1) */

/* MOVE.W -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130484;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130484;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130484: ;
return;
} /* 18 (3/1) */

/* MOVE.W (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130485;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130485;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130485: ;
return;
} /* 20 (4/1) */

/* MOVE.W (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_3170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130486;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130486;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130486: ;
return;
} /* 22 (4/1) */

/* MOVE.W (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_3178_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130487;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130487;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130487: ;
return;
} /* 20 (4/1) */

/* MOVE.W (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_3179_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130488;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130488;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130488: ;
return;
} /* 24 (5/1) */

/* MOVE.W (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_317a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130489;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130489;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130489: ;
return;
} /* 20 (4/1) */

/* MOVE.W (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_317b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130490;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130490;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130490: ;
return;
} /* 22 (4/1) */

/* MOVE.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_317c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130491;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130491: ;
return;
} /* 16 (3/1) */

/* MOVE.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130492;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130492: ;
return;
} /* 14 (2/1) */

/* MOVE.W An,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3188_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130493;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130493: ;
return;
} /* 14 (2/1) */

/* MOVE.W (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130494;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130494;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130494: ;
return;
} /* 18 (3/1) */

/* MOVE.W (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130495;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130495;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130495: ;
return;
} /* 18 (3/1) */

/* MOVE.W -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130496;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130496;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130496: ;
return;
} /* 20 (3/1) */

/* MOVE.W (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130497;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130497;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130497: ;
return;
} /* 22 (4/1) */

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130498;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130498;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130498: ;
return;
} /* 24 (4/1) */

/* MOVE.W (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130499;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130499;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130499: ;
return;
} /* 22 (4/1) */

/* MOVE.W (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130500;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130500;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130500: ;
return;
} /* 26 (5/1) */

/* MOVE.W (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130501;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130501;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130501: ;
return;
} /* 22 (4/1) */

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130502;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130502;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130502: ;
return;
} /* 24 (4/1) */

/* MOVE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130503;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130503: ;
return;
} /* 18 (3/1) */

/* MOVE.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_31c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130504;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130504: ;
return;
} /* 12 (2/1) */

/* MOVE.W An,(xxx).W */
void REGPARAM2 CPUFUNC(op_31c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130505;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130505: ;
return;
} /* 12 (2/1) */

/* MOVE.W (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130506;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130506;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130506: ;
return;
} /* 16 (3/1) */

/* MOVE.W (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_31d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130507;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130507;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130507: ;
return;
} /* 16 (3/1) */

/* MOVE.W -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130508;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130508;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130508: ;
return;
} /* 18 (3/1) */

/* MOVE.W (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130509;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130509;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130509: ;
return;
} /* 20 (4/1) */

/* MOVE.W (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_31f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130510;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130510;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130510: ;
return;
} /* 22 (4/1) */

/* MOVE.W (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_31f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130511;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130511;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130511: ;
return;
} /* 20 (4/1) */

/* MOVE.W (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_31f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130512;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130512;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130512: ;
return;
} /* 24 (5/1) */

/* MOVE.W (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_31fa_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130513;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130513;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130513: ;
return;
} /* 20 (4/1) */

/* MOVE.W (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_31fb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130514;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130514;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130514: ;
return;
} /* 22 (4/1) */

/* MOVE.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_31fc_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130515;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130515: ;
return;
} /* 16 (3/1) */

/* MOVE.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_33c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130516;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130516: ;
return;
} /* 16 (3/1) */

/* MOVE.W An,(xxx).L */
void REGPARAM2 CPUFUNC(op_33c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130517;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130517: ;
return;
} /* 16 (3/1) */

/* MOVE.W (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130518;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130518;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130518: ;
return;
} /* 20 (4/1) */

/* MOVE.W (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_33d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130519;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130519;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130519: ;
return;
} /* 20 (4/1) */

/* MOVE.W -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130520;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130520;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130520: ;
return;
} /* 22 (4/1) */

/* MOVE.W (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130521;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130521;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130521: ;
return;
} /* 24 (5/1) */

/* MOVE.W (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_33f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130522;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130522;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130522: ;
return;
} /* 26 (5/1) */

/* MOVE.W (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_33f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130523;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130523;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130523: ;
return;
} /* 24 (5/1) */

/* MOVE.W (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_33f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130524;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (8) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (10);
		exception3_write(opcode, dsta);
		goto l_130524;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (10);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130524: ;
return;
} /* 28 (6/1) */

/* MOVE.W (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_33fa_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130525;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130525;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130525: ;
return;
} /* 24 (5/1) */

/* MOVE.W (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_33fb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130526;
	}
{{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130526;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}l_130526: ;
return;
} /* 26 (5/1) */

/* MOVE.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_33fc_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (6) << 16;
	dsta |= get_word_ce000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130527;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	x_put_word (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130527: ;
return;
} /* 20 (4/1) */

/* NEGX.B Dn */
void REGPARAM2 CPUFUNC(op_4000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* NEGX.B (An) */
void REGPARAM2 CPUFUNC(op_4010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* NEGX.B (An)+ */
void REGPARAM2 CPUFUNC(op_4018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* NEGX.B -(An) */
void REGPARAM2 CPUFUNC(op_4020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* NEGX.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* NEGX.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* NEGX.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4038_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* NEGX.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4039_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* NEGX.W Dn */
void REGPARAM2 CPUFUNC(op_4040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* NEGX.W (An) */
void REGPARAM2 CPUFUNC(op_4050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130537;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (srca, newv);
}}}}}}	m68k_incpci (2);
l_130537: ;
return;
} /* 12 (2/1) */

/* NEGX.W (An)+ */
void REGPARAM2 CPUFUNC(op_4058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130538;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (srca, newv);
}}}}}}	m68k_incpci (2);
l_130538: ;
return;
} /* 12 (2/1) */

/* NEGX.W -(An) */
void REGPARAM2 CPUFUNC(op_4060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130539;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (srca, newv);
}}}}}}	m68k_incpci (2);
l_130539: ;
return;
} /* 14 (2/1) */

/* NEGX.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130540;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (srca, newv);
}}}}}}	m68k_incpci (4);
l_130540: ;
return;
} /* 16 (3/1) */

/* NEGX.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130541;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (srca, newv);
}}}}}}	m68k_incpci (4);
l_130541: ;
return;
} /* 18 (3/1) */

/* NEGX.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4078_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130542;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (srca, newv);
}}}}}}	m68k_incpci (4);
l_130542: ;
return;
} /* 16 (3/1) */

/* NEGX.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4079_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130543;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (srca, newv);
}}}}}}	m68k_incpci (6);
l_130543: ;
return;
} /* 20 (4/1) */

/* NEGX.L Dn */
void REGPARAM2 CPUFUNC(op_4080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg (regs, srcreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* NEGX.L (An) */
void REGPARAM2 CPUFUNC(op_4090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130545;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (srca + 2, newv);
	ipl_fetch ();
x_put_word (srca, newv >> 16);
}}}}}}	m68k_incpci (2);
l_130545: ;
return;
} /* 20 (3/2) */

/* NEGX.L (An)+ */
void REGPARAM2 CPUFUNC(op_4098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130546;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (srca + 2, newv);
	ipl_fetch ();
x_put_word (srca, newv >> 16);
}}}}}}	m68k_incpci (2);
l_130546: ;
return;
} /* 20 (3/2) */

/* NEGX.L -(An) */
void REGPARAM2 CPUFUNC(op_40a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130547;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (srca + 2, newv);
	ipl_fetch ();
x_put_word (srca, newv >> 16);
}}}}}}	m68k_incpci (2);
l_130547: ;
return;
} /* 22 (3/2) */

/* NEGX.L (d16,An) */
void REGPARAM2 CPUFUNC(op_40a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130548;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (srca + 2, newv);
	ipl_fetch ();
x_put_word (srca, newv >> 16);
}}}}}}	m68k_incpci (4);
l_130548: ;
return;
} /* 24 (4/2) */

/* NEGX.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_40b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130549;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (srca + 2, newv);
	ipl_fetch ();
x_put_word (srca, newv >> 16);
}}}}}}	m68k_incpci (4);
l_130549: ;
return;
} /* 26 (4/2) */

/* NEGX.L (xxx).W */
void REGPARAM2 CPUFUNC(op_40b8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130550;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (srca + 2, newv);
	ipl_fetch ();
x_put_word (srca, newv >> 16);
}}}}}}	m68k_incpci (4);
l_130550: ;
return;
} /* 24 (4/2) */

/* NEGX.L (xxx).L */
void REGPARAM2 CPUFUNC(op_40b9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130551;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (srca + 2, newv);
	ipl_fetch ();
x_put_word (srca, newv >> 16);
}}}}}}	m68k_incpci (6);
l_130551: ;
return;
} /* 28 (5/2) */

/* MVSR2.W Dn */
void REGPARAM2 CPUFUNC(op_40c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130552; }
{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	MakeSR ();
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
}}}	m68k_incpci (2);
l_130552: ;
return;
} /* 6 (1/0) */

/* MVSR2.W (An) */
void REGPARAM2 CPUFUNC(op_40d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130553; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130553;
	}
{	x_put_word (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr);
}}}}	m68k_incpci (2);
l_130553: ;
return;
} /* 12 (1/2) */

/* MVSR2.W (An)+ */
void REGPARAM2 CPUFUNC(op_40d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130554; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130554;
	}
{	m68k_areg (regs, srcreg) += 2;
	x_put_word (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr);
}}}}	m68k_incpci (2);
l_130554: ;
return;
} /* 12 (1/2) */

/* MVSR2.W -(An) */
void REGPARAM2 CPUFUNC(op_40e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130555; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130555;
	}
{	m68k_areg (regs, srcreg) = srca;
	x_put_word (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr);
}}}}	m68k_incpci (2);
l_130555: ;
return;
} /* 14 (1/2) */

/* MVSR2.W (d16,An) */
void REGPARAM2 CPUFUNC(op_40e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130556; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130556;
	}
{	x_put_word (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr);
}}}}	m68k_incpci (4);
l_130556: ;
return;
} /* 16 (2/2) */

/* MVSR2.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_40f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130557; }
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130557;
	}
{	x_put_word (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr);
}}}}	m68k_incpci (4);
l_130557: ;
return;
} /* 18 (2/2) */

/* MVSR2.W (xxx).W */
void REGPARAM2 CPUFUNC(op_40f8_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130558; }
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130558;
	}
{	x_put_word (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr);
}}}}	m68k_incpci (4);
l_130558: ;
return;
} /* 16 (2/2) */

/* MVSR2.W (xxx).L */
void REGPARAM2 CPUFUNC(op_40f9_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130559; }
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130559;
	}
{	x_put_word (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr);
}}}}	m68k_incpci (6);
l_130559: ;
return;
} /* 20 (3/2) */

/* CHK.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_4180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (2);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130560;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130560;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130560: ;
return;
} /* 10 (1/0) */

/* CHK.W (An),Dn */
void REGPARAM2 CPUFUNC(op_4190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130561;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (2);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130561;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130561;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130561: ;
return;
} /* 14 (2/0) */

/* CHK.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_4198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130562;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (2);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130562;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130562;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130562: ;
return;
} /* 14 (2/0) */

/* CHK.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_41a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130563;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (2);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130563;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130563;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130563: ;
return;
} /* 16 (2/0) */

/* CHK.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_41a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130564;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130564;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130564;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130564: ;
return;
} /* 18 (3/0) */

/* CHK.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_41b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130565;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130565;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130565;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130565: ;
return;
} /* 20 (3/0) */

/* CHK.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_41b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130566;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130566;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130566;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130566: ;
return;
} /* 18 (3/0) */

/* CHK.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_41b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130567;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (6);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130567;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130567;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130567: ;
return;
} /* 22 (4/0) */

/* CHK.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_41ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130568;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130568;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130568;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130568: ;
return;
} /* 18 (3/0) */

/* CHK.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_41bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130569;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130569;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130569;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130569: ;
return;
} /* 20 (3/0) */

/* CHK.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_41bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	do_cycles_ce000_internal (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_130570;
	}
	do_cycles_ce000_internal (2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_130570;
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130570: ;
return;
} /* 14 (2/0) */

/* LEA.L (An),An */
void REGPARAM2 CPUFUNC(op_41d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* LEA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_41e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* LEA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_41f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
} /* 12 (2/0) */

/* LEA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_41f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* LEA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_41f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (6);
return;
} /* 12 (3/0) */

/* LEA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_41fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* LEA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_41fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
} /* 12 (2/0) */

/* CLR.B Dn */
void REGPARAM2 CPUFUNC(op_4200_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((0) & 0xff);
}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* CLR.B (An) */
void REGPARAM2 CPUFUNC(op_4210_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	ipl_fetch ();
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* CLR.B (An)+ */
void REGPARAM2 CPUFUNC(op_4218_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	ipl_fetch ();
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* CLR.B -(An) */
void REGPARAM2 CPUFUNC(op_4220_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	ipl_fetch ();
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* CLR.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4228_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	ipl_fetch ();
	x_put_byte (srca, 0);
}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* CLR.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4230_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	ipl_fetch ();
	x_put_byte (srca, 0);
}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* CLR.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4238_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	ipl_fetch ();
	x_put_byte (srca, 0);
}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* CLR.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4239_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	ipl_fetch ();
	x_put_byte (srca, 0);
}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* CLR.W Dn */
void REGPARAM2 CPUFUNC(op_4240_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((0) & 0xffff);
}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* CLR.W (An) */
void REGPARAM2 CPUFUNC(op_4250_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130587;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	ipl_fetch ();
	x_put_word (srca, 0);
}}}	m68k_incpci (2);
l_130587: ;
return;
} /* 8 (1/1) */

/* CLR.W (An)+ */
void REGPARAM2 CPUFUNC(op_4258_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130588;
	}
{	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	ipl_fetch ();
	x_put_word (srca, 0);
}}}	m68k_incpci (2);
l_130588: ;
return;
} /* 8 (1/1) */

/* CLR.W -(An) */
void REGPARAM2 CPUFUNC(op_4260_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130589;
	}
{	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	ipl_fetch ();
	x_put_word (srca, 0);
}}}	m68k_incpci (2);
l_130589: ;
return;
} /* 10 (1/1) */

/* CLR.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4268_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130590;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	ipl_fetch ();
	x_put_word (srca, 0);
}}}	m68k_incpci (4);
l_130590: ;
return;
} /* 12 (2/1) */

/* CLR.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4270_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130591;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	ipl_fetch ();
	x_put_word (srca, 0);
}}}	m68k_incpci (4);
l_130591: ;
return;
} /* 14 (2/1) */

/* CLR.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4278_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130592;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	ipl_fetch ();
	x_put_word (srca, 0);
}}}	m68k_incpci (4);
l_130592: ;
return;
} /* 12 (2/1) */

/* CLR.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4279_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130593;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	ipl_fetch ();
	x_put_word (srca, 0);
}}}	m68k_incpci (6);
l_130593: ;
return;
} /* 16 (3/1) */

/* CLR.L Dn */
void REGPARAM2 CPUFUNC(op_4280_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	m68k_dreg (regs, srcreg) = (0);
}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* CLR.L (An) */
void REGPARAM2 CPUFUNC(op_4290_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130595;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	x_put_word (srca + 2, 0);
	ipl_fetch ();
x_put_word (srca, 0 >> 16);
}}}	m68k_incpci (2);
l_130595: ;
return;
} /* 12 (1/2) */

/* CLR.L (An)+ */
void REGPARAM2 CPUFUNC(op_4298_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130596;
	}
{	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	x_put_word (srca + 2, 0);
	ipl_fetch ();
x_put_word (srca, 0 >> 16);
}}}	m68k_incpci (2);
l_130596: ;
return;
} /* 12 (1/2) */

/* CLR.L -(An) */
void REGPARAM2 CPUFUNC(op_42a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130597;
	}
{	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	x_put_word (srca + 2, 0);
	ipl_fetch ();
x_put_word (srca, 0 >> 16);
}}}	m68k_incpci (2);
l_130597: ;
return;
} /* 14 (1/2) */

/* CLR.L (d16,An) */
void REGPARAM2 CPUFUNC(op_42a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130598;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	x_put_word (srca + 2, 0);
	ipl_fetch ();
x_put_word (srca, 0 >> 16);
}}}	m68k_incpci (4);
l_130598: ;
return;
} /* 16 (2/2) */

/* CLR.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_42b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130599;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	x_put_word (srca + 2, 0);
	ipl_fetch ();
x_put_word (srca, 0 >> 16);
}}}	m68k_incpci (4);
l_130599: ;
return;
} /* 18 (2/2) */

/* CLR.L (xxx).W */
void REGPARAM2 CPUFUNC(op_42b8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130600;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	x_put_word (srca + 2, 0);
	ipl_fetch ();
x_put_word (srca, 0 >> 16);
}}}	m68k_incpci (4);
l_130600: ;
return;
} /* 16 (2/2) */

/* CLR.L (xxx).L */
void REGPARAM2 CPUFUNC(op_42b9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130601;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	x_put_word (srca + 2, 0);
	ipl_fetch ();
x_put_word (srca, 0 >> 16);
}}}	m68k_incpci (6);
l_130601: ;
return;
} /* 20 (3/2) */

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	MakeSR ();
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130603;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr & 0xff);
}}}	m68k_incpci (2);
l_130603: ;
return;
} /* 8 (1/1) */

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130604;
	}
{	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr & 0xff);
}}}	m68k_incpci (2);
l_130604: ;
return;
} /* 8 (1/1) */

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130605;
	}
{	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr & 0xff);
}}}	m68k_incpci (2);
l_130605: ;
return;
} /* 10 (1/1) */

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130606;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr & 0xff);
}}}	m68k_incpci (4);
l_130606: ;
return;
} /* 12 (2/1) */

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130607;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr & 0xff);
}}}	m68k_incpci (4);
l_130607: ;
return;
} /* 14 (2/1) */

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_130608;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr & 0xff);
}}}	m68k_incpci (4);
l_130608: ;
return;
} /* 12 (2/1) */

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130609;
	}
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	MakeSR ();
	ipl_fetch ();
	x_put_word (srca, regs.sr & 0xff);
}}}	m68k_incpci (6);
l_130609: ;
return;
} /* 16 (3/1) */

#endif
/* NEG.B Dn */
void REGPARAM2 CPUFUNC(op_4400_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

#endif

#ifdef PART_4
/* NEG.B (An) */
void REGPARAM2 CPUFUNC(op_4410_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* NEG.B (An)+ */
void REGPARAM2 CPUFUNC(op_4418_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* NEG.B -(An) */
void REGPARAM2 CPUFUNC(op_4420_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* NEG.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4428_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* NEG.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4430_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* NEG.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4438_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* NEG.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4439_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* NEG.W Dn */
void REGPARAM2 CPUFUNC(op_4440_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* NEG.W (An) */
void REGPARAM2 CPUFUNC(op_4450_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130619;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}}}	m68k_incpci (2);
l_130619: ;
return;
} /* 12 (2/1) */

/* NEG.W (An)+ */
void REGPARAM2 CPUFUNC(op_4458_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130620;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}}}	m68k_incpci (2);
l_130620: ;
return;
} /* 12 (2/1) */

/* NEG.W -(An) */
void REGPARAM2 CPUFUNC(op_4460_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130621;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}}}	m68k_incpci (2);
l_130621: ;
return;
} /* 14 (2/1) */

/* NEG.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4468_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130622;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}}}	m68k_incpci (4);
l_130622: ;
return;
} /* 16 (3/1) */

/* NEG.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4470_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130623;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}}}	m68k_incpci (4);
l_130623: ;
return;
} /* 18 (3/1) */

/* NEG.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4478_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130624;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}}}	m68k_incpci (4);
l_130624: ;
return;
} /* 16 (3/1) */

/* NEG.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4479_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130625;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}}}	m68k_incpci (6);
l_130625: ;
return;
} /* 20 (4/1) */

/* NEG.L Dn */
void REGPARAM2 CPUFUNC(op_4480_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* NEG.L (An) */
void REGPARAM2 CPUFUNC(op_4490_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130627;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}}}	m68k_incpci (2);
l_130627: ;
return;
} /* 20 (3/2) */

/* NEG.L (An)+ */
void REGPARAM2 CPUFUNC(op_4498_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130628;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}}}	m68k_incpci (2);
l_130628: ;
return;
} /* 20 (3/2) */

/* NEG.L -(An) */
void REGPARAM2 CPUFUNC(op_44a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130629;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}}}	m68k_incpci (2);
l_130629: ;
return;
} /* 22 (3/2) */

/* NEG.L (d16,An) */
void REGPARAM2 CPUFUNC(op_44a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130630;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}}}	m68k_incpci (4);
l_130630: ;
return;
} /* 24 (4/2) */

/* NEG.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_44b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130631;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}}}	m68k_incpci (4);
l_130631: ;
return;
} /* 26 (4/2) */

/* NEG.L (xxx).W */
void REGPARAM2 CPUFUNC(op_44b8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130632;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}}}	m68k_incpci (4);
l_130632: ;
return;
} /* 24 (4/2) */

/* NEG.L (xxx).L */
void REGPARAM2 CPUFUNC(op_44b9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130633;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}}}	m68k_incpci (6);
l_130633: ;
return;
} /* 28 (5/2) */

/* MV2SR.B Dn */
void REGPARAM2 CPUFUNC(op_44c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}return;
} /* 12 (2/0) */

/* MV2SR.B (An) */
void REGPARAM2 CPUFUNC(op_44d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130635;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130635: ;
return;
} /* 16 (3/0) */

/* MV2SR.B (An)+ */
void REGPARAM2 CPUFUNC(op_44d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130636;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130636: ;
return;
} /* 16 (3/0) */

/* MV2SR.B -(An) */
void REGPARAM2 CPUFUNC(op_44e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130637;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130637: ;
return;
} /* 18 (3/0) */

/* MV2SR.B (d16,An) */
void REGPARAM2 CPUFUNC(op_44e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130638;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130638: ;
return;
} /* 20 (4/0) */

/* MV2SR.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_44f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130639;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130639: ;
return;
} /* 22 (4/0) */

/* MV2SR.B (xxx).W */
void REGPARAM2 CPUFUNC(op_44f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130640;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130640: ;
return;
} /* 20 (4/0) */

/* MV2SR.B (xxx).L */
void REGPARAM2 CPUFUNC(op_44f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130641;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130641: ;
return;
} /* 24 (5/0) */

/* MV2SR.B (d16,PC) */
void REGPARAM2 CPUFUNC(op_44fa_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130642;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130642: ;
return;
} /* 20 (4/0) */

/* MV2SR.B (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_44fb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130643;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}l_130643: ;
return;
} /* 22 (4/0) */

/* MV2SR.B #<data>.B */
void REGPARAM2 CPUFUNC(op_44fc_13)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}return;
} /* 16 (3/0) */

/* NOT.B Dn */
void REGPARAM2 CPUFUNC(op_4600_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* NOT.B (An) */
void REGPARAM2 CPUFUNC(op_4610_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* NOT.B (An)+ */
void REGPARAM2 CPUFUNC(op_4618_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* NOT.B -(An) */
void REGPARAM2 CPUFUNC(op_4620_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* NOT.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4628_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* NOT.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4630_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* NOT.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4638_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* NOT.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4639_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	ipl_fetch ();
	x_put_byte (srca, dst);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* NOT.W Dn */
void REGPARAM2 CPUFUNC(op_4640_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* NOT.W (An) */
void REGPARAM2 CPUFUNC(op_4650_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130654;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}	m68k_incpci (2);
l_130654: ;
return;
} /* 12 (2/1) */

/* NOT.W (An)+ */
void REGPARAM2 CPUFUNC(op_4658_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130655;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}	m68k_incpci (2);
l_130655: ;
return;
} /* 12 (2/1) */

/* NOT.W -(An) */
void REGPARAM2 CPUFUNC(op_4660_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130656;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}	m68k_incpci (2);
l_130656: ;
return;
} /* 14 (2/1) */

/* NOT.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4668_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130657;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}	m68k_incpci (4);
l_130657: ;
return;
} /* 16 (3/1) */

/* NOT.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4670_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130658;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}	m68k_incpci (4);
l_130658: ;
return;
} /* 18 (3/1) */

/* NOT.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4678_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130659;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}	m68k_incpci (4);
l_130659: ;
return;
} /* 16 (3/1) */

/* NOT.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4679_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130660;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	ipl_fetch ();
	x_put_word (srca, dst);
}}}}}	m68k_incpci (6);
l_130660: ;
return;
} /* 20 (4/1) */

/* NOT.L Dn */
void REGPARAM2 CPUFUNC(op_4680_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* NOT.L (An) */
void REGPARAM2 CPUFUNC(op_4690_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130662;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}	m68k_incpci (2);
l_130662: ;
return;
} /* 20 (3/2) */

/* NOT.L (An)+ */
void REGPARAM2 CPUFUNC(op_4698_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130663;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}	m68k_incpci (2);
l_130663: ;
return;
} /* 20 (3/2) */

/* NOT.L -(An) */
void REGPARAM2 CPUFUNC(op_46a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130664;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}	m68k_incpci (2);
l_130664: ;
return;
} /* 22 (3/2) */

/* NOT.L (d16,An) */
void REGPARAM2 CPUFUNC(op_46a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130665;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}	m68k_incpci (4);
l_130665: ;
return;
} /* 24 (4/2) */

/* NOT.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_46b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130666;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}	m68k_incpci (4);
l_130666: ;
return;
} /* 26 (4/2) */

/* NOT.L (xxx).W */
void REGPARAM2 CPUFUNC(op_46b8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130667;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}	m68k_incpci (4);
l_130667: ;
return;
} /* 24 (4/2) */

/* NOT.L (xxx).L */
void REGPARAM2 CPUFUNC(op_46b9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130668;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	x_put_word (srca + 2, dst);
	ipl_fetch ();
x_put_word (srca, dst >> 16);
}}}}}	m68k_incpci (6);
l_130668: ;
return;
} /* 28 (5/2) */

/* MV2SR.W Dn */
void REGPARAM2 CPUFUNC(op_46c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130669; }
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130669: ;
return;
} /* 12 (2/0) */

/* MV2SR.W (An) */
void REGPARAM2 CPUFUNC(op_46d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130670; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130670;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130670: ;
return;
} /* 16 (3/0) */

/* MV2SR.W (An)+ */
void REGPARAM2 CPUFUNC(op_46d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130671; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130671;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130671: ;
return;
} /* 16 (3/0) */

/* MV2SR.W -(An) */
void REGPARAM2 CPUFUNC(op_46e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130672; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130672;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130672: ;
return;
} /* 18 (3/0) */

/* MV2SR.W (d16,An) */
void REGPARAM2 CPUFUNC(op_46e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130673; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130673;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130673: ;
return;
} /* 20 (4/0) */

/* MV2SR.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_46f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130674; }
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130674;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130674: ;
return;
} /* 22 (4/0) */

/* MV2SR.W (xxx).W */
void REGPARAM2 CPUFUNC(op_46f8_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130675; }
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130675;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130675: ;
return;
} /* 20 (4/0) */

/* MV2SR.W (xxx).L */
void REGPARAM2 CPUFUNC(op_46f9_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130676; }
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130676;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (6);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130676: ;
return;
} /* 24 (5/0) */

/* MV2SR.W (d16,PC) */
void REGPARAM2 CPUFUNC(op_46fa_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130677; }
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130677;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130677: ;
return;
} /* 20 (4/0) */

/* MV2SR.W (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_46fb_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130678; }
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130678;
	}
{{	uae_s16 src = x_get_word (srca);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130678: ;
return;
} /* 22 (4/0) */

/* MV2SR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_46fc_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130679; }
{{	uae_s16 src = get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_incpci (4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130679: ;
return;
} /* 16 (3/0) */

/* NBCD.B Dn */
void REGPARAM2 CPUFUNC(op_4800_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* NBCD.B (An) */
void REGPARAM2 CPUFUNC(op_4810_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* NBCD.B (An)+ */
void REGPARAM2 CPUFUNC(op_4818_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* NBCD.B -(An) */
void REGPARAM2 CPUFUNC(op_4820_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* NBCD.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4828_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* NBCD.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4830_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* NBCD.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4838_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* NBCD.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4839_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch ();
	x_put_byte (srca, newv);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* SWAP.W Dn */
void REGPARAM2 CPUFUNC(op_4840_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* PEA.L (An) */
void REGPARAM2 CPUFUNC(op_4850_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_130689;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta, srca >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, srca);
}}}}	m68k_incpci (2);
l_130689: ;
return;
} /* 12 (1/2) */

/* PEA.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4868_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130690;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta, srca >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, srca);
}}}}	m68k_incpci (4);
l_130690: ;
return;
} /* 16 (2/2) */

/* PEA.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4870_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130691;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	x_put_word (dsta, srca >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, srca);
}}}}	m68k_incpci (4);
l_130691: ;
return;
} /* 20 (2/2) */

/* PEA.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4878_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130692;
	}
{	m68k_areg (regs, 7) = dsta;
	x_put_word (dsta, srca >> 16);
	x_put_word (dsta + 2, srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130692: ;
return;
} /* 16 (2/2) */

/* PEA.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4879_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_130693;
	}
{	m68k_areg (regs, 7) = dsta;
	x_put_word (dsta, srca >> 16);
	x_put_word (dsta + 2, srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130693: ;
return;
} /* 20 (3/2) */

/* PEA.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_487a_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130694;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta, srca >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, srca);
}}}}	m68k_incpci (4);
l_130694: ;
return;
} /* 16 (2/2) */

/* PEA.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_487b_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_130695;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	x_put_word (dsta, srca >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, srca);
}}}}	m68k_incpci (4);
l_130695: ;
return;
} /* 20 (2/2) */

/* EXT.W Dn */
void REGPARAM2 CPUFUNC(op_4880_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* MVMLE.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4890_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130697;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130697: ;
return;
} /* 8+ (2/0) */

/* MVMLE.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_48a0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130698;
	}
{{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) {
		srca -= 2;
		x_put_word (srca, m68k_areg (regs, movem_index2[amask]));
	amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 2;
		x_put_word (srca, m68k_dreg (regs, movem_index2[dmask]));
		dmask = movem_next[dmask];
	}
	m68k_areg (regs, dstreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130698: ;
return;
} /* 8+ (2/0) */

/* MVMLE.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_48a8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130699;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130699: ;
return;
} /* 12+ (3/0) */

/* MVMLE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_48b0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130700;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130700: ;
return;
} /* 14+ (3/0) */

/* MVMLE.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_48b8_13)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130701;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130701: ;
return;
} /* 12+ (3/0) */

/* MVMLE.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_48b9_13)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = get_word_ce000_prefetch (6) << 16;
	srca |= get_word_ce000_prefetch (8);
	if (srca & 1) {
	m68k_incpci (8);
		exception3_write(opcode, srca);
		goto l_130702;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
}}}}	m68k_incpci (8);
l_130702: ;
return;
} /* 16+ (4/0) */

/* EXT.L Dn */
void REGPARAM2 CPUFUNC(op_48c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* MVMLE.L #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_48d0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130704;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		x_put_word (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		x_put_word (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130704: ;
return;
} /* 8+ (2/0) */

/* MVMLE.L #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_48e0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130705;
	}
{{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) {
		srca -= 4;
		x_put_word (srca, m68k_areg (regs, movem_index2[amask]) >> 16);
		x_put_word (srca + 2, m68k_areg (regs, movem_index2[amask]));
		amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 4;
		x_put_word (srca, m68k_dreg (regs, movem_index2[dmask]) >> 16);
		x_put_word (srca + 2, m68k_dreg (regs, movem_index2[dmask]));
		dmask = movem_next[dmask];
	}
	m68k_areg (regs, dstreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130705: ;
return;
} /* 8+ (2/0) */

/* MVMLE.L #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_48e8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130706;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		x_put_word (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		x_put_word (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130706: ;
return;
} /* 12+ (3/0) */

/* MVMLE.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_48f0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130707;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		x_put_word (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		x_put_word (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130707: ;
return;
} /* 14+ (3/0) */

/* MVMLE.L #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_48f8_13)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130708;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		x_put_word (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		x_put_word (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130708: ;
return;
} /* 12+ (3/0) */

/* MVMLE.L #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_48f9_13)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce000_prefetch (4);
{	uaecptr srca;
	srca = get_word_ce000_prefetch (6) << 16;
	srca |= get_word_ce000_prefetch (8);
	if (srca & 1) {
	m68k_incpci (8);
		exception3_write(opcode, srca);
		goto l_130709;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		x_put_word (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		x_put_word (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
}}}}	m68k_incpci (8);
l_130709: ;
return;
} /* 16+ (4/0) */

/* TST.B Dn */
void REGPARAM2 CPUFUNC(op_4a00_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* TST.B (An) */
void REGPARAM2 CPUFUNC(op_4a10_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* TST.B (An)+ */
void REGPARAM2 CPUFUNC(op_4a18_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* TST.B -(An) */
void REGPARAM2 CPUFUNC(op_4a20_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
} /* 10 (2/0) */

/* TST.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4a28_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* TST.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4a30_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* TST.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4a38_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* TST.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4a39_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* TST.W Dn */
void REGPARAM2 CPUFUNC(op_4a40_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* TST.W (An) */
void REGPARAM2 CPUFUNC(op_4a50_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130719;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (2);
l_130719: ;
return;
} /* 8 (2/0) */

/* TST.W (An)+ */
void REGPARAM2 CPUFUNC(op_4a58_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130720;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (2);
l_130720: ;
return;
} /* 8 (2/0) */

/* TST.W -(An) */
void REGPARAM2 CPUFUNC(op_4a60_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130721;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (2);
l_130721: ;
return;
} /* 10 (2/0) */

/* TST.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4a68_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130722;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (4);
l_130722: ;
return;
} /* 12 (3/0) */

/* TST.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4a70_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130723;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (4);
l_130723: ;
return;
} /* 14 (3/0) */

/* TST.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4a78_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130724;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (4);
l_130724: ;
return;
} /* 12 (3/0) */

/* TST.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4a79_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130725;
	}
{{	uae_s16 src = x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (6);
l_130725: ;
return;
} /* 16 (4/0) */

/* TST.L Dn */
void REGPARAM2 CPUFUNC(op_4a80_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* TST.L (An) */
void REGPARAM2 CPUFUNC(op_4a90_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130727;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (2);
l_130727: ;
return;
} /* 12 (3/0) */

/* TST.L (An)+ */
void REGPARAM2 CPUFUNC(op_4a98_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130728;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (2);
l_130728: ;
return;
} /* 12 (3/0) */

/* TST.L -(An) */
void REGPARAM2 CPUFUNC(op_4aa0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130729;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (2);
l_130729: ;
return;
} /* 14 (3/0) */

/* TST.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4aa8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130730;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (4);
l_130730: ;
return;
} /* 16 (4/0) */

/* TST.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4ab0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_130731;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (4);
l_130731: ;
return;
} /* 18 (4/0) */

/* TST.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4ab8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_130732;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (4);
l_130732: ;
return;
} /* 16 (4/0) */

/* TST.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4ab9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_130733;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (6);
l_130733: ;
return;
} /* 20 (5/0) */

/* TAS.B Dn */
void REGPARAM2 CPUFUNC(op_4ac0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src |= 0x80;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((src) & 0xff);
}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* TAS.B (An) */
void REGPARAM2 CPUFUNC(op_4ad0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src |= 0x80;
	if (!is_cycle_ce ()) {
	ipl_fetch ();
	x_put_byte (srca, src);
	} else {
		do_cycles_ce000_internal (4);
	}
}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* TAS.B (An)+ */
void REGPARAM2 CPUFUNC(op_4ad8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src |= 0x80;
	if (!is_cycle_ce ()) {
	ipl_fetch ();
	x_put_byte (srca, src);
	} else {
		do_cycles_ce000_internal (4);
	}
}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* TAS.B -(An) */
void REGPARAM2 CPUFUNC(op_4ae0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	src |= 0x80;
	if (!is_cycle_ce ()) {
	ipl_fetch ();
	x_put_byte (srca, src);
	} else {
		do_cycles_ce000_internal (4);
	}
}}}	m68k_incpci (2);
return;
} /* 16 (2/1) */

/* TAS.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4ae8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src |= 0x80;
	if (!is_cycle_ce ()) {
	ipl_fetch ();
	x_put_byte (srca, src);
	} else {
		do_cycles_ce000_internal (4);
	}
}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* TAS.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4af0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src |= 0x80;
	if (!is_cycle_ce ()) {
	ipl_fetch ();
	x_put_byte (srca, src);
	} else {
		do_cycles_ce000_internal (4);
	}
}}}	m68k_incpci (4);
return;
} /* 20 (3/1) */

/* TAS.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4af8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	src |= 0x80;
	if (!is_cycle_ce ()) {
	ipl_fetch ();
	x_put_byte (srca, src);
	} else {
		do_cycles_ce000_internal (4);
	}
}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* TAS.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4af9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	src |= 0x80;
	if (!is_cycle_ce ()) {
	ipl_fetch ();
	x_put_byte (srca, src);
	} else {
		do_cycles_ce000_internal (4);
	}
}}}	m68k_incpci (6);
return;
} /* 22 (4/1) */

/* MVMEL.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4c90_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130742;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130742: ;
return;
} /* 12+ (3/0) */

/* MVMEL.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_4c98_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130743;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	m68k_areg (regs, dstreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130743: ;
return;
} /* 12+ (3/0) */

/* MVMEL.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_4ca8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130744;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130744: ;
return;
} /* 16+ (4/0) */

/* MVMEL.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4cb0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130745;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130745: ;
return;
} /* 18+ (4/0) */

/* MVMEL.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_4cb8_13)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130746;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130746: ;
return;
} /* 16+ (4/0) */

/* MVMEL.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_4cb9_13)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = get_word_ce000_prefetch (6) << 16;
	srca |= get_word_ce000_prefetch (8);
	if (srca & 1) {
	m68k_incpci (8);
		exception3_write(opcode, srca);
		goto l_130747;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
}}}}	m68k_incpci (8);
l_130747: ;
return;
} /* 20+ (5/0) */

/* MVMEL.W #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_4cba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_getpci () + 4;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130748;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130748: ;
return;
} /* 16+ (4/0) */

/* MVMEL.W #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4cbb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
	do_cycles_ce000_internal (2);
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 4;
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130749;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca);
		srca += 2;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130749: ;
return;
} /* 18+ (4/0) */

/* MVMEL.L #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4cd0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130750;
	}
{{	while (dmask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130750: ;
return;
} /* 12+ (3/0) */

/* MVMEL.L #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_4cd8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130751;
	}
{{	while (dmask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	m68k_areg (regs, dstreg) = srca;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}	m68k_incpci (4);
l_130751: ;
return;
} /* 12+ (3/0) */

/* MVMEL.L #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_4ce8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130752;
	}
{{	while (dmask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130752: ;
return;
} /* 16+ (4/0) */

/* MVMEL.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4cf0_13)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130753;
	}
{{	while (dmask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130753: ;
return;
} /* 18+ (4/0) */

/* MVMEL.L #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_4cf8_13)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130754;
	}
{{	while (dmask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130754: ;
return;
} /* 16+ (4/0) */

/* MVMEL.L #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_4cf9_13)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = get_word_ce000_prefetch (6) << 16;
	srca |= get_word_ce000_prefetch (8);
	if (srca & 1) {
	m68k_incpci (8);
		exception3_write(opcode, srca);
		goto l_130755;
	}
{{	while (dmask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (10);
}}}}	m68k_incpci (8);
l_130755: ;
return;
} /* 20+ (5/0) */

/* MVMEL.L #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_4cfa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_getpci () + 4;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130756;
	}
{{	while (dmask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130756: ;
return;
} /* 16+ (4/0) */

/* MVMEL.L #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4cfb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_ce000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
	do_cycles_ce000_internal (2);
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 4;
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_130757;
	}
{{	while (dmask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		v = x_get_word (srca) << 16;
		v |= x_get_word (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
	}
	x_get_word (srca);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
}}}}	m68k_incpci (6);
l_130757: ;
return;
} /* 18+ (4/0) */

/* TRAPQ.L #<data> */
void REGPARAM2 CPUFUNC(op_4e40_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 15);
{{	uae_u32 src = srcreg;
	m68k_incpci (2);
	Exception (src + 32);
}}return;
} /* 4 (0/0) */

/* LINK.W An,#<data>.W */
void REGPARAM2 CPUFUNC(op_4e50_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	if (olda & 1) {
	m68k_incpci (4);
		exception3_write(opcode, olda);
		goto l_130759;
	}
{	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s16 offs = get_word_ce000_prefetch (4);
	x_put_word (olda, src >> 16);
	x_put_word (olda + 2, src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
	m68k_areg (regs, 7) += offs;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
}}}}}	m68k_incpci (4);
l_130759: ;
return;
} /* 16 (2/2) */

/* UNLK.L An */
void REGPARAM2 CPUFUNC(op_4e58_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
	m68k_areg (regs, 7) = src;
{	uaecptr olda;
	olda = m68k_areg (regs, 7);
	if (olda & 1) {
	m68k_incpci (2);
		exception3_read(opcode, olda);
		goto l_130760;
	}
{{	uae_s32 old = x_get_word (olda) << 16; old |= x_get_word (olda + 2);
	m68k_areg (regs, 7) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_areg (regs, srcreg) = (old);
}}}}}	m68k_incpci (2);
l_130760: ;
return;
} /* 12 (3/0) */

/* MVR2USP.L An */
void REGPARAM2 CPUFUNC(op_4e60_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130761; }
{{	uae_s32 src = m68k_areg (regs, srcreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	regs.usp = src;
}}}	m68k_incpci (2);
l_130761: ;
return;
} /* 4 (1/0) */

/* MVUSP2R.L An */
void REGPARAM2 CPUFUNC(op_4e68_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_130762; }
{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_areg (regs, srcreg) = (regs.usp);
}}}	m68k_incpci (2);
l_130762: ;
return;
} /* 4 (1/0) */

/* RESET.L  */
void REGPARAM2 CPUFUNC(op_4e70_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130763; }
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	cpureset ();
	m68k_incpci (2);
	do_cycles_ce000_internal (128);
	get_word_ce000_prefetch (2);
}}l_130763: ;
return;
} /* 132 (1/0) */

/* NOP.L  */
void REGPARAM2 CPUFUNC(op_4e71_13)(uae_u32 opcode)
{
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* STOP.L #<data>.W */
void REGPARAM2 CPUFUNC(op_4e72_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130765; }
{	regs.sr = regs.irc;
	do_cycles_ce000_internal (8);
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_setstopped ();
	m68k_incpci (4);
}}l_130765: ;
return;
} /* 8 (0/0) */

/* RTE.L  */
void REGPARAM2 CPUFUNC(op_4e73_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130766; }
{	uae_u16 newsr; uae_u32 newpc;
	for (;;) {
		uaecptr a = m68k_areg (regs, 7);
		uae_u16 sr = x_get_word (a);
		uae_u32 pc = x_get_word (a + 2) << 16; pc |= x_get_word (a + 4);
		uae_u16 format = x_get_word (a + 2 + 4);
		int frame = format >> 12;
		int offset = 8;
		newsr = sr; newpc = pc;
		if (frame == 0x0) { m68k_areg (regs, 7) += offset; break; }
		else if (frame == 0x8) { m68k_areg (regs, 7) += offset + 50; break; }
		else { m68k_areg (regs, 7) += offset; Exception (14); goto l_130766; }
		regs.sr = newsr; MakeFromSR ();
}
	regs.sr = newsr;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	if (newpc & 1) {
		exception3i (0x4E73, newpc);
		goto l_130766;
	}
	m68k_setpci (newpc);
	ipl_fetch ();
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130766: ;
return;
} /* 24 (6/0) */

/* RTD.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e74_13)(uae_u32 opcode)
{
{{	uaecptr pca;
	pca = m68k_areg (regs, 7);
	if (pca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, pca);
		goto l_130767;
	}
{{	uae_s32 pc = x_get_word (pca) << 16; pc |= x_get_word (pca + 2);
	m68k_areg (regs, 7) += 4;
{	uae_s16 offs = get_word_ce000_prefetch (4);
	m68k_areg (regs, 7) += offs;
	if (pc & 1) {
		exception3i (0x4E74, pc);
		goto l_130767;
	}
	m68k_setpci (pc);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}l_130767: ;
return;
} /* 20 (5/0) */

#endif
/* RTS.L  */
void REGPARAM2 CPUFUNC(op_4e75_13)(uae_u32 opcode)
{
{	uaecptr pc = m68k_getpci ();
	m68k_do_rts_ce ();
	if (m68k_getpci () & 1) {
		uaecptr faultpc = m68k_getpci ();
	m68k_setpci (pc);
		exception3i (0x4E75, faultpc);
		goto l_130768;
	}
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_130768: ;
return;
} /* 16 (4/0) */

/* TRAPV.L  */
void REGPARAM2 CPUFUNC(op_4e76_13)(uae_u32 opcode)
{
{	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	if (GET_VFLG ()) {
		Exception (7);
		goto l_130769;
	}
}l_130769: ;
return;
} /* 4 (1/0) */

/* RTR.L  */
void REGPARAM2 CPUFUNC(op_4e77_13)(uae_u32 opcode)
{
{	uaecptr oldpc = m68k_getpci ();
	MakeSR ();
{	uaecptr sra;
	sra = m68k_areg (regs, 7);
	if (sra & 1) {
	m68k_incpci (2);
		exception3_read(opcode, sra);
		goto l_130770;
	}
{{	uae_s16 sr = x_get_word (sra);
	m68k_areg (regs, 7) += 2;
{	uaecptr pca;
	pca = m68k_areg (regs, 7);
	if (pca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, pca);
		goto l_130770;
	}
{{	uae_s32 pc = x_get_word (pca) << 16; pc |= x_get_word (pca + 2);
	m68k_areg (regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr;
	m68k_setpci (pc);
	MakeFromSR();
	regs.ipl_pin = intlev ();
	if (m68k_getpci () & 1) {
		uaecptr faultpc = m68k_getpci ();
	m68k_setpci (oldpc);
		exception3i (0x4E77, faultpc);
		goto l_130770;
	}
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}}}}}l_130770: ;
return;
} /* 20 (5/0) */

/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e7a_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130771; }
{{	uae_s16 src = get_word_ce000_prefetch (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (! m68k_movec2(src & 0xFFF, regp)) goto l_130771;
}}}}	m68k_incpci (4);
l_130771: ;
return;
} /* 8 (2/0) */

#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e7b_13)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_130772; }
{{	uae_s16 src = get_word_ce000_prefetch (4);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (! m68k_move2c(src & 0xFFF, regp)) goto l_130772;
}}}}	m68k_incpci (4);
l_130772: ;
return;
} /* 8 (2/0) */

#endif
/* JSR.L (An) */
void REGPARAM2 CPUFUNC(op_4e90_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uaecptr oldpc = m68k_getpci () + 2;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130773;
	}
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	x_put_word (m68k_areg (regs, 7), oldpc >> 16);
	x_put_word (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130773: ;
return;
} /* 16 (2/2) */

/* JSR.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4ea8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)regs.irc;
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130774;
	}
	do_cycles_ce000_internal (2);
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	x_put_word (m68k_areg (regs, 7), oldpc >> 16);
	x_put_word (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130774: ;
return;
} /* 18 (2/2) */

/* JSR.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4eb0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), regs.irc);
{	uaecptr oldpc = m68k_getpci () + 2;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130775;
	}
	do_cycles_ce000_internal (6);
	oldpc += 2;
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	x_put_word (m68k_areg (regs, 7), oldpc >> 16);
	x_put_word (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130775: ;
return;
} /* 22 (2/2) */

/* JSR.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4eb8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)regs.irc;
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130776;
	}
	do_cycles_ce000_internal (2);
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	x_put_word (m68k_areg (regs, 7), oldpc >> 16);
	x_put_word (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130776: ;
return;
} /* 18 (2/2) */

/* JSR.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4eb9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= regs.irc;
{	uaecptr oldpc = m68k_getpci () + 6;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130777;
	}
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	x_put_word (m68k_areg (regs, 7), oldpc >> 16);
	x_put_word (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130777: ;
return;
} /* 20 (3/2) */

/* JSR.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_4eba_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)regs.irc;
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130778;
	}
	do_cycles_ce000_internal (2);
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	x_put_word (m68k_areg (regs, 7), oldpc >> 16);
	x_put_word (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130778: ;
return;
} /* 18 (2/2) */

/* JSR.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4ebb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, regs.irc);
{	uaecptr oldpc = m68k_getpci () + 2;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130779;
	}
	do_cycles_ce000_internal (6);
	oldpc += 2;
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	x_put_word (m68k_areg (regs, 7), oldpc >> 16);
	x_put_word (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}l_130779: ;
return;
} /* 22 (2/2) */

/* JMP.L (An) */
void REGPARAM2 CPUFUNC(op_4ed0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130780;
	}
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130780: ;
return;
} /* 8 (2/0) */

/* JMP.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4ee8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)regs.irc;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130781;
	}
	do_cycles_ce000_internal (2);
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130781: ;
return;
} /* 10 (2/0) */

/* JMP.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4ef0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), regs.irc);
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130782;
	}
	do_cycles_ce000_internal (6);
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130782: ;
return;
} /* 14 (2/0) */

/* JMP.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4ef8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)regs.irc;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130783;
	}
	do_cycles_ce000_internal (2);
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130783: ;
return;
} /* 10 (2/0) */

/* JMP.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4ef9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= regs.irc;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130784;
	}
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130784: ;
return;
} /* 12 (3/0) */

/* JMP.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_4efa_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)regs.irc;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130785;
	}
	do_cycles_ce000_internal (2);
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130785: ;
return;
} /* 10 (2/0) */

/* JMP.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4efb_13)(uae_u32 opcode)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, regs.irc);
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_130786;
	}
	do_cycles_ce000_internal (6);
	m68k_setpci (srca);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130786: ;
return;
} /* 14 (2/0) */

/* ADDQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* ADDQ.B #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* ADDQ.B #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* ADDQ.B #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* ADDQ.B #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* ADDQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* ADDQ.B #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5038_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* ADDQ.B #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5039_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* ADDQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* ADDAQ.W #<data>,An */
void REGPARAM2 CPUFUNC(op_5048_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADDQ.W #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130797;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_130797: ;
return;
} /* 12 (2/1) */

/* ADDQ.W #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130798;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_130798: ;
return;
} /* 12 (2/1) */

/* ADDQ.W #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130799;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_130799: ;
return;
} /* 14 (2/1) */

/* ADDQ.W #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130800;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130800: ;
return;
} /* 16 (3/1) */

/* ADDQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130801;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130801: ;
return;
} /* 18 (3/1) */

/* ADDQ.W #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5078_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130802;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130802: ;
return;
} /* 16 (3/1) */

/* ADDQ.W #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5079_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130803;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_130803: ;
return;
} /* 20 (4/1) */

/* ADDQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADDAQ.L #<data>,An */
void REGPARAM2 CPUFUNC(op_5088_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADDQ.L #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130806;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_130806: ;
return;
} /* 20 (3/2) */

/* ADDQ.L #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130807;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_130807: ;
return;
} /* 20 (3/2) */

/* ADDQ.L #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_50a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130808;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_130808: ;
return;
} /* 22 (3/2) */

#endif

#ifdef PART_5
/* ADDQ.L #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_50a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130809;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_130809: ;
return;
} /* 24 (4/2) */

/* ADDQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_50b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130810;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_130810: ;
return;
} /* 26 (4/2) */

/* ADDQ.L #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_50b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130811;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_130811: ;
return;
} /* 24 (4/2) */

/* ADDQ.L #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_50b9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130812;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_130812: ;
return;
} /* 28 (5/2) */

/* Scc.B Dn (T) */
void REGPARAM2 CPUFUNC(op_50c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (0) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (T) */
void REGPARAM2 CPUFUNC(op_50c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (0)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130814;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130814: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (T) */
void REGPARAM2 CPUFUNC(op_50d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (0) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (T) */
void REGPARAM2 CPUFUNC(op_50d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (0) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (T) */
void REGPARAM2 CPUFUNC(op_50e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (0) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (T) */
void REGPARAM2 CPUFUNC(op_50e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (0) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (T) */
void REGPARAM2 CPUFUNC(op_50f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (0) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (T) */
void REGPARAM2 CPUFUNC(op_50f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (0) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (T) */
void REGPARAM2 CPUFUNC(op_50f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (0) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* SUBQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* SUBQ.B #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* SUBQ.B #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* SUBQ.B #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* SUBQ.B #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* SUBQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* SUBQ.B #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5138_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* SUBQ.B #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5139_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* SUBQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* SUBAQ.W #<data>,An */
void REGPARAM2 CPUFUNC(op_5148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUBQ.W #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130832;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_130832: ;
return;
} /* 12 (2/1) */

/* SUBQ.W #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130833;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_130833: ;
return;
} /* 12 (2/1) */

/* SUBQ.W #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130834;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_130834: ;
return;
} /* 14 (2/1) */

/* SUBQ.W #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130835;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130835: ;
return;
} /* 16 (3/1) */

/* SUBQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130836;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130836: ;
return;
} /* 18 (3/1) */

/* SUBQ.W #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5178_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130837;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_130837: ;
return;
} /* 16 (3/1) */

/* SUBQ.W #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5179_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130838;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_130838: ;
return;
} /* 20 (4/1) */

/* SUBQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUBAQ.L #<data>,An */
void REGPARAM2 CPUFUNC(op_5188_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUBQ.L #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130841;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_130841: ;
return;
} /* 20 (3/2) */

/* SUBQ.L #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130842;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_130842: ;
return;
} /* 20 (3/2) */

/* SUBQ.L #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_51a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130843;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_130843: ;
return;
} /* 22 (3/2) */

/* SUBQ.L #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_51a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130844;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_130844: ;
return;
} /* 24 (4/2) */

/* SUBQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_51b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_130845;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_130845: ;
return;
} /* 26 (4/2) */

/* SUBQ.L #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_51b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_130846;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_130846: ;
return;
} /* 24 (4/2) */

/* SUBQ.L #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_51b9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_130847;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_130847: ;
return;
} /* 28 (5/2) */

/* Scc.B Dn (F) */
void REGPARAM2 CPUFUNC(op_51c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (1) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (F) */
void REGPARAM2 CPUFUNC(op_51c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (1)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130849;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130849: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (F) */
void REGPARAM2 CPUFUNC(op_51d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (1) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (F) */
void REGPARAM2 CPUFUNC(op_51d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (1) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (F) */
void REGPARAM2 CPUFUNC(op_51e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (1) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (F) */
void REGPARAM2 CPUFUNC(op_51e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (1) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (F) */
void REGPARAM2 CPUFUNC(op_51f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (1) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (F) */
void REGPARAM2 CPUFUNC(op_51f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (1) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (F) */
void REGPARAM2 CPUFUNC(op_51f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (1) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (HI) */
void REGPARAM2 CPUFUNC(op_52c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (2) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (HI) */
void REGPARAM2 CPUFUNC(op_52c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (2)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130858;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130858: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (HI) */
void REGPARAM2 CPUFUNC(op_52d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (2) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (HI) */
void REGPARAM2 CPUFUNC(op_52d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (2) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (HI) */
void REGPARAM2 CPUFUNC(op_52e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (2) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (HI) */
void REGPARAM2 CPUFUNC(op_52e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (2) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (HI) */
void REGPARAM2 CPUFUNC(op_52f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (2) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (HI) */
void REGPARAM2 CPUFUNC(op_52f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (2) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (HI) */
void REGPARAM2 CPUFUNC(op_52f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (2) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (LS) */
void REGPARAM2 CPUFUNC(op_53c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (3) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (LS) */
void REGPARAM2 CPUFUNC(op_53c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (3)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130867;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130867: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (LS) */
void REGPARAM2 CPUFUNC(op_53d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (3) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (LS) */
void REGPARAM2 CPUFUNC(op_53d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (3) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (LS) */
void REGPARAM2 CPUFUNC(op_53e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (3) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (LS) */
void REGPARAM2 CPUFUNC(op_53e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (3) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (LS) */
void REGPARAM2 CPUFUNC(op_53f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (3) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (LS) */
void REGPARAM2 CPUFUNC(op_53f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (3) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (LS) */
void REGPARAM2 CPUFUNC(op_53f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (3) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (CC) */
void REGPARAM2 CPUFUNC(op_54c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (4) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (CC) */
void REGPARAM2 CPUFUNC(op_54c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (4)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130876;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130876: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (CC) */
void REGPARAM2 CPUFUNC(op_54d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (4) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (CC) */
void REGPARAM2 CPUFUNC(op_54d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (4) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (CC) */
void REGPARAM2 CPUFUNC(op_54e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (4) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (CC) */
void REGPARAM2 CPUFUNC(op_54e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (4) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (CC) */
void REGPARAM2 CPUFUNC(op_54f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (4) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (CC) */
void REGPARAM2 CPUFUNC(op_54f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (4) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (CC) */
void REGPARAM2 CPUFUNC(op_54f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (4) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (CS) */
void REGPARAM2 CPUFUNC(op_55c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (5) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (CS) */
void REGPARAM2 CPUFUNC(op_55c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (5)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130885;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130885: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (CS) */
void REGPARAM2 CPUFUNC(op_55d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (5) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (CS) */
void REGPARAM2 CPUFUNC(op_55d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (5) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (CS) */
void REGPARAM2 CPUFUNC(op_55e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (5) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (CS) */
void REGPARAM2 CPUFUNC(op_55e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (5) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (CS) */
void REGPARAM2 CPUFUNC(op_55f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (5) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (CS) */
void REGPARAM2 CPUFUNC(op_55f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (5) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (CS) */
void REGPARAM2 CPUFUNC(op_55f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (5) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (NE) */
void REGPARAM2 CPUFUNC(op_56c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (6) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (NE) */
void REGPARAM2 CPUFUNC(op_56c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (6)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130894;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130894: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (NE) */
void REGPARAM2 CPUFUNC(op_56d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (6) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (NE) */
void REGPARAM2 CPUFUNC(op_56d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (6) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (NE) */
void REGPARAM2 CPUFUNC(op_56e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (6) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (NE) */
void REGPARAM2 CPUFUNC(op_56e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (6) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (NE) */
void REGPARAM2 CPUFUNC(op_56f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (6) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (NE) */
void REGPARAM2 CPUFUNC(op_56f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (6) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (NE) */
void REGPARAM2 CPUFUNC(op_56f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (6) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (EQ) */
void REGPARAM2 CPUFUNC(op_57c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (7) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (EQ) */
void REGPARAM2 CPUFUNC(op_57c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (7)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130903;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130903: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (EQ) */
void REGPARAM2 CPUFUNC(op_57d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (7) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (EQ) */
void REGPARAM2 CPUFUNC(op_57d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (7) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (EQ) */
void REGPARAM2 CPUFUNC(op_57e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (7) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (EQ) */
void REGPARAM2 CPUFUNC(op_57e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (7) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (EQ) */
void REGPARAM2 CPUFUNC(op_57f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (7) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (EQ) */
void REGPARAM2 CPUFUNC(op_57f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (7) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (EQ) */
void REGPARAM2 CPUFUNC(op_57f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (7) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (VC) */
void REGPARAM2 CPUFUNC(op_58c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (8) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (VC) */
void REGPARAM2 CPUFUNC(op_58c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (8)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130912;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130912: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (VC) */
void REGPARAM2 CPUFUNC(op_58d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (8) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (VC) */
void REGPARAM2 CPUFUNC(op_58d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (8) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (VC) */
void REGPARAM2 CPUFUNC(op_58e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (8) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (VC) */
void REGPARAM2 CPUFUNC(op_58e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (8) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (VC) */
void REGPARAM2 CPUFUNC(op_58f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (8) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (VC) */
void REGPARAM2 CPUFUNC(op_58f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (8) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (VC) */
void REGPARAM2 CPUFUNC(op_58f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (8) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (VS) */
void REGPARAM2 CPUFUNC(op_59c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (9) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (VS) */
void REGPARAM2 CPUFUNC(op_59c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (9)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130921;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130921: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (VS) */
void REGPARAM2 CPUFUNC(op_59d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (9) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (VS) */
void REGPARAM2 CPUFUNC(op_59d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (9) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (VS) */
void REGPARAM2 CPUFUNC(op_59e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (9) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (VS) */
void REGPARAM2 CPUFUNC(op_59e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (9) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (VS) */
void REGPARAM2 CPUFUNC(op_59f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (9) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (VS) */
void REGPARAM2 CPUFUNC(op_59f8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (9) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (VS) */
void REGPARAM2 CPUFUNC(op_59f9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (9) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (PL) */
void REGPARAM2 CPUFUNC(op_5ac0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (10) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (PL) */
void REGPARAM2 CPUFUNC(op_5ac8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (10)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130930;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130930: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (PL) */
void REGPARAM2 CPUFUNC(op_5ad0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (10) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (PL) */
void REGPARAM2 CPUFUNC(op_5ad8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (10) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (PL) */
void REGPARAM2 CPUFUNC(op_5ae0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (10) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (PL) */
void REGPARAM2 CPUFUNC(op_5ae8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (10) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (PL) */
void REGPARAM2 CPUFUNC(op_5af0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (10) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (PL) */
void REGPARAM2 CPUFUNC(op_5af8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (10) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (PL) */
void REGPARAM2 CPUFUNC(op_5af9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (10) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (MI) */
void REGPARAM2 CPUFUNC(op_5bc0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (11) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (MI) */
void REGPARAM2 CPUFUNC(op_5bc8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (11)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130939;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130939: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (MI) */
void REGPARAM2 CPUFUNC(op_5bd0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (11) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (MI) */
void REGPARAM2 CPUFUNC(op_5bd8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (11) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (MI) */
void REGPARAM2 CPUFUNC(op_5be0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (11) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (MI) */
void REGPARAM2 CPUFUNC(op_5be8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (11) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (MI) */
void REGPARAM2 CPUFUNC(op_5bf0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (11) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (MI) */
void REGPARAM2 CPUFUNC(op_5bf8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (11) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (MI) */
void REGPARAM2 CPUFUNC(op_5bf9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (11) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (GE) */
void REGPARAM2 CPUFUNC(op_5cc0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (12) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (GE) */
void REGPARAM2 CPUFUNC(op_5cc8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (12)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130948;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130948: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (GE) */
void REGPARAM2 CPUFUNC(op_5cd0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (12) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (GE) */
void REGPARAM2 CPUFUNC(op_5cd8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (12) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (GE) */
void REGPARAM2 CPUFUNC(op_5ce0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (12) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (GE) */
void REGPARAM2 CPUFUNC(op_5ce8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (12) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (GE) */
void REGPARAM2 CPUFUNC(op_5cf0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (12) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (GE) */
void REGPARAM2 CPUFUNC(op_5cf8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (12) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (GE) */
void REGPARAM2 CPUFUNC(op_5cf9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (12) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (LT) */
void REGPARAM2 CPUFUNC(op_5dc0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (13) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (LT) */
void REGPARAM2 CPUFUNC(op_5dc8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (13)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130957;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130957: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (LT) */
void REGPARAM2 CPUFUNC(op_5dd0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (13) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (LT) */
void REGPARAM2 CPUFUNC(op_5dd8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (13) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (LT) */
void REGPARAM2 CPUFUNC(op_5de0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (13) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (LT) */
void REGPARAM2 CPUFUNC(op_5de8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (13) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (LT) */
void REGPARAM2 CPUFUNC(op_5df0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (13) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (LT) */
void REGPARAM2 CPUFUNC(op_5df8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (13) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (LT) */
void REGPARAM2 CPUFUNC(op_5df9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (13) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (GT) */
void REGPARAM2 CPUFUNC(op_5ec0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (14) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (GT) */
void REGPARAM2 CPUFUNC(op_5ec8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (14)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130966;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130966: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (GT) */
void REGPARAM2 CPUFUNC(op_5ed0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (14) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (GT) */
void REGPARAM2 CPUFUNC(op_5ed8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (14) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (GT) */
void REGPARAM2 CPUFUNC(op_5ee0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (14) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (GT) */
void REGPARAM2 CPUFUNC(op_5ee8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (14) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (GT) */
void REGPARAM2 CPUFUNC(op_5ef0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (14) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (GT) */
void REGPARAM2 CPUFUNC(op_5ef8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (14) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (GT) */
void REGPARAM2 CPUFUNC(op_5ef9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (14) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Scc.B Dn (LE) */
void REGPARAM2 CPUFUNC(op_5fc0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (15) ? 0xff : 0;
	int cycles = val ? 2 : 0;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (LE) */
void REGPARAM2 CPUFUNC(op_5fc8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	do_cycles_ce000_internal (2);
	if (!cctrue (15)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_ce000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_130975;
			}
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
			return;
		}
	} else {
	do_cycles_ce000_internal (2);
	}
	m68k_setpci (oldpc + 4);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}}l_130975: ;
return;
} /* 10 (2/0) */

/* Scc.B (An) (LE) */
void REGPARAM2 CPUFUNC(op_5fd0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (15) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B (An)+ (LE) */
void REGPARAM2 CPUFUNC(op_5fd8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (15) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/1) */

/* Scc.B -(An) (LE) */
void REGPARAM2 CPUFUNC(op_5fe0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	int val = cctrue (15) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
} /* 10 (1/1) */

/* Scc.B (d16,An) (LE) */
void REGPARAM2 CPUFUNC(op_5fe8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (15) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (LE) */
void REGPARAM2 CPUFUNC(op_5ff0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (15) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 14 (2/1) */

/* Scc.B (xxx).W (LE) */
void REGPARAM2 CPUFUNC(op_5ff8_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	int val = cctrue (15) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/1) */

/* Scc.B (xxx).L (LE) */
void REGPARAM2 CPUFUNC(op_5ff9_13)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	int val = cctrue (15) ? 0xff : 0;
	ipl_fetch ();
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/1) */

/* Bcc.W #<data>.W (T) */
void REGPARAM2 CPUFUNC(op_6000_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130983;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130983: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (T) */
void REGPARAM2 CPUFUNC(op_6001_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130984;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130984: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (T) */
void REGPARAM2 CPUFUNC(op_60ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (0)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_130985;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_130985: ;
return;
} /* 8 (1/0) */

/* BSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6100_13)(uae_u32 opcode)
{
{	uae_s32 s;
{	uae_s16 src = regs.irc;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_130986;
	}
	do_cycles_ce000_internal (2);
	m68k_do_bsr_ce (m68k_getpci () + 4, s);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130986: ;
return;
} /* 18 (2/2) */

/* BSRQ.B #<data> */
void REGPARAM2 CPUFUNC(op_6101_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{	uae_s32 s;
{	uae_u32 src = srcreg;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_130987;
	}
	do_cycles_ce000_internal (2);
	m68k_do_bsr_ce (m68k_getpci () + 2, s);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}l_130987: ;
return;
} /* 18 (2/2) */

/* BSR.L #<data>.L */
void REGPARAM2 CPUFUNC(op_61ff_13)(uae_u32 opcode)
{
{	uae_s32 s;
	uae_u32 src = 0xffffffff;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_130988;
	}
	do_cycles_ce000_internal (2);
	m68k_do_bsr_ce (m68k_getpci () + 2, s);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_130988: ;
return;
} /* 18 (2/2) */

/* Bcc.W #<data>.W (HI) */
void REGPARAM2 CPUFUNC(op_6200_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130989;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130989: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (HI) */
void REGPARAM2 CPUFUNC(op_6201_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130990;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130990: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (HI) */
void REGPARAM2 CPUFUNC(op_62ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (2)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_130991;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_130991: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (LS) */
void REGPARAM2 CPUFUNC(op_6300_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130992;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130992: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (LS) */
void REGPARAM2 CPUFUNC(op_6301_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130993;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130993: ;
return;
} /* 8 (1/0) */

#endif

#ifdef PART_6
/* Bcc.L #<data>.L (LS) */
void REGPARAM2 CPUFUNC(op_63ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (3)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_130994;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_130994: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (CC) */
void REGPARAM2 CPUFUNC(op_6400_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130995;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130995: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (CC) */
void REGPARAM2 CPUFUNC(op_6401_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130996;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130996: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (CC) */
void REGPARAM2 CPUFUNC(op_64ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (4)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_130997;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_130997: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (CS) */
void REGPARAM2 CPUFUNC(op_6500_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130998;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130998: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (CS) */
void REGPARAM2 CPUFUNC(op_6501_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_130999;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_130999: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (CS) */
void REGPARAM2 CPUFUNC(op_65ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (5)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131000;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131000: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (NE) */
void REGPARAM2 CPUFUNC(op_6600_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131001;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131001: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (NE) */
void REGPARAM2 CPUFUNC(op_6601_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131002;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131002: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (NE) */
void REGPARAM2 CPUFUNC(op_66ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (6)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131003;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131003: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (EQ) */
void REGPARAM2 CPUFUNC(op_6700_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131004;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131004: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (EQ) */
void REGPARAM2 CPUFUNC(op_6701_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131005;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131005: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (EQ) */
void REGPARAM2 CPUFUNC(op_67ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (7)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131006;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131006: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (VC) */
void REGPARAM2 CPUFUNC(op_6800_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131007;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131007: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (VC) */
void REGPARAM2 CPUFUNC(op_6801_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131008;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131008: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (VC) */
void REGPARAM2 CPUFUNC(op_68ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (8)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131009;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131009: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (VS) */
void REGPARAM2 CPUFUNC(op_6900_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131010;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131010: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (VS) */
void REGPARAM2 CPUFUNC(op_6901_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131011;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131011: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (VS) */
void REGPARAM2 CPUFUNC(op_69ff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (9)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131012;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131012: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (PL) */
void REGPARAM2 CPUFUNC(op_6a00_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131013;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131013: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (PL) */
void REGPARAM2 CPUFUNC(op_6a01_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131014;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131014: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (PL) */
void REGPARAM2 CPUFUNC(op_6aff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (10)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131015;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131015: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (MI) */
void REGPARAM2 CPUFUNC(op_6b00_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131016;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131016: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (MI) */
void REGPARAM2 CPUFUNC(op_6b01_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131017;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131017: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (MI) */
void REGPARAM2 CPUFUNC(op_6bff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (11)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131018;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131018: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (GE) */
void REGPARAM2 CPUFUNC(op_6c00_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131019;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131019: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (GE) */
void REGPARAM2 CPUFUNC(op_6c01_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131020;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131020: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (GE) */
void REGPARAM2 CPUFUNC(op_6cff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (12)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131021;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131021: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (LT) */
void REGPARAM2 CPUFUNC(op_6d00_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131022;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131022: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (LT) */
void REGPARAM2 CPUFUNC(op_6d01_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131023;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131023: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (LT) */
void REGPARAM2 CPUFUNC(op_6dff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (13)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131024;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131024: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (GT) */
void REGPARAM2 CPUFUNC(op_6e00_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131025;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131025: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (GT) */
void REGPARAM2 CPUFUNC(op_6e01_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131026;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131026: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (GT) */
void REGPARAM2 CPUFUNC(op_6eff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (14)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131027;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131027: ;
return;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (LE) */
void REGPARAM2 CPUFUNC(op_6f00_13)(uae_u32 opcode)
{
{{	uae_s16 src = regs.irc;
	do_cycles_ce000_internal (2);
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131028;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (4);
	do_cycles_ce000_internal (2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131028: ;
return;
} /* 12 (2/0) */

/* BccQ.B #<data> (LE) */
void REGPARAM2 CPUFUNC(op_6f01_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce000_internal (2);
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_131029;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_ce000_prefetch (0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
	return;
didnt_jump:;
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch (2);
}}l_131029: ;
return;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (LE) */
void REGPARAM2 CPUFUNC(op_6fff_13)(uae_u32 opcode)
{
{	do_cycles_ce000_internal (2);
	if (cctrue (15)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_131030;
	}
	m68k_incpci (2);
	do_cycles_ce000_internal (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}l_131030: ;
return;
} /* 8 (1/0) */

/* MOVEQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_7000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_u32 src = srcreg;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (2);
}}}return;
} /* 4 (1/0) */

/* OR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_8000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* OR.B (An),Dn */
void REGPARAM2 CPUFUNC(op_8010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* OR.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* OR.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_8020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 10 (2/0) */

/* OR.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_8028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* OR.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_8030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* OR.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_8038_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* OR.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_8039_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* OR.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_803a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* OR.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_803b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* OR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_803c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* OR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_8040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* OR.W (An),Dn */
void REGPARAM2 CPUFUNC(op_8050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131044;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_131044: ;
return;
} /* 8 (2/0) */

/* OR.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131045;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_131045: ;
return;
} /* 8 (2/0) */

/* OR.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_8060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131046;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_131046: ;
return;
} /* 10 (2/0) */

/* OR.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_8068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131047;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131047: ;
return;
} /* 12 (3/0) */

/* OR.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_8070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131048;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131048: ;
return;
} /* 14 (3/0) */

/* OR.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_8078_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131049;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131049: ;
return;
} /* 12 (3/0) */

/* OR.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_8079_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131050;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (6);
l_131050: ;
return;
} /* 16 (4/0) */

/* OR.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_807a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131051;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131051: ;
return;
} /* 12 (3/0) */

/* OR.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_807b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131052;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131052: ;
return;
} /* 14 (3/0) */

/* OR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_807c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* OR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_8080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* OR.L (An),Dn */
void REGPARAM2 CPUFUNC(op_8090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131055;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_131055: ;
return;
} /* 14 (3/0) */

/* OR.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131056;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_131056: ;
return;
} /* 14 (3/0) */

/* OR.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_80a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131057;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_131057: ;
return;
} /* 16 (3/0) */

/* OR.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_80a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131058;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131058: ;
return;
} /* 18 (4/0) */

/* OR.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131059;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131059: ;
return;
} /* 20 (4/0) */

/* OR.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_80b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131060;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131060: ;
return;
} /* 18 (4/0) */

/* OR.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_80b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131061;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (6);
l_131061: ;
return;
} /* 22 (5/0) */

/* OR.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_80ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131062;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131062: ;
return;
} /* 18 (4/0) */

/* OR.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131063;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131063: ;
return;
} /* 20 (4/0) */

/* OR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_80bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* DIVU.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_80c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_131065;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
}}}}l_131065: ;
return;
} /* 4+ (1/0) */

/* DIVU.W (An),Dn */
void REGPARAM2 CPUFUNC(op_80d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131066;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_131066;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
}}}}}}l_131066: ;
return;
} /* 8+ (2/0) */

/* DIVU.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_80d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131067;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_131067;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
}}}}}}l_131067: ;
return;
} /* 8+ (2/0) */

/* DIVU.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_80e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131068;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_131068;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
}}}}}}l_131068: ;
return;
} /* 10+ (2/0) */

/* DIVU.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_80e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131069;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131069;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}}l_131069: ;
return;
} /* 12+ (3/0) */

/* DIVU.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131070;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131070;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}}l_131070: ;
return;
} /* 14+ (3/0) */

/* DIVU.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_80f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131071;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131071;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}}l_131071: ;
return;
} /* 12+ (3/0) */

/* DIVU.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_80f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131072;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (6);
		Exception (5);
		goto l_131072;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (6);
	}
}}}}}}l_131072: ;
return;
} /* 16+ (4/0) */

/* DIVU.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_80fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131073;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131073;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}}l_131073: ;
return;
} /* 12+ (3/0) */

/* DIVU.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131074;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131074;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}}l_131074: ;
return;
} /* 14+ (3/0) */

/* DIVU.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_80fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131075;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
{		int cycles = (getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}l_131075: ;
return;
} /* 8+ (2/0) */

/* SBCD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_8100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG () ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG () ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* SBCD.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_8108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG () ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG () ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}	m68k_incpci (2);
return;
} /* 18 (3/1) */

/* OR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_8110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* OR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* OR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_8120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* OR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_8128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* OR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_8130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* OR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_8138_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* OR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_8139_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* OR.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_8150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131085;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131085: ;
return;
} /* 12 (2/1) */

/* OR.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131086;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131086: ;
return;
} /* 12 (2/1) */

/* OR.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_8160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131087;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131087: ;
return;
} /* 14 (2/1) */

/* OR.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_8168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131088;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131088: ;
return;
} /* 16 (3/1) */

/* OR.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_8170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131089;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131089: ;
return;
} /* 18 (3/1) */

/* OR.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_8178_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131090;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131090: ;
return;
} /* 16 (3/1) */

/* OR.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_8179_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131091;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_131091: ;
return;
} /* 20 (4/1) */

/* OR.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_8190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131092;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131092: ;
return;
} /* 20 (3/2) */

/* OR.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131093;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131093: ;
return;
} /* 20 (3/2) */

/* OR.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_81a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131094;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131094: ;
return;
} /* 22 (3/2) */

/* OR.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_81a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131095;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131095: ;
return;
} /* 24 (4/2) */

/* OR.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_81b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131096;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131096: ;
return;
} /* 26 (4/2) */

/* OR.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_81b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131097;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131097: ;
return;
} /* 24 (4/2) */

/* OR.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_81b9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131098;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_131098: ;
return;
} /* 28 (5/2) */

/* DIVS.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_81c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_131099;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
}}}}l_131099: ;
return;
} /* 4+ (1/0) */

/* DIVS.W (An),Dn */
void REGPARAM2 CPUFUNC(op_81d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131100;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_131100;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
}}}}}}l_131100: ;
return;
} /* 8+ (2/0) */

/* DIVS.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_81d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131101;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_131101;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
}}}}}}l_131101: ;
return;
} /* 8+ (2/0) */

/* DIVS.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_81e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131102;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_131102;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
}}}}}}l_131102: ;
return;
} /* 10+ (2/0) */

/* DIVS.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_81e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131103;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131103;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}}l_131103: ;
return;
} /* 12+ (3/0) */

/* DIVS.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_81f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131104;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131104;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}}l_131104: ;
return;
} /* 14+ (3/0) */

/* DIVS.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_81f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131105;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131105;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}}l_131105: ;
return;
} /* 12+ (3/0) */

/* DIVS.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_81f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131106;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (6);
		Exception (5);
		goto l_131106;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (6);
}}}}}}l_131106: ;
return;
} /* 16+ (4/0) */

/* DIVS.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_81fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131107;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131107;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}}l_131107: ;
return;
} /* 12+ (3/0) */

/* DIVS.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_81fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131108;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131108;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}}l_131108: ;
return;
} /* 14+ (3/0) */

/* DIVS.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_81fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_131109;
	}
	CLEAR_CZNV ();
{		int cycles = (getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}l_131109: ;
return;
} /* 8+ (2/0) */

/* SUB.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_9000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* SUB.B (An),Dn */
void REGPARAM2 CPUFUNC(op_9010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* SUB.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* SUB.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_9020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
} /* 10 (2/0) */

/* SUB.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_9028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* SUB.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_9030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* SUB.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_9038_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* SUB.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_9039_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* SUB.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_903a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* SUB.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_903b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* SUB.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_903c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* SUB.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_9040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* SUB.W An,Dn */
void REGPARAM2 CPUFUNC(op_9048_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* SUB.W (An),Dn */
void REGPARAM2 CPUFUNC(op_9050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131123;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_131123: ;
return;
} /* 8 (2/0) */

/* SUB.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131124;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_131124: ;
return;
} /* 8 (2/0) */

/* SUB.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_9060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131125;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_131125: ;
return;
} /* 10 (2/0) */

/* SUB.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_9068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131126;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131126: ;
return;
} /* 12 (3/0) */

/* SUB.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_9070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131127;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131127: ;
return;
} /* 14 (3/0) */

/* SUB.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_9078_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131128;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131128: ;
return;
} /* 12 (3/0) */

/* SUB.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_9079_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131129;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (6);
l_131129: ;
return;
} /* 16 (4/0) */

/* SUB.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_907a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131130;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131130: ;
return;
} /* 12 (3/0) */

/* SUB.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_907b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131131;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131131: ;
return;
} /* 14 (3/0) */

/* SUB.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_907c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* SUB.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_9080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUB.L An,Dn */
void REGPARAM2 CPUFUNC(op_9088_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUB.L (An),Dn */
void REGPARAM2 CPUFUNC(op_9090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131135;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_131135: ;
return;
} /* 14 (3/0) */

/* SUB.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131136;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_131136: ;
return;
} /* 14 (3/0) */

/* SUB.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_90a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131137;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_131137: ;
return;
} /* 16 (3/0) */

/* SUB.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_90a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131138;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131138: ;
return;
} /* 18 (4/0) */

/* SUB.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_90b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131139;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131139: ;
return;
} /* 20 (4/0) */

/* SUB.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_90b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131140;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131140: ;
return;
} /* 18 (4/0) */

/* SUB.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_90b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131141;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (6);
l_131141: ;
return;
} /* 22 (5/0) */

/* SUB.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_90ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131142;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131142: ;
return;
} /* 18 (4/0) */

/* SUB.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_90bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131143;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131143: ;
return;
} /* 20 (4/0) */

/* SUB.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_90bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* SUBA.W Dn,An */
void REGPARAM2 CPUFUNC(op_90c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUBA.W An,An */
void REGPARAM2 CPUFUNC(op_90c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUBA.W (An),An */
void REGPARAM2 CPUFUNC(op_90d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131147;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131147: ;
return;
} /* 12 (2/0) */

/* SUBA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_90d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131148;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131148: ;
return;
} /* 12 (2/0) */

/* SUBA.W -(An),An */
void REGPARAM2 CPUFUNC(op_90e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131149;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131149: ;
return;
} /* 14 (2/0) */

/* SUBA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_90e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131150;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131150: ;
return;
} /* 16 (3/0) */

/* SUBA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_90f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131151;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131151: ;
return;
} /* 18 (3/0) */

/* SUBA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_90f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131152;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131152: ;
return;
} /* 16 (3/0) */

/* SUBA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_90f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131153;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_131153: ;
return;
} /* 20 (4/0) */

/* SUBA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_90fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131154;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131154: ;
return;
} /* 16 (3/0) */

/* SUBA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_90fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131155;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131155: ;
return;
} /* 18 (3/0) */

/* SUBA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_90fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/0) */

/* SUBX.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_9100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* SUBX.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 18 (3/1) */

/* SUB.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_9110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* SUB.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* SUB.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_9120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* SUB.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_9128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* SUB.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_9130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* SUB.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_9138_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* SUB.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_9139_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* SUBX.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_9140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* SUBX.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131167;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131167;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}}	m68k_incpci (2);
l_131167: ;
return;
} /* 18 (3/1) */

/* SUB.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_9150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131168;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_131168: ;
return;
} /* 12 (2/1) */

/* SUB.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131169;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_131169: ;
return;
} /* 12 (2/1) */

/* SUB.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_9160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131170;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_131170: ;
return;
} /* 14 (2/1) */

/* SUB.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_9168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131171;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_131171: ;
return;
} /* 16 (3/1) */

/* SUB.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_9170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131172;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_131172: ;
return;
} /* 18 (3/1) */

/* SUB.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_9178_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131173;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_131173: ;
return;
} /* 16 (3/1) */

/* SUB.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_9179_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131174;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_131174: ;
return;
} /* 20 (4/1) */

/* SUBX.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_9180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUBX.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9188_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131176;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131176;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (dsta, newv >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, newv);
}}}}}}}}}	m68k_incpci (2);
l_131176: ;
return;
} /* 30 (5/2) */

/* SUB.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_9190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131177;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_131177: ;
return;
} /* 20 (3/2) */

/* SUB.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131178;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_131178: ;
return;
} /* 20 (3/2) */

/* SUB.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_91a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131179;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_131179: ;
return;
} /* 22 (3/2) */

/* SUB.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_91a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131180;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_131180: ;
return;
} /* 24 (4/2) */

/* SUB.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_91b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131181;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_131181: ;
return;
} /* 26 (4/2) */

/* SUB.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_91b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131182;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_131182: ;
return;
} /* 24 (4/2) */

/* SUB.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_91b9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131183;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_131183: ;
return;
} /* 28 (5/2) */

/* SUBA.L Dn,An */
void REGPARAM2 CPUFUNC(op_91c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUBA.L An,An */
void REGPARAM2 CPUFUNC(op_91c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* SUBA.L (An),An */
void REGPARAM2 CPUFUNC(op_91d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131186;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131186: ;
return;
} /* 14 (3/0) */

/* SUBA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_91d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131187;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131187: ;
return;
} /* 14 (3/0) */

/* SUBA.L -(An),An */
void REGPARAM2 CPUFUNC(op_91e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131188;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131188: ;
return;
} /* 16 (3/0) */

/* SUBA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_91e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131189;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131189: ;
return;
} /* 18 (4/0) */

/* SUBA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_91f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131190;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131190: ;
return;
} /* 20 (4/0) */

/* SUBA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_91f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131191;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131191: ;
return;
} /* 18 (4/0) */

/* SUBA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_91f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131192;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_131192: ;
return;
} /* 22 (5/0) */

/* SUBA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_91fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131193;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131193: ;
return;
} /* 18 (4/0) */

/* SUBA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_91fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131194;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131194: ;
return;
} /* 20 (4/0) */

/* SUBA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_91fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* CMP.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_b000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* CMP.B (An),Dn */
void REGPARAM2 CPUFUNC(op_b010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* CMP.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* CMP.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_b020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
} /* 10 (2/0) */

/* CMP.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* CMP.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* CMP.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b038_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* CMP.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b039_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* CMP.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b03a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* CMP.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b03b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* CMP.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_b03c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* CMP.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_b040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* CMP.W An,Dn */
void REGPARAM2 CPUFUNC(op_b048_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* CMP.W (An),Dn */
void REGPARAM2 CPUFUNC(op_b050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131209;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131209: ;
return;
} /* 8 (2/0) */

/* CMP.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131210;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131210: ;
return;
} /* 8 (2/0) */

/* CMP.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_b060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131211;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131211: ;
return;
} /* 10 (2/0) */

/* CMP.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131212;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131212: ;
return;
} /* 12 (3/0) */

/* CMP.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131213;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131213: ;
return;
} /* 14 (3/0) */

/* CMP.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b078_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131214;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131214: ;
return;
} /* 12 (3/0) */

/* CMP.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b079_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131215;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_131215: ;
return;
} /* 16 (4/0) */

/* CMP.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b07a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131216;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131216: ;
return;
} /* 12 (3/0) */

/* CMP.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b07b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131217;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131217: ;
return;
} /* 14 (3/0) */

/* CMP.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_b07c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* CMP.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_b080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* CMP.L An,Dn */
void REGPARAM2 CPUFUNC(op_b088_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* CMP.L (An),Dn */
void REGPARAM2 CPUFUNC(op_b090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131221;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131221: ;
return;
} /* 14 (3/0) */

/* CMP.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131222;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131222: ;
return;
} /* 14 (3/0) */

/* CMP.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_b0a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131223;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131223: ;
return;
} /* 16 (3/0) */

#endif

#ifdef PART_7
/* CMP.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b0a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131224;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131224: ;
return;
} /* 18 (4/0) */

/* CMP.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b0b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131225;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131225: ;
return;
} /* 20 (4/0) */

/* CMP.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b0b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131226;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131226: ;
return;
} /* 18 (4/0) */

/* CMP.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b0b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131227;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_131227: ;
return;
} /* 22 (5/0) */

/* CMP.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b0ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131228;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131228: ;
return;
} /* 18 (4/0) */

/* CMP.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b0bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131229;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131229: ;
return;
} /* 20 (4/0) */

/* CMP.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_b0bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (6);
return;
} /* 14 (3/0) */

/* CMPA.W Dn,An */
void REGPARAM2 CPUFUNC(op_b0c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* CMPA.W An,An */
void REGPARAM2 CPUFUNC(op_b0c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* CMPA.W (An),An */
void REGPARAM2 CPUFUNC(op_b0d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131233;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131233: ;
return;
} /* 10 (2/0) */

/* CMPA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_b0d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131234;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131234: ;
return;
} /* 10 (2/0) */

/* CMPA.W -(An),An */
void REGPARAM2 CPUFUNC(op_b0e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131235;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131235: ;
return;
} /* 12 (2/0) */

/* CMPA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_b0e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131236;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131236: ;
return;
} /* 14 (3/0) */

/* CMPA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_b0f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131237;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131237: ;
return;
} /* 16 (3/0) */

/* CMPA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_b0f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131238;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131238: ;
return;
} /* 14 (3/0) */

/* CMPA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_b0f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131239;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_131239: ;
return;
} /* 18 (4/0) */

/* CMPA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_b0fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131240;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131240: ;
return;
} /* 14 (3/0) */

/* CMPA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_b0fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131241;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131241: ;
return;
} /* 16 (3/0) */

/* CMPA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_b0fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
} /* 10 (2/0) */

/* EOR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_b100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* CMPM.B (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
return;
} /* 12 (3/0) */

/* EOR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_b110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* EOR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* EOR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* EOR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* EOR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* EOR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b138_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* EOR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b139_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* EOR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_b140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* CMPM.W (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131253;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131253;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}}}	m68k_incpci (2);
l_131253: ;
return;
} /* 12 (3/0) */

/* EOR.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_b150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131254;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131254: ;
return;
} /* 12 (2/1) */

/* EOR.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131255;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131255: ;
return;
} /* 12 (2/1) */

/* EOR.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131256;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131256: ;
return;
} /* 14 (2/1) */

/* EOR.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131257;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131257: ;
return;
} /* 16 (3/1) */

/* EOR.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131258;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131258: ;
return;
} /* 18 (3/1) */

/* EOR.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b178_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131259;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131259: ;
return;
} /* 16 (3/1) */

/* EOR.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b179_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131260;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_131260: ;
return;
} /* 20 (4/1) */

/* EOR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_b180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* CMPM.L (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b188_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131262;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131262;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}}}	m68k_incpci (2);
l_131262: ;
return;
} /* 20 (5/0) */

/* EOR.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_b190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131263;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131263: ;
return;
} /* 20 (3/2) */

/* EOR.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131264;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131264: ;
return;
} /* 20 (3/2) */

/* EOR.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b1a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131265;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131265: ;
return;
} /* 22 (3/2) */

/* EOR.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b1a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131266;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131266: ;
return;
} /* 24 (4/2) */

/* EOR.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b1b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131267;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131267: ;
return;
} /* 26 (4/2) */

/* EOR.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b1b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131268;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131268: ;
return;
} /* 24 (4/2) */

/* EOR.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b1b9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131269;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_131269: ;
return;
} /* 28 (5/2) */

/* CMPA.L Dn,An */
void REGPARAM2 CPUFUNC(op_b1c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* CMPA.L An,An */
void REGPARAM2 CPUFUNC(op_b1c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* CMPA.L (An),An */
void REGPARAM2 CPUFUNC(op_b1d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131272;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131272: ;
return;
} /* 14 (3/0) */

/* CMPA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_b1d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131273;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131273: ;
return;
} /* 14 (3/0) */

/* CMPA.L -(An),An */
void REGPARAM2 CPUFUNC(op_b1e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131274;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_131274: ;
return;
} /* 16 (3/0) */

/* CMPA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_b1e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131275;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131275: ;
return;
} /* 18 (4/0) */

/* CMPA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_b1f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131276;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131276: ;
return;
} /* 20 (4/0) */

/* CMPA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_b1f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131277;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131277: ;
return;
} /* 18 (4/0) */

/* CMPA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_b1f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131278;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_131278: ;
return;
} /* 22 (5/0) */

/* CMPA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_b1fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131279;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131279: ;
return;
} /* 18 (4/0) */

/* CMPA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_b1fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131280;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_131280: ;
return;
} /* 20 (4/0) */

/* CMPA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_b1fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (6);
return;
} /* 14 (3/0) */

/* AND.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_c000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* AND.B (An),Dn */
void REGPARAM2 CPUFUNC(op_c010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* AND.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* AND.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_c020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 10 (2/0) */

/* AND.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* AND.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* AND.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c038_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* AND.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c039_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* AND.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c03a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* AND.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c03b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* AND.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_c03c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* AND.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* AND.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131294;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_131294: ;
return;
} /* 8 (2/0) */

/* AND.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131295;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_131295: ;
return;
} /* 8 (2/0) */

/* AND.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131296;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_131296: ;
return;
} /* 10 (2/0) */

/* AND.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131297;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131297: ;
return;
} /* 12 (3/0) */

/* AND.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131298;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131298: ;
return;
} /* 14 (3/0) */

/* AND.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c078_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131299;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131299: ;
return;
} /* 12 (3/0) */

/* AND.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c079_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131300;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (6);
l_131300: ;
return;
} /* 16 (4/0) */

/* AND.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c07a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131301;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131301: ;
return;
} /* 12 (3/0) */

/* AND.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c07b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131302;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_131302: ;
return;
} /* 14 (3/0) */

/* AND.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c07c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* AND.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_c080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* AND.L (An),Dn */
void REGPARAM2 CPUFUNC(op_c090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131305;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_131305: ;
return;
} /* 14 (3/0) */

/* AND.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131306;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_131306: ;
return;
} /* 14 (3/0) */

/* AND.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_c0a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131307;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_131307: ;
return;
} /* 16 (3/0) */

/* AND.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c0a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131308;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131308: ;
return;
} /* 18 (4/0) */

/* AND.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131309;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131309: ;
return;
} /* 20 (4/0) */

/* AND.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c0b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131310;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131310: ;
return;
} /* 18 (4/0) */

/* AND.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c0b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131311;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (6);
l_131311: ;
return;
} /* 22 (5/0) */

/* AND.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c0ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131312;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131312: ;
return;
} /* 18 (4/0) */

/* AND.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131313;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_131313: ;
return;
} /* 20 (4/0) */

/* AND.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_c0bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* MULU.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c0c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}return;
} /* 38+ (1/0) */

/* MULU.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c0d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131316;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}}l_131316: ;
return;
} /* 42+ (2/0) */

/* MULU.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c0d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131317;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}}l_131317: ;
return;
} /* 42+ (2/0) */

/* MULU.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c0e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131318;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}}l_131318: ;
return;
} /* 44+ (2/0) */

/* MULU.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c0e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131319;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_131319: ;
return;
} /* 46+ (3/0) */

/* MULU.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131320;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_131320: ;
return;
} /* 48+ (3/0) */

/* MULU.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c0f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131321;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_131321: ;
return;
} /* 46+ (3/0) */

/* MULU.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c0f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131322;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (6);
}}}}}}l_131322: ;
return;
} /* 50+ (4/0) */

/* MULU.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c0fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131323;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_131323: ;
return;
} /* 46+ (3/0) */

/* MULU.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131324;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_131324: ;
return;
} /* 48+ (3/0) */

/* MULU.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c0fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 38 - 4, bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}return;
} /* 42+ (2/0) */

/* ABCD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_c100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* ABCD.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_c108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}	m68k_incpci (2);
return;
} /* 18 (3/1) */

/* AND.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_c110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* AND.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_c118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* AND.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_c120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* AND.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_c128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* AND.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_c130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* AND.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_c138_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* AND.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_c139_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* EXG.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_c140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, srcreg) = (dst);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* EXG.L An,An */
void REGPARAM2 CPUFUNC(op_c148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_areg (regs, srcreg) = (dst);
	m68k_areg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* AND.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_c150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131337;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131337: ;
return;
} /* 12 (2/1) */

/* AND.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_c158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131338;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131338: ;
return;
} /* 12 (2/1) */

/* AND.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_c160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131339;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (2);
l_131339: ;
return;
} /* 14 (2/1) */

/* AND.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_c168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131340;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131340: ;
return;
} /* 16 (3/1) */

/* AND.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_c170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131341;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131341: ;
return;
} /* 18 (3/1) */

/* AND.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_c178_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131342;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (4);
l_131342: ;
return;
} /* 16 (3/1) */

/* AND.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_c179_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131343;
	}
{{	uae_s16 dst = x_get_word (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	ipl_fetch ();
	x_put_word (dsta, src);
}}}}}	m68k_incpci (6);
l_131343: ;
return;
} /* 20 (4/1) */

/* EXG.L Dn,An */
void REGPARAM2 CPUFUNC(op_c188_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
	m68k_dreg (regs, srcreg) = (dst);
	m68k_areg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
} /* 6 (1/0) */

/* AND.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_c190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131345;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131345: ;
return;
} /* 20 (3/2) */

/* AND.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_c198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131346;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131346: ;
return;
} /* 20 (3/2) */

/* AND.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_c1a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131347;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_131347: ;
return;
} /* 22 (3/2) */

/* AND.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_c1a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131348;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131348: ;
return;
} /* 24 (4/2) */

/* AND.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_c1b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131349;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131349: ;
return;
} /* 26 (4/2) */

/* AND.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_c1b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131350;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_131350: ;
return;
} /* 24 (4/2) */

/* AND.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_c1b9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131351;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	x_put_word (dsta + 2, src);
	ipl_fetch ();
x_put_word (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_131351: ;
return;
} /* 28 (5/2) */

/* MULS.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c1c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 38+ (1/0) */

/* MULS.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c1d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131353;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131353: ;
return;
} /* 42+ (2/0) */

/* MULS.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c1d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131354;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131354: ;
return;
} /* 42+ (2/0) */

/* MULS.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c1e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131355;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131355: ;
return;
} /* 44+ (2/0) */

/* MULS.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c1e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131356;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131356: ;
return;
} /* 46+ (3/0) */

/* MULS.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c1f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131357;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131357: ;
return;
} /* 48+ (3/0) */

/* MULS.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c1f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131358;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131358: ;
return;
} /* 46+ (3/0) */

/* MULS.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c1f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131359;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_131359: ;
return;
} /* 50+ (4/0) */

/* MULS.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c1fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131360;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131360: ;
return;
} /* 46+ (3/0) */

/* MULS.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c1fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131361;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131361: ;
return;
} /* 48+ (3/0) */

/* MULS.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c1fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 38 - 4, bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2;
	if (cycles > 0) do_cycles_ce000_internal (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}	m68k_incpci (4);
return;
} /* 42+ (2/0) */

/* ADD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_d000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* ADD.B (An),Dn */
void REGPARAM2 CPUFUNC(op_d010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* ADD.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_d018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
} /* 8 (2/0) */

/* ADD.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_d020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal (2);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
} /* 10 (2/0) */

/* ADD.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_d028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* ADD.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_d030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* ADD.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_d038_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* ADD.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_d039_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (6);
return;
} /* 16 (4/0) */

/* ADD.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_d03a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 12 (3/0) */

/* ADD.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_d03b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
} /* 14 (3/0) */

/* ADD.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_d03c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* ADD.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_d040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* ADD.W An,Dn */
void REGPARAM2 CPUFUNC(op_d048_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* ADD.W (An),Dn */
void REGPARAM2 CPUFUNC(op_d050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131376;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_131376: ;
return;
} /* 8 (2/0) */

/* ADD.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_d058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131377;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_131377: ;
return;
} /* 8 (2/0) */

/* ADD.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_d060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131378;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_131378: ;
return;
} /* 10 (2/0) */

/* ADD.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_d068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131379;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131379: ;
return;
} /* 12 (3/0) */

/* ADD.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_d070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131380;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131380: ;
return;
} /* 14 (3/0) */

/* ADD.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_d078_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131381;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131381: ;
return;
} /* 12 (3/0) */

/* ADD.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_d079_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131382;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (6);
l_131382: ;
return;
} /* 16 (4/0) */

/* ADD.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_d07a_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131383;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131383: ;
return;
} /* 12 (3/0) */

/* ADD.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_d07b_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131384;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_131384: ;
return;
} /* 14 (3/0) */

/* ADD.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_d07c_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
} /* 8 (2/0) */

/* ADD.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_d080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADD.L An,Dn */
void REGPARAM2 CPUFUNC(op_d088_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADD.L (An),Dn */
void REGPARAM2 CPUFUNC(op_d090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131388;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_131388: ;
return;
} /* 14 (3/0) */

/* ADD.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_d098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131389;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_131389: ;
return;
} /* 14 (3/0) */

/* ADD.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_d0a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131390;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_131390: ;
return;
} /* 16 (3/0) */

/* ADD.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_d0a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131391;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131391: ;
return;
} /* 18 (4/0) */

/* ADD.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_d0b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131392;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131392: ;
return;
} /* 20 (4/0) */

/* ADD.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_d0b8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131393;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131393: ;
return;
} /* 18 (4/0) */

/* ADD.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_d0b9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131394;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (6);
l_131394: ;
return;
} /* 22 (5/0) */

/* ADD.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_d0ba_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131395;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131395: ;
return;
} /* 18 (4/0) */

/* ADD.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_d0bb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131396;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_131396: ;
return;
} /* 20 (4/0) */

/* ADD.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_d0bc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* ADDA.W Dn,An */
void REGPARAM2 CPUFUNC(op_d0c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADDA.W An,An */
void REGPARAM2 CPUFUNC(op_d0c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADDA.W (An),An */
void REGPARAM2 CPUFUNC(op_d0d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131400;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131400: ;
return;
} /* 12 (2/0) */

/* ADDA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_d0d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131401;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131401: ;
return;
} /* 12 (2/0) */

/* ADDA.W -(An),An */
void REGPARAM2 CPUFUNC(op_d0e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131402;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131402: ;
return;
} /* 14 (2/0) */

/* ADDA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_d0e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131403;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131403: ;
return;
} /* 16 (3/0) */

/* ADDA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_d0f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131404;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131404: ;
return;
} /* 18 (3/0) */

/* ADDA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_d0f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131405;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131405: ;
return;
} /* 16 (3/0) */

/* ADDA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_d0f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131406;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_131406: ;
return;
} /* 20 (4/0) */

/* ADDA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_d0fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131407;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131407: ;
return;
} /* 16 (3/0) */

/* ADDA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_d0fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131408;
	}
{{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131408: ;
return;
} /* 18 (3/0) */

/* ADDA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_d0fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce000_prefetch (4);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (4);
return;
} /* 12 (2/0) */

/* ADDX.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_d100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* ADDX.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_d108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 18 (3/1) */

/* ADD.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_d110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* ADD.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_d118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 12 (2/1) */

/* ADD.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_d120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal (2);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
} /* 14 (2/1) */

/* ADD.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_d128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* ADD.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_d130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 18 (3/1) */

/* ADD.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_d138_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
} /* 16 (3/1) */

/* ADD.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_d139_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
{	uae_s8 dst = x_get_byte (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
} /* 20 (4/1) */

/* ADDX.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_d140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpci (2);
return;
} /* 4 (1/0) */

/* ADDX.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_d148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131420;
	}
{{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131420;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}}	m68k_incpci (2);
l_131420: ;
return;
} /* 18 (3/1) */

/* ADD.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_d150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131421;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_131421: ;
return;
} /* 12 (2/1) */

/* ADD.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_d158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131422;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_131422: ;
return;
} /* 12 (2/1) */

/* ADD.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_d160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131423;
	}
{{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_131423: ;
return;
} /* 14 (2/1) */

/* ADD.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_d168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131424;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_131424: ;
return;
} /* 16 (3/1) */

/* ADD.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_d170_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131425;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_131425: ;
return;
} /* 18 (3/1) */

/* ADD.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_d178_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131426;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_131426: ;
return;
} /* 16 (3/1) */

/* ADD.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_d179_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131427;
	}
{{	uae_s16 dst = x_get_word (dsta);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	ipl_fetch ();
	x_put_word (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_131427: ;
return;
} /* 20 (4/1) */

/* ADDX.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_d180_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADDX.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_d188_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	do_cycles_ce000_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131429;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131429;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	x_put_word (dsta, newv >> 16);
	ipl_fetch ();
	x_put_word (dsta + 2, newv);
}}}}}}}}}	m68k_incpci (2);
l_131429: ;
return;
} /* 30 (5/2) */

/* ADD.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_d190_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131430;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_131430: ;
return;
} /* 20 (3/2) */

/* ADD.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_d198_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131431;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_131431: ;
return;
} /* 20 (3/2) */

/* ADD.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_d1a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce000_internal (2);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131432;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_131432: ;
return;
} /* 22 (3/2) */

/* ADD.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_d1a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131433;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_131433: ;
return;
} /* 24 (4/2) */

/* ADD.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_d1b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	do_cycles_ce000_internal (2);
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_ce000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_131434;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_131434: ;
return;
} /* 26 (4/2) */

/* ADD.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_d1b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_131435;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_131435: ;
return;
} /* 24 (4/2) */

/* ADD.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_d1b9_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_ce000_prefetch (4) << 16;
	dsta |= get_word_ce000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_131436;
	}
{{	uae_s32 dst = x_get_word (dsta) << 16; dst |= x_get_word (dsta + 2);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	x_put_word (dsta + 2, newv);
	ipl_fetch ();
x_put_word (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_131436: ;
return;
} /* 28 (5/2) */

/* ADDA.L Dn,An */
void REGPARAM2 CPUFUNC(op_d1c0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADDA.L An,An */
void REGPARAM2 CPUFUNC(op_d1c8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
} /* 8 (1/0) */

/* ADDA.L (An),An */
void REGPARAM2 CPUFUNC(op_d1d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131439;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131439: ;
return;
} /* 14 (3/0) */

/* ADDA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_d1d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131440;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131440: ;
return;
} /* 14 (3/0) */

/* ADDA.L -(An),An */
void REGPARAM2 CPUFUNC(op_d1e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce000_internal (2);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131441;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_131441: ;
return;
} /* 16 (3/0) */

/* ADDA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_d1e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131442;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131442: ;
return;
} /* 18 (4/0) */

/* ADDA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_d1f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131443;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131443: ;
return;
} /* 20 (4/0) */

/* ADDA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_d1f8_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_131444;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131444: ;
return;
} /* 18 (4/0) */

/* ADDA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_d1f9_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_ce000_prefetch (4) << 16;
	srca |= get_word_ce000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_131445;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_131445: ;
return;
} /* 22 (5/0) */

/* ADDA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_d1fa_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131446;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131446: ;
return;
} /* 18 (4/0) */

/* ADDA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_d1fb_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	do_cycles_ce000_internal (2);
	srca = get_disp_ea_000 (tmppc, get_word_ce000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_131447;
	}
{{	uae_s32 src = x_get_word (srca) << 16; src |= x_get_word (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
	do_cycles_ce000_internal (2);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_131447: ;
return;
} /* 20 (4/0) */

/* ADDA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_d1fc_13)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_ce000_prefetch (4) << 16;
	src |= get_word_ce000_prefetch (6);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
	do_cycles_ce000_internal (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (6);
return;
} /* 16 (3/0) */

/* ASRQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e000_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	uae_u32 sign = (0x80 & val) >> 7;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		val = 0xff & (uae_u32)-sign;
		SET_CFLG (sign);
		COPY_CARRY ();
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uae_u32)-sign;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* LSRQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e008_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		SET_CFLG ((cnt == 8) & (val >> 7));
		COPY_CARRY ();
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROXRQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e010_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG ();
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* RORQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e018_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	uae_u32 hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG ((val & 0x80) >> 7);
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ASR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_e020_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	uae_u32 sign = (0x80 & val) >> 7;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		val = 0xff & (uae_u32)-sign;
		SET_CFLG (sign);
		COPY_CARRY ();
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uae_u32)-sign;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* LSR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_e028_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		SET_CFLG ((cnt == 8) & (val >> 7));
		COPY_CARRY ();
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROXR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_e030_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 36) cnt -= 36;
	if (cnt >= 18) cnt -= 18;
	if (cnt >= 9) cnt -= 9;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG ();
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_e038_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG ((val & 0x80) >> 7);
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ASRQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e040_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = (0x8000 & val) >> 15;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 16) {
		val = 0xffff & (uae_u32)-sign;
		SET_CFLG (sign);
		COPY_CARRY ();
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
		val |= (0xffff << (16 - cnt)) & (uae_u32)-sign;
		val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

#endif

#ifdef PART_8
/* LSRQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e048_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 16) {
		SET_CFLG ((cnt == 16) & (val >> 15));
		COPY_CARRY ();
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROXRQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e050_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG ();
	hival <<= (15 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* RORQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e058_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	uae_u32 hival;
	cnt &= 15;
	hival = val << (16 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffff;
	SET_CFLG ((val & 0x8000) >> 15);
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ASR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_e060_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = (0x8000 & val) >> 15;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 16) {
		val = 0xffff & (uae_u32)-sign;
		SET_CFLG (sign);
		COPY_CARRY ();
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
		val |= (0xffff << (16 - cnt)) & (uae_u32)-sign;
		val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* LSR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_e068_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 16) {
		SET_CFLG ((cnt == 16) & (val >> 15));
		COPY_CARRY ();
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROXR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_e070_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 34) cnt -= 34;
	if (cnt >= 17) cnt -= 17;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG ();
	hival <<= (15 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_e078_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 15;
	hival = val << (16 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffff;
	SET_CFLG ((val & 0x8000) >> 15);
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ASRQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e080_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = data;
	uae_u32 sign = (0x80000000 & val) >> 31;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 32) {
		val = 0xffffffff & (uae_u32)-sign;
		SET_CFLG (sign);
		COPY_CARRY ();
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
		val |= (0xffffffff << (32 - cnt)) & (uae_u32)-sign;
		val &= 0xffffffff;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	{
		int cycles = 4;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* LSRQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e088_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 32) {
		SET_CFLG ((cnt == 32) & (val >> 31));
		COPY_CARRY ();
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	{
		int cycles = 4;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* ROXRQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e090_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG ();
	hival <<= (31 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	{
		int cycles = 4;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* RORQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e098_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	uae_u32 hival;
	cnt &= 31;
	hival = val << (32 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffffffff;
	SET_CFLG ((val & 0x80000000) >> 31);
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	{
		int cycles = 4;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* ASR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_e0a0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 cnt = m68k_dreg (regs, srcreg);
{	uae_s32 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = data;
	uae_u32 sign = (0x80000000 & val) >> 31;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 32) {
		val = 0xffffffff & (uae_u32)-sign;
		SET_CFLG (sign);
		COPY_CARRY ();
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
		val |= (0xffffffff << (32 - cnt)) & (uae_u32)-sign;
		val &= 0xffffffff;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	{
		int cycles = 4;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* LSR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_e0a8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 cnt = m68k_dreg (regs, srcreg);
{	uae_s32 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 32) {
		SET_CFLG ((cnt == 32) & (val >> 31));
		COPY_CARRY ();
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	{
		int cycles = 4;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* ROXR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_e0b0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 cnt = m68k_dreg (regs, srcreg);
{	uae_s32 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 33) cnt -= 33;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG ();
	hival <<= (31 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	{
		int cycles = 4;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* ROR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_e0b8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 cnt = m68k_dreg (regs, srcreg);
{	uae_s32 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 31;
	hival = val << (32 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffffffff;
	SET_CFLG ((val & 0x80000000) >> 31);
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	{
		int cycles = 4;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpci (2);
return;
} /* 8+ (1/0) */

/* ASRW.W (An) */
void REGPARAM2 CPUFUNC(op_e0d0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa;
	dataa = m68k_areg (regs, srcreg);
	if (dataa & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dataa);
		goto l_131473;
	}
{{	uae_s16 data = x_get_word (dataa);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY ();
	ipl_fetch ();
	x_put_word (dataa, val);
}}}}}	m68k_incpci (2);
l_131473: ;
return;
} /* 12 (2/1) */

/* ASRW.W (An)+ */
void REGPARAM2 CPUFUNC(op_e0d8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa;
	dataa = m68k_areg (regs, srcreg);
	if (dataa & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dataa);
		goto l_131474;
	}
{{	uae_s16 data = x_get_word (dataa);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY ();
	ipl_fetch ();
	x_put_word (dataa, val);
}}}}}	m68k_incpci (2);
l_131474: ;
return;
} /* 12 (2/1) */

/* ASRW.W -(An) */
void REGPARAM2 CPUFUNC(op_e0e0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa;
	dataa = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce000_internal (2);
	if (dataa & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dataa);
		goto l_131475;
	}
{{	uae_s16 data = x_get_word (dataa);
	m68k_areg (regs, srcreg) = dataa;
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY ();
	ipl_fetch ();
	x_put_word (dataa, val);
}}}}}	m68k_incpci (2);
l_131475: ;
return;
} /* 14 (2/1) */

/* ASRW.W (d16,An) */
void REGPARAM2 CPUFUNC(op_e0e8_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa;
	dataa = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dataa & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dataa);
		goto l_131476;
	}
{{	uae_s16 data = x_get_word (dataa);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY ();
	ipl_fetch ();
	x_put_word (dataa, val);
}}}}}	m68k_incpci (4);
l_131476: ;
return;
} /* 16 (3/1) */

/* ASRW.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_e0f0_13)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa;
	do_cycles_ce000_internal (2);
	dataa = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_ce000_prefetch (4));
	if (dataa & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dataa);
		goto l_131477;
	}
{{	uae_s16 data = x_get_word (dataa);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY ();
	ipl_fetch ();
	x_put_word (dataa, val);
}}}}}	m68k_incpci (4);
l_131477: ;
return;
} /* 18 (3/1) */

/* ASRW.W (xxx).W */
void REGPARAM2 CPUFUNC(op_e0f8_13)(uae_u32 opcode)
{
{{	uaecptr dataa;
	dataa = (uae_s32)(uae_s16)get_word_ce000_prefetch (4);
	if (dataa & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dataa);
		goto l_131478;
	}
{{	uae_s16 data = x_get_word (dataa);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (6);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY ();
	ipl_fetch ();
	x_put_word (dataa, val);
}}}}}	m68k_incpci (4);
l_131478: ;
return;
} /* 16 (3/1) */

/* ASRW.W (xxx).L */
void REGPARAM2 CPUFUNC(op_e0f9_13)(uae_u32 opcode)
{
{{	uaecptr dataa;
	dataa = get_word_ce000_prefetch (4) << 16;
	dataa |= get_word_ce000_prefetch (6);
	if (dataa & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dataa);
		goto l_131479;
	}
{{	uae_s16 data = x_get_word (dataa);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (8);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY ();
	ipl_fetch ();
	x_put_word (dataa, val);
}}}}}	m68k_incpci (6);
l_131479: ;
return;
} /* 20 (4/1) */

/* ASLQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e100_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 8 ? val & 1 : 0);
		COPY_CARRY ();
		val = 0;
	} else {
		uae_u32 mask = (0xff << (7 - cnt)) & 0xff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80) >> 7);
		COPY_CARRY ();
		val <<= 1;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* LSLQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e108_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		SET_CFLG (cnt == 8 ? val & 1 : 0);
		COPY_CARRY ();
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80) >> 7);
		COPY_CARRY ();
		val <<= 1;
	val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROXLQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e110_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (7 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG ()) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROLQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e118_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	uae_u32 loval;
	cnt &= 7;
	loval = val >> (8 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ASL.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_e120_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 8 ? val & 1 : 0);
		COPY_CARRY ();
		val = 0;
	} else if (cnt > 0) {
		uae_u32 mask = (0xff << (7 - cnt)) & 0xff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80) >> 7);
		COPY_CARRY ();
		val <<= 1;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* LSL.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_e128_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		SET_CFLG (cnt == 8 ? val & 1 : 0);
		COPY_CARRY ();
		val = 0;
	} else if (cnt > 0) {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80) >> 7);
		COPY_CARRY ();
		val <<= 1;
	val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROXL.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_e130_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 36) cnt -= 36;
	if (cnt >= 18) cnt -= 18;
	if (cnt >= 9) cnt -= 9;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (7 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG ()) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROL.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_e138_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt > 0) {
	uae_u32 loval;
	cnt &= 7;
	loval = val >> (8 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ASLQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e140_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 16) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 16 ? val & 1 : 0);
		COPY_CARRY ();
		val = 0;
	} else {
		uae_u32 mask = (0xffff << (15 - cnt)) & 0xffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x8000) >> 15);
		COPY_CARRY ();
		val <<= 1;
		val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* LSLQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e148_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 16) {
		SET_CFLG (cnt == 16 ? val & 1 : 0);
		COPY_CARRY ();
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x8000) >> 15);
		COPY_CARRY ();
		val <<= 1;
	val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROXLQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e150_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (15 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG ()) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ROLQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_e158_13)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	uae_u32 loval;
	cnt &= 15;
	loval = val >> (16 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* ASL.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_e160_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 16) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 16 ? val & 1 : 0);
		COPY_CARRY ();
		val = 0;
	} else if (cnt > 0) {
		uae_u32 mask = (0xffff << (15 - cnt)) & 0xffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x8000) >> 15);
		COPY_CARRY ();
		val <<= 1;
		val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	{
		int cycles = 2;
		cycles += 2 * ccnt;
		if (cycles > 0) do_cycles_ce000_internal (cycles);
	}
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpci (2);
return;
} /* 6+ (1/0) */

/* LSL.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_e168_13)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	ipl_fetch ();
	get_word_ce000_prefetch (4);
{	ua