#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "uae/memory.h"
#include "custom.h"
#include "events.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#define CPUFUNC(x) x##_ff
#define SET_CFLG_ALWAYS(x) SET_CFLG(x)
#define SET_NFLG_ALWAYS(x) SET_NFLG(x)
#ifdef NOFLAGS
#include "noflags.h"
#endif
#ifdef CPUEMU_0
const struct cputbl CPUFUNC(op_smalltbl_0)[] = {
{ CPUFUNC(op_0000_0), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0010_0), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0018_0), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0020_0), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0028_0), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0030_0), 0x0030, 4, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0038_0), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0039_0), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_003c_0), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0040_0), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0050_0), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0058_0), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0060_0), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0068_0), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0070_0), 0x0070, 4, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0078_0), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0079_0), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_007c_0), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0080_0), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0090_0), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0098_0), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a0_0), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a8_0), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b0_0), 0x00b0, 6, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b8_0), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b9_0), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_00d0_0), 0x00d0, 4, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_00e8_0), 0x00e8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_00f0_0), 0x00f0, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_00f8_0), 0x00f8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_00f9_0), 0x00f9, 8, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_00fa_0), 0x00fa, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_00fb_0), 0x00fb, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
{ CPUFUNC(op_0100_0), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0108_0), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0110_0), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0118_0), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0120_0), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0128_0), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0130_0), 0x0130, 2, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0138_0), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0139_0), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013a_0), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013b_0), 0x013b, 2, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013c_0), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0140_0), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0148_0), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0150_0), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0158_0), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0160_0), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0168_0), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0170_0), 0x0170, 2, { 2, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0178_0), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0179_0), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0180_0), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0188_0), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_0190_0), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0198_0), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a0_0), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a8_0), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b0_0), 0x01b0, 2, { 2, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b8_0), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b9_0), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01c0_0), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01c8_0), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_01d0_0), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01d8_0), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e0_0), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e8_0), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f0_0), 0x01f0, 2, { 2, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f8_0), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f9_0), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0200_0), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0210_0), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0218_0), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0220_0), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0228_0), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0230_0), 0x0230, 4, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0238_0), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0239_0), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_023c_0), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0240_0), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0250_0), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0258_0), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0260_0), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0268_0), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0270_0), 0x0270, 4, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0278_0), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0279_0), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_027c_0), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0280_0), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0290_0), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0298_0), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a0_0), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a8_0), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b0_0), 0x02b0, 6, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b8_0), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b9_0), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_02d0_0), 0x02d0, 4, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_02e8_0), 0x02e8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_02f0_0), 0x02f0, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_02f8_0), 0x02f8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_02f9_0), 0x02f9, 8, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_02fa_0), 0x02fa, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_02fb_0), 0x02fb, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
{ CPUFUNC(op_0400_0), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0410_0), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0418_0), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0420_0), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0428_0), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0430_0), 0x0430, 4, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0438_0), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0439_0), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0440_0), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0450_0), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0458_0), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0460_0), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0468_0), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0470_0), 0x0470, 4, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0478_0), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0479_0), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0480_0), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0490_0), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0498_0), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a0_0), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a8_0), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b0_0), 0x04b0, 6, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b8_0), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b9_0), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_04d0_0), 0x04d0, 4, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_04e8_0), 0x04e8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_04f0_0), 0x04f0, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_04f8_0), 0x04f8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_04f9_0), 0x04f9, 8, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_04fa_0), 0x04fa, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_04fb_0), 0x04fb, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
{ CPUFUNC(op_0600_0), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0610_0), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0618_0), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0620_0), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0628_0), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0630_0), 0x0630, 4, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0638_0), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0639_0), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0640_0), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0650_0), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0658_0), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0660_0), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0668_0), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0670_0), 0x0670, 4, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0678_0), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0679_0), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0680_0), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0690_0), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0698_0), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a0_0), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a8_0), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b0_0), 0x06b0, 6, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b8_0), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b9_0), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06c0_0), 0x06c0, 2, { 0, 0 }, 0 }, /* RTM */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06c8_0), 0x06c8, 2, { 0, 0 }, 0 }, /* RTM */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06d0_0), 0x06d0, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06e8_0), 0x06e8, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06f0_0), 0x06f0, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06f8_0), 0x06f8, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06f9_0), 0x06f9, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06fa_0), 0x06fa, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_06fb_0), 0x06fb, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
{ CPUFUNC(op_0800_0), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0810_0), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0818_0), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0820_0), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0828_0), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0830_0), 0x0830, 4, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0838_0), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0839_0), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083a_0), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083b_0), 0x083b, 4, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0840_0), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0850_0), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0858_0), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0860_0), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0868_0), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0870_0), 0x0870, 4, { 2, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0878_0), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0879_0), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0880_0), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0890_0), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0898_0), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a0_0), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a8_0), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b0_0), 0x08b0, 4, { 2, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b8_0), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b9_0), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08c0_0), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d0_0), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d8_0), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e0_0), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e8_0), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f0_0), 0x08f0, 4, { 2, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f8_0), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f9_0), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0a00_0), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a10_0), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a18_0), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a20_0), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a28_0), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a30_0), 0x0a30, 4, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a38_0), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a39_0), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a3c_0), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a40_0), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a50_0), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a58_0), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a60_0), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a68_0), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a70_0), 0x0a70, 4, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a78_0), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a79_0), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a7c_0), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a80_0), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a90_0), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a98_0), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa0_0), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa8_0), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab0_0), 0x0ab0, 6, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab8_0), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab9_0), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ad0_0), 0x0ad0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ad8_0), 0x0ad8, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ae0_0), 0x0ae0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ae8_0), 0x0ae8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0af0_0), 0x0af0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0af8_0), 0x0af8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0af9_0), 0x0af9, 8, { 0, 0 }, 0 }, /* CAS */
#endif
{ CPUFUNC(op_0c00_0), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c10_0), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c18_0), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c20_0), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c28_0), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c30_0), 0x0c30, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c38_0), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c39_0), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0c3a_0), 0x0c3a, 6, { 0, 0 }, 0 }, /* CMP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0c3b_0), 0x0c3b, 4, { 2, 0 }, 0 }, /* CMP */
#endif
{ CPUFUNC(op_0c40_0), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c50_0), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c58_0), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c60_0), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c68_0), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c70_0), 0x0c70, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c78_0), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c79_0), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0c7a_0), 0x0c7a, 6, { 0, 0 }, 0 }, /* CMP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0c7b_0), 0x0c7b, 4, { 2, 0 }, 0 }, /* CMP */
#endif
{ CPUFUNC(op_0c80_0), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c90_0), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c98_0), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca0_0), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca8_0), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb0_0), 0x0cb0, 6, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb8_0), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb9_0), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0cba_0), 0x0cba, 8, { 0, 0 }, 0 }, /* CMP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0cbb_0), 0x0cbb, 6, { 2, 0 }, 0 }, /* CMP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0cd0_0), 0x0cd0, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0cd8_0), 0x0cd8, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ce0_0), 0x0ce0, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ce8_0), 0x0ce8, 12, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0cf0_0), 0x0cf0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0cf8_0), 0x0cf8, 12, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0cf9_0), 0x0cf9, 16, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0cfc_0), 0x0cfc, 6, { 0, 0 }, 0 }, /* CAS2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e10_0), 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e18_0), 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e20_0), 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e28_0), 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e30_0), 0x0e30, 8, { 6, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e38_0), 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e39_0), 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e50_0), 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e58_0), 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e60_0), 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e68_0), 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e70_0), 0x0e70, 8, { 6, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e78_0), 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e79_0), 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e90_0), 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0e98_0), 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ea0_0), 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ea8_0), 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0eb0_0), 0x0eb0, 8, { 6, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0eb8_0), 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0eb9_0), 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ed0_0), 0x0ed0, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ed8_0), 0x0ed8, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ee0_0), 0x0ee0, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ee8_0), 0x0ee8, 12, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ef0_0), 0x0ef0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ef8_0), 0x0ef8, 12, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0ef9_0), 0x0ef9, 16, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_0efc_0), 0x0efc, 6, { 0, 0 }, 0 }, /* CAS2 */
#endif
{ CPUFUNC(op_1000_0), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1010_0), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1018_0), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1020_0), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1028_0), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1030_0), 0x1030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1038_0), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1039_0), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103a_0), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103b_0), 0x103b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103c_0), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1080_0), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1090_0), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1098_0), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a0_0), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a8_0), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b0_0), 0x10b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b8_0), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b9_0), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10ba_0), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bb_0), 0x10bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bc_0), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10c0_0), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d0_0), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d8_0), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e0_0), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e8_0), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f0_0), 0x10f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f8_0), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f9_0), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fa_0), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fb_0), 0x10fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fc_0), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1100_0), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1110_0), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1118_0), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1120_0), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1128_0), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1130_0), 0x1130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1138_0), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1139_0), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113a_0), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113b_0), 0x113b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113c_0), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1140_0), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1150_0), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1158_0), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1160_0), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1168_0), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1170_0), 0x1170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1178_0), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1179_0), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117a_0), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117b_0), 0x117b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117c_0), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1180_0), 0x1180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1190_0), 0x1190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1198_0), 0x1198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a0_0), 0x11a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a8_0), 0x11a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b0_0), 0x11b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b8_0), 0x11b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b9_0), 0x11b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11ba_0), 0x11ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bb_0), 0x11bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bc_0), 0x11bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11c0_0), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d0_0), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d8_0), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e0_0), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e8_0), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f0_0), 0x11f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f8_0), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f9_0), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fa_0), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fb_0), 0x11fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fc_0), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13c0_0), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d0_0), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d8_0), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e0_0), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e8_0), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f0_0), 0x13f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f8_0), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f9_0), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fa_0), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fb_0), 0x13fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fc_0), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2000_0), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2008_0), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2010_0), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2018_0), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2020_0), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2028_0), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2030_0), 0x2030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2038_0), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2039_0), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203a_0), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203b_0), 0x203b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203c_0), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2040_0), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2048_0), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2050_0), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2058_0), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2060_0), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2068_0), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2070_0), 0x2070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2078_0), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2079_0), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207a_0), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207b_0), 0x207b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207c_0), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2080_0), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2088_0), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2090_0), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2098_0), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a0_0), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a8_0), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b0_0), 0x20b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b8_0), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b9_0), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20ba_0), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bb_0), 0x20bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bc_0), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c0_0), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c8_0), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d0_0), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d8_0), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e0_0), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e8_0), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f0_0), 0x20f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f8_0), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f9_0), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fa_0), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fb_0), 0x20fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fc_0), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2100_0), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2108_0), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2110_0), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2118_0), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2120_0), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2128_0), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2130_0), 0x2130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2138_0), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2139_0), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213a_0), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213b_0), 0x213b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213c_0), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2140_0), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2148_0), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2150_0), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2158_0), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2160_0), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2168_0), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2170_0), 0x2170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2178_0), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2179_0), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217a_0), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217b_0), 0x217b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217c_0), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2180_0), 0x2180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2188_0), 0x2188, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2190_0), 0x2190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2198_0), 0x2198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a0_0), 0x21a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a8_0), 0x21a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b0_0), 0x21b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b8_0), 0x21b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b9_0), 0x21b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21ba_0), 0x21ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bb_0), 0x21bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bc_0), 0x21bc, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c0_0), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c8_0), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d0_0), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d8_0), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e0_0), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e8_0), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f0_0), 0x21f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f8_0), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f9_0), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fa_0), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fb_0), 0x21fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fc_0), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c0_0), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c8_0), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d0_0), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d8_0), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e0_0), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e8_0), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f0_0), 0x23f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f8_0), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f9_0), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fa_0), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fb_0), 0x23fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fc_0), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3000_0), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3008_0), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3010_0), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3018_0), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3020_0), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3028_0), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3030_0), 0x3030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3038_0), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3039_0), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303a_0), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303b_0), 0x303b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303c_0), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3040_0), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3048_0), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3050_0), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3058_0), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3060_0), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3068_0), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3070_0), 0x3070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3078_0), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3079_0), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307a_0), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307b_0), 0x307b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307c_0), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3080_0), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3088_0), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3090_0), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3098_0), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a0_0), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a8_0), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b0_0), 0x30b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b8_0), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b9_0), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30ba_0), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bb_0), 0x30bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bc_0), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c0_0), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c8_0), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d0_0), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d8_0), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e0_0), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e8_0), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f0_0), 0x30f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f8_0), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f9_0), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fa_0), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fb_0), 0x30fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fc_0), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3100_0), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3108_0), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3110_0), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3118_0), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3120_0), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3128_0), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3130_0), 0x3130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3138_0), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3139_0), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313a_0), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313b_0), 0x313b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313c_0), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3140_0), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3148_0), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3150_0), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3158_0), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3160_0), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3168_0), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3170_0), 0x3170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3178_0), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3179_0), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317a_0), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317b_0), 0x317b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317c_0), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3180_0), 0x3180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3188_0), 0x3188, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3190_0), 0x3190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3198_0), 0x3198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a0_0), 0x31a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a8_0), 0x31a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b0_0), 0x31b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b8_0), 0x31b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b9_0), 0x31b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31ba_0), 0x31ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bb_0), 0x31bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bc_0), 0x31bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c0_0), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c8_0), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d0_0), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d8_0), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e0_0), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e8_0), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f0_0), 0x31f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f8_0), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f9_0), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fa_0), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fb_0), 0x31fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fc_0), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c0_0), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c8_0), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d0_0), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d8_0), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e0_0), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e8_0), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f0_0), 0x33f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f8_0), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f9_0), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fa_0), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fb_0), 0x33fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fc_0), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_4000_0), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4010_0), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4018_0), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4020_0), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4028_0), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4030_0), 0x4030, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4038_0), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4039_0), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4040_0), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4050_0), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4058_0), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4060_0), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4068_0), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4070_0), 0x4070, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4078_0), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4079_0), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4080_0), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4090_0), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4098_0), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a0_0), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a8_0), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b0_0), 0x40b0, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b8_0), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b9_0), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40c0_0), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d0_0), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d8_0), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e0_0), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e8_0), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f0_0), 0x40f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f8_0), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f9_0), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4100_0), 0x4100, 2, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4110_0), 0x4110, 2, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4118_0), 0x4118, 2, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4120_0), 0x4120, 2, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4128_0), 0x4128, 4, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4130_0), 0x4130, 2, { 2, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4138_0), 0x4138, 4, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4139_0), 0x4139, 6, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_413a_0), 0x413a, 4, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_413b_0), 0x413b, 2, { 2, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_413c_0), 0x413c, 6, { 0, 0 }, 0 }, /* CHK */
#endif
{ CPUFUNC(op_4180_0), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4190_0), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4198_0), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a0_0), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a8_0), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b0_0), 0x41b0, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b8_0), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b9_0), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41ba_0), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bb_0), 0x41bb, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bc_0), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41d0_0), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41e8_0), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f0_0), 0x41f0, 2, { 2, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f8_0), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f9_0), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fa_0), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fb_0), 0x41fb, 2, { 2, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_4200_0), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4210_0), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4218_0), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4220_0), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4228_0), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4230_0), 0x4230, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4238_0), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4239_0), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4240_0), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4250_0), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4258_0), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4260_0), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4268_0), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4270_0), 0x4270, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4278_0), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4279_0), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4280_0), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4290_0), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4298_0), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a0_0), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a8_0), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b0_0), 0x42b0, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b8_0), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b9_0), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42c0_0), 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42d0_0), 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42d8_0), 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42e0_0), 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42e8_0), 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42f0_0), 0x42f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42f8_0), 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42f9_0), 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
#endif
{ CPUFUNC(op_4400_0), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4410_0), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4418_0), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4420_0), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4428_0), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4430_0), 0x4430, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4438_0), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4439_0), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4440_0), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4450_0), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4458_0), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4460_0), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4468_0), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4470_0), 0x4470, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4478_0), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4479_0), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4480_0), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4490_0), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4498_0), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a0_0), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a8_0), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b0_0), 0x44b0, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b8_0), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b9_0), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44c0_0), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d0_0), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d8_0), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e0_0), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e8_0), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f0_0), 0x44f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f8_0), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f9_0), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fa_0), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fb_0), 0x44fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fc_0), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4600_0), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4610_0), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4618_0), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4620_0), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4628_0), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4630_0), 0x4630, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4638_0), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4639_0), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4640_0), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4650_0), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4658_0), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4660_0), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4668_0), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4670_0), 0x4670, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4678_0), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4679_0), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4680_0), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4690_0), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4698_0), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a0_0), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a8_0), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b0_0), 0x46b0, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b8_0), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b9_0), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46c0_0), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d0_0), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d8_0), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e0_0), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e8_0), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f0_0), 0x46f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f8_0), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f9_0), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fa_0), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fb_0), 0x46fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fc_0), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4800_0), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4808_0), 0x4808, 6, { 0, 0 }, 0 }, /* LINK */
#endif
{ CPUFUNC(op_4810_0), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4818_0), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4820_0), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4828_0), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4830_0), 0x4830, 2, { 2, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4838_0), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4839_0), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4840_0), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4848_0), 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
#endif
{ CPUFUNC(op_4850_0), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4868_0), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4870_0), 0x4870, 2, { 2, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4878_0), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4879_0), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487a_0), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487b_0), 0x487b, 2, { 2, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4880_0), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4890_0), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a0_0), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a8_0), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b0_0), 0x48b0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b8_0), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b9_0), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48c0_0), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_48d0_0), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e0_0), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e8_0), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f0_0), 0x48f0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f8_0), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f9_0), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_49c0_0), 0x49c0, 2, { 0, 0 }, 0 }, /* EXT */
#endif
{ CPUFUNC(op_4a00_0), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a10_0), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a18_0), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a20_0), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a28_0), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a30_0), 0x4a30, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a38_0), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a39_0), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4a3a_0), 0x4a3a, 4, { 0, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4a3b_0), 0x4a3b, 2, { 2, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4a3c_0), 0x4a3c, 4, { 0, 0 }, 0 }, /* TST */
#endif
{ CPUFUNC(op_4a40_0), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4a48_0), 0x4a48, 2, { 0, 0 }, 0 }, /* TST */
#endif
{ CPUFUNC(op_4a50_0), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a58_0), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a60_0), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a68_0), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a70_0), 0x4a70, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a78_0), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a79_0), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4a7a_0), 0x4a7a, 4, { 0, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4a7b_0), 0x4a7b, 2, { 2, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4a7c_0), 0x4a7c, 4, { 0, 0 }, 0 }, /* TST */
#endif
{ CPUFUNC(op_4a80_0), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4a88_0), 0x4a88, 2, { 0, 0 }, 0 }, /* TST */
#endif
{ CPUFUNC(op_4a90_0), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a98_0), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa0_0), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa8_0), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab0_0), 0x4ab0, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab8_0), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab9_0), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4aba_0), 0x4aba, 4, { 0, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4abb_0), 0x4abb, 2, { 2, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4abc_0), 0x4abc, 6, { 0, 0 }, 0 }, /* TST */
#endif
{ CPUFUNC(op_4ac0_0), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad0_0), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad8_0), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae0_0), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae8_0), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af0_0), 0x4af0, 2, { 2, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af8_0), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af9_0), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c00_0), 0x4c00, 4, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c10_0), 0x4c10, 4, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c18_0), 0x4c18, 4, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c20_0), 0x4c20, 4, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c28_0), 0x4c28, 6, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c30_0), 0x4c30, 4, { 2, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c38_0), 0x4c38, 6, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c39_0), 0x4c39, 8, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c3a_0), 0x4c3a, 6, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c3b_0), 0x4c3b, 4, { 2, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c3c_0), 0x4c3c, 8, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c40_0), 0x4c40, 4, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c50_0), 0x4c50, 4, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c58_0), 0x4c58, 4, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c60_0), 0x4c60, 4, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c68_0), 0x4c68, 6, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c70_0), 0x4c70, 4, { 2, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c78_0), 0x4c78, 6, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c79_0), 0x4c79, 8, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c7a_0), 0x4c7a, 6, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c7b_0), 0x4c7b, 4, { 2, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4c7c_0), 0x4c7c, 8, { 0, 0 }, 0 }, /* DIVL */
#endif
{ CPUFUNC(op_4c90_0), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4c98_0), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ca8_0), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb0_0), 0x4cb0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb8_0), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb9_0), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cba_0), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cbb_0), 0x4cbb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd0_0), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd8_0), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ce8_0), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf0_0), 0x4cf0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf8_0), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf9_0), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfa_0), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfb_0), 0x4cfb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4e40_0), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ CPUFUNC(op_4e50_0), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4e58_0), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ CPUFUNC(op_4e60_0), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ CPUFUNC(op_4e68_0), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ CPUFUNC(op_4e70_0), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ CPUFUNC(op_4e71_0), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ CPUFUNC(op_4e72_0), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ CPUFUNC(op_4e73_0), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4e74_0), 0x4e74, 4, { 0, 0 }, 1 }, /* RTD */
#endif
{ CPUFUNC(op_4e75_0), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ CPUFUNC(op_4e76_0), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ CPUFUNC(op_4e77_0), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4e7a_0), 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4e7b_0), 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
#endif
{ CPUFUNC(op_4e90_0), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ea8_0), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb0_0), 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb8_0), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb9_0), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eba_0), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ebb_0), 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ed0_0), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ee8_0), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef0_0), 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef8_0), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef9_0), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efa_0), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efb_0), 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_5000_0), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5010_0), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5018_0), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5020_0), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5028_0), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5030_0), 0x5030, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5038_0), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5039_0), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5040_0), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5048_0), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5050_0), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5058_0), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5060_0), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5068_0), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5070_0), 0x5070, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5078_0), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5079_0), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5080_0), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5088_0), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5090_0), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5098_0), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a0_0), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a8_0), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b0_0), 0x50b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b8_0), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b9_0), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50c0_0), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50c8_0), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_50d0_0), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50d8_0), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e0_0), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e8_0), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f0_0), 0x50f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f8_0), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f9_0), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_50fa_0), 0x50fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_50fb_0), 0x50fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_50fc_0), 0x50fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_5100_0), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5110_0), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5118_0), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5120_0), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5128_0), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5130_0), 0x5130, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5138_0), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5139_0), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5140_0), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5148_0), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5150_0), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5158_0), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5160_0), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5168_0), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5170_0), 0x5170, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5178_0), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5179_0), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5180_0), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5188_0), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5190_0), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5198_0), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a0_0), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a8_0), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b0_0), 0x51b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b8_0), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b9_0), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51c0_0), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51c8_0), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_51d0_0), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51d8_0), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e0_0), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e8_0), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f0_0), 0x51f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f8_0), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f9_0), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_51fa_0), 0x51fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_51fb_0), 0x51fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_51fc_0), 0x51fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_52c0_0), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c8_0), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_52d0_0), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52d8_0), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e0_0), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e8_0), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f0_0), 0x52f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f8_0), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f9_0), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_52fa_0), 0x52fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_52fb_0), 0x52fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_52fc_0), 0x52fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_53c0_0), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c8_0), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_53d0_0), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53d8_0), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e0_0), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e8_0), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f0_0), 0x53f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f8_0), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f9_0), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_53fa_0), 0x53fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_53fb_0), 0x53fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_53fc_0), 0x53fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_54c0_0), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c8_0), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_54d0_0), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54d8_0), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e0_0), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e8_0), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f0_0), 0x54f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f8_0), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f9_0), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_54fa_0), 0x54fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_54fb_0), 0x54fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_54fc_0), 0x54fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_55c0_0), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c8_0), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_55d0_0), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55d8_0), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e0_0), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e8_0), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f0_0), 0x55f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f8_0), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f9_0), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_55fa_0), 0x55fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_55fb_0), 0x55fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_55fc_0), 0x55fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_56c0_0), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c8_0), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_56d0_0), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56d8_0), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e0_0), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e8_0), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f0_0), 0x56f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f8_0), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f9_0), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_56fa_0), 0x56fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_56fb_0), 0x56fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_56fc_0), 0x56fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_57c0_0), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c8_0), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_57d0_0), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57d8_0), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e0_0), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e8_0), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f0_0), 0x57f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f8_0), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f9_0), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_57fa_0), 0x57fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_57fb_0), 0x57fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_57fc_0), 0x57fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_58c0_0), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c8_0), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_58d0_0), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58d8_0), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e0_0), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e8_0), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f0_0), 0x58f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f8_0), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f9_0), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_58fa_0), 0x58fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_58fb_0), 0x58fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_58fc_0), 0x58fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_59c0_0), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c8_0), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_59d0_0), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59d8_0), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e0_0), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e8_0), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f0_0), 0x59f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f8_0), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f9_0), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_59fa_0), 0x59fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_59fb_0), 0x59fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_59fc_0), 0x59fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_5ac0_0), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac8_0), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ad0_0), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ad8_0), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae0_0), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae8_0), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af0_0), 0x5af0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af8_0), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af9_0), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5afa_0), 0x5afa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5afb_0), 0x5afb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5afc_0), 0x5afc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_5bc0_0), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc8_0), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5bd0_0), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bd8_0), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be0_0), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be8_0), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf0_0), 0x5bf0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf8_0), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf9_0), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5bfa_0), 0x5bfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5bfb_0), 0x5bfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5bfc_0), 0x5bfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_5cc0_0), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc8_0), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5cd0_0), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cd8_0), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce0_0), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce8_0), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf0_0), 0x5cf0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf8_0), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf9_0), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5cfa_0), 0x5cfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5cfb_0), 0x5cfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5cfc_0), 0x5cfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_5dc0_0), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc8_0), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5dd0_0), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dd8_0), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de0_0), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de8_0), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df0_0), 0x5df0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df8_0), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df9_0), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5dfa_0), 0x5dfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5dfb_0), 0x5dfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5dfc_0), 0x5dfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_5ec0_0), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec8_0), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ed0_0), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ed8_0), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee0_0), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee8_0), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef0_0), 0x5ef0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef8_0), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef9_0), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5efa_0), 0x5efa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5efb_0), 0x5efb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5efc_0), 0x5efc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_5fc0_0), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc8_0), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5fd0_0), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fd8_0), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe0_0), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe8_0), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff0_0), 0x5ff0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff8_0), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff9_0), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5ffa_0), 0x5ffa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5ffb_0), 0x5ffb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_5ffc_0), 0x5ffc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ CPUFUNC(op_6000_0), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6001_0), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_60ff_0), 0x60ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6100_0), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6101_0), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_61ff_0), 0x61ff, 6, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6200_0), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6201_0), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_62ff_0), 0x62ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6300_0), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6301_0), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_63ff_0), 0x63ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6400_0), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6401_0), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_64ff_0), 0x64ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6500_0), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6501_0), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_65ff_0), 0x65ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6600_0), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6601_0), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_66ff_0), 0x66ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6700_0), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6701_0), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_67ff_0), 0x67ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6800_0), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6801_0), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_68ff_0), 0x68ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6900_0), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6901_0), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_69ff_0), 0x69ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a00_0), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a01_0), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6aff_0), 0x6aff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b00_0), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b01_0), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6bff_0), 0x6bff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c00_0), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c01_0), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6cff_0), 0x6cff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d00_0), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d01_0), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6dff_0), 0x6dff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e00_0), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e01_0), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6eff_0), 0x6eff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f00_0), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f01_0), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6fff_0), 0x6fff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_7000_0), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_8000_0), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8010_0), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8018_0), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8020_0), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8028_0), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8030_0), 0x8030, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8038_0), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8039_0), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803a_0), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803b_0), 0x803b, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803c_0), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8040_0), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8050_0), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8058_0), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8060_0), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8068_0), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8070_0), 0x8070, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8078_0), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8079_0), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807a_0), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807b_0), 0x807b, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807c_0), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8080_0), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8090_0), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8098_0), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a0_0), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a8_0), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b0_0), 0x80b0, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b8_0), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b9_0), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80ba_0), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bb_0), 0x80bb, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bc_0), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80c0_0), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d0_0), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d8_0), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e0_0), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e8_0), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f0_0), 0x80f0, 2, { 2, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f8_0), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f9_0), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fa_0), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fb_0), 0x80fb, 2, { 2, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fc_0), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_8100_0), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8108_0), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8110_0), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8118_0), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8120_0), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8128_0), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8130_0), 0x8130, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8138_0), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8139_0), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_8140_0), 0x8140, 4, { 0, 0 }, 0 }, /* PACK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_8148_0), 0x8148, 4, { 0, 0 }, 0 }, /* PACK */
#endif
{ CPUFUNC(op_8150_0), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8158_0), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8160_0), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8168_0), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8170_0), 0x8170, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8178_0), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8179_0), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_8180_0), 0x8180, 4, { 0, 0 }, 0 }, /* UNPK */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_8188_0), 0x8188, 4, { 0, 0 }, 0 }, /* UNPK */
#endif
{ CPUFUNC(op_8190_0), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8198_0), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a0_0), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a8_0), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b0_0), 0x81b0, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b8_0), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b9_0), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81c0_0), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d0_0), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d8_0), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e0_0), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e8_0), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f0_0), 0x81f0, 2, { 2, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f8_0), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f9_0), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fa_0), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fb_0), 0x81fb, 2, { 2, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fc_0), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_9000_0), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9010_0), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9018_0), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9020_0), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9028_0), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9030_0), 0x9030, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9038_0), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9039_0), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903a_0), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903b_0), 0x903b, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903c_0), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9040_0), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9048_0), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9050_0), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9058_0), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9060_0), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9068_0), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9070_0), 0x9070, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9078_0), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9079_0), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907a_0), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907b_0), 0x907b, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907c_0), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9080_0), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9088_0), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9090_0), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9098_0), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a0_0), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a8_0), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b0_0), 0x90b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b8_0), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b9_0), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90ba_0), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bb_0), 0x90bb, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bc_0), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90c0_0), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90c8_0), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d0_0), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d8_0), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e0_0), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e8_0), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f0_0), 0x90f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f8_0), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f9_0), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fa_0), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fb_0), 0x90fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fc_0), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_9100_0), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9108_0), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9110_0), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9118_0), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9120_0), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9128_0), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9130_0), 0x9130, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9138_0), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9139_0), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9140_0), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9148_0), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9150_0), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9158_0), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9160_0), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9168_0), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9170_0), 0x9170, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9178_0), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9179_0), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9180_0), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9188_0), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9190_0), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9198_0), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a0_0), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a8_0), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b0_0), 0x91b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b8_0), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b9_0), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91c0_0), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91c8_0), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d0_0), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d8_0), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e0_0), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e8_0), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f0_0), 0x91f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f8_0), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f9_0), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fa_0), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fb_0), 0x91fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fc_0), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_b000_0), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b010_0), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b018_0), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b020_0), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b028_0), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b030_0), 0xb030, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b038_0), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b039_0), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03a_0), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03b_0), 0xb03b, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03c_0), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b040_0), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b048_0), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b050_0), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b058_0), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b060_0), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b068_0), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b070_0), 0xb070, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b078_0), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b079_0), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07a_0), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07b_0), 0xb07b, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07c_0), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b080_0), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b088_0), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b090_0), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b098_0), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a0_0), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a8_0), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b0_0), 0xb0b0, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b8_0), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b9_0), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0ba_0), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bb_0), 0xb0bb, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bc_0), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0c0_0), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0c8_0), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d0_0), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d8_0), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e0_0), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e8_0), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f0_0), 0xb0f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f8_0), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f9_0), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fa_0), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fb_0), 0xb0fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fc_0), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b100_0), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b108_0), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b110_0), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b118_0), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b120_0), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b128_0), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b130_0), 0xb130, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b138_0), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b139_0), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b140_0), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b148_0), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b150_0), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b158_0), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b160_0), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b168_0), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b170_0), 0xb170, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b178_0), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b179_0), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b180_0), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b188_0), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b190_0), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b198_0), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a0_0), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a8_0), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b0_0), 0xb1b0, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b8_0), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b9_0), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1c0_0), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1c8_0), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d0_0), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d8_0), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e0_0), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e8_0), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f0_0), 0xb1f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f8_0), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f9_0), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fa_0), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fb_0), 0xb1fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fc_0), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_c000_0), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c010_0), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c018_0), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c020_0), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c028_0), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c030_0), 0xc030, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c038_0), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c039_0), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03a_0), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03b_0), 0xc03b, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03c_0), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c040_0), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c050_0), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c058_0), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c060_0), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c068_0), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c070_0), 0xc070, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c078_0), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c079_0), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07a_0), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07b_0), 0xc07b, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07c_0), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c080_0), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c090_0), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c098_0), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a0_0), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a8_0), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b0_0), 0xc0b0, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b8_0), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b9_0), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0ba_0), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bb_0), 0xc0bb, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bc_0), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0c0_0), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d0_0), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d8_0), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e0_0), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e8_0), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f0_0), 0xc0f0, 2, { 2, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f8_0), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f9_0), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fa_0), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fb_0), 0xc0fb, 2, { 2, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fc_0), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c100_0), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c108_0), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c110_0), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c118_0), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c120_0), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c128_0), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c130_0), 0xc130, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c138_0), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c139_0), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c140_0), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c148_0), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c150_0), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c158_0), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c160_0), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c168_0), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c170_0), 0xc170, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c178_0), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c179_0), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c188_0), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c190_0), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c198_0), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a0_0), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a8_0), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b0_0), 0xc1b0, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b8_0), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b9_0), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1c0_0), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d0_0), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d8_0), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e0_0), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e8_0), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f0_0), 0xc1f0, 2, { 2, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f8_0), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f9_0), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fa_0), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fb_0), 0xc1fb, 2, { 2, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fc_0), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_d000_0), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d010_0), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d018_0), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d020_0), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d028_0), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d030_0), 0xd030, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d038_0), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d039_0), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03a_0), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03b_0), 0xd03b, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03c_0), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d040_0), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d048_0), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d050_0), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d058_0), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d060_0), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d068_0), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d070_0), 0xd070, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d078_0), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d079_0), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07a_0), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07b_0), 0xd07b, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07c_0), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d080_0), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d088_0), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d090_0), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d098_0), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a0_0), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a8_0), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b0_0), 0xd0b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b8_0), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b9_0), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0ba_0), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bb_0), 0xd0bb, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bc_0), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0c0_0), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0c8_0), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d0_0), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d8_0), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e0_0), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e8_0), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f0_0), 0xd0f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f8_0), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f9_0), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fa_0), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fb_0), 0xd0fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fc_0), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d100_0), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d108_0), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d110_0), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d118_0), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d120_0), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d128_0), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d130_0), 0xd130, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d138_0), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d139_0), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d140_0), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d148_0), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d150_0), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d158_0), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d160_0), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d168_0), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d170_0), 0xd170, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d178_0), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d179_0), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d180_0), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d188_0), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d190_0), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d198_0), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a0_0), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a8_0), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b0_0), 0xd1b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b8_0), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b9_0), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1c0_0), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1c8_0), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d0_0), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d8_0), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e0_0), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e8_0), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f0_0), 0xd1f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f8_0), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f9_0), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fa_0), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fb_0), 0xd1fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fc_0), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_e000_0), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e008_0), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e010_0), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e018_0), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e020_0), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e028_0), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e030_0), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e038_0), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e040_0), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e048_0), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e050_0), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e058_0), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e060_0), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e068_0), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e070_0), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e078_0), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e080_0), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e088_0), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e090_0), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e098_0), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0a0_0), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e0a8_0), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e0b0_0), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e0b8_0), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0d0_0), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0d8_0), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e0_0), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e8_0), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f0_0), 0xe0f0, 2, { 2, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f8_0), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f9_0), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e100_0), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e108_0), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e110_0), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e118_0), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e120_0), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e128_0), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e130_0), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e138_0), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e140_0), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e148_0), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e150_0), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e158_0), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e160_0), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e168_0), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e170_0), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e178_0), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e180_0), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e188_0), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e190_0), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e198_0), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1a0_0), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e1a8_0), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e1b0_0), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e1b8_0), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1d0_0), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1d8_0), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e0_0), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e8_0), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f0_0), 0xe1f0, 2, { 2, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f8_0), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f9_0), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e2d0_0), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2d8_0), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e0_0), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e8_0), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f0_0), 0xe2f0, 2, { 2, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f8_0), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f9_0), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e3d0_0), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3d8_0), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e0_0), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e8_0), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f0_0), 0xe3f0, 2, { 2, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f8_0), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f9_0), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e4d0_0), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4d8_0), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e0_0), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e8_0), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f0_0), 0xe4f0, 2, { 2, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f8_0), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f9_0), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e5d0_0), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5d8_0), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e0_0), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e8_0), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f0_0), 0xe5f0, 2, { 2, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f8_0), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f9_0), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e6d0_0), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6d8_0), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e0_0), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e8_0), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f0_0), 0xe6f0, 2, { 2, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f8_0), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f9_0), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e7d0_0), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7d8_0), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e0_0), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e8_0), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f0_0), 0xe7f0, 2, { 2, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f8_0), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f9_0), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e8c0_0), 0xe8c0, 4, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e8d0_0), 0xe8d0, 4, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e8e8_0), 0xe8e8, 6, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e8f0_0), 0xe8f0, 4, { 2, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e8f8_0), 0xe8f8, 6, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e8f9_0), 0xe8f9, 8, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e8fa_0), 0xe8fa, 6, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e8fb_0), 0xe8fb, 4, { 2, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e9c0_0), 0xe9c0, 4, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e9d0_0), 0xe9d0, 4, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e9e8_0), 0xe9e8, 6, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e9f0_0), 0xe9f0, 4, { 2, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e9f8_0), 0xe9f8, 6, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e9f9_0), 0xe9f9, 8, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e9fa_0), 0xe9fa, 6, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_e9fb_0), 0xe9fb, 4, { 2, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eac0_0), 0xeac0, 4, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ead0_0), 0xead0, 4, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eae8_0), 0xeae8, 6, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eaf0_0), 0xeaf0, 4, { 2, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eaf8_0), 0xeaf8, 6, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eaf9_0), 0xeaf9, 8, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ebc0_0), 0xebc0, 4, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ebd0_0), 0xebd0, 4, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ebe8_0), 0xebe8, 6, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ebf0_0), 0xebf0, 4, { 2, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ebf8_0), 0xebf8, 6, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ebf9_0), 0xebf9, 8, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ebfa_0), 0xebfa, 6, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ebfb_0), 0xebfb, 4, { 2, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ecc0_0), 0xecc0, 4, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ecd0_0), 0xecd0, 4, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ece8_0), 0xece8, 6, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ecf0_0), 0xecf0, 4, { 2, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ecf8_0), 0xecf8, 6, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ecf9_0), 0xecf9, 8, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_edc0_0), 0xedc0, 4, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_edd0_0), 0xedd0, 4, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_ede8_0), 0xede8, 6, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_edf0_0), 0xedf0, 4, { 2, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_edf8_0), 0xedf8, 6, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_edf9_0), 0xedf9, 8, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_edfa_0), 0xedfa, 6, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_edfb_0), 0xedfb, 4, { 2, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eec0_0), 0xeec0, 4, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eed0_0), 0xeed0, 4, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eee8_0), 0xeee8, 6, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eef0_0), 0xeef0, 4, { 2, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eef8_0), 0xeef8, 6, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eef9_0), 0xeef9, 8, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_efc0_0), 0xefc0, 4, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_efd0_0), 0xefd0, 4, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_efe8_0), 0xefe8, 6, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eff0_0), 0xeff0, 4, { 2, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eff8_0), 0xeff8, 6, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_eff9_0), 0xeff9, 8, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f000_0), 0xf000, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f008_0), 0xf008, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f010_0), 0xf010, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f018_0), 0xf018, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f020_0), 0xf020, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f028_0), 0xf028, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f030_0), 0xf030, -1, { -3, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f038_0), 0xf038, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f039_0), 0xf039, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f200_0), 0xf200, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f208_0), 0xf208, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f210_0), 0xf210, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f218_0), 0xf218, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f220_0), 0xf220, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f228_0), 0xf228, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f230_0), 0xf230, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f238_0), 0xf238, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f239_0), 0xf239, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f23a_0), 0xf23a, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f23b_0), 0xf23b, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f23c_0), 0xf23c, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f240_0), 0xf240, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f248_0), 0xf248, -1, { 0, 0 }, 0 }, /* FDBcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f250_0), 0xf250, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f258_0), 0xf258, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f260_0), 0xf260, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f268_0), 0xf268, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f270_0), 0xf270, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f278_0), 0xf278, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f279_0), 0xf279, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f27a_0), 0xf27a, -1, { 0, 0 }, 0 }, /* FTRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f27b_0), 0xf27b, -1, { 0, 0 }, 0 }, /* FTRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f27c_0), 0xf27c, -1, { 0, 0 }, 0 }, /* FTRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f280_0), 0xf280, -1, { 0, 0 }, 0 }, /* FBcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f2c0_0), 0xf2c0, -1, { 0, 0 }, 0 }, /* FBcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f310_0), 0xf310, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f320_0), 0xf320, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f328_0), 0xf328, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f330_0), 0xf330, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f338_0), 0xf338, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f339_0), 0xf339, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f350_0), 0xf350, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f358_0), 0xf358, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f368_0), 0xf368, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f370_0), 0xf370, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f378_0), 0xf378, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f379_0), 0xf379, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f37a_0), 0xf37a, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f37b_0), 0xf37b, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f408_0), 0xf408, -1, { 0, 0 }, 0 }, /* CINVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f410_0), 0xf410, -1, { 0, 0 }, 0 }, /* CINVP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f418_0), 0xf418, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f419_0), 0xf419, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f41a_0), 0xf41a, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f41b_0), 0xf41b, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f41c_0), 0xf41c, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f41d_0), 0xf41d, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f41e_0), 0xf41e, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f41f_0), 0xf41f, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f428_0), 0xf428, -1, { 0, 0 }, 0 }, /* CPUSHL */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f430_0), 0xf430, -1, { 0, 0 }, 0 }, /* CPUSHP */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f438_0), 0xf438, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f439_0), 0xf439, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f43a_0), 0xf43a, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f43b_0), 0xf43b, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f43c_0), 0xf43c, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f43d_0), 0xf43d, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f43e_0), 0xf43e, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f43f_0), 0xf43f, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f500_0), 0xf500, -1, { 0, 0 }, 0 }, /* PFLUSHN */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f508_0), 0xf508, -1, { 0, 0 }, 0 }, /* PFLUSH */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f510_0), 0xf510, -1, { 0, 0 }, 0 }, /* PFLUSHAN */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f518_0), 0xf518, -1, { 0, 0 }, 0 }, /* PFLUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f548_0), 0xf548, -1, { 0, 0 }, 0 }, /* PTESTW */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f568_0), 0xf568, -1, { 0, 0 }, 0 }, /* PTESTR */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f588_0), 0xf588, -1, { 0, 0 }, 0 }, /* PLPAW */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f5c8_0), 0xf5c8, -1, { 0, 0 }, 0 }, /* PLPAR */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f600_0), 0xf600, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f608_0), 0xf608, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f610_0), 0xf610, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f618_0), 0xf618, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f620_0), 0xf620, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_f800_0), 0xf800, -1, { 0, 0 }, 0 }, /* LPSTOP */
#endif
{ 0, 0 }};
#endif /* CPUEMU_0 */
#ifdef CPUEMU_0
#ifndef CPUEMU_68000_ONLY
const struct cputbl CPUFUNC(op_smalltbl_1)[] = {
{ CPUFUNC(op_0000_0), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0010_0), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0018_0), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0020_0), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0028_0), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0030_0), 0x0030, 4, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0038_0), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0039_0), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_003c_0), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0040_0), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0050_0), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0058_0), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0060_0), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0068_0), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0070_0), 0x0070, 4, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0078_0), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0079_0), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_007c_0), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0080_0), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0090_0), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0098_0), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a0_0), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a8_0), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b0_0), 0x00b0, 6, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b8_0), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b9_0), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00d0_0), 0x00d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00e8_0), 0x00e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f0_0), 0x00f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f8_0), 0x00f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f9_0), 0x00f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00fa_0), 0x00fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00fb_0), 0x00fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0100_0), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0108_0), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0110_0), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0118_0), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0120_0), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0128_0), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0130_0), 0x0130, 2, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0138_0), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0139_0), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013a_0), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013b_0), 0x013b, 2, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013c_0), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0140_0), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0148_0), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0150_0), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0158_0), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0160_0), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0168_0), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0170_0), 0x0170, 2, { 2, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0178_0), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0179_0), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0180_0), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0188_0), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_0190_0), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0198_0), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a0_0), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a8_0), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b0_0), 0x01b0, 2, { 2, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b8_0), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b9_0), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01c0_0), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01c8_0), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_01d0_0), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01d8_0), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e0_0), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e8_0), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f0_0), 0x01f0, 2, { 2, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f8_0), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f9_0), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0200_0), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0210_0), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0218_0), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0220_0), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0228_0), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0230_0), 0x0230, 4, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0238_0), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0239_0), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_023c_0), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0240_0), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0250_0), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0258_0), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0260_0), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0268_0), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0270_0), 0x0270, 4, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0278_0), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0279_0), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_027c_0), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0280_0), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0290_0), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0298_0), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a0_0), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a8_0), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b0_0), 0x02b0, 6, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b8_0), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b9_0), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02d0_0), 0x02d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02e8_0), 0x02e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f0_0), 0x02f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f8_0), 0x02f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f9_0), 0x02f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02fa_0), 0x02fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02fb_0), 0x02fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0400_0), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0410_0), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0418_0), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0420_0), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0428_0), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0430_0), 0x0430, 4, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0438_0), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0439_0), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0440_0), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0450_0), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0458_0), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0460_0), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0468_0), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0470_0), 0x0470, 4, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0478_0), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0479_0), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0480_0), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0490_0), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0498_0), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a0_0), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a8_0), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b0_0), 0x04b0, 6, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b8_0), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b9_0), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04d0_0), 0x04d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04e8_0), 0x04e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f0_0), 0x04f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f8_0), 0x04f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f9_0), 0x04f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04fa_0), 0x04fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04fb_0), 0x04fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0600_0), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0610_0), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0618_0), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0620_0), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0628_0), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0630_0), 0x0630, 4, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0638_0), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0639_0), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0640_0), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0650_0), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0658_0), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0660_0), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0668_0), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0670_0), 0x0670, 4, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0678_0), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0679_0), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0680_0), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0690_0), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0698_0), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a0_0), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a8_0), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b0_0), 0x06b0, 6, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b8_0), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b9_0), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06c0_0), 0x06c0, 2, { 0, 0 }, 0 }, /* RTM */
{ CPUFUNC(op_06c8_0), 0x06c8, 2, { 0, 0 }, 0 }, /* RTM */
{ CPUFUNC(op_06d0_0), 0x06d0, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06e8_0), 0x06e8, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f0_0), 0x06f0, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f8_0), 0x06f8, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f9_0), 0x06f9, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06fa_0), 0x06fa, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06fb_0), 0x06fb, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_0800_0), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0810_0), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0818_0), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0820_0), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0828_0), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0830_0), 0x0830, 4, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0838_0), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0839_0), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083a_0), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083b_0), 0x083b, 4, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0840_0), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0850_0), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0858_0), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0860_0), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0868_0), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0870_0), 0x0870, 4, { 2, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0878_0), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0879_0), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0880_0), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0890_0), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0898_0), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a0_0), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a8_0), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b0_0), 0x08b0, 4, { 2, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b8_0), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b9_0), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08c0_0), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d0_0), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d8_0), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e0_0), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e8_0), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f0_0), 0x08f0, 4, { 2, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f8_0), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f9_0), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0a00_0), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a10_0), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a18_0), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a20_0), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a28_0), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a30_0), 0x0a30, 4, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a38_0), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a39_0), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a3c_0), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a40_0), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a50_0), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a58_0), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a60_0), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a68_0), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a70_0), 0x0a70, 4, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a78_0), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a79_0), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a7c_0), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a80_0), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a90_0), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a98_0), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa0_0), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa8_0), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab0_0), 0x0ab0, 6, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab8_0), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab9_0), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ad0_0), 0x0ad0, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ad8_0), 0x0ad8, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ae0_0), 0x0ae0, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ae8_0), 0x0ae8, 6, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af0_0), 0x0af0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af8_0), 0x0af8, 6, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af9_0), 0x0af9, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0c00_0), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c10_0), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c18_0), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c20_0), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c28_0), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c30_0), 0x0c30, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c38_0), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c39_0), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c3a_0), 0x0c3a, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c3b_0), 0x0c3b, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c40_0), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c50_0), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c58_0), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c60_0), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c68_0), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c70_0), 0x0c70, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c78_0), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c79_0), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c7a_0), 0x0c7a, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c7b_0), 0x0c7b, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c80_0), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c90_0), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c98_0), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca0_0), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca8_0), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb0_0), 0x0cb0, 6, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb8_0), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb9_0), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cba_0), 0x0cba, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cbb_0), 0x0cbb, 6, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cd0_0), 0x0cd0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cd8_0), 0x0cd8, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ce0_0), 0x0ce0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ce8_0), 0x0ce8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf0_0), 0x0cf0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf8_0), 0x0cf8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf9_0), 0x0cf9, 16, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cfc_0), 0x0cfc, 6, { 0, 0 }, 0 }, /* CAS2 */
{ CPUFUNC(op_0e10_0), 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e18_0), 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e20_0), 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e28_0), 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e30_0), 0x0e30, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e38_0), 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e39_0), 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e50_0), 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e58_0), 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e60_0), 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e68_0), 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e70_0), 0x0e70, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e78_0), 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e79_0), 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e90_0), 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e98_0), 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ea0_0), 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ea8_0), 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb0_0), 0x0eb0, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb8_0), 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb9_0), 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ed0_0), 0x0ed0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ed8_0), 0x0ed8, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ee0_0), 0x0ee0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ee8_0), 0x0ee8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef0_0), 0x0ef0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef8_0), 0x0ef8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef9_0), 0x0ef9, 16, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0efc_0), 0x0efc, 6, { 0, 0 }, 0 }, /* CAS2 */
{ CPUFUNC(op_1000_0), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1010_0), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1018_0), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1020_0), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1028_0), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1030_0), 0x1030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1038_0), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1039_0), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103a_0), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103b_0), 0x103b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103c_0), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1080_0), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1090_0), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1098_0), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a0_0), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a8_0), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b0_0), 0x10b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b8_0), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b9_0), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10ba_0), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bb_0), 0x10bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bc_0), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10c0_0), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d0_0), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d8_0), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e0_0), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e8_0), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f0_0), 0x10f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f8_0), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f9_0), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fa_0), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fb_0), 0x10fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fc_0), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1100_0), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1110_0), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1118_0), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1120_0), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1128_0), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1130_0), 0x1130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1138_0), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1139_0), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113a_0), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113b_0), 0x113b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113c_0), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1140_0), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1150_0), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1158_0), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1160_0), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1168_0), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1170_0), 0x1170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1178_0), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1179_0), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117a_0), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117b_0), 0x117b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117c_0), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1180_0), 0x1180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1190_0), 0x1190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1198_0), 0x1198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a0_0), 0x11a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a8_0), 0x11a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b0_0), 0x11b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b8_0), 0x11b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b9_0), 0x11b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11ba_0), 0x11ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bb_0), 0x11bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bc_0), 0x11bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11c0_0), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d0_0), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d8_0), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e0_0), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e8_0), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f0_0), 0x11f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f8_0), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f9_0), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fa_0), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fb_0), 0x11fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fc_0), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13c0_0), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d0_0), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d8_0), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e0_0), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e8_0), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f0_0), 0x13f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f8_0), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f9_0), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fa_0), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fb_0), 0x13fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fc_0), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2000_0), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2008_0), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2010_0), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2018_0), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2020_0), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2028_0), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2030_0), 0x2030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2038_0), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2039_0), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203a_0), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203b_0), 0x203b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203c_0), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2040_0), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2048_0), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2050_0), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2058_0), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2060_0), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2068_0), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2070_0), 0x2070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2078_0), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2079_0), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207a_0), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207b_0), 0x207b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207c_0), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2080_0), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2088_0), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2090_0), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2098_0), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a0_0), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a8_0), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b0_0), 0x20b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b8_0), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b9_0), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20ba_0), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bb_0), 0x20bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bc_0), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c0_0), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c8_0), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d0_0), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d8_0), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e0_0), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e8_0), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f0_0), 0x20f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f8_0), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f9_0), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fa_0), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fb_0), 0x20fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fc_0), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2100_0), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2108_0), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2110_0), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2118_0), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2120_0), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2128_0), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2130_0), 0x2130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2138_0), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2139_0), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213a_0), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213b_0), 0x213b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213c_0), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2140_0), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2148_0), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2150_0), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2158_0), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2160_0), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2168_0), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2170_0), 0x2170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2178_0), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2179_0), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217a_0), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217b_0), 0x217b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217c_0), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2180_0), 0x2180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2188_0), 0x2188, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2190_0), 0x2190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2198_0), 0x2198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a0_0), 0x21a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a8_0), 0x21a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b0_0), 0x21b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b8_0), 0x21b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b9_0), 0x21b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21ba_0), 0x21ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bb_0), 0x21bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bc_0), 0x21bc, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c0_0), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c8_0), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d0_0), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d8_0), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e0_0), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e8_0), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f0_0), 0x21f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f8_0), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f9_0), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fa_0), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fb_0), 0x21fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fc_0), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c0_0), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c8_0), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d0_0), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d8_0), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e0_0), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e8_0), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f0_0), 0x23f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f8_0), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f9_0), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fa_0), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fb_0), 0x23fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fc_0), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3000_0), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3008_0), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3010_0), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3018_0), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3020_0), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3028_0), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3030_0), 0x3030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3038_0), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3039_0), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303a_0), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303b_0), 0x303b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303c_0), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3040_0), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3048_0), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3050_0), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3058_0), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3060_0), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3068_0), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3070_0), 0x3070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3078_0), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3079_0), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307a_0), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307b_0), 0x307b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307c_0), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3080_0), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3088_0), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3090_0), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3098_0), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a0_0), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a8_0), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b0_0), 0x30b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b8_0), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b9_0), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30ba_0), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bb_0), 0x30bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bc_0), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c0_0), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c8_0), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d0_0), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d8_0), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e0_0), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e8_0), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f0_0), 0x30f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f8_0), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f9_0), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fa_0), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fb_0), 0x30fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fc_0), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3100_0), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3108_0), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3110_0), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3118_0), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3120_0), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3128_0), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3130_0), 0x3130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3138_0), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3139_0), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313a_0), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313b_0), 0x313b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313c_0), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3140_0), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3148_0), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3150_0), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3158_0), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3160_0), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3168_0), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3170_0), 0x3170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3178_0), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3179_0), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317a_0), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317b_0), 0x317b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317c_0), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3180_0), 0x3180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3188_0), 0x3188, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3190_0), 0x3190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3198_0), 0x3198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a0_0), 0x31a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a8_0), 0x31a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b0_0), 0x31b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b8_0), 0x31b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b9_0), 0x31b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31ba_0), 0x31ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bb_0), 0x31bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bc_0), 0x31bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c0_0), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c8_0), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d0_0), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d8_0), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e0_0), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e8_0), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f0_0), 0x31f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f8_0), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f9_0), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fa_0), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fb_0), 0x31fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fc_0), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c0_0), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c8_0), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d0_0), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d8_0), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e0_0), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e8_0), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f0_0), 0x33f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f8_0), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f9_0), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fa_0), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fb_0), 0x33fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fc_0), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_4000_0), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4010_0), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4018_0), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4020_0), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4028_0), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4030_0), 0x4030, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4038_0), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4039_0), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4040_0), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4050_0), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4058_0), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4060_0), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4068_0), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4070_0), 0x4070, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4078_0), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4079_0), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4080_0), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4090_0), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4098_0), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a0_0), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a8_0), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b0_0), 0x40b0, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b8_0), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b9_0), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40c0_0), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d0_0), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d8_0), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e0_0), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e8_0), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f0_0), 0x40f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f8_0), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f9_0), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4100_0), 0x4100, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4110_0), 0x4110, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4118_0), 0x4118, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4120_0), 0x4120, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4128_0), 0x4128, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4130_0), 0x4130, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4138_0), 0x4138, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4139_0), 0x4139, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413a_0), 0x413a, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413b_0), 0x413b, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413c_0), 0x413c, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4180_0), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4190_0), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4198_0), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a0_0), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a8_0), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b0_0), 0x41b0, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b8_0), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b9_0), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41ba_0), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bb_0), 0x41bb, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bc_0), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41d0_0), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41e8_0), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f0_0), 0x41f0, 2, { 2, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f8_0), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f9_0), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fa_0), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fb_0), 0x41fb, 2, { 2, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_4200_0), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4210_0), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4218_0), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4220_0), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4228_0), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4230_0), 0x4230, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4238_0), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4239_0), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4240_0), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4250_0), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4258_0), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4260_0), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4268_0), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4270_0), 0x4270, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4278_0), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4279_0), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4280_0), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4290_0), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4298_0), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a0_0), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a8_0), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b0_0), 0x42b0, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b8_0), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b9_0), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42c0_0), 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42d0_0), 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42d8_0), 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42e0_0), 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42e8_0), 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f0_0), 0x42f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f8_0), 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f9_0), 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4400_0), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4410_0), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4418_0), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4420_0), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4428_0), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4430_0), 0x4430, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4438_0), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4439_0), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4440_0), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4450_0), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4458_0), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4460_0), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4468_0), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4470_0), 0x4470, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4478_0), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4479_0), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4480_0), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4490_0), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4498_0), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a0_0), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a8_0), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b0_0), 0x44b0, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b8_0), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b9_0), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44c0_0), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d0_0), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d8_0), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e0_0), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e8_0), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f0_0), 0x44f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f8_0), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f9_0), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fa_0), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fb_0), 0x44fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fc_0), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4600_0), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4610_0), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4618_0), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4620_0), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4628_0), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4630_0), 0x4630, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4638_0), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4639_0), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4640_0), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4650_0), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4658_0), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4660_0), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4668_0), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4670_0), 0x4670, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4678_0), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4679_0), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4680_0), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4690_0), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4698_0), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a0_0), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a8_0), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b0_0), 0x46b0, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b8_0), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b9_0), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46c0_0), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d0_0), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d8_0), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e0_0), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e8_0), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f0_0), 0x46f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f8_0), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f9_0), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fa_0), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fb_0), 0x46fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fc_0), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4800_0), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4808_0), 0x4808, 6, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4810_0), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4818_0), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4820_0), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4828_0), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4830_0), 0x4830, 2, { 2, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4838_0), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4839_0), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4840_0), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ CPUFUNC(op_4848_0), 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
{ CPUFUNC(op_4850_0), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4868_0), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4870_0), 0x4870, 2, { 2, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4878_0), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4879_0), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487a_0), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487b_0), 0x487b, 2, { 2, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4880_0), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4890_0), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a0_0), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a8_0), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b0_0), 0x48b0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b8_0), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b9_0), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48c0_0), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_48d0_0), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e0_0), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e8_0), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f0_0), 0x48f0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f8_0), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f9_0), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_49c0_0), 0x49c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4a00_0), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a10_0), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a18_0), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a20_0), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a28_0), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a30_0), 0x4a30, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a38_0), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a39_0), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3a_0), 0x4a3a, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3b_0), 0x4a3b, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3c_0), 0x4a3c, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a40_0), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a48_0), 0x4a48, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a50_0), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a58_0), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a60_0), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a68_0), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a70_0), 0x4a70, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a78_0), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a79_0), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7a_0), 0x4a7a, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7b_0), 0x4a7b, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7c_0), 0x4a7c, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a80_0), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a88_0), 0x4a88, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a90_0), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a98_0), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa0_0), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa8_0), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab0_0), 0x4ab0, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab8_0), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab9_0), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aba_0), 0x4aba, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4abb_0), 0x4abb, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4abc_0), 0x4abc, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ac0_0), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad0_0), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad8_0), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae0_0), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae8_0), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af0_0), 0x4af0, 2, { 2, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af8_0), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af9_0), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4c00_0), 0x4c00, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c10_0), 0x4c10, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c18_0), 0x4c18, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c20_0), 0x4c20, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c28_0), 0x4c28, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c30_0), 0x4c30, 4, { 2, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c38_0), 0x4c38, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c39_0), 0x4c39, 8, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3a_0), 0x4c3a, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3b_0), 0x4c3b, 4, { 2, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3c_0), 0x4c3c, 8, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c40_0), 0x4c40, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c50_0), 0x4c50, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c58_0), 0x4c58, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c60_0), 0x4c60, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c68_0), 0x4c68, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c70_0), 0x4c70, 4, { 2, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c78_0), 0x4c78, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c79_0), 0x4c79, 8, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7a_0), 0x4c7a, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7b_0), 0x4c7b, 4, { 2, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7c_0), 0x4c7c, 8, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c90_0), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4c98_0), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ca8_0), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb0_0), 0x4cb0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb8_0), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb9_0), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cba_0), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cbb_0), 0x4cbb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd0_0), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd8_0), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ce8_0), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf0_0), 0x4cf0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf8_0), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf9_0), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfa_0), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfb_0), 0x4cfb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4e40_0), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ CPUFUNC(op_4e50_0), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4e58_0), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ CPUFUNC(op_4e60_0), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ CPUFUNC(op_4e68_0), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ CPUFUNC(op_4e70_0), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ CPUFUNC(op_4e71_0), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ CPUFUNC(op_4e72_0), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ CPUFUNC(op_4e73_0), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ CPUFUNC(op_4e74_0), 0x4e74, 4, { 0, 0 }, 1 }, /* RTD */
{ CPUFUNC(op_4e75_0), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ CPUFUNC(op_4e76_0), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ CPUFUNC(op_4e77_0), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ CPUFUNC(op_4e7a_0), 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
{ CPUFUNC(op_4e7b_0), 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
{ CPUFUNC(op_4e90_0), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ea8_0), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb0_0), 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb8_0), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb9_0), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eba_0), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ebb_0), 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ed0_0), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ee8_0), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef0_0), 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef8_0), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef9_0), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efa_0), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efb_0), 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_5000_0), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5010_0), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5018_0), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5020_0), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5028_0), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5030_0), 0x5030, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5038_0), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5039_0), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5040_0), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5048_0), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5050_0), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5058_0), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5060_0), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5068_0), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5070_0), 0x5070, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5078_0), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5079_0), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5080_0), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5088_0), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5090_0), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5098_0), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a0_0), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a8_0), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b0_0), 0x50b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b8_0), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b9_0), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50c0_0), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50c8_0), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_50d0_0), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50d8_0), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e0_0), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e8_0), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f0_0), 0x50f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f8_0), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f9_0), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50fa_0), 0x50fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_50fb_0), 0x50fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_50fc_0), 0x50fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5100_0), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5110_0), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5118_0), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5120_0), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5128_0), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5130_0), 0x5130, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5138_0), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5139_0), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5140_0), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5148_0), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5150_0), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5158_0), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5160_0), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5168_0), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5170_0), 0x5170, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5178_0), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5179_0), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5180_0), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5188_0), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5190_0), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5198_0), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a0_0), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a8_0), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b0_0), 0x51b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b8_0), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b9_0), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51c0_0), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51c8_0), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_51d0_0), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51d8_0), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e0_0), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e8_0), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f0_0), 0x51f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f8_0), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f9_0), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51fa_0), 0x51fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_51fb_0), 0x51fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_51fc_0), 0x51fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52c0_0), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c8_0), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_52d0_0), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52d8_0), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e0_0), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e8_0), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f0_0), 0x52f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f8_0), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f9_0), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52fa_0), 0x52fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52fb_0), 0x52fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52fc_0), 0x52fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53c0_0), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c8_0), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_53d0_0), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53d8_0), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e0_0), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e8_0), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f0_0), 0x53f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f8_0), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f9_0), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53fa_0), 0x53fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53fb_0), 0x53fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53fc_0), 0x53fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54c0_0), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c8_0), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_54d0_0), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54d8_0), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e0_0), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e8_0), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f0_0), 0x54f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f8_0), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f9_0), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54fa_0), 0x54fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54fb_0), 0x54fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54fc_0), 0x54fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55c0_0), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c8_0), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_55d0_0), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55d8_0), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e0_0), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e8_0), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f0_0), 0x55f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f8_0), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f9_0), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55fa_0), 0x55fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55fb_0), 0x55fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55fc_0), 0x55fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56c0_0), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c8_0), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_56d0_0), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56d8_0), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e0_0), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e8_0), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f0_0), 0x56f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f8_0), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f9_0), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56fa_0), 0x56fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56fb_0), 0x56fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56fc_0), 0x56fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57c0_0), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c8_0), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_57d0_0), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57d8_0), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e0_0), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e8_0), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f0_0), 0x57f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f8_0), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f9_0), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57fa_0), 0x57fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57fb_0), 0x57fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57fc_0), 0x57fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58c0_0), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c8_0), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_58d0_0), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58d8_0), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e0_0), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e8_0), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f0_0), 0x58f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f8_0), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f9_0), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58fa_0), 0x58fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58fb_0), 0x58fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58fc_0), 0x58fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59c0_0), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c8_0), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_59d0_0), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59d8_0), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e0_0), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e8_0), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f0_0), 0x59f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f8_0), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f9_0), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59fa_0), 0x59fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59fb_0), 0x59fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59fc_0), 0x59fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ac0_0), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac8_0), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ad0_0), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ad8_0), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae0_0), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae8_0), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af0_0), 0x5af0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af8_0), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af9_0), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5afa_0), 0x5afa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5afb_0), 0x5afb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5afc_0), 0x5afc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bc0_0), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc8_0), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5bd0_0), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bd8_0), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be0_0), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be8_0), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf0_0), 0x5bf0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf8_0), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf9_0), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bfa_0), 0x5bfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bfb_0), 0x5bfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bfc_0), 0x5bfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cc0_0), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc8_0), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5cd0_0), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cd8_0), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce0_0), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce8_0), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf0_0), 0x5cf0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf8_0), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf9_0), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cfa_0), 0x5cfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cfb_0), 0x5cfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cfc_0), 0x5cfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dc0_0), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc8_0), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5dd0_0), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dd8_0), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de0_0), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de8_0), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df0_0), 0x5df0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df8_0), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df9_0), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dfa_0), 0x5dfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dfb_0), 0x5dfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dfc_0), 0x5dfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ec0_0), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec8_0), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ed0_0), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ed8_0), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee0_0), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee8_0), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef0_0), 0x5ef0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef8_0), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef9_0), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5efa_0), 0x5efa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5efb_0), 0x5efb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5efc_0), 0x5efc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5fc0_0), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc8_0), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5fd0_0), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fd8_0), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe0_0), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe8_0), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff0_0), 0x5ff0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff8_0), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff9_0), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ffa_0), 0x5ffa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ffb_0), 0x5ffb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ffc_0), 0x5ffc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_6000_0), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6001_0), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_60ff_0), 0x60ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6100_0), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6101_0), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_61ff_0), 0x61ff, 6, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6200_0), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6201_0), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_62ff_0), 0x62ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6300_0), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6301_0), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_63ff_0), 0x63ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6400_0), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6401_0), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_64ff_0), 0x64ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6500_0), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6501_0), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_65ff_0), 0x65ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6600_0), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6601_0), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_66ff_0), 0x66ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6700_0), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6701_0), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_67ff_0), 0x67ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6800_0), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6801_0), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_68ff_0), 0x68ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6900_0), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6901_0), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_69ff_0), 0x69ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a00_0), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a01_0), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6aff_0), 0x6aff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b00_0), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b01_0), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6bff_0), 0x6bff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c00_0), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c01_0), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6cff_0), 0x6cff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d00_0), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d01_0), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6dff_0), 0x6dff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e00_0), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e01_0), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6eff_0), 0x6eff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f00_0), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f01_0), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6fff_0), 0x6fff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_7000_0), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_8000_0), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8010_0), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8018_0), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8020_0), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8028_0), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8030_0), 0x8030, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8038_0), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8039_0), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803a_0), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803b_0), 0x803b, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803c_0), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8040_0), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8050_0), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8058_0), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8060_0), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8068_0), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8070_0), 0x8070, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8078_0), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8079_0), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807a_0), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807b_0), 0x807b, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807c_0), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8080_0), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8090_0), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8098_0), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a0_0), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a8_0), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b0_0), 0x80b0, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b8_0), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b9_0), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80ba_0), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bb_0), 0x80bb, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bc_0), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80c0_0), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d0_0), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d8_0), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e0_0), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e8_0), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f0_0), 0x80f0, 2, { 2, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f8_0), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f9_0), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fa_0), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fb_0), 0x80fb, 2, { 2, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fc_0), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_8100_0), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8108_0), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8110_0), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8118_0), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8120_0), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8128_0), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8130_0), 0x8130, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8138_0), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8139_0), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8140_0), 0x8140, 4, { 0, 0 }, 0 }, /* PACK */
{ CPUFUNC(op_8148_0), 0x8148, 4, { 0, 0 }, 0 }, /* PACK */
{ CPUFUNC(op_8150_0), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8158_0), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8160_0), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8168_0), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8170_0), 0x8170, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8178_0), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8179_0), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8180_0), 0x8180, 4, { 0, 0 }, 0 }, /* UNPK */
{ CPUFUNC(op_8188_0), 0x8188, 4, { 0, 0 }, 0 }, /* UNPK */
{ CPUFUNC(op_8190_0), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8198_0), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a0_0), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a8_0), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b0_0), 0x81b0, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b8_0), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b9_0), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81c0_0), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d0_0), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d8_0), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e0_0), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e8_0), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f0_0), 0x81f0, 2, { 2, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f8_0), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f9_0), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fa_0), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fb_0), 0x81fb, 2, { 2, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fc_0), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_9000_0), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9010_0), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9018_0), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9020_0), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9028_0), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9030_0), 0x9030, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9038_0), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9039_0), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903a_0), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903b_0), 0x903b, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903c_0), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9040_0), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9048_0), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9050_0), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9058_0), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9060_0), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9068_0), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9070_0), 0x9070, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9078_0), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9079_0), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907a_0), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907b_0), 0x907b, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907c_0), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9080_0), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9088_0), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9090_0), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9098_0), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a0_0), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a8_0), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b0_0), 0x90b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b8_0), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b9_0), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90ba_0), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bb_0), 0x90bb, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bc_0), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90c0_0), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90c8_0), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d0_0), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d8_0), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e0_0), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e8_0), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f0_0), 0x90f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f8_0), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f9_0), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fa_0), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fb_0), 0x90fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fc_0), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_9100_0), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9108_0), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9110_0), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9118_0), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9120_0), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9128_0), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9130_0), 0x9130, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9138_0), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9139_0), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9140_0), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9148_0), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9150_0), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9158_0), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9160_0), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9168_0), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9170_0), 0x9170, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9178_0), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9179_0), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9180_0), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9188_0), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9190_0), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9198_0), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a0_0), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a8_0), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b0_0), 0x91b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b8_0), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b9_0), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91c0_0), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91c8_0), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d0_0), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d8_0), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e0_0), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e8_0), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f0_0), 0x91f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f8_0), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f9_0), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fa_0), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fb_0), 0x91fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fc_0), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_b000_0), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b010_0), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b018_0), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b020_0), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b028_0), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b030_0), 0xb030, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b038_0), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b039_0), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03a_0), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03b_0), 0xb03b, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03c_0), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b040_0), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b048_0), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b050_0), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b058_0), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b060_0), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b068_0), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b070_0), 0xb070, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b078_0), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b079_0), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07a_0), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07b_0), 0xb07b, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07c_0), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b080_0), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b088_0), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b090_0), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b098_0), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a0_0), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a8_0), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b0_0), 0xb0b0, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b8_0), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b9_0), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0ba_0), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bb_0), 0xb0bb, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bc_0), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0c0_0), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0c8_0), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d0_0), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d8_0), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e0_0), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e8_0), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f0_0), 0xb0f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f8_0), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f9_0), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fa_0), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fb_0), 0xb0fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fc_0), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b100_0), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b108_0), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b110_0), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b118_0), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b120_0), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b128_0), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b130_0), 0xb130, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b138_0), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b139_0), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b140_0), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b148_0), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b150_0), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b158_0), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b160_0), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b168_0), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b170_0), 0xb170, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b178_0), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b179_0), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b180_0), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b188_0), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b190_0), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b198_0), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a0_0), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a8_0), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b0_0), 0xb1b0, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b8_0), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b9_0), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1c0_0), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1c8_0), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d0_0), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d8_0), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e0_0), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e8_0), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f0_0), 0xb1f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f8_0), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f9_0), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fa_0), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fb_0), 0xb1fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fc_0), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_c000_0), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c010_0), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c018_0), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c020_0), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c028_0), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c030_0), 0xc030, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c038_0), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c039_0), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03a_0), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03b_0), 0xc03b, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03c_0), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c040_0), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c050_0), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c058_0), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c060_0), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c068_0), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c070_0), 0xc070, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c078_0), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c079_0), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07a_0), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07b_0), 0xc07b, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07c_0), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c080_0), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c090_0), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c098_0), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a0_0), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a8_0), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b0_0), 0xc0b0, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b8_0), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b9_0), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0ba_0), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bb_0), 0xc0bb, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bc_0), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0c0_0), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d0_0), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d8_0), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e0_0), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e8_0), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f0_0), 0xc0f0, 2, { 2, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f8_0), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f9_0), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fa_0), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fb_0), 0xc0fb, 2, { 2, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fc_0), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c100_0), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c108_0), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c110_0), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c118_0), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c120_0), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c128_0), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c130_0), 0xc130, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c138_0), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c139_0), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c140_0), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c148_0), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c150_0), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c158_0), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c160_0), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c168_0), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c170_0), 0xc170, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c178_0), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c179_0), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c188_0), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c190_0), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c198_0), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a0_0), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a8_0), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b0_0), 0xc1b0, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b8_0), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b9_0), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1c0_0), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d0_0), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d8_0), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e0_0), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e8_0), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f0_0), 0xc1f0, 2, { 2, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f8_0), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f9_0), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fa_0), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fb_0), 0xc1fb, 2, { 2, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fc_0), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_d000_0), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d010_0), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d018_0), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d020_0), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d028_0), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d030_0), 0xd030, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d038_0), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d039_0), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03a_0), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03b_0), 0xd03b, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03c_0), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d040_0), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d048_0), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d050_0), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d058_0), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d060_0), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d068_0), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d070_0), 0xd070, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d078_0), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d079_0), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07a_0), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07b_0), 0xd07b, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07c_0), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d080_0), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d088_0), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d090_0), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d098_0), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a0_0), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a8_0), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b0_0), 0xd0b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b8_0), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b9_0), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0ba_0), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bb_0), 0xd0bb, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bc_0), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0c0_0), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0c8_0), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d0_0), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d8_0), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e0_0), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e8_0), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f0_0), 0xd0f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f8_0), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f9_0), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fa_0), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fb_0), 0xd0fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fc_0), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d100_0), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d108_0), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d110_0), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d118_0), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d120_0), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d128_0), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d130_0), 0xd130, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d138_0), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d139_0), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d140_0), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d148_0), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d150_0), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d158_0), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d160_0), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d168_0), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d170_0), 0xd170, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d178_0), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d179_0), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d180_0), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d188_0), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d190_0), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d198_0), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a0_0), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a8_0), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b0_0), 0xd1b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b8_0), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b9_0), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1c0_0), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1c8_0), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d0_0), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d8_0), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e0_0), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e8_0), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f0_0), 0xd1f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f8_0), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f9_0), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fa_0), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fb_0), 0xd1fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fc_0), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_e000_0), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e008_0), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e010_0), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e018_0), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e020_0), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e028_0), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e030_0), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e038_0), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e040_0), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e048_0), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e050_0), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e058_0), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e060_0), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e068_0), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e070_0), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e078_0), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e080_0), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e088_0), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e090_0), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e098_0), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0a0_0), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e0a8_0), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e0b0_0), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e0b8_0), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0d0_0), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0d8_0), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e0_0), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e8_0), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f0_0), 0xe0f0, 2, { 2, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f8_0), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f9_0), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e100_0), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e108_0), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e110_0), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e118_0), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e120_0), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e128_0), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e130_0), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e138_0), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e140_0), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e148_0), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e150_0), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e158_0), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e160_0), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e168_0), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e170_0), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e178_0), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e180_0), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e188_0), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e190_0), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e198_0), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1a0_0), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e1a8_0), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e1b0_0), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e1b8_0), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1d0_0), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1d8_0), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e0_0), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e8_0), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f0_0), 0xe1f0, 2, { 2, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f8_0), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f9_0), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e2d0_0), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2d8_0), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e0_0), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e8_0), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f0_0), 0xe2f0, 2, { 2, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f8_0), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f9_0), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e3d0_0), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3d8_0), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e0_0), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e8_0), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f0_0), 0xe3f0, 2, { 2, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f8_0), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f9_0), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e4d0_0), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4d8_0), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e0_0), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e8_0), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f0_0), 0xe4f0, 2, { 2, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f8_0), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f9_0), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e5d0_0), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5d8_0), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e0_0), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e8_0), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f0_0), 0xe5f0, 2, { 2, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f8_0), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f9_0), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e6d0_0), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6d8_0), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e0_0), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e8_0), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f0_0), 0xe6f0, 2, { 2, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f8_0), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f9_0), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e7d0_0), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7d8_0), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e0_0), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e8_0), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f0_0), 0xe7f0, 2, { 2, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f8_0), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f9_0), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e8c0_0), 0xe8c0, 4, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8d0_0), 0xe8d0, 4, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8e8_0), 0xe8e8, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f0_0), 0xe8f0, 4, { 2, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f8_0), 0xe8f8, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f9_0), 0xe8f9, 8, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8fa_0), 0xe8fa, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8fb_0), 0xe8fb, 4, { 2, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e9c0_0), 0xe9c0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9d0_0), 0xe9d0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9e8_0), 0xe9e8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f0_0), 0xe9f0, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f8_0), 0xe9f8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f9_0), 0xe9f9, 8, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9fa_0), 0xe9fa, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9fb_0), 0xe9fb, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_eac0_0), 0xeac0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_ead0_0), 0xead0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eae8_0), 0xeae8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf0_0), 0xeaf0, 4, { 2, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf8_0), 0xeaf8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf9_0), 0xeaf9, 8, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_ebc0_0), 0xebc0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebd0_0), 0xebd0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebe8_0), 0xebe8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf0_0), 0xebf0, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf8_0), 0xebf8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf9_0), 0xebf9, 8, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebfa_0), 0xebfa, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebfb_0), 0xebfb, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ecc0_0), 0xecc0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecd0_0), 0xecd0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ece8_0), 0xece8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf0_0), 0xecf0, 4, { 2, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf8_0), 0xecf8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf9_0), 0xecf9, 8, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_edc0_0), 0xedc0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edd0_0), 0xedd0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_ede8_0), 0xede8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf0_0), 0xedf0, 4, { 2, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf8_0), 0xedf8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf9_0), 0xedf9, 8, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edfa_0), 0xedfa, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edfb_0), 0xedfb, 4, { 2, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_eec0_0), 0xeec0, 4, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eed0_0), 0xeed0, 4, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eee8_0), 0xeee8, 6, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef0_0), 0xeef0, 4, { 2, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef8_0), 0xeef8, 6, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef9_0), 0xeef9, 8, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_efc0_0), 0xefc0, 4, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_efd0_0), 0xefd0, 4, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_efe8_0), 0xefe8, 6, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff0_0), 0xeff0, 4, { 2, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff8_0), 0xeff8, 6, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff9_0), 0xeff9, 8, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_f000_0), 0xf000, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f008_0), 0xf008, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f010_0), 0xf010, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f018_0), 0xf018, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f020_0), 0xf020, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f028_0), 0xf028, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f030_0), 0xf030, -1, { -3, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f038_0), 0xf038, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f039_0), 0xf039, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f200_0), 0xf200, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f208_0), 0xf208, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f210_0), 0xf210, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f218_0), 0xf218, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f220_0), 0xf220, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f228_0), 0xf228, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f230_0), 0xf230, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f238_0), 0xf238, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f239_0), 0xf239, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23a_0), 0xf23a, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23b_0), 0xf23b, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23c_0), 0xf23c, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f240_0), 0xf240, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f248_0), 0xf248, -1, { 0, 0 }, 0 }, /* FDBcc */
{ CPUFUNC(op_f250_0), 0xf250, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f258_0), 0xf258, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f260_0), 0xf260, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f268_0), 0xf268, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f270_0), 0xf270, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f278_0), 0xf278, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f279_0), 0xf279, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f27a_0), 0xf27a, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f27b_0), 0xf27b, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f27c_0), 0xf27c, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f280_0), 0xf280, -1, { 0, 0 }, 0 }, /* FBcc */
{ CPUFUNC(op_f2c0_0), 0xf2c0, -1, { 0, 0 }, 0 }, /* FBcc */
{ CPUFUNC(op_f310_0), 0xf310, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f320_0), 0xf320, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f328_0), 0xf328, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f330_0), 0xf330, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f338_0), 0xf338, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f339_0), 0xf339, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f350_0), 0xf350, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f358_0), 0xf358, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f368_0), 0xf368, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f370_0), 0xf370, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f378_0), 0xf378, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f379_0), 0xf379, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f37a_0), 0xf37a, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f37b_0), 0xf37b, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f408_0), 0xf408, -1, { 0, 0 }, 0 }, /* CINVL */
{ CPUFUNC(op_f410_0), 0xf410, -1, { 0, 0 }, 0 }, /* CINVP */
{ CPUFUNC(op_f418_0), 0xf418, -1, { 0, 0 }, 0 }, /* CINVA */
{ CPUFUNC(op_f419_0), 0xf419, -1, { 0, 0 }, 0 }, /* CINVA */
{ CPUFUNC(op_f41a_0), 0xf41a, -1, { 0, 0 }, 0 }, /* CINVA */
{ CPUFUNC(op_f41b_0), 0xf41b, -1, { 0, 0 }, 0 }, /* CINVA */
{ CPUFUNC(op_f41c_0), 0xf41c, -1, { 0, 0 }, 0 }, /* CINVA */
{ CPUFUNC(op_f41d_0), 0xf41d, -1, { 0, 0 }, 0 }, /* CINVA */
{ CPUFUNC(op_f41e_0), 0xf41e, -1, { 0, 0 }, 0 }, /* CINVA */
{ CPUFUNC(op_f41f_0), 0xf41f, -1, { 0, 0 }, 0 }, /* CINVA */
{ CPUFUNC(op_f428_0), 0xf428, -1, { 0, 0 }, 0 }, /* CPUSHL */
{ CPUFUNC(op_f430_0), 0xf430, -1, { 0, 0 }, 0 }, /* CPUSHP */
{ CPUFUNC(op_f438_0), 0xf438, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ CPUFUNC(op_f439_0), 0xf439, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ CPUFUNC(op_f43a_0), 0xf43a, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ CPUFUNC(op_f43b_0), 0xf43b, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ CPUFUNC(op_f43c_0), 0xf43c, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ CPUFUNC(op_f43d_0), 0xf43d, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ CPUFUNC(op_f43e_0), 0xf43e, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ CPUFUNC(op_f43f_0), 0xf43f, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ CPUFUNC(op_f500_0), 0xf500, -1, { 0, 0 }, 0 }, /* PFLUSHN */
{ CPUFUNC(op_f508_0), 0xf508, -1, { 0, 0 }, 0 }, /* PFLUSH */
{ CPUFUNC(op_f510_0), 0xf510, -1, { 0, 0 }, 0 }, /* PFLUSHAN */
{ CPUFUNC(op_f518_0), 0xf518, -1, { 0, 0 }, 0 }, /* PFLUSHA */
{ CPUFUNC(op_f548_0), 0xf548, -1, { 0, 0 }, 0 }, /* PTESTW */
{ CPUFUNC(op_f568_0), 0xf568, -1, { 0, 0 }, 0 }, /* PTESTR */
{ CPUFUNC(op_f600_0), 0xf600, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ CPUFUNC(op_f608_0), 0xf608, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ CPUFUNC(op_f610_0), 0xf610, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ CPUFUNC(op_f618_0), 0xf618, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ CPUFUNC(op_f620_0), 0xf620, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ 0, 0 }};
#endif /* CPUEMU_68000_ONLY */
#endif /* CPUEMU_0 */
#ifdef CPUEMU_0
#ifndef CPUEMU_68000_ONLY
const struct cputbl CPUFUNC(op_smalltbl_2)[] = {
{ CPUFUNC(op_0000_0), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0010_0), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0018_0), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0020_0), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0028_0), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0030_0), 0x0030, 4, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0038_0), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0039_0), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_003c_0), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0040_0), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0050_0), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0058_0), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0060_0), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0068_0), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0070_0), 0x0070, 4, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0078_0), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0079_0), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_007c_0), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0080_0), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0090_0), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0098_0), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a0_0), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a8_0), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b0_0), 0x00b0, 6, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b8_0), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b9_0), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00d0_0), 0x00d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00e8_0), 0x00e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f0_0), 0x00f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f8_0), 0x00f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f9_0), 0x00f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00fa_0), 0x00fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00fb_0), 0x00fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0100_0), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0108_0), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0110_0), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0118_0), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0120_0), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0128_0), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0130_0), 0x0130, 2, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0138_0), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0139_0), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013a_0), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013b_0), 0x013b, 2, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013c_0), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0140_0), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0148_0), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0150_0), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0158_0), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0160_0), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0168_0), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0170_0), 0x0170, 2, { 2, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0178_0), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0179_0), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0180_0), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0188_0), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_0190_0), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0198_0), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a0_0), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a8_0), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b0_0), 0x01b0, 2, { 2, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b8_0), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b9_0), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01c0_0), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01c8_0), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_01d0_0), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01d8_0), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e0_0), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e8_0), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f0_0), 0x01f0, 2, { 2, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f8_0), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f9_0), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0200_0), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0210_0), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0218_0), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0220_0), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0228_0), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0230_0), 0x0230, 4, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0238_0), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0239_0), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_023c_0), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0240_0), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0250_0), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0258_0), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0260_0), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0268_0), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0270_0), 0x0270, 4, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0278_0), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0279_0), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_027c_0), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0280_0), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0290_0), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0298_0), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a0_0), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a8_0), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b0_0), 0x02b0, 6, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b8_0), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b9_0), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02d0_0), 0x02d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02e8_0), 0x02e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f0_0), 0x02f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f8_0), 0x02f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f9_0), 0x02f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02fa_0), 0x02fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02fb_0), 0x02fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0400_0), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0410_0), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0418_0), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0420_0), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0428_0), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0430_0), 0x0430, 4, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0438_0), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0439_0), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0440_0), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0450_0), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0458_0), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0460_0), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0468_0), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0470_0), 0x0470, 4, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0478_0), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0479_0), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0480_0), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0490_0), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0498_0), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a0_0), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a8_0), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b0_0), 0x04b0, 6, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b8_0), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b9_0), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04d0_0), 0x04d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04e8_0), 0x04e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f0_0), 0x04f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f8_0), 0x04f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f9_0), 0x04f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04fa_0), 0x04fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04fb_0), 0x04fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0600_0), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0610_0), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0618_0), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0620_0), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0628_0), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0630_0), 0x0630, 4, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0638_0), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0639_0), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0640_0), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0650_0), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0658_0), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0660_0), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0668_0), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0670_0), 0x0670, 4, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0678_0), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0679_0), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0680_0), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0690_0), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0698_0), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a0_0), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a8_0), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b0_0), 0x06b0, 6, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b8_0), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b9_0), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06c0_0), 0x06c0, 2, { 0, 0 }, 0 }, /* RTM */
{ CPUFUNC(op_06c8_0), 0x06c8, 2, { 0, 0 }, 0 }, /* RTM */
{ CPUFUNC(op_06d0_0), 0x06d0, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06e8_0), 0x06e8, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f0_0), 0x06f0, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f8_0), 0x06f8, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f9_0), 0x06f9, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06fa_0), 0x06fa, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06fb_0), 0x06fb, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_0800_0), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0810_0), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0818_0), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0820_0), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0828_0), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0830_0), 0x0830, 4, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0838_0), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0839_0), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083a_0), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083b_0), 0x083b, 4, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0840_0), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0850_0), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0858_0), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0860_0), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0868_0), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0870_0), 0x0870, 4, { 2, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0878_0), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0879_0), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0880_0), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0890_0), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0898_0), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a0_0), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a8_0), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b0_0), 0x08b0, 4, { 2, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b8_0), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b9_0), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08c0_0), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d0_0), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d8_0), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e0_0), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e8_0), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f0_0), 0x08f0, 4, { 2, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f8_0), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f9_0), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0a00_0), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a10_0), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a18_0), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a20_0), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a28_0), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a30_0), 0x0a30, 4, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a38_0), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a39_0), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a3c_0), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a40_0), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a50_0), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a58_0), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a60_0), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a68_0), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a70_0), 0x0a70, 4, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a78_0), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a79_0), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a7c_0), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a80_0), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a90_0), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a98_0), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa0_0), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa8_0), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab0_0), 0x0ab0, 6, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab8_0), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab9_0), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ad0_0), 0x0ad0, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ad8_0), 0x0ad8, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ae0_0), 0x0ae0, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ae8_0), 0x0ae8, 6, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af0_0), 0x0af0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af8_0), 0x0af8, 6, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af9_0), 0x0af9, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0c00_0), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c10_0), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c18_0), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c20_0), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c28_0), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c30_0), 0x0c30, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c38_0), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c39_0), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c3a_0), 0x0c3a, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c3b_0), 0x0c3b, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c40_0), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c50_0), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c58_0), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c60_0), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c68_0), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c70_0), 0x0c70, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c78_0), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c79_0), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c7a_0), 0x0c7a, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c7b_0), 0x0c7b, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c80_0), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c90_0), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c98_0), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca0_0), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca8_0), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb0_0), 0x0cb0, 6, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb8_0), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb9_0), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cba_0), 0x0cba, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cbb_0), 0x0cbb, 6, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cd0_0), 0x0cd0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cd8_0), 0x0cd8, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ce0_0), 0x0ce0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ce8_0), 0x0ce8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf0_0), 0x0cf0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf8_0), 0x0cf8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf9_0), 0x0cf9, 16, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cfc_0), 0x0cfc, 6, { 0, 0 }, 0 }, /* CAS2 */
{ CPUFUNC(op_0e10_0), 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e18_0), 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e20_0), 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e28_0), 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e30_0), 0x0e30, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e38_0), 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e39_0), 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e50_0), 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e58_0), 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e60_0), 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e68_0), 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e70_0), 0x0e70, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e78_0), 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e79_0), 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e90_0), 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e98_0), 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ea0_0), 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ea8_0), 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb0_0), 0x0eb0, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb8_0), 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb9_0), 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ed0_0), 0x0ed0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ed8_0), 0x0ed8, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ee0_0), 0x0ee0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ee8_0), 0x0ee8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef0_0), 0x0ef0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef8_0), 0x0ef8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef9_0), 0x0ef9, 16, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0efc_0), 0x0efc, 6, { 0, 0 }, 0 }, /* CAS2 */
{ CPUFUNC(op_1000_0), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1010_0), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1018_0), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1020_0), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1028_0), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1030_0), 0x1030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1038_0), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1039_0), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103a_0), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103b_0), 0x103b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103c_0), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1080_0), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1090_0), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1098_0), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a0_0), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a8_0), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b0_0), 0x10b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b8_0), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b9_0), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10ba_0), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bb_0), 0x10bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bc_0), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10c0_0), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d0_0), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d8_0), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e0_0), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e8_0), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f0_0), 0x10f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f8_0), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f9_0), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fa_0), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fb_0), 0x10fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fc_0), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1100_0), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1110_0), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1118_0), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1120_0), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1128_0), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1130_0), 0x1130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1138_0), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1139_0), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113a_0), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113b_0), 0x113b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113c_0), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1140_0), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1150_0), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1158_0), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1160_0), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1168_0), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1170_0), 0x1170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1178_0), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1179_0), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117a_0), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117b_0), 0x117b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117c_0), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1180_0), 0x1180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1190_0), 0x1190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1198_0), 0x1198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a0_0), 0x11a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a8_0), 0x11a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b0_0), 0x11b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b8_0), 0x11b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b9_0), 0x11b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11ba_0), 0x11ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bb_0), 0x11bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bc_0), 0x11bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11c0_0), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d0_0), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d8_0), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e0_0), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e8_0), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f0_0), 0x11f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f8_0), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f9_0), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fa_0), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fb_0), 0x11fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fc_0), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13c0_0), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d0_0), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d8_0), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e0_0), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e8_0), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f0_0), 0x13f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f8_0), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f9_0), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fa_0), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fb_0), 0x13fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fc_0), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2000_0), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2008_0), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2010_0), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2018_0), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2020_0), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2028_0), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2030_0), 0x2030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2038_0), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2039_0), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203a_0), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203b_0), 0x203b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203c_0), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2040_0), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2048_0), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2050_0), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2058_0), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2060_0), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2068_0), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2070_0), 0x2070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2078_0), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2079_0), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207a_0), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207b_0), 0x207b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207c_0), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2080_0), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2088_0), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2090_0), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2098_0), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a0_0), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a8_0), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b0_0), 0x20b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b8_0), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b9_0), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20ba_0), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bb_0), 0x20bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bc_0), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c0_0), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c8_0), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d0_0), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d8_0), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e0_0), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e8_0), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f0_0), 0x20f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f8_0), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f9_0), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fa_0), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fb_0), 0x20fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fc_0), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2100_0), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2108_0), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2110_0), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2118_0), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2120_0), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2128_0), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2130_0), 0x2130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2138_0), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2139_0), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213a_0), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213b_0), 0x213b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213c_0), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2140_0), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2148_0), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2150_0), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2158_0), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2160_0), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2168_0), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2170_0), 0x2170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2178_0), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2179_0), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217a_0), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217b_0), 0x217b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217c_0), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2180_0), 0x2180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2188_0), 0x2188, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2190_0), 0x2190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2198_0), 0x2198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a0_0), 0x21a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a8_0), 0x21a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b0_0), 0x21b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b8_0), 0x21b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b9_0), 0x21b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21ba_0), 0x21ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bb_0), 0x21bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bc_0), 0x21bc, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c0_0), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c8_0), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d0_0), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d8_0), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e0_0), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e8_0), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f0_0), 0x21f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f8_0), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f9_0), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fa_0), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fb_0), 0x21fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fc_0), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c0_0), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c8_0), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d0_0), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d8_0), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e0_0), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e8_0), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f0_0), 0x23f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f8_0), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f9_0), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fa_0), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fb_0), 0x23fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fc_0), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3000_0), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3008_0), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3010_0), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3018_0), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3020_0), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3028_0), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3030_0), 0x3030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3038_0), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3039_0), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303a_0), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303b_0), 0x303b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303c_0), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3040_0), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3048_0), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3050_0), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3058_0), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3060_0), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3068_0), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3070_0), 0x3070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3078_0), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3079_0), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307a_0), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307b_0), 0x307b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307c_0), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3080_0), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3088_0), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3090_0), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3098_0), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a0_0), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a8_0), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b0_0), 0x30b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b8_0), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b9_0), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30ba_0), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bb_0), 0x30bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bc_0), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c0_0), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c8_0), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d0_0), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d8_0), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e0_0), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e8_0), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f0_0), 0x30f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f8_0), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f9_0), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fa_0), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fb_0), 0x30fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fc_0), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3100_0), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3108_0), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3110_0), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3118_0), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3120_0), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3128_0), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3130_0), 0x3130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3138_0), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3139_0), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313a_0), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313b_0), 0x313b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313c_0), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3140_0), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3148_0), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3150_0), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3158_0), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3160_0), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3168_0), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3170_0), 0x3170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3178_0), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3179_0), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317a_0), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317b_0), 0x317b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317c_0), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3180_0), 0x3180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3188_0), 0x3188, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3190_0), 0x3190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3198_0), 0x3198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a0_0), 0x31a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a8_0), 0x31a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b0_0), 0x31b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b8_0), 0x31b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b9_0), 0x31b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31ba_0), 0x31ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bb_0), 0x31bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bc_0), 0x31bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c0_0), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c8_0), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d0_0), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d8_0), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e0_0), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e8_0), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f0_0), 0x31f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f8_0), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f9_0), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fa_0), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fb_0), 0x31fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fc_0), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c0_0), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c8_0), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d0_0), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d8_0), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e0_0), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e8_0), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f0_0), 0x33f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f8_0), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f9_0), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fa_0), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fb_0), 0x33fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fc_0), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_4000_0), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4010_0), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4018_0), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4020_0), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4028_0), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4030_0), 0x4030, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4038_0), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4039_0), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4040_0), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4050_0), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4058_0), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4060_0), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4068_0), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4070_0), 0x4070, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4078_0), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4079_0), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4080_0), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4090_0), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4098_0), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a0_0), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a8_0), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b0_0), 0x40b0, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b8_0), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b9_0), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40c0_0), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d0_0), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d8_0), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e0_0), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e8_0), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f0_0), 0x40f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f8_0), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f9_0), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4100_0), 0x4100, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4110_0), 0x4110, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4118_0), 0x4118, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4120_0), 0x4120, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4128_0), 0x4128, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4130_0), 0x4130, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4138_0), 0x4138, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4139_0), 0x4139, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413a_0), 0x413a, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413b_0), 0x413b, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413c_0), 0x413c, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4180_0), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4190_0), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4198_0), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a0_0), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a8_0), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b0_0), 0x41b0, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b8_0), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b9_0), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41ba_0), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bb_0), 0x41bb, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bc_0), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41d0_0), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41e8_0), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f0_0), 0x41f0, 2, { 2, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f8_0), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f9_0), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fa_0), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fb_0), 0x41fb, 2, { 2, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_4200_0), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4210_0), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4218_0), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4220_0), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4228_0), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4230_0), 0x4230, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4238_0), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4239_0), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4240_0), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4250_0), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4258_0), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4260_0), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4268_0), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4270_0), 0x4270, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4278_0), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4279_0), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4280_0), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4290_0), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4298_0), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a0_0), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a8_0), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b0_0), 0x42b0, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b8_0), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b9_0), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42c0_0), 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42d0_0), 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42d8_0), 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42e0_0), 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42e8_0), 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f0_0), 0x42f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f8_0), 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f9_0), 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4400_0), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4410_0), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4418_0), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4420_0), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4428_0), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4430_0), 0x4430, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4438_0), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4439_0), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4440_0), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4450_0), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4458_0), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4460_0), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4468_0), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4470_0), 0x4470, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4478_0), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4479_0), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4480_0), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4490_0), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4498_0), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a0_0), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a8_0), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b0_0), 0x44b0, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b8_0), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b9_0), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44c0_0), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d0_0), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d8_0), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e0_0), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e8_0), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f0_0), 0x44f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f8_0), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f9_0), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fa_0), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fb_0), 0x44fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fc_0), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4600_0), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4610_0), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4618_0), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4620_0), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4628_0), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4630_0), 0x4630, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4638_0), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4639_0), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4640_0), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4650_0), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4658_0), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4660_0), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4668_0), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4670_0), 0x4670, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4678_0), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4679_0), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4680_0), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4690_0), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4698_0), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a0_0), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a8_0), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b0_0), 0x46b0, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b8_0), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b9_0), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46c0_0), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d0_0), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d8_0), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e0_0), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e8_0), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f0_0), 0x46f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f8_0), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f9_0), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fa_0), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fb_0), 0x46fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fc_0), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4800_2), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4808_0), 0x4808, 6, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4810_2), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4818_2), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4820_2), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4828_2), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4830_2), 0x4830, 2, { 2, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4838_2), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4839_2), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4840_0), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ CPUFUNC(op_4848_0), 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
{ CPUFUNC(op_4850_0), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4868_0), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4870_0), 0x4870, 2, { 2, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4878_0), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4879_0), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487a_0), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487b_0), 0x487b, 2, { 2, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4880_0), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4890_0), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a0_0), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a8_0), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b0_0), 0x48b0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b8_0), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b9_0), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48c0_0), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_48d0_0), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e0_0), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e8_0), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f0_0), 0x48f0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f8_0), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f9_0), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_49c0_0), 0x49c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4a00_0), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a10_0), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a18_0), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a20_0), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a28_0), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a30_0), 0x4a30, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a38_0), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a39_0), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3a_0), 0x4a3a, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3b_0), 0x4a3b, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3c_0), 0x4a3c, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a40_0), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a48_0), 0x4a48, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a50_0), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a58_0), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a60_0), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a68_0), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a70_0), 0x4a70, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a78_0), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a79_0), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7a_0), 0x4a7a, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7b_0), 0x4a7b, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7c_0), 0x4a7c, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a80_0), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a88_0), 0x4a88, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a90_0), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a98_0), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa0_0), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa8_0), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab0_0), 0x4ab0, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab8_0), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab9_0), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aba_0), 0x4aba, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4abb_0), 0x4abb, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4abc_0), 0x4abc, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ac0_0), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad0_0), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad8_0), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae0_0), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae8_0), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af0_0), 0x4af0, 2, { 2, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af8_0), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af9_0), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4c00_0), 0x4c00, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c10_0), 0x4c10, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c18_0), 0x4c18, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c20_0), 0x4c20, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c28_0), 0x4c28, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c30_0), 0x4c30, 4, { 2, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c38_0), 0x4c38, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c39_0), 0x4c39, 8, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3a_0), 0x4c3a, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3b_0), 0x4c3b, 4, { 2, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3c_0), 0x4c3c, 8, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c40_0), 0x4c40, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c50_0), 0x4c50, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c58_0), 0x4c58, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c60_0), 0x4c60, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c68_0), 0x4c68, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c70_0), 0x4c70, 4, { 2, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c78_0), 0x4c78, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c79_0), 0x4c79, 8, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7a_0), 0x4c7a, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7b_0), 0x4c7b, 4, { 2, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7c_0), 0x4c7c, 8, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c90_0), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4c98_0), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ca8_0), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb0_0), 0x4cb0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb8_0), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb9_0), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cba_0), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cbb_0), 0x4cbb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd0_0), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd8_0), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ce8_0), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf0_0), 0x4cf0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf8_0), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf9_0), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfa_0), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfb_0), 0x4cfb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4e40_0), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ CPUFUNC(op_4e50_0), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4e58_0), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ CPUFUNC(op_4e60_0), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ CPUFUNC(op_4e68_0), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ CPUFUNC(op_4e70_0), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ CPUFUNC(op_4e71_0), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ CPUFUNC(op_4e72_0), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ CPUFUNC(op_4e73_0), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ CPUFUNC(op_4e74_0), 0x4e74, 4, { 0, 0 }, 1 }, /* RTD */
{ CPUFUNC(op_4e75_0), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ CPUFUNC(op_4e76_0), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ CPUFUNC(op_4e77_0), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ CPUFUNC(op_4e7a_0), 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
{ CPUFUNC(op_4e7b_0), 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
{ CPUFUNC(op_4e90_0), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ea8_0), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb0_0), 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb8_0), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb9_0), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eba_0), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ebb_0), 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ed0_0), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ee8_0), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef0_0), 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef8_0), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef9_0), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efa_0), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efb_0), 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_5000_0), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5010_0), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5018_0), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5020_0), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5028_0), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5030_0), 0x5030, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5038_0), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5039_0), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5040_0), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5048_0), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5050_0), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5058_0), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5060_0), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5068_0), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5070_0), 0x5070, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5078_0), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5079_0), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5080_0), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5088_0), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5090_0), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5098_0), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a0_0), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a8_0), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b0_0), 0x50b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b8_0), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b9_0), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50c0_0), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50c8_0), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_50d0_0), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50d8_0), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e0_0), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e8_0), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f0_0), 0x50f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f8_0), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f9_0), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50fa_0), 0x50fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_50fb_0), 0x50fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_50fc_0), 0x50fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5100_0), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5110_0), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5118_0), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5120_0), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5128_0), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5130_0), 0x5130, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5138_0), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5139_0), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5140_0), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5148_0), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5150_0), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5158_0), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5160_0), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5168_0), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5170_0), 0x5170, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5178_0), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5179_0), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5180_0), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5188_0), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5190_0), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5198_0), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a0_0), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a8_0), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b0_0), 0x51b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b8_0), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b9_0), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51c0_0), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51c8_0), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_51d0_0), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51d8_0), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e0_0), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e8_0), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f0_0), 0x51f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f8_0), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f9_0), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51fa_0), 0x51fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_51fb_0), 0x51fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_51fc_0), 0x51fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52c0_0), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c8_0), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_52d0_0), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52d8_0), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e0_0), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e8_0), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f0_0), 0x52f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f8_0), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f9_0), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52fa_0), 0x52fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52fb_0), 0x52fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52fc_0), 0x52fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53c0_0), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c8_0), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_53d0_0), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53d8_0), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e0_0), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e8_0), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f0_0), 0x53f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f8_0), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f9_0), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53fa_0), 0x53fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53fb_0), 0x53fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53fc_0), 0x53fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54c0_0), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c8_0), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_54d0_0), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54d8_0), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e0_0), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e8_0), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f0_0), 0x54f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f8_0), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f9_0), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54fa_0), 0x54fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54fb_0), 0x54fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54fc_0), 0x54fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55c0_0), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c8_0), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_55d0_0), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55d8_0), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e0_0), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e8_0), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f0_0), 0x55f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f8_0), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f9_0), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55fa_0), 0x55fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55fb_0), 0x55fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55fc_0), 0x55fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56c0_0), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c8_0), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_56d0_0), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56d8_0), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e0_0), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e8_0), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f0_0), 0x56f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f8_0), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f9_0), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56fa_0), 0x56fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56fb_0), 0x56fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56fc_0), 0x56fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57c0_0), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c8_0), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_57d0_0), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57d8_0), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e0_0), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e8_0), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f0_0), 0x57f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f8_0), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f9_0), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57fa_0), 0x57fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57fb_0), 0x57fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57fc_0), 0x57fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58c0_0), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c8_0), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_58d0_0), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58d8_0), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e0_0), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e8_0), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f0_0), 0x58f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f8_0), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f9_0), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58fa_0), 0x58fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58fb_0), 0x58fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58fc_0), 0x58fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59c0_0), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c8_0), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_59d0_0), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59d8_0), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e0_0), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e8_0), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f0_0), 0x59f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f8_0), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f9_0), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59fa_0), 0x59fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59fb_0), 0x59fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59fc_0), 0x59fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ac0_0), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac8_0), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ad0_0), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ad8_0), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae0_0), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae8_0), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af0_0), 0x5af0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af8_0), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af9_0), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5afa_0), 0x5afa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5afb_0), 0x5afb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5afc_0), 0x5afc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bc0_0), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc8_0), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5bd0_0), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bd8_0), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be0_0), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be8_0), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf0_0), 0x5bf0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf8_0), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf9_0), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bfa_0), 0x5bfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bfb_0), 0x5bfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bfc_0), 0x5bfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cc0_0), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc8_0), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5cd0_0), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cd8_0), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce0_0), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce8_0), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf0_0), 0x5cf0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf8_0), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf9_0), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cfa_0), 0x5cfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cfb_0), 0x5cfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cfc_0), 0x5cfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dc0_0), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc8_0), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5dd0_0), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dd8_0), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de0_0), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de8_0), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df0_0), 0x5df0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df8_0), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df9_0), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dfa_0), 0x5dfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dfb_0), 0x5dfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dfc_0), 0x5dfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ec0_0), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec8_0), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ed0_0), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ed8_0), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee0_0), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee8_0), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef0_0), 0x5ef0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef8_0), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef9_0), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5efa_0), 0x5efa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5efb_0), 0x5efb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5efc_0), 0x5efc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5fc0_0), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc8_0), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5fd0_0), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fd8_0), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe0_0), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe8_0), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff0_0), 0x5ff0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff8_0), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff9_0), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ffa_0), 0x5ffa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ffb_0), 0x5ffb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ffc_0), 0x5ffc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_6000_0), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6001_0), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_60ff_0), 0x60ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6100_0), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6101_0), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_61ff_0), 0x61ff, 6, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6200_0), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6201_0), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_62ff_0), 0x62ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6300_0), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6301_0), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_63ff_0), 0x63ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6400_0), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6401_0), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_64ff_0), 0x64ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6500_0), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6501_0), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_65ff_0), 0x65ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6600_0), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6601_0), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_66ff_0), 0x66ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6700_0), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6701_0), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_67ff_0), 0x67ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6800_0), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6801_0), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_68ff_0), 0x68ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6900_0), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6901_0), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_69ff_0), 0x69ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a00_0), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a01_0), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6aff_0), 0x6aff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b00_0), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b01_0), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6bff_0), 0x6bff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c00_0), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c01_0), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6cff_0), 0x6cff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d00_0), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d01_0), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6dff_0), 0x6dff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e00_0), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e01_0), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6eff_0), 0x6eff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f00_0), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f01_0), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6fff_0), 0x6fff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_7000_0), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_8000_0), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8010_0), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8018_0), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8020_0), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8028_0), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8030_0), 0x8030, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8038_0), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8039_0), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803a_0), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803b_0), 0x803b, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803c_0), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8040_0), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8050_0), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8058_0), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8060_0), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8068_0), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8070_0), 0x8070, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8078_0), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8079_0), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807a_0), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807b_0), 0x807b, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807c_0), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8080_0), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8090_0), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8098_0), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a0_0), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a8_0), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b0_0), 0x80b0, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b8_0), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b9_0), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80ba_0), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bb_0), 0x80bb, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bc_0), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80c0_0), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d0_0), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d8_0), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e0_0), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e8_0), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f0_0), 0x80f0, 2, { 2, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f8_0), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f9_0), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fa_0), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fb_0), 0x80fb, 2, { 2, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fc_0), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_8100_2), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8108_2), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8110_0), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8118_0), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8120_0), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8128_0), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8130_0), 0x8130, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8138_0), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8139_0), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8140_0), 0x8140, 4, { 0, 0 }, 0 }, /* PACK */
{ CPUFUNC(op_8148_0), 0x8148, 4, { 0, 0 }, 0 }, /* PACK */
{ CPUFUNC(op_8150_0), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8158_0), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8160_0), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8168_0), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8170_0), 0x8170, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8178_0), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8179_0), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8180_0), 0x8180, 4, { 0, 0 }, 0 }, /* UNPK */
{ CPUFUNC(op_8188_0), 0x8188, 4, { 0, 0 }, 0 }, /* UNPK */
{ CPUFUNC(op_8190_0), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8198_0), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a0_0), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a8_0), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b0_0), 0x81b0, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b8_0), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b9_0), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81c0_0), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d0_0), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d8_0), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e0_0), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e8_0), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f0_0), 0x81f0, 2, { 2, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f8_0), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f9_0), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fa_0), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fb_0), 0x81fb, 2, { 2, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fc_0), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_9000_0), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9010_0), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9018_0), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9020_0), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9028_0), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9030_0), 0x9030, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9038_0), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9039_0), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903a_0), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903b_0), 0x903b, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903c_0), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9040_0), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9048_0), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9050_0), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9058_0), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9060_0), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9068_0), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9070_0), 0x9070, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9078_0), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9079_0), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907a_0), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907b_0), 0x907b, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907c_0), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9080_0), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9088_0), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9090_0), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9098_0), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a0_0), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a8_0), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b0_0), 0x90b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b8_0), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b9_0), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90ba_0), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bb_0), 0x90bb, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bc_0), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90c0_0), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90c8_0), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d0_0), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d8_0), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e0_0), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e8_0), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f0_0), 0x90f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f8_0), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f9_0), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fa_0), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fb_0), 0x90fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fc_0), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_9100_0), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9108_0), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9110_0), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9118_0), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9120_0), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9128_0), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9130_0), 0x9130, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9138_0), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9139_0), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9140_0), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9148_0), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9150_0), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9158_0), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9160_0), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9168_0), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9170_0), 0x9170, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9178_0), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9179_0), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9180_0), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9188_0), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9190_0), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9198_0), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a0_0), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a8_0), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b0_0), 0x91b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b8_0), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b9_0), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91c0_0), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91c8_0), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d0_0), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d8_0), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e0_0), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e8_0), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f0_0), 0x91f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f8_0), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f9_0), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fa_0), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fb_0), 0x91fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fc_0), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_b000_0), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b010_0), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b018_0), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b020_0), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b028_0), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b030_0), 0xb030, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b038_0), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b039_0), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03a_0), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03b_0), 0xb03b, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03c_0), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b040_0), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b048_0), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b050_0), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b058_0), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b060_0), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b068_0), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b070_0), 0xb070, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b078_0), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b079_0), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07a_0), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07b_0), 0xb07b, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07c_0), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b080_0), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b088_0), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b090_0), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b098_0), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a0_0), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a8_0), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b0_0), 0xb0b0, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b8_0), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b9_0), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0ba_0), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bb_0), 0xb0bb, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bc_0), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0c0_0), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0c8_0), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d0_0), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d8_0), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e0_0), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e8_0), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f0_0), 0xb0f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f8_0), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f9_0), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fa_0), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fb_0), 0xb0fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fc_0), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b100_0), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b108_0), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b110_0), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b118_0), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b120_0), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b128_0), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b130_0), 0xb130, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b138_0), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b139_0), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b140_0), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b148_0), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b150_0), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b158_0), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b160_0), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b168_0), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b170_0), 0xb170, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b178_0), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b179_0), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b180_0), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b188_0), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b190_0), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b198_0), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a0_0), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a8_0), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b0_0), 0xb1b0, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b8_0), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b9_0), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1c0_0), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1c8_0), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d0_0), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d8_0), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e0_0), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e8_0), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f0_0), 0xb1f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f8_0), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f9_0), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fa_0), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fb_0), 0xb1fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fc_0), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_c000_0), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c010_0), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c018_0), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c020_0), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c028_0), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c030_0), 0xc030, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c038_0), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c039_0), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03a_0), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03b_0), 0xc03b, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03c_0), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c040_0), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c050_0), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c058_0), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c060_0), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c068_0), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c070_0), 0xc070, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c078_0), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c079_0), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07a_0), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07b_0), 0xc07b, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07c_0), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c080_0), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c090_0), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c098_0), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a0_0), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a8_0), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b0_0), 0xc0b0, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b8_0), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b9_0), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0ba_0), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bb_0), 0xc0bb, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bc_0), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0c0_0), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d0_0), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d8_0), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e0_0), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e8_0), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f0_0), 0xc0f0, 2, { 2, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f8_0), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f9_0), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fa_0), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fb_0), 0xc0fb, 2, { 2, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fc_0), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c100_2), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c108_2), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c110_0), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c118_0), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c120_0), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c128_0), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c130_0), 0xc130, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c138_0), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c139_0), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c140_0), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c148_0), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c150_0), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c158_0), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c160_0), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c168_0), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c170_0), 0xc170, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c178_0), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c179_0), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c188_0), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c190_0), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c198_0), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a0_0), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a8_0), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b0_0), 0xc1b0, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b8_0), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b9_0), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1c0_0), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d0_0), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d8_0), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e0_0), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e8_0), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f0_0), 0xc1f0, 2, { 2, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f8_0), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f9_0), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fa_0), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fb_0), 0xc1fb, 2, { 2, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fc_0), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_d000_0), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d010_0), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d018_0), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d020_0), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d028_0), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d030_0), 0xd030, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d038_0), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d039_0), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03a_0), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03b_0), 0xd03b, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03c_0), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d040_0), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d048_0), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d050_0), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d058_0), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d060_0), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d068_0), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d070_0), 0xd070, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d078_0), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d079_0), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07a_0), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07b_0), 0xd07b, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07c_0), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d080_0), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d088_0), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d090_0), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d098_0), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a0_0), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a8_0), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b0_0), 0xd0b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b8_0), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b9_0), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0ba_0), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bb_0), 0xd0bb, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bc_0), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0c0_0), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0c8_0), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d0_0), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d8_0), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e0_0), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e8_0), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f0_0), 0xd0f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f8_0), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f9_0), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fa_0), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fb_0), 0xd0fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fc_0), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d100_0), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d108_0), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d110_0), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d118_0), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d120_0), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d128_0), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d130_0), 0xd130, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d138_0), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d139_0), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d140_0), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d148_0), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d150_0), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d158_0), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d160_0), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d168_0), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d170_0), 0xd170, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d178_0), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d179_0), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d180_0), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d188_0), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d190_0), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d198_0), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a0_0), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a8_0), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b0_0), 0xd1b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b8_0), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b9_0), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1c0_0), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1c8_0), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d0_0), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d8_0), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e0_0), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e8_0), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f0_0), 0xd1f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f8_0), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f9_0), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fa_0), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fb_0), 0xd1fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fc_0), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_e000_0), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e008_0), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e010_0), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e018_0), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e020_0), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e028_0), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e030_0), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e038_0), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e040_0), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e048_0), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e050_0), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e058_0), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e060_0), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e068_0), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e070_0), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e078_0), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e080_0), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e088_0), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e090_0), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e098_0), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0a0_0), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e0a8_0), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e0b0_0), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e0b8_0), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0d0_0), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0d8_0), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e0_0), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e8_0), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f0_0), 0xe0f0, 2, { 2, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f8_0), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f9_0), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e100_0), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e108_0), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e110_0), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e118_0), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e120_0), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e128_0), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e130_0), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e138_0), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e140_0), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e148_0), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e150_0), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e158_0), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e160_0), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e168_0), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e170_0), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e178_0), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e180_0), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e188_0), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e190_0), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e198_0), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1a0_0), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e1a8_0), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e1b0_0), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e1b8_0), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1d0_0), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1d8_0), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e0_0), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e8_0), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f0_0), 0xe1f0, 2, { 2, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f8_0), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f9_0), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e2d0_0), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2d8_0), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e0_0), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e8_0), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f0_0), 0xe2f0, 2, { 2, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f8_0), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f9_0), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e3d0_0), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3d8_0), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e0_0), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e8_0), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f0_0), 0xe3f0, 2, { 2, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f8_0), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f9_0), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e4d0_0), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4d8_0), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e0_0), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e8_0), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f0_0), 0xe4f0, 2, { 2, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f8_0), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f9_0), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e5d0_0), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5d8_0), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e0_0), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e8_0), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f0_0), 0xe5f0, 2, { 2, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f8_0), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f9_0), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e6d0_0), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6d8_0), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e0_0), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e8_0), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f0_0), 0xe6f0, 2, { 2, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f8_0), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f9_0), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e7d0_0), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7d8_0), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e0_0), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e8_0), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f0_0), 0xe7f0, 2, { 2, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f8_0), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f9_0), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e8c0_0), 0xe8c0, 4, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8d0_0), 0xe8d0, 4, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8e8_0), 0xe8e8, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f0_0), 0xe8f0, 4, { 2, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f8_0), 0xe8f8, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f9_0), 0xe8f9, 8, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8fa_0), 0xe8fa, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8fb_0), 0xe8fb, 4, { 2, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e9c0_0), 0xe9c0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9d0_0), 0xe9d0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9e8_0), 0xe9e8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f0_0), 0xe9f0, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f8_0), 0xe9f8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f9_0), 0xe9f9, 8, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9fa_0), 0xe9fa, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9fb_0), 0xe9fb, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_eac0_0), 0xeac0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_ead0_0), 0xead0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eae8_0), 0xeae8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf0_0), 0xeaf0, 4, { 2, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf8_0), 0xeaf8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf9_0), 0xeaf9, 8, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_ebc0_0), 0xebc0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebd0_0), 0xebd0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebe8_0), 0xebe8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf0_0), 0xebf0, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf8_0), 0xebf8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf9_0), 0xebf9, 8, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebfa_0), 0xebfa, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebfb_0), 0xebfb, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ecc0_0), 0xecc0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecd0_0), 0xecd0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ece8_0), 0xece8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf0_0), 0xecf0, 4, { 2, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf8_0), 0xecf8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf9_0), 0xecf9, 8, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_edc0_0), 0xedc0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edd0_0), 0xedd0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_ede8_0), 0xede8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf0_0), 0xedf0, 4, { 2, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf8_0), 0xedf8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf9_0), 0xedf9, 8, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edfa_0), 0xedfa, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edfb_0), 0xedfb, 4, { 2, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_eec0_0), 0xeec0, 4, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eed0_0), 0xeed0, 4, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eee8_0), 0xeee8, 6, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef0_0), 0xeef0, 4, { 2, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef8_0), 0xeef8, 6, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef9_0), 0xeef9, 8, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_efc0_0), 0xefc0, 4, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_efd0_0), 0xefd0, 4, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_efe8_0), 0xefe8, 6, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff0_0), 0xeff0, 4, { 2, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff8_0), 0xeff8, 6, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff9_0), 0xeff9, 8, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_f000_0), 0xf000, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f008_0), 0xf008, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f010_0), 0xf010, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f018_0), 0xf018, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f020_0), 0xf020, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f028_0), 0xf028, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f030_0), 0xf030, -1, { -3, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f038_0), 0xf038, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f039_0), 0xf039, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ CPUFUNC(op_f200_0), 0xf200, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f208_0), 0xf208, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f210_0), 0xf210, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f218_0), 0xf218, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f220_0), 0xf220, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f228_0), 0xf228, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f230_0), 0xf230, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f238_0), 0xf238, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f239_0), 0xf239, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23a_0), 0xf23a, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23b_0), 0xf23b, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23c_0), 0xf23c, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f240_0), 0xf240, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f248_0), 0xf248, -1, { 0, 0 }, 0 }, /* FDBcc */
{ CPUFUNC(op_f250_0), 0xf250, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f258_0), 0xf258, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f260_0), 0xf260, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f268_0), 0xf268, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f270_0), 0xf270, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f278_0), 0xf278, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f279_0), 0xf279, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f27a_0), 0xf27a, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f27b_0), 0xf27b, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f27c_0), 0xf27c, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f280_0), 0xf280, -1, { 0, 0 }, 0 }, /* FBcc */
{ CPUFUNC(op_f2c0_0), 0xf2c0, -1, { 0, 0 }, 0 }, /* FBcc */
{ CPUFUNC(op_f310_0), 0xf310, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f320_0), 0xf320, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f328_0), 0xf328, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f330_0), 0xf330, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f338_0), 0xf338, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f339_0), 0xf339, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f350_0), 0xf350, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f358_0), 0xf358, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f368_0), 0xf368, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f370_0), 0xf370, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f378_0), 0xf378, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f379_0), 0xf379, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f37a_0), 0xf37a, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f37b_0), 0xf37b, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ 0, 0 }};
#endif /* CPUEMU_68000_ONLY */
#endif /* CPUEMU_0 */
#ifdef CPUEMU_0
#ifndef CPUEMU_68000_ONLY
const struct cputbl CPUFUNC(op_smalltbl_3)[] = {
{ CPUFUNC(op_0000_0), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0010_0), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0018_0), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0020_0), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0028_0), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0030_0), 0x0030, 4, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0038_0), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0039_0), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_003c_0), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0040_0), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0050_0), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0058_0), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0060_0), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0068_0), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0070_0), 0x0070, 4, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0078_0), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0079_0), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_007c_0), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0080_0), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0090_0), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0098_0), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a0_0), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a8_0), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b0_0), 0x00b0, 6, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b8_0), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b9_0), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00d0_0), 0x00d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00e8_0), 0x00e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f0_0), 0x00f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f8_0), 0x00f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00f9_0), 0x00f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00fa_0), 0x00fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_00fb_0), 0x00fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0100_0), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0108_0), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0110_0), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0118_0), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0120_0), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0128_0), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0130_0), 0x0130, 2, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0138_0), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0139_0), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013a_0), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013b_0), 0x013b, 2, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013c_0), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0140_0), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0148_0), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0150_0), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0158_0), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0160_0), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0168_0), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0170_0), 0x0170, 2, { 2, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0178_0), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0179_0), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0180_0), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0188_0), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_0190_0), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0198_0), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a0_0), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a8_0), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b0_0), 0x01b0, 2, { 2, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b8_0), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b9_0), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01c0_0), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01c8_0), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_01d0_0), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01d8_0), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e0_0), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e8_0), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f0_0), 0x01f0, 2, { 2, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f8_0), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f9_0), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0200_0), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0210_0), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0218_0), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0220_0), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0228_0), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0230_0), 0x0230, 4, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0238_0), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0239_0), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_023c_0), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0240_0), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0250_0), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0258_0), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0260_0), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0268_0), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0270_0), 0x0270, 4, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0278_0), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0279_0), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_027c_0), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0280_0), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0290_0), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0298_0), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a0_0), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a8_0), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b0_0), 0x02b0, 6, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b8_0), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b9_0), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02d0_0), 0x02d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02e8_0), 0x02e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f0_0), 0x02f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f8_0), 0x02f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02f9_0), 0x02f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02fa_0), 0x02fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_02fb_0), 0x02fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0400_0), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0410_0), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0418_0), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0420_0), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0428_0), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0430_0), 0x0430, 4, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0438_0), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0439_0), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0440_0), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0450_0), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0458_0), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0460_0), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0468_0), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0470_0), 0x0470, 4, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0478_0), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0479_0), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0480_0), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0490_0), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0498_0), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a0_0), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a8_0), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b0_0), 0x04b0, 6, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b8_0), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b9_0), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04d0_0), 0x04d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04e8_0), 0x04e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f0_0), 0x04f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f8_0), 0x04f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04f9_0), 0x04f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04fa_0), 0x04fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_04fb_0), 0x04fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ CPUFUNC(op_0600_0), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0610_0), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0618_0), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0620_0), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0628_0), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0630_0), 0x0630, 4, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0638_0), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0639_0), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0640_0), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0650_0), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0658_0), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0660_0), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0668_0), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0670_0), 0x0670, 4, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0678_0), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0679_0), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0680_0), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0690_0), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0698_0), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a0_0), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a8_0), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b0_0), 0x06b0, 6, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b8_0), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b9_0), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06c0_0), 0x06c0, 2, { 0, 0 }, 0 }, /* RTM */
{ CPUFUNC(op_06c8_0), 0x06c8, 2, { 0, 0 }, 0 }, /* RTM */
{ CPUFUNC(op_06d0_0), 0x06d0, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06e8_0), 0x06e8, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f0_0), 0x06f0, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f8_0), 0x06f8, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06f9_0), 0x06f9, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06fa_0), 0x06fa, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_06fb_0), 0x06fb, 2, { 0, 0 }, 0 }, /* CALLM */
{ CPUFUNC(op_0800_0), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0810_0), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0818_0), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0820_0), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0828_0), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0830_0), 0x0830, 4, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0838_0), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0839_0), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083a_0), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083b_0), 0x083b, 4, { 2, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0840_0), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0850_0), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0858_0), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0860_0), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0868_0), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0870_0), 0x0870, 4, { 2, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0878_0), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0879_0), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0880_0), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0890_0), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0898_0), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a0_0), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a8_0), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b0_0), 0x08b0, 4, { 2, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b8_0), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b9_0), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08c0_0), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d0_0), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d8_0), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e0_0), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e8_0), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f0_0), 0x08f0, 4, { 2, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f8_0), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f9_0), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0a00_0), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a10_0), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a18_0), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a20_0), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a28_0), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a30_0), 0x0a30, 4, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a38_0), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a39_0), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a3c_0), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a40_0), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a50_0), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a58_0), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a60_0), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a68_0), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a70_0), 0x0a70, 4, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a78_0), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a79_0), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a7c_0), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a80_0), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a90_0), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a98_0), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa0_0), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa8_0), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab0_0), 0x0ab0, 6, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab8_0), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab9_0), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ad0_0), 0x0ad0, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ad8_0), 0x0ad8, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ae0_0), 0x0ae0, 4, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ae8_0), 0x0ae8, 6, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af0_0), 0x0af0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af8_0), 0x0af8, 6, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0af9_0), 0x0af9, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0c00_0), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c10_0), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c18_0), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c20_0), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c28_0), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c30_0), 0x0c30, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c38_0), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c39_0), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c3a_0), 0x0c3a, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c3b_0), 0x0c3b, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c40_0), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c50_0), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c58_0), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c60_0), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c68_0), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c70_0), 0x0c70, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c78_0), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c79_0), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c7a_0), 0x0c7a, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c7b_0), 0x0c7b, 4, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c80_0), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c90_0), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c98_0), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca0_0), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca8_0), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb0_0), 0x0cb0, 6, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb8_0), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb9_0), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cba_0), 0x0cba, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cbb_0), 0x0cbb, 6, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cd0_0), 0x0cd0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cd8_0), 0x0cd8, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ce0_0), 0x0ce0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ce8_0), 0x0ce8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf0_0), 0x0cf0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf8_0), 0x0cf8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cf9_0), 0x0cf9, 16, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0cfc_0), 0x0cfc, 6, { 0, 0 }, 0 }, /* CAS2 */
{ CPUFUNC(op_0e10_0), 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e18_0), 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e20_0), 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e28_0), 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e30_0), 0x0e30, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e38_0), 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e39_0), 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e50_0), 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e58_0), 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e60_0), 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e68_0), 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e70_0), 0x0e70, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e78_0), 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e79_0), 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e90_0), 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0e98_0), 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ea0_0), 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ea8_0), 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb0_0), 0x0eb0, 8, { 6, 2 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb8_0), 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0eb9_0), 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
{ CPUFUNC(op_0ed0_0), 0x0ed0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ed8_0), 0x0ed8, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ee0_0), 0x0ee0, 8, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ee8_0), 0x0ee8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef0_0), 0x0ef0, 4, { 2, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef8_0), 0x0ef8, 12, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0ef9_0), 0x0ef9, 16, { 0, 0 }, 0 }, /* CAS */
{ CPUFUNC(op_0efc_0), 0x0efc, 6, { 0, 0 }, 0 }, /* CAS2 */
{ CPUFUNC(op_1000_0), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1010_0), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1018_0), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1020_0), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1028_0), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1030_0), 0x1030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1038_0), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1039_0), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103a_0), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103b_0), 0x103b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103c_0), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1080_0), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1090_0), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1098_0), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a0_0), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a8_0), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b0_0), 0x10b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b8_0), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b9_0), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10ba_0), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bb_0), 0x10bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bc_0), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10c0_0), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d0_0), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d8_0), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e0_0), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e8_0), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f0_0), 0x10f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f8_0), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f9_0), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fa_0), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fb_0), 0x10fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fc_0), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1100_0), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1110_0), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1118_0), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1120_0), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1128_0), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1130_0), 0x1130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1138_0), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1139_0), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113a_0), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113b_0), 0x113b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113c_0), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1140_0), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1150_0), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1158_0), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1160_0), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1168_0), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1170_0), 0x1170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1178_0), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1179_0), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117a_0), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117b_0), 0x117b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117c_0), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1180_0), 0x1180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1190_0), 0x1190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1198_0), 0x1198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a0_0), 0x11a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a8_0), 0x11a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b0_0), 0x11b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b8_0), 0x11b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b9_0), 0x11b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11ba_0), 0x11ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bb_0), 0x11bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bc_0), 0x11bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11c0_0), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d0_0), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d8_0), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e0_0), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e8_0), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f0_0), 0x11f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f8_0), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f9_0), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fa_0), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fb_0), 0x11fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fc_0), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13c0_0), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d0_0), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d8_0), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e0_0), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e8_0), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f0_0), 0x13f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f8_0), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f9_0), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fa_0), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fb_0), 0x13fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fc_0), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2000_0), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2008_0), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2010_0), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2018_0), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2020_0), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2028_0), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2030_0), 0x2030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2038_0), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2039_0), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203a_0), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203b_0), 0x203b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203c_0), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2040_0), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2048_0), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2050_0), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2058_0), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2060_0), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2068_0), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2070_0), 0x2070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2078_0), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2079_0), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207a_0), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207b_0), 0x207b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207c_0), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2080_0), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2088_0), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2090_0), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2098_0), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a0_0), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a8_0), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b0_0), 0x20b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b8_0), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b9_0), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20ba_0), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bb_0), 0x20bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bc_0), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c0_0), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c8_0), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d0_0), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d8_0), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e0_0), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e8_0), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f0_0), 0x20f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f8_0), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f9_0), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fa_0), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fb_0), 0x20fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fc_0), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2100_0), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2108_0), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2110_0), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2118_0), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2120_0), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2128_0), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2130_0), 0x2130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2138_0), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2139_0), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213a_0), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213b_0), 0x213b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213c_0), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2140_0), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2148_0), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2150_0), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2158_0), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2160_0), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2168_0), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2170_0), 0x2170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2178_0), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2179_0), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217a_0), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217b_0), 0x217b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217c_0), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2180_0), 0x2180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2188_0), 0x2188, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2190_0), 0x2190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2198_0), 0x2198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a0_0), 0x21a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a8_0), 0x21a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b0_0), 0x21b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b8_0), 0x21b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b9_0), 0x21b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21ba_0), 0x21ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bb_0), 0x21bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bc_0), 0x21bc, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c0_0), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c8_0), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d0_0), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d8_0), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e0_0), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e8_0), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f0_0), 0x21f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f8_0), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f9_0), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fa_0), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fb_0), 0x21fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fc_0), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c0_0), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c8_0), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d0_0), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d8_0), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e0_0), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e8_0), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f0_0), 0x23f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f8_0), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f9_0), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fa_0), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fb_0), 0x23fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fc_0), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3000_0), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3008_0), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3010_0), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3018_0), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3020_0), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3028_0), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3030_0), 0x3030, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3038_0), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3039_0), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303a_0), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303b_0), 0x303b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303c_0), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3040_0), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3048_0), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3050_0), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3058_0), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3060_0), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3068_0), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3070_0), 0x3070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3078_0), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3079_0), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307a_0), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307b_0), 0x307b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307c_0), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3080_0), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3088_0), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3090_0), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3098_0), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a0_0), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a8_0), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b0_0), 0x30b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b8_0), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b9_0), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30ba_0), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bb_0), 0x30bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bc_0), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c0_0), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c8_0), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d0_0), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d8_0), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e0_0), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e8_0), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f0_0), 0x30f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f8_0), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f9_0), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fa_0), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fb_0), 0x30fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fc_0), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3100_0), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3108_0), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3110_0), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3118_0), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3120_0), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3128_0), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3130_0), 0x3130, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3138_0), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3139_0), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313a_0), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313b_0), 0x313b, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313c_0), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3140_0), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3148_0), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3150_0), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3158_0), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3160_0), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3168_0), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3170_0), 0x3170, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3178_0), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3179_0), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317a_0), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317b_0), 0x317b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317c_0), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3180_0), 0x3180, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3188_0), 0x3188, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3190_0), 0x3190, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3198_0), 0x3198, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a0_0), 0x31a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a8_0), 0x31a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b0_0), 0x31b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b8_0), 0x31b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b9_0), 0x31b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31ba_0), 0x31ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bb_0), 0x31bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bc_0), 0x31bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c0_0), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c8_0), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d0_0), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d8_0), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e0_0), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e8_0), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f0_0), 0x31f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f8_0), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f9_0), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fa_0), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fb_0), 0x31fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fc_0), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c0_0), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c8_0), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d0_0), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d8_0), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e0_0), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e8_0), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f0_0), 0x33f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f8_0), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f9_0), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fa_0), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fb_0), 0x33fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fc_0), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_4000_0), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4010_0), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4018_0), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4020_0), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4028_0), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4030_0), 0x4030, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4038_0), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4039_0), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4040_0), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4050_0), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4058_0), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4060_0), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4068_0), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4070_0), 0x4070, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4078_0), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4079_0), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4080_0), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4090_0), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4098_0), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a0_0), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a8_0), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b0_0), 0x40b0, 2, { 2, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b8_0), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b9_0), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40c0_0), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d0_0), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d8_0), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e0_0), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e8_0), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f0_0), 0x40f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f8_0), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f9_0), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4100_0), 0x4100, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4110_0), 0x4110, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4118_0), 0x4118, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4120_0), 0x4120, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4128_0), 0x4128, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4130_0), 0x4130, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4138_0), 0x4138, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4139_0), 0x4139, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413a_0), 0x413a, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413b_0), 0x413b, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_413c_0), 0x413c, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4180_0), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4190_0), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4198_0), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a0_0), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a8_0), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b0_0), 0x41b0, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b8_0), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b9_0), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41ba_0), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bb_0), 0x41bb, 2, { 2, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bc_0), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41d0_0), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41e8_0), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f0_0), 0x41f0, 2, { 2, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f8_0), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f9_0), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fa_0), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fb_0), 0x41fb, 2, { 2, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_4200_0), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4210_0), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4218_0), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4220_0), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4228_0), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4230_0), 0x4230, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4238_0), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4239_0), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4240_0), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4250_0), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4258_0), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4260_0), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4268_0), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4270_0), 0x4270, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4278_0), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4279_0), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4280_0), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4290_0), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4298_0), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a0_0), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a8_0), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b0_0), 0x42b0, 2, { 2, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b8_0), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b9_0), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42c0_0), 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42d0_0), 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42d8_0), 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42e0_0), 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42e8_0), 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f0_0), 0x42f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f8_0), 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f9_0), 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4400_0), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4410_0), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4418_0), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4420_0), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4428_0), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4430_0), 0x4430, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4438_0), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4439_0), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4440_0), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4450_0), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4458_0), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4460_0), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4468_0), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4470_0), 0x4470, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4478_0), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4479_0), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4480_0), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4490_0), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4498_0), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a0_0), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a8_0), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b0_0), 0x44b0, 2, { 2, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b8_0), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b9_0), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44c0_0), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d0_0), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d8_0), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e0_0), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e8_0), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f0_0), 0x44f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f8_0), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f9_0), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fa_0), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fb_0), 0x44fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fc_0), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4600_0), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4610_0), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4618_0), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4620_0), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4628_0), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4630_0), 0x4630, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4638_0), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4639_0), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4640_0), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4650_0), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4658_0), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4660_0), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4668_0), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4670_0), 0x4670, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4678_0), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4679_0), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4680_0), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4690_0), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4698_0), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a0_0), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a8_0), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b0_0), 0x46b0, 2, { 2, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b8_0), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b9_0), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46c0_0), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d0_0), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d8_0), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e0_0), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e8_0), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f0_0), 0x46f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f8_0), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f9_0), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fa_0), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fb_0), 0x46fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fc_0), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4800_2), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4808_0), 0x4808, 6, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4810_2), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4818_2), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4820_2), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4828_2), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4830_2), 0x4830, 2, { 2, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4838_2), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4839_2), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4840_0), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ CPUFUNC(op_4848_0), 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
{ CPUFUNC(op_4850_0), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4868_0), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4870_0), 0x4870, 2, { 2, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4878_0), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4879_0), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487a_0), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487b_0), 0x487b, 2, { 2, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4880_0), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4890_0), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a0_0), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a8_0), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b0_0), 0x48b0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b8_0), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b9_0), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48c0_0), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_48d0_0), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e0_0), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e8_0), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f0_0), 0x48f0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f8_0), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f9_0), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_49c0_0), 0x49c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4a00_0), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a10_0), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a18_0), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a20_0), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a28_0), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a30_0), 0x4a30, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a38_0), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a39_0), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3a_0), 0x4a3a, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3b_0), 0x4a3b, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a3c_0), 0x4a3c, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a40_0), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a48_0), 0x4a48, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a50_0), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a58_0), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a60_0), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a68_0), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a70_0), 0x4a70, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a78_0), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a79_0), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7a_0), 0x4a7a, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7b_0), 0x4a7b, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a7c_0), 0x4a7c, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a80_0), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a88_0), 0x4a88, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a90_0), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a98_0), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa0_0), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa8_0), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab0_0), 0x4ab0, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab8_0), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab9_0), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aba_0), 0x4aba, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4abb_0), 0x4abb, 2, { 2, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4abc_0), 0x4abc, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ac0_0), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad0_0), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad8_0), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae0_0), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae8_0), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af0_0), 0x4af0, 2, { 2, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af8_0), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af9_0), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4c00_0), 0x4c00, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c10_0), 0x4c10, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c18_0), 0x4c18, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c20_0), 0x4c20, 4, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c28_0), 0x4c28, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c30_0), 0x4c30, 4, { 2, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c38_0), 0x4c38, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c39_0), 0x4c39, 8, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3a_0), 0x4c3a, 6, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3b_0), 0x4c3b, 4, { 2, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c3c_0), 0x4c3c, 8, { 0, 0 }, 0 }, /* MULL */
{ CPUFUNC(op_4c40_0), 0x4c40, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c50_0), 0x4c50, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c58_0), 0x4c58, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c60_0), 0x4c60, 4, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c68_0), 0x4c68, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c70_0), 0x4c70, 4, { 2, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c78_0), 0x4c78, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c79_0), 0x4c79, 8, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7a_0), 0x4c7a, 6, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7b_0), 0x4c7b, 4, { 2, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c7c_0), 0x4c7c, 8, { 0, 0 }, 0 }, /* DIVL */
{ CPUFUNC(op_4c90_0), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4c98_0), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ca8_0), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb0_0), 0x4cb0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb8_0), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb9_0), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cba_0), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cbb_0), 0x4cbb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd0_0), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd8_0), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ce8_0), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf0_0), 0x4cf0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf8_0), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf9_0), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfa_0), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfb_0), 0x4cfb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4e40_0), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ CPUFUNC(op_4e50_0), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4e58_0), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ CPUFUNC(op_4e60_0), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ CPUFUNC(op_4e68_0), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ CPUFUNC(op_4e70_0), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ CPUFUNC(op_4e71_0), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ CPUFUNC(op_4e72_0), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ CPUFUNC(op_4e73_0), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ CPUFUNC(op_4e74_0), 0x4e74, 4, { 0, 0 }, 1 }, /* RTD */
{ CPUFUNC(op_4e75_0), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ CPUFUNC(op_4e76_0), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ CPUFUNC(op_4e77_0), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ CPUFUNC(op_4e7a_0), 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
{ CPUFUNC(op_4e7b_0), 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
{ CPUFUNC(op_4e90_0), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ea8_0), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb0_0), 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb8_0), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb9_0), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eba_0), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ebb_0), 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ed0_0), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ee8_0), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef0_0), 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef8_0), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef9_0), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efa_0), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efb_0), 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_5000_0), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5010_0), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5018_0), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5020_0), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5028_0), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5030_0), 0x5030, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5038_0), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5039_0), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5040_0), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5048_0), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5050_0), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5058_0), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5060_0), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5068_0), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5070_0), 0x5070, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5078_0), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5079_0), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5080_0), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5088_0), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5090_0), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5098_0), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a0_0), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a8_0), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b0_0), 0x50b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b8_0), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b9_0), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50c0_0), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50c8_0), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_50d0_0), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50d8_0), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e0_0), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e8_0), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f0_0), 0x50f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f8_0), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f9_0), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50fa_0), 0x50fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_50fb_0), 0x50fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_50fc_0), 0x50fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5100_0), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5110_0), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5118_0), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5120_0), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5128_0), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5130_0), 0x5130, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5138_0), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5139_0), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5140_0), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5148_0), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5150_0), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5158_0), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5160_0), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5168_0), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5170_0), 0x5170, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5178_0), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5179_0), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5180_0), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5188_0), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5190_0), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5198_0), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a0_0), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a8_0), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b0_0), 0x51b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b8_0), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b9_0), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51c0_0), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51c8_0), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_51d0_0), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51d8_0), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e0_0), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e8_0), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f0_0), 0x51f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f8_0), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f9_0), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51fa_0), 0x51fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_51fb_0), 0x51fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_51fc_0), 0x51fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52c0_0), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c8_0), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_52d0_0), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52d8_0), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e0_0), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e8_0), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f0_0), 0x52f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f8_0), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f9_0), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52fa_0), 0x52fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52fb_0), 0x52fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_52fc_0), 0x52fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53c0_0), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c8_0), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_53d0_0), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53d8_0), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e0_0), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e8_0), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f0_0), 0x53f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f8_0), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f9_0), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53fa_0), 0x53fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53fb_0), 0x53fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_53fc_0), 0x53fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54c0_0), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c8_0), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_54d0_0), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54d8_0), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e0_0), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e8_0), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f0_0), 0x54f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f8_0), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f9_0), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54fa_0), 0x54fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54fb_0), 0x54fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_54fc_0), 0x54fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55c0_0), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c8_0), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_55d0_0), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55d8_0), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e0_0), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e8_0), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f0_0), 0x55f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f8_0), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f9_0), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55fa_0), 0x55fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55fb_0), 0x55fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_55fc_0), 0x55fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56c0_0), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c8_0), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_56d0_0), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56d8_0), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e0_0), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e8_0), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f0_0), 0x56f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f8_0), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f9_0), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56fa_0), 0x56fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56fb_0), 0x56fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_56fc_0), 0x56fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57c0_0), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c8_0), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_57d0_0), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57d8_0), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e0_0), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e8_0), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f0_0), 0x57f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f8_0), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f9_0), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57fa_0), 0x57fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57fb_0), 0x57fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_57fc_0), 0x57fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58c0_0), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c8_0), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_58d0_0), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58d8_0), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e0_0), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e8_0), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f0_0), 0x58f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f8_0), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f9_0), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58fa_0), 0x58fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58fb_0), 0x58fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_58fc_0), 0x58fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59c0_0), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c8_0), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_59d0_0), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59d8_0), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e0_0), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e8_0), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f0_0), 0x59f0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f8_0), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f9_0), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59fa_0), 0x59fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59fb_0), 0x59fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_59fc_0), 0x59fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ac0_0), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac8_0), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ad0_0), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ad8_0), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae0_0), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae8_0), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af0_0), 0x5af0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af8_0), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af9_0), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5afa_0), 0x5afa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5afb_0), 0x5afb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5afc_0), 0x5afc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bc0_0), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc8_0), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5bd0_0), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bd8_0), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be0_0), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be8_0), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf0_0), 0x5bf0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf8_0), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf9_0), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bfa_0), 0x5bfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bfb_0), 0x5bfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5bfc_0), 0x5bfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cc0_0), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc8_0), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5cd0_0), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cd8_0), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce0_0), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce8_0), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf0_0), 0x5cf0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf8_0), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf9_0), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cfa_0), 0x5cfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cfb_0), 0x5cfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5cfc_0), 0x5cfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dc0_0), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc8_0), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5dd0_0), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dd8_0), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de0_0), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de8_0), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df0_0), 0x5df0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df8_0), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df9_0), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dfa_0), 0x5dfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dfb_0), 0x5dfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5dfc_0), 0x5dfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ec0_0), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec8_0), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ed0_0), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ed8_0), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee0_0), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee8_0), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef0_0), 0x5ef0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef8_0), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef9_0), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5efa_0), 0x5efa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5efb_0), 0x5efb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5efc_0), 0x5efc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5fc0_0), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc8_0), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5fd0_0), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fd8_0), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe0_0), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe8_0), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff0_0), 0x5ff0, 2, { 2, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff8_0), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff9_0), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ffa_0), 0x5ffa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ffb_0), 0x5ffb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_5ffc_0), 0x5ffc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ CPUFUNC(op_6000_0), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6001_0), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_60ff_0), 0x60ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6100_0), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6101_0), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_61ff_0), 0x61ff, 6, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6200_0), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6201_0), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_62ff_0), 0x62ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6300_0), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6301_0), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_63ff_0), 0x63ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6400_0), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6401_0), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_64ff_0), 0x64ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6500_0), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6501_0), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_65ff_0), 0x65ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6600_0), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6601_0), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_66ff_0), 0x66ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6700_0), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6701_0), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_67ff_0), 0x67ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6800_0), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6801_0), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_68ff_0), 0x68ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6900_0), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6901_0), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_69ff_0), 0x69ff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a00_0), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a01_0), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6aff_0), 0x6aff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b00_0), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b01_0), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6bff_0), 0x6bff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c00_0), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c01_0), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6cff_0), 0x6cff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d00_0), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d01_0), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6dff_0), 0x6dff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e00_0), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e01_0), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6eff_0), 0x6eff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f00_0), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f01_0), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6fff_0), 0x6fff, 6, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_7000_0), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_8000_0), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8010_0), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8018_0), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8020_0), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8028_0), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8030_0), 0x8030, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8038_0), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8039_0), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803a_0), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803b_0), 0x803b, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803c_0), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8040_0), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8050_0), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8058_0), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8060_0), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8068_0), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8070_0), 0x8070, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8078_0), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8079_0), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807a_0), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807b_0), 0x807b, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807c_0), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8080_0), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8090_0), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8098_0), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a0_0), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a8_0), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b0_0), 0x80b0, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b8_0), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b9_0), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80ba_0), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bb_0), 0x80bb, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bc_0), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80c0_0), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d0_0), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d8_0), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e0_0), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e8_0), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f0_0), 0x80f0, 2, { 2, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f8_0), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f9_0), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fa_0), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fb_0), 0x80fb, 2, { 2, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fc_0), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_8100_2), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8108_2), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8110_0), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8118_0), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8120_0), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8128_0), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8130_0), 0x8130, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8138_0), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8139_0), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8140_0), 0x8140, 4, { 0, 0 }, 0 }, /* PACK */
{ CPUFUNC(op_8148_0), 0x8148, 4, { 0, 0 }, 0 }, /* PACK */
{ CPUFUNC(op_8150_0), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8158_0), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8160_0), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8168_0), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8170_0), 0x8170, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8178_0), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8179_0), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8180_0), 0x8180, 4, { 0, 0 }, 0 }, /* UNPK */
{ CPUFUNC(op_8188_0), 0x8188, 4, { 0, 0 }, 0 }, /* UNPK */
{ CPUFUNC(op_8190_0), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8198_0), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a0_0), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a8_0), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b0_0), 0x81b0, 2, { 2, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b8_0), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b9_0), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81c0_0), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d0_0), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d8_0), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e0_0), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e8_0), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f0_0), 0x81f0, 2, { 2, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f8_0), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f9_0), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fa_0), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fb_0), 0x81fb, 2, { 2, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fc_0), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_9000_0), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9010_0), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9018_0), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9020_0), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9028_0), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9030_0), 0x9030, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9038_0), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9039_0), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903a_0), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903b_0), 0x903b, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903c_0), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9040_0), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9048_0), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9050_0), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9058_0), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9060_0), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9068_0), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9070_0), 0x9070, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9078_0), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9079_0), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907a_0), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907b_0), 0x907b, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907c_0), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9080_0), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9088_0), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9090_0), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9098_0), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a0_0), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a8_0), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b0_0), 0x90b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b8_0), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b9_0), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90ba_0), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bb_0), 0x90bb, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bc_0), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90c0_0), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90c8_0), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d0_0), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d8_0), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e0_0), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e8_0), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f0_0), 0x90f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f8_0), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f9_0), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fa_0), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fb_0), 0x90fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fc_0), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_9100_0), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9108_0), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9110_0), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9118_0), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9120_0), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9128_0), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9130_0), 0x9130, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9138_0), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9139_0), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9140_0), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9148_0), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9150_0), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9158_0), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9160_0), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9168_0), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9170_0), 0x9170, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9178_0), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9179_0), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9180_0), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9188_0), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9190_0), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9198_0), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a0_0), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a8_0), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b0_0), 0x91b0, 2, { 2, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b8_0), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b9_0), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91c0_0), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91c8_0), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d0_0), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d8_0), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e0_0), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e8_0), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f0_0), 0x91f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f8_0), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f9_0), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fa_0), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fb_0), 0x91fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fc_0), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_b000_0), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b010_0), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b018_0), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b020_0), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b028_0), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b030_0), 0xb030, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b038_0), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b039_0), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03a_0), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03b_0), 0xb03b, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03c_0), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b040_0), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b048_0), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b050_0), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b058_0), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b060_0), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b068_0), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b070_0), 0xb070, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b078_0), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b079_0), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07a_0), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07b_0), 0xb07b, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07c_0), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b080_0), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b088_0), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b090_0), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b098_0), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a0_0), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a8_0), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b0_0), 0xb0b0, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b8_0), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b9_0), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0ba_0), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bb_0), 0xb0bb, 2, { 2, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bc_0), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0c0_0), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0c8_0), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d0_0), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d8_0), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e0_0), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e8_0), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f0_0), 0xb0f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f8_0), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f9_0), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fa_0), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fb_0), 0xb0fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fc_0), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b100_0), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b108_0), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b110_0), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b118_0), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b120_0), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b128_0), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b130_0), 0xb130, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b138_0), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b139_0), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b140_0), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b148_0), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b150_0), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b158_0), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b160_0), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b168_0), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b170_0), 0xb170, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b178_0), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b179_0), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b180_0), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b188_0), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b190_0), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b198_0), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a0_0), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a8_0), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b0_0), 0xb1b0, 2, { 2, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b8_0), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b9_0), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1c0_0), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1c8_0), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d0_0), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d8_0), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e0_0), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e8_0), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f0_0), 0xb1f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f8_0), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f9_0), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fa_0), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fb_0), 0xb1fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fc_0), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_c000_0), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c010_0), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c018_0), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c020_0), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c028_0), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c030_0), 0xc030, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c038_0), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c039_0), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03a_0), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03b_0), 0xc03b, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03c_0), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c040_0), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c050_0), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c058_0), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c060_0), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c068_0), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c070_0), 0xc070, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c078_0), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c079_0), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07a_0), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07b_0), 0xc07b, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07c_0), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c080_0), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c090_0), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c098_0), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a0_0), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a8_0), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b0_0), 0xc0b0, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b8_0), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b9_0), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0ba_0), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bb_0), 0xc0bb, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bc_0), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0c0_0), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d0_0), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d8_0), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e0_0), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e8_0), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f0_0), 0xc0f0, 2, { 2, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f8_0), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f9_0), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fa_0), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fb_0), 0xc0fb, 2, { 2, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fc_0), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c100_2), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c108_2), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c110_0), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c118_0), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c120_0), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c128_0), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c130_0), 0xc130, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c138_0), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c139_0), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c140_0), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c148_0), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c150_0), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c158_0), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c160_0), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c168_0), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c170_0), 0xc170, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c178_0), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c179_0), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c188_0), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c190_0), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c198_0), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a0_0), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a8_0), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b0_0), 0xc1b0, 2, { 2, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b8_0), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b9_0), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1c0_0), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d0_0), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d8_0), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e0_0), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e8_0), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f0_0), 0xc1f0, 2, { 2, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f8_0), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f9_0), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fa_0), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fb_0), 0xc1fb, 2, { 2, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fc_0), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_d000_0), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d010_0), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d018_0), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d020_0), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d028_0), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d030_0), 0xd030, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d038_0), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d039_0), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03a_0), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03b_0), 0xd03b, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03c_0), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d040_0), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d048_0), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d050_0), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d058_0), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d060_0), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d068_0), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d070_0), 0xd070, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d078_0), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d079_0), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07a_0), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07b_0), 0xd07b, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07c_0), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d080_0), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d088_0), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d090_0), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d098_0), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a0_0), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a8_0), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b0_0), 0xd0b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b8_0), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b9_0), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0ba_0), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bb_0), 0xd0bb, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bc_0), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0c0_0), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0c8_0), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d0_0), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d8_0), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e0_0), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e8_0), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f0_0), 0xd0f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f8_0), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f9_0), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fa_0), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fb_0), 0xd0fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fc_0), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d100_0), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d108_0), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d110_0), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d118_0), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d120_0), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d128_0), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d130_0), 0xd130, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d138_0), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d139_0), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d140_0), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d148_0), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d150_0), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d158_0), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d160_0), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d168_0), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d170_0), 0xd170, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d178_0), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d179_0), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d180_0), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d188_0), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d190_0), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d198_0), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a0_0), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a8_0), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b0_0), 0xd1b0, 2, { 2, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b8_0), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b9_0), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1c0_0), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1c8_0), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d0_0), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d8_0), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e0_0), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e8_0), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f0_0), 0xd1f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f8_0), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f9_0), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fa_0), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fb_0), 0xd1fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fc_0), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_e000_0), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e008_0), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e010_0), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e018_0), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e020_0), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e028_0), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e030_0), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e038_0), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e040_0), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e048_0), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e050_0), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e058_0), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e060_0), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e068_0), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e070_0), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e078_0), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e080_0), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e088_0), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e090_0), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e098_0), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0a0_0), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e0a8_0), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e0b0_0), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e0b8_0), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0d0_0), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0d8_0), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e0_0), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e8_0), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f0_0), 0xe0f0, 2, { 2, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f8_0), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f9_0), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e100_0), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e108_0), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e110_0), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e118_0), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e120_0), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e128_0), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e130_0), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e138_0), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e140_0), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e148_0), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e150_0), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e158_0), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e160_0), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e168_0), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e170_0), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e178_0), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e180_0), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e188_0), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e190_0), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e198_0), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1a0_0), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e1a8_0), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e1b0_0), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e1b8_0), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1d0_0), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1d8_0), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e0_0), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e8_0), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f0_0), 0xe1f0, 2, { 2, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f8_0), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f9_0), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e2d0_0), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2d8_0), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e0_0), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e8_0), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f0_0), 0xe2f0, 2, { 2, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f8_0), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f9_0), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e3d0_0), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3d8_0), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e0_0), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e8_0), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f0_0), 0xe3f0, 2, { 2, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f8_0), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f9_0), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e4d0_0), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4d8_0), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e0_0), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e8_0), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f0_0), 0xe4f0, 2, { 2, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f8_0), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f9_0), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e5d0_0), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5d8_0), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e0_0), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e8_0), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f0_0), 0xe5f0, 2, { 2, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f8_0), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f9_0), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e6d0_0), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6d8_0), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e0_0), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e8_0), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f0_0), 0xe6f0, 2, { 2, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f8_0), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f9_0), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e7d0_0), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7d8_0), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e0_0), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e8_0), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f0_0), 0xe7f0, 2, { 2, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f8_0), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f9_0), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e8c0_0), 0xe8c0, 4, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8d0_0), 0xe8d0, 4, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8e8_0), 0xe8e8, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f0_0), 0xe8f0, 4, { 2, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f8_0), 0xe8f8, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8f9_0), 0xe8f9, 8, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8fa_0), 0xe8fa, 6, { 0, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e8fb_0), 0xe8fb, 4, { 2, 0 }, 0 }, /* BFTST */
{ CPUFUNC(op_e9c0_0), 0xe9c0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9d0_0), 0xe9d0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9e8_0), 0xe9e8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f0_0), 0xe9f0, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f8_0), 0xe9f8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9f9_0), 0xe9f9, 8, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9fa_0), 0xe9fa, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_e9fb_0), 0xe9fb, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ CPUFUNC(op_eac0_0), 0xeac0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_ead0_0), 0xead0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eae8_0), 0xeae8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf0_0), 0xeaf0, 4, { 2, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf8_0), 0xeaf8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_eaf9_0), 0xeaf9, 8, { 0, 0 }, 0 }, /* BFCHG */
{ CPUFUNC(op_ebc0_0), 0xebc0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebd0_0), 0xebd0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebe8_0), 0xebe8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf0_0), 0xebf0, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf8_0), 0xebf8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebf9_0), 0xebf9, 8, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebfa_0), 0xebfa, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ebfb_0), 0xebfb, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ CPUFUNC(op_ecc0_0), 0xecc0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecd0_0), 0xecd0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ece8_0), 0xece8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf0_0), 0xecf0, 4, { 2, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf8_0), 0xecf8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_ecf9_0), 0xecf9, 8, { 0, 0 }, 0 }, /* BFCLR */
{ CPUFUNC(op_edc0_0), 0xedc0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edd0_0), 0xedd0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_ede8_0), 0xede8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf0_0), 0xedf0, 4, { 2, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf8_0), 0xedf8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edf9_0), 0xedf9, 8, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edfa_0), 0xedfa, 6, { 0, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_edfb_0), 0xedfb, 4, { 2, 0 }, 0 }, /* BFFFO */
{ CPUFUNC(op_eec0_0), 0xeec0, 4, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eed0_0), 0xeed0, 4, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eee8_0), 0xeee8, 6, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef0_0), 0xeef0, 4, { 2, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef8_0), 0xeef8, 6, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_eef9_0), 0xeef9, 8, { 0, 0 }, 0 }, /* BFSET */
{ CPUFUNC(op_efc0_0), 0xefc0, 4, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_efd0_0), 0xefd0, 4, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_efe8_0), 0xefe8, 6, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff0_0), 0xeff0, 4, { 2, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff8_0), 0xeff8, 6, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_eff9_0), 0xeff9, 8, { 0, 0 }, 0 }, /* BFINS */
{ CPUFUNC(op_f200_0), 0xf200, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f208_0), 0xf208, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f210_0), 0xf210, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f218_0), 0xf218, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f220_0), 0xf220, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f228_0), 0xf228, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f230_0), 0xf230, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f238_0), 0xf238, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f239_0), 0xf239, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23a_0), 0xf23a, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23b_0), 0xf23b, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f23c_0), 0xf23c, -1, { 0, 0 }, 0 }, /* FPP */
{ CPUFUNC(op_f240_0), 0xf240, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f248_0), 0xf248, -1, { 0, 0 }, 0 }, /* FDBcc */
{ CPUFUNC(op_f250_0), 0xf250, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f258_0), 0xf258, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f260_0), 0xf260, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f268_0), 0xf268, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f270_0), 0xf270, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f278_0), 0xf278, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f279_0), 0xf279, -1, { 0, 0 }, 0 }, /* FScc */
{ CPUFUNC(op_f27a_0), 0xf27a, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f27b_0), 0xf27b, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f27c_0), 0xf27c, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ CPUFUNC(op_f280_0), 0xf280, -1, { 0, 0 }, 0 }, /* FBcc */
{ CPUFUNC(op_f2c0_0), 0xf2c0, -1, { 0, 0 }, 0 }, /* FBcc */
{ CPUFUNC(op_f310_0), 0xf310, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f320_0), 0xf320, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f328_0), 0xf328, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f330_0), 0xf330, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f338_0), 0xf338, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f339_0), 0xf339, -1, { 0, 0 }, 0 }, /* FSAVE */
{ CPUFUNC(op_f350_0), 0xf350, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f358_0), 0xf358, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f368_0), 0xf368, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f370_0), 0xf370, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f378_0), 0xf378, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f379_0), 0xf379, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f37a_0), 0xf37a, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ CPUFUNC(op_f37b_0), 0xf37b, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ 0, 0 }};
#endif /* CPUEMU_68000_ONLY */
#endif /* CPUEMU_0 */
#ifdef CPUEMU_0
#ifndef CPUEMU_68000_ONLY
const struct cputbl CPUFUNC(op_smalltbl_4)[] = {
{ CPUFUNC(op_0000_0), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0010_0), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0018_0), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0020_0), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0028_0), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0030_4), 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0038_0), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0039_0), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_003c_0), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0040_0), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0050_0), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0058_0), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0060_0), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0068_0), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0070_4), 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0078_0), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0079_0), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_007c_0), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0080_0), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0090_0), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0098_0), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a0_0), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a8_0), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b0_4), 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b8_0), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b9_0), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0100_0), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0108_0), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0110_0), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0118_0), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0120_0), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0128_0), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0130_4), 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0138_0), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0139_0), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013a_0), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013b_4), 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013c_0), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0140_0), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0148_0), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0150_0), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0158_0), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0160_0), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0168_0), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0170_4), 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0178_0), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0179_0), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0180_0), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0188_0), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_0190_0), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0198_0), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a0_0), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a8_0), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b0_4), 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b8_0), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b9_0), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01c0_0), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01c8_0), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_01d0_0), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01d8_0), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e0_0), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e8_0), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f0_4), 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f8_0), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f9_0), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0200_0), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0210_0), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0218_0), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0220_0), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0228_0), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0230_4), 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0238_0), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0239_0), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_023c_0), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0240_0), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0250_0), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0258_0), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0260_0), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0268_0), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0270_4), 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0278_0), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0279_0), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_027c_0), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0280_0), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0290_0), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0298_0), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a0_0), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a8_0), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b0_4), 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b8_0), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b9_0), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0400_0), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0410_0), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0418_0), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0420_0), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0428_0), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0430_4), 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0438_0), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0439_0), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0440_0), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0450_0), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0458_0), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0460_0), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0468_0), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0470_4), 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0478_0), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0479_0), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0480_0), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0490_0), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0498_0), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a0_0), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a8_0), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b0_4), 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b8_0), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b9_0), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0600_0), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0610_0), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0618_0), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0620_0), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0628_0), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0630_4), 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0638_0), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0639_0), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0640_0), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0650_0), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0658_0), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0660_0), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0668_0), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0670_4), 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0678_0), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0679_0), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0680_0), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0690_0), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0698_0), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a0_0), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a8_0), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b0_4), 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b8_0), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b9_0), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0800_0), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0810_0), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0818_0), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0820_0), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0828_0), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0830_4), 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0838_0), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0839_0), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083a_0), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083b_4), 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0840_0), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0850_0), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0858_0), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0860_0), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0868_0), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0870_4), 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0878_0), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0879_0), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0880_0), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0890_0), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0898_0), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a0_0), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a8_0), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b0_4), 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b8_0), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b9_0), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08c0_0), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d0_0), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d8_0), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e0_0), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e8_0), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f0_4), 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f8_0), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f9_0), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0a00_0), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a10_0), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a18_0), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a20_0), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a28_0), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a30_4), 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a38_0), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a39_0), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a3c_0), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a40_0), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a50_0), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a58_0), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a60_0), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a68_0), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a70_4), 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a78_0), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a79_0), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a7c_0), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a80_0), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a90_0), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a98_0), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa0_0), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa8_0), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab0_4), 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab8_0), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab9_0), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0c00_0), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c10_0), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c18_0), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c20_0), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c28_0), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c30_4), 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c38_0), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c39_0), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c40_0), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c50_0), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c58_0), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c60_0), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c68_0), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c70_4), 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c78_0), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c79_0), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c80_0), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c90_0), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c98_0), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca0_0), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca8_0), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb0_4), 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb8_0), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb9_0), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_1000_0), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1010_0), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1018_0), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1020_0), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1028_0), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1030_4), 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1038_0), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1039_0), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103a_0), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103b_4), 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103c_0), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1080_0), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1090_0), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1098_0), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a0_0), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a8_0), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b0_4), 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b8_0), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b9_0), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10ba_0), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bb_4), 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bc_0), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10c0_0), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d0_0), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d8_0), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e0_0), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e8_0), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f0_4), 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f8_0), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f9_0), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fa_0), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fb_4), 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fc_0), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1100_0), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1110_0), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1118_0), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1120_0), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1128_0), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1130_4), 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1138_0), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1139_0), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113a_0), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113b_4), 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113c_0), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1140_0), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1150_0), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1158_0), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1160_0), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1168_0), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1170_4), 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1178_0), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1179_0), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117a_0), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117b_4), 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117c_0), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1180_4), 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1190_4), 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1198_4), 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a0_4), 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a8_4), 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b0_4), 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b8_4), 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b9_4), 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11ba_4), 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bb_4), 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bc_4), 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11c0_0), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d0_0), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d8_0), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e0_0), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e8_0), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f0_4), 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f8_0), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f9_0), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fa_0), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fb_4), 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fc_0), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13c0_0), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d0_0), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d8_0), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e0_0), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e8_0), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f0_4), 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f8_0), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f9_0), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fa_0), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fb_4), 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fc_0), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2000_0), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2008_0), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2010_0), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2018_0), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2020_0), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2028_0), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2030_4), 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2038_0), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2039_0), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203a_0), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203b_4), 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203c_0), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2040_0), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2048_0), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2050_0), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2058_0), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2060_0), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2068_0), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2070_4), 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2078_0), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2079_0), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207a_0), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207b_4), 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207c_0), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2080_0), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2088_0), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2090_0), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2098_0), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a0_0), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a8_0), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b0_4), 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b8_0), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b9_0), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20ba_0), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bb_4), 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bc_0), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c0_0), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c8_0), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d0_0), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d8_0), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e0_0), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e8_0), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f0_4), 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f8_0), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f9_0), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fa_0), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fb_4), 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fc_0), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2100_0), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2108_0), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2110_0), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2118_0), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2120_0), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2128_0), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2130_4), 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2138_0), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2139_0), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213a_0), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213b_4), 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213c_0), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2140_0), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2148_0), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2150_0), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2158_0), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2160_0), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2168_0), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2170_4), 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2178_0), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2179_0), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217a_0), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217b_4), 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217c_0), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2180_4), 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2188_4), 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2190_4), 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2198_4), 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a0_4), 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a8_4), 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b0_4), 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b8_4), 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b9_4), 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21ba_4), 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bb_4), 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bc_4), 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c0_0), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c8_0), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d0_0), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d8_0), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e0_0), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e8_0), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f0_4), 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f8_0), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f9_0), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fa_0), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fb_4), 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fc_0), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c0_0), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c8_0), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d0_0), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d8_0), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e0_0), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e8_0), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f0_4), 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f8_0), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f9_0), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fa_0), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fb_4), 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fc_0), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3000_0), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3008_0), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3010_0), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3018_0), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3020_0), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3028_0), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3030_4), 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3038_0), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3039_0), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303a_0), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303b_4), 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303c_0), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3040_0), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3048_0), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3050_0), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3058_0), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3060_0), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3068_0), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3070_4), 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3078_0), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3079_0), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307a_0), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307b_4), 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307c_0), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3080_0), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3088_0), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3090_0), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3098_0), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a0_0), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a8_0), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b0_4), 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b8_0), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b9_0), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30ba_0), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bb_4), 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bc_0), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c0_0), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c8_0), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d0_0), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d8_0), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e0_0), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e8_0), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f0_4), 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f8_0), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f9_0), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fa_0), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fb_4), 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fc_0), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3100_0), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3108_0), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3110_0), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3118_0), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3120_0), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3128_0), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3130_4), 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3138_0), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3139_0), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313a_0), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313b_4), 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313c_0), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3140_0), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3148_0), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3150_0), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3158_0), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3160_0), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3168_0), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3170_4), 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3178_0), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3179_0), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317a_0), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317b_4), 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317c_0), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3180_4), 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3188_4), 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3190_4), 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3198_4), 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a0_4), 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a8_4), 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b0_4), 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b8_4), 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b9_4), 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31ba_4), 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bb_4), 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bc_4), 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c0_0), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c8_0), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d0_0), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d8_0), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e0_0), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e8_0), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f0_4), 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f8_0), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f9_0), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fa_0), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fb_4), 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fc_0), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c0_0), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c8_0), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d0_0), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d8_0), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e0_0), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e8_0), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f0_4), 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f8_0), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f9_0), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fa_0), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fb_4), 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fc_0), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_4000_0), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4010_0), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4018_0), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4020_0), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4028_0), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4030_4), 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4038_0), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4039_0), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4040_0), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4050_0), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4058_0), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4060_0), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4068_0), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4070_4), 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4078_0), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4079_0), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4080_0), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4090_0), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4098_0), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a0_0), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a8_0), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b0_4), 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b8_0), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b9_0), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40c0_0), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d0_0), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d8_0), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e0_0), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e8_0), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f0_4), 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f8_0), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f9_0), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4180_0), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4190_0), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4198_0), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a0_0), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a8_0), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b0_4), 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b8_0), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b9_0), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41ba_0), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bb_4), 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bc_0), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41d0_0), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41e8_0), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f0_4), 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f8_0), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f9_0), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fa_0), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fb_4), 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_4200_0), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4210_0), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4218_0), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4220_0), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4228_0), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4230_4), 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4238_0), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4239_0), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4240_0), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4250_0), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4258_0), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4260_0), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4268_0), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4270_4), 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4278_0), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4279_0), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4280_0), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4290_0), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4298_0), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a0_0), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a8_0), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b0_4), 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b8_0), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b9_0), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42c0_0), 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42d0_0), 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42d8_0), 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42e0_0), 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42e8_0), 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42f0_4), 0x42f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
#endif
{ CPUFUNC(op_42f8_0), 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_42f9_0), 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4400_0), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4410_0), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4418_0), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4420_0), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4428_0), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4430_4), 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4438_0), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4439_0), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4440_0), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4450_0), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4458_0), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4460_0), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4468_0), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4470_4), 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4478_0), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4479_0), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4480_0), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4490_0), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4498_0), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a0_0), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a8_0), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b0_4), 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b8_0), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b9_0), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44c0_0), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d0_0), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d8_0), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e0_0), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e8_0), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f0_4), 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f8_0), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f9_0), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fa_0), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fb_4), 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fc_0), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4600_0), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4610_0), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4618_0), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4620_0), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4628_0), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4630_4), 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4638_0), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4639_0), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4640_0), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4650_0), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4658_0), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4660_0), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4668_0), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4670_4), 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4678_0), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4679_0), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4680_0), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4690_0), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4698_0), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a0_0), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a8_0), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b0_4), 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b8_0), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b9_0), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46c0_0), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d0_0), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d8_0), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e0_0), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e8_0), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f0_4), 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f8_0), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f9_0), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fa_0), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fb_4), 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fc_0), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4800_2), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4810_2), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4818_2), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4820_2), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4828_2), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4830_4), 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4838_2), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4839_2), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4840_0), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ CPUFUNC(op_4850_0), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4868_0), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4870_4), 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4878_0), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4879_0), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487a_0), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487b_4), 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4880_0), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4890_0), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a0_0), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a8_0), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b0_4), 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b8_0), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b9_0), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48c0_0), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_48d0_0), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e0_0), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e8_0), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f0_4), 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f8_0), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f9_0), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_4a00_0), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a10_0), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a18_0), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a20_0), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a28_0), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a30_4), 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a38_0), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a39_0), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a40_0), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a50_0), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a58_0), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a60_0), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a68_0), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a70_4), 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a78_0), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a79_0), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a80_0), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a90_0), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a98_0), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa0_0), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa8_0), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab0_4), 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab8_0), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab9_0), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ac0_4), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad0_4), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad8_4), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae0_4), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae8_4), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af0_4), 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af8_4), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af9_4), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4c90_0), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4c98_0), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ca8_0), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb0_4), 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb8_0), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb9_0), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cba_0), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cbb_4), 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd0_0), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd8_0), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ce8_0), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf0_4), 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf8_0), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf9_0), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfa_0), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfb_4), 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4e40_0), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ CPUFUNC(op_4e50_0), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4e58_0), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ CPUFUNC(op_4e60_0), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ CPUFUNC(op_4e68_0), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ CPUFUNC(op_4e70_0), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ CPUFUNC(op_4e71_0), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ CPUFUNC(op_4e72_0), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ CPUFUNC(op_4e73_0), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ CPUFUNC(op_4e74_0), 0x4e74, 4, { 0, 0 }, 1 }, /* RTD */
{ CPUFUNC(op_4e75_0), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ CPUFUNC(op_4e76_0), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ CPUFUNC(op_4e77_0), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ CPUFUNC(op_4e7a_0), 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
{ CPUFUNC(op_4e7b_0), 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
{ CPUFUNC(op_4e90_0), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ea8_0), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb0_4), 0x4eb0, 4, { 4, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb8_0), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb9_0), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eba_0), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ebb_4), 0x4ebb, 4, { 4, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ed0_0), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ee8_0), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef0_4), 0x4ef0, 4, { 4, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef8_0), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef9_0), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efa_0), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efb_4), 0x4efb, 4, { 4, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_5000_0), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5010_0), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5018_0), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5020_0), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5028_0), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5030_4), 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5038_0), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5039_0), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5040_0), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5048_0), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5050_0), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5058_0), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5060_0), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5068_0), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5070_4), 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5078_0), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5079_0), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5080_0), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5088_0), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5090_0), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5098_0), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a0_0), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a8_0), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b0_4), 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b8_0), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b9_0), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50c0_0), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50c8_0), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_50d0_0), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50d8_0), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e0_0), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e8_0), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f0_4), 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f8_0), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f9_0), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5100_0), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5110_0), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5118_0), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5120_0), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5128_0), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5130_4), 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5138_0), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5139_0), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5140_0), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5148_0), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5150_0), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5158_0), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5160_0), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5168_0), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5170_4), 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5178_0), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5179_0), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5180_0), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5188_0), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5190_0), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5198_0), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a0_0), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a8_0), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b0_4), 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b8_0), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b9_0), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51c0_0), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51c8_0), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_51d0_0), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51d8_0), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e0_0), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e8_0), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f0_4), 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f8_0), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f9_0), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c0_0), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c8_0), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_52d0_0), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52d8_0), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e0_0), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e8_0), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f0_4), 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f8_0), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f9_0), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c0_0), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c8_0), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_53d0_0), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53d8_0), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e0_0), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e8_0), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f0_4), 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f8_0), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f9_0), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c0_0), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c8_0), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_54d0_0), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54d8_0), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e0_0), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e8_0), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f0_4), 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f8_0), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f9_0), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c0_0), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c8_0), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_55d0_0), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55d8_0), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e0_0), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e8_0), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f0_4), 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f8_0), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f9_0), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c0_0), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c8_0), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_56d0_0), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56d8_0), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e0_0), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e8_0), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f0_4), 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f8_0), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f9_0), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c0_0), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c8_0), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_57d0_0), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57d8_0), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e0_0), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e8_0), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f0_4), 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f8_0), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f9_0), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c0_0), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c8_0), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_58d0_0), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58d8_0), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e0_0), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e8_0), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f0_4), 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f8_0), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f9_0), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c0_0), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c8_0), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_59d0_0), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59d8_0), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e0_0), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e8_0), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f0_4), 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f8_0), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f9_0), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac0_0), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac8_0), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ad0_0), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ad8_0), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae0_0), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae8_0), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af0_4), 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af8_0), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af9_0), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc0_0), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc8_0), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5bd0_0), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bd8_0), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be0_0), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be8_0), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf0_4), 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf8_0), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf9_0), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc0_0), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc8_0), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5cd0_0), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cd8_0), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce0_0), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce8_0), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf0_4), 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf8_0), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf9_0), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc0_0), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc8_0), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5dd0_0), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dd8_0), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de0_0), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de8_0), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df0_4), 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df8_0), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df9_0), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec0_0), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec8_0), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ed0_0), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ed8_0), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee0_0), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee8_0), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef0_4), 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef8_0), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef9_0), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc0_0), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc8_0), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5fd0_0), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fd8_0), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe0_0), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe8_0), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff0_4), 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff8_0), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff9_0), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_6000_0), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6001_0), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_60ff_4), 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6100_0), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6101_0), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_61ff_4), 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6200_0), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6201_0), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_62ff_4), 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6300_0), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6301_0), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_63ff_4), 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6400_0), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6401_0), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_64ff_4), 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6500_0), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6501_0), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_65ff_4), 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6600_0), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6601_0), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_66ff_4), 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6700_0), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6701_0), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_67ff_4), 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6800_0), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6801_0), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_68ff_4), 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6900_0), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6901_0), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_69ff_4), 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6a00_0), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a01_0), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6aff_4), 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6b00_0), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b01_0), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6bff_4), 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6c00_0), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c01_0), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6cff_4), 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6d00_0), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d01_0), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6dff_4), 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6e00_0), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e01_0), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6eff_4), 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6f00_0), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f01_0), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6fff_4), 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_7000_0), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_8000_0), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8010_0), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8018_0), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8020_0), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8028_0), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8030_4), 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8038_0), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8039_0), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803a_0), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803b_4), 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803c_0), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8040_0), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8050_0), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8058_0), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8060_0), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8068_0), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8070_4), 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8078_0), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8079_0), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807a_0), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807b_4), 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807c_0), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8080_0), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8090_0), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8098_0), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a0_0), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a8_0), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b0_4), 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b8_0), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b9_0), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80ba_0), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bb_4), 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bc_0), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80c0_0), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d0_0), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d8_0), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e0_0), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e8_0), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f0_4), 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f8_0), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f9_0), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fa_0), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fb_4), 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fc_0), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_8100_2), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8108_2), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8110_0), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8118_0), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8120_0), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8128_0), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8130_4), 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8138_0), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8139_0), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8150_0), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8158_0), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8160_0), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8168_0), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8170_4), 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8178_0), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8179_0), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8190_0), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8198_0), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a0_0), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a8_0), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b0_4), 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b8_0), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b9_0), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81c0_0), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d0_0), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d8_0), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e0_0), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e8_0), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f0_4), 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f8_0), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f9_0), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fa_0), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fb_4), 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fc_0), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_9000_0), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9010_0), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9018_0), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9020_0), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9028_0), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9030_4), 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9038_0), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9039_0), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903a_0), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903b_4), 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903c_0), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9040_0), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9048_0), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9050_0), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9058_0), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9060_0), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9068_0), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9070_4), 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9078_0), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9079_0), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907a_0), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907b_4), 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907c_0), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9080_0), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9088_0), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9090_0), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9098_0), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a0_0), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a8_0), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b0_4), 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b8_0), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b9_0), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90ba_0), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bb_4), 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bc_0), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90c0_0), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90c8_0), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d0_0), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d8_0), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e0_0), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e8_0), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f0_4), 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f8_0), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f9_0), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fa_0), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fb_4), 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fc_0), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_9100_0), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9108_0), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9110_0), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9118_0), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9120_0), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9128_0), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9130_4), 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9138_0), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9139_0), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9140_0), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9148_0), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9150_0), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9158_0), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9160_0), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9168_0), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9170_4), 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9178_0), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9179_0), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9180_0), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9188_0), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9190_0), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9198_0), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a0_0), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a8_0), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b0_4), 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b8_0), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b9_0), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91c0_0), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91c8_0), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d0_0), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d8_0), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e0_0), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e8_0), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f0_4), 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f8_0), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f9_0), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fa_0), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fb_4), 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fc_0), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_b000_0), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b010_0), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b018_0), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b020_0), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b028_0), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b030_4), 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b038_0), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b039_0), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03a_0), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03b_4), 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03c_0), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b040_0), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b048_0), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b050_0), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b058_0), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b060_0), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b068_0), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b070_4), 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b078_0), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b079_0), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07a_0), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07b_4), 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07c_0), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b080_0), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b088_0), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b090_0), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b098_0), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a0_0), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a8_0), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b0_4), 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b8_0), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b9_0), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0ba_0), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bb_4), 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bc_0), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0c0_0), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0c8_0), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d0_0), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d8_0), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e0_0), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e8_0), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f0_4), 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f8_0), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f9_0), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fa_0), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fb_4), 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fc_0), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b100_0), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b108_0), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b110_0), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b118_0), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b120_0), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b128_0), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b130_4), 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b138_0), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b139_0), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b140_0), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b148_0), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b150_0), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b158_0), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b160_0), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b168_0), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b170_4), 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b178_0), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b179_0), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b180_0), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b188_0), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b190_0), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b198_0), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a0_0), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a8_0), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b0_4), 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b8_0), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b9_0), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1c0_0), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1c8_0), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d0_0), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d8_0), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e0_0), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e8_0), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f0_4), 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f8_0), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f9_0), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fa_0), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fb_4), 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fc_0), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_c000_0), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c010_0), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c018_0), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c020_0), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c028_0), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c030_4), 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c038_0), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c039_0), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03a_0), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03b_4), 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03c_0), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c040_0), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c050_0), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c058_0), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c060_0), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c068_0), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c070_4), 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c078_0), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c079_0), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07a_0), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07b_4), 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07c_0), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c080_0), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c090_0), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c098_0), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a0_0), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a8_0), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b0_4), 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b8_0), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b9_0), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0ba_0), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bb_4), 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bc_0), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0c0_0), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d0_0), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d8_0), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e0_0), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e8_0), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f0_4), 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f8_0), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f9_0), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fa_0), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fb_4), 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fc_0), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c100_2), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c108_2), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c110_0), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c118_0), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c120_0), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c128_0), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c130_4), 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c138_0), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c139_0), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c140_0), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c148_0), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c150_0), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c158_0), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c160_0), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c168_0), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c170_4), 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c178_0), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c179_0), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c188_0), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c190_0), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c198_0), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a0_0), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a8_0), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b0_4), 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b8_0), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b9_0), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1c0_0), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d0_0), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d8_0), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e0_0), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e8_0), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f0_4), 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f8_0), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f9_0), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fa_0), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fb_4), 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fc_0), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_d000_0), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d010_0), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d018_0), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d020_0), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d028_0), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d030_4), 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d038_0), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d039_0), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03a_0), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03b_4), 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03c_0), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d040_0), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d048_0), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d050_0), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d058_0), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d060_0), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d068_0), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d070_4), 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d078_0), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d079_0), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07a_0), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07b_4), 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07c_0), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d080_0), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d088_0), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d090_0), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d098_0), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a0_0), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a8_0), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b0_4), 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b8_0), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b9_0), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0ba_0), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bb_4), 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bc_0), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0c0_0), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0c8_0), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d0_0), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d8_0), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e0_0), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e8_0), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f0_4), 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f8_0), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f9_0), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fa_0), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fb_4), 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fc_0), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d100_0), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d108_0), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d110_0), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d118_0), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d120_0), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d128_0), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d130_4), 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d138_0), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d139_0), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d140_0), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d148_0), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d150_0), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d158_0), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d160_0), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d168_0), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d170_4), 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d178_0), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d179_0), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d180_0), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d188_0), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d190_0), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d198_0), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a0_0), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a8_0), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b0_4), 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b8_0), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b9_0), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1c0_0), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1c8_0), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d0_0), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d8_0), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e0_0), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e8_0), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f0_4), 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f8_0), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f9_0), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fa_0), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fb_4), 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fc_0), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_e000_0), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e008_0), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e010_0), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e018_0), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e020_0), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e028_0), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e030_0), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e038_0), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e040_0), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e048_0), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e050_0), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e058_0), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e060_0), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e068_0), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e070_0), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e078_0), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e080_0), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e088_0), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e090_0), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e098_0), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0a0_0), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e0a8_0), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e0b0_0), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e0b8_0), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0d0_0), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0d8_0), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e0_0), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e8_0), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f0_4), 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f8_0), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f9_0), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e100_0), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e108_0), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e110_0), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e118_0), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e120_0), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e128_0), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e130_0), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e138_0), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e140_0), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e148_0), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e150_0), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e158_0), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e160_0), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e168_0), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e170_0), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e178_0), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e180_0), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e188_0), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e190_0), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e198_0), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1a0_0), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e1a8_0), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e1b0_0), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e1b8_0), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1d0_0), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1d8_0), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e0_0), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e8_0), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f0_4), 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f8_0), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f9_0), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e2d0_0), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2d8_0), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e0_0), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e8_0), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f0_4), 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f8_0), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f9_0), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e3d0_0), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3d8_0), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e0_0), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e8_0), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f0_4), 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f8_0), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f9_0), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e4d0_0), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4d8_0), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e0_0), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e8_0), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f0_4), 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f8_0), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f9_0), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e5d0_0), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5d8_0), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e0_0), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e8_0), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f0_4), 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f8_0), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f9_0), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e6d0_0), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6d8_0), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e0_0), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e8_0), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f0_4), 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f8_0), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f9_0), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e7d0_0), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7d8_0), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e0_0), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e8_0), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f0_4), 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f8_0), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f9_0), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ 0, 0 }};
#endif /* CPUEMU_68000_ONLY */
#endif /* CPUEMU_0 */
#ifdef CPUEMU_0
#ifndef CPUEMU_68000_ONLY
const struct cputbl CPUFUNC(op_smalltbl_5)[] = {
{ CPUFUNC(op_0000_0), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0010_0), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0018_0), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0020_0), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0028_0), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0030_4), 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0038_0), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0039_0), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_003c_0), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0040_0), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0050_0), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0058_0), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0060_0), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0068_0), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0070_4), 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0078_0), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0079_0), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_007c_0), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0080_0), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0090_0), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0098_0), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a0_0), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a8_0), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b0_4), 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b8_0), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b9_0), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0100_0), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0108_0), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0110_0), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0118_0), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0120_0), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0128_0), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0130_4), 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0138_0), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0139_0), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013a_0), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013b_4), 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013c_0), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0140_0), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0148_0), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0150_0), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0158_0), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0160_0), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0168_0), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0170_4), 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0178_0), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0179_0), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0180_0), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0188_0), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_0190_0), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0198_0), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a0_0), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a8_0), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b0_4), 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b8_0), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b9_0), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01c0_0), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01c8_0), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_01d0_0), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01d8_0), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e0_0), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e8_0), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f0_4), 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f8_0), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f9_0), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0200_0), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0210_0), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0218_0), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0220_0), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0228_0), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0230_4), 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0238_0), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0239_0), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_023c_0), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0240_0), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0250_0), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0258_0), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0260_0), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0268_0), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0270_4), 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0278_0), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0279_0), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_027c_0), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0280_0), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0290_0), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0298_0), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a0_0), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a8_0), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b0_4), 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b8_0), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b9_0), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0400_0), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0410_0), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0418_0), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0420_0), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0428_0), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0430_4), 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0438_0), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0439_0), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0440_0), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0450_0), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0458_0), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0460_0), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0468_0), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0470_4), 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0478_0), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0479_0), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0480_0), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0490_0), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0498_0), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a0_0), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a8_0), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b0_4), 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b8_0), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b9_0), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0600_0), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0610_0), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0618_0), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0620_0), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0628_0), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0630_4), 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0638_0), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0639_0), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0640_0), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0650_0), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0658_0), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0660_0), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0668_0), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0670_4), 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0678_0), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0679_0), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0680_0), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0690_0), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0698_0), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a0_0), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a8_0), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b0_4), 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b8_0), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b9_0), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0800_0), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0810_0), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0818_0), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0820_0), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0828_0), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0830_4), 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0838_0), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0839_0), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083a_0), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083b_4), 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0840_0), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0850_0), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0858_0), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0860_0), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0868_0), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0870_4), 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0878_0), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0879_0), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0880_0), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0890_0), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0898_0), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a0_0), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a8_0), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b0_4), 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b8_0), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b9_0), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08c0_0), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d0_0), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d8_0), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e0_0), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e8_0), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f0_4), 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f8_0), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f9_0), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0a00_0), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a10_0), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a18_0), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a20_0), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a28_0), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a30_4), 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a38_0), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a39_0), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a3c_0), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a40_0), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a50_0), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a58_0), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a60_0), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a68_0), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a70_4), 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a78_0), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a79_0), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a7c_0), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a80_0), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a90_0), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a98_0), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa0_0), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa8_0), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab0_4), 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab8_0), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab9_0), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0c00_0), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c10_0), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c18_0), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c20_0), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c28_0), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c30_4), 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c38_0), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c39_0), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c40_0), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c50_0), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c58_0), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c60_0), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c68_0), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c70_4), 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c78_0), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c79_0), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c80_0), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c90_0), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c98_0), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca0_0), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca8_0), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb0_4), 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb8_0), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb9_0), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_1000_0), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1010_0), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1018_0), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1020_0), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1028_0), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1030_4), 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1038_0), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1039_0), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103a_0), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103b_4), 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103c_0), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1080_0), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1090_0), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1098_0), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a0_0), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a8_0), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b0_4), 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b8_0), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b9_0), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10ba_0), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bb_4), 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bc_0), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10c0_0), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d0_0), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d8_0), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e0_0), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e8_0), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f0_4), 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f8_0), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f9_0), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fa_0), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fb_4), 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fc_0), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1100_0), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1110_0), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1118_0), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1120_0), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1128_0), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1130_4), 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1138_0), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1139_0), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113a_0), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113b_4), 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113c_0), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1140_0), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1150_0), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1158_0), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1160_0), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1168_0), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1170_4), 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1178_0), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1179_0), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117a_0), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117b_4), 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117c_0), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1180_4), 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1190_4), 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1198_4), 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a0_4), 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a8_4), 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b0_4), 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b8_4), 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b9_4), 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11ba_4), 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bb_4), 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bc_4), 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11c0_0), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d0_0), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d8_0), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e0_0), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e8_0), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f0_4), 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f8_0), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f9_0), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fa_0), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fb_4), 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fc_0), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13c0_0), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d0_0), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d8_0), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e0_0), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e8_0), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f0_4), 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f8_0), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f9_0), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fa_0), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fb_4), 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fc_0), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2000_0), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2008_0), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2010_0), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2018_0), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2020_0), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2028_0), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2030_4), 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2038_0), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2039_0), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203a_0), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203b_4), 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203c_0), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2040_0), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2048_0), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2050_0), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2058_0), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2060_0), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2068_0), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2070_4), 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2078_0), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2079_0), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207a_0), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207b_4), 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207c_0), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2080_0), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2088_0), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2090_0), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2098_0), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a0_0), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a8_0), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b0_4), 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b8_0), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b9_0), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20ba_0), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bb_4), 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bc_0), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c0_0), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c8_0), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d0_0), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d8_0), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e0_0), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e8_0), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f0_4), 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f8_0), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f9_0), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fa_0), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fb_4), 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fc_0), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2100_0), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2108_0), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2110_0), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2118_0), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2120_0), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2128_0), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2130_4), 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2138_0), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2139_0), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213a_0), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213b_4), 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213c_0), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2140_0), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2148_0), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2150_0), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2158_0), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2160_0), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2168_0), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2170_4), 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2178_0), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2179_0), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217a_0), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217b_4), 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217c_0), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2180_4), 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2188_4), 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2190_4), 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2198_4), 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a0_4), 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a8_4), 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b0_4), 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b8_4), 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b9_4), 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21ba_4), 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bb_4), 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bc_4), 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c0_0), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c8_0), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d0_0), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d8_0), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e0_0), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e8_0), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f0_4), 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f8_0), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f9_0), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fa_0), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fb_4), 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fc_0), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c0_0), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c8_0), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d0_0), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d8_0), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e0_0), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e8_0), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f0_4), 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f8_0), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f9_0), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fa_0), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fb_4), 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fc_0), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3000_0), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3008_0), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3010_0), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3018_0), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3020_0), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3028_0), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3030_4), 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3038_0), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3039_0), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303a_0), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303b_4), 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303c_0), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3040_0), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3048_0), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3050_0), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3058_0), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3060_0), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3068_0), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3070_4), 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3078_0), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3079_0), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307a_0), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307b_4), 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307c_0), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3080_0), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3088_0), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3090_0), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3098_0), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a0_0), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a8_0), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b0_4), 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b8_0), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b9_0), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30ba_0), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bb_4), 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bc_0), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c0_0), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c8_0), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d0_0), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d8_0), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e0_0), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e8_0), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f0_4), 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f8_0), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f9_0), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fa_0), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fb_4), 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fc_0), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3100_0), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3108_0), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3110_0), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3118_0), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3120_0), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3128_0), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3130_4), 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3138_0), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3139_0), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313a_0), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313b_4), 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313c_0), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3140_0), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3148_0), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3150_0), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3158_0), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3160_0), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3168_0), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3170_4), 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3178_0), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3179_0), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317a_0), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317b_4), 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317c_0), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3180_4), 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3188_4), 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3190_4), 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3198_4), 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a0_4), 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a8_4), 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b0_4), 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b8_4), 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b9_4), 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31ba_4), 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bb_4), 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bc_4), 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c0_0), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c8_0), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d0_0), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d8_0), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e0_0), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e8_0), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f0_4), 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f8_0), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f9_0), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fa_0), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fb_4), 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fc_0), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c0_0), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c8_0), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d0_0), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d8_0), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e0_0), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e8_0), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f0_4), 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f8_0), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f9_0), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fa_0), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fb_4), 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fc_0), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_4000_0), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4010_0), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4018_0), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4020_0), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4028_0), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4030_4), 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4038_0), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4039_0), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4040_0), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4050_0), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4058_0), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4060_0), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4068_0), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4070_4), 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4078_0), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4079_0), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4080_0), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4090_0), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4098_0), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a0_0), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a8_0), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b0_4), 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b8_0), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b9_0), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40c0_5), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d0_5), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d8_5), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e0_5), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e8_5), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f0_5), 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f8_5), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f9_5), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4180_0), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4190_0), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4198_0), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a0_0), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a8_0), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b0_4), 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b8_0), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b9_0), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41ba_0), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bb_4), 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bc_0), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41d0_0), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41e8_0), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f0_4), 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f8_0), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f9_0), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fa_0), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fb_4), 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_4200_5), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4210_5), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4218_5), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4220_5), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4228_5), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4230_5), 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4238_5), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4239_5), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4240_5), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4250_5), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4258_5), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4260_5), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4268_5), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4270_5), 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4278_5), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4279_5), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4280_5), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4290_5), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4298_5), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a0_5), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a8_5), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b0_5), 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b8_5), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b9_5), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4400_0), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4410_0), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4418_0), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4420_0), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4428_0), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4430_4), 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4438_0), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4439_0), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4440_0), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4450_0), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4458_0), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4460_0), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4468_0), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4470_4), 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4478_0), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4479_0), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4480_0), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4490_0), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4498_0), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a0_0), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a8_0), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b0_4), 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b8_0), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b9_0), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44c0_0), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d0_0), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d8_0), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e0_0), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e8_0), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f0_4), 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f8_0), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f9_0), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fa_0), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fb_4), 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fc_0), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4600_0), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4610_0), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4618_0), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4620_0), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4628_0), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4630_4), 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4638_0), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4639_0), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4640_0), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4650_0), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4658_0), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4660_0), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4668_0), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4670_4), 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4678_0), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4679_0), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4680_0), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4690_0), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4698_0), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a0_0), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a8_0), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b0_4), 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b8_0), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b9_0), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46c0_0), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d0_0), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d8_0), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e0_0), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e8_0), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f0_4), 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f8_0), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f9_0), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fa_0), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fb_4), 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fc_0), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4800_2), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4810_2), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4818_2), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4820_2), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4828_2), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4830_4), 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4838_2), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4839_2), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4840_0), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ CPUFUNC(op_4850_0), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4868_0), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4870_4), 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4878_0), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4879_0), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487a_0), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487b_4), 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4880_0), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4890_0), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a0_0), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a8_0), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b0_4), 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b8_0), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b9_0), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48c0_0), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_48d0_0), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e0_0), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e8_0), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f0_4), 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f8_0), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f9_0), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_4a00_0), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a10_0), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a18_0), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a20_0), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a28_0), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a30_4), 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a38_0), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a39_0), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a40_0), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a50_0), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a58_0), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a60_0), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a68_0), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a70_4), 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a78_0), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a79_0), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a80_0), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a90_0), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a98_0), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa0_0), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa8_0), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab0_4), 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab8_0), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab9_0), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ac0_4), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad0_4), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad8_4), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae0_4), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae8_4), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af0_4), 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af8_4), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af9_4), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4c90_0), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4c98_0), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ca8_0), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb0_4), 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb8_0), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb9_0), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cba_0), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cbb_4), 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd0_0), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd8_0), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ce8_0), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf0_4), 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf8_0), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf9_0), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfa_0), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfb_4), 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4e40_0), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ CPUFUNC(op_4e50_0), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4e58_0), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ CPUFUNC(op_4e60_0), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ CPUFUNC(op_4e68_0), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ CPUFUNC(op_4e70_0), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ CPUFUNC(op_4e71_0), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ CPUFUNC(op_4e72_0), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ CPUFUNC(op_4e73_5), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ CPUFUNC(op_4e75_0), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ CPUFUNC(op_4e76_0), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ CPUFUNC(op_4e77_0), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ CPUFUNC(op_4e90_0), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ea8_0), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb0_4), 0x4eb0, 4, { 4, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb8_0), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb9_0), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eba_0), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ebb_4), 0x4ebb, 4, { 4, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ed0_0), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ee8_0), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef0_4), 0x4ef0, 4, { 4, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef8_0), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef9_0), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efa_0), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efb_4), 0x4efb, 4, { 4, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_5000_0), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5010_0), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5018_0), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5020_0), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5028_0), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5030_4), 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5038_0), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5039_0), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5040_0), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5048_0), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5050_0), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5058_0), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5060_0), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5068_0), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5070_4), 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5078_0), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5079_0), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5080_0), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5088_0), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5090_0), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5098_0), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a0_0), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a8_0), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b0_4), 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b8_0), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b9_0), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50c0_5), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50c8_0), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_50d0_5), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50d8_5), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e0_5), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e8_5), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f0_5), 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f8_5), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f9_5), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5100_0), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5110_0), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5118_0), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5120_0), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5128_0), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5130_4), 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5138_0), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5139_0), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5140_0), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5148_0), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5150_0), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5158_0), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5160_0), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5168_0), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5170_4), 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5178_0), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5179_0), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5180_0), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5188_0), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5190_0), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5198_0), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a0_0), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a8_0), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b0_4), 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b8_0), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b9_0), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51c0_5), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51c8_0), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_51d0_5), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51d8_5), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e0_5), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e8_5), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f0_5), 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f8_5), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f9_5), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c0_5), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c8_0), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_52d0_5), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52d8_5), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e0_5), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e8_5), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f0_5), 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f8_5), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f9_5), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c0_5), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c8_0), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_53d0_5), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53d8_5), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e0_5), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e8_5), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f0_5), 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f8_5), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f9_5), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c0_5), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c8_0), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_54d0_5), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54d8_5), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e0_5), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e8_5), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f0_5), 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f8_5), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f9_5), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c0_5), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c8_0), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_55d0_5), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55d8_5), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e0_5), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e8_5), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f0_5), 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f8_5), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f9_5), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c0_5), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c8_0), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_56d0_5), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56d8_5), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e0_5), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e8_5), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f0_5), 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f8_5), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f9_5), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c0_5), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c8_0), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_57d0_5), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57d8_5), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e0_5), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e8_5), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f0_5), 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f8_5), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f9_5), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c0_5), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c8_0), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_58d0_5), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58d8_5), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e0_5), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e8_5), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f0_5), 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f8_5), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f9_5), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c0_5), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c8_0), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_59d0_5), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59d8_5), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e0_5), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e8_5), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f0_5), 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f8_5), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f9_5), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac0_5), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac8_0), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ad0_5), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ad8_5), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae0_5), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae8_5), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af0_5), 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af8_5), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af9_5), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc0_5), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc8_0), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5bd0_5), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bd8_5), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be0_5), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be8_5), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf0_5), 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf8_5), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf9_5), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc0_5), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc8_0), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5cd0_5), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cd8_5), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce0_5), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce8_5), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf0_5), 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf8_5), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf9_5), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc0_5), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc8_0), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5dd0_5), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dd8_5), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de0_5), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de8_5), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df0_5), 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df8_5), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df9_5), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec0_5), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec8_0), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ed0_5), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ed8_5), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee0_5), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee8_5), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef0_5), 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef8_5), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef9_5), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc0_5), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc8_0), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5fd0_5), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fd8_5), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe0_5), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe8_5), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff0_5), 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff8_5), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff9_5), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_6000_0), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6001_0), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_60ff_4), 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6100_0), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6101_0), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_61ff_4), 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6200_0), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6201_0), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_62ff_4), 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6300_0), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6301_0), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_63ff_4), 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6400_0), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6401_0), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_64ff_4), 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6500_0), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6501_0), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_65ff_4), 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6600_0), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6601_0), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_66ff_4), 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6700_0), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6701_0), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_67ff_4), 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6800_0), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6801_0), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_68ff_4), 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6900_0), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6901_0), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_69ff_4), 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6a00_0), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a01_0), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6aff_4), 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6b00_0), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b01_0), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6bff_4), 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6c00_0), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c01_0), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6cff_4), 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6d00_0), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d01_0), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6dff_4), 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6e00_0), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e01_0), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6eff_4), 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6f00_0), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f01_0), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6fff_4), 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_7000_0), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_8000_0), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8010_0), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8018_0), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8020_0), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8028_0), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8030_4), 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8038_0), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8039_0), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803a_0), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803b_4), 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803c_0), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8040_0), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8050_0), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8058_0), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8060_0), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8068_0), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8070_4), 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8078_0), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8079_0), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807a_0), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807b_4), 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807c_0), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8080_0), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8090_0), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8098_0), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a0_0), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a8_0), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b0_4), 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b8_0), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b9_0), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80ba_0), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bb_4), 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bc_0), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80c0_0), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d0_0), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d8_0), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e0_0), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e8_0), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f0_4), 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f8_0), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f9_0), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fa_0), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fb_4), 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fc_0), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_8100_2), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8108_2), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8110_0), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8118_0), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8120_0), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8128_0), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8130_4), 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8138_0), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8139_0), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8150_0), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8158_0), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8160_0), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8168_0), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8170_4), 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8178_0), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8179_0), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8190_0), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8198_0), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a0_0), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a8_0), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b0_4), 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b8_0), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b9_0), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81c0_0), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d0_0), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d8_0), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e0_0), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e8_0), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f0_4), 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f8_0), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f9_0), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fa_0), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fb_4), 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fc_0), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_9000_0), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9010_0), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9018_0), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9020_0), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9028_0), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9030_4), 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9038_0), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9039_0), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903a_0), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903b_4), 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903c_0), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9040_0), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9048_0), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9050_0), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9058_0), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9060_0), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9068_0), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9070_4), 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9078_0), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9079_0), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907a_0), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907b_4), 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907c_0), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9080_0), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9088_0), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9090_0), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9098_0), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a0_0), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a8_0), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b0_4), 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b8_0), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b9_0), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90ba_0), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bb_4), 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bc_0), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90c0_0), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90c8_0), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d0_0), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d8_0), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e0_0), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e8_0), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f0_4), 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f8_0), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f9_0), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fa_0), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fb_4), 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fc_0), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_9100_0), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9108_0), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9110_0), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9118_0), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9120_0), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9128_0), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9130_4), 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9138_0), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9139_0), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9140_0), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9148_0), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9150_0), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9158_0), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9160_0), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9168_0), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9170_4), 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9178_0), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9179_0), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9180_0), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9188_0), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9190_0), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9198_0), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a0_0), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a8_0), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b0_4), 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b8_0), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b9_0), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91c0_0), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91c8_0), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d0_0), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d8_0), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e0_0), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e8_0), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f0_4), 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f8_0), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f9_0), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fa_0), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fb_4), 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fc_0), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_b000_0), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b010_0), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b018_0), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b020_0), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b028_0), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b030_4), 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b038_0), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b039_0), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03a_0), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03b_4), 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03c_0), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b040_0), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b048_0), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b050_0), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b058_0), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b060_0), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b068_0), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b070_4), 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b078_0), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b079_0), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07a_0), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07b_4), 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07c_0), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b080_0), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b088_0), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b090_0), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b098_0), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a0_0), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a8_0), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b0_4), 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b8_0), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b9_0), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0ba_0), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bb_4), 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bc_0), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0c0_0), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0c8_0), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d0_0), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d8_0), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e0_0), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e8_0), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f0_4), 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f8_0), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f9_0), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fa_0), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fb_4), 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fc_0), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b100_0), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b108_0), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b110_0), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b118_0), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b120_0), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b128_0), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b130_4), 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b138_0), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b139_0), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b140_0), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b148_0), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b150_0), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b158_0), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b160_0), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b168_0), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b170_4), 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b178_0), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b179_0), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b180_0), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b188_0), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b190_0), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b198_0), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a0_0), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a8_0), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b0_4), 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b8_0), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b9_0), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1c0_0), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1c8_0), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d0_0), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d8_0), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e0_0), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e8_0), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f0_4), 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f8_0), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f9_0), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fa_0), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fb_4), 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fc_0), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_c000_0), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c010_0), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c018_0), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c020_0), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c028_0), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c030_4), 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c038_0), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c039_0), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03a_0), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03b_4), 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03c_0), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c040_0), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c050_0), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c058_0), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c060_0), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c068_0), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c070_4), 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c078_0), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c079_0), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07a_0), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07b_4), 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07c_0), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c080_0), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c090_0), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c098_0), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a0_0), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a8_0), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b0_4), 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b8_0), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b9_0), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0ba_0), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bb_4), 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bc_0), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0c0_0), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d0_0), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d8_0), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e0_0), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e8_0), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f0_4), 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f8_0), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f9_0), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fa_0), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fb_4), 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fc_0), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c100_2), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c108_2), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c110_0), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c118_0), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c120_0), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c128_0), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c130_4), 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c138_0), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c139_0), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c140_0), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c148_0), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c150_0), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c158_0), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c160_0), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c168_0), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c170_4), 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c178_0), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c179_0), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c188_0), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c190_0), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c198_0), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a0_0), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a8_0), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b0_4), 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b8_0), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b9_0), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1c0_0), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d0_0), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d8_0), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e0_0), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e8_0), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f0_4), 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f8_0), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f9_0), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fa_0), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fb_4), 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fc_0), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_d000_0), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d010_0), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d018_0), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d020_0), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d028_0), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d030_4), 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d038_0), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d039_0), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03a_0), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03b_4), 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03c_0), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d040_0), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d048_0), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d050_0), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d058_0), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d060_0), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d068_0), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d070_4), 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d078_0), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d079_0), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07a_0), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07b_4), 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07c_0), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d080_0), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d088_0), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d090_0), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d098_0), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a0_0), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a8_0), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b0_4), 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b8_0), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b9_0), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0ba_0), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bb_4), 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bc_0), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0c0_0), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0c8_0), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d0_0), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d8_0), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e0_0), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e8_0), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f0_4), 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f8_0), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f9_0), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fa_0), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fb_4), 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fc_0), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d100_0), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d108_0), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d110_0), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d118_0), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d120_0), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d128_0), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d130_4), 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d138_0), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d139_0), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d140_0), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d148_0), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d150_0), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d158_0), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d160_0), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d168_0), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d170_4), 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d178_0), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d179_0), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d180_0), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d188_0), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d190_0), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d198_0), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a0_0), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a8_0), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b0_4), 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b8_0), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b9_0), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1c0_0), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1c8_0), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d0_0), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d8_0), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e0_0), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e8_0), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f0_4), 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f8_0), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f9_0), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fa_0), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fb_4), 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fc_0), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_e000_0), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e008_0), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e010_0), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e018_0), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e020_0), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e028_0), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e030_0), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e038_0), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e040_0), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e048_0), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e050_0), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e058_0), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e060_0), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e068_0), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e070_0), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e078_0), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e080_0), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e088_0), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e090_0), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e098_0), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0a0_0), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e0a8_0), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e0b0_0), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e0b8_0), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0d0_0), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0d8_0), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e0_0), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e8_0), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f0_4), 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f8_0), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f9_0), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e100_0), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e108_0), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e110_0), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e118_0), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e120_0), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e128_0), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e130_0), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e138_0), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e140_0), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e148_0), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e150_0), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e158_0), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e160_0), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e168_0), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e170_0), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e178_0), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e180_0), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e188_0), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e190_0), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e198_0), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1a0_0), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e1a8_0), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e1b0_0), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e1b8_0), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1d0_0), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1d8_0), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e0_0), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e8_0), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f0_4), 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f8_0), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f9_0), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e2d0_0), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2d8_0), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e0_0), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e8_0), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f0_4), 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f8_0), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f9_0), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e3d0_0), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3d8_0), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e0_0), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e8_0), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f0_4), 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f8_0), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f9_0), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e4d0_0), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4d8_0), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e0_0), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e8_0), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f0_4), 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f8_0), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f9_0), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e5d0_0), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5d8_0), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e0_0), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e8_0), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f0_4), 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f8_0), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f9_0), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e6d0_0), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6d8_0), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e0_0), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e8_0), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f0_4), 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f8_0), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f9_0), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e7d0_0), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7d8_0), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e0_0), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e8_0), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f0_4), 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f8_0), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f9_0), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ 0, 0 }};
#endif /* CPUEMU_68000_ONLY */
#endif /* CPUEMU_0 */
#ifdef CPUEMU_11
const struct cputbl CPUFUNC(op_smalltbl_11)[] = {
{ CPUFUNC(op_0000_11), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0010_11), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0018_11), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0020_11), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0028_11), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0030_11), 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0038_11), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0039_11), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_003c_11), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0040_11), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0050_11), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0058_11), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0060_11), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0068_11), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0070_11), 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0078_11), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0079_11), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_007c_11), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0080_11), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0090_11), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0098_11), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a0_11), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a8_11), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b0_11), 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b8_11), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b9_11), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0100_11), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0108_11), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0110_11), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0118_11), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0120_11), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0128_11), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0130_11), 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0138_11), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0139_11), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013a_11), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013b_11), 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013c_11), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0140_11), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0148_11), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0150_11), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0158_11), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0160_11), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0168_11), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0170_11), 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0178_11), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0179_11), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0180_11), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0188_11), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_0190_11), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0198_11), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a0_11), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a8_11), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b0_11), 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b8_11), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b9_11), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01c0_11), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01c8_11), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_01d0_11), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01d8_11), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e0_11), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e8_11), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f0_11), 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f8_11), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f9_11), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0200_11), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0210_11), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0218_11), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0220_11), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0228_11), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0230_11), 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0238_11), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0239_11), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_023c_11), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0240_11), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0250_11), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0258_11), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0260_11), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0268_11), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0270_11), 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0278_11), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0279_11), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_027c_11), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0280_11), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0290_11), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0298_11), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a0_11), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a8_11), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b0_11), 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b8_11), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b9_11), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0400_11), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0410_11), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0418_11), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0420_11), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0428_11), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0430_11), 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0438_11), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0439_11), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0440_11), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0450_11), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0458_11), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0460_11), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0468_11), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0470_11), 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0478_11), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0479_11), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0480_11), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0490_11), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0498_11), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a0_11), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a8_11), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b0_11), 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b8_11), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b9_11), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0600_11), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0610_11), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0618_11), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0620_11), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0628_11), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0630_11), 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0638_11), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0639_11), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0640_11), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0650_11), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0658_11), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0660_11), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0668_11), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0670_11), 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0678_11), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0679_11), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0680_11), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0690_11), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0698_11), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a0_11), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a8_11), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b0_11), 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b8_11), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b9_11), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0800_11), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0810_11), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0818_11), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0820_11), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0828_11), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0830_11), 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0838_11), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0839_11), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083a_11), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083b_11), 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0840_11), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0850_11), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0858_11), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0860_11), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0868_11), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0870_11), 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0878_11), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0879_11), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0880_11), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0890_11), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0898_11), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a0_11), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a8_11), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b0_11), 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b8_11), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b9_11), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08c0_11), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d0_11), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d8_11), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e0_11), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e8_11), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f0_11), 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f8_11), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f9_11), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0a00_11), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a10_11), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a18_11), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a20_11), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a28_11), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a30_11), 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a38_11), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a39_11), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a3c_11), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a40_11), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a50_11), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a58_11), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a60_11), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a68_11), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a70_11), 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a78_11), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a79_11), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a7c_11), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a80_11), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a90_11), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a98_11), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa0_11), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa8_11), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab0_11), 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab8_11), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab9_11), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0c00_11), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c10_11), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c18_11), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c20_11), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c28_11), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c30_11), 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c38_11), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c39_11), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c40_11), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c50_11), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c58_11), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c60_11), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c68_11), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c70_11), 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c78_11), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c79_11), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c80_11), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c90_11), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c98_11), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca0_11), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca8_11), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb0_11), 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb8_11), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb9_11), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_1000_11), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1010_11), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1018_11), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1020_11), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1028_11), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1030_11), 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1038_11), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1039_11), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103a_11), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103b_11), 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103c_11), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1080_11), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1090_11), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1098_11), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a0_11), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a8_11), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b0_11), 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b8_11), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b9_11), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10ba_11), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bb_11), 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bc_11), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10c0_11), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d0_11), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d8_11), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e0_11), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e8_11), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f0_11), 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f8_11), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f9_11), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fa_11), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fb_11), 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fc_11), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1100_11), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1110_11), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1118_11), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1120_11), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1128_11), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1130_11), 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1138_11), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1139_11), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113a_11), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113b_11), 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113c_11), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1140_11), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1150_11), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1158_11), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1160_11), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1168_11), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1170_11), 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1178_11), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1179_11), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117a_11), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117b_11), 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117c_11), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1180_11), 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1190_11), 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1198_11), 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a0_11), 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a8_11), 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b0_11), 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b8_11), 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b9_11), 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11ba_11), 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bb_11), 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bc_11), 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11c0_11), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d0_11), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d8_11), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e0_11), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e8_11), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f0_11), 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f8_11), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f9_11), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fa_11), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fb_11), 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fc_11), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13c0_11), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d0_11), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d8_11), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e0_11), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e8_11), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f0_11), 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f8_11), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f9_11), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fa_11), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fb_11), 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fc_11), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2000_11), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2008_11), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2010_11), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2018_11), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2020_11), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2028_11), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2030_11), 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2038_11), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2039_11), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203a_11), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203b_11), 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203c_11), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2040_11), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2048_11), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2050_11), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2058_11), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2060_11), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2068_11), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2070_11), 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2078_11), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2079_11), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207a_11), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207b_11), 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207c_11), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2080_11), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2088_11), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2090_11), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2098_11), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a0_11), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a8_11), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b0_11), 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b8_11), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b9_11), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20ba_11), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bb_11), 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bc_11), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c0_11), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c8_11), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d0_11), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d8_11), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e0_11), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e8_11), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f0_11), 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f8_11), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f9_11), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fa_11), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fb_11), 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fc_11), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2100_11), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2108_11), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2110_11), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2118_11), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2120_11), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2128_11), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2130_11), 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2138_11), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2139_11), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213a_11), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213b_11), 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213c_11), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2140_11), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2148_11), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2150_11), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2158_11), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2160_11), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2168_11), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2170_11), 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2178_11), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2179_11), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217a_11), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217b_11), 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217c_11), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2180_11), 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2188_11), 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2190_11), 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2198_11), 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a0_11), 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a8_11), 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b0_11), 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b8_11), 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b9_11), 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21ba_11), 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bb_11), 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bc_11), 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c0_11), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c8_11), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d0_11), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d8_11), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e0_11), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e8_11), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f0_11), 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f8_11), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f9_11), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fa_11), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fb_11), 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fc_11), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c0_11), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c8_11), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d0_11), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d8_11), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e0_11), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e8_11), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f0_11), 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f8_11), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f9_11), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fa_11), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fb_11), 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fc_11), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3000_11), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3008_11), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3010_11), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3018_11), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3020_11), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3028_11), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3030_11), 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3038_11), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3039_11), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303a_11), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303b_11), 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303c_11), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3040_11), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3048_11), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3050_11), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3058_11), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3060_11), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3068_11), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3070_11), 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3078_11), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3079_11), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307a_11), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307b_11), 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307c_11), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3080_11), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3088_11), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3090_11), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3098_11), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a0_11), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a8_11), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b0_11), 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b8_11), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b9_11), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30ba_11), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bb_11), 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bc_11), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c0_11), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c8_11), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d0_11), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d8_11), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e0_11), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e8_11), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f0_11), 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f8_11), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f9_11), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fa_11), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fb_11), 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fc_11), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3100_11), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3108_11), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3110_11), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3118_11), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3120_11), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3128_11), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3130_11), 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3138_11), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3139_11), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313a_11), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313b_11), 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313c_11), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3140_11), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3148_11), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3150_11), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3158_11), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3160_11), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3168_11), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3170_11), 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3178_11), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3179_11), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317a_11), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317b_11), 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317c_11), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3180_11), 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3188_11), 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3190_11), 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3198_11), 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a0_11), 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a8_11), 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b0_11), 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b8_11), 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b9_11), 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31ba_11), 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bb_11), 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bc_11), 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c0_11), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c8_11), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d0_11), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d8_11), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e0_11), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e8_11), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f0_11), 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f8_11), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f9_11), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fa_11), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fb_11), 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fc_11), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c0_11), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c8_11), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d0_11), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d8_11), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e0_11), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e8_11), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f0_11), 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f8_11), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f9_11), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fa_11), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fb_11), 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fc_11), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_4000_11), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4010_11), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4018_11), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4020_11), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4028_11), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4030_11), 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4038_11), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4039_11), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4040_11), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4050_11), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4058_11), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4060_11), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4068_11), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4070_11), 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4078_11), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4079_11), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4080_11), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4090_11), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4098_11), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a0_11), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a8_11), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b0_11), 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b8_11), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b9_11), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40c0_11), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d0_11), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d8_11), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e0_11), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e8_11), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f0_11), 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f8_11), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f9_11), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4180_11), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4190_11), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4198_11), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a0_11), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a8_11), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b0_11), 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b8_11), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b9_11), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41ba_11), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bb_11), 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bc_11), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41d0_11), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41e8_11), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f0_11), 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f8_11), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f9_11), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fa_11), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fb_11), 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_4200_11), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4210_11), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4218_11), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4220_11), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4228_11), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4230_11), 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4238_11), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4239_11), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4240_11), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4250_11), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4258_11), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4260_11), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4268_11), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4270_11), 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4278_11), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4279_11), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4280_11), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4290_11), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4298_11), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a0_11), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a8_11), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b0_11), 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b8_11), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b9_11), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42c0_11), 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42d0_11), 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42d8_11), 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42e0_11), 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42e8_11), 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42f0_11), 0x42f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42f8_11), 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_42f9_11), 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
#endif
{ CPUFUNC(op_4400_11), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4410_11), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4418_11), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4420_11), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4428_11), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4430_11), 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4438_11), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4439_11), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4440_11), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4450_11), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4458_11), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4460_11), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4468_11), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4470_11), 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4478_11), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4479_11), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4480_11), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4490_11), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4498_11), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a0_11), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a8_11), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b0_11), 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b8_11), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b9_11), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44c0_11), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d0_11), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d8_11), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e0_11), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e8_11), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f0_11), 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f8_11), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f9_11), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fa_11), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fb_11), 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fc_11), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4600_11), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4610_11), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4618_11), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4620_11), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4628_11), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4630_11), 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4638_11), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4639_11), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4640_11), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4650_11), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4658_11), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4660_11), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4668_11), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4670_11), 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4678_11), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4679_11), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4680_11), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4690_11), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4698_11), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a0_11), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a8_11), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b0_11), 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b8_11), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b9_11), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46c0_11), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d0_11), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d8_11), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e0_11), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e8_11), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f0_11), 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f8_11), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f9_11), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fa_11), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fb_11), 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fc_11), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4800_11), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4810_11), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4818_11), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4820_11), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4828_11), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4830_11), 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4838_11), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4839_11), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4840_11), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ CPUFUNC(op_4850_11), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4868_11), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4870_11), 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4878_11), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4879_11), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487a_11), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487b_11), 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4880_11), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4890_11), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a0_11), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a8_11), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b0_11), 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b8_11), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b9_11), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48c0_11), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_48d0_11), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e0_11), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e8_11), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f0_11), 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f8_11), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f9_11), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_4a00_11), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a10_11), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a18_11), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a20_11), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a28_11), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a30_11), 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a38_11), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a39_11), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a40_11), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a50_11), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a58_11), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a60_11), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a68_11), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a70_11), 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a78_11), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a79_11), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a80_11), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a90_11), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a98_11), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa0_11), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa8_11), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab0_11), 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab8_11), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab9_11), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ac0_11), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad0_11), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad8_11), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae0_11), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae8_11), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af0_11), 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af8_11), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af9_11), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4c90_11), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4c98_11), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ca8_11), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb0_11), 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb8_11), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb9_11), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cba_11), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cbb_11), 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd0_11), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd8_11), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ce8_11), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf0_11), 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf8_11), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf9_11), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfa_11), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfb_11), 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4e40_11), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ CPUFUNC(op_4e50_11), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4e58_11), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ CPUFUNC(op_4e60_11), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ CPUFUNC(op_4e68_11), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ CPUFUNC(op_4e70_11), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ CPUFUNC(op_4e71_11), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ CPUFUNC(op_4e72_11), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ CPUFUNC(op_4e73_11), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4e74_11), 0x4e74, 4, { 0, 0 }, 1 }, /* RTD */
#endif
{ CPUFUNC(op_4e75_11), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ CPUFUNC(op_4e76_11), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ CPUFUNC(op_4e77_11), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4e7a_11), 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ CPUFUNC(op_4e7b_11), 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
#endif
{ CPUFUNC(op_4e90_11), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ea8_11), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb0_11), 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb8_11), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb9_11), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eba_11), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ebb_11), 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ed0_11), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ee8_11), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef0_11), 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef8_11), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef9_11), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efa_11), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efb_11), 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_5000_11), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5010_11), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5018_11), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5020_11), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5028_11), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5030_11), 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5038_11), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5039_11), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5040_11), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5048_11), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5050_11), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5058_11), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5060_11), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5068_11), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5070_11), 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5078_11), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5079_11), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5080_11), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5088_11), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5090_11), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5098_11), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a0_11), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a8_11), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b0_11), 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b8_11), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b9_11), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50c0_11), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50c8_11), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_50d0_11), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50d8_11), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e0_11), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e8_11), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f0_11), 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f8_11), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f9_11), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5100_11), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5110_11), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5118_11), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5120_11), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5128_11), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5130_11), 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5138_11), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5139_11), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5140_11), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5148_11), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5150_11), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5158_11), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5160_11), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5168_11), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5170_11), 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5178_11), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5179_11), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5180_11), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5188_11), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5190_11), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5198_11), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a0_11), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a8_11), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b0_11), 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b8_11), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b9_11), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51c0_11), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51c8_11), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_51d0_11), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51d8_11), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e0_11), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e8_11), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f0_11), 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f8_11), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f9_11), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c0_11), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c8_11), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_52d0_11), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52d8_11), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e0_11), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e8_11), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f0_11), 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f8_11), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f9_11), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c0_11), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c8_11), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_53d0_11), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53d8_11), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e0_11), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e8_11), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f0_11), 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f8_11), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f9_11), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c0_11), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c8_11), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_54d0_11), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54d8_11), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e0_11), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e8_11), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f0_11), 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f8_11), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f9_11), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c0_11), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c8_11), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_55d0_11), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55d8_11), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e0_11), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e8_11), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f0_11), 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f8_11), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f9_11), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c0_11), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c8_11), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_56d0_11), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56d8_11), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e0_11), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e8_11), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f0_11), 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f8_11), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f9_11), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c0_11), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c8_11), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_57d0_11), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57d8_11), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e0_11), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e8_11), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f0_11), 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f8_11), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f9_11), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c0_11), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c8_11), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_58d0_11), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58d8_11), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e0_11), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e8_11), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f0_11), 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f8_11), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f9_11), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c0_11), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c8_11), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_59d0_11), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59d8_11), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e0_11), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e8_11), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f0_11), 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f8_11), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f9_11), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac0_11), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac8_11), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ad0_11), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ad8_11), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae0_11), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae8_11), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af0_11), 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af8_11), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af9_11), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc0_11), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc8_11), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5bd0_11), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bd8_11), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be0_11), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be8_11), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf0_11), 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf8_11), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf9_11), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc0_11), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc8_11), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5cd0_11), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cd8_11), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce0_11), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce8_11), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf0_11), 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf8_11), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf9_11), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc0_11), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc8_11), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5dd0_11), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dd8_11), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de0_11), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de8_11), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df0_11), 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df8_11), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df9_11), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec0_11), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec8_11), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ed0_11), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ed8_11), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee0_11), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee8_11), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef0_11), 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef8_11), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef9_11), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc0_11), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc8_11), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5fd0_11), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fd8_11), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe0_11), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe8_11), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff0_11), 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff8_11), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff9_11), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_6000_11), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6001_11), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_60ff_11), 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6100_11), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6101_11), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_61ff_11), 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6200_11), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6201_11), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_62ff_11), 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6300_11), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6301_11), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_63ff_11), 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6400_11), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6401_11), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_64ff_11), 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6500_11), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6501_11), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_65ff_11), 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6600_11), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6601_11), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_66ff_11), 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6700_11), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6701_11), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_67ff_11), 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6800_11), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6801_11), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_68ff_11), 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6900_11), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6901_11), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_69ff_11), 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6a00_11), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a01_11), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6aff_11), 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6b00_11), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b01_11), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6bff_11), 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6c00_11), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c01_11), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6cff_11), 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6d00_11), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d01_11), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6dff_11), 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6e00_11), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e01_11), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6eff_11), 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6f00_11), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f01_11), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6fff_11), 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_7000_11), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_8000_11), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8010_11), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8018_11), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8020_11), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8028_11), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8030_11), 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8038_11), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8039_11), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803a_11), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803b_11), 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803c_11), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8040_11), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8050_11), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8058_11), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8060_11), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8068_11), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8070_11), 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8078_11), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8079_11), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807a_11), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807b_11), 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807c_11), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8080_11), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8090_11), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8098_11), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a0_11), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a8_11), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b0_11), 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b8_11), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b9_11), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80ba_11), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bb_11), 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bc_11), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80c0_11), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d0_11), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d8_11), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e0_11), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e8_11), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f0_11), 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f8_11), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f9_11), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fa_11), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fb_11), 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fc_11), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_8100_11), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8108_11), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8110_11), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8118_11), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8120_11), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8128_11), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8130_11), 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8138_11), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8139_11), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8150_11), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8158_11), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8160_11), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8168_11), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8170_11), 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8178_11), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8179_11), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8190_11), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8198_11), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a0_11), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a8_11), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b0_11), 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b8_11), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b9_11), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81c0_11), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d0_11), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d8_11), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e0_11), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e8_11), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f0_11), 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f8_11), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f9_11), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fa_11), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fb_11), 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fc_11), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_9000_11), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9010_11), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9018_11), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9020_11), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9028_11), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9030_11), 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9038_11), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9039_11), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903a_11), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903b_11), 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903c_11), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9040_11), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9048_11), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9050_11), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9058_11), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9060_11), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9068_11), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9070_11), 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9078_11), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9079_11), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907a_11), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907b_11), 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907c_11), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9080_11), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9088_11), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9090_11), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9098_11), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a0_11), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a8_11), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b0_11), 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b8_11), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b9_11), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90ba_11), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bb_11), 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bc_11), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90c0_11), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90c8_11), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d0_11), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d8_11), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e0_11), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e8_11), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f0_11), 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f8_11), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f9_11), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fa_11), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fb_11), 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fc_11), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_9100_11), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9108_11), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9110_11), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9118_11), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9120_11), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9128_11), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9130_11), 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9138_11), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9139_11), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9140_11), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9148_11), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9150_11), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9158_11), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9160_11), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9168_11), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9170_11), 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9178_11), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9179_11), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9180_11), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9188_11), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9190_11), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9198_11), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a0_11), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a8_11), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b0_11), 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b8_11), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b9_11), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91c0_11), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91c8_11), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d0_11), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d8_11), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e0_11), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e8_11), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f0_11), 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f8_11), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f9_11), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fa_11), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fb_11), 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fc_11), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_b000_11), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b010_11), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b018_11), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b020_11), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b028_11), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b030_11), 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b038_11), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b039_11), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03a_11), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03b_11), 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03c_11), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b040_11), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b048_11), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b050_11), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b058_11), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b060_11), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b068_11), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b070_11), 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b078_11), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b079_11), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07a_11), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07b_11), 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07c_11), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b080_11), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b088_11), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b090_11), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b098_11), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a0_11), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a8_11), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b0_11), 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b8_11), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b9_11), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0ba_11), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bb_11), 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bc_11), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0c0_11), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0c8_11), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d0_11), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d8_11), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e0_11), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e8_11), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f0_11), 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f8_11), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f9_11), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fa_11), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fb_11), 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fc_11), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b100_11), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b108_11), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b110_11), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b118_11), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b120_11), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b128_11), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b130_11), 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b138_11), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b139_11), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b140_11), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b148_11), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b150_11), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b158_11), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b160_11), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b168_11), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b170_11), 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b178_11), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b179_11), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b180_11), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b188_11), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b190_11), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b198_11), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a0_11), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a8_11), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b0_11), 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b8_11), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b9_11), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1c0_11), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1c8_11), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d0_11), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d8_11), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e0_11), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e8_11), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f0_11), 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f8_11), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f9_11), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fa_11), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fb_11), 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fc_11), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_c000_11), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c010_11), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c018_11), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c020_11), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c028_11), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c030_11), 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c038_11), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c039_11), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03a_11), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03b_11), 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03c_11), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c040_11), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c050_11), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c058_11), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c060_11), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c068_11), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c070_11), 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c078_11), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c079_11), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07a_11), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07b_11), 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07c_11), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c080_11), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c090_11), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c098_11), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a0_11), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a8_11), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b0_11), 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b8_11), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b9_11), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0ba_11), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bb_11), 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bc_11), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0c0_11), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d0_11), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d8_11), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e0_11), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e8_11), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f0_11), 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f8_11), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f9_11), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fa_11), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fb_11), 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fc_11), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c100_11), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c108_11), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c110_11), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c118_11), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c120_11), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c128_11), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c130_11), 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c138_11), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c139_11), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c140_11), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c148_11), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c150_11), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c158_11), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c160_11), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c168_11), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c170_11), 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c178_11), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c179_11), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c188_11), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c190_11), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c198_11), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a0_11), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a8_11), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b0_11), 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b8_11), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b9_11), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1c0_11), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d0_11), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d8_11), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e0_11), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e8_11), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f0_11), 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f8_11), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f9_11), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fa_11), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fb_11), 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fc_11), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_d000_11), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d010_11), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d018_11), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d020_11), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d028_11), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d030_11), 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d038_11), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d039_11), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03a_11), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03b_11), 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03c_11), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d040_11), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d048_11), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d050_11), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d058_11), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d060_11), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d068_11), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d070_11), 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d078_11), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d079_11), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07a_11), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07b_11), 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07c_11), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d080_11), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d088_11), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d090_11), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d098_11), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a0_11), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a8_11), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b0_11), 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b8_11), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b9_11), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0ba_11), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bb_11), 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bc_11), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0c0_11), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0c8_11), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d0_11), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d8_11), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e0_11), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e8_11), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f0_11), 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f8_11), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f9_11), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fa_11), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fb_11), 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fc_11), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d100_11), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d108_11), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d110_11), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d118_11), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d120_11), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d128_11), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d130_11), 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d138_11), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d139_11), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d140_11), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d148_11), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d150_11), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d158_11), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d160_11), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d168_11), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d170_11), 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d178_11), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d179_11), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d180_11), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d188_11), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d190_11), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d198_11), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a0_11), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a8_11), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b0_11), 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b8_11), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b9_11), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1c0_11), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1c8_11), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d0_11), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d8_11), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e0_11), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e8_11), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f0_11), 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f8_11), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f9_11), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fa_11), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fb_11), 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fc_11), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_e000_11), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e008_11), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e010_11), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e018_11), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e020_11), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e028_11), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e030_11), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e038_11), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e040_11), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e048_11), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e050_11), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e058_11), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e060_11), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e068_11), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e070_11), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e078_11), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e080_11), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e088_11), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e090_11), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e098_11), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0a0_11), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e0a8_11), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e0b0_11), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e0b8_11), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0d0_11), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0d8_11), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e0_11), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e8_11), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f0_11), 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f8_11), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f9_11), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e100_11), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e108_11), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e110_11), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e118_11), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e120_11), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e128_11), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e130_11), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e138_11), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e140_11), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e148_11), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e150_11), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e158_11), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e160_11), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e168_11), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e170_11), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e178_11), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e180_11), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e188_11), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e190_11), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e198_11), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1a0_11), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e1a8_11), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e1b0_11), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e1b8_11), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1d0_11), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1d8_11), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e0_11), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e8_11), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f0_11), 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f8_11), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f9_11), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e2d0_11), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2d8_11), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e0_11), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e8_11), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f0_11), 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f8_11), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f9_11), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e3d0_11), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3d8_11), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e0_11), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e8_11), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f0_11), 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f8_11), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f9_11), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e4d0_11), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4d8_11), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e0_11), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e8_11), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f0_11), 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f8_11), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f9_11), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e5d0_11), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5d8_11), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e0_11), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e8_11), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f0_11), 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f8_11), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f9_11), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e6d0_11), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6d8_11), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e0_11), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e8_11), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f0_11), 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f8_11), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f9_11), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e7d0_11), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7d8_11), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e0_11), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e8_11), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f0_11), 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f8_11), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f9_11), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ 0, 0 }};
#endif /* CPUEMU_11 */
#ifdef CPUEMU_11
const struct cputbl CPUFUNC(op_smalltbl_12)[] = {
{ CPUFUNC(op_0000_11), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0010_11), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0018_11), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0020_11), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0028_11), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0030_11), 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0038_11), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0039_11), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_003c_11), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0040_11), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0050_11), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0058_11), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0060_11), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0068_11), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0070_11), 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0078_11), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0079_11), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_007c_11), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ CPUFUNC(op_0080_11), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0090_11), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0098_11), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a0_11), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00a8_11), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b0_11), 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b8_11), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_00b9_11), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_0100_11), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0108_11), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0110_11), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0118_11), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0120_11), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0128_11), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0130_11), 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0138_11), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0139_11), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013a_11), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013b_11), 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_013c_11), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0140_11), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0148_11), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ CPUFUNC(op_0150_11), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0158_11), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0160_11), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0168_11), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0170_11), 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0178_11), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0179_11), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0180_11), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0188_11), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_0190_11), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0198_11), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a0_11), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01a8_11), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b0_11), 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b8_11), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01b9_11), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_01c0_11), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01c8_11), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ CPUFUNC(op_01d0_11), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01d8_11), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e0_11), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01e8_11), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f0_11), 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f8_11), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_01f9_11), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0200_11), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0210_11), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0218_11), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0220_11), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0228_11), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0230_11), 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0238_11), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0239_11), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_023c_11), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0240_11), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0250_11), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0258_11), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0260_11), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0268_11), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0270_11), 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0278_11), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0279_11), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_027c_11), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ CPUFUNC(op_0280_11), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0290_11), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0298_11), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a0_11), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02a8_11), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b0_11), 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b8_11), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_02b9_11), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_0400_11), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0410_11), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0418_11), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0420_11), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0428_11), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0430_11), 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0438_11), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0439_11), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0440_11), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0450_11), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0458_11), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0460_11), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0468_11), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0470_11), 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0478_11), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0479_11), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0480_11), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0490_11), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0498_11), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a0_11), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04a8_11), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b0_11), 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b8_11), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_04b9_11), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_0600_11), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0610_11), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0618_11), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0620_11), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0628_11), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0630_11), 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0638_11), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0639_11), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0640_11), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0650_11), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0658_11), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0660_11), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0668_11), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0670_11), 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0678_11), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0679_11), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0680_11), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0690_11), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0698_11), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a0_11), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06a8_11), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b0_11), 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b8_11), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_06b9_11), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_0800_11), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0810_11), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0818_11), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0820_11), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0828_11), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0830_11), 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0838_11), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0839_11), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083a_11), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_083b_11), 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ CPUFUNC(op_0840_11), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0850_11), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0858_11), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0860_11), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0868_11), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0870_11), 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0878_11), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0879_11), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ CPUFUNC(op_0880_11), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0890_11), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_0898_11), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a0_11), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08a8_11), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b0_11), 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b8_11), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08b9_11), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ CPUFUNC(op_08c0_11), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d0_11), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08d8_11), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e0_11), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08e8_11), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f0_11), 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f8_11), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_08f9_11), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ CPUFUNC(op_0a00_11), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a10_11), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a18_11), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a20_11), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a28_11), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a30_11), 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a38_11), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a39_11), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a3c_11), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a40_11), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a50_11), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a58_11), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a60_11), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a68_11), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a70_11), 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a78_11), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a79_11), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a7c_11), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ CPUFUNC(op_0a80_11), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a90_11), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0a98_11), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa0_11), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0aa8_11), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab0_11), 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab8_11), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0ab9_11), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_0c00_11), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c10_11), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c18_11), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c20_11), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c28_11), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c30_11), 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c38_11), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c39_11), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c40_11), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c50_11), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c58_11), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c60_11), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c68_11), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c70_11), 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c78_11), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c79_11), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c80_11), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c90_11), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0c98_11), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca0_11), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0ca8_11), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb0_11), 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb8_11), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_0cb9_11), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_1000_11), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1010_11), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1018_11), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1020_11), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1028_11), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1030_11), 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1038_11), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1039_11), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103a_11), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103b_11), 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_103c_11), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1080_11), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1090_11), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1098_11), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a0_11), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10a8_11), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b0_11), 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b8_11), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10b9_11), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10ba_11), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bb_11), 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10bc_11), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10c0_11), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d0_11), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10d8_11), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e0_11), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10e8_11), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f0_11), 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f8_11), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10f9_11), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fa_11), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fb_11), 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_10fc_11), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1100_11), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1110_11), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1118_11), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1120_11), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1128_11), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1130_11), 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1138_11), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1139_11), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113a_11), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113b_11), 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_113c_11), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1140_11), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1150_11), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1158_11), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1160_11), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1168_11), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1170_11), 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1178_11), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1179_11), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117a_11), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117b_11), 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_117c_11), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1180_11), 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1190_11), 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_1198_11), 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a0_11), 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11a8_11), 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b0_11), 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b8_11), 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11b9_11), 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11ba_11), 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bb_11), 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_11bc_11), 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11c0_11), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d0_11), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11d8_11), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e0_11), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11e8_11), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f0_11), 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f8_11), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11f9_11), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fa_11), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fb_11), 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_11fc_11), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13c0_11), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d0_11), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13d8_11), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e0_11), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13e8_11), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f0_11), 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f8_11), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13f9_11), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fa_11), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fb_11), 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_13fc_11), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2000_11), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2008_11), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2010_11), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2018_11), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2020_11), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2028_11), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2030_11), 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2038_11), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2039_11), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203a_11), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203b_11), 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_203c_11), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2040_11), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2048_11), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2050_11), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2058_11), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2060_11), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2068_11), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2070_11), 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2078_11), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2079_11), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207a_11), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207b_11), 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_207c_11), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_2080_11), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2088_11), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2090_11), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2098_11), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a0_11), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20a8_11), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b0_11), 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b8_11), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20b9_11), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20ba_11), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bb_11), 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20bc_11), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c0_11), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20c8_11), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d0_11), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20d8_11), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e0_11), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20e8_11), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f0_11), 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f8_11), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20f9_11), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fa_11), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fb_11), 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_20fc_11), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2100_11), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2108_11), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2110_11), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2118_11), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2120_11), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2128_11), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2130_11), 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2138_11), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2139_11), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213a_11), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213b_11), 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_213c_11), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2140_11), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2148_11), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2150_11), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2158_11), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2160_11), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2168_11), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2170_11), 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2178_11), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2179_11), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217a_11), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217b_11), 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_217c_11), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2180_11), 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2188_11), 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2190_11), 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_2198_11), 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a0_11), 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21a8_11), 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b0_11), 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b8_11), 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21b9_11), 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21ba_11), 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bb_11), 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_21bc_11), 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c0_11), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21c8_11), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d0_11), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21d8_11), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e0_11), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21e8_11), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f0_11), 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f8_11), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21f9_11), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fa_11), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fb_11), 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_21fc_11), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c0_11), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23c8_11), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d0_11), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23d8_11), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e0_11), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23e8_11), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f0_11), 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f8_11), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23f9_11), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fa_11), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fb_11), 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_23fc_11), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3000_11), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3008_11), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3010_11), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3018_11), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3020_11), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3028_11), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3030_11), 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3038_11), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3039_11), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303a_11), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303b_11), 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_303c_11), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3040_11), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3048_11), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3050_11), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3058_11), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3060_11), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3068_11), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3070_11), 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3078_11), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3079_11), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307a_11), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307b_11), 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_307c_11), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ CPUFUNC(op_3080_11), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3088_11), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3090_11), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3098_11), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a0_11), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30a8_11), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b0_11), 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b8_11), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30b9_11), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30ba_11), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bb_11), 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30bc_11), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c0_11), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30c8_11), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d0_11), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30d8_11), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e0_11), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30e8_11), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f0_11), 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f8_11), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30f9_11), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fa_11), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fb_11), 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_30fc_11), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3100_11), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3108_11), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3110_11), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3118_11), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3120_11), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3128_11), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3130_11), 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3138_11), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3139_11), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313a_11), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313b_11), 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_313c_11), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3140_11), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3148_11), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3150_11), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3158_11), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3160_11), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3168_11), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3170_11), 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3178_11), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3179_11), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317a_11), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317b_11), 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_317c_11), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3180_11), 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3188_11), 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3190_11), 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_3198_11), 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a0_11), 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31a8_11), 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b0_11), 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b8_11), 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31b9_11), 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31ba_11), 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bb_11), 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ CPUFUNC(op_31bc_11), 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c0_11), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31c8_11), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d0_11), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31d8_11), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e0_11), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31e8_11), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f0_11), 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f8_11), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31f9_11), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fa_11), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fb_11), 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_31fc_11), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c0_11), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33c8_11), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d0_11), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33d8_11), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e0_11), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33e8_11), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f0_11), 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f8_11), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33f9_11), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fa_11), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fb_11), 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_33fc_11), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_4000_11), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4010_11), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4018_11), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4020_11), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4028_11), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4030_11), 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4038_11), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4039_11), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4040_11), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4050_11), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4058_11), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4060_11), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4068_11), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4070_11), 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4078_11), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4079_11), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4080_11), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4090_11), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_4098_11), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a0_11), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40a8_11), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b0_11), 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b8_11), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40b9_11), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ CPUFUNC(op_40c0_12), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d0_12), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40d8_12), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e0_12), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40e8_12), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f0_12), 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f8_12), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_40f9_12), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ CPUFUNC(op_4180_11), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4190_11), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_4198_11), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a0_11), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41a8_11), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b0_11), 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b8_11), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41b9_11), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41ba_11), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bb_11), 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41bc_11), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ CPUFUNC(op_41d0_11), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41e8_11), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f0_11), 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f8_11), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41f9_11), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fa_11), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_41fb_11), 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ CPUFUNC(op_4200_12), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4210_12), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4218_12), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4220_12), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4228_12), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4230_12), 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4238_12), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4239_12), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4240_12), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4250_12), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4258_12), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4260_12), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4268_12), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4270_12), 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4278_12), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4279_12), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4280_12), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4290_12), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4298_12), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a0_12), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42a8_12), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b0_12), 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b8_12), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_42b9_12), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ CPUFUNC(op_4400_11), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4410_11), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4418_11), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4420_11), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4428_11), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4430_11), 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4438_11), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4439_11), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4440_11), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4450_11), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4458_11), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4460_11), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4468_11), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4470_11), 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4478_11), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4479_11), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4480_11), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4490_11), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_4498_11), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a0_11), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44a8_11), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b0_11), 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b8_11), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44b9_11), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ CPUFUNC(op_44c0_11), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d0_11), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44d8_11), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e0_11), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44e8_11), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f0_11), 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f8_11), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44f9_11), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fa_11), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fb_11), 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_44fc_11), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4600_11), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4610_11), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4618_11), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4620_11), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4628_11), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4630_11), 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4638_11), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4639_11), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4640_11), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4650_11), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4658_11), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4660_11), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4668_11), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4670_11), 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4678_11), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4679_11), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4680_11), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4690_11), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_4698_11), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a0_11), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46a8_11), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b0_11), 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b8_11), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46b9_11), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ CPUFUNC(op_46c0_11), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d0_11), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46d8_11), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e0_11), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46e8_11), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f0_11), 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f8_11), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46f9_11), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fa_11), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fb_11), 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_46fc_11), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ CPUFUNC(op_4800_11), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4810_11), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4818_11), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4820_11), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4828_11), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4830_11), 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4838_11), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4839_11), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ CPUFUNC(op_4840_11), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ CPUFUNC(op_4850_11), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4868_11), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4870_11), 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4878_11), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4879_11), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487a_11), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_487b_11), 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ CPUFUNC(op_4880_11), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_4890_11), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a0_11), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48a8_11), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b0_11), 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b8_11), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48b9_11), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48c0_11), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ CPUFUNC(op_48d0_11), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e0_11), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48e8_11), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f0_11), 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f8_11), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_48f9_11), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ CPUFUNC(op_4a00_11), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a10_11), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a18_11), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a20_11), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a28_11), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a30_11), 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a38_11), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a39_11), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a40_11), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a50_11), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a58_11), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a60_11), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a68_11), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a70_11), 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a78_11), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a79_11), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a80_11), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a90_11), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4a98_11), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa0_11), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4aa8_11), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab0_11), 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab8_11), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ab9_11), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ CPUFUNC(op_4ac0_11), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad0_11), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ad8_11), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae0_11), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4ae8_11), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af0_11), 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af8_11), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4af9_11), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ CPUFUNC(op_4c90_11), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4c98_11), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ca8_11), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb0_11), 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb8_11), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cb9_11), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cba_11), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cbb_11), 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd0_11), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cd8_11), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4ce8_11), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf0_11), 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf8_11), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cf9_11), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfa_11), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4cfb_11), 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ CPUFUNC(op_4e40_11), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ CPUFUNC(op_4e50_11), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ CPUFUNC(op_4e58_11), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ CPUFUNC(op_4e60_11), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ CPUFUNC(op_4e68_11), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ CPUFUNC(op_4e70_11), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ CPUFUNC(op_4e71_11), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ CPUFUNC(op_4e72_11), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ CPUFUNC(op_4e73_12), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ CPUFUNC(op_4e75_11), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ CPUFUNC(op_4e76_11), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ CPUFUNC(op_4e77_11), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ CPUFUNC(op_4e90_11), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ea8_11), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb0_11), 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb8_11), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eb9_11), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4eba_11), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ebb_11), 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ CPUFUNC(op_4ed0_11), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ee8_11), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef0_11), 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef8_11), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4ef9_11), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efa_11), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_4efb_11), 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ CPUFUNC(op_5000_11), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5010_11), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5018_11), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5020_11), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5028_11), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5030_11), 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5038_11), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5039_11), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5040_11), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5048_11), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5050_11), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5058_11), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5060_11), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5068_11), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5070_11), 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5078_11), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5079_11), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5080_11), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5088_11), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_5090_11), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_5098_11), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a0_11), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50a8_11), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b0_11), 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b8_11), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50b9_11), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_50c0_12), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50c8_11), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_50d0_12), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50d8_12), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e0_12), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50e8_12), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f0_12), 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f8_12), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_50f9_12), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5100_11), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5110_11), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5118_11), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5120_11), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5128_11), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5130_11), 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5138_11), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5139_11), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5140_11), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5148_11), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5150_11), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5158_11), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5160_11), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5168_11), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5170_11), 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5178_11), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5179_11), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5180_11), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5188_11), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_5190_11), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_5198_11), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a0_11), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51a8_11), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b0_11), 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b8_11), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51b9_11), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_51c0_12), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51c8_11), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_51d0_12), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51d8_12), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e0_12), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51e8_12), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f0_12), 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f8_12), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_51f9_12), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c0_12), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52c8_11), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_52d0_12), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52d8_12), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e0_12), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52e8_12), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f0_12), 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f8_12), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_52f9_12), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c0_12), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53c8_11), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_53d0_12), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53d8_12), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e0_12), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53e8_12), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f0_12), 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f8_12), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_53f9_12), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c0_12), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54c8_11), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_54d0_12), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54d8_12), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e0_12), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54e8_12), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f0_12), 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f8_12), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_54f9_12), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c0_12), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55c8_11), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_55d0_12), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55d8_12), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e0_12), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55e8_12), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f0_12), 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f8_12), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_55f9_12), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c0_12), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56c8_11), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_56d0_12), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56d8_12), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e0_12), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56e8_12), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f0_12), 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f8_12), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_56f9_12), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c0_12), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57c8_11), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_57d0_12), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57d8_12), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e0_12), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57e8_12), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f0_12), 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f8_12), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_57f9_12), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c0_12), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58c8_11), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_58d0_12), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58d8_12), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e0_12), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58e8_12), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f0_12), 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f8_12), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_58f9_12), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c0_12), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59c8_11), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_59d0_12), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59d8_12), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e0_12), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59e8_12), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f0_12), 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f8_12), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_59f9_12), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac0_12), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ac8_11), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ad0_12), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ad8_12), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae0_12), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ae8_12), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af0_12), 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af8_12), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5af9_12), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc0_12), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bc8_11), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5bd0_12), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bd8_12), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be0_12), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5be8_12), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf0_12), 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf8_12), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5bf9_12), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc0_12), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cc8_11), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5cd0_12), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cd8_12), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce0_12), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ce8_12), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf0_12), 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf8_12), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5cf9_12), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc0_12), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dc8_11), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5dd0_12), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5dd8_12), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de0_12), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5de8_12), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df0_12), 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df8_12), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5df9_12), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec0_12), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ec8_11), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5ed0_12), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ed8_12), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee0_12), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ee8_12), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef0_12), 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef8_12), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ef9_12), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc0_12), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fc8_11), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ CPUFUNC(op_5fd0_12), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fd8_12), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe0_12), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5fe8_12), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff0_12), 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff8_12), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_5ff9_12), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ CPUFUNC(op_6000_11), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6001_11), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_60ff_11), 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6100_11), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6101_11), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_61ff_11), 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ CPUFUNC(op_6200_11), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6201_11), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_62ff_11), 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6300_11), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6301_11), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_63ff_11), 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6400_11), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6401_11), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_64ff_11), 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6500_11), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6501_11), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_65ff_11), 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6600_11), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6601_11), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_66ff_11), 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6700_11), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6701_11), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_67ff_11), 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6800_11), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6801_11), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_68ff_11), 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6900_11), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6901_11), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_69ff_11), 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6a00_11), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6a01_11), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6aff_11), 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6b00_11), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6b01_11), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6bff_11), 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6c00_11), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6c01_11), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6cff_11), 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6d00_11), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6d01_11), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6dff_11), 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6e00_11), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6e01_11), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6eff_11), 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_6f00_11), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6f01_11), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ CPUFUNC(op_6fff_11), 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ CPUFUNC(op_7000_11), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ CPUFUNC(op_8000_11), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8010_11), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8018_11), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8020_11), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8028_11), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8030_11), 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8038_11), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8039_11), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803a_11), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803b_11), 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_803c_11), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8040_11), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8050_11), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8058_11), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8060_11), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8068_11), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8070_11), 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8078_11), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8079_11), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807a_11), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807b_11), 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_807c_11), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8080_11), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8090_11), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8098_11), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a0_11), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80a8_11), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b0_11), 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b8_11), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80b9_11), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80ba_11), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bb_11), 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80bc_11), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_80c0_11), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d0_11), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80d8_11), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e0_11), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80e8_11), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f0_11), 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f8_11), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80f9_11), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fa_11), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fb_11), 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_80fc_11), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ CPUFUNC(op_8100_11), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8108_11), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ CPUFUNC(op_8110_11), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8118_11), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8120_11), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8128_11), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8130_11), 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8138_11), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8139_11), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8150_11), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8158_11), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8160_11), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8168_11), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8170_11), 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8178_11), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8179_11), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8190_11), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_8198_11), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a0_11), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81a8_11), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b0_11), 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b8_11), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81b9_11), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ CPUFUNC(op_81c0_11), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d0_11), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81d8_11), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e0_11), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81e8_11), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f0_11), 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f8_11), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81f9_11), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fa_11), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fb_11), 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_81fc_11), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ CPUFUNC(op_9000_11), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9010_11), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9018_11), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9020_11), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9028_11), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9030_11), 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9038_11), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9039_11), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903a_11), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903b_11), 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_903c_11), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9040_11), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9048_11), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9050_11), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9058_11), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9060_11), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9068_11), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9070_11), 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9078_11), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9079_11), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907a_11), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907b_11), 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_907c_11), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9080_11), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9088_11), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9090_11), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9098_11), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a0_11), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90a8_11), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b0_11), 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b8_11), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90b9_11), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90ba_11), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bb_11), 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90bc_11), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_90c0_11), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90c8_11), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d0_11), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90d8_11), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e0_11), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90e8_11), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f0_11), 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f8_11), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90f9_11), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fa_11), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fb_11), 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_90fc_11), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_9100_11), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9108_11), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9110_11), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9118_11), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9120_11), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9128_11), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9130_11), 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9138_11), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9139_11), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9140_11), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9148_11), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9150_11), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9158_11), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9160_11), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9168_11), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9170_11), 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9178_11), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9179_11), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9180_11), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9188_11), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ CPUFUNC(op_9190_11), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_9198_11), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a0_11), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91a8_11), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b0_11), 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b8_11), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91b9_11), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ CPUFUNC(op_91c0_11), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91c8_11), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d0_11), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91d8_11), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e0_11), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91e8_11), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f0_11), 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f8_11), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91f9_11), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fa_11), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fb_11), 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_91fc_11), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ CPUFUNC(op_b000_11), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b010_11), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b018_11), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b020_11), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b028_11), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b030_11), 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b038_11), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b039_11), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03a_11), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03b_11), 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b03c_11), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b040_11), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b048_11), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b050_11), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b058_11), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b060_11), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b068_11), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b070_11), 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b078_11), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b079_11), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07a_11), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07b_11), 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b07c_11), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b080_11), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b088_11), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b090_11), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b098_11), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a0_11), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0a8_11), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b0_11), 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b8_11), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0b9_11), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0ba_11), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bb_11), 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0bc_11), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ CPUFUNC(op_b0c0_11), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0c8_11), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d0_11), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0d8_11), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e0_11), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0e8_11), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f0_11), 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f8_11), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0f9_11), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fa_11), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fb_11), 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b0fc_11), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b100_11), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b108_11), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b110_11), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b118_11), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b120_11), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b128_11), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b130_11), 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b138_11), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b139_11), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b140_11), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b148_11), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b150_11), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b158_11), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b160_11), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b168_11), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b170_11), 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b178_11), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b179_11), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b180_11), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b188_11), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ CPUFUNC(op_b190_11), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b198_11), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a0_11), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1a8_11), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b0_11), 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b8_11), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1b9_11), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ CPUFUNC(op_b1c0_11), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1c8_11), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d0_11), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1d8_11), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e0_11), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1e8_11), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f0_11), 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f8_11), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1f9_11), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fa_11), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fb_11), 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_b1fc_11), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ CPUFUNC(op_c000_11), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c010_11), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c018_11), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c020_11), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c028_11), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c030_11), 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c038_11), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c039_11), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03a_11), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03b_11), 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c03c_11), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c040_11), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c050_11), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c058_11), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c060_11), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c068_11), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c070_11), 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c078_11), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c079_11), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07a_11), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07b_11), 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c07c_11), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c080_11), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c090_11), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c098_11), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a0_11), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0a8_11), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b0_11), 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b8_11), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0b9_11), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0ba_11), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bb_11), 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0bc_11), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c0c0_11), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d0_11), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0d8_11), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e0_11), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0e8_11), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f0_11), 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f8_11), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0f9_11), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fa_11), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fb_11), 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c0fc_11), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ CPUFUNC(op_c100_11), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c108_11), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ CPUFUNC(op_c110_11), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c118_11), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c120_11), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c128_11), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c130_11), 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c138_11), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c139_11), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c140_11), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c148_11), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c150_11), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c158_11), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c160_11), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c168_11), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c170_11), 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c178_11), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c179_11), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c188_11), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ CPUFUNC(op_c190_11), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c198_11), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a0_11), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1a8_11), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b0_11), 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b8_11), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1b9_11), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ CPUFUNC(op_c1c0_11), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d0_11), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1d8_11), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e0_11), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1e8_11), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f0_11), 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f8_11), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1f9_11), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fa_11), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fb_11), 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_c1fc_11), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ CPUFUNC(op_d000_11), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d010_11), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d018_11), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d020_11), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d028_11), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d030_11), 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d038_11), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d039_11), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03a_11), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03b_11), 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d03c_11), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d040_11), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d048_11), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d050_11), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d058_11), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d060_11), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d068_11), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d070_11), 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d078_11), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d079_11), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07a_11), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07b_11), 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d07c_11), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d080_11), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d088_11), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d090_11), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d098_11), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a0_11), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0a8_11), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b0_11), 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b8_11), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0b9_11), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0ba_11), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bb_11), 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0bc_11), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d0c0_11), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0c8_11), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d0_11), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0d8_11), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e0_11), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0e8_11), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f0_11), 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f8_11), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0f9_11), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fa_11), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fb_11), 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d0fc_11), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d100_11), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d108_11), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d110_11), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d118_11), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d120_11), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d128_11), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d130_11), 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d138_11), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d139_11), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d140_11), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d148_11), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d150_11), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d158_11), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d160_11), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d168_11), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d170_11), 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d178_11), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d179_11), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d180_11), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d188_11), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ CPUFUNC(op_d190_11), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d198_11), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a0_11), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1a8_11), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b0_11), 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b8_11), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1b9_11), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ CPUFUNC(op_d1c0_11), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1c8_11), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d0_11), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1d8_11), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e0_11), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1e8_11), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f0_11), 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f8_11), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1f9_11), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fa_11), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fb_11), 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_d1fc_11), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ CPUFUNC(op_e000_11), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e008_11), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e010_11), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e018_11), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e020_11), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e028_11), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e030_11), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e038_11), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e040_11), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e048_11), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e050_11), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e058_11), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e060_11), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e068_11), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e070_11), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e078_11), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e080_11), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e088_11), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e090_11), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e098_11), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0a0_11), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ CPUFUNC(op_e0a8_11), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ CPUFUNC(op_e0b0_11), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ CPUFUNC(op_e0b8_11), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ CPUFUNC(op_e0d0_11), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0d8_11), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e0_11), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0e8_11), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f0_11), 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f8_11), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e0f9_11), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ CPUFUNC(op_e100_11), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e108_11), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e110_11), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e118_11), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e120_11), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e128_11), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e130_11), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e138_11), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e140_11), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e148_11), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e150_11), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e158_11), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e160_11), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e168_11), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e170_11), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e178_11), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e180_11), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e188_11), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e190_11), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e198_11), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1a0_11), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ CPUFUNC(op_e1a8_11), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ CPUFUNC(op_e1b0_11), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ CPUFUNC(op_e1b8_11), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ CPUFUNC(op_e1d0_11), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1d8_11), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e0_11), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1e8_11), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f0_11), 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f8_11), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e1f9_11), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ CPUFUNC(op_e2d0_11), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2d8_11), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e0_11), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2e8_11), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f0_11), 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f8_11), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e2f9_11), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ CPUFUNC(op_e3d0_11), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3d8_11), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e0_11), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3e8_11), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f0_11), 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f8_11), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e3f9_11), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ CPUFUNC(op_e4d0_11), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4d8_11), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e0_11), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4e8_11), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f0_11), 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f8_11), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e4f9_11), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ CPUFUNC(op_e5d0_11), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5d8_11), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e0_11), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5e8_11), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f0_11), 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f8_11), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e5f9_11), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ CPUFUNC(op_e6d0_11), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6d8_11), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e0_11), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6e8_11), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f0_11), 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f8_11), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e6f9_11), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ CPUFUNC(op_e7d0_11), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7d8_11), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e0_11), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7e8_11), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f0_11), 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f8_11), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ CPUFUNC(op_e7f9_11), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ 0, 0 }};
#endif /* CPUEMU_11 */
#ifdef CPUEMU_13
const struct cputbl CPUFUNC(op_smalltbl_13)[] = {
{ (cpuop_func*)CPUFUNC(op_0000_13), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0010_13), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0018_13), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0020_13), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0028_13), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0030_13), 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0038_13), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0039_13), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_003c_13), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ (cpuop_func*)CPUFUNC(op_0040_13), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0050_13), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0058_13), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0060_13), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0068_13), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0070_13), 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0078_13), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0079_13), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_007c_13), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ (cpuop_func*)CPUFUNC(op_0080_13), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0090_13), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0098_13), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00a0_13), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00a8_13), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00b0_13), 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00b8_13), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00b9_13), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0100_13), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0108_13), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ (cpuop_func*)CPUFUNC(op_0110_13), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0118_13), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0120_13), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0128_13), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0130_13), 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0138_13), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0139_13), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_013a_13), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_013b_13), 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_013c_13), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0140_13), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0148_13), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ (cpuop_func*)CPUFUNC(op_0150_13), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0158_13), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0160_13), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0168_13), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0170_13), 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0178_13), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0179_13), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0180_13), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_0188_13), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ (cpuop_func*)CPUFUNC(op_0190_13), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_0198_13), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01a0_13), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01a8_13), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01b0_13), 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01b8_13), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01b9_13), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01c0_13), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01c8_13), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ (cpuop_func*)CPUFUNC(op_01d0_13), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01d8_13), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01e0_13), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01e8_13), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01f0_13), 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01f8_13), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01f9_13), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_0200_13), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0210_13), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0218_13), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0220_13), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0228_13), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0230_13), 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0238_13), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0239_13), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_023c_13), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ (cpuop_func*)CPUFUNC(op_0240_13), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0250_13), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0258_13), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0260_13), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0268_13), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0270_13), 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0278_13), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0279_13), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_027c_13), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ (cpuop_func*)CPUFUNC(op_0280_13), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0290_13), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0298_13), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02a0_13), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02a8_13), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02b0_13), 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02b8_13), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02b9_13), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0400_13), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0410_13), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0418_13), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0420_13), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0428_13), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0430_13), 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0438_13), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0439_13), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0440_13), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0450_13), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0458_13), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0460_13), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0468_13), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0470_13), 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0478_13), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0479_13), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0480_13), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0490_13), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0498_13), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04a0_13), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04a8_13), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04b0_13), 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04b8_13), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04b9_13), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0600_13), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0610_13), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0618_13), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0620_13), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0628_13), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0630_13), 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0638_13), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0639_13), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0640_13), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0650_13), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0658_13), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0660_13), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0668_13), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0670_13), 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0678_13), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0679_13), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0680_13), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0690_13), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0698_13), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06a0_13), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06a8_13), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06b0_13), 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06b8_13), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06b9_13), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0800_13), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0810_13), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0818_13), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0820_13), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0828_13), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0830_13), 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0838_13), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0839_13), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_083a_13), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_083b_13), 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0840_13), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0850_13), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0858_13), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0860_13), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0868_13), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0870_13), 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0878_13), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0879_13), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0880_13), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_0890_13), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_0898_13), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08a0_13), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08a8_13), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08b0_13), 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08b8_13), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08b9_13), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08c0_13), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08d0_13), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08d8_13), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08e0_13), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08e8_13), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08f0_13), 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08f8_13), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08f9_13), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_0a00_13), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a10_13), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a18_13), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a20_13), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a28_13), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a30_13), 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a38_13), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a39_13), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a3c_13), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ (cpuop_func*)CPUFUNC(op_0a40_13), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a50_13), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a58_13), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a60_13), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a68_13), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a70_13), 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a78_13), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a79_13), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a7c_13), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ (cpuop_func*)CPUFUNC(op_0a80_13), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a90_13), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a98_13), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0aa0_13), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0aa8_13), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0ab0_13), 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0ab8_13), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0ab9_13), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0c00_13), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c10_13), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c18_13), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c20_13), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c28_13), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c30_13), 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c38_13), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c39_13), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c40_13), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c50_13), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c58_13), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c60_13), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c68_13), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c70_13), 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c78_13), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c79_13), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c80_13), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c90_13), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c98_13), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0ca0_13), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0ca8_13), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0cb0_13), 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0cb8_13), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0cb9_13), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_1000_13), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1010_13), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1018_13), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1020_13), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1028_13), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1030_13), 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1038_13), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1039_13), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_103a_13), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_103b_13), 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_103c_13), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1080_13), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1090_13), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1098_13), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10a0_13), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10a8_13), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10b0_13), 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10b8_13), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10b9_13), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10ba_13), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10bb_13), 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10bc_13), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10c0_13), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10d0_13), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10d8_13), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10e0_13), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10e8_13), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10f0_13), 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10f8_13), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10f9_13), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10fa_13), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10fb_13), 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10fc_13), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1100_13), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1110_13), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1118_13), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1120_13), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1128_13), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1130_13), 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1138_13), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1139_13), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_113a_13), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_113b_13), 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_113c_13), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1140_13), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1150_13), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1158_13), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1160_13), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1168_13), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1170_13), 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1178_13), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1179_13), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_117a_13), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_117b_13), 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_117c_13), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1180_13), 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1190_13), 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1198_13), 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11a0_13), 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11a8_13), 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11b0_13), 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11b8_13), 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11b9_13), 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11ba_13), 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11bb_13), 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11bc_13), 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11c0_13), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11d0_13), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11d8_13), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11e0_13), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11e8_13), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11f0_13), 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11f8_13), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11f9_13), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11fa_13), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11fb_13), 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11fc_13), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13c0_13), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13d0_13), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13d8_13), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13e0_13), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13e8_13), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13f0_13), 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13f8_13), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13f9_13), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13fa_13), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13fb_13), 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13fc_13), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2000_13), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2008_13), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2010_13), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2018_13), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2020_13), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2028_13), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2030_13), 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2038_13), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2039_13), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_203a_13), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_203b_13), 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_203c_13), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2040_13), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2048_13), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2050_13), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2058_13), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2060_13), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2068_13), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2070_13), 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2078_13), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2079_13), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_207a_13), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_207b_13), 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_207c_13), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2080_13), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2088_13), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2090_13), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2098_13), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20a0_13), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20a8_13), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20b0_13), 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20b8_13), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20b9_13), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20ba_13), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20bb_13), 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20bc_13), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20c0_13), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20c8_13), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20d0_13), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20d8_13), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20e0_13), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20e8_13), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20f0_13), 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20f8_13), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20f9_13), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20fa_13), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20fb_13), 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20fc_13), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2100_13), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2108_13), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2110_13), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2118_13), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2120_13), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2128_13), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2130_13), 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2138_13), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2139_13), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_213a_13), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_213b_13), 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_213c_13), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2140_13), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2148_13), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2150_13), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2158_13), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2160_13), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2168_13), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2170_13), 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2178_13), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2179_13), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_217a_13), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_217b_13), 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_217c_13), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2180_13), 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2188_13), 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2190_13), 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2198_13), 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21a0_13), 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21a8_13), 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21b0_13), 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21b8_13), 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21b9_13), 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21ba_13), 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21bb_13), 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21bc_13), 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21c0_13), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21c8_13), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21d0_13), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21d8_13), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21e0_13), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21e8_13), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21f0_13), 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21f8_13), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21f9_13), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21fa_13), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21fb_13), 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21fc_13), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23c0_13), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23c8_13), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23d0_13), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23d8_13), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23e0_13), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23e8_13), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23f0_13), 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23f8_13), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23f9_13), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23fa_13), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23fb_13), 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23fc_13), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3000_13), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3008_13), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3010_13), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3018_13), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3020_13), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3028_13), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3030_13), 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3038_13), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3039_13), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_303a_13), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_303b_13), 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_303c_13), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3040_13), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3048_13), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3050_13), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3058_13), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3060_13), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3068_13), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3070_13), 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3078_13), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3079_13), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_307a_13), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_307b_13), 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_307c_13), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3080_13), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3088_13), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3090_13), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3098_13), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30a0_13), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30a8_13), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30b0_13), 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30b8_13), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30b9_13), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30ba_13), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30bb_13), 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30bc_13), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30c0_13), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30c8_13), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30d0_13), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30d8_13), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30e0_13), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30e8_13), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30f0_13), 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30f8_13), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30f9_13), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30fa_13), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30fb_13), 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30fc_13), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3100_13), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3108_13), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3110_13), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3118_13), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3120_13), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3128_13), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3130_13), 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3138_13), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3139_13), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_313a_13), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_313b_13), 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_313c_13), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3140_13), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3148_13), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3150_13), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3158_13), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3160_13), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3168_13), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3170_13), 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3178_13), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3179_13), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_317a_13), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_317b_13), 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_317c_13), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3180_13), 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3188_13), 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3190_13), 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3198_13), 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31a0_13), 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31a8_13), 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31b0_13), 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31b8_13), 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31b9_13), 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31ba_13), 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31bb_13), 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31bc_13), 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31c0_13), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31c8_13), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31d0_13), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31d8_13), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31e0_13), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31e8_13), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31f0_13), 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31f8_13), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31f9_13), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31fa_13), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31fb_13), 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31fc_13), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33c0_13), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33c8_13), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33d0_13), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33d8_13), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33e0_13), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33e8_13), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33f0_13), 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33f8_13), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33f9_13), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33fa_13), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33fb_13), 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33fc_13), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_4000_13), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4010_13), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4018_13), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4020_13), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4028_13), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4030_13), 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4038_13), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4039_13), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4040_13), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4050_13), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4058_13), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4060_13), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4068_13), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4070_13), 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4078_13), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4079_13), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4080_13), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4090_13), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4098_13), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40a0_13), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40a8_13), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40b0_13), 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40b8_13), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40b9_13), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40c0_13), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40d0_13), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40d8_13), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40e0_13), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40e8_13), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40f0_13), 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40f8_13), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40f9_13), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_4180_13), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_4190_13), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_4198_13), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41a0_13), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41a8_13), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41b0_13), 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41b8_13), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41b9_13), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41ba_13), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41bb_13), 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41bc_13), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41d0_13), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41e8_13), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41f0_13), 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41f8_13), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41f9_13), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41fa_13), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41fb_13), 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_4200_13), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4210_13), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4218_13), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4220_13), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4228_13), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4230_13), 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4238_13), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4239_13), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4240_13), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4250_13), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4258_13), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4260_13), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4268_13), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4270_13), 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4278_13), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4279_13), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4280_13), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4290_13), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4298_13), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42a0_13), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42a8_13), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42b0_13), 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42b8_13), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42b9_13), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_42c0_13), 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_42d0_13), 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_42d8_13), 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_42e0_13), 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_42e8_13), 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_42f0_13), 0x42f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_42f8_13), 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_42f9_13), 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
#endif
{ (cpuop_func*)CPUFUNC(op_4400_13), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4410_13), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4418_13), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4420_13), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4428_13), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4430_13), 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4438_13), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4439_13), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4440_13), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4450_13), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4458_13), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4460_13), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4468_13), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4470_13), 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4478_13), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4479_13), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4480_13), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4490_13), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4498_13), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44a0_13), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44a8_13), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44b0_13), 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44b8_13), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44b9_13), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44c0_13), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44d0_13), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44d8_13), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44e0_13), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44e8_13), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44f0_13), 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44f8_13), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44f9_13), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44fa_13), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44fb_13), 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44fc_13), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_4600_13), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4610_13), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4618_13), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4620_13), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4628_13), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4630_13), 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4638_13), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4639_13), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4640_13), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4650_13), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4658_13), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4660_13), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4668_13), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4670_13), 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4678_13), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4679_13), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4680_13), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4690_13), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4698_13), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46a0_13), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46a8_13), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46b0_13), 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46b8_13), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46b9_13), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46c0_13), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46d0_13), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46d8_13), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46e0_13), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46e8_13), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46f0_13), 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46f8_13), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46f9_13), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46fa_13), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46fb_13), 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46fc_13), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_4800_13), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4810_13), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4818_13), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4820_13), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4828_13), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4830_13), 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4838_13), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4839_13), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4840_13), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ (cpuop_func*)CPUFUNC(op_4850_13), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4868_13), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4870_13), 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4878_13), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4879_13), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_487a_13), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_487b_13), 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4880_13), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ (cpuop_func*)CPUFUNC(op_4890_13), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48a0_13), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48a8_13), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48b0_13), 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48b8_13), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48b9_13), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48c0_13), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ (cpuop_func*)CPUFUNC(op_48d0_13), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48e0_13), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48e8_13), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48f0_13), 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48f8_13), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48f9_13), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_4a00_13), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a10_13), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a18_13), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a20_13), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a28_13), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a30_13), 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a38_13), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a39_13), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a40_13), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a50_13), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a58_13), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a60_13), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a68_13), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a70_13), 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a78_13), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a79_13), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a80_13), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a90_13), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a98_13), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4aa0_13), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4aa8_13), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4ab0_13), 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4ab8_13), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4ab9_13), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4ac0_13), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4ad0_13), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4ad8_13), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4ae0_13), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4ae8_13), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4af0_13), 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4af8_13), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4af9_13), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4c90_13), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4c98_13), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4ca8_13), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cb0_13), 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cb8_13), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cb9_13), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cba_13), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cbb_13), 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cd0_13), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cd8_13), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4ce8_13), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cf0_13), 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cf8_13), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cf9_13), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cfa_13), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cfb_13), 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4e40_13), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ (cpuop_func*)CPUFUNC(op_4e50_13), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ (cpuop_func*)CPUFUNC(op_4e58_13), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ (cpuop_func*)CPUFUNC(op_4e60_13), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ (cpuop_func*)CPUFUNC(op_4e68_13), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ (cpuop_func*)CPUFUNC(op_4e70_13), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ (cpuop_func*)CPUFUNC(op_4e71_13), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ (cpuop_func*)CPUFUNC(op_4e72_13), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ (cpuop_func*)CPUFUNC(op_4e73_13), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_4e74_13), 0x4e74, 4, { 0, 0 }, 1 }, /* RTD */
#endif
{ (cpuop_func*)CPUFUNC(op_4e75_13), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ (cpuop_func*)CPUFUNC(op_4e76_13), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ (cpuop_func*)CPUFUNC(op_4e77_13), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_4e7a_13), 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ (cpuop_func*)CPUFUNC(op_4e7b_13), 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
#endif
{ (cpuop_func*)CPUFUNC(op_4e90_13), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4ea8_13), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4eb0_13), 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4eb8_13), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4eb9_13), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4eba_13), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4ebb_13), 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4ed0_13), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4ee8_13), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4ef0_13), 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4ef8_13), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4ef9_13), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4efa_13), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4efb_13), 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_5000_13), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5010_13), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5018_13), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5020_13), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5028_13), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5030_13), 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5038_13), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5039_13), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5040_13), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5048_13), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_5050_13), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5058_13), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5060_13), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5068_13), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5070_13), 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5078_13), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5079_13), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5080_13), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5088_13), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_5090_13), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5098_13), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50a0_13), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50a8_13), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50b0_13), 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50b8_13), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50b9_13), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50c0_13), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50c8_13), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_50d0_13), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50d8_13), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50e0_13), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50e8_13), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50f0_13), 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50f8_13), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50f9_13), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5100_13), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5110_13), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5118_13), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5120_13), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5128_13), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5130_13), 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5138_13), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5139_13), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5140_13), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5148_13), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_5150_13), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5158_13), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5160_13), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5168_13), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5170_13), 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5178_13), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5179_13), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5180_13), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5188_13), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_5190_13), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5198_13), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51a0_13), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51a8_13), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51b0_13), 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51b8_13), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51b9_13), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51c0_13), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51c8_13), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_51d0_13), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51d8_13), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51e0_13), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51e8_13), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51f0_13), 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51f8_13), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51f9_13), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52c0_13), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52c8_13), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_52d0_13), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52d8_13), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52e0_13), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52e8_13), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52f0_13), 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52f8_13), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52f9_13), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53c0_13), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53c8_13), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_53d0_13), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53d8_13), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53e0_13), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53e8_13), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53f0_13), 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53f8_13), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53f9_13), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54c0_13), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54c8_13), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_54d0_13), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54d8_13), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54e0_13), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54e8_13), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54f0_13), 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54f8_13), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54f9_13), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55c0_13), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55c8_13), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_55d0_13), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55d8_13), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55e0_13), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55e8_13), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55f0_13), 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55f8_13), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55f9_13), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56c0_13), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56c8_13), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_56d0_13), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56d8_13), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56e0_13), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56e8_13), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56f0_13), 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56f8_13), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56f9_13), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57c0_13), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57c8_13), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_57d0_13), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57d8_13), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57e0_13), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57e8_13), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57f0_13), 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57f8_13), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57f9_13), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58c0_13), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58c8_13), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_58d0_13), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58d8_13), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58e0_13), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58e8_13), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58f0_13), 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58f8_13), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58f9_13), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59c0_13), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59c8_13), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_59d0_13), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59d8_13), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59e0_13), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59e8_13), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59f0_13), 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59f8_13), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59f9_13), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ac0_13), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ac8_13), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5ad0_13), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ad8_13), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ae0_13), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ae8_13), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5af0_13), 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5af8_13), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5af9_13), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bc0_13), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bc8_13), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5bd0_13), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bd8_13), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5be0_13), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5be8_13), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bf0_13), 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bf8_13), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bf9_13), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cc0_13), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cc8_13), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5cd0_13), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cd8_13), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ce0_13), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ce8_13), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cf0_13), 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cf8_13), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cf9_13), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5dc0_13), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5dc8_13), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5dd0_13), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5dd8_13), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5de0_13), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5de8_13), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5df0_13), 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5df8_13), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5df9_13), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ec0_13), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ec8_13), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5ed0_13), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ed8_13), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ee0_13), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ee8_13), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ef0_13), 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ef8_13), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ef9_13), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fc0_13), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fc8_13), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5fd0_13), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fd8_13), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fe0_13), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fe8_13), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ff0_13), 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ff8_13), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ff9_13), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_6000_13), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6001_13), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_60ff_13), 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6100_13), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ (cpuop_func*)CPUFUNC(op_6101_13), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ (cpuop_func*)CPUFUNC(op_61ff_13), 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ (cpuop_func*)CPUFUNC(op_6200_13), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6201_13), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_62ff_13), 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6300_13), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6301_13), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_63ff_13), 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6400_13), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6401_13), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_64ff_13), 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6500_13), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6501_13), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_65ff_13), 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6600_13), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6601_13), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_66ff_13), 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6700_13), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6701_13), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_67ff_13), 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6800_13), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6801_13), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_68ff_13), 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6900_13), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6901_13), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_69ff_13), 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6a00_13), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6a01_13), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6aff_13), 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6b00_13), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6b01_13), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6bff_13), 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6c00_13), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6c01_13), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6cff_13), 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6d00_13), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6d01_13), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6dff_13), 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6e00_13), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6e01_13), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6eff_13), 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6f00_13), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6f01_13), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6fff_13), 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_7000_13), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_8000_13), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8010_13), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8018_13), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8020_13), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8028_13), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8030_13), 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8038_13), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8039_13), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_803a_13), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_803b_13), 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_803c_13), 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8040_13), 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8050_13), 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8058_13), 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8060_13), 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8068_13), 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8070_13), 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8078_13), 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8079_13), 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_807a_13), 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_807b_13), 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_807c_13), 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8080_13), 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8090_13), 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8098_13), 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80a0_13), 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80a8_13), 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80b0_13), 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80b8_13), 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80b9_13), 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80ba_13), 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80bb_13), 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80bc_13), 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_80c0_13), 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80d0_13), 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80d8_13), 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80e0_13), 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80e8_13), 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80f0_13), 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80f8_13), 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80f9_13), 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80fa_13), 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80fb_13), 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_80fc_13), 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ (cpuop_func*)CPUFUNC(op_8100_13), 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ (cpuop_func*)CPUFUNC(op_8108_13), 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ (cpuop_func*)CPUFUNC(op_8110_13), 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8118_13), 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8120_13), 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8128_13), 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8130_13), 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8138_13), 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8139_13), 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8150_13), 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8158_13), 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8160_13), 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8168_13), 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8170_13), 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8178_13), 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8179_13), 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8190_13), 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8198_13), 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_81a0_13), 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_81a8_13), 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_81b0_13), 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_81b8_13), 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_81b9_13), 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_81c0_13), 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81d0_13), 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81d8_13), 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81e0_13), 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81e8_13), 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81f0_13), 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81f8_13), 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81f9_13), 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81fa_13), 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81fb_13), 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_81fc_13), 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ (cpuop_func*)CPUFUNC(op_9000_13), 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9010_13), 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9018_13), 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9020_13), 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9028_13), 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9030_13), 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9038_13), 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9039_13), 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_903a_13), 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_903b_13), 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_903c_13), 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9040_13), 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9048_13), 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9050_13), 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9058_13), 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9060_13), 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9068_13), 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9070_13), 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9078_13), 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9079_13), 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_907a_13), 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_907b_13), 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_907c_13), 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9080_13), 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9088_13), 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9090_13), 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9098_13), 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90a0_13), 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90a8_13), 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90b0_13), 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90b8_13), 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90b9_13), 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90ba_13), 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90bb_13), 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90bc_13), 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_90c0_13), 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90c8_13), 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90d0_13), 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90d8_13), 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90e0_13), 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90e8_13), 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90f0_13), 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90f8_13), 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90f9_13), 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90fa_13), 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90fb_13), 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_90fc_13), 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_9100_13), 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ (cpuop_func*)CPUFUNC(op_9108_13), 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ (cpuop_func*)CPUFUNC(op_9110_13), 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9118_13), 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9120_13), 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9128_13), 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9130_13), 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9138_13), 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9139_13), 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9140_13), 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ (cpuop_func*)CPUFUNC(op_9148_13), 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ (cpuop_func*)CPUFUNC(op_9150_13), 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9158_13), 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9160_13), 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9168_13), 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9170_13), 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9178_13), 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9179_13), 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9180_13), 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ (cpuop_func*)CPUFUNC(op_9188_13), 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ (cpuop_func*)CPUFUNC(op_9190_13), 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_9198_13), 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_91a0_13), 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_91a8_13), 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_91b0_13), 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_91b8_13), 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_91b9_13), 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_91c0_13), 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91c8_13), 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91d0_13), 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91d8_13), 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91e0_13), 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91e8_13), 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91f0_13), 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91f8_13), 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91f9_13), 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91fa_13), 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91fb_13), 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_91fc_13), 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_b000_13), 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b010_13), 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b018_13), 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b020_13), 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b028_13), 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b030_13), 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b038_13), 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b039_13), 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b03a_13), 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b03b_13), 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b03c_13), 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b040_13), 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b048_13), 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b050_13), 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b058_13), 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b060_13), 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b068_13), 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b070_13), 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b078_13), 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b079_13), 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b07a_13), 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b07b_13), 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b07c_13), 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b080_13), 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b088_13), 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b090_13), 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b098_13), 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0a0_13), 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0a8_13), 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0b0_13), 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0b8_13), 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0b9_13), 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0ba_13), 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0bb_13), 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0bc_13), 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_b0c0_13), 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0c8_13), 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0d0_13), 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0d8_13), 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0e0_13), 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0e8_13), 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0f0_13), 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0f8_13), 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0f9_13), 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0fa_13), 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0fb_13), 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b0fc_13), 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b100_13), 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b108_13), 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ (cpuop_func*)CPUFUNC(op_b110_13), 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b118_13), 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b120_13), 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b128_13), 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b130_13), 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b138_13), 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b139_13), 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b140_13), 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b148_13), 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ (cpuop_func*)CPUFUNC(op_b150_13), 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b158_13), 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b160_13), 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b168_13), 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b170_13), 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b178_13), 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b179_13), 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b180_13), 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b188_13), 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ (cpuop_func*)CPUFUNC(op_b190_13), 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b198_13), 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b1a0_13), 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b1a8_13), 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b1b0_13), 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b1b8_13), 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b1b9_13), 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_b1c0_13), 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1c8_13), 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1d0_13), 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1d8_13), 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1e0_13), 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1e8_13), 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1f0_13), 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1f8_13), 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1f9_13), 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1fa_13), 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1fb_13), 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_b1fc_13), 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ (cpuop_func*)CPUFUNC(op_c000_13), 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c010_13), 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c018_13), 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c020_13), 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c028_13), 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c030_13), 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c038_13), 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c039_13), 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c03a_13), 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c03b_13), 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c03c_13), 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c040_13), 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c050_13), 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c058_13), 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c060_13), 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c068_13), 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c070_13), 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c078_13), 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c079_13), 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c07a_13), 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c07b_13), 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c07c_13), 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c080_13), 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c090_13), 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c098_13), 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0a0_13), 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0a8_13), 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0b0_13), 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0b8_13), 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0b9_13), 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0ba_13), 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0bb_13), 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0bc_13), 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c0c0_13), 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0d0_13), 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0d8_13), 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0e0_13), 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0e8_13), 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0f0_13), 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0f8_13), 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0f9_13), 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0fa_13), 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0fb_13), 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c0fc_13), 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ (cpuop_func*)CPUFUNC(op_c100_13), 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ (cpuop_func*)CPUFUNC(op_c108_13), 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ (cpuop_func*)CPUFUNC(op_c110_13), 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c118_13), 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c120_13), 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c128_13), 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c130_13), 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c138_13), 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c139_13), 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c140_13), 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ (cpuop_func*)CPUFUNC(op_c148_13), 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ (cpuop_func*)CPUFUNC(op_c150_13), 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c158_13), 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c160_13), 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c168_13), 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c170_13), 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c178_13), 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c179_13), 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c188_13), 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ (cpuop_func*)CPUFUNC(op_c190_13), 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c198_13), 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c1a0_13), 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c1a8_13), 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c1b0_13), 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c1b8_13), 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c1b9_13), 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_c1c0_13), 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1d0_13), 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1d8_13), 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1e0_13), 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1e8_13), 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1f0_13), 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1f8_13), 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1f9_13), 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1fa_13), 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1fb_13), 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_c1fc_13), 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ (cpuop_func*)CPUFUNC(op_d000_13), 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d010_13), 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d018_13), 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d020_13), 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d028_13), 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d030_13), 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d038_13), 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d039_13), 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d03a_13), 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d03b_13), 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d03c_13), 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d040_13), 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d048_13), 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d050_13), 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d058_13), 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d060_13), 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d068_13), 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d070_13), 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d078_13), 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d079_13), 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d07a_13), 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d07b_13), 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d07c_13), 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d080_13), 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d088_13), 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d090_13), 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d098_13), 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0a0_13), 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0a8_13), 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0b0_13), 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0b8_13), 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0b9_13), 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0ba_13), 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0bb_13), 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0bc_13), 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d0c0_13), 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0c8_13), 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0d0_13), 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0d8_13), 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0e0_13), 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0e8_13), 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0f0_13), 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0f8_13), 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0f9_13), 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0fa_13), 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0fb_13), 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d0fc_13), 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d100_13), 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ (cpuop_func*)CPUFUNC(op_d108_13), 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ (cpuop_func*)CPUFUNC(op_d110_13), 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d118_13), 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d120_13), 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d128_13), 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d130_13), 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d138_13), 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d139_13), 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d140_13), 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ (cpuop_func*)CPUFUNC(op_d148_13), 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ (cpuop_func*)CPUFUNC(op_d150_13), 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d158_13), 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d160_13), 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d168_13), 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d170_13), 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d178_13), 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d179_13), 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d180_13), 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ (cpuop_func*)CPUFUNC(op_d188_13), 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ (cpuop_func*)CPUFUNC(op_d190_13), 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d198_13), 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d1a0_13), 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d1a8_13), 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d1b0_13), 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d1b8_13), 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d1b9_13), 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_d1c0_13), 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1c8_13), 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1d0_13), 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1d8_13), 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1e0_13), 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1e8_13), 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1f0_13), 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1f8_13), 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1f9_13), 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1fa_13), 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1fb_13), 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_d1fc_13), 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_e000_13), 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ (cpuop_func*)CPUFUNC(op_e008_13), 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ (cpuop_func*)CPUFUNC(op_e010_13), 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ (cpuop_func*)CPUFUNC(op_e018_13), 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ (cpuop_func*)CPUFUNC(op_e020_13), 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ (cpuop_func*)CPUFUNC(op_e028_13), 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ (cpuop_func*)CPUFUNC(op_e030_13), 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ (cpuop_func*)CPUFUNC(op_e038_13), 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ (cpuop_func*)CPUFUNC(op_e040_13), 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ (cpuop_func*)CPUFUNC(op_e048_13), 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ (cpuop_func*)CPUFUNC(op_e050_13), 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ (cpuop_func*)CPUFUNC(op_e058_13), 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ (cpuop_func*)CPUFUNC(op_e060_13), 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ (cpuop_func*)CPUFUNC(op_e068_13), 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ (cpuop_func*)CPUFUNC(op_e070_13), 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ (cpuop_func*)CPUFUNC(op_e078_13), 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ (cpuop_func*)CPUFUNC(op_e080_13), 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ (cpuop_func*)CPUFUNC(op_e088_13), 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ (cpuop_func*)CPUFUNC(op_e090_13), 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ (cpuop_func*)CPUFUNC(op_e098_13), 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ (cpuop_func*)CPUFUNC(op_e0a0_13), 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ (cpuop_func*)CPUFUNC(op_e0a8_13), 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ (cpuop_func*)CPUFUNC(op_e0b0_13), 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ (cpuop_func*)CPUFUNC(op_e0b8_13), 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ (cpuop_func*)CPUFUNC(op_e0d0_13), 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ (cpuop_func*)CPUFUNC(op_e0d8_13), 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ (cpuop_func*)CPUFUNC(op_e0e0_13), 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ (cpuop_func*)CPUFUNC(op_e0e8_13), 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ (cpuop_func*)CPUFUNC(op_e0f0_13), 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ (cpuop_func*)CPUFUNC(op_e0f8_13), 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ (cpuop_func*)CPUFUNC(op_e0f9_13), 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ (cpuop_func*)CPUFUNC(op_e100_13), 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ (cpuop_func*)CPUFUNC(op_e108_13), 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ (cpuop_func*)CPUFUNC(op_e110_13), 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ (cpuop_func*)CPUFUNC(op_e118_13), 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ (cpuop_func*)CPUFUNC(op_e120_13), 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ (cpuop_func*)CPUFUNC(op_e128_13), 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ (cpuop_func*)CPUFUNC(op_e130_13), 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ (cpuop_func*)CPUFUNC(op_e138_13), 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ (cpuop_func*)CPUFUNC(op_e140_13), 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ (cpuop_func*)CPUFUNC(op_e148_13), 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ (cpuop_func*)CPUFUNC(op_e150_13), 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ (cpuop_func*)CPUFUNC(op_e158_13), 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ (cpuop_func*)CPUFUNC(op_e160_13), 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ (cpuop_func*)CPUFUNC(op_e168_13), 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ (cpuop_func*)CPUFUNC(op_e170_13), 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ (cpuop_func*)CPUFUNC(op_e178_13), 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ (cpuop_func*)CPUFUNC(op_e180_13), 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ (cpuop_func*)CPUFUNC(op_e188_13), 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ (cpuop_func*)CPUFUNC(op_e190_13), 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ (cpuop_func*)CPUFUNC(op_e198_13), 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ (cpuop_func*)CPUFUNC(op_e1a0_13), 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ (cpuop_func*)CPUFUNC(op_e1a8_13), 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ (cpuop_func*)CPUFUNC(op_e1b0_13), 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ (cpuop_func*)CPUFUNC(op_e1b8_13), 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ (cpuop_func*)CPUFUNC(op_e1d0_13), 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ (cpuop_func*)CPUFUNC(op_e1d8_13), 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ (cpuop_func*)CPUFUNC(op_e1e0_13), 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ (cpuop_func*)CPUFUNC(op_e1e8_13), 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ (cpuop_func*)CPUFUNC(op_e1f0_13), 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ (cpuop_func*)CPUFUNC(op_e1f8_13), 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ (cpuop_func*)CPUFUNC(op_e1f9_13), 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ (cpuop_func*)CPUFUNC(op_e2d0_13), 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ (cpuop_func*)CPUFUNC(op_e2d8_13), 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ (cpuop_func*)CPUFUNC(op_e2e0_13), 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ (cpuop_func*)CPUFUNC(op_e2e8_13), 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ (cpuop_func*)CPUFUNC(op_e2f0_13), 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ (cpuop_func*)CPUFUNC(op_e2f8_13), 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ (cpuop_func*)CPUFUNC(op_e2f9_13), 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ (cpuop_func*)CPUFUNC(op_e3d0_13), 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ (cpuop_func*)CPUFUNC(op_e3d8_13), 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ (cpuop_func*)CPUFUNC(op_e3e0_13), 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ (cpuop_func*)CPUFUNC(op_e3e8_13), 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ (cpuop_func*)CPUFUNC(op_e3f0_13), 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ (cpuop_func*)CPUFUNC(op_e3f8_13), 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ (cpuop_func*)CPUFUNC(op_e3f9_13), 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ (cpuop_func*)CPUFUNC(op_e4d0_13), 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ (cpuop_func*)CPUFUNC(op_e4d8_13), 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ (cpuop_func*)CPUFUNC(op_e4e0_13), 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ (cpuop_func*)CPUFUNC(op_e4e8_13), 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ (cpuop_func*)CPUFUNC(op_e4f0_13), 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ (cpuop_func*)CPUFUNC(op_e4f8_13), 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ (cpuop_func*)CPUFUNC(op_e4f9_13), 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ (cpuop_func*)CPUFUNC(op_e5d0_13), 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ (cpuop_func*)CPUFUNC(op_e5d8_13), 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ (cpuop_func*)CPUFUNC(op_e5e0_13), 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ (cpuop_func*)CPUFUNC(op_e5e8_13), 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ (cpuop_func*)CPUFUNC(op_e5f0_13), 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ (cpuop_func*)CPUFUNC(op_e5f8_13), 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ (cpuop_func*)CPUFUNC(op_e5f9_13), 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ (cpuop_func*)CPUFUNC(op_e6d0_13), 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ (cpuop_func*)CPUFUNC(op_e6d8_13), 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ (cpuop_func*)CPUFUNC(op_e6e0_13), 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ (cpuop_func*)CPUFUNC(op_e6e8_13), 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ (cpuop_func*)CPUFUNC(op_e6f0_13), 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ (cpuop_func*)CPUFUNC(op_e6f8_13), 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ (cpuop_func*)CPUFUNC(op_e6f9_13), 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ (cpuop_func*)CPUFUNC(op_e7d0_13), 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ (cpuop_func*)CPUFUNC(op_e7d8_13), 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ (cpuop_func*)CPUFUNC(op_e7e0_13), 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ (cpuop_func*)CPUFUNC(op_e7e8_13), 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ (cpuop_func*)CPUFUNC(op_e7f0_13), 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ (cpuop_func*)CPUFUNC(op_e7f8_13), 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ (cpuop_func*)CPUFUNC(op_e7f9_13), 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ 0, 0 }};
#endif /* CPUEMU_13 */
const struct cputbl CPUFUNC(op_smalltbl_14)[] = {
{ (cpuop_func*)CPUFUNC(op_0000_13), 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0010_13), 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0018_13), 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0020_13), 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0028_13), 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0030_13), 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0038_13), 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0039_13), 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_003c_13), 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ (cpuop_func*)CPUFUNC(op_0040_13), 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0050_13), 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0058_13), 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0060_13), 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0068_13), 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0070_13), 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0078_13), 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0079_13), 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_007c_13), 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ (cpuop_func*)CPUFUNC(op_0080_13), 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0090_13), 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0098_13), 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00a0_13), 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00a8_13), 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00b0_13), 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00b8_13), 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_00b9_13), 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_0100_13), 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0108_13), 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ (cpuop_func*)CPUFUNC(op_0110_13), 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0118_13), 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0120_13), 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0128_13), 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0130_13), 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0138_13), 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0139_13), 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_013a_13), 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_013b_13), 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_013c_13), 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0140_13), 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0148_13), 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ (cpuop_func*)CPUFUNC(op_0150_13), 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0158_13), 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0160_13), 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0168_13), 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0170_13), 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0178_13), 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0179_13), 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0180_13), 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_0188_13), 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ (cpuop_func*)CPUFUNC(op_0190_13), 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_0198_13), 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01a0_13), 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01a8_13), 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01b0_13), 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01b8_13), 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01b9_13), 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_01c0_13), 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01c8_13), 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ (cpuop_func*)CPUFUNC(op_01d0_13), 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01d8_13), 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01e0_13), 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01e8_13), 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01f0_13), 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01f8_13), 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_01f9_13), 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_0200_13), 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0210_13), 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0218_13), 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0220_13), 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0228_13), 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0230_13), 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0238_13), 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0239_13), 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_023c_13), 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ (cpuop_func*)CPUFUNC(op_0240_13), 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0250_13), 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0258_13), 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0260_13), 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0268_13), 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0270_13), 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0278_13), 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0279_13), 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_027c_13), 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ (cpuop_func*)CPUFUNC(op_0280_13), 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0290_13), 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0298_13), 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02a0_13), 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02a8_13), 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02b0_13), 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02b8_13), 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_02b9_13), 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ (cpuop_func*)CPUFUNC(op_0400_13), 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0410_13), 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0418_13), 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0420_13), 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0428_13), 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0430_13), 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0438_13), 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0439_13), 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0440_13), 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0450_13), 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0458_13), 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0460_13), 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0468_13), 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0470_13), 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0478_13), 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0479_13), 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0480_13), 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0490_13), 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0498_13), 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04a0_13), 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04a8_13), 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04b0_13), 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04b8_13), 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_04b9_13), 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_0600_13), 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0610_13), 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0618_13), 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0620_13), 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0628_13), 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0630_13), 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0638_13), 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0639_13), 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0640_13), 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0650_13), 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0658_13), 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0660_13), 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0668_13), 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0670_13), 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0678_13), 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0679_13), 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0680_13), 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0690_13), 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0698_13), 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06a0_13), 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06a8_13), 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06b0_13), 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06b8_13), 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_06b9_13), 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_0800_13), 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0810_13), 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0818_13), 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0820_13), 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0828_13), 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0830_13), 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0838_13), 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0839_13), 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_083a_13), 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_083b_13), 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ (cpuop_func*)CPUFUNC(op_0840_13), 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0850_13), 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0858_13), 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0860_13), 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0868_13), 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0870_13), 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0878_13), 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0879_13), 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ (cpuop_func*)CPUFUNC(op_0880_13), 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_0890_13), 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_0898_13), 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08a0_13), 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08a8_13), 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08b0_13), 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08b8_13), 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08b9_13), 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ (cpuop_func*)CPUFUNC(op_08c0_13), 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08d0_13), 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08d8_13), 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08e0_13), 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08e8_13), 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08f0_13), 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08f8_13), 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_08f9_13), 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ (cpuop_func*)CPUFUNC(op_0a00_13), 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a10_13), 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a18_13), 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a20_13), 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a28_13), 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a30_13), 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a38_13), 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a39_13), 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a3c_13), 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ (cpuop_func*)CPUFUNC(op_0a40_13), 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a50_13), 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a58_13), 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a60_13), 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a68_13), 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a70_13), 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a78_13), 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a79_13), 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a7c_13), 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ (cpuop_func*)CPUFUNC(op_0a80_13), 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a90_13), 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0a98_13), 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0aa0_13), 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0aa8_13), 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0ab0_13), 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0ab8_13), 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0ab9_13), 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ (cpuop_func*)CPUFUNC(op_0c00_13), 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c10_13), 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c18_13), 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c20_13), 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c28_13), 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c30_13), 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c38_13), 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c39_13), 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c40_13), 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c50_13), 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c58_13), 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c60_13), 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c68_13), 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c70_13), 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c78_13), 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c79_13), 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c80_13), 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c90_13), 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0c98_13), 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0ca0_13), 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0ca8_13), 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0cb0_13), 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0cb8_13), 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_0cb9_13), 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ (cpuop_func*)CPUFUNC(op_1000_13), 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1010_13), 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1018_13), 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1020_13), 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1028_13), 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1030_13), 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1038_13), 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1039_13), 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_103a_13), 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_103b_13), 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_103c_13), 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1080_13), 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1090_13), 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1098_13), 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10a0_13), 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10a8_13), 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10b0_13), 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10b8_13), 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10b9_13), 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10ba_13), 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10bb_13), 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10bc_13), 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10c0_13), 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10d0_13), 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10d8_13), 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10e0_13), 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10e8_13), 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10f0_13), 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10f8_13), 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10f9_13), 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10fa_13), 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10fb_13), 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_10fc_13), 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1100_13), 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1110_13), 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1118_13), 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1120_13), 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1128_13), 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1130_13), 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1138_13), 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1139_13), 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_113a_13), 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_113b_13), 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_113c_13), 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1140_13), 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1150_13), 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1158_13), 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1160_13), 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1168_13), 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1170_13), 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1178_13), 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1179_13), 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_117a_13), 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_117b_13), 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_117c_13), 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1180_13), 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1190_13), 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_1198_13), 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11a0_13), 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11a8_13), 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11b0_13), 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11b8_13), 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11b9_13), 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11ba_13), 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11bb_13), 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11bc_13), 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11c0_13), 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11d0_13), 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11d8_13), 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11e0_13), 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11e8_13), 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11f0_13), 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11f8_13), 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11f9_13), 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11fa_13), 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11fb_13), 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_11fc_13), 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13c0_13), 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13d0_13), 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13d8_13), 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13e0_13), 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13e8_13), 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13f0_13), 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13f8_13), 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13f9_13), 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13fa_13), 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13fb_13), 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_13fc_13), 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2000_13), 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2008_13), 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2010_13), 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2018_13), 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2020_13), 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2028_13), 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2030_13), 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2038_13), 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2039_13), 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_203a_13), 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_203b_13), 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_203c_13), 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2040_13), 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2048_13), 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2050_13), 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2058_13), 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2060_13), 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2068_13), 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2070_13), 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2078_13), 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2079_13), 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_207a_13), 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_207b_13), 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_207c_13), 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_2080_13), 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2088_13), 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2090_13), 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2098_13), 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20a0_13), 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20a8_13), 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20b0_13), 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20b8_13), 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20b9_13), 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20ba_13), 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20bb_13), 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20bc_13), 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20c0_13), 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20c8_13), 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20d0_13), 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20d8_13), 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20e0_13), 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20e8_13), 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20f0_13), 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20f8_13), 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20f9_13), 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20fa_13), 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20fb_13), 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_20fc_13), 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2100_13), 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2108_13), 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2110_13), 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2118_13), 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2120_13), 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2128_13), 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2130_13), 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2138_13), 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2139_13), 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_213a_13), 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_213b_13), 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_213c_13), 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2140_13), 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2148_13), 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2150_13), 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2158_13), 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2160_13), 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2168_13), 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2170_13), 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2178_13), 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2179_13), 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_217a_13), 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_217b_13), 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_217c_13), 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2180_13), 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2188_13), 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2190_13), 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_2198_13), 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21a0_13), 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21a8_13), 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21b0_13), 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21b8_13), 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21b9_13), 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21ba_13), 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21bb_13), 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21bc_13), 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21c0_13), 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21c8_13), 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21d0_13), 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21d8_13), 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21e0_13), 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21e8_13), 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21f0_13), 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21f8_13), 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21f9_13), 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21fa_13), 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21fb_13), 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_21fc_13), 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23c0_13), 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23c8_13), 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23d0_13), 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23d8_13), 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23e0_13), 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23e8_13), 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23f0_13), 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23f8_13), 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23f9_13), 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23fa_13), 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23fb_13), 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_23fc_13), 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3000_13), 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3008_13), 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3010_13), 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3018_13), 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3020_13), 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3028_13), 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3030_13), 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3038_13), 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3039_13), 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_303a_13), 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_303b_13), 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_303c_13), 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3040_13), 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3048_13), 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3050_13), 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3058_13), 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3060_13), 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3068_13), 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3070_13), 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3078_13), 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3079_13), 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_307a_13), 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_307b_13), 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_307c_13), 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ (cpuop_func*)CPUFUNC(op_3080_13), 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3088_13), 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3090_13), 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3098_13), 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30a0_13), 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30a8_13), 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30b0_13), 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30b8_13), 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30b9_13), 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30ba_13), 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30bb_13), 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30bc_13), 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30c0_13), 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30c8_13), 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30d0_13), 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30d8_13), 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30e0_13), 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30e8_13), 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30f0_13), 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30f8_13), 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30f9_13), 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30fa_13), 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30fb_13), 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_30fc_13), 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3100_13), 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3108_13), 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3110_13), 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3118_13), 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3120_13), 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3128_13), 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3130_13), 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3138_13), 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3139_13), 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_313a_13), 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_313b_13), 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_313c_13), 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3140_13), 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3148_13), 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3150_13), 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3158_13), 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3160_13), 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3168_13), 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3170_13), 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3178_13), 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3179_13), 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_317a_13), 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_317b_13), 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_317c_13), 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3180_13), 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3188_13), 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3190_13), 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_3198_13), 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31a0_13), 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31a8_13), 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31b0_13), 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31b8_13), 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31b9_13), 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31ba_13), 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31bb_13), 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31bc_13), 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31c0_13), 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31c8_13), 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31d0_13), 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31d8_13), 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31e0_13), 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31e8_13), 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31f0_13), 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31f8_13), 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31f9_13), 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31fa_13), 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31fb_13), 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_31fc_13), 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33c0_13), 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33c8_13), 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33d0_13), 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33d8_13), 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33e0_13), 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33e8_13), 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33f0_13), 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33f8_13), 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33f9_13), 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33fa_13), 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33fb_13), 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_33fc_13), 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_4000_13), 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4010_13), 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4018_13), 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4020_13), 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4028_13), 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4030_13), 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4038_13), 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4039_13), 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4040_13), 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4050_13), 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4058_13), 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4060_13), 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4068_13), 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4070_13), 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4078_13), 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4079_13), 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4080_13), 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4090_13), 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_4098_13), 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40a0_13), 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40a8_13), 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40b0_13), 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40b8_13), 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40b9_13), 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ (cpuop_func*)CPUFUNC(op_40c0_14), 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40d0_14), 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40d8_14), 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40e0_14), 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40e8_14), 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40f0_14), 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40f8_14), 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_40f9_14), 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ (cpuop_func*)CPUFUNC(op_4180_13), 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_4190_13), 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_4198_13), 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41a0_13), 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41a8_13), 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41b0_13), 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41b8_13), 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41b9_13), 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41ba_13), 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41bb_13), 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41bc_13), 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ (cpuop_func*)CPUFUNC(op_41d0_13), 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41e8_13), 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41f0_13), 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41f8_13), 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41f9_13), 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41fa_13), 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_41fb_13), 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ (cpuop_func*)CPUFUNC(op_4200_14), 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4210_14), 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4218_14), 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4220_14), 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4228_14), 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4230_14), 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4238_14), 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4239_14), 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4240_14), 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4250_14), 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4258_14), 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4260_14), 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4268_14), 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4270_14), 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4278_14), 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4279_14), 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4280_14), 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4290_14), 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4298_14), 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42a0_14), 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42a8_14), 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42b0_14), 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42b8_14), 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_42b9_14), 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ (cpuop_func*)CPUFUNC(op_4400_13), 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4410_13), 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4418_13), 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4420_13), 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4428_13), 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4430_13), 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4438_13), 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4439_13), 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4440_13), 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4450_13), 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4458_13), 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4460_13), 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4468_13), 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4470_13), 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4478_13), 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4479_13), 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4480_13), 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4490_13), 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_4498_13), 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44a0_13), 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44a8_13), 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44b0_13), 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44b8_13), 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44b9_13), 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ (cpuop_func*)CPUFUNC(op_44c0_13), 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44d0_13), 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44d8_13), 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44e0_13), 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44e8_13), 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44f0_13), 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44f8_13), 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44f9_13), 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44fa_13), 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44fb_13), 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_44fc_13), 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_4600_13), 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4610_13), 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4618_13), 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4620_13), 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4628_13), 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4630_13), 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4638_13), 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4639_13), 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4640_13), 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4650_13), 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4658_13), 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4660_13), 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4668_13), 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4670_13), 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4678_13), 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4679_13), 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4680_13), 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4690_13), 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_4698_13), 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46a0_13), 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46a8_13), 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46b0_13), 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46b8_13), 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46b9_13), 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ (cpuop_func*)CPUFUNC(op_46c0_13), 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46d0_13), 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46d8_13), 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46e0_13), 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46e8_13), 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46f0_13), 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46f8_13), 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46f9_13), 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46fa_13), 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46fb_13), 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_46fc_13), 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ (cpuop_func*)CPUFUNC(op_4800_13), 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4810_13), 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4818_13), 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4820_13), 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4828_13), 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4830_13), 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4838_13), 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4839_13), 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ (cpuop_func*)CPUFUNC(op_4840_13), 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ (cpuop_func*)CPUFUNC(op_4850_13), 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4868_13), 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4870_13), 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4878_13), 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4879_13), 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_487a_13), 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_487b_13), 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ (cpuop_func*)CPUFUNC(op_4880_13), 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ (cpuop_func*)CPUFUNC(op_4890_13), 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48a0_13), 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48a8_13), 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48b0_13), 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48b8_13), 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48b9_13), 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48c0_13), 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ (cpuop_func*)CPUFUNC(op_48d0_13), 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48e0_13), 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48e8_13), 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48f0_13), 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48f8_13), 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_48f9_13), 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ (cpuop_func*)CPUFUNC(op_4a00_13), 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a10_13), 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a18_13), 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a20_13), 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a28_13), 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a30_13), 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a38_13), 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a39_13), 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a40_13), 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a50_13), 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a58_13), 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a60_13), 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a68_13), 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a70_13), 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a78_13), 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a79_13), 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a80_13), 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a90_13), 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4a98_13), 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4aa0_13), 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4aa8_13), 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4ab0_13), 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4ab8_13), 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4ab9_13), 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ (cpuop_func*)CPUFUNC(op_4ac0_13), 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4ad0_13), 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4ad8_13), 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4ae0_13), 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4ae8_13), 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4af0_13), 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4af8_13), 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4af9_13), 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ (cpuop_func*)CPUFUNC(op_4c90_13), 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4c98_13), 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4ca8_13), 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cb0_13), 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cb8_13), 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cb9_13), 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cba_13), 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cbb_13), 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cd0_13), 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cd8_13), 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4ce8_13), 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cf0_13), 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cf8_13), 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cf9_13), 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cfa_13), 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4cfb_13), 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ (cpuop_func*)CPUFUNC(op_4e40_13), 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ (cpuop_func*)CPUFUNC(op_4e50_13), 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ (cpuop_func*)CPUFUNC(op_4e58_13), 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ (cpuop_func*)CPUFUNC(op_4e60_13), 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ (cpuop_func*)CPUFUNC(op_4e68_13), 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ (cpuop_func*)CPUFUNC(op_4e70_13), 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ (cpuop_func*)CPUFUNC(op_4e71_13), 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ (cpuop_func*)CPUFUNC(op_4e72_13), 0x4e72, 4, { 0, 0 }, 0 }, /* STOP */
{ (cpuop_func*)CPUFUNC(op_4e73_14), 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ (cpuop_func*)CPUFUNC(op_4e75_13), 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ (cpuop_func*)CPUFUNC(op_4e76_13), 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ (cpuop_func*)CPUFUNC(op_4e77_13), 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ (cpuop_func*)CPUFUNC(op_4e90_13), 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4ea8_13), 0x4ea8, 4, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4eb0_13), 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4eb8_13), 0x4eb8, 4, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4eb9_13), 0x4eb9, 6, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4eba_13), 0x4eba, 4, { 0, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4ebb_13), 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ (cpuop_func*)CPUFUNC(op_4ed0_13), 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4ee8_13), 0x4ee8, 4, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4ef0_13), 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4ef8_13), 0x4ef8, 4, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4ef9_13), 0x4ef9, 6, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4efa_13), 0x4efa, 4, { 0, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_4efb_13), 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ (cpuop_func*)CPUFUNC(op_5000_13), 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5010_13), 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5018_13), 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5020_13), 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5028_13), 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5030_13), 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5038_13), 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5039_13), 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5040_13), 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5048_13), 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_5050_13), 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5058_13), 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5060_13), 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5068_13), 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5070_13), 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5078_13), 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5079_13), 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5080_13), 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5088_13), 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ (cpuop_func*)CPUFUNC(op_5090_13), 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_5098_13), 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50a0_13), 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50a8_13), 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50b0_13), 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50b8_13), 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50b9_13), 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ (cpuop_func*)CPUFUNC(op_50c0_14), 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50c8_13), 0x50c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_50d0_14), 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50d8_14), 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50e0_14), 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50e8_14), 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50f0_14), 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50f8_14), 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_50f9_14), 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5100_13), 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5110_13), 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5118_13), 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5120_13), 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5128_13), 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5130_13), 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5138_13), 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5139_13), 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5140_13), 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5148_13), 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_5150_13), 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5158_13), 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5160_13), 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5168_13), 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5170_13), 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5178_13), 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5179_13), 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5180_13), 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5188_13), 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ (cpuop_func*)CPUFUNC(op_5190_13), 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_5198_13), 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51a0_13), 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51a8_13), 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51b0_13), 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51b8_13), 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51b9_13), 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ (cpuop_func*)CPUFUNC(op_51c0_14), 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51c8_13), 0x51c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_51d0_14), 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51d8_14), 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51e0_14), 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51e8_14), 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51f0_14), 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51f8_14), 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_51f9_14), 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52c0_14), 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52c8_13), 0x52c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_52d0_14), 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52d8_14), 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52e0_14), 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52e8_14), 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52f0_14), 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52f8_14), 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_52f9_14), 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53c0_14), 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53c8_13), 0x53c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_53d0_14), 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53d8_14), 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53e0_14), 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53e8_14), 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53f0_14), 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53f8_14), 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_53f9_14), 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54c0_14), 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54c8_13), 0x54c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_54d0_14), 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54d8_14), 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54e0_14), 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54e8_14), 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54f0_14), 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54f8_14), 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_54f9_14), 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55c0_14), 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55c8_13), 0x55c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_55d0_14), 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55d8_14), 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55e0_14), 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55e8_14), 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55f0_14), 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55f8_14), 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_55f9_14), 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56c0_14), 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56c8_13), 0x56c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_56d0_14), 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56d8_14), 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56e0_14), 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56e8_14), 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56f0_14), 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56f8_14), 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_56f9_14), 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57c0_14), 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57c8_13), 0x57c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_57d0_14), 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57d8_14), 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57e0_14), 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57e8_14), 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57f0_14), 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57f8_14), 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_57f9_14), 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58c0_14), 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58c8_13), 0x58c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_58d0_14), 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58d8_14), 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58e0_14), 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58e8_14), 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58f0_14), 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58f8_14), 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_58f9_14), 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59c0_14), 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59c8_13), 0x59c8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_59d0_14), 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59d8_14), 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59e0_14), 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59e8_14), 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59f0_14), 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59f8_14), 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_59f9_14), 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ac0_14), 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ac8_13), 0x5ac8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5ad0_14), 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ad8_14), 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ae0_14), 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ae8_14), 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5af0_14), 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5af8_14), 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5af9_14), 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bc0_14), 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bc8_13), 0x5bc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5bd0_14), 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bd8_14), 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5be0_14), 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5be8_14), 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bf0_14), 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bf8_14), 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5bf9_14), 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cc0_14), 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cc8_13), 0x5cc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5cd0_14), 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cd8_14), 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ce0_14), 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ce8_14), 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cf0_14), 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cf8_14), 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5cf9_14), 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5dc0_14), 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5dc8_13), 0x5dc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5dd0_14), 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5dd8_14), 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5de0_14), 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5de8_14), 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5df0_14), 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5df8_14), 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5df9_14), 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ec0_14), 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ec8_13), 0x5ec8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5ed0_14), 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ed8_14), 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ee0_14), 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ee8_14), 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ef0_14), 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ef8_14), 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ef9_14), 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fc0_14), 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fc8_13), 0x5fc8, 4, { 0, 0 }, 1 }, /* DBcc */
{ (cpuop_func*)CPUFUNC(op_5fd0_14), 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fd8_14), 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fe0_14), 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5fe8_14), 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ff0_14), 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ff8_14), 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_5ff9_14), 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ (cpuop_func*)CPUFUNC(op_6000_13), 0x6000, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6001_13), 0x6001, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_60ff_13), 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6100_13), 0x6100, 4, { 0, 0 }, 1 }, /* BSR */
{ (cpuop_func*)CPUFUNC(op_6101_13), 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ (cpuop_func*)CPUFUNC(op_61ff_13), 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ (cpuop_func*)CPUFUNC(op_6200_13), 0x6200, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6201_13), 0x6201, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_62ff_13), 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6300_13), 0x6300, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6301_13), 0x6301, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_63ff_13), 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6400_13), 0x6400, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6401_13), 0x6401, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_64ff_13), 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6500_13), 0x6500, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6501_13), 0x6501, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_65ff_13), 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6600_13), 0x6600, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6601_13), 0x6601, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_66ff_13), 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6700_13), 0x6700, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6701_13), 0x6701, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_67ff_13), 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6800_13), 0x6800, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6801_13), 0x6801, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_68ff_13), 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6900_13), 0x6900, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6901_13), 0x6901, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_69ff_13), 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6a00_13), 0x6a00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6a01_13), 0x6a01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6aff_13), 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6b00_13), 0x6b00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6b01_13), 0x6b01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6bff_13), 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6c00_13), 0x6c00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6c01_13), 0x6c01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6cff_13), 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6d00_13), 0x6d00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6d01_13), 0x6d01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6dff_13), 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6e00_13), 0x6e00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6e01_13), 0x6e01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6eff_13), 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6f00_13), 0x6f00, 4, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6f01_13), 0x6f01, 2, { 0, 0 }, 1 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_6fff_13), 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ (cpuop_func*)CPUFUNC(op_7000_13), 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ (cpuop_func*)CPUFUNC(op_8000_13), 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8010_13), 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8018_13), 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8020_13), 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8028_13), 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8030_13), 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8038_13), 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_8039_13), 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ (cpuop_func*)CPUFUNC(op_803a_13), 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ (cpu