/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-efi-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_efi_status_to_string:
 * @val: value, e.g. %FU_EFI_STATUS_LOAD_ERROR
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_status_to_string(FuEfiStatus val)
{
    if (val == FU_EFI_STATUS_SUCCESS)
        return "success";
    if (val == FU_EFI_STATUS_LOAD_ERROR)
        return "load-error";
    if (val == FU_EFI_STATUS_INVALID_PARAMETER)
        return "invalid-parameter";
    if (val == FU_EFI_STATUS_UNSUPPORTED)
        return "unsupported";
    if (val == FU_EFI_STATUS_BAD_BUFFER_SIZE)
        return "bad-buffer-size";
    if (val == FU_EFI_STATUS_BUFFER_TOO_SMALL)
        return "buffer-too-small";
    if (val == FU_EFI_STATUS_NOT_READY)
        return "not-ready";
    if (val == FU_EFI_STATUS_DEVICE_ERROR)
        return "device-error";
    if (val == FU_EFI_STATUS_WRITE_PROTECTED)
        return "write-protected";
    if (val == FU_EFI_STATUS_OUT_OF_RESOURCES)
        return "out-of-resources";
    if (val == FU_EFI_STATUS_VOLUME_CORRUPTED)
        return "volume-corrupted";
    if (val == FU_EFI_STATUS_VOLUME_FULL)
        return "volume-full";
    if (val == FU_EFI_STATUS_NO_MEDIA)
        return "no-media";
    if (val == FU_EFI_STATUS_MEDIA_CHANGED)
        return "media-changed";
    if (val == FU_EFI_STATUS_NOT_FOUND)
        return "not-found";
    if (val == FU_EFI_STATUS_ACCESS_DENIED)
        return "access-denied";
    if (val == FU_EFI_STATUS_NO_RESPONSE)
        return "no-response";
    if (val == FU_EFI_STATUS_NO_MAPPING)
        return "no-mapping";
    if (val == FU_EFI_STATUS_TIMEOUT)
        return "timeout";
    if (val == FU_EFI_STATUS_NOT_STARTED)
        return "not-started";
    if (val == FU_EFI_STATUS_ALREADY_STARTED)
        return "already-started";
    if (val == FU_EFI_STATUS_ABORTED)
        return "aborted";
    if (val == FU_EFI_STATUS_ICMP_ERROR)
        return "icmp-error";
    if (val == FU_EFI_STATUS_TFTP_ERROR)
        return "tftp-error";
    if (val == FU_EFI_STATUS_PROTOCOL_ERROR)
        return "protocol-error";
    if (val == FU_EFI_STATUS_INCOMPATIBLE_VERSION)
        return "incompatible-version";
    if (val == FU_EFI_STATUS_SECURITY_VIOLATION)
        return "security-violation";
    if (val == FU_EFI_STATUS_CRC_ERROR)
        return "crc-error";
    if (val == FU_EFI_STATUS_END_OF_MEDIA)
        return "end-of-media";
    if (val == FU_EFI_STATUS_END_OF_FILE)
        return "end-of-file";
    if (val == FU_EFI_STATUS_INVALID_LANGUAGE)
        return "invalid-language";
    if (val == FU_EFI_STATUS_COMPROMISED_DATA)
        return "compromised-data";
    if (val == FU_EFI_STATUS_IP_ADDRESS_CONFLICT)
        return "ip-address-conflict";
    if (val == FU_EFI_STATUS_HTTP_ERROR)
        return "http-error";
    return NULL;
}

/**
 * fu_efi_signature_kind_to_string:
 * @val: value, e.g. %FU_EFI_SIGNATURE_KIND_SHA256
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_signature_kind_to_string(FuEfiSignatureKind val)
{
    if (val == FU_EFI_SIGNATURE_KIND_SHA256)
        return "sha256";
    if (val == FU_EFI_SIGNATURE_KIND_X509)
        return "x509";
    return NULL;
}
/**
 * fu_efi_signature_kind_from_string:
 * @val: (nullable): a string, e.g. `sha256`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuEfiSignatureKind
fu_efi_signature_kind_from_string(const gchar *val)
{
    if (g_strcmp0(val, "sha256") == 0)
        return FU_EFI_SIGNATURE_KIND_SHA256;
    if (g_strcmp0(val, "x509") == 0)
        return FU_EFI_SIGNATURE_KIND_X509;
    return FU_EFI_SIGNATURE_KIND_UNKNOWN;
}


/**
 * fu_efi_file_type_to_string:
 * @val: value, e.g. %FU_EFI_FILE_TYPE_RAW
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_file_type_to_string(FuEfiFileType val)
{
    if (val == FU_EFI_FILE_TYPE_ALL)
        return "all";
    if (val == FU_EFI_FILE_TYPE_RAW)
        return "raw";
    if (val == FU_EFI_FILE_TYPE_FREEFORM)
        return "freeform";
    if (val == FU_EFI_FILE_TYPE_SECURITY_CORE)
        return "security-core";
    if (val == FU_EFI_FILE_TYPE_PEI_CORE)
        return "pei-core";
    if (val == FU_EFI_FILE_TYPE_DXE_CORE)
        return "dxe-core";
    if (val == FU_EFI_FILE_TYPE_PEIM)
        return "peim";
    if (val == FU_EFI_FILE_TYPE_DRIVER)
        return "driver";
    if (val == FU_EFI_FILE_TYPE_COMBINED_PEIM_DRIVER)
        return "combined-peim-driver";
    if (val == FU_EFI_FILE_TYPE_APPLICATION)
        return "application";
    if (val == FU_EFI_FILE_TYPE_MM)
        return "mm";
    if (val == FU_EFI_FILE_TYPE_FIRMWARE_VOLUME_IMAGE)
        return "firmware-volume-image";
    if (val == FU_EFI_FILE_TYPE_COMBINED_MM_DXE)
        return "combined-mm-dxe";
    if (val == FU_EFI_FILE_TYPE_MM_CORE)
        return "mm-core";
    if (val == FU_EFI_FILE_TYPE_MM_STANDALONE)
        return "mm-standalone";
    if (val == FU_EFI_FILE_TYPE_MM_CORE_STANDALONE)
        return "mm-core-standalone";
    if (val == FU_EFI_FILE_TYPE_FFS_PAD)
        return "ffs-pad";
    return NULL;
}

/**
 * fu_efi_compression_type_to_string:
 * @val: value, e.g. %FU_EFI_COMPRESSION_TYPE_STANDARD_COMPRESSION
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_efi_compression_type_to_string(FuEfiCompressionType val)
{
    if (val == FU_EFI_COMPRESSION_TYPE_NOT_COMPRESSED)
        return "not-compressed";
    if (val == FU_EFI_COMPRESSION_TYPE_STANDARD_COMPRESSION)
        return "standard-compression";
    return NULL;
}

/**
 * fu_efi_lz77_decompressor_version_to_string:
 * @val: value, e.g. %FU_EFI_LZ77_DECOMPRESSOR_VERSION_LEGACY
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_lz77_decompressor_version_to_string(FuEfiLz77DecompressorVersion val)
{
    if (val == FU_EFI_LZ77_DECOMPRESSOR_VERSION_NONE)
        return "none";
    if (val == FU_EFI_LZ77_DECOMPRESSOR_VERSION_LEGACY)
        return "legacy";
    if (val == FU_EFI_LZ77_DECOMPRESSOR_VERSION_TIANO)
        return "tiano";
    return NULL;
}

/**
 * fu_efi_section_type_to_string:
 * @val: value, e.g. %FU_EFI_SECTION_TYPE_GUID_DEFINED
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_section_type_to_string(FuEfiSectionType val)
{
    if (val == FU_EFI_SECTION_TYPE_COMPRESSION)
        return "compression";
    if (val == FU_EFI_SECTION_TYPE_GUID_DEFINED)
        return "guid-defined";
    if (val == FU_EFI_SECTION_TYPE_DISPOSABLE)
        return "disposable";
    if (val == FU_EFI_SECTION_TYPE_PE32)
        return "pe32";
    if (val == FU_EFI_SECTION_TYPE_PIC)
        return "pic";
    if (val == FU_EFI_SECTION_TYPE_TE)
        return "te";
    if (val == FU_EFI_SECTION_TYPE_DXE_DEPEX)
        return "dxe-depex";
    if (val == FU_EFI_SECTION_TYPE_VERSION)
        return "version";
    if (val == FU_EFI_SECTION_TYPE_USER_INTERFACE)
        return "user-interface";
    if (val == FU_EFI_SECTION_TYPE_COMPATIBILITY16)
        return "compatibility16";
    if (val == FU_EFI_SECTION_TYPE_VOLUME_IMAGE)
        return "volume-image";
    if (val == FU_EFI_SECTION_TYPE_FREEFORM_SUBTYPE_GUID)
        return "freeform-subtype-guid";
    if (val == FU_EFI_SECTION_TYPE_RAW)
        return "raw";
    if (val == FU_EFI_SECTION_TYPE_PEI_DEPEX)
        return "pei-depex";
    if (val == FU_EFI_SECTION_TYPE_MM_DEPEX)
        return "mm-depex";
    if (val == FU_EFI_SECTION_TYPE_PHOENIX_SECTION_POSTCODE)
        return "phoenix-section-postcode";
    if (val == FU_EFI_SECTION_TYPE_INSYDE_SECTION_POSTCODE)
        return "insyde-section-postcode";
    return NULL;
}

/**
 * fu_efi_volume_ext_entry_type_to_string:
 * @val: value, e.g. %FU_EFI_VOLUME_EXT_ENTRY_TYPE_GUID
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_volume_ext_entry_type_to_string(FuEfiVolumeExtEntryType val)
{
    if (val == FU_EFI_VOLUME_EXT_ENTRY_TYPE_OEM)
        return "oem";
    if (val == FU_EFI_VOLUME_EXT_ENTRY_TYPE_GUID)
        return "guid";
    if (val == FU_EFI_VOLUME_EXT_ENTRY_TYPE_SIZE)
        return "size";
    return NULL;
}

/**
 * fu_efi_load_option_attrs_to_string:
 * @val: value, e.g. %FU_EFI_LOAD_OPTION_ATTR_FORCE_RECONNECT
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_efi_load_option_attrs_to_string(FuEfiLoadOptionAttrs val)
{
    if (val == FU_EFI_LOAD_OPTION_ATTR_ACTIVE)
        return "active";
    if (val == FU_EFI_LOAD_OPTION_ATTR_FORCE_RECONNECT)
        return "force-reconnect";
    if (val == FU_EFI_LOAD_OPTION_ATTR_HIDDEN)
        return "hidden";
    if (val == FU_EFI_LOAD_OPTION_ATTR_CATEGORY)
        return "category";
    if (val == FU_EFI_LOAD_OPTION_ATTR_CATEGORY_BOOT)
        return "category-boot";
    if (val == FU_EFI_LOAD_OPTION_ATTR_CATEGORY_AP)
        return "category-ap";
    return NULL;
}

/**
 * fu_efi_load_option_kind_to_string:
 * @val: value, e.g. %FU_EFI_LOAD_OPTION_KIND_PATH
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_load_option_kind_to_string(FuEfiLoadOptionKind val)
{
    if (val == FU_EFI_LOAD_OPTION_KIND_PATH)
        return "path";
    if (val == FU_EFI_LOAD_OPTION_KIND_HIVE)
        return "hive";
    if (val == FU_EFI_LOAD_OPTION_KIND_DATA)
        return "data";
    return NULL;
}
/**
 * fu_efi_load_option_kind_from_string:
 * @val: (nullable): a string, e.g. `path`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuEfiLoadOptionKind
fu_efi_load_option_kind_from_string(const gchar *val)
{
    if (g_strcmp0(val, "path") == 0)
        return FU_EFI_LOAD_OPTION_KIND_PATH;
    if (g_strcmp0(val, "hive") == 0)
        return FU_EFI_LOAD_OPTION_KIND_HIVE;
    if (g_strcmp0(val, "data") == 0)
        return FU_EFI_LOAD_OPTION_KIND_DATA;
    return FU_EFI_LOAD_OPTION_KIND_UNKNOWN;
}

/**
 * fu_efi_device_path_type_to_string:
 * @val: value, e.g. %FU_EFI_DEVICE_PATH_TYPE_ACPI
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_efi_device_path_type_to_string(FuEfiDevicePathType val)
{
    if (val == FU_EFI_DEVICE_PATH_TYPE_HARDWARE)
        return "hardware";
    if (val == FU_EFI_DEVICE_PATH_TYPE_ACPI)
        return "acpi";
    if (val == FU_EFI_DEVICE_PATH_TYPE_MESSAGE)
        return "message";
    if (val == FU_EFI_DEVICE_PATH_TYPE_MEDIA)
        return "media";
    if (val == FU_EFI_DEVICE_PATH_TYPE_BIOS_BOOT)
        return "bios-boot";
    if (val == FU_EFI_DEVICE_PATH_TYPE_END)
        return "end";
    return NULL;
}

/**
 * fu_efi_hard_drive_device_path_subtype_to_string:
 * @val: value, e.g. %FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_CDROM
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_efi_hard_drive_device_path_subtype_to_string(FuEfiHardDriveDevicePathSubtype val)
{
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_HARD_DRIVE)
        return "hard-drive";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_CDROM)
        return "cdrom";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_VENDOR)
        return "vendor";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_FILE_PATH)
        return "file-path";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_MEDIA_PROTOCOL)
        return "media-protocol";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_PIWG_FIRMWARE_FILE)
        return "piwg-firmware-file";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_PIWG_FIRMWARE_VOLUME)
        return "piwg-firmware-volume";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_RELATIVE_OFFSET_RANGE)
        return "relative-offset-range";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_RAM_DISK_DEVICE_PATH)
        return "ram-disk-device-path";
    return NULL;
}

/**
 * fu_efi_hard_drive_device_path_partition_format_to_string:
 * @val: value, e.g. %FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_GUID_PARTITION_TABLE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_hard_drive_device_path_partition_format_to_string(FuEfiHardDriveDevicePathPartitionFormat val)
{
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_LEGACY_MBR)
        return "legacy-mbr";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_GUID_PARTITION_TABLE)
        return "guid-partition-table";
    return NULL;
}
/**
 * fu_efi_hard_drive_device_path_partition_format_from_string:
 * @val: (nullable): a string, e.g. `guid-partition-table`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuEfiHardDriveDevicePathPartitionFormat
fu_efi_hard_drive_device_path_partition_format_from_string(const gchar *val)
{
    if (g_strcmp0(val, "legacy-mbr") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_LEGACY_MBR;
    if (g_strcmp0(val, "guid-partition-table") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_GUID_PARTITION_TABLE;
    return FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_LEGACY_MBR;
}

/**
 * fu_efi_hard_drive_device_path_signature_type_to_string:
 * @val: value, e.g. %FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_ADDR1B8
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_hard_drive_device_path_signature_type_to_string(FuEfiHardDriveDevicePathSignatureType val)
{
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_NONE)
        return "none";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_ADDR1B8)
        return "addr1b8";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_GUID)
        return "guid";
    return NULL;
}
/**
 * fu_efi_hard_drive_device_path_signature_type_from_string:
 * @val: (nullable): a string, e.g. `addr1b8`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuEfiHardDriveDevicePathSignatureType
fu_efi_hard_drive_device_path_signature_type_from_string(const gchar *val)
{
    if (g_strcmp0(val, "none") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_NONE;
    if (g_strcmp0(val, "addr1b8") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_ADDR1B8;
    if (g_strcmp0(val, "guid") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_GUID;
    return FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_NONE;
}

/**
 * fu_efi_variable_store_state_to_string:
 * @val: value, e.g. %FU_EFI_VARIABLE_STORE_STATE_HEALTHY
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_variable_store_state_to_string(FuEfiVariableStoreState val)
{
    if (val == FU_EFI_VARIABLE_STORE_STATE_UNSET)
        return "unset";
    if (val == FU_EFI_VARIABLE_STORE_STATE_HEALTHY)
        return "healthy";
    if (val == FU_EFI_VARIABLE_STORE_STATE_EMPTY)
        return "empty";
    return NULL;
}
/**
 * fu_efi_variable_store_state_from_string:
 * @val: (nullable): a string, e.g. `healthy`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuEfiVariableStoreState
fu_efi_variable_store_state_from_string(const gchar *val)
{
    if (g_strcmp0(val, "unset") == 0)
        return FU_EFI_VARIABLE_STORE_STATE_UNSET;
    if (g_strcmp0(val, "healthy") == 0)
        return FU_EFI_VARIABLE_STORE_STATE_HEALTHY;
    if (g_strcmp0(val, "empty") == 0)
        return FU_EFI_VARIABLE_STORE_STATE_EMPTY;
    return FU_EFI_VARIABLE_STORE_STATE_UNSET;
}

/**
 * fu_efi_variable_store_format_to_string:
 * @val: value
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_efi_variable_store_format_to_string(FuEfiVariableStoreFormat val)
{
    if (val == FU_EFI_VARIABLE_STORE_FORMAT_FORMATTED)
        return "formatted";
    return NULL;
}

/**
 * fu_efi_variable_state_to_string:
 * @val: value, e.g. %FU_EFI_VARIABLE_STATE_VARIABLE_IN_DELETED_TRANSITION
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_efi_variable_state_to_string(FuEfiVariableState val)
{
    if (val == FU_EFI_VARIABLE_STATE_UNSET)
        return "unset";
    if (val == FU_EFI_VARIABLE_STATE_VARIABLE_IN_DELETED_TRANSITION)
        return "variable-in-deleted-transition";
    if (val == FU_EFI_VARIABLE_STATE_VARIABLE_DELETED)
        return "variable-deleted";
    if (val == FU_EFI_VARIABLE_STATE_VARIABLE_HEADER_VALID)
        return "variable-header-valid";
    if (val == FU_EFI_VARIABLE_STATE_VARIABLE_ADDED)
        return "variable-added";
    if (val == FU_EFI_VARIABLE_STATE_INTEL_VARIABLE_VALID)
        return "intel-variable-valid";
    if (val == FU_EFI_VARIABLE_STATE_INTEL_VARIABLE_INVALID)
        return "intel-variable-invalid";
    return NULL;
}
/**
 * fu_efi_variable_state_from_string:
 * @val: (nullable): a string, e.g. `variable-in-deleted-transition`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuEfiVariableState
fu_efi_variable_state_from_string(const gchar *val)
{
    if (g_strcmp0(val, "unset") == 0)
        return FU_EFI_VARIABLE_STATE_UNSET;
    if (g_strcmp0(val, "variable-in-deleted-transition") == 0)
        return FU_EFI_VARIABLE_STATE_VARIABLE_IN_DELETED_TRANSITION;
    if (g_strcmp0(val, "variable-deleted") == 0)
        return FU_EFI_VARIABLE_STATE_VARIABLE_DELETED;
    if (g_strcmp0(val, "variable-header-valid") == 0)
        return FU_EFI_VARIABLE_STATE_VARIABLE_HEADER_VALID;
    if (g_strcmp0(val, "variable-added") == 0)
        return FU_EFI_VARIABLE_STATE_VARIABLE_ADDED;
    if (g_strcmp0(val, "intel-variable-valid") == 0)
        return FU_EFI_VARIABLE_STATE_INTEL_VARIABLE_VALID;
    if (g_strcmp0(val, "intel-variable-invalid") == 0)
        return FU_EFI_VARIABLE_STATE_INTEL_VARIABLE_INVALID;
    return FU_EFI_VARIABLE_STATE_UNSET;
}

/**
 * fu_efi_variable_attrs_to_string:
 * @val: value, e.g. %FU_EFI_VARIABLE_ATTR_NON_VOLATILE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
gchar *
fu_efi_variable_attrs_to_string(FuEfiVariableAttrs val)
{
    const gchar *data[8] = {0};
    guint idx = 0;
    if (val == FU_EFI_VARIABLE_ATTR_NONE)
        return g_strdup("none");
    if (val & FU_EFI_VARIABLE_ATTR_NON_VOLATILE)
        data[idx++] = "non-volatile";
    if (val & FU_EFI_VARIABLE_ATTR_BOOTSERVICE_ACCESS)
        data[idx++] = "bootservice-access";
    if (val & FU_EFI_VARIABLE_ATTR_RUNTIME_ACCESS)
        data[idx++] = "runtime-access";
    if (val & FU_EFI_VARIABLE_ATTR_HARDWARE_ERROR_RECORD)
        data[idx++] = "hardware-error-record";
    if (val & FU_EFI_VARIABLE_ATTR_AUTHENTICATED_WRITE_ACCESS)
        data[idx++] = "authenticated-write-access";
    if (val & FU_EFI_VARIABLE_ATTR_TIME_BASED_AUTHENTICATED_WRITE_ACCESS)
        data[idx++] = "time-based-authenticated-write-access";
    if (val & FU_EFI_VARIABLE_ATTR_APPEND_WRITE)
        data[idx++] = "append-write";
    return g_strjoinv(",", (gchar **)data);
}
/**
 * fu_efi_variable_attrs_from_string:
 * @val: (nullable): a string, e.g. `non-volatile`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuEfiVariableAttrs
fu_efi_variable_attrs_from_string(const gchar *val)
{
    FuEfiVariableAttrs value = 0;
    g_auto(GStrv) split = NULL;
    g_return_val_if_fail(val != NULL, 0);
    split = g_strsplit(val, ",", -1);
    for (guint i = 0; split[i] != NULL; i++) {
        if (g_strcmp0(split[i], "none") == 0) {
            value |= FU_EFI_VARIABLE_ATTR_NONE;
            continue;
        }
        if (g_strcmp0(split[i], "non-volatile") == 0) {
            value |= FU_EFI_VARIABLE_ATTR_NON_VOLATILE;
            continue;
        }
        if (g_strcmp0(split[i], "bootservice-access") == 0) {
            value |= FU_EFI_VARIABLE_ATTR_BOOTSERVICE_ACCESS;
            continue;
        }
        if (g_strcmp0(split[i], "runtime-access") == 0) {
            value |= FU_EFI_VARIABLE_ATTR_RUNTIME_ACCESS;
            continue;
        }
        if (g_strcmp0(split[i], "hardware-error-record") == 0) {
            value |= FU_EFI_VARIABLE_ATTR_HARDWARE_ERROR_RECORD;
            continue;
        }
        if (g_strcmp0(split[i], "authenticated-write-access") == 0) {
            value |= FU_EFI_VARIABLE_ATTR_AUTHENTICATED_WRITE_ACCESS;
            continue;
        }
        if (g_strcmp0(split[i], "time-based-authenticated-write-access") == 0) {
            value |= FU_EFI_VARIABLE_ATTR_TIME_BASED_AUTHENTICATED_WRITE_ACCESS;
            continue;
        }
        if (g_strcmp0(split[i], "append-write") == 0) {
            value |= FU_EFI_VARIABLE_ATTR_APPEND_WRITE;
            continue;
        }
    }
    return value;
}

/**
 * fu_struct_efi_file_ref: (skip):
 **/
FuStructEfiFile *
fu_struct_efi_file_ref(FuStructEfiFile *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_file_unref: (skip):
 **/
void
fu_struct_efi_file_unref(FuStructEfiFile *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiFile refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_file_new_internal: (skip):
 **/
static FuStructEfiFile *
fu_struct_efi_file_new_internal(void)
{
    FuStructEfiFile *st = g_new0(FuStructEfiFile, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_file_get_name: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_file_get_name(const FuStructEfiFile *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_efi_file_get_hdr_checksum: (skip):
 **/
guint8
fu_struct_efi_file_get_hdr_checksum(const FuStructEfiFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}
/**
 * fu_struct_efi_file_get_data_checksum: (skip):
 **/
guint8
fu_struct_efi_file_get_data_checksum(const FuStructEfiFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[17];
}
/**
 * fu_struct_efi_file_get_type: (skip):
 **/
FuEfiFileType
fu_struct_efi_file_get_type(const FuStructEfiFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[18];
}
/**
 * fu_struct_efi_file_get_attrs: (skip):
 **/
guint8
fu_struct_efi_file_get_attrs(const FuStructEfiFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[19];
}
/**
 * fu_struct_efi_file_get_size: (skip):
 **/
guint32
fu_struct_efi_file_get_size(const FuStructEfiFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_file_get_state: (skip):
 **/
guint8
fu_struct_efi_file_get_state(const FuStructEfiFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[23];
}

/* setters */
/**
 * fu_struct_efi_file_set_name: (skip):
 **/
void
fu_struct_efi_file_set_name(FuStructEfiFile *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_file_set_hdr_checksum: (skip):
 **/
void
fu_struct_efi_file_set_hdr_checksum(FuStructEfiFile *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[16] = value;
}
/**
 * fu_struct_efi_file_set_data_checksum: (skip):
 **/
void
fu_struct_efi_file_set_data_checksum(FuStructEfiFile *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[17] = value;
}
/**
 * fu_struct_efi_file_set_type: (skip):
 **/
void
fu_struct_efi_file_set_type(FuStructEfiFile *st, FuEfiFileType value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[18] = value;
}
/**
 * fu_struct_efi_file_set_attrs: (skip):
 **/
void
fu_struct_efi_file_set_attrs(FuStructEfiFile *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[19] = value;
}
/**
 * fu_struct_efi_file_set_size: (skip):
 **/
void
fu_struct_efi_file_set_size(FuStructEfiFile *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_file_set_state: (skip):
 **/
void
fu_struct_efi_file_set_state(FuStructEfiFile *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[23] = value;
}
/**
 * fu_struct_efi_file_new: (skip):
 **/
FuStructEfiFile *
fu_struct_efi_file_new(void)
{
    FuStructEfiFile *st = fu_struct_efi_file_new_internal();
    st->buf = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st->buf, 24, 0x0);
    fu_struct_efi_file_set_state(st, 0xF8);
    return st;
}
/**
 * fu_struct_efi_file_to_string: (skip):
 **/
static gchar *
fu_struct_efi_file_to_string(const FuStructEfiFile *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiFile:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_file_get_name(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  hdr_checksum: 0x%x\n",
                           (guint) fu_struct_efi_file_get_hdr_checksum(st));
    g_string_append_printf(str, "  data_checksum: 0x%x\n",
                           (guint) fu_struct_efi_file_get_data_checksum(st));
    {
        const gchar *tmp = fu_efi_file_type_to_string(fu_struct_efi_file_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_efi_file_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_efi_file_get_type(st));
        }
    }
    g_string_append_printf(str, "  attrs: 0x%x\n",
                           (guint) fu_struct_efi_file_get_attrs(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_file_get_size(st));
    g_string_append_printf(str, "  state: 0x%x\n",
                           (guint) fu_struct_efi_file_get_state(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_file_validate_internal(FuStructEfiFile *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_efi_file_validate: (skip):
 **/
gboolean
fu_struct_efi_file_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructEfiFile st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructEfiFile: ");
        return FALSE;
    }
    if (!fu_struct_efi_file_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
static gboolean
fu_struct_efi_file_parse_internal(FuStructEfiFile *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_file_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_file_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_file_parse_stream: (skip):
 **/
FuStructEfiFile *
fu_struct_efi_file_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiFile) st = fu_struct_efi_file_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 24, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiFile failed read of 0x%x: ", (guint) 24);
        return NULL;
    }
    if (st->buf->len != 24) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiFile requested 0x%x and got 0x%x",
                    (guint) 24,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_file_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_file2_ref: (skip):
 **/
FuStructEfiFile2 *
fu_struct_efi_file2_ref(FuStructEfiFile2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_file2_unref: (skip):
 **/
void
fu_struct_efi_file2_unref(FuStructEfiFile2 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiFile2 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_file2_new_internal: (skip):
 **/
static FuStructEfiFile2 *
fu_struct_efi_file2_new_internal(void)
{
    FuStructEfiFile2 *st = g_new0(FuStructEfiFile2, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_file2_get_extended_size: (skip):
 **/
guint64
fu_struct_efi_file2_get_extended_size(const FuStructEfiFile2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_file2_to_string: (skip):
 **/
static gchar *
fu_struct_efi_file2_to_string(const FuStructEfiFile2 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiFile2:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  extended_size: 0x%x\n",
                           (guint) fu_struct_efi_file2_get_extended_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_file2_validate_internal(FuStructEfiFile2 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x0,
            .len = 24,
        };
        FuStructEfiFile st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_efi_file_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_efi_file2_parse_internal(FuStructEfiFile2 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_file2_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_file2_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_file2_parse_stream: (skip):
 **/
FuStructEfiFile2 *
fu_struct_efi_file2_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiFile2) st = fu_struct_efi_file2_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiFile2 failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiFile2 requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_file2_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_section_compression_ref: (skip):
 **/
FuStructEfiSectionCompression *
fu_struct_efi_section_compression_ref(FuStructEfiSectionCompression *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_section_compression_unref: (skip):
 **/
void
fu_struct_efi_section_compression_unref(FuStructEfiSectionCompression *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiSectionCompression refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_section_compression_new_internal: (skip):
 **/
static FuStructEfiSectionCompression *
fu_struct_efi_section_compression_new_internal(void)
{
    FuStructEfiSectionCompression *st = g_new0(FuStructEfiSectionCompression, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_section_compression_get_uncompressed_length: (skip):
 **/
guint32
fu_struct_efi_section_compression_get_uncompressed_length(const FuStructEfiSectionCompression *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_compression_get_compression_type: (skip):
 **/
FuEfiCompressionType
fu_struct_efi_section_compression_get_compression_type(const FuStructEfiSectionCompression *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}

/* setters */
/**
 * fu_struct_efi_section_compression_to_string: (skip):
 **/
static gchar *
fu_struct_efi_section_compression_to_string(const FuStructEfiSectionCompression *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiSectionCompression:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  uncompressed_length: 0x%x\n",
                           (guint) fu_struct_efi_section_compression_get_uncompressed_length(st));
    {
        const gchar *tmp = fu_efi_compression_type_to_string(fu_struct_efi_section_compression_get_compression_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  compression_type: 0x%x [%s]\n", (guint) fu_struct_efi_section_compression_get_compression_type(st), tmp);
        } else {
            g_string_append_printf(str, "  compression_type: 0x%x\n", (guint) fu_struct_efi_section_compression_get_compression_type(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_section_compression_validate_internal(FuStructEfiSectionCompression *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_section_compression_parse_internal(FuStructEfiSectionCompression *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_section_compression_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_section_compression_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_section_compression_parse_stream: (skip):
 **/
FuStructEfiSectionCompression *
fu_struct_efi_section_compression_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiSectionCompression) st = fu_struct_efi_section_compression_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 5, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiSectionCompression failed read of 0x%x: ", (guint) 5);
        return NULL;
    }
    if (st->buf->len != 5) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiSectionCompression requested 0x%x and got 0x%x",
                    (guint) 5,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_section_compression_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_lz77_decompressor_header_ref: (skip):
 **/
FuStructEfiLz77DecompressorHeader *
fu_struct_efi_lz77_decompressor_header_ref(FuStructEfiLz77DecompressorHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_lz77_decompressor_header_unref: (skip):
 **/
void
fu_struct_efi_lz77_decompressor_header_unref(FuStructEfiLz77DecompressorHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiLz77DecompressorHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_lz77_decompressor_header_new_internal: (skip):
 **/
static FuStructEfiLz77DecompressorHeader *
fu_struct_efi_lz77_decompressor_header_new_internal(void)
{
    FuStructEfiLz77DecompressorHeader *st = g_new0(FuStructEfiLz77DecompressorHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_lz77_decompressor_header_get_src_size: (skip):
 **/
guint32
fu_struct_efi_lz77_decompressor_header_get_src_size(const FuStructEfiLz77DecompressorHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_lz77_decompressor_header_get_dst_size: (skip):
 **/
guint32
fu_struct_efi_lz77_decompressor_header_get_dst_size(const FuStructEfiLz77DecompressorHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_lz77_decompressor_header_to_string: (skip):
 **/
static gchar *
fu_struct_efi_lz77_decompressor_header_to_string(const FuStructEfiLz77DecompressorHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiLz77DecompressorHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  src_size: 0x%x\n",
                           (guint) fu_struct_efi_lz77_decompressor_header_get_src_size(st));
    g_string_append_printf(str, "  dst_size: 0x%x\n",
                           (guint) fu_struct_efi_lz77_decompressor_header_get_dst_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_lz77_decompressor_header_validate_internal(FuStructEfiLz77DecompressorHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_lz77_decompressor_header_parse_internal(FuStructEfiLz77DecompressorHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_lz77_decompressor_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_lz77_decompressor_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_lz77_decompressor_header_parse_stream: (skip):
 **/
FuStructEfiLz77DecompressorHeader *
fu_struct_efi_lz77_decompressor_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiLz77DecompressorHeader) st = fu_struct_efi_lz77_decompressor_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiLz77DecompressorHeader failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiLz77DecompressorHeader requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_lz77_decompressor_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_section_ref: (skip):
 **/
FuStructEfiSection *
fu_struct_efi_section_ref(FuStructEfiSection *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_section_unref: (skip):
 **/
void
fu_struct_efi_section_unref(FuStructEfiSection *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiSection refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_section_new_internal: (skip):
 **/
static FuStructEfiSection *
fu_struct_efi_section_new_internal(void)
{
    FuStructEfiSection *st = g_new0(FuStructEfiSection, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_section_get_size: (skip):
 **/
guint32
fu_struct_efi_section_get_size(const FuStructEfiSection *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_get_type: (skip):
 **/
FuEfiSectionType
fu_struct_efi_section_get_type(const FuStructEfiSection *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_efi_section_set_size: (skip):
 **/
void
fu_struct_efi_section_set_size(FuStructEfiSection *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_set_type: (skip):
 **/
void
fu_struct_efi_section_set_type(FuStructEfiSection *st, FuEfiSectionType value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_efi_section_new: (skip):
 **/
FuStructEfiSection *
fu_struct_efi_section_new(void)
{
    FuStructEfiSection *st = fu_struct_efi_section_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    return st;
}
/**
 * fu_struct_efi_section_to_string: (skip):
 **/
static gchar *
fu_struct_efi_section_to_string(const FuStructEfiSection *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiSection:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_section_get_size(st));
    {
        const gchar *tmp = fu_efi_section_type_to_string(fu_struct_efi_section_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_efi_section_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_efi_section_get_type(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_section_validate_internal(FuStructEfiSection *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_section_parse_internal(FuStructEfiSection *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_section_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_section_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_section_parse_stream: (skip):
 **/
FuStructEfiSection *
fu_struct_efi_section_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiSection) st = fu_struct_efi_section_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiSection failed read of 0x%x: ", (guint) 4);
        return NULL;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiSection requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_section_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_section2_ref: (skip):
 **/
FuStructEfiSection2 *
fu_struct_efi_section2_ref(FuStructEfiSection2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_section2_unref: (skip):
 **/
void
fu_struct_efi_section2_unref(FuStructEfiSection2 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiSection2 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_section2_new_internal: (skip):
 **/
static FuStructEfiSection2 *
fu_struct_efi_section2_new_internal(void)
{
    FuStructEfiSection2 *st = g_new0(FuStructEfiSection2, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_section2_get_size: (skip):
 **/
static guint32
fu_struct_efi_section2_get_size(const FuStructEfiSection2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section2_get_type: (skip):
 **/
FuEfiSectionType
fu_struct_efi_section2_get_type(const FuStructEfiSection2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_efi_section2_get_extended_size: (skip):
 **/
guint32
fu_struct_efi_section2_get_extended_size(const FuStructEfiSection2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_section2_to_string: (skip):
 **/
static gchar *
fu_struct_efi_section2_to_string(const FuStructEfiSection2 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiSection2:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_efi_section_type_to_string(fu_struct_efi_section2_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_efi_section2_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_efi_section2_get_type(st));
        }
    }
    g_string_append_printf(str, "  extended_size: 0x%x\n",
                           (guint) fu_struct_efi_section2_get_extended_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_section2_validate_internal(FuStructEfiSection2 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_efi_section2_get_size(st) != 0xFFFFFF) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEfiSection2.size was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0xFFFFFF,
                    (guint) fu_struct_efi_section2_get_size(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_efi_section2_parse_internal(FuStructEfiSection2 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_section2_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_section2_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_section2_parse_stream: (skip):
 **/
FuStructEfiSection2 *
fu_struct_efi_section2_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiSection2) st = fu_struct_efi_section2_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiSection2 failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiSection2 requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_section2_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_section_freeform_subtype_guid_ref: (skip):
 **/
FuStructEfiSectionFreeformSubtypeGuid *
fu_struct_efi_section_freeform_subtype_guid_ref(FuStructEfiSectionFreeformSubtypeGuid *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_section_freeform_subtype_guid_unref: (skip):
 **/
void
fu_struct_efi_section_freeform_subtype_guid_unref(FuStructEfiSectionFreeformSubtypeGuid *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiSectionFreeformSubtypeGuid refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_section_freeform_subtype_guid_new_internal: (skip):
 **/
static FuStructEfiSectionFreeformSubtypeGuid *
fu_struct_efi_section_freeform_subtype_guid_new_internal(void)
{
    FuStructEfiSectionFreeformSubtypeGuid *st = g_new0(FuStructEfiSectionFreeformSubtypeGuid, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_section_freeform_subtype_guid_get_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_section_freeform_subtype_guid_get_guid(const FuStructEfiSectionFreeformSubtypeGuid *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}

/* setters */
/**
 * fu_struct_efi_section_freeform_subtype_guid_to_string: (skip):
 **/
static gchar *
fu_struct_efi_section_freeform_subtype_guid_to_string(const FuStructEfiSectionFreeformSubtypeGuid *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiSectionFreeformSubtypeGuid:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_section_freeform_subtype_guid_get_guid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  guid: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_section_freeform_subtype_guid_validate_internal(FuStructEfiSectionFreeformSubtypeGuid *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_section_freeform_subtype_guid_parse_internal(FuStructEfiSectionFreeformSubtypeGuid *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_section_freeform_subtype_guid_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_section_freeform_subtype_guid_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_section_freeform_subtype_guid_parse_stream: (skip):
 **/
FuStructEfiSectionFreeformSubtypeGuid *
fu_struct_efi_section_freeform_subtype_guid_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiSectionFreeformSubtypeGuid) st = fu_struct_efi_section_freeform_subtype_guid_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiSectionFreeformSubtypeGuid failed read of 0x%x: ", (guint) 16);
        return NULL;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiSectionFreeformSubtypeGuid requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_section_freeform_subtype_guid_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_section_guid_defined_ref: (skip):
 **/
FuStructEfiSectionGuidDefined *
fu_struct_efi_section_guid_defined_ref(FuStructEfiSectionGuidDefined *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_section_guid_defined_unref: (skip):
 **/
void
fu_struct_efi_section_guid_defined_unref(FuStructEfiSectionGuidDefined *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiSectionGuidDefined refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_section_guid_defined_new_internal: (skip):
 **/
static FuStructEfiSectionGuidDefined *
fu_struct_efi_section_guid_defined_new_internal(void)
{
    FuStructEfiSectionGuidDefined *st = g_new0(FuStructEfiSectionGuidDefined, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_section_guid_defined_get_name: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_section_guid_defined_get_name(const FuStructEfiSectionGuidDefined *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_efi_section_guid_defined_get_offset: (skip):
 **/
guint16
fu_struct_efi_section_guid_defined_get_offset(const FuStructEfiSectionGuidDefined *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_guid_defined_get_attr: (skip):
 **/
guint16
fu_struct_efi_section_guid_defined_get_attr(const FuStructEfiSectionGuidDefined *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_section_guid_defined_set_name: (skip):
 **/
void
fu_struct_efi_section_guid_defined_set_name(FuStructEfiSectionGuidDefined *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_section_guid_defined_set_offset: (skip):
 **/
void
fu_struct_efi_section_guid_defined_set_offset(FuStructEfiSectionGuidDefined *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_guid_defined_set_attr: (skip):
 **/
void
fu_struct_efi_section_guid_defined_set_attr(FuStructEfiSectionGuidDefined *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_guid_defined_new: (skip):
 **/
FuStructEfiSectionGuidDefined *
fu_struct_efi_section_guid_defined_new(void)
{
    FuStructEfiSectionGuidDefined *st = fu_struct_efi_section_guid_defined_new_internal();
    st->buf = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st->buf, 20, 0x0);
    return st;
}
/**
 * fu_struct_efi_section_guid_defined_to_string: (skip):
 **/
static gchar *
fu_struct_efi_section_guid_defined_to_string(const FuStructEfiSectionGuidDefined *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiSectionGuidDefined:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_section_guid_defined_get_name(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_efi_section_guid_defined_get_offset(st));
    g_string_append_printf(str, "  attr: 0x%x\n",
                           (guint) fu_struct_efi_section_guid_defined_get_attr(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_section_guid_defined_validate_internal(FuStructEfiSectionGuidDefined *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_section_guid_defined_parse_internal(FuStructEfiSectionGuidDefined *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_section_guid_defined_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_section_guid_defined_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_section_guid_defined_parse_stream: (skip):
 **/
FuStructEfiSectionGuidDefined *
fu_struct_efi_section_guid_defined_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiSectionGuidDefined) st = fu_struct_efi_section_guid_defined_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 20, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiSectionGuidDefined failed read of 0x%x: ", (guint) 20);
        return NULL;
    }
    if (st->buf->len != 20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiSectionGuidDefined requested 0x%x and got 0x%x",
                    (guint) 20,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_section_guid_defined_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_volume_ref: (skip):
 **/
FuStructEfiVolume *
fu_struct_efi_volume_ref(FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_volume_unref: (skip):
 **/
void
fu_struct_efi_volume_unref(FuStructEfiVolume *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiVolume refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_volume_new_internal: (skip):
 **/
static FuStructEfiVolume *
fu_struct_efi_volume_new_internal(void)
{
    FuStructEfiVolume *st = g_new0(FuStructEfiVolume, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_volume_get_zero_vector: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_volume_get_zero_vector(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_efi_volume_get_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_volume_get_guid(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 16);
}
/**
 * fu_struct_efi_volume_get_length: (skip):
 **/
guint64
fu_struct_efi_volume_get_length(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_signature: (skip):
 **/
static guint32
fu_struct_efi_volume_get_signature(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_attrs: (skip):
 **/
guint32
fu_struct_efi_volume_get_attrs(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 44, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_hdr_len: (skip):
 **/
guint16
fu_struct_efi_volume_get_hdr_len(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 48, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_checksum: (skip):
 **/
guint16
fu_struct_efi_volume_get_checksum(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 50, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_ext_hdr: (skip):
 **/
guint16
fu_struct_efi_volume_get_ext_hdr(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 52, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_revision: (skip):
 **/
static guint8
fu_struct_efi_volume_get_revision(const FuStructEfiVolume *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[55];
}

/* setters */
/**
 * fu_struct_efi_volume_set_zero_vector: (skip):
 **/
void
fu_struct_efi_volume_set_zero_vector(FuStructEfiVolume *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_volume_set_guid: (skip):
 **/
void
fu_struct_efi_volume_set_guid(FuStructEfiVolume *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 16, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_volume_set_length: (skip):
 **/
void
fu_struct_efi_volume_set_length(FuStructEfiVolume *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_signature: (skip):
 **/
static void
fu_struct_efi_volume_set_signature(FuStructEfiVolume *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_attrs: (skip):
 **/
void
fu_struct_efi_volume_set_attrs(FuStructEfiVolume *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 44, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_hdr_len: (skip):
 **/
void
fu_struct_efi_volume_set_hdr_len(FuStructEfiVolume *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 48, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_checksum: (skip):
 **/
void
fu_struct_efi_volume_set_checksum(FuStructEfiVolume *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 50, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_ext_hdr: (skip):
 **/
void
fu_struct_efi_volume_set_ext_hdr(FuStructEfiVolume *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 52, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_revision: (skip):
 **/
static void
fu_struct_efi_volume_set_revision(FuStructEfiVolume *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[55] = value;
}
/**
 * fu_struct_efi_volume_new: (skip):
 **/
FuStructEfiVolume *
fu_struct_efi_volume_new(void)
{
    FuStructEfiVolume *st = fu_struct_efi_volume_new_internal();
    st->buf = g_byte_array_sized_new(56);
    fu_byte_array_set_size(st->buf, 56, 0x0);
    fu_struct_efi_volume_set_signature(st, 0x4856465F);
    fu_struct_efi_volume_set_revision(st, 0x02);
    return st;
}
/**
 * fu_struct_efi_volume_to_string: (skip):
 **/
static gchar *
fu_struct_efi_volume_to_string(const FuStructEfiVolume *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiVolume:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_volume_get_zero_vector(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  zero_vector: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_volume_get_guid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  guid: %s\n", tmp);
    }
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_length(st));
    g_string_append_printf(str, "  attrs: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_attrs(st));
    g_string_append_printf(str, "  hdr_len: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_hdr_len(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_checksum(st));
    g_string_append_printf(str, "  ext_hdr: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_ext_hdr(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_volume_validate_internal(FuStructEfiVolume *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_efi_volume_get_signature(st) != 0x4856465F) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEfiVolume.signature was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x4856465F,
                    (guint) fu_struct_efi_volume_get_signature(st));
        return FALSE;
    }
    if (fu_struct_efi_volume_get_revision(st) != 0x02) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructEfiVolume.revision was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_efi_volume_validate_stream: (skip):
 **/
gboolean
fu_struct_efi_volume_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVolume) st = fu_struct_efi_volume_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 56, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVolume failed read of 0x%x: ", (guint) 56);
        return FALSE;
    }
    if (st->buf->len != 56) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVolume requested 0x%x and got 0x%x",
                    (guint) 56,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_efi_volume_validate_internal(st, error);
}
static gboolean
fu_struct_efi_volume_parse_internal(FuStructEfiVolume *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_volume_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_volume_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_volume_parse_stream: (skip):
 **/
FuStructEfiVolume *
fu_struct_efi_volume_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVolume) st = fu_struct_efi_volume_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 56, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVolume failed read of 0x%x: ", (guint) 56);
        return NULL;
    }
    if (st->buf->len != 56) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVolume requested 0x%x and got 0x%x",
                    (guint) 56,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_volume_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_volume_ext_header_ref: (skip):
 **/
FuStructEfiVolumeExtHeader *
fu_struct_efi_volume_ext_header_ref(FuStructEfiVolumeExtHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_volume_ext_header_unref: (skip):
 **/
void
fu_struct_efi_volume_ext_header_unref(FuStructEfiVolumeExtHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiVolumeExtHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_volume_ext_header_new_internal: (skip):
 **/
static FuStructEfiVolumeExtHeader *
fu_struct_efi_volume_ext_header_new_internal(void)
{
    FuStructEfiVolumeExtHeader *st = g_new0(FuStructEfiVolumeExtHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_volume_ext_header_get_fv_name: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_volume_ext_header_get_fv_name(const FuStructEfiVolumeExtHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_efi_volume_ext_header_get_size: (skip):
 **/
guint32
fu_struct_efi_volume_ext_header_get_size(const FuStructEfiVolumeExtHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_volume_ext_header_to_string: (skip):
 **/
static gchar *
fu_struct_efi_volume_ext_header_to_string(const FuStructEfiVolumeExtHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiVolumeExtHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_volume_ext_header_get_fv_name(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  fv_name: %s\n", tmp);
    }
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_volume_ext_header_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_volume_ext_header_validate_internal(FuStructEfiVolumeExtHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_volume_ext_header_parse_internal(FuStructEfiVolumeExtHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_volume_ext_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_volume_ext_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_volume_ext_header_parse_stream: (skip):
 **/
FuStructEfiVolumeExtHeader *
fu_struct_efi_volume_ext_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVolumeExtHeader) st = fu_struct_efi_volume_ext_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 20, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVolumeExtHeader failed read of 0x%x: ", (guint) 20);
        return NULL;
    }
    if (st->buf->len != 20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVolumeExtHeader requested 0x%x and got 0x%x",
                    (guint) 20,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_volume_ext_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_volume_ext_entry_ref: (skip):
 **/
FuStructEfiVolumeExtEntry *
fu_struct_efi_volume_ext_entry_ref(FuStructEfiVolumeExtEntry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_volume_ext_entry_unref: (skip):
 **/
void
fu_struct_efi_volume_ext_entry_unref(FuStructEfiVolumeExtEntry *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiVolumeExtEntry refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_volume_ext_entry_new_internal: (skip):
 **/
static FuStructEfiVolumeExtEntry *
fu_struct_efi_volume_ext_entry_new_internal(void)
{
    FuStructEfiVolumeExtEntry *st = g_new0(FuStructEfiVolumeExtEntry, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_volume_ext_entry_get_size: (skip):
 **/
guint16
fu_struct_efi_volume_ext_entry_get_size(const FuStructEfiVolumeExtEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_ext_entry_get_type: (skip):
 **/
FuEfiVolumeExtEntryType
fu_struct_efi_volume_ext_entry_get_type(const FuStructEfiVolumeExtEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_volume_ext_entry_to_string: (skip):
 **/
static gchar *
fu_struct_efi_volume_ext_entry_to_string(const FuStructEfiVolumeExtEntry *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiVolumeExtEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_volume_ext_entry_get_size(st));
    {
        const gchar *tmp = fu_efi_volume_ext_entry_type_to_string(fu_struct_efi_volume_ext_entry_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_efi_volume_ext_entry_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_efi_volume_ext_entry_get_type(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_volume_ext_entry_validate_internal(FuStructEfiVolumeExtEntry *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_volume_ext_entry_parse_internal(FuStructEfiVolumeExtEntry *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_volume_ext_entry_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_volume_ext_entry_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_volume_ext_entry_parse_stream: (skip):
 **/
FuStructEfiVolumeExtEntry *
fu_struct_efi_volume_ext_entry_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVolumeExtEntry) st = fu_struct_efi_volume_ext_entry_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVolumeExtEntry failed read of 0x%x: ", (guint) 4);
        return NULL;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVolumeExtEntry requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_volume_ext_entry_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_volume_block_map_ref: (skip):
 **/
FuStructEfiVolumeBlockMap *
fu_struct_efi_volume_block_map_ref(FuStructEfiVolumeBlockMap *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_volume_block_map_unref: (skip):
 **/
void
fu_struct_efi_volume_block_map_unref(FuStructEfiVolumeBlockMap *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiVolumeBlockMap refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_volume_block_map_new_internal: (skip):
 **/
static FuStructEfiVolumeBlockMap *
fu_struct_efi_volume_block_map_new_internal(void)
{
    FuStructEfiVolumeBlockMap *st = g_new0(FuStructEfiVolumeBlockMap, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_volume_block_map_get_num_blocks: (skip):
 **/
guint32
fu_struct_efi_volume_block_map_get_num_blocks(const FuStructEfiVolumeBlockMap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_block_map_get_length: (skip):
 **/
guint32
fu_struct_efi_volume_block_map_get_length(const FuStructEfiVolumeBlockMap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_volume_block_map_set_num_blocks: (skip):
 **/
void
fu_struct_efi_volume_block_map_set_num_blocks(FuStructEfiVolumeBlockMap *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_block_map_set_length: (skip):
 **/
void
fu_struct_efi_volume_block_map_set_length(FuStructEfiVolumeBlockMap *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_block_map_new: (skip):
 **/
FuStructEfiVolumeBlockMap *
fu_struct_efi_volume_block_map_new(void)
{
    FuStructEfiVolumeBlockMap *st = fu_struct_efi_volume_block_map_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_efi_volume_block_map_to_string: (skip):
 **/
static gchar *
fu_struct_efi_volume_block_map_to_string(const FuStructEfiVolumeBlockMap *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiVolumeBlockMap:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  num_blocks: 0x%x\n",
                           (guint) fu_struct_efi_volume_block_map_get_num_blocks(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_efi_volume_block_map_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_volume_block_map_validate_internal(FuStructEfiVolumeBlockMap *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_volume_block_map_parse_internal(FuStructEfiVolumeBlockMap *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_volume_block_map_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_volume_block_map_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_volume_block_map_parse_stream: (skip):
 **/
FuStructEfiVolumeBlockMap *
fu_struct_efi_volume_block_map_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVolumeBlockMap) st = fu_struct_efi_volume_block_map_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVolumeBlockMap failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVolumeBlockMap requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_volume_block_map_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_time_ref: (skip):
 **/
FuStructEfiTime *
fu_struct_efi_time_ref(FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_time_unref: (skip):
 **/
void
fu_struct_efi_time_unref(FuStructEfiTime *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiTime refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_time_new_internal: (skip):
 **/
FuStructEfiTime *
fu_struct_efi_time_new_internal(void)
{
    FuStructEfiTime *st = g_new0(FuStructEfiTime, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_time_get_year: (skip):
 **/
guint16
fu_struct_efi_time_get_year(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_time_get_month: (skip):
 **/
guint8
fu_struct_efi_time_get_month(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_efi_time_get_day: (skip):
 **/
guint8
fu_struct_efi_time_get_day(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_efi_time_get_hour: (skip):
 **/
guint8
fu_struct_efi_time_get_hour(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_efi_time_get_minute: (skip):
 **/
guint8
fu_struct_efi_time_get_minute(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_efi_time_get_second: (skip):
 **/
guint8
fu_struct_efi_time_get_second(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_efi_time_get_nanosecond: (skip):
 **/
guint32
fu_struct_efi_time_get_nanosecond(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_time_get_timezone: (skip):
 **/
guint16
fu_struct_efi_time_get_timezone(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_time_get_daylight: (skip):
 **/
guint8
fu_struct_efi_time_get_daylight(const FuStructEfiTime *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[14];
}

/* setters */
/**
 * fu_struct_efi_time_set_year: (skip):
 **/
void
fu_struct_efi_time_set_year(FuStructEfiTime *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_time_set_month: (skip):
 **/
void
fu_struct_efi_time_set_month(FuStructEfiTime *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_efi_time_set_day: (skip):
 **/
void
fu_struct_efi_time_set_day(FuStructEfiTime *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_efi_time_set_hour: (skip):
 **/
void
fu_struct_efi_time_set_hour(FuStructEfiTime *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_efi_time_set_minute: (skip):
 **/
void
fu_struct_efi_time_set_minute(FuStructEfiTime *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_efi_time_set_second: (skip):
 **/
void
fu_struct_efi_time_set_second(FuStructEfiTime *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_efi_time_set_nanosecond: (skip):
 **/
void
fu_struct_efi_time_set_nanosecond(FuStructEfiTime *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_time_set_timezone: (skip):
 **/
void
fu_struct_efi_time_set_timezone(FuStructEfiTime *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_time_set_daylight: (skip):
 **/
void
fu_struct_efi_time_set_daylight(FuStructEfiTime *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[14] = value;
}
/**
 * fu_struct_efi_time_new: (skip):
 **/
FuStructEfiTime *
fu_struct_efi_time_new(void)
{
    FuStructEfiTime *st = fu_struct_efi_time_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    return st;
}
/**
 * fu_struct_efi_time_to_string: (skip):
 **/
gchar *
fu_struct_efi_time_to_string(const FuStructEfiTime *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiTime:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  year: 0x%x\n",
                           (guint) fu_struct_efi_time_get_year(st));
    g_string_append_printf(str, "  month: 0x%x\n",
                           (guint) fu_struct_efi_time_get_month(st));
    g_string_append_printf(str, "  day: 0x%x\n",
                           (guint) fu_struct_efi_time_get_day(st));
    g_string_append_printf(str, "  hour: 0x%x\n",
                           (guint) fu_struct_efi_time_get_hour(st));
    g_string_append_printf(str, "  minute: 0x%x\n",
                           (guint) fu_struct_efi_time_get_minute(st));
    g_string_append_printf(str, "  second: 0x%x\n",
                           (guint) fu_struct_efi_time_get_second(st));
    g_string_append_printf(str, "  nanosecond: 0x%x\n",
                           (guint) fu_struct_efi_time_get_nanosecond(st));
    g_string_append_printf(str, "  timezone: 0x%x\n",
                           (guint) fu_struct_efi_time_get_timezone(st));
    g_string_append_printf(str, "  daylight: 0x%x\n",
                           (guint) fu_struct_efi_time_get_daylight(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
gboolean
fu_struct_efi_time_validate_internal(FuStructEfiTime *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_efi_win_certificate_ref: (skip):
 **/
FuStructEfiWinCertificate *
fu_struct_efi_win_certificate_ref(FuStructEfiWinCertificate *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_win_certificate_unref: (skip):
 **/
void
fu_struct_efi_win_certificate_unref(FuStructEfiWinCertificate *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiWinCertificate refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_win_certificate_new_internal: (skip):
 **/
static FuStructEfiWinCertificate *
fu_struct_efi_win_certificate_new_internal(void)
{
    FuStructEfiWinCertificate *st = g_new0(FuStructEfiWinCertificate, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_win_certificate_get_length: (skip):
 **/
guint32
fu_struct_efi_win_certificate_get_length(const FuStructEfiWinCertificate *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_win_certificate_get_revision: (skip):
 **/
static guint16
fu_struct_efi_win_certificate_get_revision(const FuStructEfiWinCertificate *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_win_certificate_get_certificate_type: (skip):
 **/
static guint16
fu_struct_efi_win_certificate_get_certificate_type(const FuStructEfiWinCertificate *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_win_certificate_get_guid: (skip):
 **/
static const fwupd_guid_t *
fu_struct_efi_win_certificate_get_guid(const FuStructEfiWinCertificate *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 8);
}

/* setters */
/**
 * fu_struct_efi_win_certificate_set_length: (skip):
 **/
void
fu_struct_efi_win_certificate_set_length(FuStructEfiWinCertificate *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_win_certificate_set_revision: (skip):
 **/
static void
fu_struct_efi_win_certificate_set_revision(FuStructEfiWinCertificate *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_win_certificate_set_certificate_type: (skip):
 **/
static void
fu_struct_efi_win_certificate_set_certificate_type(FuStructEfiWinCertificate *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_win_certificate_set_guid: (skip):
 **/
static void
fu_struct_efi_win_certificate_set_guid(FuStructEfiWinCertificate *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 8, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_win_certificate_new: (skip):
 **/
static FuStructEfiWinCertificate *
fu_struct_efi_win_certificate_new(void)
{
    FuStructEfiWinCertificate *st = fu_struct_efi_win_certificate_new_internal();
    st->buf = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st->buf, 24, 0x0);
    fu_struct_efi_win_certificate_set_length(st, 24);
    fu_struct_efi_win_certificate_set_revision(st, 0x0200);
    fu_struct_efi_win_certificate_set_certificate_type(st, 0x0EF1);
    fu_struct_efi_win_certificate_set_guid(st, (fwupd_guid_t *) "\x9d\xd2\xaf\x4a\xdf\x68\xee\x49\x8a\xa9\x34\x7d\x37\x56\x65\xa7");
    return st;
}
/**
 * fu_struct_efi_win_certificate_to_string: (skip):
 **/
static gchar *
fu_struct_efi_win_certificate_to_string(const FuStructEfiWinCertificate *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiWinCertificate:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_efi_win_certificate_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_win_certificate_validate_internal(FuStructEfiWinCertificate *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_efi_win_certificate_get_revision(st) != 0x0200) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEfiWinCertificate.revision was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0200,
                    (guint) fu_struct_efi_win_certificate_get_revision(st));
        return FALSE;
    }
    if (fu_struct_efi_win_certificate_get_certificate_type(st) != 0x0EF1) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEfiWinCertificate.certificate_type was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0EF1,
                    (guint) fu_struct_efi_win_certificate_get_certificate_type(st));
        return FALSE;
    }
    if (memcmp(fu_struct_efi_win_certificate_get_guid(st), "\x9d\xd2\xaf\x4a\xdf\x68\xee\x49\x8a\xa9\x34\x7d\x37\x56\x65\xa7", 16) != 0) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructEfiWinCertificate.guid was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_efi_variable_authentication2_ref: (skip):
 **/
FuStructEfiVariableAuthentication2 *
fu_struct_efi_variable_authentication2_ref(FuStructEfiVariableAuthentication2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_variable_authentication2_unref: (skip):
 **/
void
fu_struct_efi_variable_authentication2_unref(FuStructEfiVariableAuthentication2 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiVariableAuthentication2 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_variable_authentication2_new_internal: (skip):
 **/
static FuStructEfiVariableAuthentication2 *
fu_struct_efi_variable_authentication2_new_internal(void)
{
    FuStructEfiVariableAuthentication2 *st = g_new0(FuStructEfiVariableAuthentication2, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_variable_authentication2_get_timestamp: (skip):
 **/
FuStructEfiTime *
fu_struct_efi_variable_authentication2_get_timestamp(const FuStructEfiVariableAuthentication2 *st)
{
    g_autoptr(FuStructEfiTime) st_tmp = fu_struct_efi_time_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_EFI_VARIABLE_AUTHENTICATION2_OFFSET_TIMESTAMP, 16);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_efi_variable_authentication2_get_auth_info: (skip):
 **/
FuStructEfiWinCertificate *
fu_struct_efi_variable_authentication2_get_auth_info(const FuStructEfiVariableAuthentication2 *st)
{
    g_autoptr(FuStructEfiWinCertificate) st_tmp = fu_struct_efi_win_certificate_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_EFI_VARIABLE_AUTHENTICATION2_OFFSET_AUTH_INFO, 24);
    return g_steal_pointer(&st_tmp);
}

/* setters */
/**
 * fu_struct_efi_variable_authentication2_set_timestamp: (skip):
 **/
gboolean
fu_struct_efi_variable_authentication2_set_timestamp(FuStructEfiVariableAuthentication2 *st, const FuStructEfiTime *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_EFI_TIME_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructEfiTime' (0x%x bytes) does not fit in "
                    "FuStructEfiVariableAuthentication2.timestamp (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_EFI_TIME_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_EFI_VARIABLE_AUTHENTICATION2_OFFSET_TIMESTAMP, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_efi_variable_authentication2_set_auth_info: (skip):
 **/
gboolean
fu_struct_efi_variable_authentication2_set_auth_info(FuStructEfiVariableAuthentication2 *st, const FuStructEfiWinCertificate *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_EFI_WIN_CERTIFICATE_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructEfiWinCertificate' (0x%x bytes) does not fit in "
                    "FuStructEfiVariableAuthentication2.auth_info (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_EFI_WIN_CERTIFICATE_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_EFI_VARIABLE_AUTHENTICATION2_OFFSET_AUTH_INFO, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_efi_variable_authentication2_new: (skip):
 **/
FuStructEfiVariableAuthentication2 *
fu_struct_efi_variable_authentication2_new(void)
{
    FuStructEfiVariableAuthentication2 *st = fu_struct_efi_variable_authentication2_new_internal();
    st->buf = g_byte_array_sized_new(40);
    fu_byte_array_set_size(st->buf, 40, 0x0);
    {
        g_autoptr(FuStructEfiTime) st_donor = fu_struct_efi_time_new();
        memcpy(st->buf->data + 0x0, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    {
        g_autoptr(FuStructEfiWinCertificate) st_donor = fu_struct_efi_win_certificate_new();
        memcpy(st->buf->data + 0x10, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    return st;
}
/**
 * fu_struct_efi_variable_authentication2_to_string: (skip):
 **/
static gchar *
fu_struct_efi_variable_authentication2_to_string(const FuStructEfiVariableAuthentication2 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiVariableAuthentication2:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autoptr(FuStructEfiTime) st_tmp = fu_struct_efi_variable_authentication2_get_timestamp(st);
        g_autofree gchar *tmp = fu_struct_efi_time_to_string(st_tmp);
        g_string_append_printf(str, "  timestamp: %s\n", tmp);
    }
    {
        g_autoptr(FuStructEfiWinCertificate) st_tmp = fu_struct_efi_variable_authentication2_get_auth_info(st);
        g_autofree gchar *tmp = fu_struct_efi_win_certificate_to_string(st_tmp);
        g_string_append_printf(str, "  auth_info: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_variable_authentication2_validate_internal(FuStructEfiVariableAuthentication2 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x0,
            .len = 16,
        };
        FuStructEfiTime st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_efi_time_validate_internal(&st_tmp, error))
            return FALSE;
    }
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x10,
            .len = 24,
        };
        FuStructEfiWinCertificate st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_efi_win_certificate_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_efi_variable_authentication2_validate_stream: (skip):
 **/
gboolean
fu_struct_efi_variable_authentication2_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVariableAuthentication2) st = fu_struct_efi_variable_authentication2_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVariableAuthentication2 failed read of 0x%x: ", (guint) 40);
        return FALSE;
    }
    if (st->buf->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVariableAuthentication2 requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_efi_variable_authentication2_validate_internal(st, error);
}
static gboolean
fu_struct_efi_variable_authentication2_parse_internal(FuStructEfiVariableAuthentication2 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_variable_authentication2_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_variable_authentication2_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_variable_authentication2_parse_stream: (skip):
 **/
FuStructEfiVariableAuthentication2 *
fu_struct_efi_variable_authentication2_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVariableAuthentication2) st = fu_struct_efi_variable_authentication2_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVariableAuthentication2 failed read of 0x%x: ", (guint) 40);
        return NULL;
    }
    if (st->buf->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVariableAuthentication2 requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_variable_authentication2_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_signature_list_ref: (skip):
 **/
FuStructEfiSignatureList *
fu_struct_efi_signature_list_ref(FuStructEfiSignatureList *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_signature_list_unref: (skip):
 **/
void
fu_struct_efi_signature_list_unref(FuStructEfiSignatureList *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiSignatureList refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_signature_list_new_internal: (skip):
 **/
static FuStructEfiSignatureList *
fu_struct_efi_signature_list_new_internal(void)
{
    FuStructEfiSignatureList *st = g_new0(FuStructEfiSignatureList, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_signature_list_get_type: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_signature_list_get_type(const FuStructEfiSignatureList *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_efi_signature_list_get_list_size: (skip):
 **/
guint32
fu_struct_efi_signature_list_get_list_size(const FuStructEfiSignatureList *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_get_header_size: (skip):
 **/
guint32
fu_struct_efi_signature_list_get_header_size(const FuStructEfiSignatureList *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_get_size: (skip):
 **/
guint32
fu_struct_efi_signature_list_get_size(const FuStructEfiSignatureList *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_signature_list_set_type: (skip):
 **/
void
fu_struct_efi_signature_list_set_type(FuStructEfiSignatureList *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_signature_list_set_list_size: (skip):
 **/
void
fu_struct_efi_signature_list_set_list_size(FuStructEfiSignatureList *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_set_header_size: (skip):
 **/
void
fu_struct_efi_signature_list_set_header_size(FuStructEfiSignatureList *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_set_size: (skip):
 **/
void
fu_struct_efi_signature_list_set_size(FuStructEfiSignatureList *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_new: (skip):
 **/
FuStructEfiSignatureList *
fu_struct_efi_signature_list_new(void)
{
    FuStructEfiSignatureList *st = fu_struct_efi_signature_list_new_internal();
    st->buf = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st->buf, 28, 0x0);
    return st;
}
/**
 * fu_struct_efi_signature_list_to_string: (skip):
 **/
static gchar *
fu_struct_efi_signature_list_to_string(const FuStructEfiSignatureList *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiSignatureList:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_signature_list_get_type(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  type: %s\n", tmp);
    }
    g_string_append_printf(str, "  list_size: 0x%x\n",
                           (guint) fu_struct_efi_signature_list_get_list_size(st));
    g_string_append_printf(str, "  header_size: 0x%x\n",
                           (guint) fu_struct_efi_signature_list_get_header_size(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_signature_list_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_signature_list_validate_internal(FuStructEfiSignatureList *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_signature_list_parse_internal(FuStructEfiSignatureList *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_signature_list_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_signature_list_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_signature_list_parse_stream: (skip):
 **/
FuStructEfiSignatureList *
fu_struct_efi_signature_list_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiSignatureList) st = fu_struct_efi_signature_list_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiSignatureList failed read of 0x%x: ", (guint) 28);
        return NULL;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiSignatureList requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_signature_list_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_load_option_ref: (skip):
 **/
FuStructEfiLoadOption *
fu_struct_efi_load_option_ref(FuStructEfiLoadOption *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_load_option_unref: (skip):
 **/
void
fu_struct_efi_load_option_unref(FuStructEfiLoadOption *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiLoadOption refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_load_option_new_internal: (skip):
 **/
static FuStructEfiLoadOption *
fu_struct_efi_load_option_new_internal(void)
{
    FuStructEfiLoadOption *st = g_new0(FuStructEfiLoadOption, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_load_option_get_attrs: (skip):
 **/
FuEfiLoadOptionAttrs
fu_struct_efi_load_option_get_attrs(const FuStructEfiLoadOption *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_load_option_get_dp_size: (skip):
 **/
guint16
fu_struct_efi_load_option_get_dp_size(const FuStructEfiLoadOption *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_load_option_set_attrs: (skip):
 **/
void
fu_struct_efi_load_option_set_attrs(FuStructEfiLoadOption *st, FuEfiLoadOptionAttrs value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_load_option_set_dp_size: (skip):
 **/
void
fu_struct_efi_load_option_set_dp_size(FuStructEfiLoadOption *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_load_option_new: (skip):
 **/
FuStructEfiLoadOption *
fu_struct_efi_load_option_new(void)
{
    FuStructEfiLoadOption *st = fu_struct_efi_load_option_new_internal();
    st->buf = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st->buf, 6, 0x0);
    return st;
}
/**
 * fu_struct_efi_load_option_to_string: (skip):
 **/
static gchar *
fu_struct_efi_load_option_to_string(const FuStructEfiLoadOption *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiLoadOption:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_efi_load_option_attrs_to_string(fu_struct_efi_load_option_get_attrs(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  attrs: 0x%x [%s]\n", (guint) fu_struct_efi_load_option_get_attrs(st), tmp);
        } else {
            g_string_append_printf(str, "  attrs: 0x%x\n", (guint) fu_struct_efi_load_option_get_attrs(st));
        }
    }
    g_string_append_printf(str, "  dp_size: 0x%x\n",
                           (guint) fu_struct_efi_load_option_get_dp_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_load_option_validate_internal(FuStructEfiLoadOption *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_load_option_parse_internal(FuStructEfiLoadOption *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_load_option_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_load_option_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_load_option_parse_stream: (skip):
 **/
FuStructEfiLoadOption *
fu_struct_efi_load_option_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiLoadOption) st = fu_struct_efi_load_option_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 6, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiLoadOption failed read of 0x%x: ", (guint) 6);
        return NULL;
    }
    if (st->buf->len != 6) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiLoadOption requested 0x%x and got 0x%x",
                    (guint) 6,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_load_option_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_device_path_ref: (skip):
 **/
FuStructEfiDevicePath *
fu_struct_efi_device_path_ref(FuStructEfiDevicePath *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_device_path_unref: (skip):
 **/
void
fu_struct_efi_device_path_unref(FuStructEfiDevicePath *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiDevicePath refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_device_path_new_internal: (skip):
 **/
static FuStructEfiDevicePath *
fu_struct_efi_device_path_new_internal(void)
{
    FuStructEfiDevicePath *st = g_new0(FuStructEfiDevicePath, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_device_path_get_type: (skip):
 **/
FuEfiDevicePathType
fu_struct_efi_device_path_get_type(const FuStructEfiDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_efi_device_path_get_subtype: (skip):
 **/
guint8
fu_struct_efi_device_path_get_subtype(const FuStructEfiDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_efi_device_path_get_length: (skip):
 **/
guint16
fu_struct_efi_device_path_get_length(const FuStructEfiDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_device_path_set_type: (skip):
 **/
void
fu_struct_efi_device_path_set_type(FuStructEfiDevicePath *st, FuEfiDevicePathType value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_efi_device_path_set_subtype: (skip):
 **/
void
fu_struct_efi_device_path_set_subtype(FuStructEfiDevicePath *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_efi_device_path_set_length: (skip):
 **/
void
fu_struct_efi_device_path_set_length(FuStructEfiDevicePath *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_device_path_new: (skip):
 **/
FuStructEfiDevicePath *
fu_struct_efi_device_path_new(void)
{
    FuStructEfiDevicePath *st = fu_struct_efi_device_path_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    fu_struct_efi_device_path_set_subtype(st, 0xFF);
    fu_struct_efi_device_path_set_length(st, 4);
    return st;
}
/**
 * fu_struct_efi_device_path_to_string: (skip):
 **/
static gchar *
fu_struct_efi_device_path_to_string(const FuStructEfiDevicePath *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiDevicePath:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_efi_device_path_type_to_string(fu_struct_efi_device_path_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_efi_device_path_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_efi_device_path_get_type(st));
        }
    }
    g_string_append_printf(str, "  subtype: 0x%x\n",
                           (guint) fu_struct_efi_device_path_get_subtype(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_efi_device_path_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_device_path_validate_internal(FuStructEfiDevicePath *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efi_device_path_parse_internal(FuStructEfiDevicePath *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_device_path_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_device_path_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_device_path_parse_stream: (skip):
 **/
FuStructEfiDevicePath *
fu_struct_efi_device_path_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiDevicePath) st = fu_struct_efi_device_path_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiDevicePath failed read of 0x%x: ", (guint) 4);
        return NULL;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiDevicePath requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_device_path_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_hard_drive_device_path_ref: (skip):
 **/
FuStructEfiHardDriveDevicePath *
fu_struct_efi_hard_drive_device_path_ref(FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_hard_drive_device_path_unref: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_unref(FuStructEfiHardDriveDevicePath *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiHardDriveDevicePath refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_hard_drive_device_path_new_internal: (skip):
 **/
static FuStructEfiHardDriveDevicePath *
fu_struct_efi_hard_drive_device_path_new_internal(void)
{
    FuStructEfiHardDriveDevicePath *st = g_new0(FuStructEfiHardDriveDevicePath, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_hard_drive_device_path_get_type: (skip):
 **/
static FuEfiDevicePathType
fu_struct_efi_hard_drive_device_path_get_type(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_efi_hard_drive_device_path_get_subtype: (skip):
 **/
FuEfiHardDriveDevicePathSubtype
fu_struct_efi_hard_drive_device_path_get_subtype(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_efi_hard_drive_device_path_get_length: (skip):
 **/
static guint16
fu_struct_efi_hard_drive_device_path_get_length(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_number: (skip):
 **/
guint32
fu_struct_efi_hard_drive_device_path_get_partition_number(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_start: (skip):
 **/
guint64
fu_struct_efi_hard_drive_device_path_get_partition_start(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_size: (skip):
 **/
guint64
fu_struct_efi_hard_drive_device_path_get_partition_size(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_signature: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_hard_drive_device_path_get_partition_signature(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 24);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_format: (skip):
 **/
FuEfiHardDriveDevicePathPartitionFormat
fu_struct_efi_hard_drive_device_path_get_partition_format(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[40];
}
/**
 * fu_struct_efi_hard_drive_device_path_get_signature_type: (skip):
 **/
FuEfiHardDriveDevicePathSignatureType
fu_struct_efi_hard_drive_device_path_get_signature_type(const FuStructEfiHardDriveDevicePath *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[41];
}

/* setters */
/**
 * fu_struct_efi_hard_drive_device_path_set_type: (skip):
 **/
static void
fu_struct_efi_hard_drive_device_path_set_type(FuStructEfiHardDriveDevicePath *st, FuEfiDevicePathType value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_efi_hard_drive_device_path_set_subtype: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_subtype(FuStructEfiHardDriveDevicePath *st, FuEfiHardDriveDevicePathSubtype value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_efi_hard_drive_device_path_set_length: (skip):
 **/
static void
fu_struct_efi_hard_drive_device_path_set_length(FuStructEfiHardDriveDevicePath *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_number: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_number(FuStructEfiHardDriveDevicePath *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_start: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_start(FuStructEfiHardDriveDevicePath *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_size: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_size(FuStructEfiHardDriveDevicePath *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_signature: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_signature(FuStructEfiHardDriveDevicePath *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 24, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_format: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_format(FuStructEfiHardDriveDevicePath *st, FuEfiHardDriveDevicePathPartitionFormat value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[40] = value;
}
/**
 * fu_struct_efi_hard_drive_device_path_set_signature_type: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_signature_type(FuStructEfiHardDriveDevicePath *st, FuEfiHardDriveDevicePathSignatureType value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[41] = value;
}
/**
 * fu_struct_efi_hard_drive_device_path_new: (skip):
 **/
FuStructEfiHardDriveDevicePath *
fu_struct_efi_hard_drive_device_path_new(void)
{
    FuStructEfiHardDriveDevicePath *st = fu_struct_efi_hard_drive_device_path_new_internal();
    st->buf = g_byte_array_sized_new(42);
    fu_byte_array_set_size(st->buf, 42, 0x0);
    fu_struct_efi_hard_drive_device_path_set_type(st, FU_EFI_DEVICE_PATH_TYPE_MEDIA);
    fu_struct_efi_hard_drive_device_path_set_subtype(st, FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_HARD_DRIVE);
    fu_struct_efi_hard_drive_device_path_set_length(st, 42);
    fu_struct_efi_hard_drive_device_path_set_partition_format(st, FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_GUID_PARTITION_TABLE);
    fu_struct_efi_hard_drive_device_path_set_signature_type(st, FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_GUID);
    return st;
}
/**
 * fu_struct_efi_hard_drive_device_path_to_string: (skip):
 **/
static gchar *
fu_struct_efi_hard_drive_device_path_to_string(const FuStructEfiHardDriveDevicePath *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiHardDriveDevicePath:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_efi_hard_drive_device_path_subtype_to_string(fu_struct_efi_hard_drive_device_path_get_subtype(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  subtype: 0x%x [%s]\n", (guint) fu_struct_efi_hard_drive_device_path_get_subtype(st), tmp);
        } else {
            g_string_append_printf(str, "  subtype: 0x%x\n", (guint) fu_struct_efi_hard_drive_device_path_get_subtype(st));
        }
    }
    g_string_append_printf(str, "  partition_number: 0x%x\n",
                           (guint) fu_struct_efi_hard_drive_device_path_get_partition_number(st));
    g_string_append_printf(str, "  partition_start: 0x%x\n",
                           (guint) fu_struct_efi_hard_drive_device_path_get_partition_start(st));
    g_string_append_printf(str, "  partition_size: 0x%x\n",
                           (guint) fu_struct_efi_hard_drive_device_path_get_partition_size(st));
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_hard_drive_device_path_get_partition_signature(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  partition_signature: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_efi_hard_drive_device_path_partition_format_to_string(fu_struct_efi_hard_drive_device_path_get_partition_format(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  partition_format: 0x%x [%s]\n", (guint) fu_struct_efi_hard_drive_device_path_get_partition_format(st), tmp);
        } else {
            g_string_append_printf(str, "  partition_format: 0x%x\n", (guint) fu_struct_efi_hard_drive_device_path_get_partition_format(st));
        }
    }
    {
        const gchar *tmp = fu_efi_hard_drive_device_path_signature_type_to_string(fu_struct_efi_hard_drive_device_path_get_signature_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  signature_type: 0x%x [%s]\n", (guint) fu_struct_efi_hard_drive_device_path_get_signature_type(st), tmp);
        } else {
            g_string_append_printf(str, "  signature_type: 0x%x\n", (guint) fu_struct_efi_hard_drive_device_path_get_signature_type(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_hard_drive_device_path_validate_internal(FuStructEfiHardDriveDevicePath *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_efi_hard_drive_device_path_get_type(st) != FU_EFI_DEVICE_PATH_TYPE_MEDIA) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEfiHardDriveDevicePath.type was not valid, "
                    "expected 'FuEfiDevicePathType' and got '%s'",
                    fu_efi_device_path_type_to_string(fu_struct_efi_hard_drive_device_path_get_type(st)));
        return FALSE;
    }
    if (fu_struct_efi_hard_drive_device_path_get_length(st) != 42) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEfiHardDriveDevicePath.length was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 42,
                    (guint) fu_struct_efi_hard_drive_device_path_get_length(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_efi_hard_drive_device_path_parse_internal(FuStructEfiHardDriveDevicePath *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_hard_drive_device_path_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_hard_drive_device_path_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_hard_drive_device_path_parse_stream: (skip):
 **/
FuStructEfiHardDriveDevicePath *
fu_struct_efi_hard_drive_device_path_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiHardDriveDevicePath) st = fu_struct_efi_hard_drive_device_path_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 42, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiHardDriveDevicePath failed read of 0x%x: ", (guint) 42);
        return NULL;
    }
    if (st->buf->len != 42) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiHardDriveDevicePath requested 0x%x and got 0x%x",
                    (guint) 42,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_hard_drive_device_path_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_vss2_variable_store_header_ref: (skip):
 **/
FuStructEfiVss2VariableStoreHeader *
fu_struct_efi_vss2_variable_store_header_ref(FuStructEfiVss2VariableStoreHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_vss2_variable_store_header_unref: (skip):
 **/
void
fu_struct_efi_vss2_variable_store_header_unref(FuStructEfiVss2VariableStoreHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiVss2VariableStoreHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_vss2_variable_store_header_new_internal: (skip):
 **/
static FuStructEfiVss2VariableStoreHeader *
fu_struct_efi_vss2_variable_store_header_new_internal(void)
{
    FuStructEfiVss2VariableStoreHeader *st = g_new0(FuStructEfiVss2VariableStoreHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_vss2_variable_store_header_get_signature: (skip):
 **/
static const fwupd_guid_t *
fu_struct_efi_vss2_variable_store_header_get_signature(const FuStructEfiVss2VariableStoreHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_efi_vss2_variable_store_header_get_size: (skip):
 **/
guint32
fu_struct_efi_vss2_variable_store_header_get_size(const FuStructEfiVss2VariableStoreHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss2_variable_store_header_get_format: (skip):
 **/
static FuEfiVariableStoreFormat
fu_struct_efi_vss2_variable_store_header_get_format(const FuStructEfiVss2VariableStoreHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[20];
}
/**
 * fu_struct_efi_vss2_variable_store_header_get_state: (skip):
 **/
static FuEfiVariableStoreState
fu_struct_efi_vss2_variable_store_header_get_state(const FuStructEfiVss2VariableStoreHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[21];
}

/* setters */
/**
 * fu_struct_efi_vss2_variable_store_header_set_signature: (skip):
 **/
static void
fu_struct_efi_vss2_variable_store_header_set_signature(FuStructEfiVss2VariableStoreHeader *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_vss2_variable_store_header_set_size: (skip):
 **/
void
fu_struct_efi_vss2_variable_store_header_set_size(FuStructEfiVss2VariableStoreHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss2_variable_store_header_set_format: (skip):
 **/
static void
fu_struct_efi_vss2_variable_store_header_set_format(FuStructEfiVss2VariableStoreHeader *st, FuEfiVariableStoreFormat value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[20] = value;
}
/**
 * fu_struct_efi_vss2_variable_store_header_set_state: (skip):
 **/
static void
fu_struct_efi_vss2_variable_store_header_set_state(FuStructEfiVss2VariableStoreHeader *st, FuEfiVariableStoreState value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[21] = value;
}
/**
 * fu_struct_efi_vss2_variable_store_header_new: (skip):
 **/
FuStructEfiVss2VariableStoreHeader *
fu_struct_efi_vss2_variable_store_header_new(void)
{
    FuStructEfiVss2VariableStoreHeader *st = fu_struct_efi_vss2_variable_store_header_new_internal();
    st->buf = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st->buf, 28, 0x0);
    fu_struct_efi_vss2_variable_store_header_set_signature(st, (fwupd_guid_t *) "\x78\x2c\xf3\xaa\x7b\x94\x9a\x43\xa1\x80\x2e\x14\x4e\xc3\x77\x92");
    fu_struct_efi_vss2_variable_store_header_set_format(st, FU_EFI_VARIABLE_STORE_FORMAT_FORMATTED);
    fu_struct_efi_vss2_variable_store_header_set_state(st, FU_EFI_VARIABLE_STORE_STATE_HEALTHY);
    return st;
}
/**
 * fu_struct_efi_vss2_variable_store_header_to_string: (skip):
 **/
static gchar *
fu_struct_efi_vss2_variable_store_header_to_string(const FuStructEfiVss2VariableStoreHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiVss2VariableStoreHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_vss2_variable_store_header_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_vss2_variable_store_header_validate_internal(FuStructEfiVss2VariableStoreHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (memcmp(fu_struct_efi_vss2_variable_store_header_get_signature(st), "\x78\x2c\xf3\xaa\x7b\x94\x9a\x43\xa1\x80\x2e\x14\x4e\xc3\x77\x92", 16) != 0) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructEfiVss2VariableStoreHeader.signature was not valid");
        return FALSE;
    }
    if (fu_struct_efi_vss2_variable_store_header_get_format(st) != FU_EFI_VARIABLE_STORE_FORMAT_FORMATTED) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEfiVss2VariableStoreHeader.format was not valid, "
                    "expected 'FuEfiVariableStoreFormat' and got '%s'",
                    fu_efi_variable_store_format_to_string(fu_struct_efi_vss2_variable_store_header_get_format(st)));
        return FALSE;
    }
    if (fu_struct_efi_vss2_variable_store_header_get_state(st) != FU_EFI_VARIABLE_STORE_STATE_HEALTHY) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEfiVss2VariableStoreHeader.state was not valid, "
                    "expected 'FuEfiVariableStoreState' and got '%s'",
                    fu_efi_variable_store_state_to_string(fu_struct_efi_vss2_variable_store_header_get_state(st)));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_efi_vss2_variable_store_header_validate_stream: (skip):
 **/
gboolean
fu_struct_efi_vss2_variable_store_header_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVss2VariableStoreHeader) st = fu_struct_efi_vss2_variable_store_header_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVss2VariableStoreHeader failed read of 0x%x: ", (guint) 28);
        return FALSE;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVss2VariableStoreHeader requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_efi_vss2_variable_store_header_validate_internal(st, error);
}
static gboolean
fu_struct_efi_vss2_variable_store_header_parse_internal(FuStructEfiVss2VariableStoreHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_vss2_variable_store_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_vss2_variable_store_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_vss2_variable_store_header_parse_stream: (skip):
 **/
FuStructEfiVss2VariableStoreHeader *
fu_struct_efi_vss2_variable_store_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVss2VariableStoreHeader) st = fu_struct_efi_vss2_variable_store_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVss2VariableStoreHeader failed read of 0x%x: ", (guint) 28);
        return NULL;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVss2VariableStoreHeader requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_vss2_variable_store_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_vss_auth_variable_header_ref: (skip):
 **/
FuStructEfiVssAuthVariableHeader *
fu_struct_efi_vss_auth_variable_header_ref(FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_vss_auth_variable_header_unref: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_unref(FuStructEfiVssAuthVariableHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiVssAuthVariableHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_vss_auth_variable_header_new_internal: (skip):
 **/
static FuStructEfiVssAuthVariableHeader *
fu_struct_efi_vss_auth_variable_header_new_internal(void)
{
    FuStructEfiVssAuthVariableHeader *st = g_new0(FuStructEfiVssAuthVariableHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_vss_auth_variable_header_get_start_id: (skip):
 **/
guint16
fu_struct_efi_vss_auth_variable_header_get_start_id(const FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_get_state: (skip):
 **/
FuEfiVariableState
fu_struct_efi_vss_auth_variable_header_get_state(const FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_efi_vss_auth_variable_header_get_attributes: (skip):
 **/
FuEfiVariableAttrs
fu_struct_efi_vss_auth_variable_header_get_attributes(const FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_get_monotonic_counter: (skip):
 **/
guint64
fu_struct_efi_vss_auth_variable_header_get_monotonic_counter(const FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_get_timestamp: (skip):
 **/
FuStructEfiTime *
fu_struct_efi_vss_auth_variable_header_get_timestamp(const FuStructEfiVssAuthVariableHeader *st)
{
    g_autoptr(FuStructEfiTime) st_tmp = fu_struct_efi_time_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_EFI_VSS_AUTH_VARIABLE_HEADER_OFFSET_TIMESTAMP, 16);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_efi_vss_auth_variable_header_get_pubkey_index: (skip):
 **/
guint32
fu_struct_efi_vss_auth_variable_header_get_pubkey_index(const FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_get_name_size: (skip):
 **/
guint32
fu_struct_efi_vss_auth_variable_header_get_name_size(const FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_get_data_size: (skip):
 **/
guint32
fu_struct_efi_vss_auth_variable_header_get_data_size(const FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_get_vendor_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_vss_auth_variable_header_get_vendor_guid(const FuStructEfiVssAuthVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 44);
}

/* setters */
/**
 * fu_struct_efi_vss_auth_variable_header_set_start_id: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_set_start_id(FuStructEfiVssAuthVariableHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_set_state: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_set_state(FuStructEfiVssAuthVariableHeader *st, FuEfiVariableState value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_efi_vss_auth_variable_header_set_attributes: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_set_attributes(FuStructEfiVssAuthVariableHeader *st, FuEfiVariableAttrs value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_set_monotonic_counter: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_set_monotonic_counter(FuStructEfiVssAuthVariableHeader *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_set_timestamp: (skip):
 **/
gboolean
fu_struct_efi_vss_auth_variable_header_set_timestamp(FuStructEfiVssAuthVariableHeader *st, const FuStructEfiTime *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_EFI_TIME_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructEfiTime' (0x%x bytes) does not fit in "
                    "FuStructEfiVssAuthVariableHeader.timestamp (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_EFI_TIME_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_EFI_VSS_AUTH_VARIABLE_HEADER_OFFSET_TIMESTAMP, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_efi_vss_auth_variable_header_set_pubkey_index: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_set_pubkey_index(FuStructEfiVssAuthVariableHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_set_name_size: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_set_name_size(FuStructEfiVssAuthVariableHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 36, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_set_data_size: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_set_data_size(FuStructEfiVssAuthVariableHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_vss_auth_variable_header_set_vendor_guid: (skip):
 **/
void
fu_struct_efi_vss_auth_variable_header_set_vendor_guid(FuStructEfiVssAuthVariableHeader *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 44, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_vss_auth_variable_header_new: (skip):
 **/
FuStructEfiVssAuthVariableHeader *
fu_struct_efi_vss_auth_variable_header_new(void)
{
    FuStructEfiVssAuthVariableHeader *st = fu_struct_efi_vss_auth_variable_header_new_internal();
    st->buf = g_byte_array_sized_new(60);
    fu_byte_array_set_size(st->buf, 60, 0x0);
    {
        g_autoptr(FuStructEfiTime) st_donor = fu_struct_efi_time_new();
        memcpy(st->buf->data + 0x10, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    fu_struct_efi_vss_auth_variable_header_set_start_id(st, 0x55AA);
    return st;
}
/**
 * fu_struct_efi_vss_auth_variable_header_to_string: (skip):
 **/
static gchar *
fu_struct_efi_vss_auth_variable_header_to_string(const FuStructEfiVssAuthVariableHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiVssAuthVariableHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  start_id: 0x%x\n",
                           (guint) fu_struct_efi_vss_auth_variable_header_get_start_id(st));
    {
        const gchar *tmp = fu_efi_variable_state_to_string(fu_struct_efi_vss_auth_variable_header_get_state(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  state: 0x%x [%s]\n", (guint) fu_struct_efi_vss_auth_variable_header_get_state(st), tmp);
        } else {
            g_string_append_printf(str, "  state: 0x%x\n", (guint) fu_struct_efi_vss_auth_variable_header_get_state(st));
        }
    }
    {
        g_autofree gchar *tmp = fu_efi_variable_attrs_to_string(fu_struct_efi_vss_auth_variable_header_get_attributes(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  attributes: 0x%x [%s]\n", (guint) fu_struct_efi_vss_auth_variable_header_get_attributes(st), tmp);
        } else {
            g_string_append_printf(str, "  attributes: 0x%x\n", (guint) fu_struct_efi_vss_auth_variable_header_get_attributes(st));
        }
    }
    g_string_append_printf(str, "  monotonic_counter: 0x%x\n",
                           (guint) fu_struct_efi_vss_auth_variable_header_get_monotonic_counter(st));
    {
        g_autoptr(FuStructEfiTime) st_tmp = fu_struct_efi_vss_auth_variable_header_get_timestamp(st);
        g_autofree gchar *tmp = fu_struct_efi_time_to_string(st_tmp);
        g_string_append_printf(str, "  timestamp: %s\n", tmp);
    }
    g_string_append_printf(str, "  pubkey_index: 0x%x\n",
                           (guint) fu_struct_efi_vss_auth_variable_header_get_pubkey_index(st));
    g_string_append_printf(str, "  name_size: 0x%x\n",
                           (guint) fu_struct_efi_vss_auth_variable_header_get_name_size(st));
    g_string_append_printf(str, "  data_size: 0x%x\n",
                           (guint) fu_struct_efi_vss_auth_variable_header_get_data_size(st));
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_vss_auth_variable_header_get_vendor_guid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  vendor_guid: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_vss_auth_variable_header_validate_internal(FuStructEfiVssAuthVariableHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x10,
            .len = 16,
        };
        FuStructEfiTime st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_efi_time_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_efi_vss_auth_variable_header_parse_internal(FuStructEfiVssAuthVariableHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_vss_auth_variable_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_vss_auth_variable_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_vss_auth_variable_header_parse_stream: (skip):
 **/
FuStructEfiVssAuthVariableHeader *
fu_struct_efi_vss_auth_variable_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiVssAuthVariableHeader) st = fu_struct_efi_vss_auth_variable_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 60, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiVssAuthVariableHeader failed read of 0x%x: ", (guint) 60);
        return NULL;
    }
    if (st->buf->len != 60) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiVssAuthVariableHeader requested 0x%x and got 0x%x",
                    (guint) 60,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_vss_auth_variable_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_ref: (skip):
 **/
FuStructEfiFaultTolerantWorkingBlockHeader64 *
fu_struct_efi_fault_tolerant_working_block_header64_ref(FuStructEfiFaultTolerantWorkingBlockHeader64 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_unref: (skip):
 **/
void
fu_struct_efi_fault_tolerant_working_block_header64_unref(FuStructEfiFaultTolerantWorkingBlockHeader64 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiFaultTolerantWorkingBlockHeader64 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_new_internal: (skip):
 **/
static FuStructEfiFaultTolerantWorkingBlockHeader64 *
fu_struct_efi_fault_tolerant_working_block_header64_new_internal(void)
{
    FuStructEfiFaultTolerantWorkingBlockHeader64 *st = g_new0(FuStructEfiFaultTolerantWorkingBlockHeader64, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_get_signature: (skip):
 **/
static const fwupd_guid_t *
fu_struct_efi_fault_tolerant_working_block_header64_get_signature(const FuStructEfiFaultTolerantWorkingBlockHeader64 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_get_crc: (skip):
 **/
guint32
fu_struct_efi_fault_tolerant_working_block_header64_get_crc(const FuStructEfiFaultTolerantWorkingBlockHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_get_state: (skip):
 **/
FuEfiVariableStoreState
fu_struct_efi_fault_tolerant_working_block_header64_get_state(const FuStructEfiFaultTolerantWorkingBlockHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[20];
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_get_write_queue_size: (skip):
 **/
guint64
fu_struct_efi_fault_tolerant_working_block_header64_get_write_queue_size(const FuStructEfiFaultTolerantWorkingBlockHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_set_signature: (skip):
 **/
static void
fu_struct_efi_fault_tolerant_working_block_header64_set_signature(FuStructEfiFaultTolerantWorkingBlockHeader64 *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_set_crc: (skip):
 **/
void
fu_struct_efi_fault_tolerant_working_block_header64_set_crc(FuStructEfiFaultTolerantWorkingBlockHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_set_state: (skip):
 **/
void
fu_struct_efi_fault_tolerant_working_block_header64_set_state(FuStructEfiFaultTolerantWorkingBlockHeader64 *st, FuEfiVariableStoreState value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[20] = value;
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_set_write_queue_size: (skip):
 **/
void
fu_struct_efi_fault_tolerant_working_block_header64_set_write_queue_size(FuStructEfiFaultTolerantWorkingBlockHeader64 *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_new: (skip):
 **/
FuStructEfiFaultTolerantWorkingBlockHeader64 *
fu_struct_efi_fault_tolerant_working_block_header64_new(void)
{
    FuStructEfiFaultTolerantWorkingBlockHeader64 *st = fu_struct_efi_fault_tolerant_working_block_header64_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    fu_struct_efi_fault_tolerant_working_block_header64_set_signature(st, (fwupd_guid_t *) "\x2b\x29\x58\x9e\x68\x7c\x7d\x49\xa0\xce\x65\x0\xfd\x9f\x1b\x95");
    fu_struct_efi_fault_tolerant_working_block_header64_set_crc(st, 0xFFFFFFFF);
    fu_struct_efi_fault_tolerant_working_block_header64_set_state(st, FU_EFI_VARIABLE_STORE_STATE_EMPTY);
    memcpy(st->buf->data + 0x15, "\xFF\xFF\xFF", 3); /* nocheck:blocked */
    return st;
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_to_string: (skip):
 **/
static gchar *
fu_struct_efi_fault_tolerant_working_block_header64_to_string(const FuStructEfiFaultTolerantWorkingBlockHeader64 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiFaultTolerantWorkingBlockHeader64:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  crc: 0x%x\n",
                           (guint) fu_struct_efi_fault_tolerant_working_block_header64_get_crc(st));
    {
        const gchar *tmp = fu_efi_variable_store_state_to_string(fu_struct_efi_fault_tolerant_working_block_header64_get_state(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  state: 0x%x [%s]\n", (guint) fu_struct_efi_fault_tolerant_working_block_header64_get_state(st), tmp);
        } else {
            g_string_append_printf(str, "  state: 0x%x\n", (guint) fu_struct_efi_fault_tolerant_working_block_header64_get_state(st));
        }
    }
    g_string_append_printf(str, "  write_queue_size: 0x%x\n",
                           (guint) fu_struct_efi_fault_tolerant_working_block_header64_get_write_queue_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_fault_tolerant_working_block_header64_validate_internal(FuStructEfiFaultTolerantWorkingBlockHeader64 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (memcmp(fu_struct_efi_fault_tolerant_working_block_header64_get_signature(st), "\x2b\x29\x58\x9e\x68\x7c\x7d\x49\xa0\xce\x65\x0\xfd\x9f\x1b\x95", 16) != 0) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructEfiFaultTolerantWorkingBlockHeader64.signature was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_validate_stream: (skip):
 **/
gboolean
fu_struct_efi_fault_tolerant_working_block_header64_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiFaultTolerantWorkingBlockHeader64) st = fu_struct_efi_fault_tolerant_working_block_header64_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiFaultTolerantWorkingBlockHeader64 failed read of 0x%x: ", (guint) 32);
        return FALSE;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiFaultTolerantWorkingBlockHeader64 requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_efi_fault_tolerant_working_block_header64_validate_internal(st, error);
}
static gboolean
fu_struct_efi_fault_tolerant_working_block_header64_parse_internal(FuStructEfiFaultTolerantWorkingBlockHeader64 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_fault_tolerant_working_block_header64_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_fault_tolerant_working_block_header64_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efi_fault_tolerant_working_block_header64_parse_stream: (skip):
 **/
FuStructEfiFaultTolerantWorkingBlockHeader64 *
fu_struct_efi_fault_tolerant_working_block_header64_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiFaultTolerantWorkingBlockHeader64) st = fu_struct_efi_fault_tolerant_working_block_header64_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiFaultTolerantWorkingBlockHeader64 failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiFaultTolerantWorkingBlockHeader64 requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_fault_tolerant_working_block_header64_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_shim_hive_ref: (skip):
 **/
FuStructShimHive *
fu_struct_shim_hive_ref(FuStructShimHive *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_shim_hive_unref: (skip):
 **/
void
fu_struct_shim_hive_unref(FuStructShimHive *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructShimHive refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_shim_hive_new_internal: (skip):
 **/
static FuStructShimHive *
fu_struct_shim_hive_new_internal(void)
{
    FuStructShimHive *st = g_new0(FuStructShimHive, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_shim_hive_get_magic: (skip):
 **/
static gchar *
fu_struct_shim_hive_get_magic(const FuStructShimHive *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_shim_hive_get_header_version: (skip):
 **/
guint8
fu_struct_shim_hive_get_header_version(const FuStructShimHive *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_shim_hive_get_items_count: (skip):
 **/
guint8
fu_struct_shim_hive_get_items_count(const FuStructShimHive *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_shim_hive_get_items_offset: (skip):
 **/
guint8
fu_struct_shim_hive_get_items_offset(const FuStructShimHive *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_shim_hive_get_crc32: (skip):
 **/
guint32
fu_struct_shim_hive_get_crc32(const FuStructShimHive *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 7, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_shim_hive_set_magic: (skip):
 **/
static gboolean
fu_struct_shim_hive_set_magic(FuStructShimHive *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructShimHive.magic (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_shim_hive_set_header_version: (skip):
 **/
void
fu_struct_shim_hive_set_header_version(FuStructShimHive *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_shim_hive_set_items_count: (skip):
 **/
void
fu_struct_shim_hive_set_items_count(FuStructShimHive *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_shim_hive_set_items_offset: (skip):
 **/
void
fu_struct_shim_hive_set_items_offset(FuStructShimHive *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_shim_hive_set_crc32: (skip):
 **/
void
fu_struct_shim_hive_set_crc32(FuStructShimHive *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 7, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_shim_hive_new: (skip):
 **/
FuStructShimHive *
fu_struct_shim_hive_new(void)
{
    FuStructShimHive *st = fu_struct_shim_hive_new_internal();
    st->buf = g_byte_array_sized_new(11);
    fu_byte_array_set_size(st->buf, 11, 0x0);
    fu_struct_shim_hive_set_magic(st, "HIVE", NULL);
    fu_struct_shim_hive_set_header_version(st, 0x1);
    return st;
}
/**
 * fu_struct_shim_hive_to_string: (skip):
 **/
static gchar *
fu_struct_shim_hive_to_string(const FuStructShimHive *st)
{
    g_autoptr(GString) str = g_string_new("FuStructShimHive:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  header_version: 0x%x\n",
                           (guint) fu_struct_shim_hive_get_header_version(st));
    g_string_append_printf(str, "  items_count: 0x%x\n",
                           (guint) fu_struct_shim_hive_get_items_count(st));
    g_string_append_printf(str, "  items_offset: 0x%x\n",
                           (guint) fu_struct_shim_hive_get_items_offset(st));
    g_string_append_printf(str, "  crc32: 0x%x\n",
                           (guint) fu_struct_shim_hive_get_crc32(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_shim_hive_validate_internal(FuStructShimHive *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "HIVE", 4) != 0) {
        g_autofree gchar *str = fu_struct_shim_hive_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructShimHive.magic was not valid, "
                    "expected 'HIVE' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_shim_hive_parse_internal(FuStructShimHive *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_shim_hive_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_shim_hive_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_shim_hive_parse_stream: (skip):
 **/
FuStructShimHive *
fu_struct_shim_hive_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructShimHive) st = fu_struct_shim_hive_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 11, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructShimHive failed read of 0x%x: ", (guint) 11);
        return NULL;
    }
    if (st->buf->len != 11) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructShimHive requested 0x%x and got 0x%x",
                    (guint) 11,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_shim_hive_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_shim_hive_item_ref: (skip):
 **/
FuStructShimHiveItem *
fu_struct_shim_hive_item_ref(FuStructShimHiveItem *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_shim_hive_item_unref: (skip):
 **/
void
fu_struct_shim_hive_item_unref(FuStructShimHiveItem *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructShimHiveItem refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_shim_hive_item_new_internal: (skip):
 **/
static FuStructShimHiveItem *
fu_struct_shim_hive_item_new_internal(void)
{
    FuStructShimHiveItem *st = g_new0(FuStructShimHiveItem, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_shim_hive_item_get_key_length: (skip):
 **/
guint8
fu_struct_shim_hive_item_get_key_length(const FuStructShimHiveItem *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_shim_hive_item_get_value_length: (skip):
 **/
guint32
fu_struct_shim_hive_item_get_value_length(const FuStructShimHiveItem *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 1, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_shim_hive_item_set_key_length: (skip):
 **/
void
fu_struct_shim_hive_item_set_key_length(FuStructShimHiveItem *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_shim_hive_item_set_value_length: (skip):
 **/
void
fu_struct_shim_hive_item_set_value_length(FuStructShimHiveItem *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_shim_hive_item_new: (skip):
 **/
FuStructShimHiveItem *
fu_struct_shim_hive_item_new(void)
{
    FuStructShimHiveItem *st = fu_struct_shim_hive_item_new_internal();
    st->buf = g_byte_array_sized_new(5);
    fu_byte_array_set_size(st->buf, 5, 0x0);
    return st;
}
/**
 * fu_struct_shim_hive_item_to_string: (skip):
 **/
static gchar *
fu_struct_shim_hive_item_to_string(const FuStructShimHiveItem *st)
{
    g_autoptr(GString) str = g_string_new("FuStructShimHiveItem:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  key_length: 0x%x\n",
                           (guint) fu_struct_shim_hive_item_get_key_length(st));
    g_string_append_printf(str, "  value_length: 0x%x\n",
                           (guint) fu_struct_shim_hive_item_get_value_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_shim_hive_item_validate_internal(FuStructShimHiveItem *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_shim_hive_item_parse_internal(FuStructShimHiveItem *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_shim_hive_item_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_shim_hive_item_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_shim_hive_item_parse_stream: (skip):
 **/
FuStructShimHiveItem *
fu_struct_shim_hive_item_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructShimHiveItem) st = fu_struct_shim_hive_item_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 5, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructShimHiveItem failed read of 0x%x: ", (guint) 5);
        return NULL;
    }
    if (st->buf->len != 5) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructShimHiveItem requested 0x%x and got 0x%x",
                    (guint) 5,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_shim_hive_item_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
