/* math-function.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-function.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MATH_FUNCTION_0_PROPERTY,
	MATH_FUNCTION_NAME_PROPERTY,
	MATH_FUNCTION_ARGUMENTS_PROPERTY,
	MATH_FUNCTION_EXPRESSION_PROPERTY,
	MATH_FUNCTION_DESCRIPTION_PROPERTY,
	MATH_FUNCTION_NUM_PROPERTIES
};
static GParamSpec* math_function_properties[MATH_FUNCTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_FUNCTION_PARSER (function_parser_get_type ())
#define FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_PARSER, FunctionParser))
#define FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_PARSER, FunctionParserClass))
#define IS_FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_PARSER))
#define IS_FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_PARSER))
#define FUNCTION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_PARSER, FunctionParserClass))

typedef struct _FunctionParser FunctionParser;
typedef struct _FunctionParserClass FunctionParserClass;
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FunctionParserPrivate FunctionParserPrivate;
enum  {
	BUILT_IN_MATH_FUNCTION_0_PROPERTY,
	BUILT_IN_MATH_FUNCTION_NUM_PROPERTIES
};
static GParamSpec* built_in_math_function_properties[BUILT_IN_MATH_FUNCTION_NUM_PROPERTIES];

struct _MathFunctionPrivate {
	gchar* _name;
	gchar** _arguments;
	gint _arguments_length1;
	gint __arguments_size_;
	gchar* _expression;
	gchar* _description;
};

struct _ExpressionParserPrivate {
	Parser* _root_parser;
};

struct _FunctionParser {
	ExpressionParser parent_instance;
	FunctionParserPrivate * priv;
};

struct _FunctionParserClass {
	ExpressionParserClass parent_class;
};

struct _FunctionParserPrivate {
	Number** _parameters;
	gint _parameters_length1;
	gint __parameters_size_;
	MathFunction* _function;
};

static gint MathFunction_private_offset;
static gpointer math_function_parent_class = NULL;
static gint ExpressionParser_private_offset;
static gpointer expression_parser_parent_class = NULL;
static gint FunctionParser_private_offset;
static gpointer function_parser_parent_class = NULL;
static gpointer built_in_math_function_parent_class = NULL;

static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static Number* math_function_real_evaluate (MathFunction* self,
                                     Number** args,
                                     gint args_length1,
                                     Parser* root_parser);
VALA_EXTERN GType function_parser_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FunctionParser* function_parser_new (MathFunction* function,
                                     Parser* root_parser,
                                     Number** parameters,
                                     gint parameters_length1);
VALA_EXTERN FunctionParser* function_parser_construct (GType object_type,
                                           MathFunction* function,
                                           Parser* root_parser,
                                           Number** parameters,
                                           gint parameters_length1);
static gboolean math_function_is_name_valid (MathFunction* self,
                                      const gchar* x);
static gboolean math_function_real_is_custom_function (MathFunction* self);
static void math_function_finalize (GObject * obj);
static GType math_function_get_type_once (void);
static void _vala_math_function_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static gboolean expression_parser_real_variable_is_defined (Parser* base,
                                                     const gchar* name);
static Number* expression_parser_real_get_variable (Parser* base,
                                             const gchar* name);
static gboolean expression_parser_real_function_is_defined (Parser* base,
                                                     const gchar* name);
static gboolean expression_parser_real_unit_is_defined (Parser* base,
                                                 const gchar* name);
static gboolean expression_parser_real_currency_is_defined (Parser* base,
                                                     const gchar* name);
static gboolean expression_parser_real_currency_has_rate (Parser* base,
                                                   const gchar* name);
static Number* expression_parser_real_convert (Parser* base,
                                        Number* x,
                                        const gchar* x_units,
                                        const gchar* z_units,
                                        Unit** x_unit,
                                        Unit** z_unit);
static gboolean expression_parser_real_literal_base_is_defined (Parser* base,
                                                         const gchar* name);
static void expression_parser_finalize (Parser * obj);
static GType expression_parser_get_type_once (void);
static Number** _vala_array_dup8 (Number** self,
                           gssize length);
static gboolean function_parser_real_variable_is_defined (Parser* base,
                                                   const gchar* name);
static gchar** _vala_array_dup9 (gchar** self,
                          gssize length);
static Number* function_parser_real_get_variable (Parser* base,
                                           const gchar* name);
static gchar** _vala_array_dup10 (gchar** self,
                           gssize length);
static void function_parser_finalize (Parser * obj);
static GType function_parser_get_type_once (void);
static Number* built_in_math_function_real_evaluate (MathFunction* base,
                                              Number** args,
                                              gint args_length1,
                                              Parser* root_parser);
VALA_EXTERN Number* evaluate_built_in_function (const gchar* name,
                                    Number** args,
                                    gint args_length1,
                                    Parser* root_parser);
static gboolean built_in_math_function_real_is_custom_function (MathFunction* base);
static GType built_in_math_function_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
math_function_get_instance_private (MathFunction* self)
{
	return G_STRUCT_MEMBER_P (self, MathFunction_private_offset);
}

gint
math_function_name_compare_func (MathFunction* function1,
                                 MathFunction* function2)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (function1 != NULL, 0);
	g_return_val_if_fail (function2 != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = math_function_get_name (function1);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_function_get_name (function2);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

gboolean
math_function_name_equal_func (MathFunction* function1,
                               MathFunction* function2)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (function1 != NULL, FALSE);
	g_return_val_if_fail (function2 != NULL, FALSE);
	_tmp0_ = math_function_get_name (function1);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_function_get_name (function2);
	_tmp3_ = _tmp2_;
	result = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	return result;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

MathFunction*
math_function_construct (GType object_type,
                         const gchar* function_name,
                         gchar** arguments,
                         gint arguments_length1,
                         const gchar* expression,
                         const gchar* description)
{
	MathFunction * self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (function_name != NULL, NULL);
	self = (MathFunction*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (function_name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	_tmp1_ = (arguments != NULL) ? _vala_array_dup7 (arguments, arguments_length1) : arguments;
	_tmp1__length1 = arguments_length1;
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_arguments = _tmp1_;
	self->priv->_arguments_length1 = _tmp1__length1;
	self->priv->__arguments_size_ = self->priv->_arguments_length1;
	if (expression != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (expression);
		_g_free0 (self->priv->_expression);
		self->priv->_expression = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (self->priv->_expression);
		self->priv->_expression = _tmp3_;
	}
	if (description != NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (description);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp5_;
	}
	return self;
}

MathFunction*
math_function_new (const gchar* function_name,
                   gchar** arguments,
                   gint arguments_length1,
                   const gchar* expression,
                   const gchar* description)
{
	return math_function_construct (TYPE_MATH_FUNCTION, function_name, arguments, arguments_length1, expression, description);
}

static Number*
math_function_real_evaluate (MathFunction* self,
                             Number** args,
                             gint args_length1,
                             Parser* root_parser)
{
	FunctionParser* parser = NULL;
	FunctionParser* _tmp0_;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	Number* ans = NULL;
	FunctionParser* _tmp1_;
	guint _tmp2_ = 0U;
	ErrorCode _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	Number* _tmp7_;
	const gchar* _tmp8_;
	Number* result;
	_tmp0_ = function_parser_new (self, root_parser, args, args_length1);
	parser = _tmp0_;
	_tmp1_ = parser;
	_tmp7_ = parser_parse ((Parser*) _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	representation_base = _tmp2_;
	error_code = _tmp3_;
	_g_free0 (error_token);
	error_token = _tmp4_;
	error_start = _tmp5_;
	error_end = _tmp6_;
	ans = _tmp7_;
	if (error_code == ERROR_CODE_NONE) {
		result = ans;
		_g_free0 (error_token);
		_parser_unref0 (parser);
		return result;
	}
	_tmp8_ = error_token;
	parser_set_error (root_parser, error_code, _tmp8_, error_start, error_end);
	result = NULL;
	_g_object_unref0 (ans);
	_g_free0 (error_token);
	_parser_unref0 (parser);
	return result;
}

Number*
math_function_evaluate (MathFunction* self,
                        Number** args,
                        gint args_length1,
                        Parser* root_parser)
{
	MathFunctionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MATH_FUNCTION_GET_CLASS (self);
	if (_klass_->evaluate) {
		return _klass_->evaluate (self, args, args_length1, root_parser);
	}
	return NULL;
}

gboolean
math_function_validate (MathFunction* self,
                        Parser* root_parser)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	Number** args = NULL;
	Number** _tmp7_;
	gint args_length1;
	gint _args_size_;
	FunctionParser* parser = NULL;
	Number** _tmp8_;
	gint _tmp8__length1;
	FunctionParser* _tmp9_;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	FunctionParser* _tmp10_;
	guint _tmp11_ = 0U;
	ErrorCode _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	const gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_function_get_name (self);
	_tmp1_ = _tmp0_;
	if (!math_function_is_name_valid (self, _tmp1_)) {
		parser_set_error (root_parser, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
		result = FALSE;
		return result;
	}
	_tmp2_ = math_function_get_arguments (self, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	{
		gchar** argument_collection = NULL;
		gint argument_collection_length1 = 0;
		gint _argument_collection_size_ = 0;
		gint argument_it = 0;
		argument_collection = _tmp4_;
		argument_collection_length1 = _tmp4__length1;
		for (argument_it = 0; argument_it < argument_collection_length1; argument_it = argument_it + 1) {
			gchar* _tmp5_;
			gchar* argument = NULL;
			_tmp5_ = g_strdup (argument_collection[argument_it]);
			argument = _tmp5_;
			{
				const gchar* _tmp6_;
				_tmp6_ = argument;
				if (!math_function_is_name_valid (self, _tmp6_)) {
					parser_set_error (root_parser, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
					result = FALSE;
					_g_free0 (argument);
					return result;
				}
				_g_free0 (argument);
			}
		}
	}
	_tmp7_ = g_new0 (Number*, 0 + 1);
	args = _tmp7_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp8_ = args;
	_tmp8__length1 = args_length1;
	_tmp9_ = function_parser_new (self, root_parser, _tmp8_, _tmp8__length1);
	parser = _tmp9_;
	_tmp10_ = parser;
	parser_create_parse_tree ((Parser*) _tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
	representation_base = _tmp11_;
	error_code = _tmp12_;
	_g_free0 (error_token);
	error_token = _tmp13_;
	error_start = _tmp14_;
	error_end = _tmp15_;
	if (error_code == ERROR_CODE_NONE) {
		result = TRUE;
		_g_free0 (error_token);
		_parser_unref0 (parser);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	_tmp16_ = error_token;
	parser_set_error (root_parser, error_code, _tmp16_, error_start, error_end);
	result = FALSE;
	_g_free0 (error_token);
	_parser_unref0 (parser);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
math_function_is_name_valid (MathFunction* self,
                             const gchar* x)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (x != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gunichar current_char = 0U;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = strlen (x);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				current_char = string_get_char (x, (glong) i);
				if (!g_unichar_isalpha (current_char)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
math_function_real_is_custom_function (MathFunction* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
math_function_is_custom_function (MathFunction* self)
{
	MathFunctionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = MATH_FUNCTION_GET_CLASS (self);
	if (_klass_->is_custom_function) {
		return _klass_->is_custom_function (self);
	}
	return FALSE;
}

const gchar*
math_function_get_name (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

gchar**
math_function_get_arguments (MathFunction* self,
                             gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_arguments;
	_tmp0__length1 = self->priv->_arguments_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

const gchar*
math_function_get_expression (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}

const gchar*
math_function_get_description (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
math_function_class_init (MathFunctionClass * klass,
                          gpointer klass_data)
{
	math_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathFunction_private_offset);
	((MathFunctionClass *) klass)->evaluate = (Number* (*) (MathFunction*, Number**, gint, Parser*)) math_function_real_evaluate;
	((MathFunctionClass *) klass)->is_custom_function = (gboolean (*) (MathFunction*)) math_function_real_is_custom_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_function_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_function_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_NAME_PROPERTY, math_function_properties[MATH_FUNCTION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_ARGUMENTS_PROPERTY, math_function_properties[MATH_FUNCTION_ARGUMENTS_PROPERTY] = g_param_spec_boxed ("arguments", "arguments", "arguments", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_EXPRESSION_PROPERTY, math_function_properties[MATH_FUNCTION_EXPRESSION_PROPERTY] = g_param_spec_string ("expression", "expression", "expression", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_DESCRIPTION_PROPERTY, math_function_properties[MATH_FUNCTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
math_function_instance_init (MathFunction * self,
                             gpointer klass)
{
	self->priv = math_function_get_instance_private (self);
}

static void
math_function_finalize (GObject * obj)
{
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_FUNCTION, MathFunction);
	_g_free0 (self->priv->_name);
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_expression);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (math_function_parent_class)->finalize (obj);
}

static GType
math_function_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathFunction), 0, (GInstanceInitFunc) math_function_instance_init, NULL };
	GType math_function_type_id;
	math_function_type_id = g_type_register_static (G_TYPE_OBJECT, "MathFunction", &g_define_type_info, 0);
	MathFunction_private_offset = g_type_add_instance_private (math_function_type_id, sizeof (MathFunctionPrivate));
	return math_function_type_id;
}

GType
math_function_get_type (void)
{
	static volatile gsize math_function_type_id__once = 0;
	if (g_once_init_enter (&math_function_type_id__once)) {
		GType math_function_type_id;
		math_function_type_id = math_function_get_type_once ();
		g_once_init_leave (&math_function_type_id__once, math_function_type_id);
	}
	return math_function_type_id__once;
}

static void
_vala_math_function_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_FUNCTION, MathFunction);
	switch (property_id) {
		case MATH_FUNCTION_NAME_PROPERTY:
		g_value_set_string (value, math_function_get_name (self));
		break;
		case MATH_FUNCTION_ARGUMENTS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, math_function_get_arguments (self, &length));
		}
		break;
		case MATH_FUNCTION_EXPRESSION_PROPERTY:
		g_value_set_string (value, math_function_get_expression (self));
		break;
		case MATH_FUNCTION_DESCRIPTION_PROPERTY:
		g_value_set_string (value, math_function_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
expression_parser_get_instance_private (ExpressionParser* self)
{
	return G_STRUCT_MEMBER_P (self, ExpressionParser_private_offset);
}

static gpointer
_parser_ref0 (gpointer self)
{
	return self ? parser_ref (self) : NULL;
}

ExpressionParser*
expression_parser_construct (GType object_type,
                             const gchar* expression,
                             Parser* root_parser)
{
	ExpressionParser* self = NULL;
	Parser* _tmp0_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ExpressionParser*) parser_construct (object_type, expression, root_parser->number_base, root_parser->wordlen, root_parser->angle_units);
	_tmp0_ = _parser_ref0 (root_parser);
	_parser_unref0 (self->priv->_root_parser);
	self->priv->_root_parser = _tmp0_;
	return self;
}

ExpressionParser*
expression_parser_new (const gchar* expression,
                       Parser* root_parser)
{
	return expression_parser_construct (TYPE_EXPRESSION_PARSER, expression, root_parser);
}

static gboolean
expression_parser_real_variable_is_defined (Parser* base,
                                            const gchar* name)
{
	ExpressionParser * self;
	Parser* _tmp0_;
	gboolean result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	if (PARSER_CLASS (expression_parser_parent_class)->variable_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_root_parser;
	result = parser_variable_is_defined (_tmp0_, name);
	return result;
}

static Number*
expression_parser_real_get_variable (Parser* base,
                                     const gchar* name)
{
	ExpressionParser * self;
	Number* value = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Parser* _tmp2_;
	Number* _tmp3_;
	Number* result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = PARSER_CLASS (expression_parser_parent_class)->get_variable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name);
	value = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		result = value;
		return result;
	}
	_tmp2_ = self->priv->_root_parser;
	_tmp3_ = parser_get_variable (_tmp2_, name);
	result = _tmp3_;
	_g_object_unref0 (value);
	return result;
}

static gboolean
expression_parser_real_function_is_defined (Parser* base,
                                            const gchar* name)
{
	ExpressionParser * self;
	Parser* _tmp0_;
	gboolean result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	if (PARSER_CLASS (expression_parser_parent_class)->function_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_root_parser;
	result = parser_function_is_defined (_tmp0_, name);
	return result;
}

static gboolean
expression_parser_real_unit_is_defined (Parser* base,
                                        const gchar* name)
{
	ExpressionParser * self;
	Parser* _tmp0_;
	gboolean result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_root_parser;
	result = parser_unit_is_defined (_tmp0_, name);
	return result;
}

static gboolean
expression_parser_real_currency_is_defined (Parser* base,
                                            const gchar* name)
{
	ExpressionParser * self;
	Parser* _tmp0_;
	gboolean result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_root_parser;
	result = parser_currency_is_defined (_tmp0_, name);
	return result;
}

static gboolean
expression_parser_real_currency_has_rate (Parser* base,
                                          const gchar* name)
{
	ExpressionParser * self;
	Parser* _tmp0_;
	gboolean result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_root_parser;
	result = parser_currency_has_rate (_tmp0_, name);
	return result;
}

static Number*
expression_parser_real_convert (Parser* base,
                                Number* x,
                                const gchar* x_units,
                                const gchar* z_units,
                                Unit** x_unit,
                                Unit** z_unit)
{
	ExpressionParser * self;
	Unit* _vala_x_unit = NULL;
	Unit* _vala_z_unit = NULL;
	Parser* _tmp0_;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	Number* _tmp3_;
	Number* result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = self->priv->_root_parser;
	_tmp3_ = parser_convert (_tmp0_, x, x_units, z_units, &_tmp1_, &_tmp2_);
	_g_object_unref0 (_vala_x_unit);
	_vala_x_unit = _tmp1_;
	_g_object_unref0 (_vala_z_unit);
	_vala_z_unit = _tmp2_;
	result = _tmp3_;
	if (x_unit) {
		*x_unit = _vala_x_unit;
	} else {
		_g_object_unref0 (_vala_x_unit);
	}
	if (z_unit) {
		*z_unit = _vala_z_unit;
	} else {
		_g_object_unref0 (_vala_z_unit);
	}
	return result;
}

static gboolean
expression_parser_real_literal_base_is_defined (Parser* base,
                                                const gchar* name)
{
	ExpressionParser * self;
	Parser* _tmp0_;
	gboolean result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_root_parser;
	result = parser_literal_base_is_defined (_tmp0_, name);
	return result;
}

static void
expression_parser_class_init (ExpressionParserClass * klass,
                              gpointer klass_data)
{
	expression_parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = expression_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ExpressionParser_private_offset);
	((ParserClass *) klass)->variable_is_defined = (gboolean (*) (Parser*, const gchar*)) expression_parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = (Number* (*) (Parser*, const gchar*)) expression_parser_real_get_variable;
	((ParserClass *) klass)->function_is_defined = (gboolean (*) (Parser*, const gchar*)) expression_parser_real_function_is_defined;
	((ParserClass *) klass)->unit_is_defined = (gboolean (*) (Parser*, const gchar*)) expression_parser_real_unit_is_defined;
	((ParserClass *) klass)->currency_is_defined = (gboolean (*) (Parser*, const gchar*)) expression_parser_real_currency_is_defined;
	((ParserClass *) klass)->currency_has_rate = (gboolean (*) (Parser*, const gchar*)) expression_parser_real_currency_has_rate;
	((ParserClass *) klass)->convert = (Number* (*) (Parser*, Number*, const gchar*, const gchar*, Unit**, Unit**)) expression_parser_real_convert;
	((ParserClass *) klass)->literal_base_is_defined = (gboolean (*) (Parser*, const gchar*)) expression_parser_real_literal_base_is_defined;
}

static void
expression_parser_instance_init (ExpressionParser * self,
                                 gpointer klass)
{
	self->priv = expression_parser_get_instance_private (self);
}

static void
expression_parser_finalize (Parser * obj)
{
	ExpressionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPRESSION_PARSER, ExpressionParser);
	_parser_unref0 (self->priv->_root_parser);
	PARSER_CLASS (expression_parser_parent_class)->finalize (obj);
}

static GType
expression_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExpressionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expression_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpressionParser), 0, (GInstanceInitFunc) expression_parser_instance_init, NULL };
	GType expression_parser_type_id;
	expression_parser_type_id = g_type_register_static (TYPE_PARSER, "ExpressionParser", &g_define_type_info, 0);
	ExpressionParser_private_offset = g_type_add_instance_private (expression_parser_type_id, sizeof (ExpressionParserPrivate));
	return expression_parser_type_id;
}

GType
expression_parser_get_type (void)
{
	static volatile gsize expression_parser_type_id__once = 0;
	if (g_once_init_enter (&expression_parser_type_id__once)) {
		GType expression_parser_type_id;
		expression_parser_type_id = expression_parser_get_type_once ();
		g_once_init_leave (&expression_parser_type_id__once, expression_parser_type_id);
	}
	return expression_parser_type_id__once;
}

static inline gpointer
function_parser_get_instance_private (FunctionParser* self)
{
	return G_STRUCT_MEMBER_P (self, FunctionParser_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Number**
_vala_array_dup8 (Number** self,
                  gssize length)
{
	if (length >= 0) {
		Number** result;
		gssize i;
		result = g_new0 (Number*, length + 1);
		for (i = 0; i < length; i++) {
			Number* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

FunctionParser*
function_parser_construct (GType object_type,
                           MathFunction* function,
                           Parser* root_parser,
                           Number** parameters,
                           gint parameters_length1)
{
	FunctionParser* self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	MathFunction* _tmp2_;
	Number** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (function != NULL, NULL);
	_tmp0_ = math_function_get_expression (function);
	_tmp1_ = _tmp0_;
	self = (FunctionParser*) expression_parser_construct (object_type, _tmp1_, root_parser);
	_tmp2_ = _g_object_ref0 (function);
	_g_object_unref0 (self->priv->_function);
	self->priv->_function = _tmp2_;
	_tmp3_ = (parameters != NULL) ? _vala_array_dup8 (parameters, parameters_length1) : parameters;
	_tmp3__length1 = parameters_length1;
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_parameters = _tmp3_;
	self->priv->_parameters_length1 = _tmp3__length1;
	self->priv->__parameters_size_ = self->priv->_parameters_length1;
	return self;
}

FunctionParser*
function_parser_new (MathFunction* function,
                     Parser* root_parser,
                     Number** parameters,
                     gint parameters_length1)
{
	return function_parser_construct (TYPE_FUNCTION_PARSER, function, root_parser, parameters, parameters_length1);
}

static gchar**
_vala_array_dup9 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
function_parser_real_variable_is_defined (Parser* base,
                                          const gchar* name)
{
	FunctionParser * self;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint argument_names_length1;
	gint _argument_names_size_;
	gboolean result;
	self = (FunctionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_function;
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup9 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	argument_names = _tmp4_;
	argument_names_length1 = _tmp4__length1;
	_argument_names_size_ = argument_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = argument_names;
				_tmp7__length1 = argument_names_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = argument_names;
				_tmp8__length1 = argument_names_length1;
				_tmp9_ = _tmp8_[i];
				if (g_strcmp0 (_tmp9_, name) == 0) {
					result = TRUE;
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	result = PARSER_CLASS (function_parser_parent_class)->variable_is_defined ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), name);
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar**
_vala_array_dup10 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Number*
function_parser_real_get_variable (Parser* base,
                                   const gchar* name)
{
	FunctionParser * self;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint argument_names_length1;
	gint _argument_names_size_;
	Number* _tmp14_;
	Number* result;
	self = (FunctionParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_function;
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup10 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	argument_names = _tmp4_;
	argument_names_length1 = _tmp4__length1;
	_argument_names_size_ = argument_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = argument_names;
				_tmp7__length1 = argument_names_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = argument_names;
				_tmp8__length1 = argument_names_length1;
				_tmp9_ = _tmp8_[i];
				if (g_strcmp0 (_tmp9_, name) == 0) {
					Number** _tmp10_;
					gint _tmp10__length1;
					_tmp10_ = self->priv->_parameters;
					_tmp10__length1 = self->priv->_parameters_length1;
					if (_tmp10__length1 > i) {
						Number** _tmp11_;
						gint _tmp11__length1;
						Number* _tmp12_;
						Number* _tmp13_;
						_tmp11_ = self->priv->_parameters;
						_tmp11__length1 = self->priv->_parameters_length1;
						_tmp12_ = _tmp11_[i];
						_tmp13_ = _g_object_ref0 (_tmp12_);
						result = _tmp13_;
						argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					result = NULL;
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp14_ = PARSER_CLASS (function_parser_parent_class)->get_variable ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), name);
	result = _tmp14_;
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
function_parser_class_init (FunctionParserClass * klass,
                            gpointer klass_data)
{
	function_parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = function_parser_finalize;
	g_type_class_adjust_private_offset (klass, &FunctionParser_private_offset);
	((ParserClass *) klass)->variable_is_defined = (gboolean (*) (Parser*, const gchar*)) function_parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = (Number* (*) (Parser*, const gchar*)) function_parser_real_get_variable;
}

static void
function_parser_instance_init (FunctionParser * self,
                               gpointer klass)
{
	self->priv = function_parser_get_instance_private (self);
}

static void
function_parser_finalize (Parser * obj)
{
	FunctionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUNCTION_PARSER, FunctionParser);
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_function);
	PARSER_CLASS (function_parser_parent_class)->finalize (obj);
}

static GType
function_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionParser), 0, (GInstanceInitFunc) function_parser_instance_init, NULL };
	GType function_parser_type_id;
	function_parser_type_id = g_type_register_static (TYPE_EXPRESSION_PARSER, "FunctionParser", &g_define_type_info, 0);
	FunctionParser_private_offset = g_type_add_instance_private (function_parser_type_id, sizeof (FunctionParserPrivate));
	return function_parser_type_id;
}

GType
function_parser_get_type (void)
{
	static volatile gsize function_parser_type_id__once = 0;
	if (g_once_init_enter (&function_parser_type_id__once)) {
		GType function_parser_type_id;
		function_parser_type_id = function_parser_get_type_once ();
		g_once_init_leave (&function_parser_type_id__once, function_parser_type_id);
	}
	return function_parser_type_id__once;
}

BuiltInMathFunction*
built_in_math_function_construct (GType object_type,
                                  const gchar* function_name,
                                  const gchar* description,
                                  gchar** arguments,
                                  gint arguments_length1)
{
	BuiltInMathFunction * self = NULL;
	gchar* expression = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (function_name != NULL, NULL);
	_tmp0_ = g_strdup ("");
	expression = _tmp0_;
	self = (BuiltInMathFunction*) math_function_construct (object_type, function_name, arguments, (gint) arguments_length1, expression, description);
	_g_free0 (expression);
	return self;
}

BuiltInMathFunction*
built_in_math_function_new (const gchar* function_name,
                            const gchar* description,
                            gchar** arguments,
                            gint arguments_length1)
{
	return built_in_math_function_construct (TYPE_BUILT_IN_MATH_FUNCTION, function_name, description, arguments, arguments_length1);
}

static Number*
built_in_math_function_real_evaluate (MathFunction* base,
                                      Number** args,
                                      gint args_length1,
                                      Parser* root_parser)
{
	BuiltInMathFunction * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	Number* _tmp2_;
	Number* result;
	self = (BuiltInMathFunction*) base;
	_tmp0_ = math_function_get_name ((MathFunction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = evaluate_built_in_function (_tmp1_, args, (gint) args_length1, root_parser);
	result = _tmp2_;
	return result;
}

static gboolean
built_in_math_function_real_is_custom_function (MathFunction* base)
{
	BuiltInMathFunction * self;
	gboolean result;
	self = (BuiltInMathFunction*) base;
	result = FALSE;
	return result;
}

static void
built_in_math_function_class_init (BuiltInMathFunctionClass * klass,
                                   gpointer klass_data)
{
	built_in_math_function_parent_class = g_type_class_peek_parent (klass);
	((MathFunctionClass *) klass)->evaluate = (Number* (*) (MathFunction*, Number**, gint, Parser*)) built_in_math_function_real_evaluate;
	((MathFunctionClass *) klass)->is_custom_function = (gboolean (*) (MathFunction*)) built_in_math_function_real_is_custom_function;
}

static void
built_in_math_function_instance_init (BuiltInMathFunction * self,
                                      gpointer klass)
{
}

static GType
built_in_math_function_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BuiltInMathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) built_in_math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuiltInMathFunction), 0, (GInstanceInitFunc) built_in_math_function_instance_init, NULL };
	GType built_in_math_function_type_id;
	built_in_math_function_type_id = g_type_register_static (TYPE_MATH_FUNCTION, "BuiltInMathFunction", &g_define_type_info, 0);
	return built_in_math_function_type_id;
}

GType
built_in_math_function_get_type (void)
{
	static volatile gsize built_in_math_function_type_id__once = 0;
	if (g_once_init_enter (&built_in_math_function_type_id__once)) {
		GType built_in_math_function_type_id;
		built_in_math_function_type_id = built_in_math_function_get_type_once ();
		g_once_init_leave (&built_in_math_function_type_id__once, built_in_math_function_type_id);
	}
	return built_in_math_function_type_id__once;
}

Number*
evaluate_built_in_function (const gchar* name,
                            Number** args,
                            gint args_length1,
                            Parser* root_parser)
{
	gchar* lower_name = NULL;
	gchar* _tmp0_;
	Number* x = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	static GQuark _tmp5_label6 = 0;
	static GQuark _tmp5_label7 = 0;
	static GQuark _tmp5_label8 = 0;
	static GQuark _tmp5_label9 = 0;
	static GQuark _tmp5_label10 = 0;
	static GQuark _tmp5_label11 = 0;
	static GQuark _tmp5_label12 = 0;
	static GQuark _tmp5_label13 = 0;
	static GQuark _tmp5_label14 = 0;
	static GQuark _tmp5_label15 = 0;
	static GQuark _tmp5_label16 = 0;
	static GQuark _tmp5_label17 = 0;
	static GQuark _tmp5_label18 = 0;
	static GQuark _tmp5_label19 = 0;
	static GQuark _tmp5_label20 = 0;
	static GQuark _tmp5_label21 = 0;
	static GQuark _tmp5_label22 = 0;
	static GQuark _tmp5_label23 = 0;
	static GQuark _tmp5_label24 = 0;
	static GQuark _tmp5_label25 = 0;
	static GQuark _tmp5_label26 = 0;
	static GQuark _tmp5_label27 = 0;
	static GQuark _tmp5_label28 = 0;
	static GQuark _tmp5_label29 = 0;
	static GQuark _tmp5_label30 = 0;
	static GQuark _tmp5_label31 = 0;
	static GQuark _tmp5_label32 = 0;
	static GQuark _tmp5_label33 = 0;
	static GQuark _tmp5_label34 = 0;
	static GQuark _tmp5_label35 = 0;
	static GQuark _tmp5_label36 = 0;
	static GQuark _tmp5_label37 = 0;
	static GQuark _tmp5_label38 = 0;
	static GQuark _tmp5_label39 = 0;
	static GQuark _tmp5_label40 = 0;
	static GQuark _tmp5_label41 = 0;
	static GQuark _tmp5_label42 = 0;
	static GQuark _tmp5_label43 = 0;
	static GQuark _tmp5_label44 = 0;
	static GQuark _tmp5_label45 = 0;
	static GQuark _tmp5_label46 = 0;
	static GQuark _tmp5_label47 = 0;
	static GQuark _tmp5_label48 = 0;
	static GQuark _tmp5_label49 = 0;
	static GQuark _tmp5_label50 = 0;
	static GQuark _tmp5_label51 = 0;
	Number* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	lower_name = _tmp0_;
	if (args_length1 == 0) {
		result = NULL;
		_g_free0 (lower_name);
		return result;
	}
	_tmp1_ = args[0];
	_tmp2_ = _g_object_ref0 (_tmp1_);
	x = _tmp2_;
	_tmp3_ = lower_name;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("sin")))) {
		switch (0) {
			default:
			{
				Number* _tmp7_;
				Number* _tmp8_;
				_tmp7_ = x;
				_tmp8_ = number_sin (_tmp7_, root_parser->angle_units);
				result = _tmp8_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("cos")))) {
		switch (0) {
			default:
			{
				Number* _tmp9_;
				Number* _tmp10_;
				_tmp9_ = x;
				_tmp10_ = number_cos (_tmp9_, root_parser->angle_units);
				result = _tmp10_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("tan")))) {
		switch (0) {
			default:
			{
				Number* _tmp11_;
				Number* _tmp12_;
				_tmp11_ = x;
				_tmp12_ = number_tan (_tmp11_, root_parser->angle_units);
				result = _tmp12_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if ((_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("sin⁻¹")))) || (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("asin"))))) {
		switch (0) {
			default:
			{
				Number* _tmp13_;
				Number* _tmp14_;
				_tmp13_ = x;
				_tmp14_ = number_asin (_tmp13_, root_parser->angle_units);
				result = _tmp14_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if ((_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("cos⁻¹")))) || (_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("acos"))))) {
		switch (0) {
			default:
			{
				Number* _tmp15_;
				Number* _tmp16_;
				_tmp15_ = x;
				_tmp16_ = number_acos (_tmp15_, root_parser->angle_units);
				result = _tmp16_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if ((_tmp6_ == ((0 != _tmp5_label7) ? _tmp5_label7 : (_tmp5_label7 = g_quark_from_static_string ("tan⁻¹")))) || (_tmp6_ == ((0 != _tmp5_label8) ? _tmp5_label8 : (_tmp5_label8 = g_quark_from_static_string ("atan"))))) {
		switch (0) {
			default:
			{
				Number* _tmp17_;
				Number* _tmp18_;
				_tmp17_ = x;
				_tmp18_ = number_atan (_tmp17_, root_parser->angle_units);
				result = _tmp18_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label9) ? _tmp5_label9 : (_tmp5_label9 = g_quark_from_static_string ("sinh")))) {
		switch (0) {
			default:
			{
				Number* _tmp19_;
				Number* _tmp20_;
				_tmp19_ = x;
				_tmp20_ = number_sinh (_tmp19_);
				result = _tmp20_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label10) ? _tmp5_label10 : (_tmp5_label10 = g_quark_from_static_string ("cosh")))) {
		switch (0) {
			default:
			{
				Number* _tmp21_;
				Number* _tmp22_;
				_tmp21_ = x;
				_tmp22_ = number_cosh (_tmp21_);
				result = _tmp22_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label11) ? _tmp5_label11 : (_tmp5_label11 = g_quark_from_static_string ("tanh")))) {
		switch (0) {
			default:
			{
				Number* _tmp23_;
				Number* _tmp24_;
				_tmp23_ = x;
				_tmp24_ = number_tanh (_tmp23_);
				result = _tmp24_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if ((_tmp6_ == ((0 != _tmp5_label12) ? _tmp5_label12 : (_tmp5_label12 = g_quark_from_static_string ("sinh⁻¹")))) || (_tmp6_ == ((0 != _tmp5_label13) ? _tmp5_label13 : (_tmp5_label13 = g_quark_from_static_string ("asinh"))))) {
		switch (0) {
			default:
			{
				Number* _tmp25_;
				Number* _tmp26_;
				_tmp25_ = x;
				_tmp26_ = number_asinh (_tmp25_);
				result = _tmp26_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if ((_tmp6_ == ((0 != _tmp5_label14) ? _tmp5_label14 : (_tmp5_label14 = g_quark_from_static_string ("cosh⁻¹")))) || (_tmp6_ == ((0 != _tmp5_label15) ? _tmp5_label15 : (_tmp5_label15 = g_quark_from_static_string ("acosh"))))) {
		switch (0) {
			default:
			{
				Number* _tmp27_;
				Number* _tmp28_;
				_tmp27_ = x;
				_tmp28_ = number_acosh (_tmp27_);
				result = _tmp28_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if ((_tmp6_ == ((0 != _tmp5_label16) ? _tmp5_label16 : (_tmp5_label16 = g_quark_from_static_string ("tanh⁻¹")))) || (_tmp6_ == ((0 != _tmp5_label17) ? _tmp5_label17 : (_tmp5_label17 = g_quark_from_static_string ("atanh"))))) {
		switch (0) {
			default:
			{
				Number* _tmp29_;
				Number* _tmp30_;
				_tmp29_ = x;
				_tmp30_ = number_atanh (_tmp29_);
				result = _tmp30_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label18) ? _tmp5_label18 : (_tmp5_label18 = g_quark_from_static_string ("conj")))) {
		switch (0) {
			default:
			{
				Number* _tmp31_;
				Number* _tmp32_;
				_tmp31_ = x;
				_tmp32_ = number_conjugate (_tmp31_);
				result = _tmp32_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label19) ? _tmp5_label19 : (_tmp5_label19 = g_quark_from_static_string ("arg")))) {
		switch (0) {
			default:
			{
				Number* _tmp33_;
				Number* _tmp34_;
				_tmp33_ = x;
				_tmp34_ = number_arg (_tmp33_, root_parser->angle_units);
				result = _tmp34_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label20) ? _tmp5_label20 : (_tmp5_label20 = g_quark_from_static_string ("re")))) {
		switch (0) {
			default:
			{
				Number* _tmp35_;
				Number* _tmp36_;
				_tmp35_ = x;
				_tmp36_ = number_real_component (_tmp35_);
				result = _tmp36_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label21) ? _tmp5_label21 : (_tmp5_label21 = g_quark_from_static_string ("im")))) {
		switch (0) {
			default:
			{
				Number* _tmp37_;
				Number* _tmp38_;
				_tmp37_ = x;
				_tmp38_ = number_imaginary_component (_tmp37_);
				result = _tmp38_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label22) ? _tmp5_label22 : (_tmp5_label22 = g_quark_from_static_string ("ones")))) {
		switch (0) {
			default:
			{
				Number* _tmp39_;
				Number* _tmp40_;
				_tmp39_ = x;
				_tmp40_ = number_ones_complement (_tmp39_, root_parser->wordlen);
				result = _tmp40_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label23) ? _tmp5_label23 : (_tmp5_label23 = g_quark_from_static_string ("twos")))) {
		switch (0) {
			default:
			{
				Number* _tmp41_;
				Number* _tmp42_;
				_tmp41_ = x;
				_tmp42_ = number_twos_complement (_tmp41_, root_parser->wordlen);
				result = _tmp42_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label24) ? _tmp5_label24 : (_tmp5_label24 = g_quark_from_static_string ("bswap")))) {
		switch (0) {
			default:
			{
				Number* _tmp43_;
				Number* _tmp44_;
				_tmp43_ = x;
				_tmp44_ = number_swap_endianness (_tmp43_, root_parser->wordlen);
				result = _tmp44_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label25) ? _tmp5_label25 : (_tmp5_label25 = g_quark_from_static_string ("mod")))) {
		switch (0) {
			default:
			{
				Number* _tmp45_;
				Number* _tmp46_;
				Number* _tmp47_;
				_tmp45_ = x;
				_tmp46_ = args[1];
				_tmp47_ = number_modulus_divide (_tmp45_, _tmp46_);
				result = _tmp47_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label26) ? _tmp5_label26 : (_tmp5_label26 = g_quark_from_static_string ("modexp")))) {
		switch (0) {
			default:
			{
				Number* _tmp48_;
				Number* _tmp49_;
				Number* _tmp50_;
				Number* _tmp51_;
				_tmp48_ = x;
				_tmp49_ = args[1];
				_tmp50_ = args[2];
				_tmp51_ = number_modular_exponentiation (_tmp48_, _tmp49_, _tmp50_);
				result = _tmp51_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label27) ? _tmp5_label27 : (_tmp5_label27 = g_quark_from_static_string ("round")))) {
		switch (0) {
			default:
			{
				Number* _tmp52_;
				Number* _tmp53_;
				_tmp52_ = x;
				_tmp53_ = number_round (_tmp52_);
				result = _tmp53_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label28) ? _tmp5_label28 : (_tmp5_label28 = g_quark_from_static_string ("floor")))) {
		switch (0) {
			default:
			{
				Number* _tmp54_;
				Number* _tmp55_;
				_tmp54_ = x;
				_tmp55_ = number_floor (_tmp54_);
				result = _tmp55_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label29) ? _tmp5_label29 : (_tmp5_label29 = g_quark_from_static_string ("ceil")))) {
		switch (0) {
			default:
			{
				Number* _tmp56_;
				Number* _tmp57_;
				_tmp56_ = x;
				_tmp57_ = number_ceiling (_tmp56_);
				result = _tmp57_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label30) ? _tmp5_label30 : (_tmp5_label30 = g_quark_from_static_string ("int")))) {
		switch (0) {
			default:
			{
				Number* _tmp58_;
				Number* _tmp59_;
				_tmp58_ = x;
				_tmp59_ = number_integer_component (_tmp58_);
				result = _tmp59_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label31) ? _tmp5_label31 : (_tmp5_label31 = g_quark_from_static_string ("frac")))) {
		switch (0) {
			default:
			{
				Number* _tmp60_;
				Number* _tmp61_;
				_tmp60_ = x;
				_tmp61_ = number_fractional_component (_tmp60_);
				result = _tmp61_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label32) ? _tmp5_label32 : (_tmp5_label32 = g_quark_from_static_string ("sum")))) {
		switch (0) {
			default:
			{
				Number* _tmp62_;
				_tmp62_ = number_sum (args, (gint) args_length1);
				result = _tmp62_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label33) ? _tmp5_label33 : (_tmp5_label33 = g_quark_from_static_string ("sumsq")))) {
		switch (0) {
			default:
			{
				Number* _tmp63_;
				_tmp63_ = number_sum_squares (args, (gint) args_length1);
				result = _tmp63_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label34) ? _tmp5_label34 : (_tmp5_label34 = g_quark_from_static_string ("average")))) {
		switch (0) {
			default:
			{
				Number* _tmp64_;
				Number* _tmp65_;
				Number* _tmp66_;
				Number* _tmp67_;
				_tmp64_ = number_sum (args, (gint) args_length1);
				_tmp65_ = _tmp64_;
				_tmp66_ = number_divide_integer (_tmp65_, (gint64) args_length1);
				_tmp67_ = _tmp66_;
				_g_object_unref0 (_tmp65_);
				result = _tmp67_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label35) ? _tmp5_label35 : (_tmp5_label35 = g_quark_from_static_string ("median")))) {
		switch (0) {
			default:
			{
				Number* _tmp68_;
				_tmp68_ = number_median (args, (gint) args_length1);
				result = _tmp68_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label36) ? _tmp5_label36 : (_tmp5_label36 = g_quark_from_static_string ("min")))) {
		switch (0) {
			default:
			{
				Number* _tmp69_;
				_tmp69_ = number_min (args, (gint) args_length1);
				result = _tmp69_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label37) ? _tmp5_label37 : (_tmp5_label37 = g_quark_from_static_string ("max")))) {
		switch (0) {
			default:
			{
				Number* _tmp70_;
				_tmp70_ = number_max (args, (gint) args_length1);
				result = _tmp70_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label38) ? _tmp5_label38 : (_tmp5_label38 = g_quark_from_static_string ("stdev")))) {
		switch (0) {
			default:
			{
				Number* _tmp71_;
				Number* _tmp72_;
				Number* _tmp73_;
				Number* _tmp74_;
				_tmp71_ = number_variance (args, (gint) args_length1, TRUE);
				_tmp72_ = _tmp71_;
				_tmp73_ = number_sqrt (_tmp72_);
				_tmp74_ = _tmp73_;
				_g_object_unref0 (_tmp72_);
				result = _tmp74_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label39) ? _tmp5_label39 : (_tmp5_label39 = g_quark_from_static_string ("stdevp")))) {
		switch (0) {
			default:
			{
				Number* _tmp75_;
				Number* _tmp76_;
				Number* _tmp77_;
				Number* _tmp78_;
				_tmp75_ = number_variance (args, (gint) args_length1, FALSE);
				_tmp76_ = _tmp75_;
				_tmp77_ = number_sqrt (_tmp76_);
				_tmp78_ = _tmp77_;
				_g_object_unref0 (_tmp76_);
				result = _tmp78_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label40) ? _tmp5_label40 : (_tmp5_label40 = g_quark_from_static_string ("var")))) {
		switch (0) {
			default:
			{
				Number* _tmp79_;
				_tmp79_ = number_variance (args, (gint) args_length1, TRUE);
				result = _tmp79_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label41) ? _tmp5_label41 : (_tmp5_label41 = g_quark_from_static_string ("varp")))) {
		switch (0) {
			default:
			{
				Number* _tmp80_;
				_tmp80_ = number_variance (args, (gint) args_length1, FALSE);
				result = _tmp80_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label42) ? _tmp5_label42 : (_tmp5_label42 = g_quark_from_static_string ("log")))) {
		switch (0) {
			default:
			{
				Number* _tmp81_ = NULL;
				Number* _tmp85_;
				Number* _tmp86_;
				if (args_length1 > 1) {
					Number* _tmp82_;
					Number* _tmp83_;
					_tmp82_ = args[1];
					_tmp83_ = _g_object_ref0 (_tmp82_);
					_g_object_unref0 (_tmp81_);
					_tmp81_ = _tmp83_;
				} else {
					Number* _tmp84_;
					_tmp84_ = number_new_integer ((gint64) 10, (gint64) 0);
					_g_object_unref0 (_tmp81_);
					_tmp81_ = _tmp84_;
				}
				_tmp85_ = x;
				_tmp86_ = number_logarithm (_tmp85_, _tmp81_);
				result = _tmp86_;
				_g_object_unref0 (_tmp81_);
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label43) ? _tmp5_label43 : (_tmp5_label43 = g_quark_from_static_string ("ln")))) {
		switch (0) {
			default:
			{
				Number* _tmp87_;
				Number* _tmp88_;
				_tmp87_ = x;
				_tmp88_ = number_ln (_tmp87_);
				result = _tmp88_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label44) ? _tmp5_label44 : (_tmp5_label44 = g_quark_from_static_string ("sqrt")))) {
		switch (0) {
			default:
			{
				Number* _tmp89_;
				Number* _tmp90_;
				_tmp89_ = x;
				_tmp90_ = number_sqrt (_tmp89_);
				result = _tmp90_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label45) ? _tmp5_label45 : (_tmp5_label45 = g_quark_from_static_string ("abs")))) {
		switch (0) {
			default:
			{
				Number* _tmp91_;
				Number* _tmp92_;
				_tmp91_ = x;
				_tmp92_ = number_abs (_tmp91_);
				result = _tmp92_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label46) ? _tmp5_label46 : (_tmp5_label46 = g_quark_from_static_string ("sgn")))) {
		switch (0) {
			default:
			{
				Number* _tmp93_;
				Number* _tmp94_;
				_tmp93_ = x;
				_tmp94_ = number_sgn (_tmp93_);
				result = _tmp94_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label47) ? _tmp5_label47 : (_tmp5_label47 = g_quark_from_static_string ("ncr")))) {
		switch (0) {
			default:
			{
				Number* _tmp95_;
				Number* _tmp96_;
				Number* _tmp97_;
				_tmp95_ = x;
				_tmp96_ = args[1];
				_tmp97_ = number_combination (_tmp95_, _tmp96_);
				result = _tmp97_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label48) ? _tmp5_label48 : (_tmp5_label48 = g_quark_from_static_string ("npr")))) {
		switch (0) {
			default:
			{
				Number* _tmp98_;
				Number* _tmp99_;
				Number* _tmp100_;
				_tmp98_ = x;
				_tmp99_ = args[1];
				_tmp100_ = number_permutation (_tmp98_, _tmp99_);
				result = _tmp100_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label49) ? _tmp5_label49 : (_tmp5_label49 = g_quark_from_static_string ("gcd")))) {
		switch (0) {
			default:
			{
				Number* _tmp101_;
				_tmp101_ = number_gcd (args, (gint) args_length1);
				result = _tmp101_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label50) ? _tmp5_label50 : (_tmp5_label50 = g_quark_from_static_string ("lcm")))) {
		switch (0) {
			default:
			{
				Number* _tmp102_;
				_tmp102_ = number_lcm (args, (gint) args_length1);
				result = _tmp102_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label51) ? _tmp5_label51 : (_tmp5_label51 = g_quark_from_static_string ("cmp")))) {
		switch (0) {
			default:
			{
				Number* _tmp103_;
				Number* _tmp104_;
				Number* _tmp105_;
				_tmp103_ = x;
				_tmp104_ = args[1];
				_tmp105_ = number_kronecker_delta (_tmp103_, _tmp104_);
				result = _tmp105_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	}
	result = NULL;
	_g_object_unref0 (x);
	_g_free0 (lower_name);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

