/* database.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from database.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gnome-games.h"

#define GAMES_DATABASE_CREATE_RESOURCES_TABLE_QUERY "\n" \
"\t\tCREATE TABLE IF NOT EXISTS game_resources (\n" \
"\t\t\tid INTEGER PRIMARY KEY NOT NULL,\n" \
"\t\t\turi TEXT NOT NULL\n" \
"\t\t);\n" \
"\t"
#define GAMES_DATABASE_CREATE_GAMES_TABLE_QUERY "\n" \
"\t\tCREATE TABLE IF NOT EXISTS games (\n" \
"\t\t\tid INTEGER PRIMARY KEY NOT NULL,\n" \
"\t\t\tuid TEXT NOT NULL UNIQUE,\n" \
"\t\t\ttitle TEXT NOT NULL,\n" \
"\t\t\tplatform TEXT NOT NULL,\n" \
"\t\t\tmedia_set TEXT NULL,\n" \
"\t\t\tis_favorite INTEGER NOT NULL DEFAULT 0,\n" \
"\t\t\tlast_played TEXT DEFAULT NULL\n" \
"\t\t);\n" \
"\t"
#define GAMES_DATABASE_CREATE_URIS_TABLE_QUERY "\n" \
"\t\tCREATE TABLE IF NOT EXISTS uris (\n" \
"\t\t\tid INTEGER PRIMARY KEY NOT NULL,\n" \
"\t\t\tuid TEXT NOT NULL,\n" \
"\t\t\turi TEXT NOT NULL UNIQUE,\n" \
"\t\t\tFOREIGN KEY(uid) REFERENCES games(uid)\n" \
"\t\t);\n" \
"\t"
#define GAMES_DATABASE_CREATE_USER_COLLECTIONS_TABLE_QUERY "\n" \
"\t\tCREATE TABLE IF NOT EXISTS user_collections (\n" \
"\t\t\tid INTEGER PRIMARY KEY NOT NULL,\n" \
"\t\t\tcollection_id TEXT NOT NULL UNIQUE,\n" \
"\t\t\ttitle TEXT NOT NULL UNIQUE\n" \
"\t\t);\n" \
"\t"
#define GAMES_DATABASE_CREATE_USER_COLLECTIONS_GAMES_TABLE_QUERY "\n" \
"\t\tCREATE TABLE IF NOT EXISTS user_collections_games (\n" \
"\t\t\tid INTEGER PRIMARY KEY NOT NULL,\n" \
"\t\t\tcollection TEXT NOT NULL,\n" \
"\t\t\tgame TEXT NOT NULL,\n" \
"\t\t\tFOREIGN KEY(collection) REFERENCES user_collections(collection_i" \
"d) ON DELETE CASCADE,\n" \
"\t\t\tFOREIGN KEY(game) REFERENCES games(uid) ON DELETE CASCADE\n" \
"\t\t);\n" \
"\t"
#define GAMES_DATABASE_ADD_GAME_QUERY "\n" \
"\t\tINSERT INTO games (uid, title, platform, media_set) VALUES ($UID, " \
"$TITLE, $PLATFORM, $MEDIA_SET);\n" \
"\t"
#define GAMES_DATABASE_ADD_GAME_URI_QUERY "\n\t\tINSERT INTO uris (uid, uri) VALUES ($UID, $URI);\n\t"
#define GAMES_DATABASE_UPDATE_GAME_QUERY "\n" \
"\t\tUPDATE games SET title = $TITLE, media_set = $MEDIA_SET WHERE uid " \
"= $UID;\n" \
"\t"
#define GAMES_DATABASE_DELETE_GAME_QUERY "\n\t\tDELETE FROM games WHERE uid = $UID;\n\t"
#define GAMES_DATABASE_DELETE_URI_QUERY "\n\t\tDELETE FROM uris WHERE uri = $URI;\n\t"
#define GAMES_DATABASE_FIND_GAME_URIS_QUERY "\n\t\tSELECT uri FROM uris WHERE uid = $UID;\n\t"
#define GAMES_DATABASE_GET_CACHED_GAME_QUERY "\n" \
"\t\tSELECT uri, title, platform, media_set, is_favorite, last_played\n" \
"\t\tFROM games JOIN uris ON games.uid == uris.uid WHERE games.uid == $" \
"UID;\n" \
"\t"
#define GAMES_DATABASE_LIST_CACHED_GAMES_QUERY "\n" \
"\t\tSELECT games.uid, uri, title, platform, media_set, is_favorite, la" \
"st_played\n" \
"\t\tFROM games JOIN uris ON games.uid == uris.uid ORDER BY title;\n" \
"\t"
#define GAMES_DATABASE_ADD_GAME_RESOURCE_QUERY "\n\t\tINSERT INTO game_resources (id, uri) VALUES (NULL, $URI);\n\t"
#define GAMES_DATABASE_HAS_URI_QUERY "\n" \
"\t\tSELECT EXISTS (SELECT 1 FROM game_resources WHERE uri=$URI LIMIT 1" \
");\n" \
"\t"
#define GAMES_DATABASE_SET_IS_FAVORITE_QUERY "\n" \
"\t\tUPDATE games SET is_favorite = $IS_FAVORITE WHERE uid = $UID;\n" \
"\t"
#define GAMES_DATABASE_IS_GAME_FAVORITE_QUERY "\n" \
"\t\tSELECT EXISTS (SELECT 1 FROM games WHERE uid = $UID AND is_favorit" \
"e = 1 LIMIT 1);\n" \
"\t"
#define GAMES_DATABASE_LIST_FAVORITE_GAMES_QUERY "\n\t\tSELECT uid FROM games WHERE is_favorite = 1;\n\t"
#define GAMES_DATABASE_UPDATE_RECENTLY_PLAYED_GAME_QUERY "\n" \
"\t\tUPDATE games SET last_played = $LAST_PLAYED WHERE uid = $UID;\n" \
"\t"
#define GAMES_DATABASE_LIST_RECENTLY_PLAYED_GAMES_QUERY "\n\t\tSELECT uid FROM games WHERE last_played IS NOT NULL;\n\t"
#define GAMES_DATABASE_ADD_USER_COLLECTION_QUERY "\n" \
"\t\tINSERT INTO user_collections (collection_id, title) VALUES ($COLLE" \
"CTION_ID, $TITLE);\n" \
"\t"
#define GAMES_DATABASE_ADD_GAME_TO_USER_COLLECTION_QUERY "\n" \
"\t\tINSERT INTO user_collections_games (collection, game)\n" \
"\t\tVALUES ($COLLECTION_ID, $GAME_UID);\n" \
"\t"
#define GAMES_DATABASE_DOES_USER_COLLECTION_EXIST_QUERY "\n" \
"\t\tSELECT EXISTS (SELECT 1 FROM user_collections\n" \
"\t\tWHERE collection_id = $COLLECTION_ID LIMIT 1);\n" \
"\t"
#define GAMES_DATABASE_IS_GAME_IN_USER_COLLECTION_QUERY "\n" \
"\t\tSELECT EXISTS (SELECT 1 FROM user_collections_games\n" \
"\t\tWHERE game = $GAME_UID AND collection = $COLLECTION_ID LIMIT 1);\n" \
"\t"
#define GAMES_DATABASE_LIST_USER_COLLECTIONS_QUERY "\n\t\tSELECT collection_id, title FROM user_collections;\n\t"
#define GAMES_DATABASE_LIST_GAMES_IN_USER_COLLECTION_QUERY "\n" \
"\t\tSELECT games.uid FROM games JOIN user_collections_games\n" \
"\t\tON games.uid = game WHERE collection = $COLLECTION_ID;\n" \
"\t"
#define GAMES_DATABASE_REMOVE_USER_COLLECTION_QUERY "\n" \
"\t\tDELETE FROM user_collections WHERE collection_id = $COLLECTION_ID;" \
"\n" \
"\t"
#define GAMES_DATABASE_REMOVE_GAME_FROM_USER_COLLECTION_QUERY "\n" \
"\t\tDELETE FROM user_collections_games WHERE collection = $COLLECTION_" \
"ID AND game = $GAME_UID;\n" \
"\t"
#define GAMES_DATABASE_RENAME_USER_COLLECTION_QUERY "\n" \
"\t\tUPDATE user_collections SET title = $TITLE WHERE collection_id = $" \
"COLLECTION_ID;\n" \
"\t"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;
typedef struct _GamesDatabasePrivate GamesDatabasePrivate;
enum  {
	GAMES_DATABASE_0_PROPERTY,
	GAMES_DATABASE_NUM_PROPERTIES
};
static GParamSpec* games_database_properties[GAMES_DATABASE_NUM_PROPERTIES];
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define GAMES_TYPE_DATABASE_ERROR (games_database_error_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_DATABASE_URI_SOURCE (games_database_uri_source_get_type ())
#define GAMES_DATABASE_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSource))
#define GAMES_DATABASE_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSourceClass))
#define GAMES_IS_DATABASE_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE_URI_SOURCE))
#define GAMES_IS_DATABASE_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE_URI_SOURCE))
#define GAMES_DATABASE_URI_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSourceClass))

typedef struct _GamesDatabaseUriSource GamesDatabaseUriSource;
typedef struct _GamesDatabaseUriSourceClass GamesDatabaseUriSourceClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block17Data Block17Data;
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))

#define GAMES_TYPE_PLATFORM_REGISTER (games_platform_register_get_type ())
#define GAMES_PLATFORM_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegister))
#define GAMES_PLATFORM_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegisterClass))
#define GAMES_IS_PLATFORM_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLATFORM_REGISTER))
#define GAMES_IS_PLATFORM_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLATFORM_REGISTER))
#define GAMES_PLATFORM_REGISTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegisterClass))

typedef struct _GamesPlatformRegister GamesPlatformRegister;
typedef struct _GamesPlatformRegisterClass GamesPlatformRegisterClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define GAMES_TYPE_USER_COLLECTION (games_user_collection_get_type ())
#define GAMES_USER_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_USER_COLLECTION, GamesUserCollection))
#define GAMES_USER_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_USER_COLLECTION, GamesUserCollectionClass))
#define GAMES_IS_USER_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_USER_COLLECTION))
#define GAMES_IS_USER_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_USER_COLLECTION))
#define GAMES_USER_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_USER_COLLECTION, GamesUserCollectionClass))

typedef struct _GamesUserCollection GamesUserCollection;
typedef struct _GamesUserCollectionClass GamesUserCollectionClass;

#define GAMES_TYPE_COLLECTION (games_collection_get_type ())
#define GAMES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION, GamesCollection))
#define GAMES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION))
#define GAMES_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COLLECTION, GamesCollectionIface))

typedef struct _GamesCollection GamesCollection;
typedef struct _GamesCollectionIface GamesCollectionIface;

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;
typedef enum  {
	GAMES_COLLECTION_TYPE_AUTO,
	GAMES_COLLECTION_TYPE_USER,
	GAMES_COLLECTION_TYPE_PLACEHOLDER
} GamesCollectionType;

#define GAMES_TYPE_COLLECTION_TYPE (games_collection_type_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _GamesDatabase {
	GObject parent_instance;
	GamesDatabasePrivate * priv;
};

struct _GamesDatabaseClass {
	GObjectClass parent_class;
};

struct _GamesDatabasePrivate {
	sqlite3* database;
	sqlite3_stmt* add_game_query;
	sqlite3_stmt* add_game_uri_query;
	sqlite3_stmt* update_game_query;
	sqlite3_stmt* delete_game_query;
	sqlite3_stmt* delete_uri_query;
	sqlite3_stmt* find_game_uris_query;
	sqlite3_stmt* get_cached_game_query;
	sqlite3_stmt* list_cached_games_query;
	sqlite3_stmt* add_game_resource_query;
	sqlite3_stmt* has_uri_query;
	sqlite3_stmt* set_is_favorite_query;
	sqlite3_stmt* is_game_favorite_query;
	sqlite3_stmt* list_favorite_games_query;
	sqlite3_stmt* update_recently_played_game_query;
	sqlite3_stmt* list_recently_played_games_query;
	sqlite3_stmt* add_user_collection_query;
	sqlite3_stmt* add_game_to_user_collection_query;
	sqlite3_stmt* does_user_collection_exist_query;
	sqlite3_stmt* is_game_in_user_collection_query;
	sqlite3_stmt* list_user_collections_query;
	sqlite3_stmt* list_games_in_user_collection_query;
	sqlite3_stmt* remove_user_collection_query;
	sqlite3_stmt* remove_game_from_user_collection_query;
	sqlite3_stmt* rename_user_collection_query;
};

typedef enum  {
	GAMES_DATABASE_ERROR_COULDNT_OPEN,
	GAMES_DATABASE_ERROR_EXECUTION_FAILED,
	GAMES_DATABASE_ERROR_PREPARATION_FAILED,
	GAMES_DATABASE_ERROR_BINDING_FAILED
} GamesDatabaseError;
#define GAMES_DATABASE_ERROR games_database_error_quark ()

struct _Block17Data {
	int _ref_count_;
	GamesDatabase* self;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
};

struct _GamesCollectionIface {
	GTypeInterface parent_iface;
	void (*load) (GamesCollection* self);
	gchar* (*get_id) (GamesCollection* self);
	gboolean (*get_hide_stars) (GamesCollection* self);
	GamesGameModel* (*get_game_model) (GamesCollection* self);
	GamesCollectionType (*get_collection_type) (GamesCollection* self);
	void (*add_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*remove_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*on_game_added) (GamesCollection* self, GamesGame* game);
	void (*on_game_removed) (GamesCollection* self, GamesGame* game);
	void (*on_game_replaced) (GamesCollection* self, GamesGame* game, GamesGame* prev_game);
	gboolean (*get_is_empty) (GamesCollection* self);
	const gchar* (*get_title) (GamesCollection* self);
};

static gint GamesDatabase_private_offset;
static gpointer games_database_parent_class = NULL;

VALA_EXTERN GType games_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesDatabase* games_database_new (const gchar* path,
                                   GError** error);
VALA_EXTERN GamesDatabase* games_database_construct (GType object_type,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GQuark games_database_error_quark (void);
VALA_EXTERN GType games_database_error_get_type (void) G_GNUC_CONST ;
static void games_database_exec (GamesDatabase* self,
                          const gchar* query,
                          sqlite3_callback callback,
                          gpointer callback_target,
                          GError** error);
VALA_EXTERN void games_database_prepare_statements (GamesDatabase* self);
VALA_EXTERN sqlite3_stmt* games_database_prepare (sqlite3* database,
                                      const gchar* query,
                                      GError** error);
VALA_EXTERN void games_database_apply_favorites_migration (GamesDatabase* self,
                                               GError** error);
VALA_EXTERN void games_database_apply_recently_played_migration (GamesDatabase* self,
                                                     GError** error);
VALA_EXTERN void games_database_add_uri (GamesDatabase* self,
                             GamesUri* uri,
                             GError** error);
VALA_EXTERN gboolean games_database_has_uri (GamesDatabase* self,
                                 GamesUri* uri,
                                 GError** error);
VALA_EXTERN void games_database_bind_text (sqlite3_stmt* statement,
                               const gchar* parameter,
                               const gchar* text,
                               GError** error);
VALA_EXTERN GType games_database_uri_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesDatabaseUriSource* games_database_get_uri_source (GamesDatabase* self);
VALA_EXTERN GamesDatabaseUriSource* games_database_uri_source_new (sqlite3* database);
VALA_EXTERN GamesDatabaseUriSource* games_database_uri_source_construct (GType object_type,
                                                             sqlite3* database);
VALA_EXTERN void games_database_bind_int (sqlite3_stmt* statement,
                              const gchar* parameter,
                              gint* integer,
                              GError** error);
static gchar* games_database_serialize_media_set (GamesDatabase* self,
                                           GamesGame* game);
static gchar** games_database_get_media_uris (GamesDatabase* self,
                                       GamesGame* game,
                                       gint* result_length1);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda5_ (Block17Data* _data17_,
                 GamesMedia* media);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void ___lambda5__games_media_set_media_callback (GamesMedia* media,
                                                 gpointer self);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static void games_database_store_game_uri (GamesDatabase* self,
                                    const gchar* uid,
                                    const gchar* uri,
                                    GError** error);
VALA_EXTERN GamesGame* games_database_store_game (GamesDatabase* self,
                                      GamesGame* game,
                                      GError** error);
static GamesGame* games_database_get_cached_game (GamesDatabase* self,
                                           const gchar* uid,
                                           GError** error);
VALA_EXTERN void games_database_update_game (GamesDatabase* self,
                                 GamesGame* game,
                                 GamesGame* prev_game,
                                 GError** error);
VALA_EXTERN gboolean games_database_remove_game (GamesDatabase* self,
                                     const gchar* uri,
                                     GamesGame* game,
                                     GError** error);
static GamesGame* games_database_create_game (GamesDatabase* self,
                                       const gchar* uid,
                                       const gchar* uri,
                                       const gchar* title,
                                       const gchar* platform,
                                       const gchar* media_set,
                                       gint is_favorite,
                                       const gchar* last_played);
VALA_EXTERN void games_database_list_cached_games (GamesDatabase* self,
                                       GamesGameCallback game_callback,
                                       gpointer game_callback_target,
                                       GError** error);
VALA_EXTERN GType games_platform_register_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesPlatformRegister* games_platform_register_get_register (void);
VALA_EXTERN GamesPlatform* games_platform_register_get_platform (GamesPlatformRegister* self,
                                                     const gchar* id);
VALA_EXTERN gboolean games_database_set_is_favorite (GamesDatabase* self,
                                         GamesGame* game,
                                         GError** error);
static gboolean games_database_is_game_favorite (GamesDatabase* self,
                                          GamesGame* game,
                                          GError** error);
VALA_EXTERN GHashTable* games_database_list_favorite_games (GamesDatabase* self,
                                                GError** error);
static guint _games_uid_hash_ghash_func (gconstpointer key);
static gboolean _games_uid_equal_gequal_func (gconstpointer a,
                                       gconstpointer b);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN GHashTable* games_database_list_recently_played_games (GamesDatabase* self,
                                                       GError** error);
VALA_EXTERN void games_database_update_recently_played_game (GamesDatabase* self,
                                                 GamesGame* game,
                                                 gboolean remove,
                                                 GError** error);
static gboolean games_database_does_user_collection_exist (GamesDatabase* self,
                                                    const gchar* uuid,
                                                    GError** error);
static gboolean games_database_is_game_in_user_collection (GamesDatabase* self,
                                                    const gchar* game_uid,
                                                    const gchar* collection_id,
                                                    GError** error);
VALA_EXTERN GType games_user_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean games_database_add_user_collection (GamesDatabase* self,
                                             GamesUserCollection* collection,
                                             GError** error);
VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* games_collection_get_id (GamesCollection* self);
VALA_EXTERN const gchar* games_collection_get_title (GamesCollection* self);
VALA_EXTERN gboolean games_database_add_game_to_user_collection (GamesDatabase* self,
                                                     GamesGame* game,
                                                     GamesUserCollection* collection,
                                                     GError** error);
VALA_EXTERN GHashTable* games_database_get_user_collections (GamesDatabase* self,
                                                 GError** error);
VALA_EXTERN guint games_collection_hash (GamesCollection* collection);
static guint _games_collection_hash_ghash_func (gconstpointer key);
VALA_EXTERN gboolean games_collection_equal (GamesCollection* a,
                                 GamesCollection* b);
static gboolean _games_collection_equal_gequal_func (gconstpointer a,
                                              gconstpointer b);
VALA_EXTERN GamesUserCollection* games_user_collection_new (const gchar* id,
                                                const gchar* title,
                                                GamesDatabase* database);
VALA_EXTERN GamesUserCollection* games_user_collection_construct (GType object_type,
                                                      const gchar* id,
                                                      const gchar* title,
                                                      GamesDatabase* database);
VALA_EXTERN GHashTable* games_database_list_games_in_user_collection (GamesDatabase* self,
                                                          GamesUserCollection* collection,
                                                          GError** error);
VALA_EXTERN gboolean games_database_remove_user_collection (GamesDatabase* self,
                                                GamesUserCollection* collection,
                                                GError** error);
VALA_EXTERN gboolean games_database_remove_game_from_user_collection (GamesDatabase* self,
                                                          GamesGame* game,
                                                          GamesUserCollection* collection,
                                                          GError** error);
VALA_EXTERN gboolean games_database_rename_user_collection (GamesDatabase* self,
                                                GamesUserCollection* collection,
                                                const gchar* title,
                                                GError** error);
static void games_database_finalize (GObject * obj);
static GType games_database_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_database_get_instance_private (GamesDatabase* self)
{
	return G_STRUCT_MEMBER_P (self, GamesDatabase_private_offset);
}

GamesDatabase*
games_database_construct (GType object_type,
                          const gchar* path,
                          GError** error)
{
	GamesDatabase * self = NULL;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (GamesDatabase*) g_object_new (object_type, NULL);
	_tmp1_ = sqlite3_open (path, &_tmp0_);
	_sqlite3_close0 (self->priv->database);
	self->priv->database = _tmp0_;
	if (_tmp1_ != SQLITE_OK) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_COULDNT_OPEN, "Couldn’t open the database for “%s”.", path);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	games_database_exec (self, GAMES_DATABASE_CREATE_RESOURCES_TABLE_QUERY, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	games_database_exec (self, GAMES_DATABASE_CREATE_GAMES_TABLE_QUERY, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	games_database_exec (self, GAMES_DATABASE_CREATE_URIS_TABLE_QUERY, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	games_database_exec (self, GAMES_DATABASE_CREATE_USER_COLLECTIONS_TABLE_QUERY, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	games_database_exec (self, GAMES_DATABASE_CREATE_USER_COLLECTIONS_GAMES_TABLE_QUERY, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

GamesDatabase*
games_database_new (const gchar* path,
                    GError** error)
{
	return games_database_construct (GAMES_TYPE_DATABASE, path, error);
}

void
games_database_prepare_statements (GamesDatabase* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		sqlite3_stmt* _tmp0_ = NULL;
		sqlite3* _tmp1_;
		sqlite3_stmt* _tmp2_;
		sqlite3_stmt* _tmp3_;
		sqlite3_stmt* _tmp4_ = NULL;
		sqlite3* _tmp5_;
		sqlite3_stmt* _tmp6_;
		sqlite3_stmt* _tmp7_;
		sqlite3_stmt* _tmp8_ = NULL;
		sqlite3* _tmp9_;
		sqlite3_stmt* _tmp10_;
		sqlite3_stmt* _tmp11_;
		sqlite3_stmt* _tmp12_ = NULL;
		sqlite3* _tmp13_;
		sqlite3_stmt* _tmp14_;
		sqlite3_stmt* _tmp15_;
		sqlite3_stmt* _tmp16_ = NULL;
		sqlite3* _tmp17_;
		sqlite3_stmt* _tmp18_;
		sqlite3_stmt* _tmp19_;
		sqlite3_stmt* _tmp20_ = NULL;
		sqlite3* _tmp21_;
		sqlite3_stmt* _tmp22_;
		sqlite3_stmt* _tmp23_;
		sqlite3_stmt* _tmp24_ = NULL;
		sqlite3* _tmp25_;
		sqlite3_stmt* _tmp26_;
		sqlite3_stmt* _tmp27_;
		sqlite3_stmt* _tmp28_ = NULL;
		sqlite3* _tmp29_;
		sqlite3_stmt* _tmp30_;
		sqlite3_stmt* _tmp31_;
		sqlite3_stmt* _tmp32_ = NULL;
		sqlite3* _tmp33_;
		sqlite3_stmt* _tmp34_;
		sqlite3_stmt* _tmp35_;
		sqlite3_stmt* _tmp36_ = NULL;
		sqlite3* _tmp37_;
		sqlite3_stmt* _tmp38_;
		sqlite3_stmt* _tmp39_;
		sqlite3_stmt* _tmp40_ = NULL;
		sqlite3* _tmp41_;
		sqlite3_stmt* _tmp42_;
		sqlite3_stmt* _tmp43_;
		sqlite3_stmt* _tmp44_ = NULL;
		sqlite3* _tmp45_;
		sqlite3_stmt* _tmp46_;
		sqlite3_stmt* _tmp47_;
		sqlite3_stmt* _tmp48_ = NULL;
		sqlite3* _tmp49_;
		sqlite3_stmt* _tmp50_;
		sqlite3_stmt* _tmp51_;
		sqlite3_stmt* _tmp52_ = NULL;
		sqlite3* _tmp53_;
		sqlite3_stmt* _tmp54_;
		sqlite3_stmt* _tmp55_;
		sqlite3_stmt* _tmp56_ = NULL;
		sqlite3* _tmp57_;
		sqlite3_stmt* _tmp58_;
		sqlite3_stmt* _tmp59_;
		sqlite3_stmt* _tmp60_ = NULL;
		sqlite3* _tmp61_;
		sqlite3_stmt* _tmp62_;
		sqlite3_stmt* _tmp63_;
		sqlite3_stmt* _tmp64_ = NULL;
		sqlite3* _tmp65_;
		sqlite3_stmt* _tmp66_;
		sqlite3_stmt* _tmp67_;
		sqlite3_stmt* _tmp68_ = NULL;
		sqlite3* _tmp69_;
		sqlite3_stmt* _tmp70_;
		sqlite3_stmt* _tmp71_;
		sqlite3_stmt* _tmp72_ = NULL;
		sqlite3* _tmp73_;
		sqlite3_stmt* _tmp74_;
		sqlite3_stmt* _tmp75_;
		sqlite3_stmt* _tmp76_ = NULL;
		sqlite3* _tmp77_;
		sqlite3_stmt* _tmp78_;
		sqlite3_stmt* _tmp79_;
		sqlite3_stmt* _tmp80_ = NULL;
		sqlite3* _tmp81_;
		sqlite3_stmt* _tmp82_;
		sqlite3_stmt* _tmp83_;
		sqlite3_stmt* _tmp84_ = NULL;
		sqlite3* _tmp85_;
		sqlite3_stmt* _tmp86_;
		sqlite3_stmt* _tmp87_;
		sqlite3_stmt* _tmp88_ = NULL;
		sqlite3* _tmp89_;
		sqlite3_stmt* _tmp90_;
		sqlite3_stmt* _tmp91_;
		sqlite3_stmt* _tmp92_ = NULL;
		sqlite3* _tmp93_;
		sqlite3_stmt* _tmp94_;
		sqlite3_stmt* _tmp95_;
		_tmp1_ = self->priv->database;
		_tmp2_ = games_database_prepare (_tmp1_, GAMES_DATABASE_ADD_GAME_QUERY, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_sqlite3_finalize0 (self->priv->add_game_query);
		self->priv->add_game_query = _tmp3_;
		_tmp5_ = self->priv->database;
		_tmp6_ = games_database_prepare (_tmp5_, GAMES_DATABASE_ADD_GAME_URI_QUERY, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_sqlite3_finalize0 (self->priv->add_game_uri_query);
		self->priv->add_game_uri_query = _tmp7_;
		_tmp9_ = self->priv->database;
		_tmp10_ = games_database_prepare (_tmp9_, GAMES_DATABASE_UPDATE_GAME_QUERY, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_sqlite3_finalize0 (self->priv->update_game_query);
		self->priv->update_game_query = _tmp11_;
		_tmp13_ = self->priv->database;
		_tmp14_ = games_database_prepare (_tmp13_, GAMES_DATABASE_DELETE_GAME_QUERY, &_inner_error0_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp15_ = _tmp12_;
		_tmp12_ = NULL;
		_sqlite3_finalize0 (self->priv->delete_game_query);
		self->priv->delete_game_query = _tmp15_;
		_tmp17_ = self->priv->database;
		_tmp18_ = games_database_prepare (_tmp17_, GAMES_DATABASE_DELETE_URI_QUERY, &_inner_error0_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp19_ = _tmp16_;
		_tmp16_ = NULL;
		_sqlite3_finalize0 (self->priv->delete_uri_query);
		self->priv->delete_uri_query = _tmp19_;
		_tmp21_ = self->priv->database;
		_tmp22_ = games_database_prepare (_tmp21_, GAMES_DATABASE_FIND_GAME_URIS_QUERY, &_inner_error0_);
		_tmp20_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp23_ = _tmp20_;
		_tmp20_ = NULL;
		_sqlite3_finalize0 (self->priv->find_game_uris_query);
		self->priv->find_game_uris_query = _tmp23_;
		_tmp25_ = self->priv->database;
		_tmp26_ = games_database_prepare (_tmp25_, GAMES_DATABASE_GET_CACHED_GAME_QUERY, &_inner_error0_);
		_tmp24_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp27_ = _tmp24_;
		_tmp24_ = NULL;
		_sqlite3_finalize0 (self->priv->get_cached_game_query);
		self->priv->get_cached_game_query = _tmp27_;
		_tmp29_ = self->priv->database;
		_tmp30_ = games_database_prepare (_tmp29_, GAMES_DATABASE_LIST_CACHED_GAMES_QUERY, &_inner_error0_);
		_tmp28_ = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp31_ = _tmp28_;
		_tmp28_ = NULL;
		_sqlite3_finalize0 (self->priv->list_cached_games_query);
		self->priv->list_cached_games_query = _tmp31_;
		_tmp33_ = self->priv->database;
		_tmp34_ = games_database_prepare (_tmp33_, GAMES_DATABASE_ADD_GAME_RESOURCE_QUERY, &_inner_error0_);
		_tmp32_ = _tmp34_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp35_ = _tmp32_;
		_tmp32_ = NULL;
		_sqlite3_finalize0 (self->priv->add_game_resource_query);
		self->priv->add_game_resource_query = _tmp35_;
		_tmp37_ = self->priv->database;
		_tmp38_ = games_database_prepare (_tmp37_, GAMES_DATABASE_HAS_URI_QUERY, &_inner_error0_);
		_tmp36_ = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp39_ = _tmp36_;
		_tmp36_ = NULL;
		_sqlite3_finalize0 (self->priv->has_uri_query);
		self->priv->has_uri_query = _tmp39_;
		_tmp41_ = self->priv->database;
		_tmp42_ = games_database_prepare (_tmp41_, GAMES_DATABASE_SET_IS_FAVORITE_QUERY, &_inner_error0_);
		_tmp40_ = _tmp42_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp43_ = _tmp40_;
		_tmp40_ = NULL;
		_sqlite3_finalize0 (self->priv->set_is_favorite_query);
		self->priv->set_is_favorite_query = _tmp43_;
		_tmp45_ = self->priv->database;
		_tmp46_ = games_database_prepare (_tmp45_, GAMES_DATABASE_IS_GAME_FAVORITE_QUERY, &_inner_error0_);
		_tmp44_ = _tmp46_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp47_ = _tmp44_;
		_tmp44_ = NULL;
		_sqlite3_finalize0 (self->priv->is_game_favorite_query);
		self->priv->is_game_favorite_query = _tmp47_;
		_tmp49_ = self->priv->database;
		_tmp50_ = games_database_prepare (_tmp49_, GAMES_DATABASE_LIST_FAVORITE_GAMES_QUERY, &_inner_error0_);
		_tmp48_ = _tmp50_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp51_ = _tmp48_;
		_tmp48_ = NULL;
		_sqlite3_finalize0 (self->priv->list_favorite_games_query);
		self->priv->list_favorite_games_query = _tmp51_;
		_tmp53_ = self->priv->database;
		_tmp54_ = games_database_prepare (_tmp53_, GAMES_DATABASE_UPDATE_RECENTLY_PLAYED_GAME_QUERY, &_inner_error0_);
		_tmp52_ = _tmp54_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp55_ = _tmp52_;
		_tmp52_ = NULL;
		_sqlite3_finalize0 (self->priv->update_recently_played_game_query);
		self->priv->update_recently_played_game_query = _tmp55_;
		_tmp57_ = self->priv->database;
		_tmp58_ = games_database_prepare (_tmp57_, GAMES_DATABASE_LIST_RECENTLY_PLAYED_GAMES_QUERY, &_inner_error0_);
		_tmp56_ = _tmp58_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp59_ = _tmp56_;
		_tmp56_ = NULL;
		_sqlite3_finalize0 (self->priv->list_recently_played_games_query);
		self->priv->list_recently_played_games_query = _tmp59_;
		_tmp61_ = self->priv->database;
		_tmp62_ = games_database_prepare (_tmp61_, GAMES_DATABASE_ADD_USER_COLLECTION_QUERY, &_inner_error0_);
		_tmp60_ = _tmp62_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp63_ = _tmp60_;
		_tmp60_ = NULL;
		_sqlite3_finalize0 (self->priv->add_user_collection_query);
		self->priv->add_user_collection_query = _tmp63_;
		_tmp65_ = self->priv->database;
		_tmp66_ = games_database_prepare (_tmp65_, GAMES_DATABASE_ADD_GAME_TO_USER_COLLECTION_QUERY, &_inner_error0_);
		_tmp64_ = _tmp66_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp60_);
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp67_ = _tmp64_;
		_tmp64_ = NULL;
		_sqlite3_finalize0 (self->priv->add_game_to_user_collection_query);
		self->priv->add_game_to_user_collection_query = _tmp67_;
		_tmp69_ = self->priv->database;
		_tmp70_ = games_database_prepare (_tmp69_, GAMES_DATABASE_DOES_USER_COLLECTION_EXIST_QUERY, &_inner_error0_);
		_tmp68_ = _tmp70_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp64_);
			_sqlite3_finalize0 (_tmp60_);
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp71_ = _tmp68_;
		_tmp68_ = NULL;
		_sqlite3_finalize0 (self->priv->does_user_collection_exist_query);
		self->priv->does_user_collection_exist_query = _tmp71_;
		_tmp73_ = self->priv->database;
		_tmp74_ = games_database_prepare (_tmp73_, GAMES_DATABASE_IS_GAME_IN_USER_COLLECTION_QUERY, &_inner_error0_);
		_tmp72_ = _tmp74_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp68_);
			_sqlite3_finalize0 (_tmp64_);
			_sqlite3_finalize0 (_tmp60_);
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp75_ = _tmp72_;
		_tmp72_ = NULL;
		_sqlite3_finalize0 (self->priv->is_game_in_user_collection_query);
		self->priv->is_game_in_user_collection_query = _tmp75_;
		_tmp77_ = self->priv->database;
		_tmp78_ = games_database_prepare (_tmp77_, GAMES_DATABASE_LIST_USER_COLLECTIONS_QUERY, &_inner_error0_);
		_tmp76_ = _tmp78_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp72_);
			_sqlite3_finalize0 (_tmp68_);
			_sqlite3_finalize0 (_tmp64_);
			_sqlite3_finalize0 (_tmp60_);
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp79_ = _tmp76_;
		_tmp76_ = NULL;
		_sqlite3_finalize0 (self->priv->list_user_collections_query);
		self->priv->list_user_collections_query = _tmp79_;
		_tmp81_ = self->priv->database;
		_tmp82_ = games_database_prepare (_tmp81_, GAMES_DATABASE_LIST_GAMES_IN_USER_COLLECTION_QUERY, &_inner_error0_);
		_tmp80_ = _tmp82_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp76_);
			_sqlite3_finalize0 (_tmp72_);
			_sqlite3_finalize0 (_tmp68_);
			_sqlite3_finalize0 (_tmp64_);
			_sqlite3_finalize0 (_tmp60_);
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp83_ = _tmp80_;
		_tmp80_ = NULL;
		_sqlite3_finalize0 (self->priv->list_games_in_user_collection_query);
		self->priv->list_games_in_user_collection_query = _tmp83_;
		_tmp85_ = self->priv->database;
		_tmp86_ = games_database_prepare (_tmp85_, GAMES_DATABASE_REMOVE_USER_COLLECTION_QUERY, &_inner_error0_);
		_tmp84_ = _tmp86_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp80_);
			_sqlite3_finalize0 (_tmp76_);
			_sqlite3_finalize0 (_tmp72_);
			_sqlite3_finalize0 (_tmp68_);
			_sqlite3_finalize0 (_tmp64_);
			_sqlite3_finalize0 (_tmp60_);
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp87_ = _tmp84_;
		_tmp84_ = NULL;
		_sqlite3_finalize0 (self->priv->remove_user_collection_query);
		self->priv->remove_user_collection_query = _tmp87_;
		_tmp89_ = self->priv->database;
		_tmp90_ = games_database_prepare (_tmp89_, GAMES_DATABASE_REMOVE_GAME_FROM_USER_COLLECTION_QUERY, &_inner_error0_);
		_tmp88_ = _tmp90_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp84_);
			_sqlite3_finalize0 (_tmp80_);
			_sqlite3_finalize0 (_tmp76_);
			_sqlite3_finalize0 (_tmp72_);
			_sqlite3_finalize0 (_tmp68_);
			_sqlite3_finalize0 (_tmp64_);
			_sqlite3_finalize0 (_tmp60_);
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp91_ = _tmp88_;
		_tmp88_ = NULL;
		_sqlite3_finalize0 (self->priv->remove_game_from_user_collection_query);
		self->priv->remove_game_from_user_collection_query = _tmp91_;
		_tmp93_ = self->priv->database;
		_tmp94_ = games_database_prepare (_tmp93_, GAMES_DATABASE_RENAME_USER_COLLECTION_QUERY, &_inner_error0_);
		_tmp92_ = _tmp94_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_sqlite3_finalize0 (_tmp88_);
			_sqlite3_finalize0 (_tmp84_);
			_sqlite3_finalize0 (_tmp80_);
			_sqlite3_finalize0 (_tmp76_);
			_sqlite3_finalize0 (_tmp72_);
			_sqlite3_finalize0 (_tmp68_);
			_sqlite3_finalize0 (_tmp64_);
			_sqlite3_finalize0 (_tmp60_);
			_sqlite3_finalize0 (_tmp56_);
			_sqlite3_finalize0 (_tmp52_);
			_sqlite3_finalize0 (_tmp48_);
			_sqlite3_finalize0 (_tmp44_);
			_sqlite3_finalize0 (_tmp40_);
			_sqlite3_finalize0 (_tmp36_);
			_sqlite3_finalize0 (_tmp32_);
			_sqlite3_finalize0 (_tmp28_);
			_sqlite3_finalize0 (_tmp24_);
			_sqlite3_finalize0 (_tmp20_);
			_sqlite3_finalize0 (_tmp16_);
			_sqlite3_finalize0 (_tmp12_);
			_sqlite3_finalize0 (_tmp8_);
			_sqlite3_finalize0 (_tmp4_);
			_sqlite3_finalize0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp95_ = _tmp92_;
		_tmp92_ = NULL;
		_sqlite3_finalize0 (self->priv->rename_user_collection_query);
		self->priv->rename_user_collection_query = _tmp95_;
		_sqlite3_finalize0 (_tmp92_);
		_sqlite3_finalize0 (_tmp88_);
		_sqlite3_finalize0 (_tmp84_);
		_sqlite3_finalize0 (_tmp80_);
		_sqlite3_finalize0 (_tmp76_);
		_sqlite3_finalize0 (_tmp72_);
		_sqlite3_finalize0 (_tmp68_);
		_sqlite3_finalize0 (_tmp64_);
		_sqlite3_finalize0 (_tmp60_);
		_sqlite3_finalize0 (_tmp56_);
		_sqlite3_finalize0 (_tmp52_);
		_sqlite3_finalize0 (_tmp48_);
		_sqlite3_finalize0 (_tmp44_);
		_sqlite3_finalize0 (_tmp40_);
		_sqlite3_finalize0 (_tmp36_);
		_sqlite3_finalize0 (_tmp32_);
		_sqlite3_finalize0 (_tmp28_);
		_sqlite3_finalize0 (_tmp24_);
		_sqlite3_finalize0 (_tmp20_);
		_sqlite3_finalize0 (_tmp16_);
		_sqlite3_finalize0 (_tmp12_);
		_sqlite3_finalize0 (_tmp8_);
		_sqlite3_finalize0 (_tmp4_);
		_sqlite3_finalize0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp96_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp96_ = e->message;
		g_critical ("database.vala:228: Failed to prepare statements: %s", _tmp96_);
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
games_database_apply_favorites_migration (GamesDatabase* self,
                                          GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_info ("database.vala:234: Applying database migration to support favorites");
	games_database_exec (self, "ALTER TABLE games ADD COLUMN is_favorite INTEGER NOT NULL DEFAULT 0;", NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
games_database_apply_recently_played_migration (GamesDatabase* self,
                                                GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_info ("database.vala:239: Applying database migration to support recently pla" \
"yed games");
	games_database_exec (self, "ALTER TABLE games ADD COLUMN last_played TEXT DEFAULT NULL;", NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
games_database_add_uri (GamesDatabase* self,
                        GamesUri* uri,
                        GError** error)
{
	gboolean _tmp0_ = FALSE;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	sqlite3_stmt* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = games_database_has_uri (self, uri, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->add_game_resource_query;
	sqlite3_reset (_tmp1_);
	_tmp2_ = self->priv->add_game_resource_query;
	_tmp3_ = games_uri_to_string (uri);
	_tmp4_ = _tmp3_;
	games_database_bind_text (_tmp2_, "$URI", _tmp4_, &_inner_error0_);
	_g_free0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp5_ = self->priv->add_game_resource_query;
	if (sqlite3_step (_tmp5_) != SQLITE_DONE) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Execution failed.");
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

gboolean
games_database_has_uri (GamesDatabase* self,
                        GamesUri* uri,
                        GError** error)
{
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3_stmt* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->has_uri_query;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->has_uri_query;
	_tmp2_ = games_uri_to_string (uri);
	_tmp3_ = _tmp2_;
	games_database_bind_text (_tmp1_, "$URI", _tmp3_, &_inner_error0_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	_tmp5_ = self->priv->has_uri_query;
	switch (sqlite3_step (_tmp5_)) {
		case SQLITE_ROW:
		{
			sqlite3_stmt* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->priv->has_uri_query;
			_tmp7_ = (const gchar*) sqlite3_column_text (_tmp6_, 0);
			result = g_strcmp0 (_tmp7_, "1") == 0;
			return result;
		}
		default:
		{
			g_debug ("database.vala:262: Execution failed.");
			result = FALSE;
			return result;
		}
	}
}

GamesDatabaseUriSource*
games_database_get_uri_source (GamesDatabase* self)
{
	sqlite3* _tmp0_;
	GamesDatabaseUriSource* _tmp1_;
	GamesDatabaseUriSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = games_database_uri_source_new (_tmp0_);
	result = _tmp1_;
	return result;
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static void
games_database_exec (GamesDatabase* self,
                     const gchar* query,
                     sqlite3_callback callback,
                     gpointer callback_target,
                     GError** error)
{
	gchar* error_message = NULL;
	sqlite3* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_tmp0_ = self->priv->database;
	_tmp2_ = _sqlite3_exec (_tmp0_, query, callback, callback_target, &_tmp1_);
	_g_free0 (error_message);
	error_message = _tmp1_;
	if (_tmp2_ != SQLITE_OK) {
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp3_ = error_message;
		_tmp4_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Execution failed: %s", _tmp3_);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (error_message);
		return;
	}
	_g_free0 (error_message);
}

sqlite3_stmt*
games_database_prepare (sqlite3* database,
                        const gchar* query,
                        GError** error)
{
	sqlite3_stmt* statement = NULL;
	gint _tmp0_;
	gint _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	sqlite3_stmt* result;
	g_return_val_if_fail (database != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = strlen (query);
	_tmp1_ = _tmp0_;
	_tmp3_ = sqlite3_prepare_v2 (database, query, _tmp1_, &_tmp2_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp2_;
	if (_tmp3_ != SQLITE_OK) {
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp4_ = sqlite3_errmsg (database);
		_tmp5_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_PREPARATION_FAILED, "Preparation failed: %s", _tmp4_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_sqlite3_finalize0 (statement);
		return NULL;
	}
	result = statement;
	return result;
}

void
games_database_bind_text (sqlite3_stmt* statement,
                          const gchar* parameter,
                          const gchar* text,
                          GError** error)
{
	gint position = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (statement != NULL);
	g_return_if_fail (parameter != NULL);
	position = sqlite3_bind_parameter_index (statement, parameter);
	if (position <= 0) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_BINDING_FAILED, "Couldn't bind text to the parameter “%s”, unexpected position: %d.", parameter, position);
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (text != NULL) {
		gchar* _tmp1_;
		GDestroyNotify _tmp2_;
		_tmp1_ = g_strdup (text);
		_tmp2_ = g_free;
		sqlite3_bind_text (statement, position, _tmp1_, -1, _tmp2_);
	} else {
		sqlite3_bind_null (statement, position);
	}
}

void
games_database_bind_int (sqlite3_stmt* statement,
                         const gchar* parameter,
                         gint* integer,
                         GError** error)
{
	gint position = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (statement != NULL);
	g_return_if_fail (parameter != NULL);
	position = sqlite3_bind_parameter_index (statement, parameter);
	if (position <= 0) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_BINDING_FAILED, "Couldn't bind text to the parameter “%s”, unexpected position: %d.", parameter, position);
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (integer != NULL) {
		sqlite3_bind_int (statement, position, *integer);
	} else {
		sqlite3_bind_null (statement, position);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
games_database_serialize_media_set (GamesDatabase* self,
                                    GamesGame* game)
{
	GamesMediaSet* media_set = NULL;
	GamesMediaSet* _tmp0_;
	GamesMediaSet* _tmp1_;
	GamesMediaSet* _tmp2_;
	GamesMediaSet* _tmp3_;
	GamesMediaSet* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = games_game_get_media_set (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	media_set = _tmp2_;
	_tmp3_ = media_set;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (media_set);
		return result;
	}
	_tmp4_ = media_set;
	_tmp5_ = games_media_set_serialize (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_print (_tmp6_, TRUE);
	_tmp8_ = _tmp7_;
	_g_variant_unref0 (_tmp6_);
	result = _tmp8_;
	_g_object_unref0 (media_set);
	return result;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		GamesDatabase* self;
		self = _data17_->self;
		_data17_->uris = (_vala_array_free (_data17_->uris, _data17_->uris_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static gpointer
_games_uri_ref0 (gpointer self)
{
	return self ? games_uri_ref (self) : NULL;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda5_ (Block17Data* _data17_,
            GamesMedia* media)
{
	GamesDatabase* self;
	gint _tmp0_ = 0;
	GamesUri** _tmp1_;
	self = _data17_->self;
	g_return_if_fail (media != NULL);
	_tmp1_ = games_media_get_uris (media, &_tmp0_);
	{
		GamesUri** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp1_;
		uri_collection_length1 = _tmp0_;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			GamesUri* _tmp2_;
			GamesUri* uri = NULL;
			_tmp2_ = _games_uri_ref0 (uri_collection[uri_it]);
			uri = _tmp2_;
			{
				GamesUri* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = uri;
				_tmp4_ = games_uri_to_string (_tmp3_);
				_vala_array_add18 (&_data17_->uris, &_data17_->uris_length1, &_data17_->_uris_size_, _tmp4_);
				_games_uri_unref0 (uri);
			}
		}
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) games_uri_unref), NULL);
	}
}

static void
___lambda5__games_media_set_media_callback (GamesMedia* media,
                                            gpointer self)
{
	__lambda5_ (self, media);
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
games_database_get_media_uris (GamesDatabase* self,
                               GamesGame* game,
                               gint* result_length1)
{
	Block17Data* _data17_;
	GamesMediaSet* media_set = NULL;
	GamesMediaSet* _tmp0_;
	GamesMediaSet* _tmp1_;
	GamesMediaSet* _tmp2_;
	GamesMediaSet* _tmp3_;
	gchar** _tmp6_;
	GamesMediaSet* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = games_game_get_media_set (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	media_set = _tmp2_;
	_tmp3_ = media_set;
	if (_tmp3_ == NULL) {
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp4_ = g_new0 (gchar*, 0 + 1);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp5__length1;
		}
		result = _tmp5_;
		_g_object_unref0 (media_set);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return result;
	}
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	_data17_->uris = _tmp6_;
	_data17_->uris_length1 = 0;
	_data17_->_uris_size_ = _data17_->uris_length1;
	_tmp7_ = media_set;
	games_media_set_foreach_media (_tmp7_, ___lambda5__games_media_set_media_callback, _data17_);
	_tmp8_ = _data17_->uris;
	_tmp8__length1 = _data17_->uris_length1;
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup8 (_tmp8_, _tmp8__length1) : _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_object_unref0 (media_set);
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}

static void
games_database_store_game_uri (GamesDatabase* self,
                               const gchar* uid,
                               const gchar* uri,
                               GError** error)
{
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->add_game_uri_query;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->add_game_uri_query;
	games_database_bind_text (_tmp1_, "$UID", uid, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = self->priv->add_game_uri_query;
	games_database_bind_text (_tmp2_, "$URI", uri, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = self->priv->add_game_uri_query;
	_result_ = sqlite3_step (_tmp3_);
	if (_result_ != SQLITE_DONE) {
		_tmp4_ = _result_ != SQLITE_CONSTRAINT;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Couldn't add uri (%s, %s)", uid, uri);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

GamesGame*
games_database_store_game (GamesDatabase* self,
                           GamesGame* game,
                           GError** error)
{
	gchar* uid = NULL;
	GamesUid* _tmp0_;
	GamesUid* _tmp1_;
	gchar* _tmp2_;
	gchar* uri = NULL;
	GamesUri* _tmp3_;
	GamesUri* _tmp4_;
	gchar* _tmp5_;
	gchar* title = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* platform = NULL;
	GamesPlatform* _tmp9_;
	GamesPlatform* _tmp10_;
	gchar* _tmp11_;
	gchar* media_set = NULL;
	gchar* _tmp12_;
	GamesMediaSet* _tmp13_;
	GamesMediaSet* _tmp14_;
	sqlite3_stmt* _tmp22_;
	sqlite3_stmt* _tmp23_;
	const gchar* _tmp24_;
	sqlite3_stmt* _tmp25_;
	const gchar* _tmp26_;
	sqlite3_stmt* _tmp27_;
	const gchar* _tmp28_;
	sqlite3_stmt* _tmp29_;
	const gchar* _tmp30_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp31_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = games_game_get_uid (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_uid_to_string (_tmp1_);
	uid = _tmp2_;
	_tmp3_ = games_game_get_uri (game);
	_tmp4_ = _tmp3_;
	_tmp5_ = games_uri_to_string (_tmp4_);
	uri = _tmp5_;
	_tmp6_ = games_game_get_name (game);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	title = _tmp8_;
	_tmp9_ = games_game_get_platform (game);
	_tmp10_ = _tmp9_;
	_tmp11_ = games_platform_get_id (_tmp10_);
	platform = _tmp11_;
	_tmp12_ = games_database_serialize_media_set (self, game);
	media_set = _tmp12_;
	_tmp13_ = games_game_get_media_set (game);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		gint _tmp15_ = 0;
		gchar** _tmp16_;
		_tmp16_ = games_database_get_media_uris (self, game, &_tmp15_);
		{
			gchar** media_uri_collection = NULL;
			gint media_uri_collection_length1 = 0;
			gint _media_uri_collection_size_ = 0;
			gint media_uri_it = 0;
			media_uri_collection = _tmp16_;
			media_uri_collection_length1 = _tmp15_;
			for (media_uri_it = 0; media_uri_it < media_uri_collection_length1; media_uri_it = media_uri_it + 1) {
				gchar* _tmp17_;
				gchar* media_uri = NULL;
				_tmp17_ = g_strdup (media_uri_collection[media_uri_it]);
				media_uri = _tmp17_;
				{
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp18_ = uid;
					_tmp19_ = media_uri;
					games_database_store_game_uri (self, _tmp18_, _tmp19_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (media_uri);
						media_uri_collection = (_vala_array_free (media_uri_collection, media_uri_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (media_set);
						_g_free0 (platform);
						_g_free0 (title);
						_g_free0 (uri);
						_g_free0 (uid);
						return NULL;
					}
					_g_free0 (media_uri);
				}
			}
			media_uri_collection = (_vala_array_free (media_uri_collection, media_uri_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	} else {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = uid;
		_tmp21_ = uri;
		games_database_store_game_uri (self, _tmp20_, _tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (media_set);
			_g_free0 (platform);
			_g_free0 (title);
			_g_free0 (uri);
			_g_free0 (uid);
			return NULL;
		}
	}
	_tmp22_ = self->priv->add_game_query;
	sqlite3_reset (_tmp22_);
	_tmp23_ = self->priv->add_game_query;
	_tmp24_ = uid;
	games_database_bind_text (_tmp23_, "$UID", _tmp24_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (media_set);
		_g_free0 (platform);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return NULL;
	}
	_tmp25_ = self->priv->add_game_query;
	_tmp26_ = title;
	games_database_bind_text (_tmp25_, "$TITLE", _tmp26_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (media_set);
		_g_free0 (platform);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return NULL;
	}
	_tmp27_ = self->priv->add_game_query;
	_tmp28_ = platform;
	games_database_bind_text (_tmp27_, "$PLATFORM", _tmp28_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (media_set);
		_g_free0 (platform);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return NULL;
	}
	_tmp29_ = self->priv->add_game_query;
	_tmp30_ = media_set;
	games_database_bind_text (_tmp29_, "$MEDIA_SET", _tmp30_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (media_set);
		_g_free0 (platform);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return NULL;
	}
	_tmp31_ = self->priv->add_game_query;
	_result_ = sqlite3_step (_tmp31_);
	if (_result_ == SQLITE_CONSTRAINT) {
		GamesGame* prev_game = NULL;
		const gchar* _tmp32_;
		GamesGame* _tmp33_;
		GamesGame* _tmp34_;
		_tmp32_ = uid;
		_tmp33_ = games_database_get_cached_game (self, _tmp32_, &_inner_error0_);
		prev_game = _tmp33_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (media_set);
			_g_free0 (platform);
			_g_free0 (title);
			_g_free0 (uri);
			_g_free0 (uid);
			return NULL;
		}
		_tmp34_ = prev_game;
		games_database_update_game (self, game, _tmp34_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (prev_game);
			_g_free0 (media_set);
			_g_free0 (platform);
			_g_free0 (title);
			_g_free0 (uri);
			_g_free0 (uid);
			return NULL;
		}
		result = prev_game;
		_g_free0 (media_set);
		_g_free0 (platform);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return result;
	}
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		GError* _tmp39_;
		_tmp35_ = uid;
		_tmp36_ = title;
		_tmp37_ = platform;
		_tmp38_ = media_set;
		_tmp39_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Couldn't add game (%s, %s, %s, %s)", _tmp35_, _tmp36_, _tmp37_, _tmp38_);
		_inner_error0_ = _tmp39_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (media_set);
		_g_free0 (platform);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return NULL;
	}
	result = NULL;
	_g_free0 (media_set);
	_g_free0 (platform);
	_g_free0 (title);
	_g_free0 (uri);
	_g_free0 (uid);
	return result;
}

void
games_database_update_game (GamesDatabase* self,
                            GamesGame* game,
                            GamesGame* prev_game,
                            GError** error)
{
	gchar* uid = NULL;
	GamesUid* _tmp0_;
	GamesUid* _tmp1_;
	gchar* _tmp2_;
	gchar* uri = NULL;
	GamesUri* _tmp3_;
	GamesUri* _tmp4_;
	gchar* _tmp5_;
	gchar* title = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* media_set = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* old_title = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* old_media_set = NULL;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	sqlite3_stmt* _tmp22_;
	sqlite3_stmt* _tmp23_;
	const gchar* _tmp24_;
	sqlite3_stmt* _tmp25_;
	const gchar* _tmp26_;
	sqlite3_stmt* _tmp27_;
	const gchar* _tmp28_;
	sqlite3_stmt* _tmp29_;
	GamesMediaSet* _tmp34_;
	GamesMediaSet* _tmp35_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = games_game_get_uid (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_uid_to_string (_tmp1_);
	uid = _tmp2_;
	_tmp3_ = games_game_get_uri (game);
	_tmp4_ = _tmp3_;
	_tmp5_ = games_uri_to_string (_tmp4_);
	uri = _tmp5_;
	_tmp6_ = games_game_get_name (game);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	title = _tmp8_;
	_tmp9_ = games_database_serialize_media_set (self, game);
	media_set = _tmp9_;
	if (prev_game != NULL) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = games_game_get_name (prev_game);
		_tmp12_ = _tmp11_;
		_tmp10_ = _tmp12_;
	} else {
		_tmp10_ = NULL;
	}
	_tmp13_ = g_strdup (_tmp10_);
	old_title = _tmp13_;
	if (prev_game != NULL) {
		gchar* _tmp15_;
		_tmp15_ = games_database_serialize_media_set (self, prev_game);
		_g_free0 (_tmp14_);
		_tmp14_ = _tmp15_;
	} else {
		_g_free0 (_tmp14_);
		_tmp14_ = NULL;
	}
	_tmp16_ = g_strdup (_tmp14_);
	old_media_set = _tmp16_;
	_tmp18_ = old_title;
	_tmp19_ = title;
	if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = old_media_set;
		_tmp21_ = media_set;
		_tmp17_ = g_strcmp0 (_tmp20_, _tmp21_) == 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_g_free0 (old_media_set);
		_g_free0 (_tmp14_);
		_g_free0 (old_title);
		_g_free0 (media_set);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return;
	}
	_tmp22_ = self->priv->update_game_query;
	sqlite3_reset (_tmp22_);
	_tmp23_ = self->priv->update_game_query;
	_tmp24_ = uid;
	games_database_bind_text (_tmp23_, "$UID", _tmp24_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (old_media_set);
		_g_free0 (_tmp14_);
		_g_free0 (old_title);
		_g_free0 (media_set);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return;
	}
	_tmp25_ = self->priv->update_game_query;
	_tmp26_ = title;
	games_database_bind_text (_tmp25_, "$TITLE", _tmp26_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (old_media_set);
		_g_free0 (_tmp14_);
		_g_free0 (old_title);
		_g_free0 (media_set);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return;
	}
	_tmp27_ = self->priv->update_game_query;
	_tmp28_ = media_set;
	games_database_bind_text (_tmp27_, "$MEDIA_SET", _tmp28_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (old_media_set);
		_g_free0 (_tmp14_);
		_g_free0 (old_title);
		_g_free0 (media_set);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return;
	}
	_tmp29_ = self->priv->update_game_query;
	if (sqlite3_step (_tmp29_) != SQLITE_DONE) {
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		GError* _tmp33_;
		_tmp30_ = uid;
		_tmp31_ = title;
		_tmp32_ = media_set;
		_tmp33_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Couldn't update game (%s, %s, %s)", _tmp30_, _tmp31_, _tmp32_);
		_inner_error0_ = _tmp33_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (old_media_set);
		_g_free0 (_tmp14_);
		_g_free0 (old_title);
		_g_free0 (media_set);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
		return;
	}
	_tmp34_ = games_game_get_media_set (game);
	_tmp35_ = _tmp34_;
	if (_tmp35_ != NULL) {
		gint _tmp36_ = 0;
		gchar** _tmp37_;
		_tmp37_ = games_database_get_media_uris (self, game, &_tmp36_);
		{
			gchar** media_uri_collection = NULL;
			gint media_uri_collection_length1 = 0;
			gint _media_uri_collection_size_ = 0;
			gint media_uri_it = 0;
			media_uri_collection = _tmp37_;
			media_uri_collection_length1 = _tmp36_;
			for (media_uri_it = 0; media_uri_it < media_uri_collection_length1; media_uri_it = media_uri_it + 1) {
				gchar* _tmp38_;
				gchar* media_uri = NULL;
				_tmp38_ = g_strdup (media_uri_collection[media_uri_it]);
				media_uri = _tmp38_;
				{
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp39_ = uid;
					_tmp40_ = media_uri;
					games_database_store_game_uri (self, _tmp39_, _tmp40_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (media_uri);
						media_uri_collection = (_vala_array_free (media_uri_collection, media_uri_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (old_media_set);
						_g_free0 (_tmp14_);
						_g_free0 (old_title);
						_g_free0 (media_set);
						_g_free0 (title);
						_g_free0 (uri);
						_g_free0 (uid);
						return;
					}
					_g_free0 (media_uri);
				}
			}
			media_uri_collection = (_vala_array_free (media_uri_collection, media_uri_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	} else {
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		_tmp41_ = uid;
		_tmp42_ = uri;
		games_database_store_game_uri (self, _tmp41_, _tmp42_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (old_media_set);
			_g_free0 (_tmp14_);
			_g_free0 (old_title);
			_g_free0 (media_set);
			_g_free0 (title);
			_g_free0 (uri);
			_g_free0 (uid);
			return;
		}
	}
	_g_free0 (old_media_set);
	_g_free0 (_tmp14_);
	_g_free0 (old_title);
	_g_free0 (media_set);
	_g_free0 (title);
	_g_free0 (uri);
	_g_free0 (uid);
}

gboolean
games_database_remove_game (GamesDatabase* self,
                            const gchar* uri,
                            GamesGame* game,
                            GError** error)
{
	gchar* uid = NULL;
	GamesUid* _tmp0_;
	GamesUid* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	const gchar* _tmp11_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp17_;
	sqlite3_stmt* _tmp18_;
	const gchar* _tmp19_;
	sqlite3_stmt* _tmp21_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (game != NULL, FALSE);
	_tmp0_ = games_game_get_uid (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_uid_to_string (_tmp1_);
	uid = _tmp2_;
	_tmp3_ = self->priv->delete_uri_query;
	sqlite3_reset (_tmp3_);
	_tmp4_ = self->priv->delete_uri_query;
	games_database_bind_text (_tmp4_, "$URI", uri, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uid);
		return _tmp5_;
	}
	_tmp6_ = self->priv->delete_uri_query;
	if (sqlite3_step (_tmp6_) != SQLITE_DONE) {
		GError* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Couldn't delete uri (%s)", uri);
		_inner_error0_ = _tmp7_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uid);
		return _tmp8_;
	}
	_tmp9_ = self->priv->find_game_uris_query;
	sqlite3_reset (_tmp9_);
	_tmp10_ = self->priv->find_game_uris_query;
	_tmp11_ = uid;
	games_database_bind_text (_tmp10_, "$UID", _tmp11_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uid);
		return _tmp12_;
	}
	_tmp13_ = self->priv->find_game_uris_query;
	_result_ = sqlite3_step (_tmp13_);
	if (_result_ == SQLITE_ROW) {
		result = FALSE;
		_g_free0 (uid);
		return result;
	}
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp14_;
		GError* _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp14_ = uid;
		_tmp15_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Couldn't find uris (%s)", _tmp14_);
		_inner_error0_ = _tmp15_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uid);
		return _tmp16_;
	}
	_tmp17_ = self->priv->delete_game_query;
	sqlite3_reset (_tmp17_);
	_tmp18_ = self->priv->delete_game_query;
	_tmp19_ = uid;
	games_database_bind_text (_tmp18_, "$UID", _tmp19_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp20_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uid);
		return _tmp20_;
	}
	_tmp21_ = self->priv->delete_game_query;
	if (sqlite3_step (_tmp21_) != SQLITE_DONE) {
		const gchar* _tmp22_;
		GError* _tmp23_;
		gboolean _tmp24_ = FALSE;
		_tmp22_ = uid;
		_tmp23_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Couldn't delete game (%s)", _tmp22_);
		_inner_error0_ = _tmp23_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uid);
		return _tmp24_;
	}
	result = TRUE;
	_g_free0 (uid);
	return result;
}

static GamesGame*
games_database_get_cached_game (GamesDatabase* self,
                                const gchar* uid,
                                GError** error)
{
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError* _tmp25_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	_tmp0_ = self->priv->get_cached_game_query;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->get_cached_game_query;
	games_database_bind_text (_tmp1_, "$UID", uid, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = self->priv->get_cached_game_query;
	if (sqlite3_step (_tmp2_) == SQLITE_ROW) {
		gchar* uri = NULL;
		sqlite3_stmt* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* title = NULL;
		sqlite3_stmt* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* platform = NULL;
		sqlite3_stmt* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* media_set = NULL;
		sqlite3_stmt* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gint is_favorite = 0;
		sqlite3_stmt* _tmp15_;
		gchar* last_played = NULL;
		sqlite3_stmt* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		GamesGame* _tmp24_;
		_tmp3_ = self->priv->get_cached_game_query;
		_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
		_tmp5_ = g_strdup (_tmp4_);
		uri = _tmp5_;
		_tmp6_ = self->priv->get_cached_game_query;
		_tmp7_ = (const gchar*) sqlite3_column_text (_tmp6_, 1);
		_tmp8_ = g_strdup (_tmp7_);
		title = _tmp8_;
		_tmp9_ = self->priv->get_cached_game_query;
		_tmp10_ = (const gchar*) sqlite3_column_text (_tmp9_, 2);
		_tmp11_ = g_strdup (_tmp10_);
		platform = _tmp11_;
		_tmp12_ = self->priv->get_cached_game_query;
		_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 3);
		_tmp14_ = g_strdup (_tmp13_);
		media_set = _tmp14_;
		_tmp15_ = self->priv->get_cached_game_query;
		is_favorite = sqlite3_column_int (_tmp15_, 4);
		_tmp16_ = self->priv->get_cached_game_query;
		_tmp17_ = (const gchar*) sqlite3_column_text (_tmp16_, 5);
		_tmp18_ = g_strdup (_tmp17_);
		last_played = _tmp18_;
		_tmp19_ = uri;
		_tmp20_ = title;
		_tmp21_ = platform;
		_tmp22_ = media_set;
		_tmp23_ = last_played;
		_tmp24_ = games_database_create_game (self, uid, _tmp19_, _tmp20_, _tmp21_, _tmp22_, is_favorite, _tmp23_);
		result = _tmp24_;
		_g_free0 (last_played);
		_g_free0 (media_set);
		_g_free0 (platform);
		_g_free0 (title);
		_g_free0 (uri);
		return result;
	}
	_tmp25_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Couldn't get game for uid (%s)", uid);
	_inner_error0_ = _tmp25_;
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

void
games_database_list_cached_games (GamesDatabase* self,
                                  GamesGameCallback game_callback,
                                  gpointer game_callback_target,
                                  GError** error)
{
	sqlite3_stmt* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_cached_games_query;
	sqlite3_reset (_tmp0_);
	while (TRUE) {
		sqlite3_stmt* _tmp1_;
		gchar* uid = NULL;
		sqlite3_stmt* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* uri = NULL;
		sqlite3_stmt* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* title = NULL;
		sqlite3_stmt* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* platform = NULL;
		sqlite3_stmt* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* media_set = NULL;
		sqlite3_stmt* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gint is_favorite = 0;
		sqlite3_stmt* _tmp17_;
		gchar* last_played = NULL;
		sqlite3_stmt* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		GamesGame* game = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		GamesGame* _tmp27_;
		GamesGame* _tmp28_;
		_tmp1_ = self->priv->list_cached_games_query;
		if (!(sqlite3_step (_tmp1_) == SQLITE_ROW)) {
			break;
		}
		_tmp2_ = self->priv->list_cached_games_query;
		_tmp3_ = (const gchar*) sqlite3_column_text (_tmp2_, 0);
		_tmp4_ = g_strdup (_tmp3_);
		uid = _tmp4_;
		_tmp5_ = self->priv->list_cached_games_query;
		_tmp6_ = (const gchar*) sqlite3_column_text (_tmp5_, 1);
		_tmp7_ = g_strdup (_tmp6_);
		uri = _tmp7_;
		_tmp8_ = self->priv->list_cached_games_query;
		_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 2);
		_tmp10_ = g_strdup (_tmp9_);
		title = _tmp10_;
		_tmp11_ = self->priv->list_cached_games_query;
		_tmp12_ = (const gchar*) sqlite3_column_text (_tmp11_, 3);
		_tmp13_ = g_strdup (_tmp12_);
		platform = _tmp13_;
		_tmp14_ = self->priv->list_cached_games_query;
		_tmp15_ = (const gchar*) sqlite3_column_text (_tmp14_, 4);
		_tmp16_ = g_strdup (_tmp15_);
		media_set = _tmp16_;
		_tmp17_ = self->priv->list_cached_games_query;
		is_favorite = sqlite3_column_int (_tmp17_, 5);
		_tmp18_ = self->priv->list_cached_games_query;
		_tmp19_ = (const gchar*) sqlite3_column_text (_tmp18_, 6);
		_tmp20_ = g_strdup (_tmp19_);
		last_played = _tmp20_;
		_tmp21_ = uid;
		_tmp22_ = uri;
		_tmp23_ = title;
		_tmp24_ = platform;
		_tmp25_ = media_set;
		_tmp26_ = last_played;
		_tmp27_ = games_database_create_game (self, _tmp21_, _tmp22_, _tmp23_, _tmp24_, _tmp25_, is_favorite, _tmp26_);
		game = _tmp27_;
		_tmp28_ = game;
		game_callback (_tmp28_, game_callback_target);
		_g_object_unref0 (game);
		_g_free0 (last_played);
		_g_free0 (media_set);
		_g_free0 (platform);
		_g_free0 (title);
		_g_free0 (uri);
		_g_free0 (uid);
	}
}

static GamesGame*
games_database_create_game (GamesDatabase* self,
                            const gchar* uid,
                            const gchar* uri,
                            const gchar* title,
                            const gchar* platform,
                            const gchar* media_set,
                            gint is_favorite,
                            const gchar* last_played)
{
	GamesUid* game_uid = NULL;
	GamesUid* _tmp0_;
	GamesUri* game_uri = NULL;
	GamesUri* _tmp1_;
	GamesGenericTitle* game_title = NULL;
	GamesGenericTitle* _tmp2_;
	GamesPlatform* game_platform = NULL;
	GamesPlatformRegister* _tmp3_;
	GamesPlatformRegister* _tmp4_;
	GamesPlatform* _tmp5_;
	GamesPlatform* _tmp6_;
	GamesPlatform* _tmp7_;
	GamesGame* game = NULL;
	GamesUid* _tmp9_;
	GamesUri* _tmp10_;
	GamesGenericTitle* _tmp11_;
	GamesPlatform* _tmp12_;
	GamesGame* _tmp13_;
	GamesGame* _tmp14_;
	GamesGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (platform != NULL, NULL);
	_tmp0_ = games_uid_new (uid);
	game_uid = _tmp0_;
	_tmp1_ = games_uri_new (uri);
	game_uri = _tmp1_;
	_tmp2_ = games_generic_title_new (title);
	game_title = _tmp2_;
	_tmp3_ = games_platform_register_get_register ();
	_tmp4_ = _tmp3_;
	_tmp5_ = games_platform_register_get_platform (_tmp4_, platform);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	game_platform = _tmp6_;
	_tmp7_ = game_platform;
	if (_tmp7_ == NULL) {
		GamesDummyPlatform* _tmp8_;
		_tmp8_ = games_dummy_platform_new ();
		_g_object_unref0 (game_platform);
		game_platform = (GamesPlatform*) _tmp8_;
	}
	_tmp9_ = game_uid;
	_tmp10_ = game_uri;
	_tmp11_ = game_title;
	_tmp12_ = game_platform;
	_tmp13_ = games_game_new (_tmp9_, _tmp10_, (GamesTitle*) _tmp11_, _tmp12_);
	game = _tmp13_;
	_tmp14_ = game;
	games_game_set_is_favorite (_tmp14_, is_favorite == 1);
	if (last_played != NULL) {
		GamesGame* _tmp15_;
		GDateTime* _tmp16_;
		GDateTime* _tmp17_;
		_tmp15_ = game;
		_tmp16_ = g_date_time_new_from_iso8601 (last_played, NULL);
		_tmp17_ = _tmp16_;
		games_game_set_last_played (_tmp15_, _tmp17_);
		_g_date_time_unref0 (_tmp17_);
	}
	if (media_set != NULL) {
		GamesGame* _tmp18_;
		GVariant* _tmp19_;
		GVariant* _tmp20_;
		GamesMediaSet* _tmp21_;
		GamesMediaSet* _tmp22_;
		_tmp18_ = game;
		_tmp19_ = g_variant_new_parsed (media_set, NULL);
		g_variant_ref_sink (_tmp19_);
		_tmp20_ = _tmp19_;
		_tmp21_ = games_media_set_new_parse (_tmp20_);
		_tmp22_ = _tmp21_;
		games_game_set_media_set (_tmp18_, _tmp22_);
		_g_object_unref0 (_tmp22_);
		_g_variant_unref0 (_tmp20_);
	}
	result = game;
	_g_object_unref0 (game_platform);
	_g_object_unref0 (game_title);
	_games_uri_unref0 (game_uri);
	_g_object_unref0 (game_uid);
	return result;
}

gboolean
games_database_set_is_favorite (GamesDatabase* self,
                                GamesGame* game,
                                GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gboolean _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp10_;
	GamesUid* _tmp11_;
	GamesUid* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp16_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (game != NULL, FALSE);
	_tmp0_ = games_database_is_game_favorite (self, game, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = games_game_get_is_favorite (game);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == _tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->set_is_favorite_query;
	sqlite3_reset (_tmp4_);
	_tmp6_ = games_game_get_is_favorite (game);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp5_ = 1;
	} else {
		_tmp5_ = 0;
	}
	_tmp8_ = self->priv->set_is_favorite_query;
	games_database_bind_int (_tmp8_, "$IS_FAVORITE", &_tmp5_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = self->priv->set_is_favorite_query;
	_tmp11_ = games_game_get_uid (game);
	_tmp12_ = _tmp11_;
	_tmp13_ = games_uid_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	games_database_bind_text (_tmp10_, "$UID", _tmp14_, &_inner_error0_);
	_g_free0 (_tmp14_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = self->priv->set_is_favorite_query;
	_result_ = sqlite3_step (_tmp16_);
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp17_ = NULL;
		gboolean _tmp18_;
		gboolean _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GError* _tmp22_;
		gboolean _tmp23_ = FALSE;
		_tmp18_ = games_game_get_is_favorite (game);
		_tmp19_ = _tmp18_;
		if (_tmp19_) {
			_tmp17_ = "";
		} else {
			_tmp17_ = "non-";
		}
		_tmp20_ = games_game_get_name (game);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Failed to make %s %sfavorite", _tmp21_, _tmp17_);
		_inner_error0_ = _tmp22_;
		g_propagate_error (error, _inner_error0_);
		return _tmp23_;
	}
	result = TRUE;
	return result;
}

static guint
_games_uid_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = games_uid_hash ((GamesUid*) key);
	return result;
}

static gboolean
_games_uid_equal_gequal_func (gconstpointer a,
                              gconstpointer b)
{
	gboolean result;
	result = games_uid_equal ((GamesUid*) a, (GamesUid*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

GHashTable*
games_database_list_favorite_games (GamesDatabase* self,
                                    GError** error)
{
	sqlite3_stmt* _tmp0_;
	GHashTable* games = NULL;
	GHashTable* _tmp1_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->list_favorite_games_query;
	sqlite3_reset (_tmp0_);
	_tmp1_ = g_hash_table_new_full (_games_uid_hash_ghash_func, _games_uid_equal_gequal_func, NULL, _g_object_unref0_);
	games = _tmp1_;
	while (TRUE) {
		sqlite3_stmt* _tmp2_;
		GHashTable* _tmp3_;
		sqlite3_stmt* _tmp4_;
		const gchar* _tmp5_;
		GamesUid* _tmp6_;
		_tmp2_ = self->priv->list_favorite_games_query;
		if (!(sqlite3_step (_tmp2_) == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = games;
		_tmp4_ = self->priv->list_favorite_games_query;
		_tmp5_ = (const gchar*) sqlite3_column_text (_tmp4_, 0);
		_tmp6_ = games_uid_new (_tmp5_);
		g_hash_table_add (_tmp3_, _tmp6_);
	}
	result = games;
	return result;
}

static gboolean
games_database_is_game_favorite (GamesDatabase* self,
                                 GamesGame* game,
                                 GError** error)
{
	gchar* uid = NULL;
	GamesUid* _tmp0_;
	GamesUid* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	sqlite3_stmt* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (game != NULL, FALSE);
	_tmp0_ = games_game_get_uid (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_uid_to_string (_tmp1_);
	uid = _tmp2_;
	_tmp3_ = self->priv->is_game_favorite_query;
	sqlite3_reset (_tmp3_);
	_tmp4_ = self->priv->is_game_favorite_query;
	_tmp5_ = uid;
	games_database_bind_text (_tmp4_, "$UID", _tmp5_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uid);
		return _tmp6_;
	}
	_tmp7_ = self->priv->is_game_favorite_query;
	switch (sqlite3_step (_tmp7_)) {
		case SQLITE_ROW:
		{
			sqlite3_stmt* _tmp8_;
			_tmp8_ = self->priv->is_game_favorite_query;
			result = sqlite3_column_int (_tmp8_, 0) == 1;
			_g_free0 (uid);
			return result;
		}
		default:
		{
			GError* _tmp9_;
			gboolean _tmp10_ = FALSE;
			_tmp9_ = g_error_new_literal (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Execution failed.");
			_inner_error0_ = _tmp9_;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (uid);
			return _tmp10_;
		}
	}
}

GHashTable*
games_database_list_recently_played_games (GamesDatabase* self,
                                           GError** error)
{
	sqlite3_stmt* _tmp0_;
	GHashTable* games = NULL;
	GHashTable* _tmp1_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->list_recently_played_games_query;
	sqlite3_reset (_tmp0_);
	_tmp1_ = g_hash_table_new_full (_games_uid_hash_ghash_func, _games_uid_equal_gequal_func, NULL, _g_object_unref0_);
	games = _tmp1_;
	while (TRUE) {
		sqlite3_stmt* _tmp2_;
		GHashTable* _tmp3_;
		sqlite3_stmt* _tmp4_;
		const gchar* _tmp5_;
		GamesUid* _tmp6_;
		_tmp2_ = self->priv->list_recently_played_games_query;
		if (!(sqlite3_step (_tmp2_) == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = games;
		_tmp4_ = self->priv->list_recently_played_games_query;
		_tmp5_ = (const gchar*) sqlite3_column_text (_tmp4_, 0);
		_tmp6_ = games_uid_new (_tmp5_);
		g_hash_table_add (_tmp3_, _tmp6_);
	}
	result = games;
	return result;
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

void
games_database_update_recently_played_game (GamesDatabase* self,
                                            GamesGame* game,
                                            gboolean remove,
                                            GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* last_played = NULL;
	gchar* _tmp4_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	const gchar* _tmp7_;
	sqlite3_stmt* _tmp8_;
	GamesUid* _tmp9_;
	GamesUid* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	if (remove) {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	} else {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = games_game_get_last_played (game);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_date_time_to_string (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp0_);
	last_played = _tmp4_;
	_tmp5_ = self->priv->update_recently_played_game_query;
	sqlite3_reset (_tmp5_);
	_tmp6_ = self->priv->update_recently_played_game_query;
	_tmp7_ = last_played;
	games_database_bind_text (_tmp6_, "$LAST_PLAYED", _tmp7_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (last_played);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp8_ = self->priv->update_recently_played_game_query;
	_tmp9_ = games_game_get_uid (game);
	_tmp10_ = _tmp9_;
	_tmp11_ = games_uid_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	games_database_bind_text (_tmp8_, "$UID", _tmp12_, &_inner_error0_);
	_g_free0 (_tmp12_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (last_played);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp13_ = self->priv->update_recently_played_game_query;
	_result_ = sqlite3_step (_tmp13_);
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		GError* _tmp16_;
		_tmp14_ = games_game_get_name (game);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Failed to update last played date-time of %s", _tmp15_);
		_inner_error0_ = _tmp16_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (last_played);
		_g_free0 (_tmp0_);
		return;
	}
	_g_free0 (last_played);
	_g_free0 (_tmp0_);
}

static gboolean
games_database_does_user_collection_exist (GamesDatabase* self,
                                           const gchar* uuid,
                                           GError** error)
{
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uuid != NULL, FALSE);
	if (!g_uuid_string_is_valid (uuid)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->does_user_collection_exist_query;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->does_user_collection_exist_query;
	games_database_bind_text (_tmp1_, "$COLLECTION_ID", uuid, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_tmp3_ = self->priv->does_user_collection_exist_query;
	if (sqlite3_step (_tmp3_) == SQLITE_ROW) {
		sqlite3_stmt* _tmp4_;
		_tmp4_ = self->priv->does_user_collection_exist_query;
		result = sqlite3_column_int (_tmp4_, 0) == 1;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
games_database_is_game_in_user_collection (GamesDatabase* self,
                                           const gchar* game_uid,
                                           const gchar* collection_id,
                                           GError** error)
{
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (game_uid != NULL, FALSE);
	g_return_val_if_fail (collection_id != NULL, FALSE);
	_tmp0_ = self->priv->is_game_in_user_collection_query;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->is_game_in_user_collection_query;
	games_database_bind_text (_tmp1_, "$GAME_UID", game_uid, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_tmp3_ = self->priv->is_game_in_user_collection_query;
	games_database_bind_text (_tmp3_, "$COLLECTION_ID", collection_id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	_tmp5_ = self->priv->is_game_in_user_collection_query;
	if (sqlite3_step (_tmp5_) == SQLITE_ROW) {
		sqlite3_stmt* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->is_game_in_user_collection_query;
		_tmp7_ = (const gchar*) sqlite3_column_text (_tmp6_, 0);
		result = g_strcmp0 (_tmp7_, "1") == 0;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
games_database_add_user_collection (GamesDatabase* self,
                                    GamesUserCollection* collection,
                                    GError** error)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	sqlite3_stmt* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp16_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp1_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_database_does_user_collection_exist (self, _tmp2_, &_inner_error0_);
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	if (_tmp0_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = games_collection_get_title ((GamesCollection*) collection);
		_tmp6_ = _tmp5_;
		g_critical ("database.vala:576: A collection named %s already exists", _tmp6_);
		result = FALSE;
		return result;
	}
	_tmp7_ = self->priv->add_user_collection_query;
	sqlite3_reset (_tmp7_);
	_tmp8_ = self->priv->add_user_collection_query;
	_tmp9_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp10_ = _tmp9_;
	games_database_bind_text (_tmp8_, "$COLLECTION_ID", _tmp10_, &_inner_error0_);
	_g_free0 (_tmp10_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp11_;
	}
	_tmp12_ = self->priv->add_user_collection_query;
	_tmp13_ = games_collection_get_title ((GamesCollection*) collection);
	_tmp14_ = _tmp13_;
	games_database_bind_text (_tmp12_, "$TITLE", _tmp14_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = self->priv->add_user_collection_query;
	_result_ = sqlite3_step (_tmp16_);
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		gboolean _tmp23_ = FALSE;
		_tmp17_ = games_collection_get_title ((GamesCollection*) collection);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%i", _result_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Failed to add user collection %s: %s", _tmp18_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_inner_error0_ = _tmp22_;
		g_propagate_error (error, _inner_error0_);
		return _tmp23_;
	}
	result = TRUE;
	return result;
}

gboolean
games_database_add_game_to_user_collection (GamesDatabase* self,
                                            GamesGame* game,
                                            GamesUserCollection* collection,
                                            GError** error)
{
	gboolean _tmp0_ = FALSE;
	GamesUid* _tmp1_;
	GamesUid* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	sqlite3_stmt* _tmp14_;
	GamesUid* _tmp15_;
	GamesUid* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (game != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp1_ = games_game_get_uid (game);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_uid_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp6_ = _tmp5_;
	_tmp7_ = games_database_is_game_in_user_collection (self, _tmp4_, _tmp6_, &_inner_error0_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->add_game_to_user_collection_query;
	sqlite3_reset (_tmp9_);
	_tmp10_ = self->priv->add_game_to_user_collection_query;
	_tmp11_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp12_ = _tmp11_;
	games_database_bind_text (_tmp10_, "$COLLECTION_ID", _tmp12_, &_inner_error0_);
	_g_free0 (_tmp12_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp13_;
	}
	_tmp14_ = self->priv->add_game_to_user_collection_query;
	_tmp15_ = games_game_get_uid (game);
	_tmp16_ = _tmp15_;
	_tmp17_ = games_uid_to_string (_tmp16_);
	_tmp18_ = _tmp17_;
	games_database_bind_text (_tmp14_, "$GAME_UID", _tmp18_, &_inner_error0_);
	_g_free0 (_tmp18_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp19_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp19_;
	}
	_tmp20_ = self->priv->add_game_to_user_collection_query;
	_result_ = sqlite3_step (_tmp20_);
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		GError* _tmp25_;
		gboolean _tmp26_ = FALSE;
		_tmp21_ = games_game_get_name (game);
		_tmp22_ = _tmp21_;
		_tmp23_ = games_collection_get_title ((GamesCollection*) collection);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Failed to add %s to user collection %s", _tmp22_, _tmp24_);
		_inner_error0_ = _tmp25_;
		g_propagate_error (error, _inner_error0_);
		return _tmp26_;
	}
	result = TRUE;
	return result;
}

static guint
_games_collection_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = games_collection_hash ((GamesCollection*) key);
	return result;
}

static gboolean
_games_collection_equal_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = games_collection_equal ((GamesCollection*) a, (GamesCollection*) b);
	return result;
}

GHashTable*
games_database_get_user_collections (GamesDatabase* self,
                                     GError** error)
{
	GHashTable* collections = NULL;
	GHashTable* _tmp0_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_new_full (_games_collection_hash_ghash_func, _games_collection_equal_gequal_func, NULL, _g_object_unref0_);
	collections = _tmp0_;
	while (TRUE) {
		sqlite3_stmt* _tmp1_;
		gchar* uuid = NULL;
		sqlite3_stmt* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* title = NULL;
		sqlite3_stmt* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		GamesUserCollection* collection = NULL;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GamesUserCollection* _tmp10_;
		GHashTable* _tmp11_;
		GamesUserCollection* _tmp12_;
		GamesUserCollection* _tmp13_;
		_tmp1_ = self->priv->list_user_collections_query;
		if (!(sqlite3_step (_tmp1_) == SQLITE_ROW)) {
			break;
		}
		_tmp2_ = self->priv->list_user_collections_query;
		_tmp3_ = (const gchar*) sqlite3_column_text (_tmp2_, 0);
		_tmp4_ = g_strdup (_tmp3_);
		uuid = _tmp4_;
		_tmp5_ = self->priv->list_user_collections_query;
		_tmp6_ = (const gchar*) sqlite3_column_text (_tmp5_, 1);
		_tmp7_ = g_strdup (_tmp6_);
		title = _tmp7_;
		_tmp8_ = uuid;
		_tmp9_ = title;
		_tmp10_ = games_user_collection_new (_tmp8_, _tmp9_, self);
		collection = _tmp10_;
		_tmp11_ = collections;
		_tmp12_ = collection;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		g_hash_table_add (_tmp11_, _tmp13_);
		_g_object_unref0 (collection);
		_g_free0 (title);
		_g_free0 (uuid);
	}
	result = collections;
	return result;
}

GHashTable*
games_database_list_games_in_user_collection (GamesDatabase* self,
                                              GamesUserCollection* collection,
                                              GError** error)
{
	GHashTable* games = NULL;
	GHashTable* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = g_hash_table_new_full (_games_uid_hash_ghash_func, _games_uid_equal_gequal_func, NULL, _g_object_unref0_);
	games = _tmp0_;
	_tmp1_ = self->priv->list_games_in_user_collection_query;
	sqlite3_reset (_tmp1_);
	_tmp2_ = self->priv->list_games_in_user_collection_query;
	_tmp3_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp4_ = _tmp3_;
	games_database_bind_text (_tmp2_, "$COLLECTION_ID", _tmp4_, &_inner_error0_);
	_g_free0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_hash_table_unref0 (games);
		return NULL;
	}
	while (TRUE) {
		sqlite3_stmt* _tmp5_;
		sqlite3_stmt* _tmp6_;
		const gchar* _tmp7_;
		GamesUid* _tmp8_;
		_tmp5_ = self->priv->list_games_in_user_collection_query;
		if (!(sqlite3_step (_tmp5_) == SQLITE_ROW)) {
			break;
		}
		_tmp6_ = self->priv->list_games_in_user_collection_query;
		_tmp7_ = (const gchar*) sqlite3_column_text (_tmp6_, 0);
		_tmp8_ = games_uid_new (_tmp7_);
		g_hash_table_add (games, _tmp8_);
	}
	result = games;
	return result;
}

gboolean
games_database_remove_user_collection (GamesDatabase* self,
                                       GamesUserCollection* collection,
                                       GError** error)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp1_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_database_does_user_collection_exist (self, _tmp2_, &_inner_error0_);
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->remove_user_collection_query;
	sqlite3_reset (_tmp5_);
	_tmp6_ = self->priv->remove_user_collection_query;
	_tmp7_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp8_ = _tmp7_;
	games_database_bind_text (_tmp6_, "$COLLECTION_ID", _tmp8_, &_inner_error0_);
	_g_free0 (_tmp8_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = self->priv->remove_user_collection_query;
	_result_ = sqlite3_step (_tmp10_);
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = games_collection_get_title ((GamesCollection*) collection);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Failed to remove user collection %s", _tmp12_);
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		return _tmp14_;
	}
	result = TRUE;
	return result;
}

gboolean
games_database_remove_game_from_user_collection (GamesDatabase* self,
                                                 GamesGame* game,
                                                 GamesUserCollection* collection,
                                                 GError** error)
{
	gboolean _tmp0_ = FALSE;
	GamesUid* _tmp1_;
	GamesUid* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	GamesUid* _tmp11_;
	GamesUid* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	sqlite3_stmt* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (game != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp1_ = games_game_get_uid (game);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_uid_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp6_ = _tmp5_;
	_tmp7_ = games_database_is_game_in_user_collection (self, _tmp4_, _tmp6_, &_inner_error0_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp8_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->remove_game_from_user_collection_query;
	sqlite3_reset (_tmp9_);
	_tmp10_ = self->priv->remove_game_from_user_collection_query;
	_tmp11_ = games_game_get_uid (game);
	_tmp12_ = _tmp11_;
	_tmp13_ = games_uid_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	games_database_bind_text (_tmp10_, "$GAME_UID", _tmp14_, &_inner_error0_);
	_g_free0 (_tmp14_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = self->priv->remove_game_from_user_collection_query;
	_tmp17_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp18_ = _tmp17_;
	games_database_bind_text (_tmp16_, "$COLLECTION_ID", _tmp18_, &_inner_error0_);
	_g_free0 (_tmp18_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp19_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp19_;
	}
	_tmp20_ = self->priv->remove_game_from_user_collection_query;
	_result_ = sqlite3_step (_tmp20_);
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		GError* _tmp25_;
		gboolean _tmp26_ = FALSE;
		_tmp21_ = games_game_get_name (game);
		_tmp22_ = _tmp21_;
		_tmp23_ = games_collection_get_title ((GamesCollection*) collection);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Failed to remove %s from user collection %s", _tmp22_, _tmp24_);
		_inner_error0_ = _tmp25_;
		g_propagate_error (error, _inner_error0_);
		return _tmp26_;
	}
	result = TRUE;
	return result;
}

gboolean
games_database_rename_user_collection (GamesDatabase* self,
                                       GamesUserCollection* collection,
                                       const gchar* title,
                                       GError** error)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint _result_ = 0;
	sqlite3_stmt* _tmp12_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	_tmp1_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_database_does_user_collection_exist (self, _tmp2_, &_inner_error0_);
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->rename_user_collection_query;
	sqlite3_reset (_tmp5_);
	_tmp6_ = self->priv->rename_user_collection_query;
	games_database_bind_text (_tmp6_, "$TITLE", title, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = self->priv->rename_user_collection_query;
	_tmp9_ = games_collection_get_id ((GamesCollection*) collection);
	_tmp10_ = _tmp9_;
	games_database_bind_text (_tmp8_, "$COLLECTION_ID", _tmp10_, &_inner_error0_);
	_g_free0 (_tmp10_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp11_;
	}
	_tmp12_ = self->priv->rename_user_collection_query;
	_result_ = sqlite3_step (_tmp12_);
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp13_ = games_collection_get_title ((GamesCollection*) collection);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Failed to rename user collection %s", _tmp14_);
		_inner_error0_ = _tmp15_;
		g_propagate_error (error, _inner_error0_);
		return _tmp16_;
	}
	result = TRUE;
	return result;
}

static void
games_database_class_init (GamesDatabaseClass * klass,
                           gpointer klass_data)
{
	games_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesDatabase_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_database_finalize;
}

static void
games_database_instance_init (GamesDatabase * self,
                              gpointer klass)
{
	self->priv = games_database_get_instance_private (self);
}

static void
games_database_finalize (GObject * obj)
{
	GamesDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DATABASE, GamesDatabase);
	_sqlite3_close0 (self->priv->database);
	_sqlite3_finalize0 (self->priv->add_game_query);
	_sqlite3_finalize0 (self->priv->add_game_uri_query);
	_sqlite3_finalize0 (self->priv->update_game_query);
	_sqlite3_finalize0 (self->priv->delete_game_query);
	_sqlite3_finalize0 (self->priv->delete_uri_query);
	_sqlite3_finalize0 (self->priv->find_game_uris_query);
	_sqlite3_finalize0 (self->priv->get_cached_game_query);
	_sqlite3_finalize0 (self->priv->list_cached_games_query);
	_sqlite3_finalize0 (self->priv->add_game_resource_query);
	_sqlite3_finalize0 (self->priv->has_uri_query);
	_sqlite3_finalize0 (self->priv->set_is_favorite_query);
	_sqlite3_finalize0 (self->priv->is_game_favorite_query);
	_sqlite3_finalize0 (self->priv->list_favorite_games_query);
	_sqlite3_finalize0 (self->priv->update_recently_played_game_query);
	_sqlite3_finalize0 (self->priv->list_recently_played_games_query);
	_sqlite3_finalize0 (self->priv->add_user_collection_query);
	_sqlite3_finalize0 (self->priv->add_game_to_user_collection_query);
	_sqlite3_finalize0 (self->priv->does_user_collection_exist_query);
	_sqlite3_finalize0 (self->priv->is_game_in_user_collection_query);
	_sqlite3_finalize0 (self->priv->list_user_collections_query);
	_sqlite3_finalize0 (self->priv->list_games_in_user_collection_query);
	_sqlite3_finalize0 (self->priv->remove_user_collection_query);
	_sqlite3_finalize0 (self->priv->remove_game_from_user_collection_query);
	_sqlite3_finalize0 (self->priv->rename_user_collection_query);
	G_OBJECT_CLASS (games_database_parent_class)->finalize (obj);
}

static GType
games_database_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesDatabase), 0, (GInstanceInitFunc) games_database_instance_init, NULL };
	GType games_database_type_id;
	games_database_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesDatabase", &g_define_type_info, 0);
	GamesDatabase_private_offset = g_type_add_instance_private (games_database_type_id, sizeof (GamesDatabasePrivate));
	return games_database_type_id;
}

GType
games_database_get_type (void)
{
	static volatile gsize games_database_type_id__once = 0;
	if (g_once_init_enter (&games_database_type_id__once)) {
		GType games_database_type_id;
		games_database_type_id = games_database_get_type_once ();
		g_once_init_leave (&games_database_type_id__once, games_database_type_id);
	}
	return games_database_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

