/* map.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from map.vala, do not modify */

/* SPDX-FileCopyrightText: 2010-2025 Mahjongg Contributors*/
/* SPDX-FileCopyrightText: 2010-2013 Robert Ancell*/
/* SPDX-License-Identifier: GPL-2.0-or-later*/

#include <glib-object.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
typedef struct _SlotPrivate SlotPrivate;
typedef struct _ParamSpecSlot ParamSpecSlot;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
typedef struct _MapPrivate MapPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAP_TYPE_ITERATOR (map_iterator_get_type ())
#define MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAP_TYPE_ITERATOR, MapIterator))
#define MAP_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAP_TYPE_ITERATOR, MapIteratorClass))
#define MAP_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAP_TYPE_ITERATOR))
#define MAP_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAP_TYPE_ITERATOR))
#define MAP_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAP_TYPE_ITERATOR, MapIteratorClass))

typedef struct _MapIterator MapIterator;
typedef struct _MapIteratorClass MapIteratorClass;
typedef struct _MapIteratorPrivate MapIteratorPrivate;
#define _map_unref0(var) ((var == NULL) ? NULL : (var = (map_unref (var), NULL)))
typedef struct _MapParamSpecIterator MapParamSpecIterator;
typedef struct _ParamSpecMap ParamSpecMap;

#define TYPE_MAPS (maps_get_type ())
#define MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAPS, Maps))
#define MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAPS, MapsClass))
#define IS_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAPS))
#define IS_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAPS))
#define MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAPS, MapsClass))

typedef struct _Maps Maps;
typedef struct _MapsClass MapsClass;
typedef struct _MapsPrivate MapsPrivate;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef void (*GMarkupParserStartElementFunc) (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer user_data, GError** error);
typedef void (*GMarkupParserEndElementFunc) (GMarkupParseContext* context, const gchar* element_name, gpointer user_data, GError** error);
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))

#define MAPS_TYPE_ITERATOR (maps_iterator_get_type ())
#define MAPS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAPS_TYPE_ITERATOR, MapsIterator))
#define MAPS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAPS_TYPE_ITERATOR, MapsIteratorClass))
#define MAPS_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAPS_TYPE_ITERATOR))
#define MAPS_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAPS_TYPE_ITERATOR))
#define MAPS_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAPS_TYPE_ITERATOR, MapsIteratorClass))

typedef struct _MapsIterator MapsIterator;
typedef struct _MapsIteratorClass MapsIteratorClass;
#define _slot_unref0(var) ((var == NULL) ? NULL : (var = (slot_unref (var), NULL)))
typedef struct _MapsIteratorPrivate MapsIteratorPrivate;
#define _maps_unref0(var) ((var == NULL) ? NULL : (var = (maps_unref (var), NULL)))
typedef struct _MapsParamSpecIterator MapsParamSpecIterator;
typedef struct _ParamSpecMaps ParamSpecMaps;

struct _Slot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GTypeClass parent_class;
	void (*finalize) (Slot *self);
};

struct _ParamSpecSlot {
	GParamSpec parent_instance;
};

struct _Map {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	gint h_overhang;
	gint v_overhang;
};

struct _MapClass {
	GTypeClass parent_class;
	void (*finalize) (Map *self);
};

struct _MapPrivate {
	GList* slots;
	gint _width;
	gint _height;
};

struct _MapIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapIteratorPrivate * priv;
};

struct _MapIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (MapIterator *self);
};

struct _MapIteratorPrivate {
	gint index;
	Map* map;
};

struct _MapParamSpecIterator {
	GParamSpec parent_instance;
};

struct _ParamSpecMap {
	GParamSpec parent_instance;
};

struct _Maps {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapsPrivate * priv;
};

struct _MapsClass {
	GTypeClass parent_class;
	void (*finalize) (Maps *self);
};

struct _MapsPrivate {
	Map** maps;
	gint maps_length1;
	gint _maps_size_;
	Map* map;
	gint layer_z;
};

struct _MapsIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapsIteratorPrivate * priv;
};

struct _MapsIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (MapsIterator *self);
};

struct _MapsIteratorPrivate {
	gint index;
	Maps* maps;
};

struct _MapsParamSpecIterator {
	GParamSpec parent_instance;
};

struct _ParamSpecMaps {
	GParamSpec parent_instance;
};

static gpointer slot_parent_class = NULL;
static gint Map_private_offset;
static gpointer map_parent_class = NULL;
static gint MapIterator_private_offset;
static gpointer map_iterator_parent_class = NULL;
static gint Maps_private_offset;
static gpointer maps_parent_class = NULL;
static gint MapsIterator_private_offset;
static gpointer maps_iterator_parent_class = NULL;

VALA_EXTERN gpointer slot_ref (gpointer instance);
VALA_EXTERN void slot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slot (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_slot (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_slot (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_slot (const GValue* value);
VALA_EXTERN GType slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Slot, slot_unref)
VALA_EXTERN Slot* slot_new (gint x,
                gint y,
                gint layer);
VALA_EXTERN Slot* slot_construct (GType object_type,
                      gint x,
                      gint y,
                      gint layer);
VALA_EXTERN gboolean slot_equals (Slot* self,
                      Slot* b);
static void slot_finalize (Slot * obj);
static GType slot_get_type_once (void);
VALA_EXTERN gpointer map_ref (gpointer instance);
VALA_EXTERN void map_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_map (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags);
VALA_EXTERN void value_set_map (GValue* value,
                    gpointer v_object);
VALA_EXTERN void value_take_map (GValue* value,
                     gpointer v_object);
VALA_EXTERN gpointer value_get_map (const GValue* value);
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, map_unref)
static void _slot_unref0_ (gpointer var);
static inline void _g_list_free__slot_unref0_ (GList* self);
VALA_EXTERN void map_add_slot (Map* self,
                   Slot* slot);
static gint map_compare_slots (Slot* a,
                        Slot* b);
static gint _map_compare_slots_gcompare_func (gconstpointer a,
                                       gconstpointer b);
VALA_EXTERN Slot* map_get_slot (Map* self,
                    gint position);
VALA_EXTERN gpointer map_iterator_ref (gpointer instance);
VALA_EXTERN void map_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* map_param_spec_iterator (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void map_value_set_iterator (GValue* value,
                             gpointer v_object);
VALA_EXTERN void map_value_take_iterator (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer map_value_get_iterator (const GValue* value);
VALA_EXTERN GType map_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MapIterator, map_iterator_unref)
VALA_EXTERN MapIterator* map_iterator (Map* self);
VALA_EXTERN MapIterator* map_iterator_new (Map* map);
VALA_EXTERN MapIterator* map_iterator_construct (GType object_type,
                                     Map* map);
VALA_EXTERN Map* map_new (void);
VALA_EXTERN Map* map_construct (GType object_type);
VALA_EXTERN gint map_get_n_slots (Map* self);
VALA_EXTERN gint map_get_width (Map* self);
VALA_EXTERN gint map_get_height (Map* self);
VALA_EXTERN gboolean map_iterator_next (MapIterator* self);
VALA_EXTERN Slot* map_iterator_get (MapIterator* self);
static void map_iterator_finalize (MapIterator * obj);
static GType map_iterator_get_type_once (void);
static void map_finalize (Map * obj);
static GType map_get_type_once (void);
VALA_EXTERN gpointer maps_ref (gpointer instance);
VALA_EXTERN void maps_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_maps (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_maps (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_maps (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_maps (const GValue* value);
VALA_EXTERN GType maps_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Maps, maps_unref)
VALA_EXTERN gboolean maps_load (Maps* self);
static void maps_start_element_cb (Maps* self,
                            GMarkupParseContext* context,
                            const gchar* element_name,
                            gchar** attribute_names,
                            gint attribute_names_length1,
                            gchar** attribute_values,
                            gint attribute_values_length1,
                            GError** error);
static void _maps_start_element_cb_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                               const gchar* element_name,
                                                               gchar** attribute_names,
                                                               gchar** attribute_values,
                                                               gpointer self,
                                                               GError** error);
static void maps_end_element_cb (Maps* self,
                          GMarkupParseContext* context,
                          const gchar* element_name,
                          GError** error);
static void _maps_end_element_cb_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                           const gchar* element_name,
                                                           gpointer self,
                                                           GError** error);
VALA_EXTERN Map* maps_get_map_by_name (Maps* self,
                           const gchar* name);
VALA_EXTERN Map* maps_get_map_at_position (Maps* self,
                               gint position);
VALA_EXTERN gint maps_get_n_maps (Maps* self);
VALA_EXTERN Map* maps_get_next_map (Maps* self,
                        Map* map);
VALA_EXTERN Map* maps_get_random_map (Maps* self);
VALA_EXTERN gchar* maps_get_map_display_name (Maps* self,
                                  const gchar* score_name);
VALA_EXTERN gpointer maps_iterator_ref (gpointer instance);
VALA_EXTERN void maps_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* maps_param_spec_iterator (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void maps_value_set_iterator (GValue* value,
                              gpointer v_object);
VALA_EXTERN void maps_value_take_iterator (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer maps_value_get_iterator (const GValue* value);
VALA_EXTERN GType maps_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MapsIterator, maps_iterator_unref)
VALA_EXTERN MapsIterator* maps_iterator (Maps* self);
VALA_EXTERN MapsIterator* maps_iterator_new (Maps* maps);
VALA_EXTERN MapsIterator* maps_iterator_construct (GType object_type,
                                       Maps* maps);
static gchar* maps_get_attribute (Maps* self,
                           gchar** attribute_names,
                           gint attribute_names_length1,
                           gchar** attribute_values,
                           gint attribute_values_length1,
                           const gchar* name,
                           const gchar* _default_);
static gdouble maps_get_attribute_d (Maps* self,
                              gchar** attribute_names,
                              gint attribute_names_length1,
                              gchar** attribute_values,
                              gint attribute_values_length1,
                              const gchar* name,
                              gdouble _default_);
static void _vala_array_add14 (Map** * array,
                        gint* length,
                        gint* size,
                        Map* value);
VALA_EXTERN Maps* maps_new (void);
VALA_EXTERN Maps* maps_construct (GType object_type);
VALA_EXTERN gboolean maps_iterator_next (MapsIterator* self);
VALA_EXTERN Map* maps_iterator_get (MapsIterator* self);
static void maps_iterator_finalize (MapsIterator * obj);
static GType maps_iterator_get_type_once (void);
static void maps_finalize (Maps * obj);
static GType maps_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

Slot*
slot_construct (GType object_type,
                gint x,
                gint y,
                gint layer)
{
	Slot* self = NULL;
	self = (Slot*) g_type_create_instance (object_type);
	self->x = x;
	self->y = y;
	self->layer = layer;
	return self;
}

Slot*
slot_new (gint x,
          gint y,
          gint layer)
{
	return slot_construct (TYPE_SLOT, x, y, layer);
}

gboolean
slot_equals (Slot* self,
             Slot* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	if (self->x == b->x) {
		_tmp1_ = self->y == b->y;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->layer == b->layer;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
value_slot_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_slot_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		slot_unref (value->data[0].v_pointer);
	}
}

static void
value_slot_copy_value (const GValue* src_value,
                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = slot_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_slot_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_slot_collect_value (GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Slot * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = slot_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_slot_lcopy_value (const GValue* value,
                        guint n_collect_values,
                        GTypeCValue* collect_values,
                        guint collect_flags)
{
	Slot ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = slot_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_slot (const gchar* name,
                 const gchar* nick,
                 const gchar* blurb,
                 GType object_type,
                 GParamFlags flags)
{
	ParamSpecSlot* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SLOT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_slot (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SLOT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_slot (GValue* value,
                gpointer v_object)
{
	Slot * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SLOT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SLOT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		slot_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		slot_unref (old);
	}
}

void
value_take_slot (GValue* value,
                 gpointer v_object)
{
	Slot * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SLOT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SLOT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		slot_unref (old);
	}
}

static void
slot_class_init (SlotClass * klass,
                 gpointer klass_data)
{
	slot_parent_class = g_type_class_peek_parent (klass);
	((SlotClass *) klass)->finalize = slot_finalize;
}

static void
slot_instance_init (Slot * self,
                    gpointer klass)
{
	self->ref_count = 1;
}

static void
slot_finalize (Slot * obj)
{
	Slot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SLOT, Slot);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
slot_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_slot_init, value_slot_free_value, value_slot_copy_value, value_slot_peek_pointer, "p", value_slot_collect_value, "p", value_slot_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SlotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Slot), 0, (GInstanceInitFunc) slot_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType slot_type_id;
	slot_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Slot", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return slot_type_id;
}

GType
slot_get_type (void)
{
	static gsize slot_type_id__once = 0;
	if (g_once_init_enter (&slot_type_id__once)) {
		GType slot_type_id;
		slot_type_id = slot_get_type_once ();
		g_once_init_leave (&slot_type_id__once, slot_type_id);
	}
	return slot_type_id__once;
}

gpointer
slot_ref (gpointer instance)
{
	Slot * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
slot_unref (gpointer instance)
{
	Slot * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SLOT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
map_get_instance_private (Map* self)
{
	return G_STRUCT_MEMBER_P (self, Map_private_offset);
}

static void
_slot_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (slot_unref (var), NULL));
}

static inline void
_g_list_free__slot_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _slot_unref0_);
}

static gpointer
_slot_ref0 (gpointer self)
{
	return self ? slot_ref (self) : NULL;
}

static gint
_map_compare_slots_gcompare_func (gconstpointer a,
                                  gconstpointer b)
{
	gint result;
	result = map_compare_slots ((Slot*) a, (Slot*) b);
	return result;
}

void
map_add_slot (Map* self,
              Slot* slot)
{
	Slot* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (slot != NULL);
	_tmp0_ = _slot_ref0 (slot);
	self->priv->slots = g_list_insert_sorted (self->priv->slots, _tmp0_, _map_compare_slots_gcompare_func);
}

Slot*
map_get_slot (Map* self,
              gint position)
{
	GList* _tmp0_;
	gconstpointer _tmp1_;
	Slot* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->slots;
	_tmp1_ = g_list_nth_data (_tmp0_, (guint) position);
	result = (Slot*) _tmp1_;
	return result;
}

MapIterator*
map_iterator (Map* self)
{
	MapIterator* _tmp0_;
	MapIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = map_iterator_new (self);
	result = _tmp0_;
	return result;
}

static gint
map_compare_slots (Slot* a,
                   Slot* b)
{
	gint dl = 0;
	gint dx = 0;
	gint dy = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	dl = a->layer - b->layer;
	if (dl != 0) {
		result = dl;
		return result;
	}
	dx = a->x - b->x;
	dy = a->y - b->y;
	if (dx > dy) {
		result = -1;
		return result;
	}
	if (dx < dy) {
		result = 1;
		return result;
	}
	result = dx;
	return result;
}

Map*
map_construct (GType object_type)
{
	Map* self = NULL;
	self = (Map*) g_type_create_instance (object_type);
	return self;
}

Map*
map_new (void)
{
	return map_construct (TYPE_MAP);
}

gint
map_get_n_slots (Map* self)
{
	gint result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->slots;
	result = (gint) g_list_length (_tmp0_);
	return result;
}

gint
map_get_width (Map* self)
{
	gint result;
	gint x = 0;
	gint layer = 0;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->_width > 0) {
		result = self->priv->_width;
		return result;
	}
	x = 0;
	layer = 0;
	_tmp0_ = self->priv->slots;
	{
		GList* slot_collection = NULL;
		GList* slot_it = NULL;
		slot_collection = _tmp0_;
		for (slot_it = slot_collection; slot_it != NULL; slot_it = slot_it->next) {
			Slot* slot = NULL;
			slot = (Slot*) slot_it->data;
			{
				gboolean _tmp1_ = FALSE;
				Slot* _tmp2_;
				_tmp2_ = slot;
				if (_tmp2_->x >= x) {
					Slot* _tmp3_;
					_tmp3_ = slot;
					_tmp1_ = _tmp3_->layer >= layer;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					Slot* _tmp4_;
					Slot* _tmp5_;
					_tmp4_ = slot;
					x = _tmp4_->x;
					_tmp5_ = slot;
					layer = _tmp5_->layer;
				}
			}
		}
	}
	self->h_overhang = layer;
	self->priv->_width = x + 2;
	result = self->priv->_width;
	return result;
}

gint
map_get_height (Map* self)
{
	gint result;
	gint y = 0;
	gint layer = 0;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->_height > 0) {
		result = self->priv->_height;
		return result;
	}
	y = 0;
	layer = 0;
	_tmp0_ = self->priv->slots;
	{
		GList* slot_collection = NULL;
		GList* slot_it = NULL;
		slot_collection = _tmp0_;
		for (slot_it = slot_collection; slot_it != NULL; slot_it = slot_it->next) {
			Slot* slot = NULL;
			slot = (Slot*) slot_it->data;
			{
				Slot* _tmp1_;
				_tmp1_ = slot;
				if (_tmp1_->y > y) {
					Slot* _tmp2_;
					_tmp2_ = slot;
					y = _tmp2_->y;
				} else {
					gboolean _tmp3_ = FALSE;
					Slot* _tmp4_;
					_tmp4_ = slot;
					if (_tmp4_->y == 0) {
						Slot* _tmp5_;
						_tmp5_ = slot;
						_tmp3_ = _tmp5_->layer > layer;
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						Slot* _tmp6_;
						_tmp6_ = slot;
						layer = _tmp6_->layer;
					}
				}
			}
		}
	}
	self->v_overhang = layer;
	self->priv->_height = y + 2;
	result = self->priv->_height;
	return result;
}

static inline gpointer
map_iterator_get_instance_private (MapIterator* self)
{
	return G_STRUCT_MEMBER_P (self, MapIterator_private_offset);
}

static gpointer
_map_ref0 (gpointer self)
{
	return self ? map_ref (self) : NULL;
}

MapIterator*
map_iterator_construct (GType object_type,
                        Map* map)
{
	MapIterator* self = NULL;
	Map* _tmp0_;
	g_return_val_if_fail (map != NULL, NULL);
	self = (MapIterator*) g_type_create_instance (object_type);
	_tmp0_ = _map_ref0 (map);
	_map_unref0 (self->priv->map);
	self->priv->map = _tmp0_;
	return self;
}

MapIterator*
map_iterator_new (Map* map)
{
	return map_iterator_construct (MAP_TYPE_ITERATOR, map);
}

gboolean
map_iterator_next (MapIterator* self)
{
	Map* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->map;
	_tmp1_ = _tmp0_->priv->slots;
	result = ((guint) self->priv->index) < g_list_length (_tmp1_);
	return result;
}

Slot*
map_iterator_get (MapIterator* self)
{
	Map* _tmp0_;
	GList* _tmp1_;
	gint _tmp2_;
	gconstpointer _tmp3_;
	Slot* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = _tmp0_->priv->slots;
	_tmp2_ = self->priv->index;
	self->priv->index = _tmp2_ + 1;
	_tmp3_ = g_list_nth_data (_tmp1_, (guint) _tmp2_);
	result = (Slot*) _tmp3_;
	return result;
}

static void
map_value_iterator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
map_value_iterator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		map_iterator_unref (value->data[0].v_pointer);
	}
}

static void
map_value_iterator_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = map_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
map_value_iterator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
map_value_iterator_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MapIterator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = map_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
map_value_iterator_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	MapIterator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = map_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
map_param_spec_iterator (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	MapParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, MAP_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
map_value_get_iterator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAP_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}

void
map_value_set_iterator (GValue* value,
                        gpointer v_object)
{
	MapIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAP_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MAP_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		map_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		map_iterator_unref (old);
	}
}

void
map_value_take_iterator (GValue* value,
                         gpointer v_object)
{
	MapIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAP_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MAP_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		map_iterator_unref (old);
	}
}

static void
map_iterator_class_init (MapIteratorClass * klass,
                         gpointer klass_data)
{
	map_iterator_parent_class = g_type_class_peek_parent (klass);
	((MapIteratorClass *) klass)->finalize = map_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &MapIterator_private_offset);
}

static void
map_iterator_instance_init (MapIterator * self,
                            gpointer klass)
{
	self->priv = map_iterator_get_instance_private (self);
	self->ref_count = 1;
}

static void
map_iterator_finalize (MapIterator * obj)
{
	MapIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAP_TYPE_ITERATOR, MapIterator);
	g_signal_handlers_destroy (self);
	_map_unref0 (self->priv->map);
}

 G_GNUC_NO_INLINE static GType
map_iterator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { map_value_iterator_init, map_value_iterator_free_value, map_value_iterator_copy_value, map_value_iterator_peek_pointer, "p", map_value_iterator_collect_value, "p", map_value_iterator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MapIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapIterator), 0, (GInstanceInitFunc) map_iterator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType map_iterator_type_id;
	map_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MapIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MapIterator_private_offset = g_type_add_instance_private (map_iterator_type_id, sizeof (MapIteratorPrivate));
	return map_iterator_type_id;
}

GType
map_iterator_get_type (void)
{
	static gsize map_iterator_type_id__once = 0;
	if (g_once_init_enter (&map_iterator_type_id__once)) {
		GType map_iterator_type_id;
		map_iterator_type_id = map_iterator_get_type_once ();
		g_once_init_leave (&map_iterator_type_id__once, map_iterator_type_id);
	}
	return map_iterator_type_id__once;
}

gpointer
map_iterator_ref (gpointer instance)
{
	MapIterator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
map_iterator_unref (gpointer instance)
{
	MapIterator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAP_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_map_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_map_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		map_unref (value->data[0].v_pointer);
	}
}

static void
value_map_copy_value (const GValue* src_value,
                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = map_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_map_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_map_collect_value (GValue* value,
                         guint n_collect_values,
                         GTypeCValue* collect_values,
                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Map * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = map_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_map_lcopy_value (const GValue* value,
                       guint n_collect_values,
                       GTypeCValue* collect_values,
                       guint collect_flags)
{
	Map ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = map_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_map (const gchar* name,
                const gchar* nick,
                const gchar* blurb,
                GType object_type,
                GParamFlags flags)
{
	ParamSpecMap* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_map (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAP), NULL);
	return value->data[0].v_pointer;
}

void
value_set_map (GValue* value,
               gpointer v_object)
{
	Map * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		map_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		map_unref (old);
	}
}

void
value_take_map (GValue* value,
                gpointer v_object)
{
	Map * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		map_unref (old);
	}
}

static void
map_class_init (MapClass * klass,
                gpointer klass_data)
{
	map_parent_class = g_type_class_peek_parent (klass);
	((MapClass *) klass)->finalize = map_finalize;
	g_type_class_adjust_private_offset (klass, &Map_private_offset);
}

static void
map_instance_init (Map * self,
                   gpointer klass)
{
	self->priv = map_get_instance_private (self);
	self->ref_count = 1;
}

static void
map_finalize (Map * obj)
{
	Map * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAP, Map);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->score_name);
	(self->priv->slots == NULL) ? NULL : (self->priv->slots = (_g_list_free__slot_unref0_ (self->priv->slots), NULL));
}

 G_GNUC_NO_INLINE static GType
map_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_map_init, value_map_free_value, value_map_copy_value, value_map_peek_pointer, "p", value_map_collect_value, "p", value_map_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Map), 0, (GInstanceInitFunc) map_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType map_type_id;
	map_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Map", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Map_private_offset = g_type_add_instance_private (map_type_id, sizeof (MapPrivate));
	return map_type_id;
}

GType
map_get_type (void)
{
	static gsize map_type_id__once = 0;
	if (g_once_init_enter (&map_type_id__once)) {
		GType map_type_id;
		map_type_id = map_get_type_once ();
		g_once_init_leave (&map_type_id__once, map_type_id);
	}
	return map_type_id__once;
}

gpointer
map_ref (gpointer instance)
{
	Map * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
map_unref (gpointer instance)
{
	Map * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
maps_get_instance_private (Maps* self)
{
	return G_STRUCT_MEMBER_P (self, Maps_private_offset);
}

static void
_maps_start_element_cb_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                          const gchar* element_name,
                                                          gchar** attribute_names,
                                                          gchar** attribute_values,
                                                          gpointer self,
                                                          GError** error)
{
	maps_start_element_cb ((Maps*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}

static void
_maps_end_element_cb_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                      const gchar* element_name,
                                                      gpointer self,
                                                      GError** error)
{
	maps_end_element_cb ((Maps*) self, context, element_name, error);
}

gboolean
maps_load (Maps* self)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* data = NULL;
	GMarkupParser parser = {0};
	GMarkupParser _tmp11_ = {0};
	GMarkupParseContext* parse_context = NULL;
	GMarkupParser _tmp12_;
	GMarkupParseContext* _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("/org/gnome/Mahjongg/maps/mahjongg.map");
	path = _tmp0_;
	{
		GBytes* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GBytes* _tmp3_;
		gsize _tmp4_ = 0;
		guint8* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = path;
		_tmp3_ = g_resources_lookup_data (_tmp2_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = g_bytes_get_data (_tmp1_, &_tmp4_);
		_tmp6_ = g_strdup ((const gchar*) _tmp5_);
		_g_free0 (data);
		data = _tmp6_;
		_g_bytes_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = path;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("map.vala:139: Could not load map %s: %s\n", _tmp7_, _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (path);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_free0 (data);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	memset (&_tmp11_, 0, sizeof (GMarkupParser));
	_tmp11_.start_element = _maps_start_element_cb_gmarkup_parser_start_element_func;
	_tmp11_.end_element = _maps_end_element_cb_gmarkup_parser_end_element_func;
	parser = _tmp11_;
	_tmp12_ = parser;
	_tmp13_ = g_markup_parse_context_new (&_tmp12_, 0, self, NULL);
	parse_context = _tmp13_;
	{
		GMarkupParseContext* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp14_ = parse_context;
		_tmp15_ = data;
		_tmp16_ = data;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		g_markup_parse_context_parse (_tmp14_, _tmp15_, (gssize) _tmp18_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp19_ = FALSE;
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch1_g_markup_error;
			}
			_g_markup_parse_context_unref0 (parse_context);
			_g_free0 (data);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp19_;
		}
	}
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = path;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("map.vala:152: Could not parse map %s: %s\n", _tmp20_, _tmp22_);
		result = FALSE;
		_g_error_free0 (e);
		_g_markup_parse_context_unref0 (parse_context);
		_g_free0 (data);
		_g_free0 (path);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp23_ = FALSE;
		_g_markup_parse_context_unref0 (parse_context);
		_g_free0 (data);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp23_;
	}
	result = TRUE;
	_g_markup_parse_context_unref0 (parse_context);
	_g_free0 (data);
	_g_free0 (path);
	return result;
}

Map*
maps_get_map_by_name (Maps* self,
                      const gchar* name)
{
	Map** _tmp0_;
	gint _tmp0__length1;
	Map* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->maps;
	_tmp0__length1 = self->priv->maps_length1;
	{
		Map** map_collection = NULL;
		gint map_collection_length1 = 0;
		gint _map_collection_size_ = 0;
		gint map_it = 0;
		map_collection = _tmp0_;
		map_collection_length1 = _tmp0__length1;
		for (map_it = 0; map_it < map_collection_length1; map_it = map_it + 1) {
			Map* map = NULL;
			map = map_collection[map_it];
			{
				Map* _tmp1_;
				const gchar* _tmp2_;
				_tmp1_ = map;
				_tmp2_ = _tmp1_->name;
				if (g_strcmp0 (_tmp2_, name) == 0) {
					Map* _tmp3_;
					_tmp3_ = map;
					result = _tmp3_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

Map*
maps_get_map_at_position (Maps* self,
                          gint position)
{
	gboolean _tmp0_ = FALSE;
	Map** _tmp3_;
	gint _tmp3__length1;
	Map* _tmp4_;
	Map* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (position < 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = maps_get_n_maps (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = position >= _tmp2_;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->maps;
	_tmp3__length1 = self->priv->maps_length1;
	_tmp4_ = _tmp3_[position];
	result = _tmp4_;
	return result;
}

Map*
maps_get_next_map (Maps* self,
                   Map* map)
{
	gint map_index = 0;
	Map** _tmp0_;
	gint _tmp0__length1;
	gint next_map_index = 0;
	gint _tmp3_;
	gint _tmp4_;
	Map* _tmp5_;
	Map* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (map != NULL, NULL);
	map_index = 0;
	_tmp0_ = self->priv->maps;
	_tmp0__length1 = self->priv->maps_length1;
	{
		Map** m_collection = NULL;
		gint m_collection_length1 = 0;
		gint _m_collection_size_ = 0;
		gint m_it = 0;
		m_collection = _tmp0_;
		m_collection_length1 = _tmp0__length1;
		for (m_it = 0; m_it < m_collection_length1; m_it = m_it + 1) {
			Map* m = NULL;
			m = m_collection[m_it];
			{
				Map* _tmp1_;
				gint _tmp2_;
				_tmp1_ = m;
				if (_tmp1_ == map) {
					break;
				}
				_tmp2_ = map_index;
				map_index = _tmp2_ + 1;
			}
		}
	}
	_tmp3_ = maps_get_n_maps (self);
	_tmp4_ = _tmp3_;
	next_map_index = (map_index + 1) % ((gint) _tmp4_);
	_tmp5_ = maps_get_map_at_position (self, next_map_index);
	result = _tmp5_;
	return result;
}

Map*
maps_get_random_map (Maps* self)
{
	gint32 map_index = 0;
	gint _tmp0_;
	gint _tmp1_;
	Map* _tmp2_;
	Map* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = maps_get_n_maps (self);
	_tmp1_ = _tmp0_;
	map_index = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp1_));
	_tmp2_ = maps_get_map_at_position (self, (gint) map_index);
	result = _tmp2_;
	return result;
}

gchar*
maps_get_map_display_name (Maps* self,
                           const gchar* score_name)
{
	gchar* display_name = NULL;
	gchar* _tmp0_;
	Map** _tmp1_;
	gint _tmp1__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (score_name != NULL, NULL);
	_tmp0_ = g_strdup (score_name);
	display_name = _tmp0_;
	_tmp1_ = self->priv->maps;
	_tmp1__length1 = self->priv->maps_length1;
	{
		Map** map_collection = NULL;
		gint map_collection_length1 = 0;
		gint _map_collection_size_ = 0;
		gint map_it = 0;
		map_collection = _tmp1_;
		map_collection_length1 = _tmp1__length1;
		for (map_it = 0; map_it < map_collection_length1; map_it = map_it + 1) {
			Map* _tmp2_;
			Map* map = NULL;
			_tmp2_ = _map_ref0 (map_collection[map_it]);
			map = _tmp2_;
			{
				Map* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = map;
				_tmp4_ = _tmp3_->score_name;
				if (g_strcmp0 (_tmp4_, score_name) == 0) {
					Map* _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp5_ = map;
					_tmp6_ = _tmp5_->name;
					_tmp7_ = g_strdup (g_dpgettext2 (NULL, "mahjongg map name", _tmp6_));
					_g_free0 (display_name);
					display_name = _tmp7_;
					_map_unref0 (map);
					break;
				}
				_map_unref0 (map);
			}
		}
	}
	result = display_name;
	return result;
}

MapsIterator*
maps_iterator (Maps* self)
{
	MapsIterator* _tmp0_;
	MapsIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = maps_iterator_new (self);
	result = _tmp0_;
	return result;
}

static gchar*
maps_get_attribute (Maps* self,
                    gchar** attribute_names,
                    gint attribute_names_length1,
                    gchar** attribute_values,
                    gint attribute_values_length1,
                    const gchar* name,
                    const gchar* _default_)
{
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attribute_names[i];
				if (!(_tmp2_ != NULL)) {
					break;
				}
				_tmp3_ = attribute_names[i];
				_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, name) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = attribute_values[i];
					_tmp8_ = g_strdup (_tmp7_);
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	_tmp9_ = g_strdup (_default_);
	result = _tmp9_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gdouble
maps_get_attribute_d (Maps* self,
                      gchar** attribute_names,
                      gint attribute_names_length1,
                      gchar** attribute_values,
                      gint attribute_values_length1,
                      const gchar* name,
                      gdouble _default_)
{
	gchar* a = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	_tmp0_ = maps_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, name, NULL);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = a;
		result = double_parse (_tmp2_);
		_g_free0 (a);
		return result;
	}
	result = _default_;
	_g_free0 (a);
	return result;
}

static void
maps_start_element_cb (Maps* self,
                       GMarkupParseContext* context,
                       const gchar* element_name,
                       gchar** attribute_names,
                       gint attribute_names_length1,
                       gchar** attribute_values,
                       gint attribute_values_length1,
                       GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	Map* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GQuark _tmp12_ = 0U;
	static GQuark _tmp11_label0 = 0;
	static GQuark _tmp11_label1 = 0;
	static GQuark _tmp11_label2 = 0;
	static GQuark _tmp11_label3 = 0;
	static GQuark _tmp11_label4 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (element_name != NULL);
	_tmp0_ = g_utf8_strdown (element_name, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "map") == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		Map* _tmp3_;
		Map* _tmp4_;
		gchar* _tmp5_;
		Map* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = map_new ();
		_map_unref0 (self->priv->map);
		self->priv->map = _tmp3_;
		_tmp4_ = self->priv->map;
		_tmp5_ = maps_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "name", "");
		_g_free0 (_tmp4_->name);
		_tmp4_->name = _tmp5_;
		_tmp6_ = self->priv->map;
		_tmp7_ = maps_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "scorename", "");
		_g_free0 (_tmp6_->score_name);
		_tmp6_->score_name = _tmp7_;
		return;
	}
	_tmp8_ = self->priv->map;
	if (_tmp8_ == NULL) {
		return;
	}
	_tmp9_ = g_utf8_strdown (element_name, (gssize) -1);
	_tmp10_ = _tmp9_;
	_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
	g_free (_tmp10_);
	if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string ("layer")))) {
		switch (0) {
			default:
			{
				self->priv->layer_z = (gint) maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", 0.0);
				break;
			}
		}
	} else if (_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("row")))) {
		switch (0) {
			default:
			{
				gint x1 = 0;
				gint x2 = 0;
				gint y = 0;
				gint z = 0;
				x1 = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "left", 0.0) * 2);
				x2 = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "right", 0.0) * 2);
				y = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "y", 0.0) * 2);
				z = (gint) maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", (gdouble) self->priv->layer_z);
				{
					gboolean _tmp13_ = FALSE;
					_tmp13_ = TRUE;
					while (TRUE) {
						Map* _tmp14_;
						Slot* _tmp15_;
						Slot* _tmp16_;
						if (!_tmp13_) {
							x1 += 2;
						}
						_tmp13_ = FALSE;
						if (!(x1 <= x2)) {
							break;
						}
						_tmp14_ = self->priv->map;
						_tmp15_ = slot_new (x1, y, z);
						_tmp16_ = _tmp15_;
						map_add_slot (_tmp14_, _tmp16_);
						_slot_unref0 (_tmp16_);
					}
				}
				break;
			}
		}
	} else if (_tmp12_ == ((0 != _tmp11_label2) ? _tmp11_label2 : (_tmp11_label2 = g_quark_from_static_string ("column")))) {
		switch (0) {
			default:
			{
				gint x = 0;
				gint y1 = 0;
				gint y2 = 0;
				gint z = 0;
				x = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "x", 0.0) * 2);
				y1 = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "top", 0.0) * 2);
				y2 = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "bottom", 0.0) * 2);
				z = (gint) maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", (gdouble) self->priv->layer_z);
				{
					gboolean _tmp17_ = FALSE;
					_tmp17_ = TRUE;
					while (TRUE) {
						Map* _tmp18_;
						Slot* _tmp19_;
						Slot* _tmp20_;
						if (!_tmp17_) {
							y1 += 2;
						}
						_tmp17_ = FALSE;
						if (!(y1 <= y2)) {
							break;
						}
						_tmp18_ = self->priv->map;
						_tmp19_ = slot_new (x, y1, z);
						_tmp20_ = _tmp19_;
						map_add_slot (_tmp18_, _tmp20_);
						_slot_unref0 (_tmp20_);
					}
				}
				break;
			}
		}
	} else if (_tmp12_ == ((0 != _tmp11_label3) ? _tmp11_label3 : (_tmp11_label3 = g_quark_from_static_string ("block")))) {
		switch (0) {
			default:
			{
				gint x1 = 0;
				gint x2 = 0;
				gint y1 = 0;
				gint y2 = 0;
				gint z = 0;
				x1 = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "left", 0.0) * 2);
				x2 = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "right", 0.0) * 2);
				y1 = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "top", 0.0) * 2);
				y2 = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "bottom", 0.0) * 2);
				z = (gint) maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", (gdouble) self->priv->layer_z);
				{
					gboolean _tmp21_ = FALSE;
					_tmp21_ = TRUE;
					while (TRUE) {
						if (!_tmp21_) {
							x1 += 2;
						}
						_tmp21_ = FALSE;
						if (!(x1 <= x2)) {
							break;
						}
						{
							gint y = 0;
							y = y1;
							{
								gboolean _tmp22_ = FALSE;
								_tmp22_ = TRUE;
								while (TRUE) {
									Map* _tmp23_;
									Slot* _tmp24_;
									Slot* _tmp25_;
									if (!_tmp22_) {
										y += 2;
									}
									_tmp22_ = FALSE;
									if (!(y <= y2)) {
										break;
									}
									_tmp23_ = self->priv->map;
									_tmp24_ = slot_new (x1, y, z);
									_tmp25_ = _tmp24_;
									map_add_slot (_tmp23_, _tmp25_);
									_slot_unref0 (_tmp25_);
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp12_ == ((0 != _tmp11_label4) ? _tmp11_label4 : (_tmp11_label4 = g_quark_from_static_string ("tile")))) {
		switch (0) {
			default:
			{
				gint x = 0;
				gint y = 0;
				gint z = 0;
				Map* _tmp26_;
				Slot* _tmp27_;
				Slot* _tmp28_;
				x = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "x", 0.0) * 2);
				y = (gint) (maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "y", 0.0) * 2);
				z = (gint) maps_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", (gdouble) self->priv->layer_z);
				_tmp26_ = self->priv->map;
				_tmp27_ = slot_new (x, y, z);
				_tmp28_ = _tmp27_;
				map_add_slot (_tmp26_, _tmp28_);
				_slot_unref0 (_tmp28_);
				break;
			}
		}
	}
}

static void
_vala_array_add14 (Map** * array,
                   gint* length,
                   gint* size,
                   Map* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Map*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
maps_end_element_cb (Maps* self,
                     GMarkupParseContext* context,
                     const gchar* element_name,
                     GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (element_name != NULL);
	_tmp0_ = g_utf8_strdown (element_name, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("map")))) {
		switch (0) {
			default:
			{
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				Map* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp6_ = self->priv->map;
				_tmp7_ = map_get_n_slots (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_ > 0) {
					Map* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					_tmp9_ = self->priv->map;
					_tmp10_ = map_get_n_slots (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp5_ = _tmp11_ <= 144;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					Map* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = self->priv->map;
					_tmp13_ = map_get_n_slots (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp4_ = (_tmp14_ % 2) == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					Map* _tmp15_;
					Map* _tmp16_;
					_tmp15_ = self->priv->map;
					_tmp16_ = _map_ref0 (_tmp15_);
					_vala_array_add14 (&self->priv->maps, &self->priv->maps_length1, &self->priv->_maps_size_, _tmp16_);
				} else {
					Map* _tmp17_;
					const gchar* _tmp18_;
					Map* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					_tmp17_ = self->priv->map;
					_tmp18_ = _tmp17_->name;
					_tmp19_ = self->priv->map;
					_tmp20_ = map_get_n_slots (_tmp19_);
					_tmp21_ = _tmp20_;
					g_warning ("map.vala:283: Invalid map %s with %d slots", _tmp18_, _tmp21_);
				}
				_map_unref0 (self->priv->map);
				self->priv->map = NULL;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("layer")))) {
		switch (0) {
			default:
			{
				self->priv->layer_z = 0;
				break;
			}
		}
	}
}

Maps*
maps_construct (GType object_type)
{
	Maps* self = NULL;
	self = (Maps*) g_type_create_instance (object_type);
	return self;
}

Maps*
maps_new (void)
{
	return maps_construct (TYPE_MAPS);
}

gint
maps_get_n_maps (Maps* self)
{
	gint result;
	Map** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->maps;
	_tmp0__length1 = self->priv->maps_length1;
	result = _tmp0__length1;
	return result;
}

static inline gpointer
maps_iterator_get_instance_private (MapsIterator* self)
{
	return G_STRUCT_MEMBER_P (self, MapsIterator_private_offset);
}

static gpointer
_maps_ref0 (gpointer self)
{
	return self ? maps_ref (self) : NULL;
}

MapsIterator*
maps_iterator_construct (GType object_type,
                         Maps* maps)
{
	MapsIterator* self = NULL;
	Maps* _tmp0_;
	g_return_val_if_fail (maps != NULL, NULL);
	self = (MapsIterator*) g_type_create_instance (object_type);
	_tmp0_ = _maps_ref0 (maps);
	_maps_unref0 (self->priv->maps);
	self->priv->maps = _tmp0_;
	return self;
}

MapsIterator*
maps_iterator_new (Maps* maps)
{
	return maps_iterator_construct (MAPS_TYPE_ITERATOR, maps);
}

gboolean
maps_iterator_next (MapsIterator* self)
{
	Maps* _tmp0_;
	Map** _tmp1_;
	gint _tmp1__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->maps;
	_tmp1_ = _tmp0_->priv->maps;
	_tmp1__length1 = _tmp0_->priv->maps_length1;
	result = self->priv->index < _tmp1__length1;
	return result;
}

Map*
maps_iterator_get (MapsIterator* self)
{
	Maps* _tmp0_;
	Map** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	Map* _tmp3_;
	Map* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = _tmp0_->priv->maps;
	_tmp1__length1 = _tmp0_->priv->maps_length1;
	_tmp2_ = self->priv->index;
	self->priv->index = _tmp2_ + 1;
	_tmp3_ = _tmp1_[_tmp2_];
	result = _tmp3_;
	return result;
}

static void
maps_value_iterator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
maps_value_iterator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		maps_iterator_unref (value->data[0].v_pointer);
	}
}

static void
maps_value_iterator_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = maps_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
maps_value_iterator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
maps_value_iterator_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MapsIterator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = maps_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
maps_value_iterator_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	MapsIterator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = maps_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
maps_param_spec_iterator (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	MapsParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, MAPS_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
maps_value_get_iterator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAPS_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}

void
maps_value_set_iterator (GValue* value,
                         gpointer v_object)
{
	MapsIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAPS_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MAPS_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		maps_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		maps_iterator_unref (old);
	}
}

void
maps_value_take_iterator (GValue* value,
                          gpointer v_object)
{
	MapsIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAPS_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MAPS_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		maps_iterator_unref (old);
	}
}

static void
maps_iterator_class_init (MapsIteratorClass * klass,
                          gpointer klass_data)
{
	maps_iterator_parent_class = g_type_class_peek_parent (klass);
	((MapsIteratorClass *) klass)->finalize = maps_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &MapsIterator_private_offset);
}

static void
maps_iterator_instance_init (MapsIterator * self,
                             gpointer klass)
{
	self->priv = maps_iterator_get_instance_private (self);
	self->ref_count = 1;
}

static void
maps_iterator_finalize (MapsIterator * obj)
{
	MapsIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAPS_TYPE_ITERATOR, MapsIterator);
	g_signal_handlers_destroy (self);
	_maps_unref0 (self->priv->maps);
}

 G_GNUC_NO_INLINE static GType
maps_iterator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { maps_value_iterator_init, maps_value_iterator_free_value, maps_value_iterator_copy_value, maps_value_iterator_peek_pointer, "p", maps_value_iterator_collect_value, "p", maps_value_iterator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MapsIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maps_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapsIterator), 0, (GInstanceInitFunc) maps_iterator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType maps_iterator_type_id;
	maps_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MapsIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MapsIterator_private_offset = g_type_add_instance_private (maps_iterator_type_id, sizeof (MapsIteratorPrivate));
	return maps_iterator_type_id;
}

GType
maps_iterator_get_type (void)
{
	static gsize maps_iterator_type_id__once = 0;
	if (g_once_init_enter (&maps_iterator_type_id__once)) {
		GType maps_iterator_type_id;
		maps_iterator_type_id = maps_iterator_get_type_once ();
		g_once_init_leave (&maps_iterator_type_id__once, maps_iterator_type_id);
	}
	return maps_iterator_type_id__once;
}

gpointer
maps_iterator_ref (gpointer instance)
{
	MapsIterator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
maps_iterator_unref (gpointer instance)
{
	MapsIterator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAPS_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_maps_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_maps_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		maps_unref (value->data[0].v_pointer);
	}
}

static void
value_maps_copy_value (const GValue* src_value,
                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = maps_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_maps_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_maps_collect_value (GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Maps * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = maps_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_maps_lcopy_value (const GValue* value,
                        guint n_collect_values,
                        GTypeCValue* collect_values,
                        guint collect_flags)
{
	Maps ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = maps_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_maps (const gchar* name,
                 const gchar* nick,
                 const gchar* blurb,
                 GType object_type,
                 GParamFlags flags)
{
	ParamSpecMaps* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAPS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_maps (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAPS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_maps (GValue* value,
                gpointer v_object)
{
	Maps * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAPS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAPS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		maps_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		maps_unref (old);
	}
}

void
value_take_maps (GValue* value,
                 gpointer v_object)
{
	Maps * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAPS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAPS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		maps_unref (old);
	}
}

static void
maps_class_init (MapsClass * klass,
                 gpointer klass_data)
{
	maps_parent_class = g_type_class_peek_parent (klass);
	((MapsClass *) klass)->finalize = maps_finalize;
	g_type_class_adjust_private_offset (klass, &Maps_private_offset);
}

static void
maps_instance_init (Maps * self,
                    gpointer klass)
{
	self->priv = maps_get_instance_private (self);
	self->ref_count = 1;
}

static void
maps_finalize (Maps * obj)
{
	Maps * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAPS, Maps);
	g_signal_handlers_destroy (self);
	self->priv->maps = (_vala_array_free (self->priv->maps, self->priv->maps_length1, (GDestroyNotify) map_unref), NULL);
	_map_unref0 (self->priv->map);
}

 G_GNUC_NO_INLINE static GType
maps_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_maps_init, value_maps_free_value, value_maps_copy_value, value_maps_peek_pointer, "p", value_maps_collect_value, "p", value_maps_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MapsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maps_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Maps), 0, (GInstanceInitFunc) maps_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType maps_type_id;
	maps_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Maps", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Maps_private_offset = g_type_add_instance_private (maps_type_id, sizeof (MapsPrivate));
	return maps_type_id;
}

GType
maps_get_type (void)
{
	static gsize maps_type_id__once = 0;
	if (g_once_init_enter (&maps_type_id__once)) {
		GType maps_type_id;
		maps_type_id = maps_get_type_once ();
		g_once_init_leave (&maps_type_id__once, maps_type_id);
	}
	return maps_type_id__once;
}

gpointer
maps_ref (gpointer instance)
{
	Maps * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
maps_unref (gpointer instance)
{
	Maps * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAPS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

