/* libsudoku.h generated by valac 0.56.18-dirty, the Vala compiler, do not modify */

#ifndef __LIB_LIBSUDOKU_H__
#define __LIB_LIBSUDOKU_H__

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;
typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN = 0,
	DIFFICULTY_CATEGORY_EASY = 1,
	DIFFICULTY_CATEGORY_MEDIUM = 2,
	DIFFICULTY_CATEGORY_HARD = 3,
	DIFFICULTY_CATEGORY_VERY_HARD = 4,
	DIFFICULTY_CATEGORY_CUSTOM = 5
} DifficultyCategory;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;
typedef enum  {
	STACK_ACTION_NONE,
	STACK_ACTION_INSERT,
	STACK_ACTION_REMOVE,
	STACK_ACTION_ENABLE_EARMARK,
	STACK_ACTION_DISABLE_EARMARK,
	STACK_ACTION_DISABLE_ALL_EARMARKS,
	STACK_ACTION_INSERT_AND_DISABLE_RELATED_EARMARKS,
	STACK_ACTION_ENABLE_ALL_EARMARK_POSSIBILITIES,
	STACK_ACTION_CLEAR_BOARD
} StackAction;

#define TYPE_STACK_ACTION (stack_action_get_type ())
typedef enum  {
	GAME_MODE_NONE,
	GAME_MODE_PLAY,
	GAME_MODE_CREATE
} GameMode;

#define TYPE_GAME_MODE (game_mode_get_type ())

#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

struct _SudokuSaver {
	GObject parent_instance;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GObjectClass parent_class;
};

VALA_EXTERN GType sudoku_board_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuBoard, g_object_unref)
VALA_EXTERN gboolean sudoku_board_is_empty (SudokuBoard* self);
VALA_EXTERN gboolean sudoku_board_is_fully_filled (SudokuBoard* self);
VALA_EXTERN SudokuBoard* sudoku_board_new (void);
VALA_EXTERN SudokuBoard* sudoku_board_construct (GType object_type);
VALA_EXTERN SudokuBoard* sudoku_board_clone (SudokuBoard* self);
VALA_EXTERN gint sudoku_board_get (SudokuBoard* self,
                       gint row,
                       gint col);
VALA_EXTERN gboolean* sudoku_board_get_earmarks (SudokuBoard* self,
                                     gint row,
                                     gint col,
                                     gint* result_length1);
VALA_EXTERN gboolean sudoku_board_get_is_fixed (SudokuBoard* self,
                                    gint row,
                                    gint col);
VALA_EXTERN gint sudoku_board_get_solution (SudokuBoard* self,
                                gint row,
                                gint col);
VALA_EXTERN gint* sudoku_board_get_cells (SudokuBoard* self,
                              gint* result_length1,
                              gint* result_length2);
VALA_EXTERN gint* sudoku_board_get_possibilities (SudokuBoard* self,
                                      gint row,
                                      gint col,
                                      gint* result_length1);
VALA_EXTERN gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self,
                                                        gint row,
                                                        gint col,
                                                        gint* result_length1);
VALA_EXTERN void sudoku_board_set (SudokuBoard* self,
                       gint row,
                       gint col,
                       gint val);
VALA_EXTERN void sudoku_board_set_all_fixed (SudokuBoard* self);
VALA_EXTERN void sudoku_board_enable_earmark (SudokuBoard* self,
                                  gint row,
                                  gint col,
                                  gint num);
VALA_EXTERN void sudoku_board_disable_earmark (SudokuBoard* self,
                                   gint row,
                                   gint col,
                                   gint num);
VALA_EXTERN void sudoku_board_disable_all_earmarks (SudokuBoard* self,
                                        gint row,
                                        gint col);
VALA_EXTERN gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self,
                                          gint row,
                                          gint col,
                                          gint num);
VALA_EXTERN gboolean sudoku_board_is_possible (SudokuBoard* self,
                                   gint row,
                                   gint col,
                                   gint val);
VALA_EXTERN void sudoku_board_insert (SudokuBoard* self,
                          gint row,
                          gint col,
                          gint val,
                          gboolean is_fixed);
VALA_EXTERN void sudoku_board_remove (SudokuBoard* self,
                          gint row,
                          gint col);
VALA_EXTERN void sudoku_board_solve (SudokuBoard* self);
VALA_EXTERN gboolean sudoku_board_solved (SudokuBoard* self);
VALA_EXTERN gint sudoku_board_count_solutions_limited (SudokuBoard* self);
VALA_EXTERN gchar* sudoku_board_to_string (SudokuBoard* self);
VALA_EXTERN gboolean sudoku_board_is_finished (SudokuBoard* self);
VALA_EXTERN gboolean sudoku_board_has_earmarks (SudokuBoard* self,
                                    gint row,
                                    gint col);
VALA_EXTERN gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
VALA_EXTERN void sudoku_board_set_previous_played_time (SudokuBoard* self,
                                            gdouble value);
VALA_EXTERN GType difficulty_category_get_type (void) G_GNUC_CONST ;
VALA_EXTERN DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
VALA_EXTERN void sudoku_board_set_difficulty_category (SudokuBoard* self,
                                           DifficultyCategory value);
VALA_EXTERN gint sudoku_board_get_block_rows (SudokuBoard* self);
VALA_EXTERN gint sudoku_board_get_block_cols (SudokuBoard* self);
VALA_EXTERN gint sudoku_board_get_rows (SudokuBoard* self);
VALA_EXTERN gint sudoku_board_get_cols (SudokuBoard* self);
VALA_EXTERN gint sudoku_board_get_max_val (SudokuBoard* self);
VALA_EXTERN gint sudoku_board_get_filled (SudokuBoard* self);
VALA_EXTERN gint sudoku_board_get_fixed (SudokuBoard* self);
VALA_EXTERN gboolean sudoku_board_get_complete (SudokuBoard* self);
VALA_EXTERN GType coord_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Coord* coord_dup (const Coord* self);
VALA_EXTERN void coord_free (Coord* self);
VALA_EXTERN GeeSet* sudoku_board_get_broken_coords (SudokuBoard* self);
VALA_EXTERN GeeList* sudoku_board_get_coords_for_col (SudokuBoard* self);
VALA_EXTERN GeeList* sudoku_board_get_coords_for_row (SudokuBoard* self);
VALA_EXTERN GeeMap* sudoku_board_get_coords_for_block (SudokuBoard* self);
VALA_EXTERN void coord_init (Coord *self,
                 gint row,
                 gint col);
VALA_EXTERN gint coord_hash (Coord* coord);
VALA_EXTERN gboolean coord_equal (Coord* a,
                      Coord* b);
VALA_EXTERN gchar* difficulty_category_to_string (DifficultyCategory self);
VALA_EXTERN gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
VALA_EXTERN DifficultyCategory difficulty_category_from_string (const gchar* input);
VALA_EXTERN GType sudoku_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGame, g_object_unref)
VALA_EXTERN gboolean sudoku_game_is_undostack_null (SudokuGame* self);
VALA_EXTERN gboolean sudoku_game_is_redostack_null (SudokuGame* self);
VALA_EXTERN SudokuGame* sudoku_game_new (SudokuBoard* board);
VALA_EXTERN SudokuGame* sudoku_game_construct (GType object_type,
                                   SudokuBoard* board);
VALA_EXTERN void sudoku_game_change_board (SudokuGame* self,
                               SudokuBoard* board);
VALA_EXTERN void sudoku_game_enable_earmark (SudokuGame* self,
                                 gint row,
                                 gint col,
                                 gint num);
VALA_EXTERN void sudoku_game_disable_earmark (SudokuGame* self,
                                  gint row,
                                  gint col,
                                  gint num);
VALA_EXTERN void sudoku_game_disable_all_earmarks (SudokuGame* self,
                                       gint row,
                                       gint col);
VALA_EXTERN void sudoku_game_insert (SudokuGame* self,
                         gint row,
                         gint col,
                         gint val);
VALA_EXTERN void sudoku_game_remove (SudokuGame* self,
                         gint row,
                         gint col);
VALA_EXTERN void sudoku_game_insert_and_disable_related_earmarks (SudokuGame* self,
                                                      gint row,
                                                      gint col,
                                                      gint val);
VALA_EXTERN GType stack_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StackAction sudoku_game_get_current_stack_action (SudokuGame* self);
VALA_EXTERN void sudoku_game_toggle_pause (SudokuGame* self);
VALA_EXTERN gboolean sudoku_game_is_empty (SudokuGame* self);
VALA_EXTERN void sudoku_game_reset (SudokuGame* self);
VALA_EXTERN void sudoku_game_undo (SudokuGame* self);
VALA_EXTERN void sudoku_game_redo (SudokuGame* self);
VALA_EXTERN void sudoku_game_enable_all_earmark_possibilities (SudokuGame* self);
VALA_EXTERN void sudoku_game_stack_slice (SudokuGame* self);
VALA_EXTERN gdouble sudoku_game_get_total_time_played (SudokuGame* self);
VALA_EXTERN gdouble sudoku_game_get_elapsed_time (SudokuGame* self);
VALA_EXTERN void sudoku_game_start_clock (SudokuGame* self);
VALA_EXTERN void sudoku_game_stop_clock (SudokuGame* self);
VALA_EXTERN void sudoku_game_resume_clock (SudokuGame* self);
VALA_EXTERN SudokuBoard* sudoku_game_get_board (SudokuGame* self);
VALA_EXTERN GType game_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameMode sudoku_game_get_mode (SudokuGame* self);
VALA_EXTERN void sudoku_game_set_mode (SudokuGame* self,
                           GameMode value);
VALA_EXTERN gboolean sudoku_game_get_paused (SudokuGame* self);
VALA_EXTERN gboolean stack_action_is_single_value_change (StackAction self);
VALA_EXTERN gboolean stack_action_is_single_earmarks_change (StackAction self);
VALA_EXTERN void sudoku_generator_generate_boards_async (gint nboards,
                                             DifficultyCategory category,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_,
                                                  GError** error);
VALA_EXTERN void sudoku_generator_print_stats (SudokuBoard* board);
VALA_EXTERN gchar* sudoku_generator_qqwing_version (void);
VALA_EXTERN GType sudoku_saver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuSaver, g_object_unref)
VALA_EXTERN SudokuSaver* sudoku_saver_new (void);
VALA_EXTERN SudokuSaver* sudoku_saver_construct (GType object_type);
VALA_EXTERN gdouble* sudoku_saver_get_highscore (SudokuSaver* self,
                                     DifficultyCategory difficulty);
VALA_EXTERN void sudoku_saver_save_highscore (SudokuSaver* self,
                                  DifficultyCategory difficulty,
                                  gdouble time_elapsed);
VALA_EXTERN SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
VALA_EXTERN void sudoku_saver_save_game (SudokuSaver* self,
                             SudokuGame* game);
VALA_EXTERN void sudoku_saver_delete_save (SudokuSaver* self);
VALA_EXTERN void sudoku_saver_add_game_to_finished (SudokuSaver* self,
                                        SudokuGame* game,
                                        gboolean delete_savegame,
                                        gboolean save_timer);
VALA_EXTERN const gchar* sudoku_saver_get_savegame_file (void);
VALA_EXTERN const gchar* sudoku_saver_get_finishgame_dir (void);
VALA_EXTERN const gchar* sudoku_saver_get_highscores_file (void);

G_END_DECLS

#endif
