/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_hdlc_framer_pb = R"doc(HDLC framer which takes in PMT binary blobs and outputs HDLC frames as unpacked bits, with CRC and bit stuffing added. The first sample of the frame is tagged with the tag frame_tag_name and includes a length field for tagged_stream use.

This block outputs one whole frame at a time; if there is not enough output buffer space to fit a frame, it is pushed onto a queue. As a result flowgraphs which only run for a finite number of samples may not receive all frames in the queue, due to the scheduler's granularity. For flowgraphs that stream continuously (anything using a USRP) this should not be an issue.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of digital::hdlc_framer.

Args:
    frame_tag_name : The tag to add to the first sample of each frame.)doc";


static const char* __doc_gr_digital_hdlc_framer_pb_hdlc_framer_pb = R"doc()doc";


static const char* __doc_gr_digital_hdlc_framer_pb_make = R"doc(HDLC framer which takes in PMT binary blobs and outputs HDLC frames as unpacked bits, with CRC and bit stuffing added. The first sample of the frame is tagged with the tag frame_tag_name and includes a length field for tagged_stream use.

This block outputs one whole frame at a time; if there is not enough output buffer space to fit a frame, it is pushed onto a queue. As a result flowgraphs which only run for a finite number of samples may not receive all frames in the queue, due to the scheduler's granularity. For flowgraphs that stream continuously (anything using a USRP) this should not be an issue.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of digital::hdlc_framer.

Args:
    frame_tag_name : The tag to add to the first sample of each frame.)doc";
