/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_unpack_k_bits_bb = R"doc(Converts a byte with k relevant bits to k output bytes with 1 bit in the LSB.

This block picks the K least significant bits from a byte, and expands them into K bytes of 0 or 1.


Example: k = 4 in = [0xf5, 0x08] out = [0,1,0,1, 1,0,0,0]

Constructor Specific Documentation:

Make an unpack_k_bits block.

Args:
    k : number of bits to unpack.)doc";


static const char* __doc_gr_blocks_unpack_k_bits_bb_unpack_k_bits_bb = R"doc()doc";


static const char* __doc_gr_blocks_unpack_k_bits_bb_make = R"doc(Converts a byte with k relevant bits to k output bytes with 1 bit in the LSB.

This block picks the K least significant bits from a byte, and expands them into K bytes of 0 or 1.


Example: k = 4 in = [0xf5, 0x08] out = [0,1,0,1, 1,0,0,0]

Constructor Specific Documentation:

Make an unpack_k_bits block.

Args:
    k : number of bits to unpack.)doc";
