/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_packet_sink = R"doc(process received bits looking for packet sync, header, and process bits into packet

input: stream of symbols to be sliced.


output: none. Pushes assembled packet into target queue


The packet sink takes in a stream of binary symbols that are sliced around 0. The bits are then checked for the  to determine find and decode the packet. It then expects a fixed length header of 2 16-bit shorts containing the payload length, followed by the payload. If the 2 16-bit shorts are not identical, this packet is ignored. Better algs are welcome.


This block is not very useful anymore as it only works with 2-level modulations such as BPSK or GMSK. The block can generally be replaced with a correlate access code and frame sink blocks.

Constructor Specific Documentation:

Make a packet_sink block.

Args:
    sync_vector : The synchronization vector as a vector of 1's and 0's.
    target_queue : The message queue that packets are sent to.
    threshold : Number of bits that can be incorrect in the .)doc";


static const char* __doc_gr_digital_packet_sink_packet_sink_0 = R"doc()doc";


static const char* __doc_gr_digital_packet_sink_packet_sink_1 = R"doc()doc";


static const char* __doc_gr_digital_packet_sink_make = R"doc(process received bits looking for packet sync, header, and process bits into packet

input: stream of symbols to be sliced.


output: none. Pushes assembled packet into target queue


The packet sink takes in a stream of binary symbols that are sliced around 0. The bits are then checked for the  to determine find and decode the packet. It then expects a fixed length header of 2 16-bit shorts containing the payload length, followed by the payload. If the 2 16-bit shorts are not identical, this packet is ignored. Better algs are welcome.


This block is not very useful anymore as it only works with 2-level modulations such as BPSK or GMSK. The block can generally be replaced with a correlate access code and frame sink blocks.

Constructor Specific Documentation:

Make a packet_sink block.

Args:
    sync_vector : The synchronization vector as a vector of 1's and 0's.
    target_queue : The message queue that packets are sent to.
    threshold : Number of bits that can be incorrect in the .)doc";


static const char* __doc_gr_digital_packet_sink_carrier_sensed = R"doc(return true if we detect carrier)doc";
