/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbs2_interleaver_bb = R"doc(Bit interleaves DVB-S2 FEC baseband frames.

Input: Normal or short FEC baseband frames with appended LPDC (LDPCFEC). 
Output: Bit interleaved baseband frames.

Constructor Specific Documentation:

Create a DVB-S2 bit interleaver.

Args:
    framesize : FEC frame size (normal or short).
    rate : FEC code rate.
    constellation : DVB-S2 constellation.)doc";


static const char* __doc_gr_dtv_dvbs2_interleaver_bb_dvbs2_interleaver_bb = R"doc()doc";


static const char* __doc_gr_dtv_dvbs2_interleaver_bb_make = R"doc(Bit interleaves DVB-S2 FEC baseband frames.

Input: Normal or short FEC baseband frames with appended LPDC (LDPCFEC). 
Output: Bit interleaved baseband frames.

Constructor Specific Documentation:

Create a DVB-S2 bit interleaver.

Args:
    framesize : FEC frame size (normal or short).
    rate : FEC code rate.
    constellation : DVB-S2 constellation.)doc";
