{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Cairo.Structs.RectangleInt
    ( 

-- * Exported types
    RectangleInt(..)                        ,
    newZeroRectangleInt                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveRectangleIntMethod               ,
#endif



 -- * Properties


-- ** height #attr:height#
-- | /No description available in the introspection data./

    getRectangleIntHeight                   ,
#if defined(ENABLE_OVERLOADING)
    rectangleInt_height                     ,
#endif
    setRectangleIntHeight                   ,


-- ** width #attr:width#
-- | /No description available in the introspection data./

    getRectangleIntWidth                    ,
#if defined(ENABLE_OVERLOADING)
    rectangleInt_width                      ,
#endif
    setRectangleIntWidth                    ,


-- ** x #attr:x#
-- | /No description available in the introspection data./

    getRectangleIntX                        ,
#if defined(ENABLE_OVERLOADING)
    rectangleInt_x                          ,
#endif
    setRectangleIntX                        ,


-- ** y #attr:y#
-- | /No description available in the introspection data./

    getRectangleIntY                        ,
#if defined(ENABLE_OVERLOADING)
    rectangleInt_y                          ,
#endif
    setRectangleIntY                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype RectangleInt = RectangleInt (SP.ManagedPtr RectangleInt)
    deriving (Eq)

instance SP.ManagedPtrNewtype RectangleInt where
    toManagedPtr (RectangleInt p) = p

foreign import ccall "cairo_gobject_rectangle_int_get_type" c_cairo_gobject_rectangle_int_get_type :: 
    IO GType

type instance O.ParentTypes RectangleInt = '[]
instance O.HasParentTypes RectangleInt

instance B.Types.TypedObject RectangleInt where
    glibType = c_cairo_gobject_rectangle_int_get_type

instance B.Types.GBoxed RectangleInt

-- | Convert t'RectangleInt' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe RectangleInt) where
    gvalueGType_ = c_cairo_gobject_rectangle_int_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr RectangleInt)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr RectangleInt)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed RectangleInt ptr
        else return P.Nothing
        
    

-- | Construct a t'RectangleInt' struct initialized to zero.
newZeroRectangleInt :: MonadIO m => m RectangleInt
newZeroRectangleInt = liftIO $ callocBoxedBytes 16 >>= wrapBoxed RectangleInt

instance tag ~ 'AttrSet => Constructible RectangleInt tag where
    new _ attrs = do
        o <- newZeroRectangleInt
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rectangleInt #x
-- @
getRectangleIntX :: MonadIO m => RectangleInt -> m Int32
getRectangleIntX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' rectangleInt [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setRectangleIntX :: MonadIO m => RectangleInt -> Int32 -> m ()
setRectangleIntX s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data RectangleIntXFieldInfo
instance AttrInfo RectangleIntXFieldInfo where
    type AttrBaseTypeConstraint RectangleIntXFieldInfo = (~) RectangleInt
    type AttrAllowedOps RectangleIntXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint RectangleIntXFieldInfo = (~) Int32
    type AttrTransferTypeConstraint RectangleIntXFieldInfo = (~)Int32
    type AttrTransferType RectangleIntXFieldInfo = Int32
    type AttrGetType RectangleIntXFieldInfo = Int32
    type AttrLabel RectangleIntXFieldInfo = "x"
    type AttrOrigin RectangleIntXFieldInfo = RectangleInt
    attrGet = getRectangleIntX
    attrSet = setRectangleIntX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.RectangleInt.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-RectangleInt.html#g:attr:x"
        })

rectangleInt_x :: AttrLabelProxy "x"
rectangleInt_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rectangleInt #y
-- @
getRectangleIntY :: MonadIO m => RectangleInt -> m Int32
getRectangleIntY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' rectangleInt [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setRectangleIntY :: MonadIO m => RectangleInt -> Int32 -> m ()
setRectangleIntY s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data RectangleIntYFieldInfo
instance AttrInfo RectangleIntYFieldInfo where
    type AttrBaseTypeConstraint RectangleIntYFieldInfo = (~) RectangleInt
    type AttrAllowedOps RectangleIntYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint RectangleIntYFieldInfo = (~) Int32
    type AttrTransferTypeConstraint RectangleIntYFieldInfo = (~)Int32
    type AttrTransferType RectangleIntYFieldInfo = Int32
    type AttrGetType RectangleIntYFieldInfo = Int32
    type AttrLabel RectangleIntYFieldInfo = "y"
    type AttrOrigin RectangleIntYFieldInfo = RectangleInt
    attrGet = getRectangleIntY
    attrSet = setRectangleIntY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.RectangleInt.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-RectangleInt.html#g:attr:y"
        })

rectangleInt_y :: AttrLabelProxy "y"
rectangleInt_y = AttrLabelProxy

#endif


-- | Get the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rectangleInt #width
-- @
getRectangleIntWidth :: MonadIO m => RectangleInt -> m Int32
getRectangleIntWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' rectangleInt [ #width 'Data.GI.Base.Attributes.:=' value ]
-- @
setRectangleIntWidth :: MonadIO m => RectangleInt -> Int32 -> m ()
setRectangleIntWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data RectangleIntWidthFieldInfo
instance AttrInfo RectangleIntWidthFieldInfo where
    type AttrBaseTypeConstraint RectangleIntWidthFieldInfo = (~) RectangleInt
    type AttrAllowedOps RectangleIntWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint RectangleIntWidthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint RectangleIntWidthFieldInfo = (~)Int32
    type AttrTransferType RectangleIntWidthFieldInfo = Int32
    type AttrGetType RectangleIntWidthFieldInfo = Int32
    type AttrLabel RectangleIntWidthFieldInfo = "width"
    type AttrOrigin RectangleIntWidthFieldInfo = RectangleInt
    attrGet = getRectangleIntWidth
    attrSet = setRectangleIntWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.RectangleInt.width"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-RectangleInt.html#g:attr:width"
        })

rectangleInt_width :: AttrLabelProxy "width"
rectangleInt_width = AttrLabelProxy

#endif


-- | Get the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rectangleInt #height
-- @
getRectangleIntHeight :: MonadIO m => RectangleInt -> m Int32
getRectangleIntHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' rectangleInt [ #height 'Data.GI.Base.Attributes.:=' value ]
-- @
setRectangleIntHeight :: MonadIO m => RectangleInt -> Int32 -> m ()
setRectangleIntHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data RectangleIntHeightFieldInfo
instance AttrInfo RectangleIntHeightFieldInfo where
    type AttrBaseTypeConstraint RectangleIntHeightFieldInfo = (~) RectangleInt
    type AttrAllowedOps RectangleIntHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint RectangleIntHeightFieldInfo = (~) Int32
    type AttrTransferTypeConstraint RectangleIntHeightFieldInfo = (~)Int32
    type AttrTransferType RectangleIntHeightFieldInfo = Int32
    type AttrGetType RectangleIntHeightFieldInfo = Int32
    type AttrLabel RectangleIntHeightFieldInfo = "height"
    type AttrOrigin RectangleIntHeightFieldInfo = RectangleInt
    attrGet = getRectangleIntHeight
    attrSet = setRectangleIntHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.RectangleInt.height"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-RectangleInt.html#g:attr:height"
        })

rectangleInt_height :: AttrLabelProxy "height"
rectangleInt_height = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList RectangleInt
type instance O.AttributeList RectangleInt = RectangleIntAttributeList
type RectangleIntAttributeList = ('[ '("x", RectangleIntXFieldInfo), '("y", RectangleIntYFieldInfo), '("width", RectangleIntWidthFieldInfo), '("height", RectangleIntHeightFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveRectangleIntMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRectangleIntMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRectangleIntMethod t RectangleInt, O.OverloadedMethod info RectangleInt p) => OL.IsLabel t (RectangleInt -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRectangleIntMethod t RectangleInt, O.OverloadedMethod info RectangleInt p, R.HasField t RectangleInt p) => R.HasField t RectangleInt p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRectangleIntMethod t RectangleInt, O.OverloadedMethodInfo info RectangleInt) => OL.IsLabel t (O.MethodProxy info RectangleInt) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


