

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Functions
    ( 

 -- * Methods


-- ** cairoDrawFromGl #method:cairoDrawFromGl#

    cairoDrawFromGl                         ,


-- ** cairoRectangle #method:cairoRectangle#

    cairoRectangle                          ,


-- ** cairoRegion #method:cairoRegion#

    cairoRegion                             ,


-- ** cairoRegionCreateFromSurface #method:cairoRegionCreateFromSurface#

    cairoRegionCreateFromSurface            ,


-- ** cairoSetSourcePixbuf #method:cairoSetSourcePixbuf#

    cairoSetSourcePixbuf                    ,


-- ** cairoSetSourceRgba #method:cairoSetSourceRgba#

    cairoSetSourceRgba                      ,


-- ** contentDeserializeAsync #method:contentDeserializeAsync#

    contentDeserializeAsync                 ,


-- ** contentDeserializeFinish #method:contentDeserializeFinish#

    contentDeserializeFinish                ,


-- ** contentRegisterDeserializer #method:contentRegisterDeserializer#

    contentRegisterDeserializer             ,


-- ** contentRegisterSerializer #method:contentRegisterSerializer#

    contentRegisterSerializer               ,


-- ** contentSerializeAsync #method:contentSerializeAsync#

    contentSerializeAsync                   ,


-- ** contentSerializeFinish #method:contentSerializeFinish#

    contentSerializeFinish                  ,


-- ** eventsGetAngle #method:eventsGetAngle#

    eventsGetAngle                          ,


-- ** eventsGetCenter #method:eventsGetCenter#

    eventsGetCenter                         ,


-- ** eventsGetDistance #method:eventsGetDistance#

    eventsGetDistance                       ,


-- ** internMimeType #method:internMimeType#

    internMimeType                          ,


-- ** keyvalConvertCase #method:keyvalConvertCase#

    keyvalConvertCase                       ,


-- ** keyvalFromName #method:keyvalFromName#

    keyvalFromName                          ,


-- ** keyvalIsLower #method:keyvalIsLower#

    keyvalIsLower                           ,


-- ** keyvalIsUpper #method:keyvalIsUpper#

    keyvalIsUpper                           ,


-- ** keyvalName #method:keyvalName#

    keyvalName                              ,


-- ** keyvalToLower #method:keyvalToLower#

    keyvalToLower                           ,


-- ** keyvalToUnicode #method:keyvalToUnicode#

    keyvalToUnicode                         ,


-- ** keyvalToUpper #method:keyvalToUpper#

    keyvalToUpper                           ,


-- ** pixbufGetFromSurface #method:pixbufGetFromSurface#

    pixbufGetFromSurface                    ,


-- ** pixbufGetFromTexture #method:pixbufGetFromTexture#

    pixbufGetFromTexture                    ,


-- ** setAllowedBackends #method:setAllowedBackends#

    setAllowedBackends                      ,


-- ** unicodeToKeyval #method:unicodeToKeyval#

    unicodeToKeyval                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- function unicode_to_keyval
-- Args: [ Arg
--           { argCName = "wc"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_unicode_to_keyval" gdk_unicode_to_keyval :: 
    Word32 ->                               -- wc : TBasicType TUInt32
    IO Word32

-- | Converts from a Unicode character to a key symbol.
unicodeToKeyval ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@wc@/: a Unicode character
    -> m Word32
    -- ^ __Returns:__ the corresponding GDK key symbol, if one exists,
    --   or, if there is no corresponding symbol, @wc | 0x01000000@
unicodeToKeyval wc = liftIO $ do
    result <- gdk_unicode_to_keyval wc
    return result


-- function set_allowed_backends
-- Args: [ Arg
--           { argCName = "backends"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a comma-separated list of backends"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_set_allowed_backends" gdk_set_allowed_backends :: 
    CString ->                              -- backends : TBasicType TUTF8
    IO ()

-- | Sets a list of backends that GDK should try to use.
-- 
-- This can be useful if your application does not
-- work with certain GDK backends.
-- 
-- By default, GDK tries all included backends.
-- 
-- For example:
-- 
-- 
-- === /c code/
-- >gdk_set_allowed_backends ("wayland,macos,*");
-- 
-- 
-- instructs GDK to try the Wayland backend first, followed by the
-- MacOs backend, and then all others.
-- 
-- If the @GDK_BACKEND@ environment variable is set, it determines
-- what backends are tried in what order, while still respecting the
-- set of allowed backends that are specified by this function.
-- 
-- The possible backend names are:
-- 
-- * @broadway@
-- * @macos@
-- * @wayland@.
-- * @win32@
-- * @x11@
-- 
-- 
-- You can also include a @*@ in the list to try all remaining backends.
-- 
-- This call must happen prior to functions that open a display, such
-- as 'GI.Gdk.Objects.Display.displayOpen', @gtk_init()@, or @gtk_init_check()@
-- in order to take effect.
setAllowedBackends ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@backends@/: a comma-separated list of backends
    -> m ()
setAllowedBackends backends = liftIO $ do
    backends' <- textToCString backends
    gdk_set_allowed_backends backends'
    freeMem backends'
    return ()


-- function pixbuf_get_from_texture
-- Args: [ Arg
--           { argCName = "texture"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Texture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkTexture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_get_from_texture" gdk_pixbuf_get_from_texture :: 
    Ptr Gdk.Texture.Texture ->              -- texture : TInterface (Name {namespace = "Gdk", name = "Texture"})
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

{-# DEPRECATED pixbufGetFromTexture ["(Since version 4.12)","Use t'GI.Gdk.Objects.Texture.Texture' and subclasses instead","  cairo surfaces and pixbufs"] #-}
-- | Creates a new pixbuf from /@texture@/.
-- 
-- This should generally not be used in newly written code as later
-- stages will almost certainly convert the pixbuf back into a texture
-- to draw it on screen.
pixbufGetFromTexture ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Texture.IsTexture a) =>
    a
    -- ^ /@texture@/: a @GdkTexture@
    -> m (Maybe GdkPixbuf.Pixbuf.Pixbuf)
    -- ^ __Returns:__ a new @GdkPixbuf@
pixbufGetFromTexture texture = liftIO $ do
    texture' <- unsafeManagedPtrCastPtr texture
    result <- gdk_pixbuf_get_from_texture texture'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GdkPixbuf.Pixbuf.Pixbuf) result'
        return result''
    touchManagedPtr texture
    return maybeResult


-- function pixbuf_get_from_surface
-- Args: [ Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "surface to copy from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Source X coordinate within @surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Source Y coordinate within @surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Width in pixels of region to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Height in pixels of region to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_get_from_surface" gdk_pixbuf_get_from_surface :: 
    Ptr Cairo.Surface.Surface ->            -- surface : TInterface (Name {namespace = "cairo", name = "Surface"})
    Int32 ->                                -- src_x : TBasicType TInt
    Int32 ->                                -- src_y : TBasicType TInt
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

{-# DEPRECATED pixbufGetFromSurface ["(Since version 4.12)","Use t'GI.Gdk.Objects.Texture.Texture' and subclasses instead","  cairo surfaces and pixbufs"] #-}
-- | Transfers image data from a @cairo_surface_t@ and converts it
-- to a @GdkPixbuf@.
-- 
-- This allows you to efficiently read individual pixels from cairo surfaces.
-- 
-- This function will create an RGB pixbuf with 8 bits per channel.
-- The pixbuf will contain an alpha channel if the /@surface@/ contains one.
pixbufGetFromSurface ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Surface.Surface
    -- ^ /@surface@/: surface to copy from
    -> Int32
    -- ^ /@srcX@/: Source X coordinate within /@surface@/
    -> Int32
    -- ^ /@srcY@/: Source Y coordinate within /@surface@/
    -> Int32
    -- ^ /@width@/: Width in pixels of region to get
    -> Int32
    -- ^ /@height@/: Height in pixels of region to get
    -> m (Maybe GdkPixbuf.Pixbuf.Pixbuf)
    -- ^ __Returns:__ A newly-created pixbuf with a
    --   reference count of 1
pixbufGetFromSurface surface srcX srcY width height = liftIO $ do
    surface' <- unsafeManagedPtrGetPtr surface
    result <- gdk_pixbuf_get_from_surface surface' srcX srcY width height
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GdkPixbuf.Pixbuf.Pixbuf) result'
        return result''
    touchManagedPtr surface
    return maybeResult


-- function keyval_to_upper
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_to_upper" gdk_keyval_to_upper :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO Word32

-- | Converts a key value to upper case, if applicable.
keyvalToUpper ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value.
    -> m Word32
    -- ^ __Returns:__ the upper case form of /@keyval@/, or /@keyval@/ itself if it is already
    --   in upper case or it is not subject to case conversion.
keyvalToUpper keyval = liftIO $ do
    result <- gdk_keyval_to_upper keyval
    return result


-- function keyval_to_unicode
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a GDK key symbol" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_to_unicode" gdk_keyval_to_unicode :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO Word32

-- | Converts from a GDK key symbol to the corresponding Unicode
-- character.
-- 
-- Note that the conversion does not take the current locale
-- into consideration, which might be expected for particular
-- keyvals, such as @GDK_KEY_KP_Decimal@.
keyvalToUnicode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a GDK key symbol
    -> m Word32
    -- ^ __Returns:__ the corresponding unicode character, or 0 if there
    --   is no corresponding character.
keyvalToUnicode keyval = liftIO $ do
    result <- gdk_keyval_to_unicode keyval
    return result


-- function keyval_to_lower
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_to_lower" gdk_keyval_to_lower :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO Word32

-- | Converts a key value to lower case, if applicable.
keyvalToLower ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value.
    -> m Word32
    -- ^ __Returns:__ the lower case form of /@keyval@/, or /@keyval@/ itself if it is already
    --  in lower case or it is not subject to case conversion.
keyvalToLower keyval = liftIO $ do
    result <- gdk_keyval_to_lower keyval
    return result


-- function keyval_name
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_name" gdk_keyval_name :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO CString

-- | Converts a key value into a symbolic name.
-- 
-- The names are the same as those in the
-- @gdk\/gdkkeysyms.h@ header file
-- but without the leading “GDK_KEY_”.
keyvalName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string containing the name
    --   of the key
keyvalName keyval = liftIO $ do
    result <- gdk_keyval_name keyval
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult


-- function keyval_is_upper
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_is_upper" gdk_keyval_is_upper :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO CInt

-- | Returns true if the given key value is in upper case.
keyvalIsUpper ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value.
    -> m Bool
    -- ^ __Returns:__ true if /@keyval@/ is in upper case, or if /@keyval@/ is not subject to
    --  case conversion.
keyvalIsUpper keyval = liftIO $ do
    result <- gdk_keyval_is_upper keyval
    let result' = (/= 0) result
    return result'


-- function keyval_is_lower
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_is_lower" gdk_keyval_is_lower :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO CInt

-- | Returns true if the given key value is in lower case.
keyvalIsLower ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value.
    -> m Bool
    -- ^ __Returns:__ true if /@keyval@/ is in lower case, or if /@keyval@/ is not
    --   subject to case conversion.
keyvalIsLower keyval = liftIO $ do
    result <- gdk_keyval_is_lower keyval
    let result' = (/= 0) result
    return result'


-- function keyval_from_name
-- Args: [ Arg
--           { argCName = "keyval_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_from_name" gdk_keyval_from_name :: 
    CString ->                              -- keyval_name : TBasicType TUTF8
    IO Word32

-- | Converts a key name to a key value.
-- 
-- The names are the same as those in the
-- @gdk\/gdkkeysyms.h@ header file
-- but without the leading “GDK_KEY_”.
keyvalFromName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@keyvalName@/: a key name
    -> m Word32
    -- ^ __Returns:__ the corresponding key value, or @GDK_KEY_VoidSymbol@
    --   if the key name is not a valid key
keyvalFromName keyvalName = liftIO $ do
    keyvalName' <- textToCString keyvalName
    result <- gdk_keyval_from_name keyvalName'
    freeMem keyvalName'
    return result


-- function keyval_convert_case
-- Args: [ Arg
--           { argCName = "symbol"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a keyval" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lower"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for lowercase version of @symbol"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "upper"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for uppercase version of @symbol"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_convert_case" gdk_keyval_convert_case :: 
    Word32 ->                               -- symbol : TBasicType TUInt
    Ptr Word32 ->                           -- lower : TBasicType TUInt
    Ptr Word32 ->                           -- upper : TBasicType TUInt
    IO ()

-- | Obtains the upper- and lower-case versions of the keyval /@symbol@/.
-- 
-- Examples of keyvals are @GDK_KEY_a@, @GDK_KEY_Enter@, @GDK_KEY_F1@, etc.
keyvalConvertCase ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@symbol@/: a keyval
    -> m ((Word32, Word32))
keyvalConvertCase symbol = liftIO $ do
    lower <- allocMem :: IO (Ptr Word32)
    upper <- allocMem :: IO (Ptr Word32)
    gdk_keyval_convert_case symbol lower upper
    lower' <- peek lower
    upper' <- peek upper
    freeMem lower
    freeMem upper
    return (lower', upper')


-- function intern_mime_type
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string of a potential mime type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_intern_mime_type" gdk_intern_mime_type :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

-- | Canonicalizes the given mime type and interns the result.
-- 
-- If /@string@/ is not a valid mime type, 'P.Nothing' is returned instead.
-- See RFC 2048 for the syntax if mime types.
internMimeType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: string of a potential mime type
    -> m (Maybe T.Text)
    -- ^ __Returns:__ An interned string for the canonicalized
    --   mime type or 'P.Nothing' if the string wasn\'t a valid mime type
internMimeType string = liftIO $ do
    string' <- textToCString string
    result <- gdk_intern_mime_type string'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    freeMem string'
    return maybeResult


-- function events_get_distance
-- Args: [ Arg
--           { argCName = "event1"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event2"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "distance"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the distance"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_events_get_distance" gdk_events_get_distance :: 
    Ptr Gdk.Event.Event ->                  -- event1 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Event.Event ->                  -- event2 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- distance : TBasicType TDouble
    IO CInt

-- | Returns the distance between the event locations.
-- 
-- This assumes that both events have X\/Y information.
-- If not, this function returns 'P.False'.
eventsGetDistance ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Event.IsEvent a, Gdk.Event.IsEvent b) =>
    a
    -- ^ /@event1@/: first @GdkEvent@
    -> b
    -- ^ /@event2@/: second @GdkEvent@
    -> m ((Bool, Double))
    -- ^ __Returns:__ 'P.True' if the distance could be calculated.
eventsGetDistance event1 event2 = liftIO $ do
    event1' <- unsafeManagedPtrCastPtr event1
    event2' <- unsafeManagedPtrCastPtr event2
    distance <- allocMem :: IO (Ptr CDouble)
    result <- gdk_events_get_distance event1' event2' distance
    let result' = (/= 0) result
    distance' <- peek distance
    let distance'' = realToFrac distance'
    touchManagedPtr event1
    touchManagedPtr event2
    freeMem distance
    return (result', distance'')


-- function events_get_center
-- Args: [ Arg
--           { argCName = "event1"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event2"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the X coordinate of the center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the Y coordinate of the center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_events_get_center" gdk_events_get_center :: 
    Ptr Gdk.Event.Event ->                  -- event1 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Event.Event ->                  -- event2 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- x : TBasicType TDouble
    Ptr CDouble ->                          -- y : TBasicType TDouble
    IO CInt

-- | Returns the point halfway between the events\' positions.
-- 
-- This assumes that both events have X\/Y information.
-- If not, this function returns 'P.False'.
eventsGetCenter ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Event.IsEvent a, Gdk.Event.IsEvent b) =>
    a
    -- ^ /@event1@/: first @GdkEvent@
    -> b
    -- ^ /@event2@/: second @GdkEvent@
    -> m ((Bool, Double, Double))
    -- ^ __Returns:__ 'P.True' if the center could be calculated.
eventsGetCenter event1 event2 = liftIO $ do
    event1' <- unsafeManagedPtrCastPtr event1
    event2' <- unsafeManagedPtrCastPtr event2
    x <- allocMem :: IO (Ptr CDouble)
    y <- allocMem :: IO (Ptr CDouble)
    result <- gdk_events_get_center event1' event2' x y
    let result' = (/= 0) result
    x' <- peek x
    let x'' = realToFrac x'
    y' <- peek y
    let y'' = realToFrac y'
    touchManagedPtr event1
    touchManagedPtr event2
    freeMem x
    freeMem y
    return (result', x'', y'')


-- function events_get_angle
-- Args: [ Arg
--           { argCName = "event1"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event2"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "angle"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the relative angle between both events"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_events_get_angle" gdk_events_get_angle :: 
    Ptr Gdk.Event.Event ->                  -- event1 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Event.Event ->                  -- event2 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- angle : TBasicType TDouble
    IO CInt

-- | Returns the relative angle from /@event1@/ to /@event2@/.
-- 
-- The relative angle is the angle between the X axis and the line
-- through both events\' positions. The rotation direction for positive
-- angles is from the positive X axis towards the positive Y axis.
-- 
-- This assumes that both events have X\/Y information.
-- If not, this function returns 'P.False'.
eventsGetAngle ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Event.IsEvent a, Gdk.Event.IsEvent b) =>
    a
    -- ^ /@event1@/: first @GdkEvent@
    -> b
    -- ^ /@event2@/: second @GdkEvent@
    -> m ((Bool, Double))
    -- ^ __Returns:__ 'P.True' if the angle could be calculated.
eventsGetAngle event1 event2 = liftIO $ do
    event1' <- unsafeManagedPtrCastPtr event1
    event2' <- unsafeManagedPtrCastPtr event2
    angle <- allocMem :: IO (Ptr CDouble)
    result <- gdk_events_get_angle event1' event2' angle
    let result' = (/= 0) result
    angle' <- peek angle
    let angle'' = realToFrac angle'
    touchManagedPtr event1
    touchManagedPtr event2
    freeMem angle
    return (result', angle'')


-- function content_serialize_finish
-- Args: [ Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GAsyncResult`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gdk_content_serialize_finish" gdk_content_serialize_finish :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes a content serialization operation.
contentSerializeFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a) =>
    a
    -- ^ /@result@/: the @GAsyncResult@
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
contentSerializeFinish result_ = liftIO $ do
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ gdk_content_serialize_finish result_'
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )


-- function content_serialize_async
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GOutputStream` to write the serialized content to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the mime type to serialize to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the content to serialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the I/O priority of the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional `GCancellable` object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "callback to call when the operation is done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 6
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to the callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_serialize_async" gdk_content_serialize_async :: 
    Ptr Gio.OutputStream.OutputStream ->    -- stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    CString ->                              -- mime_type : TBasicType TUTF8
    Ptr GValue ->                           -- value : TGValue
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Serialize content and write it to the given output stream, asynchronously.
-- 
-- The default I\/O priority is 'GI.GLib.Constants.PRIORITY_DEFAULT' (i.e. 0), and lower numbers
-- indicate a higher priority.
contentSerializeAsync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.OutputStream.IsOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a @GOutputStream@ to write the serialized content to
    -> T.Text
    -- ^ /@mimeType@/: the mime type to serialize to
    -> GValue
    -- ^ /@value@/: the content to serialize
    -> Int32
    -- ^ /@ioPriority@/: the I\/O priority of the operation
    -> Maybe (b)
    -- ^ /@cancellable@/: optional @GCancellable@ object
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: callback to call when the operation is done
    -> m ()
contentSerializeAsync stream mimeType value ioPriority cancellable callback = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    mimeType' <- textToCString mimeType
    value' <- unsafeManagedPtrGetPtr value
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gdk_content_serialize_async stream' mimeType' value' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr stream
    touchManagedPtr value
    whenJust cancellable touchManagedPtr
    freeMem mimeType'
    return ()


-- function content_register_serializer
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the type of objects that the function can serialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the mime type to serialize to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "serialize"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentSerializeFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the callback" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data that @serialize can access"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_register_serializer" gdk_content_register_serializer :: 
    CGType ->                               -- type : TBasicType TGType
    CString ->                              -- mime_type : TBasicType TUTF8
    FunPtr Gdk.Callbacks.C_ContentSerializeFunc -> -- serialize : TInterface (Name {namespace = "Gdk", name = "ContentSerializeFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Registers a function to serialize objects of a given type.
-- 
-- Since 4.20, when looking up a serializer to use, GTK will
-- use the last registered serializer for a given mime type,
-- so applications can override the built-in serializers.
contentRegisterSerializer ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: the type of objects that the function can serialize
    -> T.Text
    -- ^ /@mimeType@/: the mime type to serialize to
    -> Gdk.Callbacks.ContentSerializeFunc
    -- ^ /@serialize@/: the callback
    -> m ()
contentRegisterSerializer type_ mimeType serialize = liftIO $ do
    let type_' = gtypeToCGType type_
    mimeType' <- textToCString mimeType
    serialize' <- Gdk.Callbacks.mk_ContentSerializeFunc (Gdk.Callbacks.wrap_ContentSerializeFunc Nothing serialize)
    let data_ = castFunPtrToPtr serialize'
    let notify = SP.safeFreeFunPtrPtr
    gdk_content_register_serializer type_' mimeType' serialize' data_ notify
    freeMem mimeType'
    return ()


-- function content_register_deserializer
-- Args: [ Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the mime type which the function can deserialize from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type of objects that the function creates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "deserialize"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializeFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the callback" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data that @deserialize can access"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_register_deserializer" gdk_content_register_deserializer :: 
    CString ->                              -- mime_type : TBasicType TUTF8
    CGType ->                               -- type : TBasicType TGType
    FunPtr Gdk.Callbacks.C_ContentDeserializeFunc -> -- deserialize : TInterface (Name {namespace = "Gdk", name = "ContentDeserializeFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Registers a function to deserialize object of a given type.
-- 
-- Since 4.20, when looking up a deserializer to use, GTK will
-- use the last registered deserializer for a given mime type,
-- so applications can override the built-in deserializers.
contentRegisterDeserializer ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@mimeType@/: the mime type which the function can deserialize from
    -> GType
    -- ^ /@type@/: the type of objects that the function creates
    -> Gdk.Callbacks.ContentDeserializeFunc
    -- ^ /@deserialize@/: the callback
    -> m ()
contentRegisterDeserializer mimeType type_ deserialize = liftIO $ do
    mimeType' <- textToCString mimeType
    let type_' = gtypeToCGType type_
    deserialize' <- Gdk.Callbacks.mk_ContentDeserializeFunc (Gdk.Callbacks.wrap_ContentDeserializeFunc Nothing deserialize)
    let data_ = castFunPtrToPtr deserialize'
    let notify = SP.safeFreeFunPtrPtr
    gdk_content_register_deserializer mimeType' type_' deserialize' data_ notify
    freeMem mimeType'
    return ()


-- function content_deserialize_finish
-- Args: [ Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GAsyncResult`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the result of the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gdk_content_deserialize_finish" gdk_content_deserialize_finish :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr GValue ->                           -- value : TGValue
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes a content deserialization operation.
contentDeserializeFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a) =>
    a
    -- ^ /@result@/: the @GAsyncResult@
    -> m (GValue)
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
contentDeserializeFinish result_ = liftIO $ do
    result_' <- unsafeManagedPtrCastPtr result_
    value <- SP.callocBytes 24 :: IO (Ptr GValue)
    onException (do
        _ <- propagateGError $ gdk_content_deserialize_finish result_' value
        value' <- B.GValue.wrapGValuePtr value
        touchManagedPtr result_
        return value'
     ) (do
        freeMem value
     )


-- function content_deserialize_async
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GInputStream` to read the serialized content from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the mime type to deserialize from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the GType to deserialize from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the I/O priority of the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional `GCancellable` object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "callback to call when the operation is done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 6
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to the callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserialize_async" gdk_content_deserialize_async :: 
    Ptr Gio.InputStream.InputStream ->      -- stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    CString ->                              -- mime_type : TBasicType TUTF8
    CGType ->                               -- type : TBasicType TGType
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Reads content from the given input stream and deserialize it, asynchronously.
-- 
-- The default I\/O priority is @G_PRIORITY_DEFAULT@ (i.e. 0), and lower numbers
-- indicate a higher priority.
contentDeserializeAsync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a @GInputStream@ to read the serialized content from
    -> T.Text
    -- ^ /@mimeType@/: the mime type to deserialize from
    -> GType
    -- ^ /@type@/: the GType to deserialize from
    -> Int32
    -- ^ /@ioPriority@/: the I\/O priority of the operation
    -> Maybe (b)
    -- ^ /@cancellable@/: optional @GCancellable@ object
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: callback to call when the operation is done
    -> m ()
contentDeserializeAsync stream mimeType type_ ioPriority cancellable callback = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    mimeType' <- textToCString mimeType
    let type_' = gtypeToCGType type_
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gdk_content_deserialize_async stream' mimeType' type_' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    freeMem mimeType'
    return ()


-- function cairo_set_source_rgba
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rgba"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkRGBA`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_set_source_rgba" gdk_cairo_set_source_rgba :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.RGBA.RGBA ->                    -- rgba : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    IO ()

-- | Sets the specified @GdkRGBA@ as the source color of /@cr@/.
cairoSetSourceRgba ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> Gdk.RGBA.RGBA
    -- ^ /@rgba@/: a @GdkRGBA@
    -> m ()
cairoSetSourceRgba cr rgba = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    rgba' <- unsafeManagedPtrGetPtr rgba
    gdk_cairo_set_source_rgba cr' rgba'
    touchManagedPtr cr
    touchManagedPtr rgba
    return ()


-- function cairo_set_source_pixbuf
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbuf`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "X coordinate of location to place upper left corner of @pixbuf"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Y coordinate of location to place upper left corner of @pixbuf"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_set_source_pixbuf" gdk_cairo_set_source_pixbuf :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    CDouble ->                              -- pixbuf_x : TBasicType TDouble
    CDouble ->                              -- pixbuf_y : TBasicType TDouble
    IO ()

{-# DEPRECATED cairoSetSourcePixbuf ["(Since version 4.20)","Use @/cairo_set_source_surface()/@ and 'GI.Gdk.Objects.Texture.textureDownload'"] #-}
-- | Sets the given pixbuf as the source pattern for /@cr@/.
-- 
-- The pattern has an extend mode of 'GI.Cairo.Enums.ExtendNone' and is aligned
-- so that the origin of /@pixbuf@/ is /@pixbufX@/, /@pixbufY@/.
cairoSetSourcePixbuf ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> a
    -- ^ /@pixbuf@/: a @GdkPixbuf@
    -> Double
    -- ^ /@pixbufX@/: X coordinate of location to place upper left corner of /@pixbuf@/
    -> Double
    -- ^ /@pixbufY@/: Y coordinate of location to place upper left corner of /@pixbuf@/
    -> m ()
cairoSetSourcePixbuf cr pixbuf pixbufX pixbufY = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    let pixbufX' = realToFrac pixbufX
    let pixbufY' = realToFrac pixbufY
    gdk_cairo_set_source_pixbuf cr' pixbuf' pixbufX' pixbufY'
    touchManagedPtr cr
    touchManagedPtr pixbuf
    return ()


-- function cairo_region_create_from_surface
-- Args: [ Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo surface" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_region_create_from_surface" gdk_cairo_region_create_from_surface :: 
    Ptr Cairo.Surface.Surface ->            -- surface : TInterface (Name {namespace = "cairo", name = "Surface"})
    IO (Ptr Cairo.Region.Region)

-- | Creates region that covers the area where the given
-- /@surface@/ is more than 50% opaque.
-- 
-- This function takes into account device offsets that might be
-- set with @/cairo_surface_set_device_offset()/@.
cairoRegionCreateFromSurface ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Surface.Surface
    -- ^ /@surface@/: a cairo surface
    -> m Cairo.Region.Region
    -- ^ __Returns:__ A @cairo_region_t@
cairoRegionCreateFromSurface surface = liftIO $ do
    surface' <- unsafeManagedPtrGetPtr surface
    result <- gdk_cairo_region_create_from_surface surface'
    checkUnexpectedReturnNULL "cairoRegionCreateFromSurface" result
    result' <- (wrapBoxed Cairo.Region.Region) result
    touchManagedPtr surface
    return result'


-- function cairo_region
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_region_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_region" gdk_cairo_region :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO ()

-- | Adds the given region to the current path of /@cr@/.
cairoRegion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> Cairo.Region.Region
    -- ^ /@region@/: a @cairo_region_t@
    -> m ()
cairoRegion cr region = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    region' <- unsafeManagedPtrGetPtr region
    gdk_cairo_region cr' region'
    touchManagedPtr cr
    touchManagedPtr region
    return ()


-- function cairo_rectangle
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rectangle"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkRectangle`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_rectangle" gdk_cairo_rectangle :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rectangle : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Adds the given rectangle to the current path of /@cr@/.
cairoRectangle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> Gdk.Rectangle.Rectangle
    -- ^ /@rectangle@/: a @GdkRectangle@
    -> m ()
cairoRectangle cr rectangle = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    rectangle' <- unsafeManagedPtrGetPtr rectangle
    gdk_cairo_rectangle cr' rectangle'
    touchManagedPtr cr
    touchManagedPtr rectangle
    return ()


-- function cairo_draw_from_gl
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The surface we're rendering for (not necessarily into)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The GL ID of the source buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_type"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The type of the @source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer_scale"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The scale-factor that the @source buffer is allocated for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The source x position in @source to start copying from in GL coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The source y position in @source to start copying from in GL coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The width of the region to draw"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The height of the region to draw"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_draw_from_gl" gdk_cairo_draw_from_gl :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.Surface.Surface ->              -- surface : TInterface (Name {namespace = "Gdk", name = "Surface"})
    Int32 ->                                -- source : TBasicType TInt
    Int32 ->                                -- source_type : TBasicType TInt
    Int32 ->                                -- buffer_scale : TBasicType TInt
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

{-# DEPRECATED cairoDrawFromGl ["(Since version 4.6)","The function is overly complex and produces broken output","  in various combinations of arguments. If you want to draw with GL textures","  in GTK, use 'GI.Gdk.Objects.GLTexture.gLTextureNew'; if you want to use that texture in","  Cairo, use 'GI.Gdk.Objects.Texture.textureDownload' to download the data into a Cairo","  image surface."] #-}
-- | Draws GL content onto a cairo context.
-- 
-- It takes a render buffer ID (/@sourceType@/ == GL_RENDERBUFFER) or a texture
-- id (/@sourceType@/ == GL_TEXTURE) and draws it onto /@cr@/ with an OVER operation,
-- respecting the current clip. The top left corner of the rectangle specified
-- by /@x@/, /@y@/, /@width@/ and /@height@/ will be drawn at the current (0,0) position of
-- the @cairo_t@.
-- 
-- This will work for *all* @cairo_t@, as long as /@surface@/ is realized, but the
-- fallback implementation that reads back the pixels from the buffer may be
-- used in the general case. In the case of direct drawing to a surface with
-- no special effects applied to /@cr@/ it will however use a more efficient
-- approach.
-- 
-- For GL_RENDERBUFFER the code will always fall back to software for buffers
-- with alpha components, so make sure you use GL_TEXTURE if using alpha.
-- 
-- Calling this may change the current GL context.
cairoDrawFromGl ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Surface.IsSurface a) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> a
    -- ^ /@surface@/: The surface we\'re rendering for (not necessarily into)
    -> Int32
    -- ^ /@source@/: The GL ID of the source buffer
    -> Int32
    -- ^ /@sourceType@/: The type of the /@source@/
    -> Int32
    -- ^ /@bufferScale@/: The scale-factor that the /@source@/ buffer is allocated for
    -> Int32
    -- ^ /@x@/: The source x position in /@source@/ to start copying from in GL coordinates
    -> Int32
    -- ^ /@y@/: The source y position in /@source@/ to start copying from in GL coordinates
    -> Int32
    -- ^ /@width@/: The width of the region to draw
    -> Int32
    -- ^ /@height@/: The height of the region to draw
    -> m ()
cairoDrawFromGl cr surface source sourceType bufferScale x y width height = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    surface' <- unsafeManagedPtrCastPtr surface
    gdk_cairo_draw_from_gl cr' surface' source sourceType bufferScale x y width height
    touchManagedPtr cr
    touchManagedPtr surface
    return ()



