{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GTlsServerConnection@ is the server-side subclass of
-- t'GI.Gio.Objects.TlsConnection.TlsConnection', representing a server-side TLS connection.
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.TlsServerConnection
    ( 

-- * Exported types
    TlsServerConnection(..)                 ,
    IsTlsServerConnection                   ,
    toTlsServerConnection                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearPending]("GI.Gio.Objects.IOStream#g:method:clearPending"), [close]("GI.Gio.Objects.IOStream#g:method:close"), [closeAsync]("GI.Gio.Objects.IOStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.IOStream#g:method:closeFinish"), [emitAcceptCertificate]("GI.Gio.Objects.TlsConnection#g:method:emitAcceptCertificate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [handshake]("GI.Gio.Objects.TlsConnection#g:method:handshake"), [handshakeAsync]("GI.Gio.Objects.TlsConnection#g:method:handshakeAsync"), [handshakeFinish]("GI.Gio.Objects.TlsConnection#g:method:handshakeFinish"), [hasPending]("GI.Gio.Objects.IOStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.IOStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [spliceAsync]("GI.Gio.Objects.IOStream#g:method:spliceAsync"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCertificate]("GI.Gio.Objects.TlsConnection#g:method:getCertificate"), [getChannelBindingData]("GI.Gio.Objects.TlsConnection#g:method:getChannelBindingData"), [getCiphersuiteName]("GI.Gio.Objects.TlsConnection#g:method:getCiphersuiteName"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDatabase]("GI.Gio.Objects.TlsConnection#g:method:getDatabase"), [getInputStream]("GI.Gio.Objects.IOStream#g:method:getInputStream"), [getInteraction]("GI.Gio.Objects.TlsConnection#g:method:getInteraction"), [getNegotiatedProtocol]("GI.Gio.Objects.TlsConnection#g:method:getNegotiatedProtocol"), [getOutputStream]("GI.Gio.Objects.IOStream#g:method:getOutputStream"), [getPeerCertificate]("GI.Gio.Objects.TlsConnection#g:method:getPeerCertificate"), [getPeerCertificateErrors]("GI.Gio.Objects.TlsConnection#g:method:getPeerCertificateErrors"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getProtocolVersion]("GI.Gio.Objects.TlsConnection#g:method:getProtocolVersion"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRehandshakeMode]("GI.Gio.Objects.TlsConnection#g:method:getRehandshakeMode"), [getRequireCloseNotify]("GI.Gio.Objects.TlsConnection#g:method:getRequireCloseNotify"), [getUseSystemCertdb]("GI.Gio.Objects.TlsConnection#g:method:getUseSystemCertdb").
-- 
-- ==== Setters
-- [setAdvertisedProtocols]("GI.Gio.Objects.TlsConnection#g:method:setAdvertisedProtocols"), [setCertificate]("GI.Gio.Objects.TlsConnection#g:method:setCertificate"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDatabase]("GI.Gio.Objects.TlsConnection#g:method:setDatabase"), [setInteraction]("GI.Gio.Objects.TlsConnection#g:method:setInteraction"), [setPending]("GI.Gio.Objects.IOStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRehandshakeMode]("GI.Gio.Objects.TlsConnection#g:method:setRehandshakeMode"), [setRequireCloseNotify]("GI.Gio.Objects.TlsConnection#g:method:setRequireCloseNotify"), [setUseSystemCertdb]("GI.Gio.Objects.TlsConnection#g:method:setUseSystemCertdb").

#if defined(ENABLE_OVERLOADING)
    ResolveTlsServerConnectionMethod        ,
#endif

-- ** new #method:new#

    tlsServerConnectionNew                  ,




 -- * Properties


-- ** authenticationMode #attr:authenticationMode#
-- | The t'GI.Gio.Enums.TlsAuthenticationMode' for the server. This can be changed
-- before calling 'GI.Gio.Objects.TlsConnection.tlsConnectionHandshake' if you want to
-- rehandshake with a different mode from the initial handshake.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsServerConnectionAuthenticationModePropertyInfo,
#endif
    constructTlsServerConnectionAuthenticationMode,
    getTlsServerConnectionAuthenticationMode,
    setTlsServerConnectionAuthenticationMode,
#if defined(ENABLE_OVERLOADING)
    tlsServerConnectionAuthenticationMode   ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsCertificate as Gio.TlsCertificate
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsConnection as Gio.TlsConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsInteraction as Gio.TlsInteraction
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsPassword as Gio.TlsPassword
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsCertificate as Gio.TlsCertificate
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsConnection as Gio.TlsConnection

#endif

-- interface TlsServerConnection 
-- | Memory-managed wrapper type.
newtype TlsServerConnection = TlsServerConnection (SP.ManagedPtr TlsServerConnection)
    deriving (Eq)

instance SP.ManagedPtrNewtype TlsServerConnection where
    toManagedPtr (TlsServerConnection p) = p

foreign import ccall "g_tls_server_connection_get_type"
    c_g_tls_server_connection_get_type :: IO B.Types.GType

instance B.Types.TypedObject TlsServerConnection where
    glibType = c_g_tls_server_connection_get_type

instance B.Types.GObject TlsServerConnection

-- | Type class for types which can be safely cast to t'TlsServerConnection', for instance with `toTlsServerConnection`.
class (SP.GObject o, O.IsDescendantOf TlsServerConnection o) => IsTlsServerConnection o
instance (SP.GObject o, O.IsDescendantOf TlsServerConnection o) => IsTlsServerConnection o

instance O.HasParentTypes TlsServerConnection
type instance O.ParentTypes TlsServerConnection = '[GObject.Object.Object, Gio.TlsConnection.TlsConnection, Gio.IOStream.IOStream]

-- | Cast to t'TlsServerConnection', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTlsServerConnection :: (MIO.MonadIO m, IsTlsServerConnection o) => o -> m TlsServerConnection
toTlsServerConnection = MIO.liftIO . B.ManagedPtr.unsafeCastTo TlsServerConnection

-- | Convert t'TlsServerConnection' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TlsServerConnection) where
    gvalueGType_ = c_g_tls_server_connection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TlsServerConnection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TlsServerConnection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TlsServerConnection ptr
        else return P.Nothing
        
    

-- VVV Prop "authentication-mode"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsAuthenticationMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@authentication-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsServerConnection #authenticationMode
-- @
getTlsServerConnectionAuthenticationMode :: (MonadIO m, IsTlsServerConnection o) => o -> m Gio.Enums.TlsAuthenticationMode
getTlsServerConnectionAuthenticationMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "authentication-mode"

-- | Set the value of the “@authentication-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsServerConnection [ #authenticationMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsServerConnectionAuthenticationMode :: (MonadIO m, IsTlsServerConnection o) => o -> Gio.Enums.TlsAuthenticationMode -> m ()
setTlsServerConnectionAuthenticationMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "authentication-mode" val

-- | Construct a t'GValueConstruct' with valid value for the “@authentication-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsServerConnectionAuthenticationMode :: (IsTlsServerConnection o, MIO.MonadIO m) => Gio.Enums.TlsAuthenticationMode -> m (GValueConstruct o)
constructTlsServerConnectionAuthenticationMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "authentication-mode" val

#if defined(ENABLE_OVERLOADING)
data TlsServerConnectionAuthenticationModePropertyInfo
instance AttrInfo TlsServerConnectionAuthenticationModePropertyInfo where
    type AttrAllowedOps TlsServerConnectionAuthenticationModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TlsServerConnectionAuthenticationModePropertyInfo = IsTlsServerConnection
    type AttrSetTypeConstraint TlsServerConnectionAuthenticationModePropertyInfo = (~) Gio.Enums.TlsAuthenticationMode
    type AttrTransferTypeConstraint TlsServerConnectionAuthenticationModePropertyInfo = (~) Gio.Enums.TlsAuthenticationMode
    type AttrTransferType TlsServerConnectionAuthenticationModePropertyInfo = Gio.Enums.TlsAuthenticationMode
    type AttrGetType TlsServerConnectionAuthenticationModePropertyInfo = Gio.Enums.TlsAuthenticationMode
    type AttrLabel TlsServerConnectionAuthenticationModePropertyInfo = "authentication-mode"
    type AttrOrigin TlsServerConnectionAuthenticationModePropertyInfo = TlsServerConnection
    attrGet = getTlsServerConnectionAuthenticationMode
    attrSet = setTlsServerConnectionAuthenticationMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsServerConnectionAuthenticationMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsServerConnection.authenticationMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsServerConnection.html#g:attr:authenticationMode"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TlsServerConnection
type instance O.AttributeList TlsServerConnection = TlsServerConnectionAttributeList
type TlsServerConnectionAttributeList = ('[ '("advertisedProtocols", Gio.TlsConnection.TlsConnectionAdvertisedProtocolsPropertyInfo), '("authenticationMode", TlsServerConnectionAuthenticationModePropertyInfo), '("baseIoStream", Gio.TlsConnection.TlsConnectionBaseIoStreamPropertyInfo), '("certificate", Gio.TlsConnection.TlsConnectionCertificatePropertyInfo), '("ciphersuiteName", Gio.TlsConnection.TlsConnectionCiphersuiteNamePropertyInfo), '("closed", Gio.IOStream.IOStreamClosedPropertyInfo), '("database", Gio.TlsConnection.TlsConnectionDatabasePropertyInfo), '("inputStream", Gio.IOStream.IOStreamInputStreamPropertyInfo), '("interaction", Gio.TlsConnection.TlsConnectionInteractionPropertyInfo), '("negotiatedProtocol", Gio.TlsConnection.TlsConnectionNegotiatedProtocolPropertyInfo), '("outputStream", Gio.IOStream.IOStreamOutputStreamPropertyInfo), '("peerCertificate", Gio.TlsConnection.TlsConnectionPeerCertificatePropertyInfo), '("peerCertificateErrors", Gio.TlsConnection.TlsConnectionPeerCertificateErrorsPropertyInfo), '("protocolVersion", Gio.TlsConnection.TlsConnectionProtocolVersionPropertyInfo), '("rehandshakeMode", Gio.TlsConnection.TlsConnectionRehandshakeModePropertyInfo), '("requireCloseNotify", Gio.TlsConnection.TlsConnectionRequireCloseNotifyPropertyInfo), '("useSystemCertdb", Gio.TlsConnection.TlsConnectionUseSystemCertdbPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
tlsServerConnectionAuthenticationMode :: AttrLabelProxy "authenticationMode"
tlsServerConnectionAuthenticationMode = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTlsServerConnectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTlsServerConnectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTlsServerConnectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTlsServerConnectionMethod "clearPending" o = Gio.IOStream.IOStreamClearPendingMethodInfo
    ResolveTlsServerConnectionMethod "close" o = Gio.IOStream.IOStreamCloseMethodInfo
    ResolveTlsServerConnectionMethod "closeAsync" o = Gio.IOStream.IOStreamCloseAsyncMethodInfo
    ResolveTlsServerConnectionMethod "closeFinish" o = Gio.IOStream.IOStreamCloseFinishMethodInfo
    ResolveTlsServerConnectionMethod "emitAcceptCertificate" o = Gio.TlsConnection.TlsConnectionEmitAcceptCertificateMethodInfo
    ResolveTlsServerConnectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTlsServerConnectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTlsServerConnectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTlsServerConnectionMethod "handshake" o = Gio.TlsConnection.TlsConnectionHandshakeMethodInfo
    ResolveTlsServerConnectionMethod "handshakeAsync" o = Gio.TlsConnection.TlsConnectionHandshakeAsyncMethodInfo
    ResolveTlsServerConnectionMethod "handshakeFinish" o = Gio.TlsConnection.TlsConnectionHandshakeFinishMethodInfo
    ResolveTlsServerConnectionMethod "hasPending" o = Gio.IOStream.IOStreamHasPendingMethodInfo
    ResolveTlsServerConnectionMethod "isClosed" o = Gio.IOStream.IOStreamIsClosedMethodInfo
    ResolveTlsServerConnectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTlsServerConnectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTlsServerConnectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTlsServerConnectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTlsServerConnectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTlsServerConnectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTlsServerConnectionMethod "spliceAsync" o = Gio.IOStream.IOStreamSpliceAsyncMethodInfo
    ResolveTlsServerConnectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTlsServerConnectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTlsServerConnectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTlsServerConnectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTlsServerConnectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTlsServerConnectionMethod "getCertificate" o = Gio.TlsConnection.TlsConnectionGetCertificateMethodInfo
    ResolveTlsServerConnectionMethod "getChannelBindingData" o = Gio.TlsConnection.TlsConnectionGetChannelBindingDataMethodInfo
    ResolveTlsServerConnectionMethod "getCiphersuiteName" o = Gio.TlsConnection.TlsConnectionGetCiphersuiteNameMethodInfo
    ResolveTlsServerConnectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTlsServerConnectionMethod "getDatabase" o = Gio.TlsConnection.TlsConnectionGetDatabaseMethodInfo
    ResolveTlsServerConnectionMethod "getInputStream" o = Gio.IOStream.IOStreamGetInputStreamMethodInfo
    ResolveTlsServerConnectionMethod "getInteraction" o = Gio.TlsConnection.TlsConnectionGetInteractionMethodInfo
    ResolveTlsServerConnectionMethod "getNegotiatedProtocol" o = Gio.TlsConnection.TlsConnectionGetNegotiatedProtocolMethodInfo
    ResolveTlsServerConnectionMethod "getOutputStream" o = Gio.IOStream.IOStreamGetOutputStreamMethodInfo
    ResolveTlsServerConnectionMethod "getPeerCertificate" o = Gio.TlsConnection.TlsConnectionGetPeerCertificateMethodInfo
    ResolveTlsServerConnectionMethod "getPeerCertificateErrors" o = Gio.TlsConnection.TlsConnectionGetPeerCertificateErrorsMethodInfo
    ResolveTlsServerConnectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTlsServerConnectionMethod "getProtocolVersion" o = Gio.TlsConnection.TlsConnectionGetProtocolVersionMethodInfo
    ResolveTlsServerConnectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTlsServerConnectionMethod "getRehandshakeMode" o = Gio.TlsConnection.TlsConnectionGetRehandshakeModeMethodInfo
    ResolveTlsServerConnectionMethod "getRequireCloseNotify" o = Gio.TlsConnection.TlsConnectionGetRequireCloseNotifyMethodInfo
    ResolveTlsServerConnectionMethod "getUseSystemCertdb" o = Gio.TlsConnection.TlsConnectionGetUseSystemCertdbMethodInfo
    ResolveTlsServerConnectionMethod "setAdvertisedProtocols" o = Gio.TlsConnection.TlsConnectionSetAdvertisedProtocolsMethodInfo
    ResolveTlsServerConnectionMethod "setCertificate" o = Gio.TlsConnection.TlsConnectionSetCertificateMethodInfo
    ResolveTlsServerConnectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTlsServerConnectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTlsServerConnectionMethod "setDatabase" o = Gio.TlsConnection.TlsConnectionSetDatabaseMethodInfo
    ResolveTlsServerConnectionMethod "setInteraction" o = Gio.TlsConnection.TlsConnectionSetInteractionMethodInfo
    ResolveTlsServerConnectionMethod "setPending" o = Gio.IOStream.IOStreamSetPendingMethodInfo
    ResolveTlsServerConnectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTlsServerConnectionMethod "setRehandshakeMode" o = Gio.TlsConnection.TlsConnectionSetRehandshakeModeMethodInfo
    ResolveTlsServerConnectionMethod "setRequireCloseNotify" o = Gio.TlsConnection.TlsConnectionSetRequireCloseNotifyMethodInfo
    ResolveTlsServerConnectionMethod "setUseSystemCertdb" o = Gio.TlsConnection.TlsConnectionSetUseSystemCertdbMethodInfo
    ResolveTlsServerConnectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTlsServerConnectionMethod t TlsServerConnection, O.OverloadedMethod info TlsServerConnection p) => OL.IsLabel t (TlsServerConnection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTlsServerConnectionMethod t TlsServerConnection, O.OverloadedMethod info TlsServerConnection p, R.HasField t TlsServerConnection p) => R.HasField t TlsServerConnection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTlsServerConnectionMethod t TlsServerConnection, O.OverloadedMethodInfo info TlsServerConnection) => OL.IsLabel t (O.MethodProxy info TlsServerConnection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method TlsServerConnection::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "base_io_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GIOStream to wrap"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "certificate"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the default server certificate, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsServerConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_server_connection_new" g_tls_server_connection_new :: 
    Ptr Gio.IOStream.IOStream ->            -- base_io_stream : TInterface (Name {namespace = "Gio", name = "IOStream"})
    Ptr Gio.TlsCertificate.TlsCertificate -> -- certificate : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsServerConnection)

-- | Creates a new t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection' wrapping /@baseIoStream@/ (which
-- must have pollable input and output streams).
-- 
-- See the documentation for [TlsConnection:baseIoStream]("GI.Gio.Objects.TlsConnection#g:attr:baseIoStream") for restrictions
-- on when application code can run operations on the /@baseIoStream@/ after
-- this function has returned.
-- 
-- /Since: 2.28/
tlsServerConnectionNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.IOStream.IsIOStream a, Gio.TlsCertificate.IsTlsCertificate b) =>
    a
    -- ^ /@baseIoStream@/: the t'GI.Gio.Objects.IOStream.IOStream' to wrap
    -> Maybe (b)
    -- ^ /@certificate@/: the default server certificate, or 'P.Nothing'
    -> m TlsServerConnection
    -- ^ __Returns:__ the new
    -- t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection', or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
tlsServerConnectionNew baseIoStream certificate = liftIO $ do
    baseIoStream' <- unsafeManagedPtrCastPtr baseIoStream
    maybeCertificate <- case certificate of
        Nothing -> return FP.nullPtr
        Just jCertificate -> do
            jCertificate' <- unsafeManagedPtrCastPtr jCertificate
            return jCertificate'
    onException (do
        result <- propagateGError $ g_tls_server_connection_new baseIoStream' maybeCertificate
        checkUnexpectedReturnNULL "tlsServerConnectionNew" result
        result' <- (wrapObject TlsServerConnection) result
        touchManagedPtr baseIoStream
        whenJust certificate touchManagedPtr
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TlsServerConnection = TlsServerConnectionSignalList
type TlsServerConnectionSignalList = ('[ '("acceptCertificate", Gio.TlsConnection.TlsConnectionAcceptCertificateSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


