{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- This is the subclass of t'GI.Gio.Objects.SocketConnection.SocketConnection' that is created
-- for UNIX domain sockets.
-- 
-- It contains functions to do some of the UNIX socket specific
-- functionality like passing file descriptors.
-- 
-- Since GLib 2.72, @GUnixConnection@ is available on all platforms. It requires
-- underlying system support (such as Windows 10 with @AF_UNIX@) at run time.
-- 
-- Before GLib 2.72, @\<gio\/gunixconnection.h>@ belonged to the UNIX-specific GIO
-- interfaces, thus you had to use the @gio-unix-2.0.pc@ pkg-config file when
-- using it. This is no longer necessary since GLib 2.72.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.UnixConnection
    ( 

-- * Exported types
    UnixConnection(..)                      ,
    IsUnixConnection                        ,
    toUnixConnection                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearPending]("GI.Gio.Objects.IOStream#g:method:clearPending"), [close]("GI.Gio.Objects.IOStream#g:method:close"), [closeAsync]("GI.Gio.Objects.IOStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.IOStream#g:method:closeFinish"), [connect]("GI.Gio.Objects.SocketConnection#g:method:connect"), [connectAsync]("GI.Gio.Objects.SocketConnection#g:method:connectAsync"), [connectFinish]("GI.Gio.Objects.SocketConnection#g:method:connectFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.IOStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.IOStream#g:method:isClosed"), [isConnected]("GI.Gio.Objects.SocketConnection#g:method:isConnected"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [receiveCredentials]("GI.Gio.Objects.UnixConnection#g:method:receiveCredentials"), [receiveCredentialsAsync]("GI.Gio.Objects.UnixConnection#g:method:receiveCredentialsAsync"), [receiveCredentialsFinish]("GI.Gio.Objects.UnixConnection#g:method:receiveCredentialsFinish"), [receiveFd]("GI.Gio.Objects.UnixConnection#g:method:receiveFd"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sendCredentials]("GI.Gio.Objects.UnixConnection#g:method:sendCredentials"), [sendCredentialsAsync]("GI.Gio.Objects.UnixConnection#g:method:sendCredentialsAsync"), [sendCredentialsFinish]("GI.Gio.Objects.UnixConnection#g:method:sendCredentialsFinish"), [sendFd]("GI.Gio.Objects.UnixConnection#g:method:sendFd"), [spliceAsync]("GI.Gio.Objects.IOStream#g:method:spliceAsync"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getInputStream]("GI.Gio.Objects.IOStream#g:method:getInputStream"), [getLocalAddress]("GI.Gio.Objects.SocketConnection#g:method:getLocalAddress"), [getOutputStream]("GI.Gio.Objects.IOStream#g:method:getOutputStream"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRemoteAddress]("GI.Gio.Objects.SocketConnection#g:method:getRemoteAddress"), [getSocket]("GI.Gio.Objects.SocketConnection#g:method:getSocket").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.IOStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveUnixConnectionMethod             ,
#endif

-- ** receiveCredentials #method:receiveCredentials#

#if defined(ENABLE_OVERLOADING)
    UnixConnectionReceiveCredentialsMethodInfo,
#endif
    unixConnectionReceiveCredentials        ,


-- ** receiveCredentialsAsync #method:receiveCredentialsAsync#

#if defined(ENABLE_OVERLOADING)
    UnixConnectionReceiveCredentialsAsyncMethodInfo,
#endif
    unixConnectionReceiveCredentialsAsync   ,


-- ** receiveCredentialsFinish #method:receiveCredentialsFinish#

#if defined(ENABLE_OVERLOADING)
    UnixConnectionReceiveCredentialsFinishMethodInfo,
#endif
    unixConnectionReceiveCredentialsFinish  ,


-- ** receiveFd #method:receiveFd#

#if defined(ENABLE_OVERLOADING)
    UnixConnectionReceiveFdMethodInfo       ,
#endif
    unixConnectionReceiveFd                 ,


-- ** sendCredentials #method:sendCredentials#

#if defined(ENABLE_OVERLOADING)
    UnixConnectionSendCredentialsMethodInfo ,
#endif
    unixConnectionSendCredentials           ,


-- ** sendCredentialsAsync #method:sendCredentialsAsync#

#if defined(ENABLE_OVERLOADING)
    UnixConnectionSendCredentialsAsyncMethodInfo,
#endif
    unixConnectionSendCredentialsAsync      ,


-- ** sendCredentialsFinish #method:sendCredentialsFinish#

#if defined(ENABLE_OVERLOADING)
    UnixConnectionSendCredentialsFinishMethodInfo,
#endif
    unixConnectionSendCredentialsFinish     ,


-- ** sendFd #method:sendFd#

#if defined(ENABLE_OVERLOADING)
    UnixConnectionSendFdMethodInfo          ,
#endif
    unixConnectionSendFd                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputVector as Gio.InputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection

#endif

-- | Memory-managed wrapper type.
newtype UnixConnection = UnixConnection (SP.ManagedPtr UnixConnection)
    deriving (Eq)

instance SP.ManagedPtrNewtype UnixConnection where
    toManagedPtr (UnixConnection p) = p

foreign import ccall "g_unix_connection_get_type"
    c_g_unix_connection_get_type :: IO B.Types.GType

instance B.Types.TypedObject UnixConnection where
    glibType = c_g_unix_connection_get_type

instance B.Types.GObject UnixConnection

-- | Type class for types which can be safely cast to t'UnixConnection', for instance with `toUnixConnection`.
class (SP.GObject o, O.IsDescendantOf UnixConnection o) => IsUnixConnection o
instance (SP.GObject o, O.IsDescendantOf UnixConnection o) => IsUnixConnection o

instance O.HasParentTypes UnixConnection
type instance O.ParentTypes UnixConnection = '[Gio.SocketConnection.SocketConnection, Gio.IOStream.IOStream, GObject.Object.Object]

-- | Cast to t'UnixConnection', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toUnixConnection :: (MIO.MonadIO m, IsUnixConnection o) => o -> m UnixConnection
toUnixConnection = MIO.liftIO . B.ManagedPtr.unsafeCastTo UnixConnection

-- | Convert t'UnixConnection' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe UnixConnection) where
    gvalueGType_ = c_g_unix_connection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr UnixConnection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr UnixConnection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject UnixConnection ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveUnixConnectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUnixConnectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveUnixConnectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveUnixConnectionMethod "clearPending" o = Gio.IOStream.IOStreamClearPendingMethodInfo
    ResolveUnixConnectionMethod "close" o = Gio.IOStream.IOStreamCloseMethodInfo
    ResolveUnixConnectionMethod "closeAsync" o = Gio.IOStream.IOStreamCloseAsyncMethodInfo
    ResolveUnixConnectionMethod "closeFinish" o = Gio.IOStream.IOStreamCloseFinishMethodInfo
    ResolveUnixConnectionMethod "connect" o = Gio.SocketConnection.SocketConnectionConnectMethodInfo
    ResolveUnixConnectionMethod "connectAsync" o = Gio.SocketConnection.SocketConnectionConnectAsyncMethodInfo
    ResolveUnixConnectionMethod "connectFinish" o = Gio.SocketConnection.SocketConnectionConnectFinishMethodInfo
    ResolveUnixConnectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveUnixConnectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveUnixConnectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveUnixConnectionMethod "hasPending" o = Gio.IOStream.IOStreamHasPendingMethodInfo
    ResolveUnixConnectionMethod "isClosed" o = Gio.IOStream.IOStreamIsClosedMethodInfo
    ResolveUnixConnectionMethod "isConnected" o = Gio.SocketConnection.SocketConnectionIsConnectedMethodInfo
    ResolveUnixConnectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveUnixConnectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveUnixConnectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveUnixConnectionMethod "receiveCredentials" o = UnixConnectionReceiveCredentialsMethodInfo
    ResolveUnixConnectionMethod "receiveCredentialsAsync" o = UnixConnectionReceiveCredentialsAsyncMethodInfo
    ResolveUnixConnectionMethod "receiveCredentialsFinish" o = UnixConnectionReceiveCredentialsFinishMethodInfo
    ResolveUnixConnectionMethod "receiveFd" o = UnixConnectionReceiveFdMethodInfo
    ResolveUnixConnectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveUnixConnectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveUnixConnectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveUnixConnectionMethod "sendCredentials" o = UnixConnectionSendCredentialsMethodInfo
    ResolveUnixConnectionMethod "sendCredentialsAsync" o = UnixConnectionSendCredentialsAsyncMethodInfo
    ResolveUnixConnectionMethod "sendCredentialsFinish" o = UnixConnectionSendCredentialsFinishMethodInfo
    ResolveUnixConnectionMethod "sendFd" o = UnixConnectionSendFdMethodInfo
    ResolveUnixConnectionMethod "spliceAsync" o = Gio.IOStream.IOStreamSpliceAsyncMethodInfo
    ResolveUnixConnectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveUnixConnectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveUnixConnectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveUnixConnectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveUnixConnectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveUnixConnectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveUnixConnectionMethod "getInputStream" o = Gio.IOStream.IOStreamGetInputStreamMethodInfo
    ResolveUnixConnectionMethod "getLocalAddress" o = Gio.SocketConnection.SocketConnectionGetLocalAddressMethodInfo
    ResolveUnixConnectionMethod "getOutputStream" o = Gio.IOStream.IOStreamGetOutputStreamMethodInfo
    ResolveUnixConnectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveUnixConnectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveUnixConnectionMethod "getRemoteAddress" o = Gio.SocketConnection.SocketConnectionGetRemoteAddressMethodInfo
    ResolveUnixConnectionMethod "getSocket" o = Gio.SocketConnection.SocketConnectionGetSocketMethodInfo
    ResolveUnixConnectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveUnixConnectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveUnixConnectionMethod "setPending" o = Gio.IOStream.IOStreamSetPendingMethodInfo
    ResolveUnixConnectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveUnixConnectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUnixConnectionMethod t UnixConnection, O.OverloadedMethod info UnixConnection p) => OL.IsLabel t (UnixConnection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUnixConnectionMethod t UnixConnection, O.OverloadedMethod info UnixConnection p, R.HasField t UnixConnection p) => R.HasField t UnixConnection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUnixConnectionMethod t UnixConnection, O.OverloadedMethodInfo info UnixConnection) => OL.IsLabel t (O.MethodProxy info UnixConnection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UnixConnection
type instance O.AttributeList UnixConnection = UnixConnectionAttributeList
type UnixConnectionAttributeList = ('[ '("closed", Gio.IOStream.IOStreamClosedPropertyInfo), '("inputStream", Gio.IOStream.IOStreamInputStreamPropertyInfo), '("outputStream", Gio.IOStream.IOStreamOutputStreamPropertyInfo), '("socket", Gio.SocketConnection.SocketConnectionSocketPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList UnixConnection = UnixConnectionSignalList
type UnixConnectionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method UnixConnection::receive_credentials
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GUnixConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCancellable or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Credentials" })
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_connection_receive_credentials" g_unix_connection_receive_credentials :: 
    Ptr UnixConnection ->                   -- connection : TInterface (Name {namespace = "Gio", name = "UnixConnection"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.Credentials.Credentials)

-- | Receives credentials from the sending end of the connection.  The
-- sending end has to call 'GI.Gio.Objects.UnixConnection.unixConnectionSendCredentials' (or
-- similar) for this to work.
-- 
-- As well as reading the credentials this also reads (and discards) a
-- single byte from the stream, as this is required for credentials
-- passing to work on some implementations.
-- 
-- This method can be expected to be available on the following platforms:
-- 
-- * Linux since GLib 2.26
-- * FreeBSD since GLib 2.26
-- * GNU\/kFreeBSD since GLib 2.36
-- * Solaris, Illumos and OpenSolaris since GLib 2.40
-- * GNU\/Hurd since GLib 2.40
-- 
-- 
-- Other ways to exchange credentials with a foreign peer includes the
-- t'GI.Gio.Objects.UnixCredentialsMessage.UnixCredentialsMessage' type and 'GI.Gio.Objects.Socket.socketGetCredentials' function.
-- 
-- /Since: 2.26/
unixConnectionReceiveCredentials ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@connection@/: A t'GI.Gio.Objects.UnixConnection.UnixConnection'.
    -> Maybe (b)
    -- ^ /@cancellable@/: A t'GI.Gio.Objects.Cancellable.Cancellable' or 'P.Nothing'.
    -> m Gio.Credentials.Credentials
    -- ^ __Returns:__ Received credentials on success (free with
    -- 'GI.GObject.Objects.Object.objectUnref'), 'P.Nothing' if /@error@/ is set. /(Can throw 'Data.GI.Base.GError.GError')/
unixConnectionReceiveCredentials connection cancellable = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_unix_connection_receive_credentials connection' maybeCancellable
        checkUnexpectedReturnNULL "unixConnectionReceiveCredentials" result
        result' <- (wrapObject Gio.Credentials.Credentials) result
        touchManagedPtr connection
        whenJust cancellable touchManagedPtr
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UnixConnectionReceiveCredentialsMethodInfo
instance (signature ~ (Maybe (b) -> m Gio.Credentials.Credentials), MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod UnixConnectionReceiveCredentialsMethodInfo a signature where
    overloadedMethod = unixConnectionReceiveCredentials

instance O.OverloadedMethodInfo UnixConnectionReceiveCredentialsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentials",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixConnection.html#v:unixConnectionReceiveCredentials"
        })


#endif

-- method UnixConnection::receive_credentials_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GUnixConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_connection_receive_credentials_async" g_unix_connection_receive_credentials_async :: 
    Ptr UnixConnection ->                   -- connection : TInterface (Name {namespace = "Gio", name = "UnixConnection"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously receive credentials.
-- 
-- For more details, see 'GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentials' which is
-- the synchronous version of this call.
-- 
-- When the operation is finished, /@callback@/ will be called. You can then call
-- 'GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentialsFinish' to get the result of the operation.
-- 
-- /Since: 2.32/
unixConnectionReceiveCredentialsAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@connection@/: A t'GI.Gio.Objects.UnixConnection.UnixConnection'.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> m ()
unixConnectionReceiveCredentialsAsync connection cancellable callback = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_unix_connection_receive_credentials_async connection' maybeCancellable maybeCallback userData
    touchManagedPtr connection
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data UnixConnectionReceiveCredentialsAsyncMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod UnixConnectionReceiveCredentialsAsyncMethodInfo a signature where
    overloadedMethod = unixConnectionReceiveCredentialsAsync

instance O.OverloadedMethodInfo UnixConnectionReceiveCredentialsAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentialsAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixConnection.html#v:unixConnectionReceiveCredentialsAsync"
        })


#endif

-- method UnixConnection::receive_credentials_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GUnixConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Credentials" })
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_connection_receive_credentials_finish" g_unix_connection_receive_credentials_finish :: 
    Ptr UnixConnection ->                   -- connection : TInterface (Name {namespace = "Gio", name = "UnixConnection"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.Credentials.Credentials)

-- | Finishes an asynchronous receive credentials operation started with
-- 'GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentialsAsync'.
-- 
-- /Since: 2.32/
unixConnectionReceiveCredentialsFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixConnection a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@connection@/: A t'GI.Gio.Objects.UnixConnection.UnixConnection'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m Gio.Credentials.Credentials
    -- ^ __Returns:__ a t'GI.Gio.Objects.Credentials.Credentials', or 'P.Nothing' on error.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'. /(Can throw 'Data.GI.Base.GError.GError')/
unixConnectionReceiveCredentialsFinish connection result_ = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_unix_connection_receive_credentials_finish connection' result_'
        checkUnexpectedReturnNULL "unixConnectionReceiveCredentialsFinish" result
        result' <- (wrapObject Gio.Credentials.Credentials) result
        touchManagedPtr connection
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UnixConnectionReceiveCredentialsFinishMethodInfo
instance (signature ~ (b -> m Gio.Credentials.Credentials), MonadIO m, IsUnixConnection a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod UnixConnectionReceiveCredentialsFinishMethodInfo a signature where
    overloadedMethod = unixConnectionReceiveCredentialsFinish

instance O.OverloadedMethodInfo UnixConnectionReceiveCredentialsFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentialsFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixConnection.html#v:unixConnectionReceiveCredentialsFinish"
        })


#endif

-- method UnixConnection::receive_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_connection_receive_fd" g_unix_connection_receive_fd :: 
    Ptr UnixConnection ->                   -- connection : TInterface (Name {namespace = "Gio", name = "UnixConnection"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO Int32

-- | Receives a file descriptor from the sending end of the connection.
-- The sending end has to call 'GI.Gio.Objects.UnixConnection.unixConnectionSendFd' for this
-- to work.
-- 
-- As well as reading the fd this also reads a single byte from the
-- stream, as this is required for fd passing to work on some
-- implementations.
-- 
-- /Since: 2.22/
unixConnectionReceiveFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@connection@/: a t'GI.Gio.Objects.UnixConnection.UnixConnection'
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore
    -> m Int32
    -- ^ __Returns:__ a file descriptor on success, -1 on error. /(Can throw 'Data.GI.Base.GError.GError')/
unixConnectionReceiveFd connection cancellable = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_unix_connection_receive_fd connection' maybeCancellable
        touchManagedPtr connection
        whenJust cancellable touchManagedPtr
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UnixConnectionReceiveFdMethodInfo
instance (signature ~ (Maybe (b) -> m Int32), MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod UnixConnectionReceiveFdMethodInfo a signature where
    overloadedMethod = unixConnectionReceiveFd

instance O.OverloadedMethodInfo UnixConnectionReceiveFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixConnection.unixConnectionReceiveFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixConnection.html#v:unixConnectionReceiveFd"
        })


#endif

-- method UnixConnection::send_credentials
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GUnixConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCancellable or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_connection_send_credentials" g_unix_connection_send_credentials :: 
    Ptr UnixConnection ->                   -- connection : TInterface (Name {namespace = "Gio", name = "UnixConnection"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Passes the credentials of the current user the receiving side
-- of the connection. The receiving end has to call
-- 'GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentials' (or similar) to accept the
-- credentials.
-- 
-- As well as sending the credentials this also writes a single NUL
-- byte to the stream, as this is required for credentials passing to
-- work on some implementations.
-- 
-- This method can be expected to be available on the following platforms:
-- 
-- * Linux since GLib 2.26
-- * FreeBSD since GLib 2.26
-- * GNU\/kFreeBSD since GLib 2.36
-- * Solaris, Illumos and OpenSolaris since GLib 2.40
-- * GNU\/Hurd since GLib 2.40
-- 
-- 
-- Other ways to exchange credentials with a foreign peer includes the
-- t'GI.Gio.Objects.UnixCredentialsMessage.UnixCredentialsMessage' type and 'GI.Gio.Objects.Socket.socketGetCredentials' function.
-- 
-- /Since: 2.26/
unixConnectionSendCredentials ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@connection@/: A t'GI.Gio.Objects.UnixConnection.UnixConnection'.
    -> Maybe (b)
    -- ^ /@cancellable@/: A t'GI.Gio.Objects.Cancellable.Cancellable' or 'P.Nothing'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
unixConnectionSendCredentials connection cancellable = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_unix_connection_send_credentials connection' maybeCancellable
        touchManagedPtr connection
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UnixConnectionSendCredentialsMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod UnixConnectionSendCredentialsMethodInfo a signature where
    overloadedMethod = unixConnectionSendCredentials

instance O.OverloadedMethodInfo UnixConnectionSendCredentialsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixConnection.unixConnectionSendCredentials",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixConnection.html#v:unixConnectionSendCredentials"
        })


#endif

-- method UnixConnection::send_credentials_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GUnixConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_connection_send_credentials_async" g_unix_connection_send_credentials_async :: 
    Ptr UnixConnection ->                   -- connection : TInterface (Name {namespace = "Gio", name = "UnixConnection"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously send credentials.
-- 
-- For more details, see 'GI.Gio.Objects.UnixConnection.unixConnectionSendCredentials' which is
-- the synchronous version of this call.
-- 
-- When the operation is finished, /@callback@/ will be called. You can then call
-- 'GI.Gio.Objects.UnixConnection.unixConnectionSendCredentialsFinish' to get the result of the operation.
-- 
-- /Since: 2.32/
unixConnectionSendCredentialsAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@connection@/: A t'GI.Gio.Objects.UnixConnection.UnixConnection'.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> m ()
unixConnectionSendCredentialsAsync connection cancellable callback = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_unix_connection_send_credentials_async connection' maybeCancellable maybeCallback userData
    touchManagedPtr connection
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data UnixConnectionSendCredentialsAsyncMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod UnixConnectionSendCredentialsAsyncMethodInfo a signature where
    overloadedMethod = unixConnectionSendCredentialsAsync

instance O.OverloadedMethodInfo UnixConnectionSendCredentialsAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixConnection.unixConnectionSendCredentialsAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixConnection.html#v:unixConnectionSendCredentialsAsync"
        })


#endif

-- method UnixConnection::send_credentials_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GUnixConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_connection_send_credentials_finish" g_unix_connection_send_credentials_finish :: 
    Ptr UnixConnection ->                   -- connection : TInterface (Name {namespace = "Gio", name = "UnixConnection"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes an asynchronous send credentials operation started with
-- 'GI.Gio.Objects.UnixConnection.unixConnectionSendCredentialsAsync'.
-- 
-- /Since: 2.32/
unixConnectionSendCredentialsFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixConnection a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@connection@/: A t'GI.Gio.Objects.UnixConnection.UnixConnection'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
unixConnectionSendCredentialsFinish connection result_ = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_unix_connection_send_credentials_finish connection' result_'
        touchManagedPtr connection
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UnixConnectionSendCredentialsFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsUnixConnection a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod UnixConnectionSendCredentialsFinishMethodInfo a signature where
    overloadedMethod = unixConnectionSendCredentialsFinish

instance O.OverloadedMethodInfo UnixConnectionSendCredentialsFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixConnection.unixConnectionSendCredentialsFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixConnection.html#v:unixConnectionSendCredentialsFinish"
        })


#endif

-- method UnixConnection::send_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file descriptor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_connection_send_fd" g_unix_connection_send_fd :: 
    Ptr UnixConnection ->                   -- connection : TInterface (Name {namespace = "Gio", name = "UnixConnection"})
    Int32 ->                                -- fd : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Passes a file descriptor to the receiving side of the
-- connection. The receiving end has to call 'GI.Gio.Objects.UnixConnection.unixConnectionReceiveFd'
-- to accept the file descriptor.
-- 
-- As well as sending the fd this also writes a single byte to the
-- stream, as this is required for fd passing to work on some
-- implementations.
-- 
-- /Since: 2.22/
unixConnectionSendFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@connection@/: a t'GI.Gio.Objects.UnixConnection.UnixConnection'
    -> Int32
    -- ^ /@fd@/: a file descriptor
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
unixConnectionSendFd connection fd cancellable = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_unix_connection_send_fd connection' fd maybeCancellable
        touchManagedPtr connection
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UnixConnectionSendFdMethodInfo
instance (signature ~ (Int32 -> Maybe (b) -> m ()), MonadIO m, IsUnixConnection a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod UnixConnectionSendFdMethodInfo a signature where
    overloadedMethod = unixConnectionSendFd

instance O.OverloadedMethodInfo UnixConnectionSendFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixConnection.unixConnectionSendFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixConnection.html#v:unixConnectionSendFd"
        })


#endif


