{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about a signal on a D-Bus interface.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusSignalInfo
    ( 

-- * Exported types
    DBusSignalInfo(..)                      ,
    newZeroDBusSignalInfo                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gio.Structs.DBusSignalInfo#g:method:ref"), [unref]("GI.Gio.Structs.DBusSignalInfo#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveDBusSignalInfoMethod             ,
#endif

-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    DBusSignalInfoRefMethodInfo             ,
#endif
    dBusSignalInfoRef                       ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    DBusSignalInfoUnrefMethodInfo           ,
#endif
    dBusSignalInfoUnref                     ,




 -- * Properties


-- ** annotations #attr:annotations#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusAnnotationInfo.DBusAnnotationInfo' structures or 'P.Nothing' if there are no annotations.

    clearDBusSignalInfoAnnotations          ,
#if defined(ENABLE_OVERLOADING)
    dBusSignalInfo_annotations              ,
#endif
    getDBusSignalInfoAnnotations            ,
    setDBusSignalInfoAnnotations            ,


-- ** args #attr:args#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusArgInfo.DBusArgInfo' structures or 'P.Nothing' if there are no arguments.

    clearDBusSignalInfoArgs                 ,
#if defined(ENABLE_OVERLOADING)
    dBusSignalInfo_args                     ,
#endif
    getDBusSignalInfoArgs                   ,
    setDBusSignalInfoArgs                   ,


-- ** name #attr:name#
-- | The name of the D-Bus signal, e.g. \"NameOwnerChanged\".

    clearDBusSignalInfoName                 ,
#if defined(ENABLE_OVERLOADING)
    dBusSignalInfo_name                     ,
#endif
    getDBusSignalInfoName                   ,
    setDBusSignalInfoName                   ,


-- ** refCount #attr:refCount#
-- | The reference count or -1 if statically allocated.

#if defined(ENABLE_OVERLOADING)
    dBusSignalInfo_refCount                 ,
#endif
    getDBusSignalInfoRefCount               ,
    setDBusSignalInfoRefCount               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo

#else
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo

#endif

-- | Memory-managed wrapper type.
newtype DBusSignalInfo = DBusSignalInfo (SP.ManagedPtr DBusSignalInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusSignalInfo where
    toManagedPtr (DBusSignalInfo p) = p

foreign import ccall "g_dbus_signal_info_get_type" c_g_dbus_signal_info_get_type :: 
    IO GType

type instance O.ParentTypes DBusSignalInfo = '[]
instance O.HasParentTypes DBusSignalInfo

instance B.Types.TypedObject DBusSignalInfo where
    glibType = c_g_dbus_signal_info_get_type

instance B.Types.GBoxed DBusSignalInfo

-- | Convert t'DBusSignalInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusSignalInfo) where
    gvalueGType_ = c_g_dbus_signal_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr DBusSignalInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr DBusSignalInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed DBusSignalInfo ptr
        else return P.Nothing
        
    

-- | Construct a t'DBusSignalInfo' struct initialized to zero.
newZeroDBusSignalInfo :: MonadIO m => m DBusSignalInfo
newZeroDBusSignalInfo = liftIO $ callocBoxedBytes 32 >>= wrapBoxed DBusSignalInfo

instance tag ~ 'AttrSet => Constructible DBusSignalInfo tag where
    new _ attrs = do
        o <- newZeroDBusSignalInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusSignalInfo #refCount
-- @
getDBusSignalInfoRefCount :: MonadIO m => DBusSignalInfo -> m Int32
getDBusSignalInfoRefCount s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusSignalInfo [ #refCount 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusSignalInfoRefCount :: MonadIO m => DBusSignalInfo -> Int32 -> m ()
setDBusSignalInfoRefCount s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data DBusSignalInfoRefCountFieldInfo
instance AttrInfo DBusSignalInfoRefCountFieldInfo where
    type AttrBaseTypeConstraint DBusSignalInfoRefCountFieldInfo = (~) DBusSignalInfo
    type AttrAllowedOps DBusSignalInfoRefCountFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DBusSignalInfoRefCountFieldInfo = (~) Int32
    type AttrTransferTypeConstraint DBusSignalInfoRefCountFieldInfo = (~)Int32
    type AttrTransferType DBusSignalInfoRefCountFieldInfo = Int32
    type AttrGetType DBusSignalInfoRefCountFieldInfo = Int32
    type AttrLabel DBusSignalInfoRefCountFieldInfo = "ref_count"
    type AttrOrigin DBusSignalInfoRefCountFieldInfo = DBusSignalInfo
    attrGet = getDBusSignalInfoRefCount
    attrSet = setDBusSignalInfoRefCount
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSignalInfo.refCount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSignalInfo.html#g:attr:refCount"
        })

dBusSignalInfo_refCount :: AttrLabelProxy "refCount"
dBusSignalInfo_refCount = AttrLabelProxy

#endif


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusSignalInfo #name
-- @
getDBusSignalInfoName :: MonadIO m => DBusSignalInfo -> m (Maybe T.Text)
getDBusSignalInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusSignalInfo [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusSignalInfoName :: MonadIO m => DBusSignalInfo -> CString -> m ()
setDBusSignalInfoName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearDBusSignalInfoName :: MonadIO m => DBusSignalInfo -> m ()
clearDBusSignalInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusSignalInfoNameFieldInfo
instance AttrInfo DBusSignalInfoNameFieldInfo where
    type AttrBaseTypeConstraint DBusSignalInfoNameFieldInfo = (~) DBusSignalInfo
    type AttrAllowedOps DBusSignalInfoNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusSignalInfoNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusSignalInfoNameFieldInfo = (~)CString
    type AttrTransferType DBusSignalInfoNameFieldInfo = CString
    type AttrGetType DBusSignalInfoNameFieldInfo = Maybe T.Text
    type AttrLabel DBusSignalInfoNameFieldInfo = "name"
    type AttrOrigin DBusSignalInfoNameFieldInfo = DBusSignalInfo
    attrGet = getDBusSignalInfoName
    attrSet = setDBusSignalInfoName
    attrConstruct = undefined
    attrClear = clearDBusSignalInfoName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSignalInfo.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSignalInfo.html#g:attr:name"
        })

dBusSignalInfo_name :: AttrLabelProxy "name"
dBusSignalInfo_name = AttrLabelProxy

#endif


-- | Get the value of the “@args@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusSignalInfo #args
-- @
getDBusSignalInfoArgs :: MonadIO m => DBusSignalInfo -> m (Maybe [Gio.DBusArgInfo.DBusArgInfo])
getDBusSignalInfoArgs s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusArgInfo.DBusArgInfo) val''
        return val'''
    return result

-- | Set the value of the “@args@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusSignalInfo [ #args 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusSignalInfoArgs :: MonadIO m => DBusSignalInfo -> Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo) -> m ()
setDBusSignalInfoArgs s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))

-- | Set the value of the “@args@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #args
-- @
clearDBusSignalInfoArgs :: MonadIO m => DBusSignalInfo -> m ()
clearDBusSignalInfoArgs s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))

#if defined(ENABLE_OVERLOADING)
data DBusSignalInfoArgsFieldInfo
instance AttrInfo DBusSignalInfoArgsFieldInfo where
    type AttrBaseTypeConstraint DBusSignalInfoArgsFieldInfo = (~) DBusSignalInfo
    type AttrAllowedOps DBusSignalInfoArgsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusSignalInfoArgsFieldInfo = (~) (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrTransferTypeConstraint DBusSignalInfoArgsFieldInfo = (~)(Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrTransferType DBusSignalInfoArgsFieldInfo = (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrGetType DBusSignalInfoArgsFieldInfo = Maybe [Gio.DBusArgInfo.DBusArgInfo]
    type AttrLabel DBusSignalInfoArgsFieldInfo = "args"
    type AttrOrigin DBusSignalInfoArgsFieldInfo = DBusSignalInfo
    attrGet = getDBusSignalInfoArgs
    attrSet = setDBusSignalInfoArgs
    attrConstruct = undefined
    attrClear = clearDBusSignalInfoArgs
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSignalInfo.args"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSignalInfo.html#g:attr:args"
        })

dBusSignalInfo_args :: AttrLabelProxy "args"
dBusSignalInfo_args = AttrLabelProxy

#endif


-- | Get the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusSignalInfo #annotations
-- @
getDBusSignalInfoAnnotations :: MonadIO m => DBusSignalInfo -> m (Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo])
getDBusSignalInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusAnnotationInfo.DBusAnnotationInfo) val''
        return val'''
    return result

-- | Set the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusSignalInfo [ #annotations 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusSignalInfoAnnotations :: MonadIO m => DBusSignalInfo -> Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo) -> m ()
setDBusSignalInfoAnnotations s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

-- | Set the value of the “@annotations@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #annotations
-- @
clearDBusSignalInfoAnnotations :: MonadIO m => DBusSignalInfo -> m ()
clearDBusSignalInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

#if defined(ENABLE_OVERLOADING)
data DBusSignalInfoAnnotationsFieldInfo
instance AttrInfo DBusSignalInfoAnnotationsFieldInfo where
    type AttrBaseTypeConstraint DBusSignalInfoAnnotationsFieldInfo = (~) DBusSignalInfo
    type AttrAllowedOps DBusSignalInfoAnnotationsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusSignalInfoAnnotationsFieldInfo = (~) (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferTypeConstraint DBusSignalInfoAnnotationsFieldInfo = (~)(Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferType DBusSignalInfoAnnotationsFieldInfo = (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrGetType DBusSignalInfoAnnotationsFieldInfo = Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo]
    type AttrLabel DBusSignalInfoAnnotationsFieldInfo = "annotations"
    type AttrOrigin DBusSignalInfoAnnotationsFieldInfo = DBusSignalInfo
    attrGet = getDBusSignalInfoAnnotations
    attrSet = setDBusSignalInfoAnnotations
    attrConstruct = undefined
    attrClear = clearDBusSignalInfoAnnotations
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSignalInfo.annotations"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSignalInfo.html#g:attr:annotations"
        })

dBusSignalInfo_annotations :: AttrLabelProxy "annotations"
dBusSignalInfo_annotations = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusSignalInfo
type instance O.AttributeList DBusSignalInfo = DBusSignalInfoAttributeList
type DBusSignalInfoAttributeList = ('[ '("refCount", DBusSignalInfoRefCountFieldInfo), '("name", DBusSignalInfoNameFieldInfo), '("args", DBusSignalInfoArgsFieldInfo), '("annotations", DBusSignalInfoAnnotationsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method DBusSignalInfo::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusSignalInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusSignalInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusSignalInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_signal_info_ref" g_dbus_signal_info_ref :: 
    Ptr DBusSignalInfo ->                   -- info : TInterface (Name {namespace = "Gio", name = "DBusSignalInfo"})
    IO (Ptr DBusSignalInfo)

-- | If /@info@/ is statically allocated does nothing. Otherwise increases
-- the reference count.
-- 
-- /Since: 2.26/
dBusSignalInfoRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusSignalInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusSignalInfo.DBusSignalInfo'
    -> m DBusSignalInfo
    -- ^ __Returns:__ The same /@info@/.
dBusSignalInfoRef info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    result <- g_dbus_signal_info_ref info'
    checkUnexpectedReturnNULL "dBusSignalInfoRef" result
    result' <- (wrapBoxed DBusSignalInfo) result
    touchManagedPtr info
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusSignalInfoRefMethodInfo
instance (signature ~ (m DBusSignalInfo), MonadIO m) => O.OverloadedMethod DBusSignalInfoRefMethodInfo DBusSignalInfo signature where
    overloadedMethod = dBusSignalInfoRef

instance O.OverloadedMethodInfo DBusSignalInfoRefMethodInfo DBusSignalInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSignalInfo.dBusSignalInfoRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSignalInfo.html#v:dBusSignalInfoRef"
        })


#endif

-- method DBusSignalInfo::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusSignalInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusSignalInfo."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_signal_info_unref" g_dbus_signal_info_unref :: 
    Ptr DBusSignalInfo ->                   -- info : TInterface (Name {namespace = "Gio", name = "DBusSignalInfo"})
    IO ()

-- | If /@info@/ is statically allocated, does nothing. Otherwise decreases
-- the reference count of /@info@/. When its reference count drops to 0,
-- the memory used is freed.
-- 
-- /Since: 2.26/
dBusSignalInfoUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusSignalInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusSignalInfo.DBusSignalInfo'.
    -> m ()
dBusSignalInfoUnref info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    g_dbus_signal_info_unref info'
    touchManagedPtr info
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusSignalInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod DBusSignalInfoUnrefMethodInfo DBusSignalInfo signature where
    overloadedMethod = dBusSignalInfoUnref

instance O.OverloadedMethodInfo DBusSignalInfoUnrefMethodInfo DBusSignalInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSignalInfo.dBusSignalInfoUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSignalInfo.html#v:dBusSignalInfoUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusSignalInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusSignalInfoMethod "ref" o = DBusSignalInfoRefMethodInfo
    ResolveDBusSignalInfoMethod "unref" o = DBusSignalInfoUnrefMethodInfo
    ResolveDBusSignalInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusSignalInfoMethod t DBusSignalInfo, O.OverloadedMethod info DBusSignalInfo p) => OL.IsLabel t (DBusSignalInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusSignalInfoMethod t DBusSignalInfo, O.OverloadedMethod info DBusSignalInfo p, R.HasField t DBusSignalInfo p) => R.HasField t DBusSignalInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusSignalInfoMethod t DBusSignalInfo, O.OverloadedMethodInfo info DBusSignalInfo) => OL.IsLabel t (O.MethodProxy info DBusSignalInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


