{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GDBusObject@ type is the base type for D-Bus objects on both
-- the service side (see t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton') and the client side
-- (see t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy'). It is essentially just a container of
-- interfaces.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.DBusObject
    ( 

-- * Exported types
    DBusObject(..)                          ,
    IsDBusObject                            ,
    toDBusObject                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getInterface]("GI.Gio.Interfaces.DBusObject#g:method:getInterface"), [getInterfaces]("GI.Gio.Interfaces.DBusObject#g:method:getInterfaces"), [getObjectPath]("GI.Gio.Interfaces.DBusObject#g:method:getObjectPath"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDBusObjectMethod                 ,
#endif

-- ** getInterface #method:getInterface#

#if defined(ENABLE_OVERLOADING)
    DBusObjectGetInterfaceMethodInfo        ,
#endif
    dBusObjectGetInterface                  ,


-- ** getInterfaces #method:getInterfaces#

#if defined(ENABLE_OVERLOADING)
    DBusObjectGetInterfacesMethodInfo       ,
#endif
    dBusObjectGetInterfaces                 ,


-- ** getObjectPath #method:getObjectPath#

#if defined(ENABLE_OVERLOADING)
    DBusObjectGetObjectPathMethodInfo       ,
#endif
    dBusObjectGetObjectPath                 ,




 -- * Signals


-- ** interfaceAdded #signal:interfaceAdded#

    DBusObjectInterfaceAddedCallback        ,
#if defined(ENABLE_OVERLOADING)
    DBusObjectInterfaceAddedSignalInfo      ,
#endif
    afterDBusObjectInterfaceAdded           ,
    onDBusObjectInterfaceAdded              ,


-- ** interfaceRemoved #signal:interfaceRemoved#

    DBusObjectInterfaceRemovedCallback      ,
#if defined(ENABLE_OVERLOADING)
    DBusObjectInterfaceRemovedSignalInfo    ,
#endif
    afterDBusObjectInterfaceRemoved         ,
    onDBusObjectInterfaceRemoved            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusInterface as Gio.DBusInterface
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusInterface as Gio.DBusInterface

#endif

-- interface DBusObject 
-- | Memory-managed wrapper type.
newtype DBusObject = DBusObject (SP.ManagedPtr DBusObject)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusObject where
    toManagedPtr (DBusObject p) = p

foreign import ccall "g_dbus_object_get_type"
    c_g_dbus_object_get_type :: IO B.Types.GType

instance B.Types.TypedObject DBusObject where
    glibType = c_g_dbus_object_get_type

instance B.Types.GObject DBusObject

-- | Type class for types which can be safely cast to t'DBusObject', for instance with `toDBusObject`.
class (SP.GObject o, O.IsDescendantOf DBusObject o) => IsDBusObject o
instance (SP.GObject o, O.IsDescendantOf DBusObject o) => IsDBusObject o

instance O.HasParentTypes DBusObject
type instance O.ParentTypes DBusObject = '[GObject.Object.Object]

-- | Cast to t'DBusObject', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDBusObject :: (MIO.MonadIO m, IsDBusObject o) => o -> m DBusObject
toDBusObject = MIO.liftIO . B.ManagedPtr.unsafeCastTo DBusObject

-- | Convert t'DBusObject' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusObject) where
    gvalueGType_ = c_g_dbus_object_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DBusObject)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DBusObject)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DBusObject ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusObject
type instance O.AttributeList DBusObject = DBusObjectAttributeList
type DBusObjectAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusObjectMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusObjectMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDBusObjectMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDBusObjectMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDBusObjectMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDBusObjectMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDBusObjectMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDBusObjectMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDBusObjectMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDBusObjectMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDBusObjectMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDBusObjectMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDBusObjectMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDBusObjectMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDBusObjectMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDBusObjectMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDBusObjectMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDBusObjectMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDBusObjectMethod "getInterface" o = DBusObjectGetInterfaceMethodInfo
    ResolveDBusObjectMethod "getInterfaces" o = DBusObjectGetInterfacesMethodInfo
    ResolveDBusObjectMethod "getObjectPath" o = DBusObjectGetObjectPathMethodInfo
    ResolveDBusObjectMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDBusObjectMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDBusObjectMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDBusObjectMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDBusObjectMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDBusObjectMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusObjectMethod t DBusObject, O.OverloadedMethod info DBusObject p) => OL.IsLabel t (DBusObject -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusObjectMethod t DBusObject, O.OverloadedMethod info DBusObject p, R.HasField t DBusObject p) => R.HasField t DBusObject p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusObjectMethod t DBusObject, O.OverloadedMethodInfo info DBusObject) => OL.IsLabel t (O.MethodProxy info DBusObject) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method DBusObject::get_interface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObject" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObject." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A D-Bus interface name."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusInterface" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_get_interface" g_dbus_object_get_interface :: 
    Ptr DBusObject ->                       -- object : TInterface (Name {namespace = "Gio", name = "DBusObject"})
    CString ->                              -- interface_name : TBasicType TUTF8
    IO (Ptr Gio.DBusInterface.DBusInterface)

-- | Gets the D-Bus interface with name /@interfaceName@/ associated with
-- /@object@/, if any.
-- 
-- /Since: 2.30/
dBusObjectGetInterface ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObject a) =>
    a
    -- ^ /@object@/: A t'GI.Gio.Interfaces.DBusObject.DBusObject'.
    -> T.Text
    -- ^ /@interfaceName@/: A D-Bus interface name.
    -> m (Maybe Gio.DBusInterface.DBusInterface)
    -- ^ __Returns:__ 'P.Nothing' if not found, otherwise a
    --   t'GI.Gio.Interfaces.DBusInterface.DBusInterface' that must be freed with 'GI.GObject.Objects.Object.objectUnref'.
dBusObjectGetInterface object interfaceName = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    interfaceName' <- textToCString interfaceName
    result <- g_dbus_object_get_interface object' interfaceName'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.DBusInterface.DBusInterface) result'
        return result''
    touchManagedPtr object
    freeMem interfaceName'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DBusObjectGetInterfaceMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gio.DBusInterface.DBusInterface)), MonadIO m, IsDBusObject a) => O.OverloadedMethod DBusObjectGetInterfaceMethodInfo a signature where
    overloadedMethod = dBusObjectGetInterface

instance O.OverloadedMethodInfo DBusObjectGetInterfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DBusObject.dBusObjectGetInterface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-DBusObject.html#v:dBusObjectGetInterface"
        })


#endif

-- method DBusObject::get_interfaces
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObject" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObject." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gio" , name = "DBusInterface" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_get_interfaces" g_dbus_object_get_interfaces :: 
    Ptr DBusObject ->                       -- object : TInterface (Name {namespace = "Gio", name = "DBusObject"})
    IO (Ptr (GList (Ptr Gio.DBusInterface.DBusInterface)))

-- | Gets the D-Bus interfaces associated with /@object@/.
-- 
-- /Since: 2.30/
dBusObjectGetInterfaces ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObject a) =>
    a
    -- ^ /@object@/: A t'GI.Gio.Interfaces.DBusObject.DBusObject'.
    -> m [Gio.DBusInterface.DBusInterface]
    -- ^ __Returns:__ A list of t'GI.Gio.Interfaces.DBusInterface.DBusInterface' instances.
    --   The returned list must be freed by @/g_list_free()/@ after each element has been freed
    --   with 'GI.GObject.Objects.Object.objectUnref'.
dBusObjectGetInterfaces object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    result <- g_dbus_object_get_interfaces object'
    result' <- unpackGList result
    result'' <- mapM (wrapObject Gio.DBusInterface.DBusInterface) result'
    g_list_free result
    touchManagedPtr object
    return result''

#if defined(ENABLE_OVERLOADING)
data DBusObjectGetInterfacesMethodInfo
instance (signature ~ (m [Gio.DBusInterface.DBusInterface]), MonadIO m, IsDBusObject a) => O.OverloadedMethod DBusObjectGetInterfacesMethodInfo a signature where
    overloadedMethod = dBusObjectGetInterfaces

instance O.OverloadedMethodInfo DBusObjectGetInterfacesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DBusObject.dBusObjectGetInterfaces",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-DBusObject.html#v:dBusObjectGetInterfaces"
        })


#endif

-- method DBusObject::get_object_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObject" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObject." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_get_object_path" g_dbus_object_get_object_path :: 
    Ptr DBusObject ->                       -- object : TInterface (Name {namespace = "Gio", name = "DBusObject"})
    IO CString

-- | Gets the object path for /@object@/.
-- 
-- /Since: 2.30/
dBusObjectGetObjectPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObject a) =>
    a
    -- ^ /@object@/: A t'GI.Gio.Interfaces.DBusObject.DBusObject'.
    -> m T.Text
    -- ^ __Returns:__ A string owned by /@object@/. Do not free.
dBusObjectGetObjectPath object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    result <- g_dbus_object_get_object_path object'
    checkUnexpectedReturnNULL "dBusObjectGetObjectPath" result
    result' <- cstringToText result
    touchManagedPtr object
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusObjectGetObjectPathMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsDBusObject a) => O.OverloadedMethod DBusObjectGetObjectPathMethodInfo a signature where
    overloadedMethod = dBusObjectGetObjectPath

instance O.OverloadedMethodInfo DBusObjectGetObjectPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DBusObject.dBusObjectGetObjectPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-DBusObject.html#v:dBusObjectGetObjectPath"
        })


#endif

-- signal DBusObject::interface-added
-- | Emitted when /@interface@/ is added to /@object@/.
-- 
-- /Since: 2.30/
type DBusObjectInterfaceAddedCallback =
    Gio.DBusInterface.DBusInterface
    -- ^ /@interface@/: The t'GI.Gio.Interfaces.DBusInterface.DBusInterface' that was added.
    -> IO ()

type C_DBusObjectInterfaceAddedCallback =
    Ptr DBusObject ->                       -- object
    Ptr Gio.DBusInterface.DBusInterface ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DBusObjectInterfaceAddedCallback`.
foreign import ccall "wrapper"
    mk_DBusObjectInterfaceAddedCallback :: C_DBusObjectInterfaceAddedCallback -> IO (FunPtr C_DBusObjectInterfaceAddedCallback)

wrap_DBusObjectInterfaceAddedCallback :: 
    GObject a => (a -> DBusObjectInterfaceAddedCallback) ->
    C_DBusObjectInterfaceAddedCallback
wrap_DBusObjectInterfaceAddedCallback gi'cb gi'selfPtr interface _ = do
    interface' <- (newObject Gio.DBusInterface.DBusInterface) interface
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  interface'


-- | Connect a signal handler for the [interfaceAdded](#signal:interfaceAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dBusObject #interfaceAdded callback
-- @
-- 
-- 
onDBusObjectInterfaceAdded :: (IsDBusObject a, MonadIO m) => a -> ((?self :: a) => DBusObjectInterfaceAddedCallback) -> m SignalHandlerId
onDBusObjectInterfaceAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DBusObjectInterfaceAddedCallback wrapped
    wrapped'' <- mk_DBusObjectInterfaceAddedCallback wrapped'
    connectSignalFunPtr obj "interface-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [interfaceAdded](#signal:interfaceAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dBusObject #interfaceAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDBusObjectInterfaceAdded :: (IsDBusObject a, MonadIO m) => a -> ((?self :: a) => DBusObjectInterfaceAddedCallback) -> m SignalHandlerId
afterDBusObjectInterfaceAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DBusObjectInterfaceAddedCallback wrapped
    wrapped'' <- mk_DBusObjectInterfaceAddedCallback wrapped'
    connectSignalFunPtr obj "interface-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DBusObjectInterfaceAddedSignalInfo
instance SignalInfo DBusObjectInterfaceAddedSignalInfo where
    type HaskellCallbackType DBusObjectInterfaceAddedSignalInfo = DBusObjectInterfaceAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DBusObjectInterfaceAddedCallback cb
        cb'' <- mk_DBusObjectInterfaceAddedCallback cb'
        connectSignalFunPtr obj "interface-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DBusObject::interface-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-DBusObject.html#g:signal:interfaceAdded"})

#endif

-- signal DBusObject::interface-removed
-- | Emitted when /@interface@/ is removed from /@object@/.
-- 
-- /Since: 2.30/
type DBusObjectInterfaceRemovedCallback =
    Gio.DBusInterface.DBusInterface
    -- ^ /@interface@/: The t'GI.Gio.Interfaces.DBusInterface.DBusInterface' that was removed.
    -> IO ()

type C_DBusObjectInterfaceRemovedCallback =
    Ptr DBusObject ->                       -- object
    Ptr Gio.DBusInterface.DBusInterface ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DBusObjectInterfaceRemovedCallback`.
foreign import ccall "wrapper"
    mk_DBusObjectInterfaceRemovedCallback :: C_DBusObjectInterfaceRemovedCallback -> IO (FunPtr C_DBusObjectInterfaceRemovedCallback)

wrap_DBusObjectInterfaceRemovedCallback :: 
    GObject a => (a -> DBusObjectInterfaceRemovedCallback) ->
    C_DBusObjectInterfaceRemovedCallback
wrap_DBusObjectInterfaceRemovedCallback gi'cb gi'selfPtr interface _ = do
    interface' <- (newObject Gio.DBusInterface.DBusInterface) interface
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  interface'


-- | Connect a signal handler for the [interfaceRemoved](#signal:interfaceRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dBusObject #interfaceRemoved callback
-- @
-- 
-- 
onDBusObjectInterfaceRemoved :: (IsDBusObject a, MonadIO m) => a -> ((?self :: a) => DBusObjectInterfaceRemovedCallback) -> m SignalHandlerId
onDBusObjectInterfaceRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DBusObjectInterfaceRemovedCallback wrapped
    wrapped'' <- mk_DBusObjectInterfaceRemovedCallback wrapped'
    connectSignalFunPtr obj "interface-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [interfaceRemoved](#signal:interfaceRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dBusObject #interfaceRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDBusObjectInterfaceRemoved :: (IsDBusObject a, MonadIO m) => a -> ((?self :: a) => DBusObjectInterfaceRemovedCallback) -> m SignalHandlerId
afterDBusObjectInterfaceRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DBusObjectInterfaceRemovedCallback wrapped
    wrapped'' <- mk_DBusObjectInterfaceRemovedCallback wrapped'
    connectSignalFunPtr obj "interface-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DBusObjectInterfaceRemovedSignalInfo
instance SignalInfo DBusObjectInterfaceRemovedSignalInfo where
    type HaskellCallbackType DBusObjectInterfaceRemovedSignalInfo = DBusObjectInterfaceRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DBusObjectInterfaceRemovedCallback cb
        cb'' <- mk_DBusObjectInterfaceRemovedCallback cb'
        connectSignalFunPtr obj "interface-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DBusObject::interface-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-DBusObject.html#g:signal:interfaceRemoved"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DBusObject = DBusObjectSignalList
type DBusObjectSignalList = ('[ '("interfaceAdded", DBusObjectInterfaceAddedSignalInfo), '("interfaceRemoved", DBusObjectInterfaceRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


