

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Flags
    ( 

 -- * Flags


-- ** AsciiType #flag:AsciiType#

    AsciiType(..)                           ,


-- ** FileSetContentsFlags #flag:FileSetContentsFlags#

    FileSetContentsFlags(..)                ,


-- ** FileTest #flag:FileTest#

    FileTest(..)                            ,


-- ** FormatSizeFlags #flag:FormatSizeFlags#

    FormatSizeFlags(..)                     ,


-- ** HookFlagMask #flag:HookFlagMask#

    HookFlagMask(..)                        ,


-- ** IOCondition #flag:IOCondition#

    IOCondition(..)                         ,


-- ** IOFlags #flag:IOFlags#

    IOFlags(..)                             ,


-- ** KeyFileFlags #flag:KeyFileFlags#

    KeyFileFlags(..)                        ,


-- ** LogLevelFlags #flag:LogLevelFlags#

    LogLevelFlags(..)                       ,


-- ** MainContextFlags #flag:MainContextFlags#

    MainContextFlags(..)                    ,


-- ** MarkupCollectType #flag:MarkupCollectType#

    MarkupCollectType(..)                   ,


-- ** MarkupParseFlags #flag:MarkupParseFlags#

    MarkupParseFlags(..)                    ,


-- ** OptionFlags #flag:OptionFlags#

    OptionFlags(..)                         ,


-- ** RegexCompileFlags #flag:RegexCompileFlags#

    RegexCompileFlags(..)                   ,


-- ** RegexMatchFlags #flag:RegexMatchFlags#

    RegexMatchFlags(..)                     ,


-- ** SpawnFlags #flag:SpawnFlags#

    SpawnFlags(..)                          ,


-- ** TestSubprocessFlags #flag:TestSubprocessFlags#

    TestSubprocessFlags(..)                 ,


-- ** TestTrapFlags #flag:TestTrapFlags#

    TestTrapFlags(..)                       ,


-- ** TraverseFlags #flag:TraverseFlags#

    TraverseFlags(..)                       ,


-- ** UriFlags #flag:UriFlags#

    UriFlags(..)                            ,


-- ** UriHideFlags #flag:UriHideFlags#

    UriHideFlags(..)                        ,


-- ** UriParamsFlags #flag:UriParamsFlags#

    UriParamsFlags(..)                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags UriParamsFlags
-- | Flags modifying the way parameters are handled by 'GI.GLib.Functions.uriParseParams' and
-- t'GI.GLib.Structs.UriParamsIter.UriParamsIter'.
-- 
-- /Since: 2.66/
data UriParamsFlags = 
      UriParamsFlagsNone
    -- ^ No flags set.
    | UriParamsFlagsCaseInsensitive
    -- ^ Parameter names are case insensitive.
    | UriParamsFlagsWwwForm
    -- ^ Replace @+@ with space character. Only useful for
    --     URLs on the web, using the @https@ or @http@ schemas.
    | UriParamsFlagsParseRelaxed
    -- ^ See 'GI.GLib.Flags.UriFlagsParseRelaxed'.
    | AnotherUriParamsFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UriParamsFlags where
    fromEnum UriParamsFlagsNone = 0
    fromEnum UriParamsFlagsCaseInsensitive = 1
    fromEnum UriParamsFlagsWwwForm = 2
    fromEnum UriParamsFlagsParseRelaxed = 4
    fromEnum (AnotherUriParamsFlags k) = k

    toEnum 0 = UriParamsFlagsNone
    toEnum 1 = UriParamsFlagsCaseInsensitive
    toEnum 2 = UriParamsFlagsWwwForm
    toEnum 4 = UriParamsFlagsParseRelaxed
    toEnum k = AnotherUriParamsFlags k

instance P.Ord UriParamsFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag UriParamsFlags

-- Flags UriHideFlags
-- | Flags describing what parts of the URI to hide in
-- 'GI.GLib.Structs.Uri.uriToStringPartial'. Note that 'GI.GLib.Flags.UriHideFlagsPassword' and
-- 'GI.GLib.Flags.UriHideFlagsAuthParams' will only work if the t'GI.GLib.Structs.Uri.Uri' was parsed with
-- the corresponding flags.
-- 
-- /Since: 2.66/
data UriHideFlags = 
      UriHideFlagsNone
    -- ^ No flags set.
    | UriHideFlagsUserinfo
    -- ^ Hide the userinfo.
    | UriHideFlagsPassword
    -- ^ Hide the password.
    | UriHideFlagsAuthParams
    -- ^ Hide the auth_params.
    | UriHideFlagsQuery
    -- ^ Hide the query.
    | UriHideFlagsFragment
    -- ^ Hide the fragment.
    | AnotherUriHideFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UriHideFlags where
    fromEnum UriHideFlagsNone = 0
    fromEnum UriHideFlagsUserinfo = 1
    fromEnum UriHideFlagsPassword = 2
    fromEnum UriHideFlagsAuthParams = 4
    fromEnum UriHideFlagsQuery = 8
    fromEnum UriHideFlagsFragment = 16
    fromEnum (AnotherUriHideFlags k) = k

    toEnum 0 = UriHideFlagsNone
    toEnum 1 = UriHideFlagsUserinfo
    toEnum 2 = UriHideFlagsPassword
    toEnum 4 = UriHideFlagsAuthParams
    toEnum 8 = UriHideFlagsQuery
    toEnum 16 = UriHideFlagsFragment
    toEnum k = AnotherUriHideFlags k

instance P.Ord UriHideFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag UriHideFlags

-- Flags UriFlags
-- | Flags that describe a URI.
-- 
-- When parsing a URI, if you need to choose different flags based on
-- the type of URI, you can use 'GI.GLib.Functions.uriPeekScheme' on the URI string
-- to check the scheme first, and use that to decide what flags to
-- parse it with.
-- 
-- /Since: 2.66/
data UriFlags = 
      UriFlagsNone
    -- ^ No flags set.
    | UriFlagsParseRelaxed
    -- ^ Parse the URI more relaxedly than the
    --     <https://tools.ietf.org/html/rfc3986 RFC 3986> grammar specifies,
    --     fixing up or ignoring common mistakes in URIs coming from external
    --     sources. This is also needed for some obscure URI schemes where @;@
    --     separates the host from the path. Don’t use this flag unless you need to.
    | UriFlagsHasPassword
    -- ^ The userinfo field may contain a password,
    --     which will be separated from the username by @:@.
    | UriFlagsHasAuthParams
    -- ^ The userinfo may contain additional
    --     authentication-related parameters, which will be separated from
    --     the username and\/or password by @;@.
    | UriFlagsEncoded
    -- ^ When parsing a URI, this indicates that @%@-encoded
    --     characters in the userinfo, path, query, and fragment fields
    --     should not be decoded. (And likewise the host field if
    --     'GI.GLib.Flags.UriFlagsNonDns' is also set.) When building a URI, it indicates
    --     that you have already @%@-encoded the components, and so t'GI.GLib.Structs.Uri.Uri'
    --     should not do any encoding itself.
    | UriFlagsNonDns
    -- ^ The host component should not be assumed to be a
    --     DNS hostname or IP address (for example, for @smb@ URIs with NetBIOS
    --     hostnames).
    | UriFlagsEncodedQuery
    -- ^ Same as 'GI.GLib.Flags.UriFlagsEncoded', for the query
    --     field only.
    | UriFlagsEncodedPath
    -- ^ Same as 'GI.GLib.Flags.UriFlagsEncoded', for the path only.
    | UriFlagsEncodedFragment
    -- ^ Same as 'GI.GLib.Flags.UriFlagsEncoded', for the
    --     fragment only.
    | UriFlagsSchemeNormalize
    -- ^ A scheme-based normalization will be applied.
    --     For example, when parsing an HTTP URI changing omitted path to @\/@ and
    --     omitted port to @80@; and when building a URI, changing empty path to @\/@
    --     and default port @80@). This only supports a subset of known schemes. (Since: 2.68)
    | AnotherUriFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UriFlags where
    fromEnum UriFlagsNone = 0
    fromEnum UriFlagsParseRelaxed = 1
    fromEnum UriFlagsHasPassword = 2
    fromEnum UriFlagsHasAuthParams = 4
    fromEnum UriFlagsEncoded = 8
    fromEnum UriFlagsNonDns = 16
    fromEnum UriFlagsEncodedQuery = 32
    fromEnum UriFlagsEncodedPath = 64
    fromEnum UriFlagsEncodedFragment = 128
    fromEnum UriFlagsSchemeNormalize = 256
    fromEnum (AnotherUriFlags k) = k

    toEnum 0 = UriFlagsNone
    toEnum 1 = UriFlagsParseRelaxed
    toEnum 2 = UriFlagsHasPassword
    toEnum 4 = UriFlagsHasAuthParams
    toEnum 8 = UriFlagsEncoded
    toEnum 16 = UriFlagsNonDns
    toEnum 32 = UriFlagsEncodedQuery
    toEnum 64 = UriFlagsEncodedPath
    toEnum 128 = UriFlagsEncodedFragment
    toEnum 256 = UriFlagsSchemeNormalize
    toEnum k = AnotherUriFlags k

instance P.Ord UriFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag UriFlags

-- Flags TraverseFlags
-- | Specifies which nodes are visited during several of the tree
-- functions, including 'GI.GLib.Structs.Node.nodeTraverse' and @/g_node_find()/@.
data TraverseFlags = 
      TraverseFlagsLeaves
    -- ^ only leaf nodes should be visited. This name has
    --                     been introduced in 2.6, for older version use
    --                     'GI.GLib.Flags.TraverseFlagsLeafs'.
    | TraverseFlagsNonLeaves
    -- ^ only non-leaf nodes should be visited. This
    --                         name has been introduced in 2.6, for older
    --                         version use 'GI.GLib.Flags.TraverseFlagsNonLeafs'.
    | TraverseFlagsAll
    -- ^ all nodes should be visited.
    | TraverseFlagsMask
    -- ^ a mask of all traverse flags.
    | TraverseFlagsLeafs
    -- ^ identical to 'GI.GLib.Flags.TraverseFlagsLeaves'.
    | TraverseFlagsNonLeafs
    -- ^ identical to 'GI.GLib.Flags.TraverseFlagsNonLeaves'.
    | AnotherTraverseFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TraverseFlags where
    fromEnum TraverseFlagsLeaves = 1
    fromEnum TraverseFlagsNonLeaves = 2
    fromEnum TraverseFlagsAll = 3
    fromEnum TraverseFlagsMask = 3
    fromEnum TraverseFlagsLeafs = 1
    fromEnum TraverseFlagsNonLeafs = 2
    fromEnum (AnotherTraverseFlags k) = k

    toEnum 1 = TraverseFlagsLeaves
    toEnum 2 = TraverseFlagsNonLeaves
    toEnum 3 = TraverseFlagsAll
    toEnum k = AnotherTraverseFlags k

instance P.Ord TraverseFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag TraverseFlags

-- Flags TestTrapFlags
{-# DEPRECATED TestTrapFlags ["(Since version 2.38)","@GTestTrapFlags@ is used only with 'GI.GLib.Functions.testTrapFork',","  which is deprecated. Its replacement, 'GI.GLib.Functions.testTrapSubprocess' uses","  [flags/@gLib@/.TestSubprocessFlags]."] #-}
-- | Flags to pass to 'GI.GLib.Functions.testTrapFork' to control input and output.
-- 
-- Test traps are guards around forked tests. These flags determine what traps to set.
data TestTrapFlags = 
      TestTrapFlagsDefault
    -- ^ Default behaviour. Since: 2.74
    | TestTrapFlagsSilenceStdout
    -- ^ Redirect stdout of the test child to
    --     @\/dev\/null@ so it cannot be observed on the console during test
    --     runs. The actual output is still captured though to allow later
    --     tests with @/g_test_trap_assert_stdout()/@.
    | TestTrapFlagsSilenceStderr
    -- ^ Redirect stderr of the test child to
    --     @\/dev\/null@ so it cannot be observed on the console during test
    --     runs. The actual output is still captured though to allow later
    --     tests with @/g_test_trap_assert_stderr()/@.
    | TestTrapFlagsInheritStdin
    -- ^ If this flag is given, stdin of the
    --     child process is shared with stdin of its parent process.
    --     It is redirected to @\/dev\/null@ otherwise.
    | AnotherTestTrapFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TestTrapFlags where
    fromEnum TestTrapFlagsDefault = 0
    fromEnum TestTrapFlagsSilenceStdout = 128
    fromEnum TestTrapFlagsSilenceStderr = 256
    fromEnum TestTrapFlagsInheritStdin = 512
    fromEnum (AnotherTestTrapFlags k) = k

    toEnum 0 = TestTrapFlagsDefault
    toEnum 128 = TestTrapFlagsSilenceStdout
    toEnum 256 = TestTrapFlagsSilenceStderr
    toEnum 512 = TestTrapFlagsInheritStdin
    toEnum k = AnotherTestTrapFlags k

instance P.Ord TestTrapFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag TestTrapFlags

-- Flags TestSubprocessFlags
-- | Flags to pass to 'GI.GLib.Functions.testTrapSubprocess' to control input and output.
-- 
-- Note that in contrast with 'GI.GLib.Functions.testTrapFork', the default
-- behavior of 'GI.GLib.Functions.testTrapSubprocess' is to not show stdout
-- and stderr.
data TestSubprocessFlags = 
      TestSubprocessFlagsDefault
    -- ^ Default behaviour. Since: 2.74
    | TestSubprocessFlagsInheritStdin
    -- ^ If this flag is given, the child
    --   process will inherit the parent\'s stdin. Otherwise, the child\'s
    --   stdin is redirected to @\/dev\/null@.
    | TestSubprocessFlagsInheritStdout
    -- ^ If this flag is given, the child
    --   process will inherit the parent\'s stdout. Otherwise, the child\'s
    --   stdout will not be visible, but it will be captured to allow
    --   later tests with @/GLib.test_trap_assert_stdout/@.
    | TestSubprocessFlagsInheritStderr
    -- ^ If this flag is given, the child
    --   process will inherit the parent\'s stderr. Otherwise, the child\'s
    --   stderr will not be visible, but it will be captured to allow
    --   later tests with @/GLib.test_trap_assert_stderr/@.
    | AnotherTestSubprocessFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TestSubprocessFlags where
    fromEnum TestSubprocessFlagsDefault = 0
    fromEnum TestSubprocessFlagsInheritStdin = 1
    fromEnum TestSubprocessFlagsInheritStdout = 2
    fromEnum TestSubprocessFlagsInheritStderr = 4
    fromEnum (AnotherTestSubprocessFlags k) = k

    toEnum 0 = TestSubprocessFlagsDefault
    toEnum 1 = TestSubprocessFlagsInheritStdin
    toEnum 2 = TestSubprocessFlagsInheritStdout
    toEnum 4 = TestSubprocessFlagsInheritStderr
    toEnum k = AnotherTestSubprocessFlags k

instance P.Ord TestSubprocessFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag TestSubprocessFlags

-- Flags SpawnFlags
-- | Flags passed to 'GI.GLib.Functions.spawnSync', 'GI.GLib.Functions.spawnAsync' and 'GI.GLib.Functions.spawnAsyncWithPipes'.
data SpawnFlags = 
      SpawnFlagsDefault
    -- ^ no flags, default behaviour
    | SpawnFlagsLeaveDescriptorsOpen
    -- ^ the parent\'s open file descriptors will
    --     be inherited by the child; otherwise all descriptors except stdin,
    --     stdout and stderr will be closed before calling @/exec()/@ in the child.
    | SpawnFlagsDoNotReapChild
    -- ^ the child will not be automatically reaped;
    --     you must use @/g_child_watch_add()/@ yourself (or call @/waitpid()/@ or handle
    --     @SIGCHLD@ yourself), or the child will become a zombie.
    | SpawnFlagsSearchPath
    -- ^ @argv[0]@ need not be an absolute path, it will be
    --     looked for in the user\'s @PATH@.
    | SpawnFlagsStdoutToDevNull
    -- ^ the child\'s standard output will be discarded,
    --     instead of going to the same location as the parent\'s standard output.
    | SpawnFlagsStderrToDevNull
    -- ^ the child\'s standard error will be discarded.
    | SpawnFlagsChildInheritsStdin
    -- ^ the child will inherit the parent\'s standard
    --     input (by default, the child\'s standard input is attached to @\/dev\/null@).
    | SpawnFlagsFileAndArgvZero
    -- ^ the first element of @argv@ is the file to
    --     execute, while the remaining elements are the actual argument vector
    --     to pass to the file. Normally 'GI.GLib.Functions.spawnAsyncWithPipes' uses @argv[0]@
    --     as the file to execute, and passes all of @argv@ to the child.
    | SpawnFlagsSearchPathFromEnvp
    -- ^ if @argv[0]@ is not an absolute path,
    --     it will be looked for in the @PATH@ from the passed child environment.
    --     Since: 2.34
    | SpawnFlagsCloexecPipes
    -- ^ create all pipes with the @O_CLOEXEC@ flag set.
    --     Since: 2.40
    | SpawnFlagsChildInheritsStdout
    -- ^ The child will inherit the parent\'s standard output.
    -- 
    -- /Since: 2.74/
    | SpawnFlagsChildInheritsStderr
    -- ^ The child will inherit the parent\'s standard error.
    -- 
    -- /Since: 2.74/
    | SpawnFlagsStdinFromDevNull
    -- ^ The child\'s standard input is attached to @\/dev\/null@.
    -- 
    -- /Since: 2.74/
    | AnotherSpawnFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SpawnFlags where
    fromEnum SpawnFlagsDefault = 0
    fromEnum SpawnFlagsLeaveDescriptorsOpen = 1
    fromEnum SpawnFlagsDoNotReapChild = 2
    fromEnum SpawnFlagsSearchPath = 4
    fromEnum SpawnFlagsStdoutToDevNull = 8
    fromEnum SpawnFlagsStderrToDevNull = 16
    fromEnum SpawnFlagsChildInheritsStdin = 32
    fromEnum SpawnFlagsFileAndArgvZero = 64
    fromEnum SpawnFlagsSearchPathFromEnvp = 128
    fromEnum SpawnFlagsCloexecPipes = 256
    fromEnum SpawnFlagsChildInheritsStdout = 512
    fromEnum SpawnFlagsChildInheritsStderr = 1024
    fromEnum SpawnFlagsStdinFromDevNull = 2048
    fromEnum (AnotherSpawnFlags k) = k

    toEnum 0 = SpawnFlagsDefault
    toEnum 1 = SpawnFlagsLeaveDescriptorsOpen
    toEnum 2 = SpawnFlagsDoNotReapChild
    toEnum 4 = SpawnFlagsSearchPath
    toEnum 8 = SpawnFlagsStdoutToDevNull
    toEnum 16 = SpawnFlagsStderrToDevNull
    toEnum 32 = SpawnFlagsChildInheritsStdin
    toEnum 64 = SpawnFlagsFileAndArgvZero
    toEnum 128 = SpawnFlagsSearchPathFromEnvp
    toEnum 256 = SpawnFlagsCloexecPipes
    toEnum 512 = SpawnFlagsChildInheritsStdout
    toEnum 1024 = SpawnFlagsChildInheritsStderr
    toEnum 2048 = SpawnFlagsStdinFromDevNull
    toEnum k = AnotherSpawnFlags k

instance P.Ord SpawnFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag SpawnFlags

-- Flags RegexMatchFlags
-- | Flags specifying match-time options.
-- 
-- /Since: 2.14/
data RegexMatchFlags = 
      RegexMatchFlagsDefault
    -- ^ No special options set. Since: 2.74
    | RegexMatchFlagsAnchored
    -- ^ The pattern is forced to be \"anchored\", that is,
    --     it is constrained to match only at the first matching point in the
    --     string that is being searched. This effect can also be achieved by
    --     appropriate constructs in the pattern itself such as the \"^\"
    --     metacharacter.
    | RegexMatchFlagsNotbol
    -- ^ Specifies that first character of the string is
    --     not the beginning of a line, so the circumflex metacharacter should
    --     not match before it. Setting this without 'GI.GLib.Flags.RegexCompileFlagsMultiline' (at
    --     compile time) causes circumflex never to match. This option affects
    --     only the behaviour of the circumflex metacharacter, it does not
    --     affect \"\\A\".
    | RegexMatchFlagsNoteol
    -- ^ Specifies that the end of the subject string is
    --     not the end of a line, so the dollar metacharacter should not match
    --     it nor (except in multiline mode) a newline immediately before it.
    --     Setting this without 'GI.GLib.Flags.RegexCompileFlagsMultiline' (at compile time) causes
    --     dollar never to match. This option affects only the behaviour of
    --     the dollar metacharacter, it does not affect \"\\Z\" or \"\\z\".
    | RegexMatchFlagsNotempty
    -- ^ An empty string is not considered to be a valid
    --     match if this option is set. If there are alternatives in the pattern,
    --     they are tried. If all the alternatives match the empty string, the
    --     entire match fails. For example, if the pattern \"a?b?\" is applied to
    --     a string not beginning with \"a\" or \"b\", it matches the empty string
    --     at the start of the string. With this flag set, this match is not
    --     valid, so GRegex searches further into the string for occurrences
    --     of \"a\" or \"b\".
    | RegexMatchFlagsPartial
    -- ^ Turns on the partial matching feature, for more
    --     documentation on partial matching see 'GI.GLib.Structs.MatchInfo.matchInfoIsPartialMatch'.
    | RegexMatchFlagsNewlineCr
    -- ^ Overrides the newline definition set when
    --     creating a new t'GI.GLib.Structs.Regex.Regex', setting the \'\\r\' character as line terminator.
    | RegexMatchFlagsNewlineLf
    -- ^ Overrides the newline definition set when
    --     creating a new t'GI.GLib.Structs.Regex.Regex', setting the \'\\n\' character as line terminator.
    | RegexMatchFlagsNewlineCrlf
    -- ^ Overrides the newline definition set when
    --     creating a new t'GI.GLib.Structs.Regex.Regex', setting the \'\\r\\n\' characters sequence as line terminator.
    | RegexMatchFlagsNewlineAny
    -- ^ Overrides the newline definition set when
    --     creating a new t'GI.GLib.Structs.Regex.Regex', any Unicode newline sequence
    --     is recognised as a newline. These are \'\\r\', \'\\n\' and \'\\rn\', and the
    --     single characters U+000B LINE TABULATION, U+000C FORM FEED (FF),
    --     U+0085 NEXT LINE (NEL), U+2028 LINE SEPARATOR and
    --     U+2029 PARAGRAPH SEPARATOR.
    | RegexMatchFlagsNewlineAnycrlf
    -- ^ Overrides the newline definition set when
    --     creating a new t'GI.GLib.Structs.Regex.Regex'; any \'\\r\', \'\\n\', or \'\\r\\n\' character sequence
    --     is recognized as a newline. Since: 2.34
    | RegexMatchFlagsBsrAnycrlf
    -- ^ Overrides the newline definition for \"\\R\" set when
    --     creating a new t'GI.GLib.Structs.Regex.Regex'; only \'\\r\', \'\\n\', or \'\\r\\n\' character sequences
    --     are recognized as a newline by \"\\R\". Since: 2.34
    | RegexMatchFlagsBsrAny
    -- ^ Overrides the newline definition for \"\\R\" set when
    --     creating a new t'GI.GLib.Structs.Regex.Regex'; any Unicode newline character or character sequence
    --     are recognized as a newline by \"\\R\". These are \'\\r\', \'\\n\' and \'\\rn\', and the
    --     single characters U+000B LINE TABULATION, U+000C FORM FEED (FF),
    --     U+0085 NEXT LINE (NEL), U+2028 LINE SEPARATOR and
    --     U+2029 PARAGRAPH SEPARATOR. Since: 2.34
    | RegexMatchFlagsPartialSoft
    -- ^ An alias for 'GI.GLib.Flags.RegexMatchFlagsPartial'. Since: 2.34
    | RegexMatchFlagsPartialHard
    -- ^ Turns on the partial matching feature. In contrast to
    --     to 'GI.GLib.Flags.RegexMatchFlagsPartialSoft', this stops matching as soon as a partial match
    --     is found, without continuing to search for a possible complete match. See
    --     'GI.GLib.Structs.MatchInfo.matchInfoIsPartialMatch' for more information. Since: 2.34
    | RegexMatchFlagsNotemptyAtstart
    -- ^ Like 'GI.GLib.Flags.RegexMatchFlagsNotempty', but only applied to
    --     the start of the matched string. For anchored
    --     patterns this can only happen for pattern containing \"\\K\". Since: 2.34
    | AnotherRegexMatchFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum RegexMatchFlags where
    fromEnum RegexMatchFlagsDefault = 0
    fromEnum RegexMatchFlagsAnchored = 16
    fromEnum RegexMatchFlagsNotbol = 128
    fromEnum RegexMatchFlagsNoteol = 256
    fromEnum RegexMatchFlagsNotempty = 1024
    fromEnum RegexMatchFlagsPartial = 32768
    fromEnum RegexMatchFlagsNewlineCr = 1048576
    fromEnum RegexMatchFlagsNewlineLf = 2097152
    fromEnum RegexMatchFlagsNewlineCrlf = 3145728
    fromEnum RegexMatchFlagsNewlineAny = 4194304
    fromEnum RegexMatchFlagsNewlineAnycrlf = 5242880
    fromEnum RegexMatchFlagsBsrAnycrlf = 8388608
    fromEnum RegexMatchFlagsBsrAny = 16777216
    fromEnum RegexMatchFlagsPartialSoft = 32768
    fromEnum RegexMatchFlagsPartialHard = 134217728
    fromEnum RegexMatchFlagsNotemptyAtstart = 268435456
    fromEnum (AnotherRegexMatchFlags k) = k

    toEnum 0 = RegexMatchFlagsDefault
    toEnum 16 = RegexMatchFlagsAnchored
    toEnum 128 = RegexMatchFlagsNotbol
    toEnum 256 = RegexMatchFlagsNoteol
    toEnum 1024 = RegexMatchFlagsNotempty
    toEnum 32768 = RegexMatchFlagsPartial
    toEnum 1048576 = RegexMatchFlagsNewlineCr
    toEnum 2097152 = RegexMatchFlagsNewlineLf
    toEnum 3145728 = RegexMatchFlagsNewlineCrlf
    toEnum 4194304 = RegexMatchFlagsNewlineAny
    toEnum 5242880 = RegexMatchFlagsNewlineAnycrlf
    toEnum 8388608 = RegexMatchFlagsBsrAnycrlf
    toEnum 16777216 = RegexMatchFlagsBsrAny
    toEnum 134217728 = RegexMatchFlagsPartialHard
    toEnum 268435456 = RegexMatchFlagsNotemptyAtstart
    toEnum k = AnotherRegexMatchFlags k

instance P.Ord RegexMatchFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag RegexMatchFlags

-- Flags RegexCompileFlags
-- | Flags specifying compile-time options.
-- 
-- /Since: 2.14/
data RegexCompileFlags = 
      RegexCompileFlagsDefault
    -- ^ No special options set. Since: 2.74
    | RegexCompileFlagsCaseless
    -- ^ Letters in the pattern match both upper- and
    --     lowercase letters. This option can be changed within a pattern
    --     by a \"(?i)\" option setting.
    | RegexCompileFlagsMultiline
    -- ^ By default, GRegex treats the strings as consisting
    --     of a single line of characters (even if it actually contains
    --     newlines). The \"start of line\" metacharacter (\"^\") matches only
    --     at the start of the string, while the \"end of line\" metacharacter
    --     (\"$\") matches only at the end of the string, or before a terminating
    --     newline (unless 'GI.GLib.Flags.RegexCompileFlagsDollarEndonly' is set). When
    --     'GI.GLib.Flags.RegexCompileFlagsMultiline' is set, the \"start of line\" and \"end of line\"
    --     constructs match immediately following or immediately before any
    --     newline in the string, respectively, as well as at the very start
    --     and end. This can be changed within a pattern by a \"(?m)\" option
    --     setting.
    | RegexCompileFlagsDotall
    -- ^ A dot metacharacter (\".\") in the pattern matches all
    --     characters, including newlines. Without it, newlines are excluded.
    --     This option can be changed within a pattern by a (\"?s\") option setting.
    | RegexCompileFlagsExtended
    -- ^ Whitespace data characters in the pattern are
    --     totally ignored except when escaped or inside a character class.
    --     Whitespace does not include the VT character (code 11). In addition,
    --     characters between an unescaped \"#\" outside a character class and
    --     the next newline character, inclusive, are also ignored. This can
    --     be changed within a pattern by a \"(?x)\" option setting.
    | RegexCompileFlagsAnchored
    -- ^ The pattern is forced to be \"anchored\", that is,
    --     it is constrained to match only at the first matching point in the
    --     string that is being searched. This effect can also be achieved by
    --     appropriate constructs in the pattern itself such as the \"^\"
    --     metacharacter.
    | RegexCompileFlagsDollarEndonly
    -- ^ A dollar metacharacter (\"$\") in the pattern
    --     matches only at the end of the string. Without this option, a
    --     dollar also matches immediately before the final character if
    --     it is a newline (but not before any other newlines). This option
    --     is ignored if 'GI.GLib.Flags.RegexCompileFlagsMultiline' is set.
    | RegexCompileFlagsUngreedy
    -- ^ Inverts the \"greediness\" of the quantifiers so that
    --     they are not greedy by default, but become greedy if followed by \"?\".
    --     It can also be set by a \"(?U)\" option setting within the pattern.
    | RegexCompileFlagsRaw
    -- ^ Usually strings must be valid UTF-8 strings, using this
    --     flag they are considered as a raw sequence of bytes.
    | RegexCompileFlagsNoAutoCapture
    -- ^ Disables the use of numbered capturing
    --     parentheses in the pattern. Any opening parenthesis that is not
    --     followed by \"?\" behaves as if it were followed by \"?:\" but named
    --     parentheses can still be used for capturing (and they acquire numbers
    --     in the usual way).
    | RegexCompileFlagsOptimize
    -- ^ Since 2.74 and the port to pcre2, requests JIT
    --     compilation, which, if the just-in-time compiler is available, further
    --     processes a compiled pattern into machine code that executes much
    --     faster. However, it comes at the cost of extra processing before the
    --     match is performed, so it is most beneficial to use this when the same
    --     compiled pattern is used for matching many times. Before 2.74 this
    --     option used the built-in non-JIT optimizations in pcre1.
    | RegexCompileFlagsFirstline
    -- ^ Limits an unanchored pattern to match before (or at) the
    --     first newline. Since: 2.34
    | RegexCompileFlagsDupnames
    -- ^ Names used to identify capturing subpatterns need not
    --     be unique. This can be helpful for certain types of pattern when it
    --     is known that only one instance of the named subpattern can ever be
    --     matched.
    | RegexCompileFlagsNewlineCr
    -- ^ Usually any newline character or character sequence is
    --     recognized. If this option is set, the only recognized newline character
    --     is \'\\r\'.
    | RegexCompileFlagsNewlineLf
    -- ^ Usually any newline character or character sequence is
    --     recognized. If this option is set, the only recognized newline character
    --     is \'\\n\'.
    | RegexCompileFlagsNewlineCrlf
    -- ^ Usually any newline character or character sequence is
    --     recognized. If this option is set, the only recognized newline character
    --     sequence is \'\\r\\n\'.
    | RegexCompileFlagsNewlineAnycrlf
    -- ^ Usually any newline character or character sequence
    --     is recognized. If this option is set, the only recognized newline character
    --     sequences are \'\\r\', \'\\n\', and \'\\r\\n\'. Since: 2.34
    | RegexCompileFlagsBsrAnycrlf
    -- ^ Usually any newline character or character sequence
    --     is recognised. If this option is set, then \"\\R\" only recognizes the newline
    --    characters \'\\r\', \'\\n\' and \'\\r\\n\'. Since: 2.34
    | RegexCompileFlagsJavascriptCompat
    -- ^ Changes behaviour so that it is compatible with
    --     JavaScript rather than PCRE. Since GLib 2.74 this is no longer supported,
    --     as libpcre2 does not support it. Since: 2.34 Deprecated: 2.74
    | AnotherRegexCompileFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum RegexCompileFlags where
    fromEnum RegexCompileFlagsDefault = 0
    fromEnum RegexCompileFlagsCaseless = 1
    fromEnum RegexCompileFlagsMultiline = 2
    fromEnum RegexCompileFlagsDotall = 4
    fromEnum RegexCompileFlagsExtended = 8
    fromEnum RegexCompileFlagsAnchored = 16
    fromEnum RegexCompileFlagsDollarEndonly = 32
    fromEnum RegexCompileFlagsUngreedy = 512
    fromEnum RegexCompileFlagsRaw = 2048
    fromEnum RegexCompileFlagsNoAutoCapture = 4096
    fromEnum RegexCompileFlagsOptimize = 8192
    fromEnum RegexCompileFlagsFirstline = 262144
    fromEnum RegexCompileFlagsDupnames = 524288
    fromEnum RegexCompileFlagsNewlineCr = 1048576
    fromEnum RegexCompileFlagsNewlineLf = 2097152
    fromEnum RegexCompileFlagsNewlineCrlf = 3145728
    fromEnum RegexCompileFlagsNewlineAnycrlf = 5242880
    fromEnum RegexCompileFlagsBsrAnycrlf = 8388608
    fromEnum RegexCompileFlagsJavascriptCompat = 33554432
    fromEnum (AnotherRegexCompileFlags k) = k

    toEnum 0 = RegexCompileFlagsDefault
    toEnum 1 = RegexCompileFlagsCaseless
    toEnum 2 = RegexCompileFlagsMultiline
    toEnum 4 = RegexCompileFlagsDotall
    toEnum 8 = RegexCompileFlagsExtended
    toEnum 16 = RegexCompileFlagsAnchored
    toEnum 32 = RegexCompileFlagsDollarEndonly
    toEnum 512 = RegexCompileFlagsUngreedy
    toEnum 2048 = RegexCompileFlagsRaw
    toEnum 4096 = RegexCompileFlagsNoAutoCapture
    toEnum 8192 = RegexCompileFlagsOptimize
    toEnum 262144 = RegexCompileFlagsFirstline
    toEnum 524288 = RegexCompileFlagsDupnames
    toEnum 1048576 = RegexCompileFlagsNewlineCr
    toEnum 2097152 = RegexCompileFlagsNewlineLf
    toEnum 3145728 = RegexCompileFlagsNewlineCrlf
    toEnum 5242880 = RegexCompileFlagsNewlineAnycrlf
    toEnum 8388608 = RegexCompileFlagsBsrAnycrlf
    toEnum 33554432 = RegexCompileFlagsJavascriptCompat
    toEnum k = AnotherRegexCompileFlags k

instance P.Ord RegexCompileFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag RegexCompileFlags

-- Flags OptionFlags
-- | Flags which modify individual options.
data OptionFlags = 
      OptionFlagsNone
    -- ^ No flags.
    -- 
    -- /Since: 2.42/
    | OptionFlagsHidden
    -- ^ The option doesn\'t appear in @--help@ output.
    | OptionFlagsInMain
    -- ^ The option appears in the main section of the
    --   @--help@ output, even if it is defined in a group.
    | OptionFlagsReverse
    -- ^ For options of the 'GI.GLib.Enums.OptionArgNone' kind, this
    --   flag indicates that the sense of the option is reversed. i.e. 'P.False' will
    --   be stored into the argument rather than 'P.True'.
    | OptionFlagsNoArg
    -- ^ For options of the 'GI.GLib.Enums.OptionArgCallback' kind,
    --   this flag indicates that the callback does not take any argument
    --   (like a 'GI.GLib.Enums.OptionArgNone' option). Since 2.8
    | OptionFlagsFilename
    -- ^ For options of the 'GI.GLib.Enums.OptionArgCallback'
    --   kind, this flag indicates that the argument should be passed to the
    --   callback in the GLib filename encoding rather than UTF-8. Since 2.8
    | OptionFlagsOptionalArg
    -- ^ For options of the 'GI.GLib.Enums.OptionArgCallback'
    --   kind, this flag indicates that the argument supply is optional.
    --   If no argument is given then data of @/GOptionParseFunc/@ will be
    --   set to NULL. Since 2.8
    | OptionFlagsNoalias
    -- ^ This flag turns off the automatic conflict
    --   resolution which prefixes long option names with @groupname-@ if
    --   there is a conflict. This option should only be used in situations
    --   where aliasing is necessary to model some legacy commandline interface.
    --   It is not safe to use this option, unless all option groups are under
    --   your direct control. Since 2.8.
    | OptionFlagsDeprecated
    -- ^ This flag marks the option as deprecated in the @--help@.
    -- 
    -- You should update the description of the option to describe what
    -- the user should do in response to the deprecation, for instance:
    -- remove the option, or replace it with another one.
    -- 
    -- /Since: 2.84/
    | AnotherOptionFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OptionFlags where
    fromEnum OptionFlagsNone = 0
    fromEnum OptionFlagsHidden = 1
    fromEnum OptionFlagsInMain = 2
    fromEnum OptionFlagsReverse = 4
    fromEnum OptionFlagsNoArg = 8
    fromEnum OptionFlagsFilename = 16
    fromEnum OptionFlagsOptionalArg = 32
    fromEnum OptionFlagsNoalias = 64
    fromEnum OptionFlagsDeprecated = 128
    fromEnum (AnotherOptionFlags k) = k

    toEnum 0 = OptionFlagsNone
    toEnum 1 = OptionFlagsHidden
    toEnum 2 = OptionFlagsInMain
    toEnum 4 = OptionFlagsReverse
    toEnum 8 = OptionFlagsNoArg
    toEnum 16 = OptionFlagsFilename
    toEnum 32 = OptionFlagsOptionalArg
    toEnum 64 = OptionFlagsNoalias
    toEnum 128 = OptionFlagsDeprecated
    toEnum k = AnotherOptionFlags k

instance P.Ord OptionFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag OptionFlags

-- Flags MarkupParseFlags
-- | Flags that affect the behaviour of the parser.
data MarkupParseFlags = 
      MarkupParseFlagsDefaultFlags
    -- ^ No special behaviour. Since: 2.74
    | MarkupParseFlagsDoNotUseThisUnsupportedFlag
    -- ^ flag you should not use
    | MarkupParseFlagsTreatCdataAsText
    -- ^ When this flag is set, CDATA marked
    --     sections are not passed literally to the /@passthrough@/ function of
    --     the parser. Instead, the content of the section (without the
    --     @\<![CDATA[@ and @]]>@) is
    --     passed to the /@text@/ function. This flag was added in GLib 2.12
    | MarkupParseFlagsPrefixErrorPosition
    -- ^ Normally errors caught by GMarkup
    --     itself have line\/column information prefixed to them to let the
    --     caller know the location of the error. When this flag is set the
    --     location information is also prefixed to errors generated by the
    --     t'GI.GLib.Structs.MarkupParser.MarkupParser' implementation functions
    | MarkupParseFlagsIgnoreQualified
    -- ^ Ignore (don\'t report) qualified
    --     attributes and tags, along with their contents.  A qualified
    --     attribute or tag is one that contains \':\' in its name (ie: is in
    --     another namespace).  Since: 2.40.
    | AnotherMarkupParseFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MarkupParseFlags where
    fromEnum MarkupParseFlagsDefaultFlags = 0
    fromEnum MarkupParseFlagsDoNotUseThisUnsupportedFlag = 1
    fromEnum MarkupParseFlagsTreatCdataAsText = 2
    fromEnum MarkupParseFlagsPrefixErrorPosition = 4
    fromEnum MarkupParseFlagsIgnoreQualified = 8
    fromEnum (AnotherMarkupParseFlags k) = k

    toEnum 0 = MarkupParseFlagsDefaultFlags
    toEnum 1 = MarkupParseFlagsDoNotUseThisUnsupportedFlag
    toEnum 2 = MarkupParseFlagsTreatCdataAsText
    toEnum 4 = MarkupParseFlagsPrefixErrorPosition
    toEnum 8 = MarkupParseFlagsIgnoreQualified
    toEnum k = AnotherMarkupParseFlags k

instance P.Ord MarkupParseFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag MarkupParseFlags

-- Flags MarkupCollectType
-- | A mixed enumerated type and flags field. You must specify one type
-- (string, strdup, boolean, tristate).  Additionally, you may  optionally
-- bitwise OR the type with the flag 'GI.GLib.Flags.MarkupCollectTypeOptional'.
-- 
-- It is likely that this enum will be extended in the future to
-- support other types.
data MarkupCollectType = 
      MarkupCollectTypeInvalid
    -- ^ used to terminate the list of attributes
    --     to collect
    | MarkupCollectTypeString
    -- ^ collect the string pointer directly from
    --     the attribute_values[] array. Expects a parameter of type (const
    --     char __). If 'GI.GLib.Flags.MarkupCollectTypeOptional' is specified and the
    --     attribute isn\'t present then the pointer will be set to 'P.Nothing'
    | MarkupCollectTypeStrdup
    -- ^ as with 'GI.GLib.Flags.MarkupCollectTypeString', but
    --     expects a parameter of type (char __) and 'GI.GLib.Functions.strdup's the
    --     returned pointer. The pointer must be freed with 'GI.GLib.Functions.free'
    | MarkupCollectTypeBoolean
    -- ^ expects a parameter of type (@gboolean *@)
    --     and parses the attribute value as a boolean. Sets 'P.False' if the
    --     attribute isn\'t present. Valid boolean values consist of
    --     (case-insensitive) \"false\", \"f\", \"no\", \"n\", \"0\" and \"true\", \"t\",
    --     \"yes\", \"y\", \"1\"
    | MarkupCollectTypeTristate
    -- ^ as with 'GI.GLib.Flags.MarkupCollectTypeBoolean', but
    --     in the case of a missing attribute a value is set that compares
    --     equal to neither 'P.False' nor 'P.True' 'GI.GLib.Flags.MarkupCollectTypeOptional' is
    --     implied
    | MarkupCollectTypeOptional
    -- ^ can be bitwise ORed with the other fields.
    --     If present, allows the attribute not to appear. A default value
    --     is set depending on what value type is used
    | AnotherMarkupCollectType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MarkupCollectType where
    fromEnum MarkupCollectTypeInvalid = 0
    fromEnum MarkupCollectTypeString = 1
    fromEnum MarkupCollectTypeStrdup = 2
    fromEnum MarkupCollectTypeBoolean = 3
    fromEnum MarkupCollectTypeTristate = 4
    fromEnum MarkupCollectTypeOptional = 65536
    fromEnum (AnotherMarkupCollectType k) = k

    toEnum 0 = MarkupCollectTypeInvalid
    toEnum 1 = MarkupCollectTypeString
    toEnum 2 = MarkupCollectTypeStrdup
    toEnum 3 = MarkupCollectTypeBoolean
    toEnum 4 = MarkupCollectTypeTristate
    toEnum 65536 = MarkupCollectTypeOptional
    toEnum k = AnotherMarkupCollectType k

instance P.Ord MarkupCollectType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag MarkupCollectType

-- Flags MainContextFlags
-- | Flags to pass to 'GI.GLib.Structs.MainContext.mainContextNewWithFlags' which affect the
-- behaviour of a t'GI.GLib.Structs.MainContext.MainContext'.
-- 
-- /Since: 2.72/
data MainContextFlags = 
      MainContextFlagsNone
    -- ^ Default behaviour.
    | MainContextFlagsOwnerlessPolling
    -- ^ Assume that polling for events will
    -- free the thread to process other jobs. That\'s useful if you\'re using
    -- @g_main_context_{prepare,query,check,dispatch}@ to integrate GMainContext in
    -- other event loops.
    | AnotherMainContextFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MainContextFlags where
    fromEnum MainContextFlagsNone = 0
    fromEnum MainContextFlagsOwnerlessPolling = 1
    fromEnum (AnotherMainContextFlags k) = k

    toEnum 0 = MainContextFlagsNone
    toEnum 1 = MainContextFlagsOwnerlessPolling
    toEnum k = AnotherMainContextFlags k

instance P.Ord MainContextFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag MainContextFlags

-- Flags LogLevelFlags
-- | Flags specifying the level of log messages.
-- 
-- It is possible to change how GLib treats messages of the various
-- levels using 'GI.GLib.Functions.logSetHandler' and 'GI.GLib.Functions.logSetFatalMask'.
data LogLevelFlags = 
      LogLevelFlagsFlagRecursion
    -- ^ internal flag
    | LogLevelFlagsFlagFatal
    -- ^ internal flag
    | LogLevelFlagsLevelError
    -- ^ log level for errors, see @/GLib.error/@.
    --   This level is also used for messages produced by @/GLib.assert/@.
    | LogLevelFlagsLevelCritical
    -- ^ log level for critical warning messages, see
    --   @/GLib.critical/@. This level is also used for messages produced by
    --   @/GLib.return_if_fail/@ and @/GLib.return_val_if_fail/@.
    | LogLevelFlagsLevelWarning
    -- ^ log level for warnings, see @/GLib.warning/@
    | LogLevelFlagsLevelMessage
    -- ^ log level for messages, see @/GLib.message/@
    | LogLevelFlagsLevelInfo
    -- ^ log level for informational messages, see @/GLib.info/@
    | LogLevelFlagsLevelDebug
    -- ^ log level for debug messages, see @/GLib.debug/@
    | LogLevelFlagsLevelMask
    -- ^ a mask including all log levels
    | AnotherLogLevelFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum LogLevelFlags where
    fromEnum LogLevelFlagsFlagRecursion = 1
    fromEnum LogLevelFlagsFlagFatal = 2
    fromEnum LogLevelFlagsLevelError = 4
    fromEnum LogLevelFlagsLevelCritical = 8
    fromEnum LogLevelFlagsLevelWarning = 16
    fromEnum LogLevelFlagsLevelMessage = 32
    fromEnum LogLevelFlagsLevelInfo = 64
    fromEnum LogLevelFlagsLevelDebug = 128
    fromEnum LogLevelFlagsLevelMask = -4
    fromEnum (AnotherLogLevelFlags k) = k

    toEnum 1 = LogLevelFlagsFlagRecursion
    toEnum 2 = LogLevelFlagsFlagFatal
    toEnum 4 = LogLevelFlagsLevelError
    toEnum 8 = LogLevelFlagsLevelCritical
    toEnum 16 = LogLevelFlagsLevelWarning
    toEnum 32 = LogLevelFlagsLevelMessage
    toEnum 64 = LogLevelFlagsLevelInfo
    toEnum 128 = LogLevelFlagsLevelDebug
    toEnum -4 = LogLevelFlagsLevelMask
    toEnum k = AnotherLogLevelFlags k

instance P.Ord LogLevelFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag LogLevelFlags

-- Flags KeyFileFlags
-- | Flags which influence the parsing.
data KeyFileFlags = 
      KeyFileFlagsNone
    -- ^ No flags, default behaviour
    | KeyFileFlagsKeepComments
    -- ^ Use this flag if you plan to write the
    --   (possibly modified) contents of the key file back to a file;
    --   otherwise all comments will be lost when the key file is
    --   written back.
    | KeyFileFlagsKeepTranslations
    -- ^ Use this flag if you plan to write the
    --   (possibly modified) contents of the key file back to a file;
    --   otherwise only the translations for the current language will be
    --   written back.
    | AnotherKeyFileFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum KeyFileFlags where
    fromEnum KeyFileFlagsNone = 0
    fromEnum KeyFileFlagsKeepComments = 1
    fromEnum KeyFileFlagsKeepTranslations = 2
    fromEnum (AnotherKeyFileFlags k) = k

    toEnum 0 = KeyFileFlagsNone
    toEnum 1 = KeyFileFlagsKeepComments
    toEnum 2 = KeyFileFlagsKeepTranslations
    toEnum k = AnotherKeyFileFlags k

instance P.Ord KeyFileFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag KeyFileFlags

-- Flags IOFlags
-- | Specifies properties of a t'GI.GLib.Structs.IOChannel.IOChannel'. Some of the flags can only be
-- read with 'GI.GLib.Structs.IOChannel.iOChannelGetFlags', but not changed with
-- 'GI.GLib.Structs.IOChannel.iOChannelSetFlags'.
data IOFlags = 
      IOFlagsNone
    -- ^ no special flags set. Since: 2.74
    | IOFlagsAppend
    -- ^ turns on append mode, corresponds to @/O_APPEND/@
    --     (see the documentation of the UNIX @/open()/@ syscall)
    | IOFlagsNonblock
    -- ^ turns on nonblocking mode, corresponds to
    --     @/O_NONBLOCK/@\/@/O_NDELAY/@ (see the documentation of the UNIX @/open()/@
    --     syscall)
    | IOFlagsIsReadable
    -- ^ indicates that the io channel is readable.
    --     This flag cannot be changed.
    | IOFlagsIsWritable
    -- ^ indicates that the io channel is writable.
    --     This flag cannot be changed.
    | IOFlagsIsWriteable
    -- ^ a misspelled version of /@gIOFLAGISWRITABLE@/
    --     that existed before the spelling was fixed in GLib 2.30. It is kept
    --     here for compatibility reasons. Deprecated since 2.30
    | IOFlagsIsSeekable
    -- ^ indicates that the io channel is seekable,
    --     i.e. that 'GI.GLib.Structs.IOChannel.iOChannelSeekPosition' can be used on it.
    --     This flag cannot be changed.
    | IOFlagsMask
    -- ^ the mask that specifies all the valid flags.
    | IOFlagsGetMask
    -- ^ the mask of the flags that are returned from
    --     'GI.GLib.Structs.IOChannel.iOChannelGetFlags'
    | IOFlagsSetMask
    -- ^ the mask of the flags that the user can modify
    --     with 'GI.GLib.Structs.IOChannel.iOChannelSetFlags'
    | AnotherIOFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IOFlags where
    fromEnum IOFlagsNone = 0
    fromEnum IOFlagsAppend = 1
    fromEnum IOFlagsNonblock = 2
    fromEnum IOFlagsIsReadable = 4
    fromEnum IOFlagsIsWritable = 8
    fromEnum IOFlagsIsWriteable = 8
    fromEnum IOFlagsIsSeekable = 16
    fromEnum IOFlagsMask = 31
    fromEnum IOFlagsGetMask = 31
    fromEnum IOFlagsSetMask = 3
    fromEnum (AnotherIOFlags k) = k

    toEnum 0 = IOFlagsNone
    toEnum 1 = IOFlagsAppend
    toEnum 2 = IOFlagsNonblock
    toEnum 4 = IOFlagsIsReadable
    toEnum 8 = IOFlagsIsWritable
    toEnum 16 = IOFlagsIsSeekable
    toEnum 31 = IOFlagsMask
    toEnum 3 = IOFlagsSetMask
    toEnum k = AnotherIOFlags k

instance P.Ord IOFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag IOFlags

-- Flags IOCondition
-- | A bitwise combination representing a condition to watch for on an
-- event source.
data IOCondition = 
      IOConditionIn
    -- ^ There is data to read.
    | IOConditionOut
    -- ^ Data can be written (without blocking).
    | IOConditionPri
    -- ^ There is urgent data to read.
    | IOConditionErr
    -- ^ Error condition.
    | IOConditionHup
    -- ^ Hung up (the connection has been broken, usually for
    --            pipes and sockets).
    | IOConditionNval
    -- ^ Invalid request. The file descriptor is not open.
    | AnotherIOCondition Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IOCondition where
    fromEnum IOConditionIn = 1
    fromEnum IOConditionOut = 4
    fromEnum IOConditionPri = 2
    fromEnum IOConditionErr = 8
    fromEnum IOConditionHup = 16
    fromEnum IOConditionNval = 32
    fromEnum (AnotherIOCondition k) = k

    toEnum 1 = IOConditionIn
    toEnum 4 = IOConditionOut
    toEnum 2 = IOConditionPri
    toEnum 8 = IOConditionErr
    toEnum 16 = IOConditionHup
    toEnum 32 = IOConditionNval
    toEnum k = AnotherIOCondition k

instance P.Ord IOCondition where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes IOCondition = '[]
instance O.HasParentTypes IOCondition

foreign import ccall "g_io_condition_get_type" c_g_io_condition_get_type :: 
    IO GType

instance B.Types.TypedObject IOCondition where
    glibType = c_g_io_condition_get_type

instance B.Types.BoxedFlags IOCondition

instance IsGFlag IOCondition

-- Flags HookFlagMask
-- | Flags used internally in the t'GI.GLib.Structs.Hook.Hook' implementation.
data HookFlagMask = 
      HookFlagMaskActive
    -- ^ set if the hook has not been destroyed
    | HookFlagMaskInCall
    -- ^ set if the hook is currently being run
    | HookFlagMaskMask
    -- ^ A mask covering all bits reserved for
    --   hook flags; see 'GI.GLib.Constants.HOOK_FLAG_USER_SHIFT'
    | AnotherHookFlagMask Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum HookFlagMask where
    fromEnum HookFlagMaskActive = 1
    fromEnum HookFlagMaskInCall = 2
    fromEnum HookFlagMaskMask = 15
    fromEnum (AnotherHookFlagMask k) = k

    toEnum 1 = HookFlagMaskActive
    toEnum 2 = HookFlagMaskInCall
    toEnum 15 = HookFlagMaskMask
    toEnum k = AnotherHookFlagMask k

instance P.Ord HookFlagMask where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag HookFlagMask

-- Flags FormatSizeFlags
-- | Flags to modify the format of the string returned by 'GI.GLib.Functions.formatSizeFull'.
data FormatSizeFlags = 
      FormatSizeFlagsDefault
    -- ^ behave the same as 'GI.GLib.Functions.formatSize'
    | FormatSizeFlagsLongFormat
    -- ^ include the exact number of bytes as part
    --     of the returned string.  For example, \"45.6 kB (45,612 bytes)\".
    | FormatSizeFlagsIecUnits
    -- ^ use IEC (base 1024) units with \"KiB\"-style
    --     suffixes. IEC units should only be used for reporting things with
    --     a strong \"power of 2\" basis, like RAM sizes or RAID stripe sizes.
    --     Network and storage sizes should be reported in the normal SI units.
    | FormatSizeFlagsBits
    -- ^ set the size as a quantity in bits, rather than
    --     bytes, and return units in bits. For example, ‘Mbit’ rather than ‘MB’.
    | FormatSizeFlagsOnlyValue
    -- ^ return only value, without unit; this should
    --     not be used together with /@gFORMATSIZELONGFORMAT@/
    --     nor /@gFORMATSIZEONLYUNIT@/. Since: 2.74
    | FormatSizeFlagsOnlyUnit
    -- ^ return only unit, without value; this should
    --     not be used together with /@gFORMATSIZELONGFORMAT@/
    --     nor /@gFORMATSIZEONLYVALUE@/. Since: 2.74
    | AnotherFormatSizeFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FormatSizeFlags where
    fromEnum FormatSizeFlagsDefault = 0
    fromEnum FormatSizeFlagsLongFormat = 1
    fromEnum FormatSizeFlagsIecUnits = 2
    fromEnum FormatSizeFlagsBits = 4
    fromEnum FormatSizeFlagsOnlyValue = 8
    fromEnum FormatSizeFlagsOnlyUnit = 16
    fromEnum (AnotherFormatSizeFlags k) = k

    toEnum 0 = FormatSizeFlagsDefault
    toEnum 1 = FormatSizeFlagsLongFormat
    toEnum 2 = FormatSizeFlagsIecUnits
    toEnum 4 = FormatSizeFlagsBits
    toEnum 8 = FormatSizeFlagsOnlyValue
    toEnum 16 = FormatSizeFlagsOnlyUnit
    toEnum k = AnotherFormatSizeFlags k

instance P.Ord FormatSizeFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag FormatSizeFlags

-- Flags FileTest
-- | A test to perform on a file using 'GI.GLib.Functions.fileTest'.
data FileTest = 
      FileTestIsRegular
    -- ^ 'P.True' if the file is a regular file
    --     (not a directory). Note that this test will also return 'P.True'
    --     if the tested file is a symlink to a regular file.
    | FileTestIsSymlink
    -- ^ 'P.True' if the file is a symlink.
    | FileTestIsDir
    -- ^ 'P.True' if the file is a directory.
    | FileTestIsExecutable
    -- ^ 'P.True' if the file is executable.
    | FileTestExists
    -- ^ 'P.True' if the file exists. It may or may not
    --     be a regular file.
    | AnotherFileTest Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileTest where
    fromEnum FileTestIsRegular = 1
    fromEnum FileTestIsSymlink = 2
    fromEnum FileTestIsDir = 4
    fromEnum FileTestIsExecutable = 8
    fromEnum FileTestExists = 16
    fromEnum (AnotherFileTest k) = k

    toEnum 1 = FileTestIsRegular
    toEnum 2 = FileTestIsSymlink
    toEnum 4 = FileTestIsDir
    toEnum 8 = FileTestIsExecutable
    toEnum 16 = FileTestExists
    toEnum k = AnotherFileTest k

instance P.Ord FileTest where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag FileTest

-- Flags FileSetContentsFlags
-- | Flags to pass to 'GI.GLib.Functions.fileSetContentsFull' to affect its safety and
-- performance.
-- 
-- /Since: 2.66/
data FileSetContentsFlags = 
      FileSetContentsFlagsNone
    -- ^ No guarantees about file consistency or durability.
    --   The most dangerous setting, which is slightly faster than other settings.
    | FileSetContentsFlagsConsistent
    -- ^ Guarantee file consistency: after a crash,
    --   either the old version of the file or the new version of the file will be
    --   available, but not a mixture. On Unix systems this equates to an @fsync()@
    --   on the file and use of an atomic @rename()@ of the new version of the file
    --   over the old.
    | FileSetContentsFlagsDurable
    -- ^ Guarantee file durability: after a crash, the
    --   new version of the file will be available. On Unix systems this equates to
    --   an @fsync()@ on the file (if 'GI.GLib.Flags.FileSetContentsFlagsConsistent' is unset), or
    --   the effects of 'GI.GLib.Flags.FileSetContentsFlagsConsistent' plus an @fsync()@ on the
    --   directory containing the file after calling @rename()@.
    | FileSetContentsFlagsOnlyExisting
    -- ^ Only apply consistency and durability
    --   guarantees if the file already exists. This may speed up file operations
    --   if the file doesn’t currently exist, but may result in a corrupted version
    --   of the new file if the system crashes while writing it.
    | AnotherFileSetContentsFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileSetContentsFlags where
    fromEnum FileSetContentsFlagsNone = 0
    fromEnum FileSetContentsFlagsConsistent = 1
    fromEnum FileSetContentsFlagsDurable = 2
    fromEnum FileSetContentsFlagsOnlyExisting = 4
    fromEnum (AnotherFileSetContentsFlags k) = k

    toEnum 0 = FileSetContentsFlagsNone
    toEnum 1 = FileSetContentsFlagsConsistent
    toEnum 2 = FileSetContentsFlagsDurable
    toEnum 4 = FileSetContentsFlagsOnlyExisting
    toEnum k = AnotherFileSetContentsFlags k

instance P.Ord FileSetContentsFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag FileSetContentsFlags

-- Flags AsciiType
-- | /No description available in the introspection data./
data AsciiType = 
      AsciiTypeAlnum
    -- ^ /No description available in the introspection data./
    | AsciiTypeAlpha
    -- ^ /No description available in the introspection data./
    | AsciiTypeCntrl
    -- ^ /No description available in the introspection data./
    | AsciiTypeDigit
    -- ^ /No description available in the introspection data./
    | AsciiTypeGraph
    -- ^ /No description available in the introspection data./
    | AsciiTypeLower
    -- ^ /No description available in the introspection data./
    | AsciiTypePrint
    -- ^ /No description available in the introspection data./
    | AsciiTypePunct
    -- ^ /No description available in the introspection data./
    | AsciiTypeSpace
    -- ^ /No description available in the introspection data./
    | AsciiTypeUpper
    -- ^ /No description available in the introspection data./
    | AsciiTypeXdigit
    -- ^ /No description available in the introspection data./
    | AnotherAsciiType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AsciiType where
    fromEnum AsciiTypeAlnum = 1
    fromEnum AsciiTypeAlpha = 2
    fromEnum AsciiTypeCntrl = 4
    fromEnum AsciiTypeDigit = 8
    fromEnum AsciiTypeGraph = 16
    fromEnum AsciiTypeLower = 32
    fromEnum AsciiTypePrint = 64
    fromEnum AsciiTypePunct = 128
    fromEnum AsciiTypeSpace = 256
    fromEnum AsciiTypeUpper = 512
    fromEnum AsciiTypeXdigit = 1024
    fromEnum (AnotherAsciiType k) = k

    toEnum 1 = AsciiTypeAlnum
    toEnum 2 = AsciiTypeAlpha
    toEnum 4 = AsciiTypeCntrl
    toEnum 8 = AsciiTypeDigit
    toEnum 16 = AsciiTypeGraph
    toEnum 32 = AsciiTypeLower
    toEnum 64 = AsciiTypePrint
    toEnum 128 = AsciiTypePunct
    toEnum 256 = AsciiTypeSpace
    toEnum 512 = AsciiTypeUpper
    toEnum 1024 = AsciiTypeXdigit
    toEnum k = AnotherAsciiType k

instance P.Ord AsciiType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag AsciiType


