{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides language binding support to @GtkBuilder@.
-- 
-- The goal of @GtkBuilderScope@ is to look up programming-language-specific
-- values for strings that are given in a @GtkBuilder@ UI file.
-- 
-- The primary intended audience is bindings that want to provide deeper
-- integration of @GtkBuilder@ into the language.
-- 
-- A @GtkBuilderScope@ instance may be used with multiple @GtkBuilder@ objects,
-- even at once.
-- 
-- By default, GTK will use its own implementation of @GtkBuilderScope@
-- for the C language which can be created via 'GI.Gtk.Objects.BuilderCScope.builderCScopeNew'.
-- 
-- If you implement @GtkBuilderScope@ for a language binding, you
-- may want to (partially) derive from or fall back to a t'GI.Gtk.Objects.BuilderCScope.BuilderCScope',
-- as that class implements support for automatic lookups from C symbols.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.BuilderScope
    ( 

-- * Exported types
    BuilderScope(..)                        ,
    IsBuilderScope                          ,
    toBuilderScope                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveBuilderScopeMethod               ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface BuilderScope 
-- | Memory-managed wrapper type.
newtype BuilderScope = BuilderScope (SP.ManagedPtr BuilderScope)
    deriving (Eq)

instance SP.ManagedPtrNewtype BuilderScope where
    toManagedPtr (BuilderScope p) = p

foreign import ccall "gtk_builder_scope_get_type"
    c_gtk_builder_scope_get_type :: IO B.Types.GType

instance B.Types.TypedObject BuilderScope where
    glibType = c_gtk_builder_scope_get_type

instance B.Types.GObject BuilderScope

-- | Type class for types which can be safely cast to t'BuilderScope', for instance with `toBuilderScope`.
class (SP.GObject o, O.IsDescendantOf BuilderScope o) => IsBuilderScope o
instance (SP.GObject o, O.IsDescendantOf BuilderScope o) => IsBuilderScope o

instance O.HasParentTypes BuilderScope
type instance O.ParentTypes BuilderScope = '[GObject.Object.Object]

-- | Cast to t'BuilderScope', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toBuilderScope :: (MIO.MonadIO m, IsBuilderScope o) => o -> m BuilderScope
toBuilderScope = MIO.liftIO . B.ManagedPtr.unsafeCastTo BuilderScope

-- | Convert t'BuilderScope' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BuilderScope) where
    gvalueGType_ = c_gtk_builder_scope_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BuilderScope)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BuilderScope)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BuilderScope ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BuilderScope
type instance O.AttributeList BuilderScope = BuilderScopeAttributeList
type BuilderScopeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveBuilderScopeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBuilderScopeMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBuilderScopeMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBuilderScopeMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBuilderScopeMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBuilderScopeMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBuilderScopeMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBuilderScopeMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBuilderScopeMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBuilderScopeMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBuilderScopeMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBuilderScopeMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBuilderScopeMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBuilderScopeMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBuilderScopeMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBuilderScopeMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBuilderScopeMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBuilderScopeMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBuilderScopeMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBuilderScopeMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBuilderScopeMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBuilderScopeMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBuilderScopeMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBuilderScopeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBuilderScopeMethod t BuilderScope, O.OverloadedMethod info BuilderScope p) => OL.IsLabel t (BuilderScope -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBuilderScopeMethod t BuilderScope, O.OverloadedMethod info BuilderScope p, R.HasField t BuilderScope p) => R.HasField t BuilderScope p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBuilderScopeMethod t BuilderScope, O.OverloadedMethodInfo info BuilderScope) => OL.IsLabel t (O.MethodProxy info BuilderScope) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BuilderScope = BuilderScopeSignalList
type BuilderScopeSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


