{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Preserves the aspect ratio of its child.
-- 
-- The frame can respect the aspect ratio of the child widget,
-- or use its own aspect ratio.
-- 
-- = CSS nodes
-- 
-- @GtkAspectFrame@ uses a CSS node with name @aspectframe@.
-- 
-- = Accessibility
-- 
-- Until GTK 4.10, @GtkAspectFrame@ used the 'GI.Gtk.Enums.AccessibleRoleGroup' role.
-- 
-- Starting from GTK 4.12, @GtkAspectFrame@ uses the 'GI.Gtk.Enums.AccessibleRoleGeneric' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.AspectFrame
    ( 

-- * Exported types
    AspectFrame(..)                         ,
    IsAspectFrame                           ,
    toAspectFrame                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.AspectFrame#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getObeyChild]("GI.Gtk.Objects.AspectFrame#g:method:getObeyChild"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRatio]("GI.Gtk.Objects.AspectFrame#g:method:getRatio"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth"), [getXalign]("GI.Gtk.Objects.AspectFrame#g:method:getXalign"), [getYalign]("GI.Gtk.Objects.AspectFrame#g:method:getYalign").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.AspectFrame#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setObeyChild]("GI.Gtk.Objects.AspectFrame#g:method:setObeyChild"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRatio]("GI.Gtk.Objects.AspectFrame#g:method:setRatio"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setXalign]("GI.Gtk.Objects.AspectFrame#g:method:setXalign"), [setYalign]("GI.Gtk.Objects.AspectFrame#g:method:setYalign").

#if defined(ENABLE_OVERLOADING)
    ResolveAspectFrameMethod                ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    AspectFrameGetChildMethodInfo           ,
#endif
    aspectFrameGetChild                     ,


-- ** getObeyChild #method:getObeyChild#

#if defined(ENABLE_OVERLOADING)
    AspectFrameGetObeyChildMethodInfo       ,
#endif
    aspectFrameGetObeyChild                 ,


-- ** getRatio #method:getRatio#

#if defined(ENABLE_OVERLOADING)
    AspectFrameGetRatioMethodInfo           ,
#endif
    aspectFrameGetRatio                     ,


-- ** getXalign #method:getXalign#

#if defined(ENABLE_OVERLOADING)
    AspectFrameGetXalignMethodInfo          ,
#endif
    aspectFrameGetXalign                    ,


-- ** getYalign #method:getYalign#

#if defined(ENABLE_OVERLOADING)
    AspectFrameGetYalignMethodInfo          ,
#endif
    aspectFrameGetYalign                    ,


-- ** new #method:new#

    aspectFrameNew                          ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    AspectFrameSetChildMethodInfo           ,
#endif
    aspectFrameSetChild                     ,


-- ** setObeyChild #method:setObeyChild#

#if defined(ENABLE_OVERLOADING)
    AspectFrameSetObeyChildMethodInfo       ,
#endif
    aspectFrameSetObeyChild                 ,


-- ** setRatio #method:setRatio#

#if defined(ENABLE_OVERLOADING)
    AspectFrameSetRatioMethodInfo           ,
#endif
    aspectFrameSetRatio                     ,


-- ** setXalign #method:setXalign#

#if defined(ENABLE_OVERLOADING)
    AspectFrameSetXalignMethodInfo          ,
#endif
    aspectFrameSetXalign                    ,


-- ** setYalign #method:setYalign#

#if defined(ENABLE_OVERLOADING)
    AspectFrameSetYalignMethodInfo          ,
#endif
    aspectFrameSetYalign                    ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    AspectFrameChildPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    aspectFrameChild                        ,
#endif
    clearAspectFrameChild                   ,
    constructAspectFrameChild               ,
    getAspectFrameChild                     ,
    setAspectFrameChild                     ,


-- ** obeyChild #attr:obeyChild#
-- | Whether the @GtkAspectFrame@ should use the aspect ratio of its child.

#if defined(ENABLE_OVERLOADING)
    AspectFrameObeyChildPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    aspectFrameObeyChild                    ,
#endif
    constructAspectFrameObeyChild           ,
    getAspectFrameObeyChild                 ,
    setAspectFrameObeyChild                 ,


-- ** ratio #attr:ratio#
-- | The aspect ratio to be used by the @GtkAspectFrame@.
-- 
-- This property is only used if
-- [AspectFrame:obeyChild]("GI.Gtk.Objects.AspectFrame#g:attr:obeyChild") is set to 'P.False'.

#if defined(ENABLE_OVERLOADING)
    AspectFrameRatioPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    aspectFrameRatio                        ,
#endif
    constructAspectFrameRatio               ,
    getAspectFrameRatio                     ,
    setAspectFrameRatio                     ,


-- ** xalign #attr:xalign#
-- | The horizontal alignment of the child.

#if defined(ENABLE_OVERLOADING)
    AspectFrameXalignPropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    aspectFrameXalign                       ,
#endif
    constructAspectFrameXalign              ,
    getAspectFrameXalign                    ,
    setAspectFrameXalign                    ,


-- ** yalign #attr:yalign#
-- | The vertical alignment of the child.

#if defined(ENABLE_OVERLOADING)
    AspectFrameYalignPropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    aspectFrameYalign                       ,
#endif
    constructAspectFrameYalign              ,
    getAspectFrameYalign                    ,
    setAspectFrameYalign                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype AspectFrame = AspectFrame (SP.ManagedPtr AspectFrame)
    deriving (Eq)

instance SP.ManagedPtrNewtype AspectFrame where
    toManagedPtr (AspectFrame p) = p

foreign import ccall "gtk_aspect_frame_get_type"
    c_gtk_aspect_frame_get_type :: IO B.Types.GType

instance B.Types.TypedObject AspectFrame where
    glibType = c_gtk_aspect_frame_get_type

instance B.Types.GObject AspectFrame

-- | Type class for types which can be safely cast to t'AspectFrame', for instance with `toAspectFrame`.
class (SP.GObject o, O.IsDescendantOf AspectFrame o) => IsAspectFrame o
instance (SP.GObject o, O.IsDescendantOf AspectFrame o) => IsAspectFrame o

instance O.HasParentTypes AspectFrame
type instance O.ParentTypes AspectFrame = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'AspectFrame', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAspectFrame :: (MIO.MonadIO m, IsAspectFrame o) => o -> m AspectFrame
toAspectFrame = MIO.liftIO . B.ManagedPtr.unsafeCastTo AspectFrame

-- | Convert t'AspectFrame' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AspectFrame) where
    gvalueGType_ = c_gtk_aspect_frame_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AspectFrame)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AspectFrame)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AspectFrame ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAspectFrameMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAspectFrameMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveAspectFrameMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveAspectFrameMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveAspectFrameMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveAspectFrameMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveAspectFrameMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveAspectFrameMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveAspectFrameMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveAspectFrameMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveAspectFrameMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveAspectFrameMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAspectFrameMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAspectFrameMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveAspectFrameMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveAspectFrameMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveAspectFrameMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveAspectFrameMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveAspectFrameMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveAspectFrameMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveAspectFrameMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveAspectFrameMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveAspectFrameMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveAspectFrameMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveAspectFrameMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAspectFrameMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAspectFrameMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAspectFrameMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveAspectFrameMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveAspectFrameMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveAspectFrameMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveAspectFrameMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveAspectFrameMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveAspectFrameMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveAspectFrameMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveAspectFrameMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveAspectFrameMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveAspectFrameMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveAspectFrameMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveAspectFrameMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveAspectFrameMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAspectFrameMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveAspectFrameMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveAspectFrameMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveAspectFrameMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveAspectFrameMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveAspectFrameMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveAspectFrameMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveAspectFrameMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveAspectFrameMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAspectFrameMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAspectFrameMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveAspectFrameMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveAspectFrameMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveAspectFrameMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveAspectFrameMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveAspectFrameMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveAspectFrameMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveAspectFrameMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAspectFrameMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAspectFrameMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveAspectFrameMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveAspectFrameMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveAspectFrameMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveAspectFrameMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveAspectFrameMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveAspectFrameMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveAspectFrameMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAspectFrameMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveAspectFrameMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveAspectFrameMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveAspectFrameMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveAspectFrameMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAspectFrameMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAspectFrameMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAspectFrameMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveAspectFrameMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveAspectFrameMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveAspectFrameMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveAspectFrameMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveAspectFrameMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAspectFrameMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveAspectFrameMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveAspectFrameMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveAspectFrameMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveAspectFrameMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveAspectFrameMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveAspectFrameMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAspectFrameMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveAspectFrameMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveAspectFrameMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveAspectFrameMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveAspectFrameMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveAspectFrameMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveAspectFrameMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveAspectFrameMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveAspectFrameMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveAspectFrameMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveAspectFrameMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveAspectFrameMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveAspectFrameMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveAspectFrameMethod "getChild" o = AspectFrameGetChildMethodInfo
    ResolveAspectFrameMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveAspectFrameMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveAspectFrameMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveAspectFrameMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveAspectFrameMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveAspectFrameMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveAspectFrameMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAspectFrameMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveAspectFrameMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveAspectFrameMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveAspectFrameMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveAspectFrameMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveAspectFrameMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveAspectFrameMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveAspectFrameMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveAspectFrameMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveAspectFrameMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveAspectFrameMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveAspectFrameMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveAspectFrameMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveAspectFrameMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveAspectFrameMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveAspectFrameMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveAspectFrameMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveAspectFrameMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveAspectFrameMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveAspectFrameMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveAspectFrameMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveAspectFrameMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveAspectFrameMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveAspectFrameMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveAspectFrameMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveAspectFrameMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveAspectFrameMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveAspectFrameMethod "getObeyChild" o = AspectFrameGetObeyChildMethodInfo
    ResolveAspectFrameMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveAspectFrameMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveAspectFrameMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveAspectFrameMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveAspectFrameMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveAspectFrameMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveAspectFrameMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveAspectFrameMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveAspectFrameMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAspectFrameMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAspectFrameMethod "getRatio" o = AspectFrameGetRatioMethodInfo
    ResolveAspectFrameMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveAspectFrameMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveAspectFrameMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveAspectFrameMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveAspectFrameMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveAspectFrameMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveAspectFrameMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveAspectFrameMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveAspectFrameMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveAspectFrameMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveAspectFrameMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveAspectFrameMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveAspectFrameMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveAspectFrameMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveAspectFrameMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveAspectFrameMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveAspectFrameMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveAspectFrameMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveAspectFrameMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveAspectFrameMethod "getXalign" o = AspectFrameGetXalignMethodInfo
    ResolveAspectFrameMethod "getYalign" o = AspectFrameGetYalignMethodInfo
    ResolveAspectFrameMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveAspectFrameMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveAspectFrameMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveAspectFrameMethod "setChild" o = AspectFrameSetChildMethodInfo
    ResolveAspectFrameMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveAspectFrameMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveAspectFrameMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveAspectFrameMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveAspectFrameMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAspectFrameMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAspectFrameMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveAspectFrameMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveAspectFrameMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveAspectFrameMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveAspectFrameMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveAspectFrameMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveAspectFrameMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveAspectFrameMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveAspectFrameMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveAspectFrameMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveAspectFrameMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveAspectFrameMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveAspectFrameMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveAspectFrameMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveAspectFrameMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveAspectFrameMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveAspectFrameMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveAspectFrameMethod "setObeyChild" o = AspectFrameSetObeyChildMethodInfo
    ResolveAspectFrameMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveAspectFrameMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveAspectFrameMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveAspectFrameMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAspectFrameMethod "setRatio" o = AspectFrameSetRatioMethodInfo
    ResolveAspectFrameMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveAspectFrameMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveAspectFrameMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveAspectFrameMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveAspectFrameMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveAspectFrameMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveAspectFrameMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveAspectFrameMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveAspectFrameMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveAspectFrameMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveAspectFrameMethod "setXalign" o = AspectFrameSetXalignMethodInfo
    ResolveAspectFrameMethod "setYalign" o = AspectFrameSetYalignMethodInfo
    ResolveAspectFrameMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAspectFrameMethod t AspectFrame, O.OverloadedMethod info AspectFrame p) => OL.IsLabel t (AspectFrame -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAspectFrameMethod t AspectFrame, O.OverloadedMethod info AspectFrame p, R.HasField t AspectFrame p) => R.HasField t AspectFrame p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAspectFrameMethod t AspectFrame, O.OverloadedMethodInfo info AspectFrame) => OL.IsLabel t (O.MethodProxy info AspectFrame) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aspectFrame #child
-- @
getAspectFrameChild :: (MonadIO m, IsAspectFrame o) => o -> m (Maybe Gtk.Widget.Widget)
getAspectFrameChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aspectFrame [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setAspectFrameChild :: (MonadIO m, IsAspectFrame o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setAspectFrameChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAspectFrameChild :: (IsAspectFrame o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructAspectFrameChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearAspectFrameChild :: (MonadIO m, IsAspectFrame o) => o -> m ()
clearAspectFrameChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data AspectFrameChildPropertyInfo
instance AttrInfo AspectFrameChildPropertyInfo where
    type AttrAllowedOps AspectFrameChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AspectFrameChildPropertyInfo = IsAspectFrame
    type AttrSetTypeConstraint AspectFrameChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint AspectFrameChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType AspectFrameChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType AspectFrameChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel AspectFrameChildPropertyInfo = "child"
    type AttrOrigin AspectFrameChildPropertyInfo = AspectFrame
    attrGet = getAspectFrameChild
    attrSet = setAspectFrameChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructAspectFrameChild
    attrClear = clearAspectFrameChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#g:attr:child"
        })
#endif

-- VVV Prop "obey-child"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@obey-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aspectFrame #obeyChild
-- @
getAspectFrameObeyChild :: (MonadIO m, IsAspectFrame o) => o -> m Bool
getAspectFrameObeyChild obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "obey-child"

-- | Set the value of the “@obey-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aspectFrame [ #obeyChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setAspectFrameObeyChild :: (MonadIO m, IsAspectFrame o) => o -> Bool -> m ()
setAspectFrameObeyChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "obey-child" val

-- | Construct a t'GValueConstruct' with valid value for the “@obey-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAspectFrameObeyChild :: (IsAspectFrame o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAspectFrameObeyChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "obey-child" val

#if defined(ENABLE_OVERLOADING)
data AspectFrameObeyChildPropertyInfo
instance AttrInfo AspectFrameObeyChildPropertyInfo where
    type AttrAllowedOps AspectFrameObeyChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AspectFrameObeyChildPropertyInfo = IsAspectFrame
    type AttrSetTypeConstraint AspectFrameObeyChildPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AspectFrameObeyChildPropertyInfo = (~) Bool
    type AttrTransferType AspectFrameObeyChildPropertyInfo = Bool
    type AttrGetType AspectFrameObeyChildPropertyInfo = Bool
    type AttrLabel AspectFrameObeyChildPropertyInfo = "obey-child"
    type AttrOrigin AspectFrameObeyChildPropertyInfo = AspectFrame
    attrGet = getAspectFrameObeyChild
    attrSet = setAspectFrameObeyChild
    attrTransfer _ v = do
        return v
    attrConstruct = constructAspectFrameObeyChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.obeyChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#g:attr:obeyChild"
        })
#endif

-- VVV Prop "ratio"
   -- Type: TBasicType TFloat
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@ratio@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aspectFrame #ratio
-- @
getAspectFrameRatio :: (MonadIO m, IsAspectFrame o) => o -> m Float
getAspectFrameRatio obj = MIO.liftIO $ B.Properties.getObjectPropertyFloat obj "ratio"

-- | Set the value of the “@ratio@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aspectFrame [ #ratio 'Data.GI.Base.Attributes.:=' value ]
-- @
setAspectFrameRatio :: (MonadIO m, IsAspectFrame o) => o -> Float -> m ()
setAspectFrameRatio obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFloat obj "ratio" val

-- | Construct a t'GValueConstruct' with valid value for the “@ratio@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAspectFrameRatio :: (IsAspectFrame o, MIO.MonadIO m) => Float -> m (GValueConstruct o)
constructAspectFrameRatio val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFloat "ratio" val

#if defined(ENABLE_OVERLOADING)
data AspectFrameRatioPropertyInfo
instance AttrInfo AspectFrameRatioPropertyInfo where
    type AttrAllowedOps AspectFrameRatioPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AspectFrameRatioPropertyInfo = IsAspectFrame
    type AttrSetTypeConstraint AspectFrameRatioPropertyInfo = (~) Float
    type AttrTransferTypeConstraint AspectFrameRatioPropertyInfo = (~) Float
    type AttrTransferType AspectFrameRatioPropertyInfo = Float
    type AttrGetType AspectFrameRatioPropertyInfo = Float
    type AttrLabel AspectFrameRatioPropertyInfo = "ratio"
    type AttrOrigin AspectFrameRatioPropertyInfo = AspectFrame
    attrGet = getAspectFrameRatio
    attrSet = setAspectFrameRatio
    attrTransfer _ v = do
        return v
    attrConstruct = constructAspectFrameRatio
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.ratio"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#g:attr:ratio"
        })
#endif

-- VVV Prop "xalign"
   -- Type: TBasicType TFloat
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@xalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aspectFrame #xalign
-- @
getAspectFrameXalign :: (MonadIO m, IsAspectFrame o) => o -> m Float
getAspectFrameXalign obj = MIO.liftIO $ B.Properties.getObjectPropertyFloat obj "xalign"

-- | Set the value of the “@xalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aspectFrame [ #xalign 'Data.GI.Base.Attributes.:=' value ]
-- @
setAspectFrameXalign :: (MonadIO m, IsAspectFrame o) => o -> Float -> m ()
setAspectFrameXalign obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFloat obj "xalign" val

-- | Construct a t'GValueConstruct' with valid value for the “@xalign@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAspectFrameXalign :: (IsAspectFrame o, MIO.MonadIO m) => Float -> m (GValueConstruct o)
constructAspectFrameXalign val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFloat "xalign" val

#if defined(ENABLE_OVERLOADING)
data AspectFrameXalignPropertyInfo
instance AttrInfo AspectFrameXalignPropertyInfo where
    type AttrAllowedOps AspectFrameXalignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AspectFrameXalignPropertyInfo = IsAspectFrame
    type AttrSetTypeConstraint AspectFrameXalignPropertyInfo = (~) Float
    type AttrTransferTypeConstraint AspectFrameXalignPropertyInfo = (~) Float
    type AttrTransferType AspectFrameXalignPropertyInfo = Float
    type AttrGetType AspectFrameXalignPropertyInfo = Float
    type AttrLabel AspectFrameXalignPropertyInfo = "xalign"
    type AttrOrigin AspectFrameXalignPropertyInfo = AspectFrame
    attrGet = getAspectFrameXalign
    attrSet = setAspectFrameXalign
    attrTransfer _ v = do
        return v
    attrConstruct = constructAspectFrameXalign
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.xalign"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#g:attr:xalign"
        })
#endif

-- VVV Prop "yalign"
   -- Type: TBasicType TFloat
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@yalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aspectFrame #yalign
-- @
getAspectFrameYalign :: (MonadIO m, IsAspectFrame o) => o -> m Float
getAspectFrameYalign obj = MIO.liftIO $ B.Properties.getObjectPropertyFloat obj "yalign"

-- | Set the value of the “@yalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aspectFrame [ #yalign 'Data.GI.Base.Attributes.:=' value ]
-- @
setAspectFrameYalign :: (MonadIO m, IsAspectFrame o) => o -> Float -> m ()
setAspectFrameYalign obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFloat obj "yalign" val

-- | Construct a t'GValueConstruct' with valid value for the “@yalign@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAspectFrameYalign :: (IsAspectFrame o, MIO.MonadIO m) => Float -> m (GValueConstruct o)
constructAspectFrameYalign val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFloat "yalign" val

#if defined(ENABLE_OVERLOADING)
data AspectFrameYalignPropertyInfo
instance AttrInfo AspectFrameYalignPropertyInfo where
    type AttrAllowedOps AspectFrameYalignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AspectFrameYalignPropertyInfo = IsAspectFrame
    type AttrSetTypeConstraint AspectFrameYalignPropertyInfo = (~) Float
    type AttrTransferTypeConstraint AspectFrameYalignPropertyInfo = (~) Float
    type AttrTransferType AspectFrameYalignPropertyInfo = Float
    type AttrGetType AspectFrameYalignPropertyInfo = Float
    type AttrLabel AspectFrameYalignPropertyInfo = "yalign"
    type AttrOrigin AspectFrameYalignPropertyInfo = AspectFrame
    attrGet = getAspectFrameYalign
    attrSet = setAspectFrameYalign
    attrTransfer _ v = do
        return v
    attrConstruct = constructAspectFrameYalign
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.yalign"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#g:attr:yalign"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AspectFrame
type instance O.AttributeList AspectFrame = AspectFrameAttributeList
type AspectFrameAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", AspectFrameChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("obeyChild", AspectFrameObeyChildPropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("ratio", AspectFrameRatioPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("xalign", AspectFrameXalignPropertyInfo), '("yalign", AspectFrameYalignPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
aspectFrameChild :: AttrLabelProxy "child"
aspectFrameChild = AttrLabelProxy

aspectFrameObeyChild :: AttrLabelProxy "obeyChild"
aspectFrameObeyChild = AttrLabelProxy

aspectFrameRatio :: AttrLabelProxy "ratio"
aspectFrameRatio = AttrLabelProxy

aspectFrameXalign :: AttrLabelProxy "xalign"
aspectFrameXalign = AttrLabelProxy

aspectFrameYalign :: AttrLabelProxy "yalign"
aspectFrameYalign = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AspectFrame = AspectFrameSignalList
type AspectFrameSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AspectFrame::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "xalign"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Horizontal alignment of the child within the parent.\n  Ranges from 0.0 (left aligned) to 1.0 (right aligned)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "yalign"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Vertical alignment of the child within the parent.\n  Ranges from 0.0 (top aligned) to 1.0 (bottom aligned)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ratio"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The desired aspect ratio."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "obey_child"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "If %TRUE, @ratio is ignored, and the aspect\n  ratio is taken from the requistion of the child."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "AspectFrame" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_new" gtk_aspect_frame_new :: 
    CFloat ->                               -- xalign : TBasicType TFloat
    CFloat ->                               -- yalign : TBasicType TFloat
    CFloat ->                               -- ratio : TBasicType TFloat
    CInt ->                                 -- obey_child : TBasicType TBoolean
    IO (Ptr AspectFrame)

-- | Create a new @GtkAspectFrame@.
aspectFrameNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Float
    -- ^ /@xalign@/: Horizontal alignment of the child within the parent.
    --   Ranges from 0.0 (left aligned) to 1.0 (right aligned)
    -> Float
    -- ^ /@yalign@/: Vertical alignment of the child within the parent.
    --   Ranges from 0.0 (top aligned) to 1.0 (bottom aligned)
    -> Float
    -- ^ /@ratio@/: The desired aspect ratio.
    -> Bool
    -- ^ /@obeyChild@/: If 'P.True', /@ratio@/ is ignored, and the aspect
    --   ratio is taken from the requistion of the child.
    -> m AspectFrame
    -- ^ __Returns:__ the new @GtkAspectFrame@.
aspectFrameNew xalign yalign ratio obeyChild = liftIO $ do
    let xalign' = realToFrac xalign
    let yalign' = realToFrac yalign
    let ratio' = realToFrac ratio
    let obeyChild' = (P.fromIntegral . P.fromEnum) obeyChild
    result <- gtk_aspect_frame_new xalign' yalign' ratio' obeyChild'
    checkUnexpectedReturnNULL "aspectFrameNew" result
    result' <- (newObject AspectFrame) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AspectFrame::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_get_child" gtk_aspect_frame_get_child :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@self@/.
aspectFrameGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@self@/
aspectFrameGetChild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_aspect_frame_get_child self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AspectFrameGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameGetChildMethodInfo a signature where
    overloadedMethod = aspectFrameGetChild

instance O.OverloadedMethodInfo AspectFrameGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameGetChild"
        })


#endif

-- method AspectFrame::get_obey_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_get_obey_child" gtk_aspect_frame_get_obey_child :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    IO CInt

-- | Returns whether the child\'s size request should override
-- the set aspect ratio of the @GtkAspectFrame@.
aspectFrameGetObeyChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> m Bool
    -- ^ __Returns:__ whether to obey the child\'s size request
aspectFrameGetObeyChild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_aspect_frame_get_obey_child self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AspectFrameGetObeyChildMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameGetObeyChildMethodInfo a signature where
    overloadedMethod = aspectFrameGetObeyChild

instance O.OverloadedMethodInfo AspectFrameGetObeyChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameGetObeyChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameGetObeyChild"
        })


#endif

-- method AspectFrame::get_ratio
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_get_ratio" gtk_aspect_frame_get_ratio :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    IO CFloat

-- | Returns the desired aspect ratio of the child.
aspectFrameGetRatio ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> m Float
    -- ^ __Returns:__ the desired aspect ratio
aspectFrameGetRatio self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_aspect_frame_get_ratio self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AspectFrameGetRatioMethodInfo
instance (signature ~ (m Float), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameGetRatioMethodInfo a signature where
    overloadedMethod = aspectFrameGetRatio

instance O.OverloadedMethodInfo AspectFrameGetRatioMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameGetRatio",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameGetRatio"
        })


#endif

-- method AspectFrame::get_xalign
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_get_xalign" gtk_aspect_frame_get_xalign :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    IO CFloat

-- | Returns the horizontal alignment of the child within the
-- allocation of the @GtkAspectFrame@.
aspectFrameGetXalign ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> m Float
    -- ^ __Returns:__ the horizontal alignment
aspectFrameGetXalign self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_aspect_frame_get_xalign self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AspectFrameGetXalignMethodInfo
instance (signature ~ (m Float), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameGetXalignMethodInfo a signature where
    overloadedMethod = aspectFrameGetXalign

instance O.OverloadedMethodInfo AspectFrameGetXalignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameGetXalign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameGetXalign"
        })


#endif

-- method AspectFrame::get_yalign
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_get_yalign" gtk_aspect_frame_get_yalign :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    IO CFloat

-- | Returns the vertical alignment of the child within the
-- allocation of the @GtkAspectFrame@.
aspectFrameGetYalign ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> m Float
    -- ^ __Returns:__ the vertical alignment
aspectFrameGetYalign self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_aspect_frame_get_yalign self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AspectFrameGetYalignMethodInfo
instance (signature ~ (m Float), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameGetYalignMethodInfo a signature where
    overloadedMethod = aspectFrameGetYalign

instance O.OverloadedMethodInfo AspectFrameGetYalignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameGetYalign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameGetYalign"
        })


#endif

-- method AspectFrame::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_set_child" gtk_aspect_frame_set_child :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@self@/.
aspectFrameSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
aspectFrameSetChild self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_aspect_frame_set_child self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data AspectFrameSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsAspectFrame a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AspectFrameSetChildMethodInfo a signature where
    overloadedMethod = aspectFrameSetChild

instance O.OverloadedMethodInfo AspectFrameSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameSetChild"
        })


#endif

-- method AspectFrame::set_obey_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "obey_child"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "If %TRUE, @ratio is ignored, and the aspect\n   ratio is taken from the requisition of the child."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_set_obey_child" gtk_aspect_frame_set_obey_child :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    CInt ->                                 -- obey_child : TBasicType TBoolean
    IO ()

-- | Sets whether the aspect ratio of the child\'s size
-- request should override the set aspect ratio of
-- the @GtkAspectFrame@.
aspectFrameSetObeyChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> Bool
    -- ^ /@obeyChild@/: If 'P.True', /@ratio@/ is ignored, and the aspect
    --    ratio is taken from the requisition of the child.
    -> m ()
aspectFrameSetObeyChild self obeyChild = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let obeyChild' = (P.fromIntegral . P.fromEnum) obeyChild
    gtk_aspect_frame_set_obey_child self' obeyChild'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AspectFrameSetObeyChildMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameSetObeyChildMethodInfo a signature where
    overloadedMethod = aspectFrameSetObeyChild

instance O.OverloadedMethodInfo AspectFrameSetObeyChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameSetObeyChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameSetObeyChild"
        })


#endif

-- method AspectFrame::set_ratio
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ratio"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "aspect ratio of the child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_set_ratio" gtk_aspect_frame_set_ratio :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    CFloat ->                               -- ratio : TBasicType TFloat
    IO ()

-- | Sets the desired aspect ratio of the child.
aspectFrameSetRatio ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> Float
    -- ^ /@ratio@/: aspect ratio of the child
    -> m ()
aspectFrameSetRatio self ratio = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let ratio' = realToFrac ratio
    gtk_aspect_frame_set_ratio self' ratio'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AspectFrameSetRatioMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameSetRatioMethodInfo a signature where
    overloadedMethod = aspectFrameSetRatio

instance O.OverloadedMethodInfo AspectFrameSetRatioMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameSetRatio",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameSetRatio"
        })


#endif

-- method AspectFrame::set_xalign
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xalign"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "horizontal alignment, from 0.0 (left aligned) to 1.0 (right aligned)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_set_xalign" gtk_aspect_frame_set_xalign :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    CFloat ->                               -- xalign : TBasicType TFloat
    IO ()

-- | Sets the horizontal alignment of the child within the allocation
-- of the @GtkAspectFrame@.
aspectFrameSetXalign ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> Float
    -- ^ /@xalign@/: horizontal alignment, from 0.0 (left aligned) to 1.0 (right aligned)
    -> m ()
aspectFrameSetXalign self xalign = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let xalign' = realToFrac xalign
    gtk_aspect_frame_set_xalign self' xalign'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AspectFrameSetXalignMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameSetXalignMethodInfo a signature where
    overloadedMethod = aspectFrameSetXalign

instance O.OverloadedMethodInfo AspectFrameSetXalignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameSetXalign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameSetXalign"
        })


#endif

-- method AspectFrame::set_yalign
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AspectFrame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAspectFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "yalign"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "horizontal alignment, from 0.0 (top aligned) to 1.0 (bottom aligned)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_aspect_frame_set_yalign" gtk_aspect_frame_set_yalign :: 
    Ptr AspectFrame ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AspectFrame"})
    CFloat ->                               -- yalign : TBasicType TFloat
    IO ()

-- | Sets the vertical alignment of the child within the allocation
-- of the @GtkAspectFrame@.
aspectFrameSetYalign ::
    (B.CallStack.HasCallStack, MonadIO m, IsAspectFrame a) =>
    a
    -- ^ /@self@/: a @GtkAspectFrame@
    -> Float
    -- ^ /@yalign@/: horizontal alignment, from 0.0 (top aligned) to 1.0 (bottom aligned)
    -> m ()
aspectFrameSetYalign self yalign = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let yalign' = realToFrac yalign
    gtk_aspect_frame_set_yalign self' yalign'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AspectFrameSetYalignMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m, IsAspectFrame a) => O.OverloadedMethod AspectFrameSetYalignMethodInfo a signature where
    overloadedMethod = aspectFrameSetYalign

instance O.OverloadedMethodInfo AspectFrameSetYalignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AspectFrame.aspectFrameSetYalign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AspectFrame.html#v:aspectFrameSetYalign"
        })


#endif


