{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents a printer.
-- 
-- You only need to deal directly with printers if you use the
-- non-portable t'GI.Gtk.Objects.PrintUnixDialog.PrintUnixDialog' API.
-- 
-- A @GtkPrinter@ allows to get status information about the printer,
-- such as its description, its location, the number of queued jobs,
-- etc. Most importantly, a @GtkPrinter@ object can be used to create
-- a t'GI.Gtk.Objects.PrintJob.PrintJob' object, which lets you print to the printer.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Printer
    ( 

-- * Exported types
    Printer(..)                             ,
    IsPrinter                               ,
    toPrinter                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [acceptsPdf]("GI.Gtk.Objects.Printer#g:method:acceptsPdf"), [acceptsPs]("GI.Gtk.Objects.Printer#g:method:acceptsPs"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [compare]("GI.Gtk.Objects.Printer#g:method:compare"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasDetails]("GI.Gtk.Objects.Printer#g:method:hasDetails"), [isAcceptingJobs]("GI.Gtk.Objects.Printer#g:method:isAcceptingJobs"), [isActive]("GI.Gtk.Objects.Printer#g:method:isActive"), [isDefault]("GI.Gtk.Objects.Printer#g:method:isDefault"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isPaused]("GI.Gtk.Objects.Printer#g:method:isPaused"), [isVirtual]("GI.Gtk.Objects.Printer#g:method:isVirtual"), [listPapers]("GI.Gtk.Objects.Printer#g:method:listPapers"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [requestDetails]("GI.Gtk.Objects.Printer#g:method:requestDetails"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBackend]("GI.Gtk.Objects.Printer#g:method:getBackend"), [getCapabilities]("GI.Gtk.Objects.Printer#g:method:getCapabilities"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultPageSize]("GI.Gtk.Objects.Printer#g:method:getDefaultPageSize"), [getDescription]("GI.Gtk.Objects.Printer#g:method:getDescription"), [getHardMargins]("GI.Gtk.Objects.Printer#g:method:getHardMargins"), [getHardMarginsForPaperSize]("GI.Gtk.Objects.Printer#g:method:getHardMarginsForPaperSize"), [getIconName]("GI.Gtk.Objects.Printer#g:method:getIconName"), [getJobCount]("GI.Gtk.Objects.Printer#g:method:getJobCount"), [getLocation]("GI.Gtk.Objects.Printer#g:method:getLocation"), [getName]("GI.Gtk.Objects.Printer#g:method:getName"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStateMessage]("GI.Gtk.Objects.Printer#g:method:getStateMessage").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolvePrinterMethod                    ,
#endif

-- ** acceptsPdf #method:acceptsPdf#

#if defined(ENABLE_OVERLOADING)
    PrinterAcceptsPdfMethodInfo             ,
#endif
    printerAcceptsPdf                       ,


-- ** acceptsPs #method:acceptsPs#

#if defined(ENABLE_OVERLOADING)
    PrinterAcceptsPsMethodInfo              ,
#endif
    printerAcceptsPs                        ,


-- ** compare #method:compare#

#if defined(ENABLE_OVERLOADING)
    PrinterCompareMethodInfo                ,
#endif
    printerCompare                          ,


-- ** getBackend #method:getBackend#

#if defined(ENABLE_OVERLOADING)
    PrinterGetBackendMethodInfo             ,
#endif
    printerGetBackend                       ,


-- ** getCapabilities #method:getCapabilities#

#if defined(ENABLE_OVERLOADING)
    PrinterGetCapabilitiesMethodInfo        ,
#endif
    printerGetCapabilities                  ,


-- ** getDefaultPageSize #method:getDefaultPageSize#

#if defined(ENABLE_OVERLOADING)
    PrinterGetDefaultPageSizeMethodInfo     ,
#endif
    printerGetDefaultPageSize               ,


-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    PrinterGetDescriptionMethodInfo         ,
#endif
    printerGetDescription                   ,


-- ** getHardMargins #method:getHardMargins#

#if defined(ENABLE_OVERLOADING)
    PrinterGetHardMarginsMethodInfo         ,
#endif
    printerGetHardMargins                   ,


-- ** getHardMarginsForPaperSize #method:getHardMarginsForPaperSize#

#if defined(ENABLE_OVERLOADING)
    PrinterGetHardMarginsForPaperSizeMethodInfo,
#endif
    printerGetHardMarginsForPaperSize       ,


-- ** getIconName #method:getIconName#

#if defined(ENABLE_OVERLOADING)
    PrinterGetIconNameMethodInfo            ,
#endif
    printerGetIconName                      ,


-- ** getJobCount #method:getJobCount#

#if defined(ENABLE_OVERLOADING)
    PrinterGetJobCountMethodInfo            ,
#endif
    printerGetJobCount                      ,


-- ** getLocation #method:getLocation#

#if defined(ENABLE_OVERLOADING)
    PrinterGetLocationMethodInfo            ,
#endif
    printerGetLocation                      ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    PrinterGetNameMethodInfo                ,
#endif
    printerGetName                          ,


-- ** getStateMessage #method:getStateMessage#

#if defined(ENABLE_OVERLOADING)
    PrinterGetStateMessageMethodInfo        ,
#endif
    printerGetStateMessage                  ,


-- ** hasDetails #method:hasDetails#

#if defined(ENABLE_OVERLOADING)
    PrinterHasDetailsMethodInfo             ,
#endif
    printerHasDetails                       ,


-- ** isAcceptingJobs #method:isAcceptingJobs#

#if defined(ENABLE_OVERLOADING)
    PrinterIsAcceptingJobsMethodInfo        ,
#endif
    printerIsAcceptingJobs                  ,


-- ** isActive #method:isActive#

#if defined(ENABLE_OVERLOADING)
    PrinterIsActiveMethodInfo               ,
#endif
    printerIsActive                         ,


-- ** isDefault #method:isDefault#

#if defined(ENABLE_OVERLOADING)
    PrinterIsDefaultMethodInfo              ,
#endif
    printerIsDefault                        ,


-- ** isPaused #method:isPaused#

#if defined(ENABLE_OVERLOADING)
    PrinterIsPausedMethodInfo               ,
#endif
    printerIsPaused                         ,


-- ** isVirtual #method:isVirtual#

#if defined(ENABLE_OVERLOADING)
    PrinterIsVirtualMethodInfo              ,
#endif
    printerIsVirtual                        ,


-- ** listPapers #method:listPapers#

#if defined(ENABLE_OVERLOADING)
    PrinterListPapersMethodInfo             ,
#endif
    printerListPapers                       ,


-- ** new #method:new#

    printerNew                              ,


-- ** requestDetails #method:requestDetails#

#if defined(ENABLE_OVERLOADING)
    PrinterRequestDetailsMethodInfo         ,
#endif
    printerRequestDetails                   ,




 -- * Properties


-- ** acceptingJobs #attr:acceptingJobs#
-- | 'P.True' if the printer is accepting jobs.

#if defined(ENABLE_OVERLOADING)
    PrinterAcceptingJobsPropertyInfo        ,
#endif
    getPrinterAcceptingJobs                 ,
#if defined(ENABLE_OVERLOADING)
    printerAcceptingJobs                    ,
#endif


-- ** acceptsPdf #attr:acceptsPdf#
-- | 'P.True' if this printer can accept PDF.

#if defined(ENABLE_OVERLOADING)
    PrinterAcceptsPdfPropertyInfo           ,
#endif
    constructPrinterAcceptsPdf              ,
    getPrinterAcceptsPdf                    ,


-- ** acceptsPs #attr:acceptsPs#
-- | 'P.True' if this printer can accept PostScript.

#if defined(ENABLE_OVERLOADING)
    PrinterAcceptsPsPropertyInfo            ,
#endif
    constructPrinterAcceptsPs               ,
    getPrinterAcceptsPs                     ,


-- ** iconName #attr:iconName#
-- | Icon name to use for the printer.

#if defined(ENABLE_OVERLOADING)
    PrinterIconNamePropertyInfo             ,
#endif
    getPrinterIconName                      ,
#if defined(ENABLE_OVERLOADING)
    printerIconName                         ,
#endif


-- ** isVirtual #attr:isVirtual#
-- | 'P.False' if this represents a real hardware device.

#if defined(ENABLE_OVERLOADING)
    PrinterIsVirtualPropertyInfo            ,
#endif
    constructPrinterIsVirtual               ,
    getPrinterIsVirtual                     ,


-- ** jobCount #attr:jobCount#
-- | Number of jobs queued in the printer.

#if defined(ENABLE_OVERLOADING)
    PrinterJobCountPropertyInfo             ,
#endif
    getPrinterJobCount                      ,
#if defined(ENABLE_OVERLOADING)
    printerJobCount                         ,
#endif


-- ** location #attr:location#
-- | Information about the location of the printer.

#if defined(ENABLE_OVERLOADING)
    PrinterLocationPropertyInfo             ,
#endif
    getPrinterLocation                      ,
#if defined(ENABLE_OVERLOADING)
    printerLocation                         ,
#endif


-- ** name #attr:name#
-- | The name of the printer.

#if defined(ENABLE_OVERLOADING)
    PrinterNamePropertyInfo                 ,
#endif
    constructPrinterName                    ,
    getPrinterName                          ,
#if defined(ENABLE_OVERLOADING)
    printerName                             ,
#endif


-- ** paused #attr:paused#
-- | 'P.True' if this printer is paused.
-- 
-- A paused printer still accepts jobs, but it does
-- not print them.

#if defined(ENABLE_OVERLOADING)
    PrinterPausedPropertyInfo               ,
#endif
    getPrinterPaused                        ,
#if defined(ENABLE_OVERLOADING)
    printerPaused                           ,
#endif


-- ** stateMessage #attr:stateMessage#
-- | String giving the current status of the printer.

#if defined(ENABLE_OVERLOADING)
    PrinterStateMessagePropertyInfo         ,
#endif
    getPrinterStateMessage                  ,
#if defined(ENABLE_OVERLOADING)
    printerStateMessage                     ,
#endif




 -- * Signals


-- ** detailsAcquired #signal:detailsAcquired#

    PrinterDetailsAcquiredCallback          ,
#if defined(ENABLE_OVERLOADING)
    PrinterDetailsAcquiredSignalInfo        ,
#endif
    afterPrinterDetailsAcquired             ,
    onPrinterDetailsAcquired                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.KeyFile as GLib.KeyFile
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Structs.PaperSize as Gtk.PaperSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.PrintBackend as Gtk.PrintBackend

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Structs.PaperSize as Gtk.PaperSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.PrintBackend as Gtk.PrintBackend

#endif

-- | Memory-managed wrapper type.
newtype Printer = Printer (SP.ManagedPtr Printer)
    deriving (Eq)

instance SP.ManagedPtrNewtype Printer where
    toManagedPtr (Printer p) = p

foreign import ccall "gtk_printer_get_type"
    c_gtk_printer_get_type :: IO B.Types.GType

instance B.Types.TypedObject Printer where
    glibType = c_gtk_printer_get_type

instance B.Types.GObject Printer

-- | Type class for types which can be safely cast to t'Printer', for instance with `toPrinter`.
class (SP.GObject o, O.IsDescendantOf Printer o) => IsPrinter o
instance (SP.GObject o, O.IsDescendantOf Printer o) => IsPrinter o

instance O.HasParentTypes Printer
type instance O.ParentTypes Printer = '[GObject.Object.Object]

-- | Cast to t'Printer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPrinter :: (MIO.MonadIO m, IsPrinter o) => o -> m Printer
toPrinter = MIO.liftIO . B.ManagedPtr.unsafeCastTo Printer

-- | Convert t'Printer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Printer) where
    gvalueGType_ = c_gtk_printer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Printer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Printer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Printer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePrinterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePrinterMethod "acceptsPdf" o = PrinterAcceptsPdfMethodInfo
    ResolvePrinterMethod "acceptsPs" o = PrinterAcceptsPsMethodInfo
    ResolvePrinterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePrinterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePrinterMethod "compare" o = PrinterCompareMethodInfo
    ResolvePrinterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePrinterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePrinterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePrinterMethod "hasDetails" o = PrinterHasDetailsMethodInfo
    ResolvePrinterMethod "isAcceptingJobs" o = PrinterIsAcceptingJobsMethodInfo
    ResolvePrinterMethod "isActive" o = PrinterIsActiveMethodInfo
    ResolvePrinterMethod "isDefault" o = PrinterIsDefaultMethodInfo
    ResolvePrinterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePrinterMethod "isPaused" o = PrinterIsPausedMethodInfo
    ResolvePrinterMethod "isVirtual" o = PrinterIsVirtualMethodInfo
    ResolvePrinterMethod "listPapers" o = PrinterListPapersMethodInfo
    ResolvePrinterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePrinterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePrinterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePrinterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePrinterMethod "requestDetails" o = PrinterRequestDetailsMethodInfo
    ResolvePrinterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePrinterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePrinterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePrinterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePrinterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePrinterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePrinterMethod "getBackend" o = PrinterGetBackendMethodInfo
    ResolvePrinterMethod "getCapabilities" o = PrinterGetCapabilitiesMethodInfo
    ResolvePrinterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePrinterMethod "getDefaultPageSize" o = PrinterGetDefaultPageSizeMethodInfo
    ResolvePrinterMethod "getDescription" o = PrinterGetDescriptionMethodInfo
    ResolvePrinterMethod "getHardMargins" o = PrinterGetHardMarginsMethodInfo
    ResolvePrinterMethod "getHardMarginsForPaperSize" o = PrinterGetHardMarginsForPaperSizeMethodInfo
    ResolvePrinterMethod "getIconName" o = PrinterGetIconNameMethodInfo
    ResolvePrinterMethod "getJobCount" o = PrinterGetJobCountMethodInfo
    ResolvePrinterMethod "getLocation" o = PrinterGetLocationMethodInfo
    ResolvePrinterMethod "getName" o = PrinterGetNameMethodInfo
    ResolvePrinterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePrinterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePrinterMethod "getStateMessage" o = PrinterGetStateMessageMethodInfo
    ResolvePrinterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePrinterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePrinterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePrinterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePrinterMethod t Printer, O.OverloadedMethod info Printer p) => OL.IsLabel t (Printer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePrinterMethod t Printer, O.OverloadedMethod info Printer p, R.HasField t Printer p) => R.HasField t Printer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePrinterMethod t Printer, O.OverloadedMethodInfo info Printer) => OL.IsLabel t (O.MethodProxy info Printer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Printer::details-acquired
-- | Emitted in response to a request for detailed information
-- about a printer from the print backend.
-- 
-- The /@success@/ parameter indicates if the information was
-- actually obtained.
type PrinterDetailsAcquiredCallback =
    Bool
    -- ^ /@success@/: 'P.True' if the details were successfully acquired
    -> IO ()

type C_PrinterDetailsAcquiredCallback =
    Ptr Printer ->                          -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_PrinterDetailsAcquiredCallback`.
foreign import ccall "wrapper"
    mk_PrinterDetailsAcquiredCallback :: C_PrinterDetailsAcquiredCallback -> IO (FunPtr C_PrinterDetailsAcquiredCallback)

wrap_PrinterDetailsAcquiredCallback :: 
    GObject a => (a -> PrinterDetailsAcquiredCallback) ->
    C_PrinterDetailsAcquiredCallback
wrap_PrinterDetailsAcquiredCallback gi'cb gi'selfPtr success _ = do
    let success' = (/= 0) success
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  success'


-- | Connect a signal handler for the [detailsAcquired](#signal:detailsAcquired) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' printer #detailsAcquired callback
-- @
-- 
-- 
onPrinterDetailsAcquired :: (IsPrinter a, MonadIO m) => a -> ((?self :: a) => PrinterDetailsAcquiredCallback) -> m SignalHandlerId
onPrinterDetailsAcquired obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PrinterDetailsAcquiredCallback wrapped
    wrapped'' <- mk_PrinterDetailsAcquiredCallback wrapped'
    connectSignalFunPtr obj "details-acquired" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [detailsAcquired](#signal:detailsAcquired) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' printer #detailsAcquired callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPrinterDetailsAcquired :: (IsPrinter a, MonadIO m) => a -> ((?self :: a) => PrinterDetailsAcquiredCallback) -> m SignalHandlerId
afterPrinterDetailsAcquired obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PrinterDetailsAcquiredCallback wrapped
    wrapped'' <- mk_PrinterDetailsAcquiredCallback wrapped'
    connectSignalFunPtr obj "details-acquired" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PrinterDetailsAcquiredSignalInfo
instance SignalInfo PrinterDetailsAcquiredSignalInfo where
    type HaskellCallbackType PrinterDetailsAcquiredSignalInfo = PrinterDetailsAcquiredCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PrinterDetailsAcquiredCallback cb
        cb'' <- mk_PrinterDetailsAcquiredCallback cb'
        connectSignalFunPtr obj "details-acquired" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer::details-acquired"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:signal:detailsAcquired"})

#endif

-- VVV Prop "accepting-jobs"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@accepting-jobs@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #acceptingJobs
-- @
getPrinterAcceptingJobs :: (MonadIO m, IsPrinter o) => o -> m Bool
getPrinterAcceptingJobs obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "accepting-jobs"

#if defined(ENABLE_OVERLOADING)
data PrinterAcceptingJobsPropertyInfo
instance AttrInfo PrinterAcceptingJobsPropertyInfo where
    type AttrAllowedOps PrinterAcceptingJobsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint PrinterAcceptingJobsPropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterAcceptingJobsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint PrinterAcceptingJobsPropertyInfo = (~) ()
    type AttrTransferType PrinterAcceptingJobsPropertyInfo = ()
    type AttrGetType PrinterAcceptingJobsPropertyInfo = Bool
    type AttrLabel PrinterAcceptingJobsPropertyInfo = "accepting-jobs"
    type AttrOrigin PrinterAcceptingJobsPropertyInfo = Printer
    attrGet = getPrinterAcceptingJobs
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.acceptingJobs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:acceptingJobs"
        })
#endif

-- VVV Prop "accepts-pdf"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@accepts-pdf@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #acceptsPdf
-- @
getPrinterAcceptsPdf :: (MonadIO m, IsPrinter o) => o -> m Bool
getPrinterAcceptsPdf obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "accepts-pdf"

-- | Construct a t'GValueConstruct' with valid value for the “@accepts-pdf@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrinterAcceptsPdf :: (IsPrinter o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPrinterAcceptsPdf val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "accepts-pdf" val

#if defined(ENABLE_OVERLOADING)
data PrinterAcceptsPdfPropertyInfo
instance AttrInfo PrinterAcceptsPdfPropertyInfo where
    type AttrAllowedOps PrinterAcceptsPdfPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrinterAcceptsPdfPropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterAcceptsPdfPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PrinterAcceptsPdfPropertyInfo = (~) Bool
    type AttrTransferType PrinterAcceptsPdfPropertyInfo = Bool
    type AttrGetType PrinterAcceptsPdfPropertyInfo = Bool
    type AttrLabel PrinterAcceptsPdfPropertyInfo = "accepts-pdf"
    type AttrOrigin PrinterAcceptsPdfPropertyInfo = Printer
    attrGet = getPrinterAcceptsPdf
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrinterAcceptsPdf
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.acceptsPdf"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:acceptsPdf"
        })
#endif

-- VVV Prop "accepts-ps"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@accepts-ps@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #acceptsPs
-- @
getPrinterAcceptsPs :: (MonadIO m, IsPrinter o) => o -> m Bool
getPrinterAcceptsPs obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "accepts-ps"

-- | Construct a t'GValueConstruct' with valid value for the “@accepts-ps@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrinterAcceptsPs :: (IsPrinter o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPrinterAcceptsPs val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "accepts-ps" val

#if defined(ENABLE_OVERLOADING)
data PrinterAcceptsPsPropertyInfo
instance AttrInfo PrinterAcceptsPsPropertyInfo where
    type AttrAllowedOps PrinterAcceptsPsPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrinterAcceptsPsPropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterAcceptsPsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PrinterAcceptsPsPropertyInfo = (~) Bool
    type AttrTransferType PrinterAcceptsPsPropertyInfo = Bool
    type AttrGetType PrinterAcceptsPsPropertyInfo = Bool
    type AttrLabel PrinterAcceptsPsPropertyInfo = "accepts-ps"
    type AttrOrigin PrinterAcceptsPsPropertyInfo = Printer
    attrGet = getPrinterAcceptsPs
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrinterAcceptsPs
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.acceptsPs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:acceptsPs"
        })
#endif

-- VVV Prop "icon-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #iconName
-- @
getPrinterIconName :: (MonadIO m, IsPrinter o) => o -> m T.Text
getPrinterIconName obj = MIO.liftIO $ checkUnexpectedNothing "getPrinterIconName" $ B.Properties.getObjectPropertyString obj "icon-name"

#if defined(ENABLE_OVERLOADING)
data PrinterIconNamePropertyInfo
instance AttrInfo PrinterIconNamePropertyInfo where
    type AttrAllowedOps PrinterIconNamePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrinterIconNamePropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterIconNamePropertyInfo = (~) ()
    type AttrTransferTypeConstraint PrinterIconNamePropertyInfo = (~) ()
    type AttrTransferType PrinterIconNamePropertyInfo = ()
    type AttrGetType PrinterIconNamePropertyInfo = T.Text
    type AttrLabel PrinterIconNamePropertyInfo = "icon-name"
    type AttrOrigin PrinterIconNamePropertyInfo = Printer
    attrGet = getPrinterIconName
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.iconName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:iconName"
        })
#endif

-- VVV Prop "is-virtual"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-virtual@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #isVirtual
-- @
getPrinterIsVirtual :: (MonadIO m, IsPrinter o) => o -> m Bool
getPrinterIsVirtual obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-virtual"

-- | Construct a t'GValueConstruct' with valid value for the “@is-virtual@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrinterIsVirtual :: (IsPrinter o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPrinterIsVirtual val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "is-virtual" val

#if defined(ENABLE_OVERLOADING)
data PrinterIsVirtualPropertyInfo
instance AttrInfo PrinterIsVirtualPropertyInfo where
    type AttrAllowedOps PrinterIsVirtualPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrinterIsVirtualPropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterIsVirtualPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PrinterIsVirtualPropertyInfo = (~) Bool
    type AttrTransferType PrinterIsVirtualPropertyInfo = Bool
    type AttrGetType PrinterIsVirtualPropertyInfo = Bool
    type AttrLabel PrinterIsVirtualPropertyInfo = "is-virtual"
    type AttrOrigin PrinterIsVirtualPropertyInfo = Printer
    attrGet = getPrinterIsVirtual
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrinterIsVirtual
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.isVirtual"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:isVirtual"
        })
#endif

-- VVV Prop "job-count"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@job-count@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #jobCount
-- @
getPrinterJobCount :: (MonadIO m, IsPrinter o) => o -> m Int32
getPrinterJobCount obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "job-count"

#if defined(ENABLE_OVERLOADING)
data PrinterJobCountPropertyInfo
instance AttrInfo PrinterJobCountPropertyInfo where
    type AttrAllowedOps PrinterJobCountPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint PrinterJobCountPropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterJobCountPropertyInfo = (~) ()
    type AttrTransferTypeConstraint PrinterJobCountPropertyInfo = (~) ()
    type AttrTransferType PrinterJobCountPropertyInfo = ()
    type AttrGetType PrinterJobCountPropertyInfo = Int32
    type AttrLabel PrinterJobCountPropertyInfo = "job-count"
    type AttrOrigin PrinterJobCountPropertyInfo = Printer
    attrGet = getPrinterJobCount
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.jobCount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:jobCount"
        })
#endif

-- VVV Prop "location"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@location@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #location
-- @
getPrinterLocation :: (MonadIO m, IsPrinter o) => o -> m T.Text
getPrinterLocation obj = MIO.liftIO $ checkUnexpectedNothing "getPrinterLocation" $ B.Properties.getObjectPropertyString obj "location"

#if defined(ENABLE_OVERLOADING)
data PrinterLocationPropertyInfo
instance AttrInfo PrinterLocationPropertyInfo where
    type AttrAllowedOps PrinterLocationPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrinterLocationPropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterLocationPropertyInfo = (~) ()
    type AttrTransferTypeConstraint PrinterLocationPropertyInfo = (~) ()
    type AttrTransferType PrinterLocationPropertyInfo = ()
    type AttrGetType PrinterLocationPropertyInfo = T.Text
    type AttrLabel PrinterLocationPropertyInfo = "location"
    type AttrOrigin PrinterLocationPropertyInfo = Printer
    attrGet = getPrinterLocation
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.location"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:location"
        })
#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #name
-- @
getPrinterName :: (MonadIO m, IsPrinter o) => o -> m T.Text
getPrinterName obj = MIO.liftIO $ checkUnexpectedNothing "getPrinterName" $ B.Properties.getObjectPropertyString obj "name"

-- | Construct a t'GValueConstruct' with valid value for the “@name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrinterName :: (IsPrinter o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructPrinterName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data PrinterNamePropertyInfo
instance AttrInfo PrinterNamePropertyInfo where
    type AttrAllowedOps PrinterNamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrinterNamePropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint PrinterNamePropertyInfo = (~) T.Text
    type AttrTransferType PrinterNamePropertyInfo = T.Text
    type AttrGetType PrinterNamePropertyInfo = T.Text
    type AttrLabel PrinterNamePropertyInfo = "name"
    type AttrOrigin PrinterNamePropertyInfo = Printer
    attrGet = getPrinterName
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrinterName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:name"
        })
#endif

-- VVV Prop "paused"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@paused@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #paused
-- @
getPrinterPaused :: (MonadIO m, IsPrinter o) => o -> m Bool
getPrinterPaused obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "paused"

#if defined(ENABLE_OVERLOADING)
data PrinterPausedPropertyInfo
instance AttrInfo PrinterPausedPropertyInfo where
    type AttrAllowedOps PrinterPausedPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint PrinterPausedPropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterPausedPropertyInfo = (~) ()
    type AttrTransferTypeConstraint PrinterPausedPropertyInfo = (~) ()
    type AttrTransferType PrinterPausedPropertyInfo = ()
    type AttrGetType PrinterPausedPropertyInfo = Bool
    type AttrLabel PrinterPausedPropertyInfo = "paused"
    type AttrOrigin PrinterPausedPropertyInfo = Printer
    attrGet = getPrinterPaused
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.paused"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:paused"
        })
#endif

-- VVV Prop "state-message"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@state-message@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printer #stateMessage
-- @
getPrinterStateMessage :: (MonadIO m, IsPrinter o) => o -> m T.Text
getPrinterStateMessage obj = MIO.liftIO $ checkUnexpectedNothing "getPrinterStateMessage" $ B.Properties.getObjectPropertyString obj "state-message"

#if defined(ENABLE_OVERLOADING)
data PrinterStateMessagePropertyInfo
instance AttrInfo PrinterStateMessagePropertyInfo where
    type AttrAllowedOps PrinterStateMessagePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrinterStateMessagePropertyInfo = IsPrinter
    type AttrSetTypeConstraint PrinterStateMessagePropertyInfo = (~) ()
    type AttrTransferTypeConstraint PrinterStateMessagePropertyInfo = (~) ()
    type AttrTransferType PrinterStateMessagePropertyInfo = ()
    type AttrGetType PrinterStateMessagePropertyInfo = T.Text
    type AttrLabel PrinterStateMessagePropertyInfo = "state-message"
    type AttrOrigin PrinterStateMessagePropertyInfo = Printer
    attrGet = getPrinterStateMessage
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.stateMessage"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#g:attr:stateMessage"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Printer
type instance O.AttributeList Printer = PrinterAttributeList
type PrinterAttributeList = ('[ '("acceptingJobs", PrinterAcceptingJobsPropertyInfo), '("acceptsPdf", PrinterAcceptsPdfPropertyInfo), '("acceptsPs", PrinterAcceptsPsPropertyInfo), '("iconName", PrinterIconNamePropertyInfo), '("isVirtual", PrinterIsVirtualPropertyInfo), '("jobCount", PrinterJobCountPropertyInfo), '("location", PrinterLocationPropertyInfo), '("name", PrinterNamePropertyInfo), '("paused", PrinterPausedPropertyInfo), '("stateMessage", PrinterStateMessagePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
printerAcceptingJobs :: AttrLabelProxy "acceptingJobs"
printerAcceptingJobs = AttrLabelProxy

printerIconName :: AttrLabelProxy "iconName"
printerIconName = AttrLabelProxy

printerJobCount :: AttrLabelProxy "jobCount"
printerJobCount = AttrLabelProxy

printerLocation :: AttrLabelProxy "location"
printerLocation = AttrLabelProxy

printerName :: AttrLabelProxy "name"
printerName = AttrLabelProxy

printerPaused :: AttrLabelProxy "paused"
printerPaused = AttrLabelProxy

printerStateMessage :: AttrLabelProxy "stateMessage"
printerStateMessage = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Printer = PrinterSignalList
type PrinterSignalList = ('[ '("detailsAcquired", PrinterDetailsAcquiredSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Printer::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the printer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintBackend`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "virtual_"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the printer is virtual"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Printer" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_new" gtk_printer_new :: 
    CString ->                              -- name : TBasicType TUTF8
    Ptr Gtk.PrintBackend.PrintBackend ->    -- backend : TInterface (Name {namespace = "Gtk", name = "PrintBackend"})
    CInt ->                                 -- virtual_ : TBasicType TBoolean
    IO (Ptr Printer)

-- | Creates a new @GtkPrinter@.
printerNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the name of the printer
    -> Gtk.PrintBackend.PrintBackend
    -- ^ /@backend@/: a @GtkPrintBackend@
    -> Bool
    -- ^ /@virtual_@/: whether the printer is virtual
    -> m Printer
    -- ^ __Returns:__ a new @GtkPrinter@
printerNew name backend virtual_ = liftIO $ do
    name' <- textToCString name
    backend' <- unsafeManagedPtrGetPtr backend
    let virtual_' = (P.fromIntegral . P.fromEnum) virtual_
    result <- gtk_printer_new name' backend' virtual_'
    checkUnexpectedReturnNULL "printerNew" result
    result' <- (wrapObject Printer) result
    touchManagedPtr backend
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Printer::accepts_pdf
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_accepts_pdf" gtk_printer_accepts_pdf :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CInt

-- | Returns whether the printer accepts input in
-- PDF format.
printerAcceptsPdf ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@printer@/ accepts PDF
printerAcceptsPdf printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_accepts_pdf printer'
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterAcceptsPdfMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterAcceptsPdfMethodInfo a signature where
    overloadedMethod = printerAcceptsPdf

instance O.OverloadedMethodInfo PrinterAcceptsPdfMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerAcceptsPdf",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerAcceptsPdf"
        })


#endif

-- method Printer::accepts_ps
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_accepts_ps" gtk_printer_accepts_ps :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CInt

-- | Returns whether the printer accepts input in
-- PostScript format.
printerAcceptsPs ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@printer@/ accepts PostScript
printerAcceptsPs printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_accepts_ps printer'
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterAcceptsPsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterAcceptsPsMethodInfo a signature where
    overloadedMethod = printerAcceptsPs

instance O.OverloadedMethodInfo PrinterAcceptsPsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerAcceptsPs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerAcceptsPs"
        })


#endif

-- method Printer::compare
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another `GtkPrinter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_compare" gtk_printer_compare :: 
    Ptr Printer ->                          -- a : TInterface (Name {namespace = "Gtk", name = "Printer"})
    Ptr Printer ->                          -- b : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO Int32

-- | Compares two printers.
printerCompare ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a, IsPrinter b) =>
    a
    -- ^ /@a@/: a @GtkPrinter@
    -> b
    -- ^ /@b@/: another @GtkPrinter@
    -> m Int32
    -- ^ __Returns:__ 0 if the printer match, a negative value if /@a@/ \< /@b@/,
    --   or a positive value if /@a@/ > /@b@/
printerCompare a b = liftIO $ do
    a' <- unsafeManagedPtrCastPtr a
    b' <- unsafeManagedPtrCastPtr b
    result <- gtk_printer_compare a' b'
    touchManagedPtr a
    touchManagedPtr b
    return result

#if defined(ENABLE_OVERLOADING)
data PrinterCompareMethodInfo
instance (signature ~ (b -> m Int32), MonadIO m, IsPrinter a, IsPrinter b) => O.OverloadedMethod PrinterCompareMethodInfo a signature where
    overloadedMethod = printerCompare

instance O.OverloadedMethodInfo PrinterCompareMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerCompare",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerCompare"
        })


#endif

-- method Printer::get_backend
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PrintBackend" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_backend" gtk_printer_get_backend :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO (Ptr Gtk.PrintBackend.PrintBackend)

-- | Returns the backend of the printer.
printerGetBackend ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Gtk.PrintBackend.PrintBackend
    -- ^ __Returns:__ the backend of /@printer@/
printerGetBackend printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_backend printer'
    checkUnexpectedReturnNULL "printerGetBackend" result
    result' <- (newPtr Gtk.PrintBackend.PrintBackend) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterGetBackendMethodInfo
instance (signature ~ (m Gtk.PrintBackend.PrintBackend), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetBackendMethodInfo a signature where
    overloadedMethod = printerGetBackend

instance O.OverloadedMethodInfo PrinterGetBackendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetBackend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetBackend"
        })


#endif

-- method Printer::get_capabilities
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "PrintCapabilities" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_capabilities" gtk_printer_get_capabilities :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CUInt

-- | Returns the printer’s capabilities.
-- 
-- This is useful when you’re using @GtkPrintUnixDialog@’s
-- manual-capabilities setting and need to know which settings
-- the printer can handle and which you must handle yourself.
-- 
-- This will return 0 unless the printer’s details are
-- available, see 'GI.Gtk.Objects.Printer.printerHasDetails' and
-- 'GI.Gtk.Objects.Printer.printerRequestDetails'.
printerGetCapabilities ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m [Gtk.Flags.PrintCapabilities]
    -- ^ __Returns:__ the printer’s capabilities
printerGetCapabilities printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_capabilities printer'
    let result' = wordToGFlags result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterGetCapabilitiesMethodInfo
instance (signature ~ (m [Gtk.Flags.PrintCapabilities]), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetCapabilitiesMethodInfo a signature where
    overloadedMethod = printerGetCapabilities

instance O.OverloadedMethodInfo PrinterGetCapabilitiesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetCapabilities",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetCapabilities"
        })


#endif

-- method Printer::get_default_page_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PageSetup" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_default_page_size" gtk_printer_get_default_page_size :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO (Ptr Gtk.PageSetup.PageSetup)

-- | Returns default page size of /@printer@/.
printerGetDefaultPageSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Gtk.PageSetup.PageSetup
    -- ^ __Returns:__ a newly allocated @GtkPageSetup@ with default page size
    --   of the printer.
printerGetDefaultPageSize printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_default_page_size printer'
    checkUnexpectedReturnNULL "printerGetDefaultPageSize" result
    result' <- (wrapObject Gtk.PageSetup.PageSetup) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterGetDefaultPageSizeMethodInfo
instance (signature ~ (m Gtk.PageSetup.PageSetup), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetDefaultPageSizeMethodInfo a signature where
    overloadedMethod = printerGetDefaultPageSize

instance O.OverloadedMethodInfo PrinterGetDefaultPageSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetDefaultPageSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetDefaultPageSize"
        })


#endif

-- method Printer::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_description" gtk_printer_get_description :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CString

-- | Gets the description of the printer.
printerGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m T.Text
    -- ^ __Returns:__ the description of /@printer@/
printerGetDescription printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_description printer'
    checkUnexpectedReturnNULL "printerGetDescription" result
    result' <- cstringToText result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterGetDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetDescriptionMethodInfo a signature where
    overloadedMethod = printerGetDescription

instance O.OverloadedMethodInfo PrinterGetDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetDescription"
        })


#endif

-- method Printer::get_hard_margins
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "top"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the top margin in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "bottom"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the bottom margin in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "left"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the left margin in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "right"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the right margin in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_hard_margins" gtk_printer_get_hard_margins :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    Ptr CDouble ->                          -- top : TBasicType TDouble
    Ptr CDouble ->                          -- bottom : TBasicType TDouble
    Ptr CDouble ->                          -- left : TBasicType TDouble
    Ptr CDouble ->                          -- right : TBasicType TDouble
    IO CInt

-- | Retrieve the hard margins of /@printer@/.
-- 
-- These are the margins that define the area at the borders
-- of the paper that the printer cannot print to.
-- 
-- Note: This will not succeed unless the printer’s details are
-- available, see 'GI.Gtk.Objects.Printer.printerHasDetails' and
-- 'GI.Gtk.Objects.Printer.printerRequestDetails'.
printerGetHardMargins ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m ((Bool, Double, Double, Double, Double))
    -- ^ __Returns:__ 'P.True' iff the hard margins were retrieved
printerGetHardMargins printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    top <- allocMem :: IO (Ptr CDouble)
    bottom <- allocMem :: IO (Ptr CDouble)
    left <- allocMem :: IO (Ptr CDouble)
    right <- allocMem :: IO (Ptr CDouble)
    result <- gtk_printer_get_hard_margins printer' top bottom left right
    let result' = (/= 0) result
    top' <- peek top
    let top'' = realToFrac top'
    bottom' <- peek bottom
    let bottom'' = realToFrac bottom'
    left' <- peek left
    let left'' = realToFrac left'
    right' <- peek right
    let right'' = realToFrac right'
    touchManagedPtr printer
    freeMem top
    freeMem bottom
    freeMem left
    freeMem right
    return (result', top'', bottom'', left'', right'')

#if defined(ENABLE_OVERLOADING)
data PrinterGetHardMarginsMethodInfo
instance (signature ~ (m ((Bool, Double, Double, Double, Double))), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetHardMarginsMethodInfo a signature where
    overloadedMethod = printerGetHardMargins

instance O.OverloadedMethodInfo PrinterGetHardMarginsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetHardMargins",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetHardMargins"
        })


#endif

-- method Printer::get_hard_margins_for_paper_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paper_size"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PaperSize" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaperSize`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "top"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the top margin in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "bottom"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the bottom margin in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "left"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the left margin in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "right"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the right margin in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_hard_margins_for_paper_size" gtk_printer_get_hard_margins_for_paper_size :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    Ptr Gtk.PaperSize.PaperSize ->          -- paper_size : TInterface (Name {namespace = "Gtk", name = "PaperSize"})
    Ptr CDouble ->                          -- top : TBasicType TDouble
    Ptr CDouble ->                          -- bottom : TBasicType TDouble
    Ptr CDouble ->                          -- left : TBasicType TDouble
    Ptr CDouble ->                          -- right : TBasicType TDouble
    IO CInt

-- | Retrieve the hard margins of /@printer@/ for /@paperSize@/.
-- 
-- These are the margins that define the area at the borders
-- of the paper that the printer cannot print to.
-- 
-- Note: This will not succeed unless the printer’s details are
-- available, see 'GI.Gtk.Objects.Printer.printerHasDetails' and
-- 'GI.Gtk.Objects.Printer.printerRequestDetails'.
printerGetHardMarginsForPaperSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> Gtk.PaperSize.PaperSize
    -- ^ /@paperSize@/: a @GtkPaperSize@
    -> m ((Bool, Double, Double, Double, Double))
    -- ^ __Returns:__ 'P.True' iff the hard margins were retrieved
printerGetHardMarginsForPaperSize printer paperSize = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    paperSize' <- unsafeManagedPtrGetPtr paperSize
    top <- allocMem :: IO (Ptr CDouble)
    bottom <- allocMem :: IO (Ptr CDouble)
    left <- allocMem :: IO (Ptr CDouble)
    right <- allocMem :: IO (Ptr CDouble)
    result <- gtk_printer_get_hard_margins_for_paper_size printer' paperSize' top bottom left right
    let result' = (/= 0) result
    top' <- peek top
    let top'' = realToFrac top'
    bottom' <- peek bottom
    let bottom'' = realToFrac bottom'
    left' <- peek left
    let left'' = realToFrac left'
    right' <- peek right
    let right'' = realToFrac right'
    touchManagedPtr printer
    touchManagedPtr paperSize
    freeMem top
    freeMem bottom
    freeMem left
    freeMem right
    return (result', top'', bottom'', left'', right'')

#if defined(ENABLE_OVERLOADING)
data PrinterGetHardMarginsForPaperSizeMethodInfo
instance (signature ~ (Gtk.PaperSize.PaperSize -> m ((Bool, Double, Double, Double, Double))), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetHardMarginsForPaperSizeMethodInfo a signature where
    overloadedMethod = printerGetHardMarginsForPaperSize

instance O.OverloadedMethodInfo PrinterGetHardMarginsForPaperSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetHardMarginsForPaperSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetHardMarginsForPaperSize"
        })


#endif

-- method Printer::get_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_icon_name" gtk_printer_get_icon_name :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CString

-- | Gets the name of the icon to use for the printer.
printerGetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m T.Text
    -- ^ __Returns:__ the icon name for /@printer@/
printerGetIconName printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_icon_name printer'
    checkUnexpectedReturnNULL "printerGetIconName" result
    result' <- cstringToText result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterGetIconNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetIconNameMethodInfo a signature where
    overloadedMethod = printerGetIconName

instance O.OverloadedMethodInfo PrinterGetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetIconName"
        })


#endif

-- method Printer::get_job_count
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_job_count" gtk_printer_get_job_count :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO Int32

-- | Gets the number of jobs currently queued on the printer.
printerGetJobCount ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Int32
    -- ^ __Returns:__ the number of jobs on /@printer@/
printerGetJobCount printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_job_count printer'
    touchManagedPtr printer
    return result

#if defined(ENABLE_OVERLOADING)
data PrinterGetJobCountMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetJobCountMethodInfo a signature where
    overloadedMethod = printerGetJobCount

instance O.OverloadedMethodInfo PrinterGetJobCountMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetJobCount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetJobCount"
        })


#endif

-- method Printer::get_location
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_location" gtk_printer_get_location :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CString

-- | Returns a description of the location of the printer.
printerGetLocation ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m T.Text
    -- ^ __Returns:__ the location of /@printer@/
printerGetLocation printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_location printer'
    checkUnexpectedReturnNULL "printerGetLocation" result
    result' <- cstringToText result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterGetLocationMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetLocationMethodInfo a signature where
    overloadedMethod = printerGetLocation

instance O.OverloadedMethodInfo PrinterGetLocationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetLocation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetLocation"
        })


#endif

-- method Printer::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_name" gtk_printer_get_name :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CString

-- | Returns the name of the printer.
printerGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m T.Text
    -- ^ __Returns:__ the name of /@printer@/
printerGetName printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_name printer'
    checkUnexpectedReturnNULL "printerGetName" result
    result' <- cstringToText result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetNameMethodInfo a signature where
    overloadedMethod = printerGetName

instance O.OverloadedMethodInfo PrinterGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetName"
        })


#endif

-- method Printer::get_state_message
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_get_state_message" gtk_printer_get_state_message :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CString

-- | Returns the state message describing the current state
-- of the printer.
printerGetStateMessage ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m T.Text
    -- ^ __Returns:__ the state message of /@printer@/
printerGetStateMessage printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_get_state_message printer'
    checkUnexpectedReturnNULL "printerGetStateMessage" result
    result' <- cstringToText result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterGetStateMessageMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterGetStateMessageMethodInfo a signature where
    overloadedMethod = printerGetStateMessage

instance O.OverloadedMethodInfo PrinterGetStateMessageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerGetStateMessage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerGetStateMessage"
        })


#endif

-- method Printer::has_details
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_has_details" gtk_printer_has_details :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CInt

-- | Returns whether the printer details are available.
printerHasDetails ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@printer@/ details are available
printerHasDetails printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_has_details printer'
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterHasDetailsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterHasDetailsMethodInfo a signature where
    overloadedMethod = printerHasDetails

instance O.OverloadedMethodInfo PrinterHasDetailsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerHasDetails",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerHasDetails"
        })


#endif

-- method Printer::is_accepting_jobs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_is_accepting_jobs" gtk_printer_is_accepting_jobs :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CInt

-- | Returns whether the printer is accepting jobs
printerIsAcceptingJobs ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@printer@/ is accepting jobs
printerIsAcceptingJobs printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_is_accepting_jobs printer'
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterIsAcceptingJobsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterIsAcceptingJobsMethodInfo a signature where
    overloadedMethod = printerIsAcceptingJobs

instance O.OverloadedMethodInfo PrinterIsAcceptingJobsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerIsAcceptingJobs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerIsAcceptingJobs"
        })


#endif

-- method Printer::is_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_is_active" gtk_printer_is_active :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CInt

-- | Returns whether the printer is currently active (i.e.
-- accepts new jobs).
printerIsActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@printer@/ is active
printerIsActive printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_is_active printer'
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterIsActiveMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterIsActiveMethodInfo a signature where
    overloadedMethod = printerIsActive

instance O.OverloadedMethodInfo PrinterIsActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerIsActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerIsActive"
        })


#endif

-- method Printer::is_default
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_is_default" gtk_printer_is_default :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CInt

-- | Returns whether the printer is the default printer.
printerIsDefault ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@printer@/ is the default
printerIsDefault printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_is_default printer'
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterIsDefaultMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterIsDefaultMethodInfo a signature where
    overloadedMethod = printerIsDefault

instance O.OverloadedMethodInfo PrinterIsDefaultMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerIsDefault",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerIsDefault"
        })


#endif

-- method Printer::is_paused
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_is_paused" gtk_printer_is_paused :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CInt

-- | Returns whether the printer is currently paused.
-- 
-- A paused printer still accepts jobs, but it is not
-- printing them.
printerIsPaused ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@printer@/ is paused
printerIsPaused printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_is_paused printer'
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterIsPausedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterIsPausedMethodInfo a signature where
    overloadedMethod = printerIsPaused

instance O.OverloadedMethodInfo PrinterIsPausedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerIsPaused",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerIsPaused"
        })


#endif

-- method Printer::is_virtual
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_is_virtual" gtk_printer_is_virtual :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO CInt

-- | Returns whether the printer is virtual (i.e. does not
-- represent actual printer hardware, but something like
-- a CUPS class).
printerIsVirtual ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@printer@/ is virtual
printerIsVirtual printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_is_virtual printer'
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

#if defined(ENABLE_OVERLOADING)
data PrinterIsVirtualMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterIsVirtualMethodInfo a signature where
    overloadedMethod = printerIsVirtual

instance O.OverloadedMethodInfo PrinterIsVirtualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerIsVirtual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerIsVirtual"
        })


#endif

-- method Printer::list_papers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gtk" , name = "PageSetup" }))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_list_papers" gtk_printer_list_papers :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO (Ptr (GList (Ptr Gtk.PageSetup.PageSetup)))

-- | Lists all the paper sizes /@printer@/ supports.
-- 
-- This will return and empty list unless the printer’s details
-- are available, see 'GI.Gtk.Objects.Printer.printerHasDetails' and
-- 'GI.Gtk.Objects.Printer.printerRequestDetails'.
printerListPapers ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m [Gtk.PageSetup.PageSetup]
    -- ^ __Returns:__ a newly
    --   allocated list of newly allocated @GtkPageSetup@s.
printerListPapers printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- gtk_printer_list_papers printer'
    result' <- unpackGList result
    result'' <- mapM (wrapObject Gtk.PageSetup.PageSetup) result'
    g_list_free result
    touchManagedPtr printer
    return result''

#if defined(ENABLE_OVERLOADING)
data PrinterListPapersMethodInfo
instance (signature ~ (m [Gtk.PageSetup.PageSetup]), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterListPapersMethodInfo a signature where
    overloadedMethod = printerListPapers

instance O.OverloadedMethodInfo PrinterListPapersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerListPapers",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerListPapers"
        })


#endif

-- method Printer::request_details
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_printer_request_details" gtk_printer_request_details :: 
    Ptr Printer ->                          -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    IO ()

-- | Requests the printer details.
-- 
-- When the details are available, the
-- [Printer::detailsAcquired]("GI.Gtk.Objects.Printer#g:signal:detailsAcquired") signal
-- will be emitted on /@printer@/.
printerRequestDetails ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrinter a) =>
    a
    -- ^ /@printer@/: a @GtkPrinter@
    -> m ()
printerRequestDetails printer = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    gtk_printer_request_details printer'
    touchManagedPtr printer
    return ()

#if defined(ENABLE_OVERLOADING)
data PrinterRequestDetailsMethodInfo
instance (signature ~ (m ()), MonadIO m, IsPrinter a) => O.OverloadedMethod PrinterRequestDetailsMethodInfo a signature where
    overloadedMethod = printerRequestDetails

instance O.OverloadedMethodInfo PrinterRequestDetailsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Printer.printerRequestDetails",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Printer.html#v:printerRequestDetails"
        })


#endif


