

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Flags
    ( 

 -- * Flags


-- ** BufferDiffFlagsT #flag:BufferDiffFlagsT#

    BufferDiffFlagsT(..)                    ,


-- ** BufferFlagsT #flag:BufferFlagsT#

    BufferFlagsT(..)                        ,


-- ** BufferSerializeFlagsT #flag:BufferSerializeFlagsT#

    BufferSerializeFlagsT(..)               ,


-- ** GlyphFlagsT #flag:GlyphFlagsT#

    GlyphFlagsT(..)                         ,


-- ** OtColorPaletteFlagsT #flag:OtColorPaletteFlagsT#

    OtColorPaletteFlagsT(..)                ,


-- ** OtMathGlyphPartFlagsT #flag:OtMathGlyphPartFlagsT#

    OtMathGlyphPartFlagsT(..)               ,


-- ** OtVarAxisFlagsT #flag:OtVarAxisFlagsT#

    OtVarAxisFlagsT(..)                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags ot_var_axis_flags_t
-- | Flags for t'GI.HarfBuzz.Structs.OtVarAxisInfoT.OtVarAxisInfoT'.
-- 
-- /Since: 2.2.0/
data OtVarAxisFlagsT = 
      OtVarAxisFlagsTHidden
    -- ^ The axis should not be exposed directly in user interfaces.
    | AnotherOtVarAxisFlagsT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtVarAxisFlagsT where
    fromEnum OtVarAxisFlagsTHidden = 1
    fromEnum (AnotherOtVarAxisFlagsT k) = k

    toEnum 1 = OtVarAxisFlagsTHidden
    toEnum k = AnotherOtVarAxisFlagsT k

instance P.Ord OtVarAxisFlagsT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtVarAxisFlagsT = '[]
instance O.HasParentTypes OtVarAxisFlagsT

foreign import ccall "hb_gobject_ot_var_axis_flags_get_type" c_hb_gobject_ot_var_axis_flags_get_type :: 
    IO GType

instance B.Types.TypedObject OtVarAxisFlagsT where
    glibType = c_hb_gobject_ot_var_axis_flags_get_type

instance B.Types.BoxedFlags OtVarAxisFlagsT

instance IsGFlag OtVarAxisFlagsT

-- Flags ot_math_glyph_part_flags_t
-- | Flags for math glyph parts.
-- 
-- /Since: 1.3.3/
data OtMathGlyphPartFlagsT = 
      OtMathGlyphPartFlagsTExtender
    -- ^ This is an extender glyph part that
    -- can be repeated to reach the desired length.
    | AnotherOtMathGlyphPartFlagsT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtMathGlyphPartFlagsT where
    fromEnum OtMathGlyphPartFlagsTExtender = 1
    fromEnum (AnotherOtMathGlyphPartFlagsT k) = k

    toEnum 1 = OtMathGlyphPartFlagsTExtender
    toEnum k = AnotherOtMathGlyphPartFlagsT k

instance P.Ord OtMathGlyphPartFlagsT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtMathGlyphPartFlagsT = '[]
instance O.HasParentTypes OtMathGlyphPartFlagsT

foreign import ccall "hb_gobject_ot_math_glyph_part_flags_get_type" c_hb_gobject_ot_math_glyph_part_flags_get_type :: 
    IO GType

instance B.Types.TypedObject OtMathGlyphPartFlagsT where
    glibType = c_hb_gobject_ot_math_glyph_part_flags_get_type

instance B.Types.BoxedFlags OtMathGlyphPartFlagsT

instance IsGFlag OtMathGlyphPartFlagsT

-- Flags ot_color_palette_flags_t
-- | Flags that describe the properties of color palette.
-- 
-- /Since: 2.1.0/
data OtColorPaletteFlagsT = 
      OtColorPaletteFlagsTDefault
    -- ^ Default indicating that there is nothing special
    --   to note about a color palette.
    | OtColorPaletteFlagsTUsableWithLightBackground
    -- ^ Flag indicating that the color
    --   palette is appropriate to use when displaying the font on a light background such as white.
    | OtColorPaletteFlagsTUsableWithDarkBackground
    -- ^ Flag indicating that the color
    --   palette is appropriate to use when displaying the font on a dark background such as black.
    | AnotherOtColorPaletteFlagsT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtColorPaletteFlagsT where
    fromEnum OtColorPaletteFlagsTDefault = 0
    fromEnum OtColorPaletteFlagsTUsableWithLightBackground = 1
    fromEnum OtColorPaletteFlagsTUsableWithDarkBackground = 2
    fromEnum (AnotherOtColorPaletteFlagsT k) = k

    toEnum 0 = OtColorPaletteFlagsTDefault
    toEnum 1 = OtColorPaletteFlagsTUsableWithLightBackground
    toEnum 2 = OtColorPaletteFlagsTUsableWithDarkBackground
    toEnum k = AnotherOtColorPaletteFlagsT k

instance P.Ord OtColorPaletteFlagsT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtColorPaletteFlagsT = '[]
instance O.HasParentTypes OtColorPaletteFlagsT

foreign import ccall "hb_gobject_ot_color_palette_flags_get_type" c_hb_gobject_ot_color_palette_flags_get_type :: 
    IO GType

instance B.Types.TypedObject OtColorPaletteFlagsT where
    glibType = c_hb_gobject_ot_color_palette_flags_get_type

instance B.Types.BoxedFlags OtColorPaletteFlagsT

instance IsGFlag OtColorPaletteFlagsT

-- Flags glyph_flags_t
-- | Flags for t'GI.HarfBuzz.Structs.GlyphInfoT.GlyphInfoT'.
-- 
-- /Since: 1.5.0/
data GlyphFlagsT = 
      GlyphFlagsTUnsafeToBreak
    -- ^ Indicates that if input text is broken at the
    -- 				   beginning of the cluster this glyph is part of,
    -- 				   then both sides need to be re-shaped, as the
    -- 				   result might be different.
    -- 				   On the flip side, it means that when this
    -- 				   flag is not present, then it is safe to break
    -- 				   the glyph-run at the beginning of this
    -- 				   cluster, and the two sides will represent the
    -- 				   exact same result one would get if breaking
    -- 				   input text at the beginning of this cluster
    -- 				   and shaping the two sides separately.
    -- 				   This can be used to optimize paragraph
    -- 				   layout, by avoiding re-shaping of each line
    -- 				   after line-breaking.
    | GlyphFlagsTUnsafeToConcat
    -- ^ Indicates that if input text is changed on one
    -- 				   side of the beginning of the cluster this glyph
    -- 				   is part of, then the shaping results for the
    -- 				   other side might change.
    -- 				   Note that the absence of this flag will NOT by
    -- 				   itself mean that it IS safe to concat text.
    -- 				   Only two pieces of text both of which clear of
    -- 				   this flag can be concatenated safely.
    -- 				   This can be used to optimize paragraph
    -- 				   layout, by avoiding re-shaping of each line
    -- 				   after line-breaking, by limiting the
    -- 				   reshaping to a small piece around the
    -- 				   breaking position only, even if the breaking
    -- 				   position carries the
    -- 				   @/HB_GLYPH_FLAG_UNSAFE_TO_BREAK/@ or when
    -- 				   hyphenation or other text transformation
    -- 				   happens at line-break position, in the following
    -- 				   way:
    -- 1. Iterate back from the line-break position
    --    until the first cluster start position that is
    --    NOT unsafe-to-concat, 2. shape the segment from
    --    there till the end of line, 3. check whether the
    --    resulting glyph-run also is clear of the
    --    unsafe-to-concat at its start-of-text position;
    --    if it is, just splice it into place and the line
    --    is shaped; If not, move on to a position further
    --    back that is clear of unsafe-to-concat and retry
    --    from there, and repeat.
    --    At the start of next line a similar algorithm can
    --    be implemented. That is: 1. Iterate forward from
    --    the line-break position until the first cluster
    --    start position that is NOT unsafe-to-concat, 2.
    --    shape the segment from beginning of the line to
    --    that position, 3. check whether the resulting
    --    glyph-run also is clear of the unsafe-to-concat
    --    at its end-of-text position; if it is, just splice
    --    it into place and the beginning is shaped; If not,
    --    move on to a position further forward that is clear
    --    of unsafe-to-concat and retry up to there, and repeat.
    --    A slight complication will arise in the
    --    implementation of the algorithm above,
    --    because while our buffer API has a way to
    --    return flags for position corresponding to
    --    start-of-text, there is currently no position
    --    corresponding to end-of-text.  This limitation
    --    can be alleviated by shaping more text than needed
    --    and looking for unsafe-to-concat flag within text
    --    clusters.
    --    The @/HB_GLYPH_FLAG_UNSAFE_TO_BREAK/@ flag will
    --    always imply this flag.
    -- 
    -- 
    -- 			   To use this flag, you must enable the buffer flag
    -- 			   /@hBBUFFERFLAGPRODUCEUNSAFETOCONCAT@/ during
    -- 			   shaping, otherwise the buffer flag will not be
    -- 			   reliably produced.
    -- 				   Since: 4.0.0
    | GlyphFlagsTSafeToInsertTatweel
    -- ^ In scripts that use elongation (Arabic,
    -- 				   Mongolian, Syriac, etc.), this flag signifies
    -- 				   that it is safe to insert a U+0640 TATWEEL
    -- 				   character before this cluster for elongation.
    -- 				   This flag does not determine the
    -- 				   script-specific elongation places, but only
    -- 				   when it is safe to do the elongation without
    -- 				   interrupting text shaping.
    -- 				   Since: 5.1.0
    | GlyphFlagsTDefined
    -- ^ All the currently defined flags.
    | AnotherGlyphFlagsT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum GlyphFlagsT where
    fromEnum GlyphFlagsTUnsafeToBreak = 1
    fromEnum GlyphFlagsTUnsafeToConcat = 2
    fromEnum GlyphFlagsTSafeToInsertTatweel = 4
    fromEnum GlyphFlagsTDefined = 7
    fromEnum (AnotherGlyphFlagsT k) = k

    toEnum 1 = GlyphFlagsTUnsafeToBreak
    toEnum 2 = GlyphFlagsTUnsafeToConcat
    toEnum 4 = GlyphFlagsTSafeToInsertTatweel
    toEnum 7 = GlyphFlagsTDefined
    toEnum k = AnotherGlyphFlagsT k

instance P.Ord GlyphFlagsT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes GlyphFlagsT = '[]
instance O.HasParentTypes GlyphFlagsT

foreign import ccall "hb_gobject_glyph_flags_get_type" c_hb_gobject_glyph_flags_get_type :: 
    IO GType

instance B.Types.TypedObject GlyphFlagsT where
    glibType = c_hb_gobject_glyph_flags_get_type

instance B.Types.BoxedFlags GlyphFlagsT

instance IsGFlag GlyphFlagsT

-- Flags buffer_serialize_flags_t
-- | Flags that control what glyph information are serialized in 'GI.HarfBuzz.Functions.bufferSerializeGlyphs'.
-- 
-- /Since: 0.9.20/
data BufferSerializeFlagsT = 
      BufferSerializeFlagsTDefault
    -- ^ serialize glyph names, clusters and positions.
    | BufferSerializeFlagsTNoClusters
    -- ^ do not serialize glyph cluster.
    | BufferSerializeFlagsTNoPositions
    -- ^ do not serialize glyph position information.
    | BufferSerializeFlagsTNoGlyphNames
    -- ^ do no serialize glyph name.
    | BufferSerializeFlagsTGlyphExtents
    -- ^ serialize glyph extents.
    | BufferSerializeFlagsTGlyphFlags
    -- ^ serialize glyph flags. Since: 1.5.0
    | BufferSerializeFlagsTNoAdvances
    -- ^ do not serialize glyph advances,
    --  glyph offsets will reflect absolute glyph positions. Since: 1.8.0
    | BufferSerializeFlagsTDefined
    -- ^ All currently defined flags. Since: 4.4.0
    | AnotherBufferSerializeFlagsT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BufferSerializeFlagsT where
    fromEnum BufferSerializeFlagsTDefault = 0
    fromEnum BufferSerializeFlagsTNoClusters = 1
    fromEnum BufferSerializeFlagsTNoPositions = 2
    fromEnum BufferSerializeFlagsTNoGlyphNames = 4
    fromEnum BufferSerializeFlagsTGlyphExtents = 8
    fromEnum BufferSerializeFlagsTGlyphFlags = 16
    fromEnum BufferSerializeFlagsTNoAdvances = 32
    fromEnum BufferSerializeFlagsTDefined = 63
    fromEnum (AnotherBufferSerializeFlagsT k) = k

    toEnum 0 = BufferSerializeFlagsTDefault
    toEnum 1 = BufferSerializeFlagsTNoClusters
    toEnum 2 = BufferSerializeFlagsTNoPositions
    toEnum 4 = BufferSerializeFlagsTNoGlyphNames
    toEnum 8 = BufferSerializeFlagsTGlyphExtents
    toEnum 16 = BufferSerializeFlagsTGlyphFlags
    toEnum 32 = BufferSerializeFlagsTNoAdvances
    toEnum 63 = BufferSerializeFlagsTDefined
    toEnum k = AnotherBufferSerializeFlagsT k

instance P.Ord BufferSerializeFlagsT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BufferSerializeFlagsT = '[]
instance O.HasParentTypes BufferSerializeFlagsT

foreign import ccall "hb_gobject_buffer_serialize_flags_get_type" c_hb_gobject_buffer_serialize_flags_get_type :: 
    IO GType

instance B.Types.TypedObject BufferSerializeFlagsT where
    glibType = c_hb_gobject_buffer_serialize_flags_get_type

instance B.Types.BoxedFlags BufferSerializeFlagsT

instance IsGFlag BufferSerializeFlagsT

-- Flags buffer_flags_t
-- | Flags for t'GI.HarfBuzz.Structs.BufferT.BufferT'.
-- 
-- /Since: 0.9.20/
data BufferFlagsT = 
      BufferFlagsTDefault
    -- ^ the default buffer flag.
    | BufferFlagsTBot
    -- ^ flag indicating that special handling of the beginning
    --                      of text paragraph can be applied to this buffer. Should usually
    --                      be set, unless you are passing to the buffer only part
    --                      of the text without the full context.
    | BufferFlagsTEot
    -- ^ flag indicating that special handling of the end of text
    --                      paragraph can be applied to this buffer, similar to
    --                      /@hBBUFFERFLAGBOT@/.
    | BufferFlagsTPreserveDefaultIgnorables
    -- ^ flag indication that character with Default_Ignorable
    --                      Unicode property should use the corresponding glyph
    --                      from the font, instead of hiding them (done by
    --                      replacing them with the space glyph and zeroing the
    --                      advance width.)  This flag takes precedence over
    --                      /@hBBUFFERFLAGREMOVEDEFAULTIGNORABLES@/.
    | BufferFlagsTRemoveDefaultIgnorables
    -- ^ flag indication that character with Default_Ignorable
    --                      Unicode property should be removed from glyph string
    --                      instead of hiding them (done by replacing them with the
    --                      space glyph and zeroing the advance width.)
    --                      /@hBBUFFERFLAGPRESERVEDEFAULTIGNORABLES@/ takes
    --                      precedence over this flag. Since: 1.8.0
    | BufferFlagsTDoNotInsertDottedCircle
    -- ^ flag indicating that a dotted circle should
    --                      not be inserted in the rendering of incorrect
    --                      character sequences (such at \<0905 093E>). Since: 2.4.0
    | BufferFlagsTVerify
    -- ^ flag indicating that the 'GI.HarfBuzz.Functions.shape' call and its variants
    --                      should perform various verification processes on the results
    --                      of the shaping operation on the buffer.  If the verification
    --                      fails, then either a buffer message is sent, if a message
    --                      handler is installed on the buffer, or a message is written
    --                      to standard error.  In either case, the shaping result might
    --                      be modified to show the failed output. Since: 3.4.0
    | BufferFlagsTProduceUnsafeToConcat
    -- ^ flag indicating that the /@hBGLYPHFLAGUNSAFETOCONCAT@/
    --                      glyph-flag should be produced by the shaper. By default
    --                      it will not be produced since it incurs a cost. Since: 4.0.0
    | BufferFlagsTProduceSafeToInsertTatweel
    -- ^ flag indicating that the /@hBGLYPHFLAGSAFETOINSERTTATWEEL@/
    --                      glyph-flag should be produced by the shaper. By default
    --                      it will not be produced. Since: 5.1.0
    | BufferFlagsTDefined
    -- ^ All currently defined flags: Since: 4.4.0
    | AnotherBufferFlagsT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BufferFlagsT where
    fromEnum BufferFlagsTDefault = 0
    fromEnum BufferFlagsTBot = 1
    fromEnum BufferFlagsTEot = 2
    fromEnum BufferFlagsTPreserveDefaultIgnorables = 4
    fromEnum BufferFlagsTRemoveDefaultIgnorables = 8
    fromEnum BufferFlagsTDoNotInsertDottedCircle = 16
    fromEnum BufferFlagsTVerify = 32
    fromEnum BufferFlagsTProduceUnsafeToConcat = 64
    fromEnum BufferFlagsTProduceSafeToInsertTatweel = 128
    fromEnum BufferFlagsTDefined = 255
    fromEnum (AnotherBufferFlagsT k) = k

    toEnum 0 = BufferFlagsTDefault
    toEnum 1 = BufferFlagsTBot
    toEnum 2 = BufferFlagsTEot
    toEnum 4 = BufferFlagsTPreserveDefaultIgnorables
    toEnum 8 = BufferFlagsTRemoveDefaultIgnorables
    toEnum 16 = BufferFlagsTDoNotInsertDottedCircle
    toEnum 32 = BufferFlagsTVerify
    toEnum 64 = BufferFlagsTProduceUnsafeToConcat
    toEnum 128 = BufferFlagsTProduceSafeToInsertTatweel
    toEnum 255 = BufferFlagsTDefined
    toEnum k = AnotherBufferFlagsT k

instance P.Ord BufferFlagsT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BufferFlagsT = '[]
instance O.HasParentTypes BufferFlagsT

foreign import ccall "hb_gobject_buffer_flags_get_type" c_hb_gobject_buffer_flags_get_type :: 
    IO GType

instance B.Types.TypedObject BufferFlagsT where
    glibType = c_hb_gobject_buffer_flags_get_type

instance B.Types.BoxedFlags BufferFlagsT

instance IsGFlag BufferFlagsT

-- Flags buffer_diff_flags_t
-- | Flags from comparing two t'GI.HarfBuzz.Structs.BufferT.BufferT'\'s.
-- 
-- Buffer with different t'GI.HarfBuzz.Enums.BufferContentTypeT' cannot be meaningfully
-- compared in any further detail.
-- 
-- For buffers with differing length, the per-glyph comparison is not
-- attempted, though we do still scan reference buffer for dotted circle and
-- @.notdef@ glyphs.
-- 
-- If the buffers have the same length, we compare them glyph-by-glyph and
-- report which aspect(s) of the glyph info\/position are different.
-- 
-- /Since: 1.5.0/
data BufferDiffFlagsT = 
      BufferDiffFlagsTEqual
    -- ^ equal buffers.
    | BufferDiffFlagsTContentTypeMismatch
    -- ^ buffers with different
    --     t'GI.HarfBuzz.Enums.BufferContentTypeT'.
    | BufferDiffFlagsTLengthMismatch
    -- ^ buffers with differing length.
    | BufferDiffFlagsTNotdefPresent
    -- ^ @.notdef@ glyph is present in the
    --     reference buffer.
    | BufferDiffFlagsTDottedCirclePresent
    -- ^ dotted circle glyph is present
    --     in the reference buffer.
    | BufferDiffFlagsTCodepointMismatch
    -- ^ difference in t'GI.HarfBuzz.Structs.GlyphInfoT.GlyphInfoT'.@/codepoint/@
    | BufferDiffFlagsTClusterMismatch
    -- ^ difference in t'GI.HarfBuzz.Structs.GlyphInfoT.GlyphInfoT'.@/cluster/@
    | BufferDiffFlagsTGlyphFlagsMismatch
    -- ^ difference in t'GI.HarfBuzz.Flags.GlyphFlagsT'.
    | BufferDiffFlagsTPositionMismatch
    -- ^ difference in t'GI.HarfBuzz.Structs.GlyphPositionT.GlyphPositionT'.
    | AnotherBufferDiffFlagsT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BufferDiffFlagsT where
    fromEnum BufferDiffFlagsTEqual = 0
    fromEnum BufferDiffFlagsTContentTypeMismatch = 1
    fromEnum BufferDiffFlagsTLengthMismatch = 2
    fromEnum BufferDiffFlagsTNotdefPresent = 4
    fromEnum BufferDiffFlagsTDottedCirclePresent = 8
    fromEnum BufferDiffFlagsTCodepointMismatch = 16
    fromEnum BufferDiffFlagsTClusterMismatch = 32
    fromEnum BufferDiffFlagsTGlyphFlagsMismatch = 64
    fromEnum BufferDiffFlagsTPositionMismatch = 128
    fromEnum (AnotherBufferDiffFlagsT k) = k

    toEnum 0 = BufferDiffFlagsTEqual
    toEnum 1 = BufferDiffFlagsTContentTypeMismatch
    toEnum 2 = BufferDiffFlagsTLengthMismatch
    toEnum 4 = BufferDiffFlagsTNotdefPresent
    toEnum 8 = BufferDiffFlagsTDottedCirclePresent
    toEnum 16 = BufferDiffFlagsTCodepointMismatch
    toEnum 32 = BufferDiffFlagsTClusterMismatch
    toEnum 64 = BufferDiffFlagsTGlyphFlagsMismatch
    toEnum 128 = BufferDiffFlagsTPositionMismatch
    toEnum k = AnotherBufferDiffFlagsT k

instance P.Ord BufferDiffFlagsT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BufferDiffFlagsT = '[]
instance O.HasParentTypes BufferDiffFlagsT

foreign import ccall "hb_gobject_buffer_diff_flags_get_type" c_hb_gobject_buffer_diff_flags_get_type :: 
    IO GType

instance B.Types.TypedObject BufferDiffFlagsT where
    glibType = c_hb_gobject_buffer_diff_flags_get_type

instance B.Types.BoxedFlags BufferDiffFlagsT

instance IsGFlag BufferDiffFlagsT


