module Text.XML.LibXML.Types where

import Foreign

newtype Document = Document (ForeignPtr Document)
newtype Node = Node (ForeignPtr Node)
newtype Property = Property (ForeignPtr Property)
newtype Namespace = Namespace (ForeignPtr Namespace)

withDocument :: Document -> (Ptr Document -> IO a) -> IO a
withDocument (Document ptr) = withForeignPtr ptr

withNode :: Node -> (Ptr Node -> IO a) -> IO a
withNode (Node ptr) = withForeignPtr ptr

withProperty :: Property -> (Ptr Property -> IO a) -> IO a
withProperty (Property ptr) = withForeignPtr ptr

withNamespace :: Namespace -> (Ptr Namespace -> IO a) -> IO a
withNamespace (Namespace ptr) = withForeignPtr ptr
