// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha3 "istio.io/client-go/pkg/apis/networking/v1alpha3"
	networkingv1alpha3 "istio.io/client-go/pkg/applyconfiguration/networking/v1alpha3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeWorkloadGroups implements WorkloadGroupInterface
type FakeWorkloadGroups struct {
	Fake *FakeNetworkingV1alpha3
	ns   string
}

var workloadgroupsResource = v1alpha3.SchemeGroupVersion.WithResource("workloadgroups")

var workloadgroupsKind = v1alpha3.SchemeGroupVersion.WithKind("WorkloadGroup")

// Get takes name of the workloadGroup, and returns the corresponding workloadGroup object, and an error if there is any.
func (c *FakeWorkloadGroups) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha3.WorkloadGroup, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(workloadgroupsResource, c.ns, name), &v1alpha3.WorkloadGroup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha3.WorkloadGroup), err
}

// List takes label and field selectors, and returns the list of WorkloadGroups that match those selectors.
func (c *FakeWorkloadGroups) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha3.WorkloadGroupList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(workloadgroupsResource, workloadgroupsKind, c.ns, opts), &v1alpha3.WorkloadGroupList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha3.WorkloadGroupList{ListMeta: obj.(*v1alpha3.WorkloadGroupList).ListMeta}
	for _, item := range obj.(*v1alpha3.WorkloadGroupList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested workloadGroups.
func (c *FakeWorkloadGroups) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(workloadgroupsResource, c.ns, opts))

}

// Create takes the representation of a workloadGroup and creates it.  Returns the server's representation of the workloadGroup, and an error, if there is any.
func (c *FakeWorkloadGroups) Create(ctx context.Context, workloadGroup *v1alpha3.WorkloadGroup, opts v1.CreateOptions) (result *v1alpha3.WorkloadGroup, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(workloadgroupsResource, c.ns, workloadGroup), &v1alpha3.WorkloadGroup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha3.WorkloadGroup), err
}

// Update takes the representation of a workloadGroup and updates it. Returns the server's representation of the workloadGroup, and an error, if there is any.
func (c *FakeWorkloadGroups) Update(ctx context.Context, workloadGroup *v1alpha3.WorkloadGroup, opts v1.UpdateOptions) (result *v1alpha3.WorkloadGroup, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(workloadgroupsResource, c.ns, workloadGroup), &v1alpha3.WorkloadGroup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha3.WorkloadGroup), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeWorkloadGroups) UpdateStatus(ctx context.Context, workloadGroup *v1alpha3.WorkloadGroup, opts v1.UpdateOptions) (*v1alpha3.WorkloadGroup, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(workloadgroupsResource, "status", c.ns, workloadGroup), &v1alpha3.WorkloadGroup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha3.WorkloadGroup), err
}

// Delete takes name of the workloadGroup and deletes it. Returns an error if one occurs.
func (c *FakeWorkloadGroups) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(workloadgroupsResource, c.ns, name, opts), &v1alpha3.WorkloadGroup{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeWorkloadGroups) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(workloadgroupsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha3.WorkloadGroupList{})
	return err
}

// Patch applies the patch and returns the patched workloadGroup.
func (c *FakeWorkloadGroups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha3.WorkloadGroup, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(workloadgroupsResource, c.ns, name, pt, data, subresources...), &v1alpha3.WorkloadGroup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha3.WorkloadGroup), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied workloadGroup.
func (c *FakeWorkloadGroups) Apply(ctx context.Context, workloadGroup *networkingv1alpha3.WorkloadGroupApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha3.WorkloadGroup, err error) {
	if workloadGroup == nil {
		return nil, fmt.Errorf("workloadGroup provided to Apply must not be nil")
	}
	data, err := json.Marshal(workloadGroup)
	if err != nil {
		return nil, err
	}
	name := workloadGroup.Name
	if name == nil {
		return nil, fmt.Errorf("workloadGroup.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(workloadgroupsResource, c.ns, *name, types.ApplyPatchType, data), &v1alpha3.WorkloadGroup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha3.WorkloadGroup), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeWorkloadGroups) ApplyStatus(ctx context.Context, workloadGroup *networkingv1alpha3.WorkloadGroupApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha3.WorkloadGroup, err error) {
	if workloadGroup == nil {
		return nil, fmt.Errorf("workloadGroup provided to Apply must not be nil")
	}
	data, err := json.Marshal(workloadGroup)
	if err != nil {
		return nil, err
	}
	name := workloadGroup.Name
	if name == nil {
		return nil, fmt.Errorf("workloadGroup.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(workloadgroupsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1alpha3.WorkloadGroup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha3.WorkloadGroup), err
}
