//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/access_loggers/filters/process_ratelimit/v3/process_ratelimit.proto

package process_ratelimitv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ProcessRateLimitFilter with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ProcessRateLimitFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ProcessRateLimitFilter with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ProcessRateLimitFilterMultiError, or nil if none found.
func (m *ProcessRateLimitFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *ProcessRateLimitFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetDynamicConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ProcessRateLimitFilterValidationError{
					field:  "DynamicConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ProcessRateLimitFilterValidationError{
					field:  "DynamicConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDynamicConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ProcessRateLimitFilterValidationError{
				field:  "DynamicConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ProcessRateLimitFilterMultiError(errors)
	}

	return nil
}

// ProcessRateLimitFilterMultiError is an error wrapping multiple validation
// errors returned by ProcessRateLimitFilter.ValidateAll() if the designated
// constraints aren't met.
type ProcessRateLimitFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProcessRateLimitFilterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProcessRateLimitFilterMultiError) AllErrors() []error { return m }

// ProcessRateLimitFilterValidationError is the validation error returned by
// ProcessRateLimitFilter.Validate if the designated constraints aren't met.
type ProcessRateLimitFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProcessRateLimitFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProcessRateLimitFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProcessRateLimitFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProcessRateLimitFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProcessRateLimitFilterValidationError) ErrorName() string {
	return "ProcessRateLimitFilterValidationError"
}

// Error satisfies the builtin error interface
func (e ProcessRateLimitFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProcessRateLimitFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProcessRateLimitFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProcessRateLimitFilterValidationError{}

// Validate checks the field values on DynamicTokenBucket with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DynamicTokenBucket) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DynamicTokenBucket with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DynamicTokenBucketMultiError, or nil if none found.
func (m *DynamicTokenBucket) ValidateAll() error {
	return m.validate(true)
}

func (m *DynamicTokenBucket) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetResourceName()) < 1 {
		err := DynamicTokenBucketValidationError{
			field:  "ResourceName",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetConfigSource() == nil {
		err := DynamicTokenBucketValidationError{
			field:  "ConfigSource",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetConfigSource()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DynamicTokenBucketValidationError{
					field:  "ConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DynamicTokenBucketValidationError{
					field:  "ConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DynamicTokenBucketValidationError{
				field:  "ConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return DynamicTokenBucketMultiError(errors)
	}

	return nil
}

// DynamicTokenBucketMultiError is an error wrapping multiple validation errors
// returned by DynamicTokenBucket.ValidateAll() if the designated constraints
// aren't met.
type DynamicTokenBucketMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DynamicTokenBucketMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DynamicTokenBucketMultiError) AllErrors() []error { return m }

// DynamicTokenBucketValidationError is the validation error returned by
// DynamicTokenBucket.Validate if the designated constraints aren't met.
type DynamicTokenBucketValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DynamicTokenBucketValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DynamicTokenBucketValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DynamicTokenBucketValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DynamicTokenBucketValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DynamicTokenBucketValidationError) ErrorName() string {
	return "DynamicTokenBucketValidationError"
}

// Error satisfies the builtin error interface
func (e DynamicTokenBucketValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDynamicTokenBucket.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DynamicTokenBucketValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DynamicTokenBucketValidationError{}
