//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/http/injected_credentials/oauth2/v3/oauth2.proto

package oauth2v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on OAuth2 with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *OAuth2) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on OAuth2 with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in OAuth2MultiError, or nil if none found.
func (m *OAuth2) ValidateAll() error {
	return m.validate(true)
}

func (m *OAuth2) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetTokenEndpoint() == nil {
		err := OAuth2ValidationError{
			field:  "TokenEndpoint",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTokenEndpoint()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OAuth2ValidationError{
					field:  "TokenEndpoint",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OAuth2ValidationError{
					field:  "TokenEndpoint",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTokenEndpoint()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OAuth2ValidationError{
				field:  "TokenEndpoint",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetTokenFetchRetryInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = OAuth2ValidationError{
				field:  "TokenFetchRetryInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(1*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := OAuth2ValidationError{
					field:  "TokenFetchRetryInterval",
					reason: "value must be greater than or equal to 1s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	for idx, item := range m.GetEndpointParams() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, OAuth2ValidationError{
						field:  fmt.Sprintf("EndpointParams[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, OAuth2ValidationError{
						field:  fmt.Sprintf("EndpointParams[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OAuth2ValidationError{
					field:  fmt.Sprintf("EndpointParams[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	oneofFlowTypePresent := false
	switch v := m.FlowType.(type) {
	case *OAuth2_ClientCredentials_:
		if v == nil {
			err := OAuth2ValidationError{
				field:  "FlowType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofFlowTypePresent = true

		if all {
			switch v := interface{}(m.GetClientCredentials()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, OAuth2ValidationError{
						field:  "ClientCredentials",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, OAuth2ValidationError{
						field:  "ClientCredentials",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetClientCredentials()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OAuth2ValidationError{
					field:  "ClientCredentials",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofFlowTypePresent {
		err := OAuth2ValidationError{
			field:  "FlowType",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return OAuth2MultiError(errors)
	}

	return nil
}

// OAuth2MultiError is an error wrapping multiple validation errors returned by
// OAuth2.ValidateAll() if the designated constraints aren't met.
type OAuth2MultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OAuth2MultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OAuth2MultiError) AllErrors() []error { return m }

// OAuth2ValidationError is the validation error returned by OAuth2.Validate if
// the designated constraints aren't met.
type OAuth2ValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OAuth2ValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OAuth2ValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OAuth2ValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OAuth2ValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OAuth2ValidationError) ErrorName() string { return "OAuth2ValidationError" }

// Error satisfies the builtin error interface
func (e OAuth2ValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOAuth2.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OAuth2ValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OAuth2ValidationError{}

// Validate checks the field values on OAuth2_ClientCredentials with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *OAuth2_ClientCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on OAuth2_ClientCredentials with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// OAuth2_ClientCredentialsMultiError, or nil if none found.
func (m *OAuth2_ClientCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *OAuth2_ClientCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetClientId()) < 1 {
		err := OAuth2_ClientCredentialsValidationError{
			field:  "ClientId",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetClientSecret() == nil {
		err := OAuth2_ClientCredentialsValidationError{
			field:  "ClientSecret",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetClientSecret()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OAuth2_ClientCredentialsValidationError{
					field:  "ClientSecret",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OAuth2_ClientCredentialsValidationError{
					field:  "ClientSecret",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetClientSecret()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OAuth2_ClientCredentialsValidationError{
				field:  "ClientSecret",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for AuthType

	if len(errors) > 0 {
		return OAuth2_ClientCredentialsMultiError(errors)
	}

	return nil
}

// OAuth2_ClientCredentialsMultiError is an error wrapping multiple validation
// errors returned by OAuth2_ClientCredentials.ValidateAll() if the designated
// constraints aren't met.
type OAuth2_ClientCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OAuth2_ClientCredentialsMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OAuth2_ClientCredentialsMultiError) AllErrors() []error { return m }

// OAuth2_ClientCredentialsValidationError is the validation error returned by
// OAuth2_ClientCredentials.Validate if the designated constraints aren't met.
type OAuth2_ClientCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OAuth2_ClientCredentialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OAuth2_ClientCredentialsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OAuth2_ClientCredentialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OAuth2_ClientCredentialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OAuth2_ClientCredentialsValidationError) ErrorName() string {
	return "OAuth2_ClientCredentialsValidationError"
}

// Error satisfies the builtin error interface
func (e OAuth2_ClientCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOAuth2_ClientCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OAuth2_ClientCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OAuth2_ClientCredentialsValidationError{}

// Validate checks the field values on OAuth2_EndpointParameter with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *OAuth2_EndpointParameter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on OAuth2_EndpointParameter with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// OAuth2_EndpointParameterMultiError, or nil if none found.
func (m *OAuth2_EndpointParameter) ValidateAll() error {
	return m.validate(true)
}

func (m *OAuth2_EndpointParameter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := OAuth2_EndpointParameterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Value

	if len(errors) > 0 {
		return OAuth2_EndpointParameterMultiError(errors)
	}

	return nil
}

// OAuth2_EndpointParameterMultiError is an error wrapping multiple validation
// errors returned by OAuth2_EndpointParameter.ValidateAll() if the designated
// constraints aren't met.
type OAuth2_EndpointParameterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OAuth2_EndpointParameterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OAuth2_EndpointParameterMultiError) AllErrors() []error { return m }

// OAuth2_EndpointParameterValidationError is the validation error returned by
// OAuth2_EndpointParameter.Validate if the designated constraints aren't met.
type OAuth2_EndpointParameterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OAuth2_EndpointParameterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OAuth2_EndpointParameterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OAuth2_EndpointParameterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OAuth2_EndpointParameterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OAuth2_EndpointParameterValidationError) ErrorName() string {
	return "OAuth2_EndpointParameterValidationError"
}

// Error satisfies the builtin error interface
func (e OAuth2_EndpointParameterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOAuth2_EndpointParameter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OAuth2_EndpointParameterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OAuth2_EndpointParameterValidationError{}
