// Copyright 2019 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: meta/v1alpha1/status.proto

// $title: Istio Status
// $description: Common status field for all istio collections.
// $location: https://istio.io/docs/reference/config/meta/v1beta1/istio-status.html

package v1alpha1

import (
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1alpha1 "istio.io/api/analysis/v1alpha1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type IstioStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Current service state of the resource.
	// More info: https://istio.io/docs/reference/config/config-status/
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*IstioCondition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// Includes any errors or warnings detected by Istio's analyzers.
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	ValidationMessages []*v1alpha1.AnalysisMessageBase `protobuf:"bytes,2,rep,name=validation_messages,json=validationMessages,proto3" json:"validation_messages,omitempty"`
	// $hide_from_docs
	// Deprecated. IstioCondition observed_generation will show the resource generation for which the condition was generated.
	// Resource Generation to which the Reconciled Condition refers.
	// When this value is not equal to the object's metadata generation, reconciled condition  calculation for the current
	// generation is still in progress.  See https://istio.io/latest/docs/reference/config/config-status/ for more info.
	// +optional
	// +protoc-gen-crd:validation:XIntOrString
	ObservedGeneration int64 `protobuf:"varint,3,opt,name=observed_generation,json=observedGeneration,proto3" json:"observed_generation,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *IstioStatus) Reset() {
	*x = IstioStatus{}
	mi := &file_meta_v1alpha1_status_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IstioStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstioStatus) ProtoMessage() {}

func (x *IstioStatus) ProtoReflect() protoreflect.Message {
	mi := &file_meta_v1alpha1_status_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstioStatus.ProtoReflect.Descriptor instead.
func (*IstioStatus) Descriptor() ([]byte, []int) {
	return file_meta_v1alpha1_status_proto_rawDescGZIP(), []int{0}
}

func (x *IstioStatus) GetConditions() []*IstioCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *IstioStatus) GetValidationMessages() []*v1alpha1.AnalysisMessageBase {
	if x != nil {
		return x.ValidationMessages
	}
	return nil
}

func (x *IstioStatus) GetObservedGeneration() int64 {
	if x != nil {
		return x.ObservedGeneration
	}
	return 0
}

type IstioCondition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type is the type of the condition.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Status is the status of the condition.
	// Can be True, False, Unknown.
	Status string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// Last time we probed the condition.
	// +optional
	LastProbeTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=last_probe_time,json=lastProbeTime,proto3" json:"last_probe_time,omitempty"`
	// Last time the condition transitioned from one status to another.
	// +optional
	LastTransitionTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=last_transition_time,json=lastTransitionTime,proto3" json:"last_transition_time,omitempty"`
	// Unique, one-word, CamelCase reason for the condition's last transition.
	// +optional
	Reason string `protobuf:"bytes,5,opt,name=reason,proto3" json:"reason,omitempty"`
	// Human-readable message indicating details about last transition.
	// +optional
	Message string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
	// Resource Generation to which the Condition refers.
	// +optional
	// +protoc-gen-crd:validation:XIntOrString
	ObservedGeneration int64 `protobuf:"varint,7,opt,name=observed_generation,json=observedGeneration,proto3" json:"observed_generation,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *IstioCondition) Reset() {
	*x = IstioCondition{}
	mi := &file_meta_v1alpha1_status_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IstioCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstioCondition) ProtoMessage() {}

func (x *IstioCondition) ProtoReflect() protoreflect.Message {
	mi := &file_meta_v1alpha1_status_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstioCondition.ProtoReflect.Descriptor instead.
func (*IstioCondition) Descriptor() ([]byte, []int) {
	return file_meta_v1alpha1_status_proto_rawDescGZIP(), []int{1}
}

func (x *IstioCondition) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *IstioCondition) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *IstioCondition) GetLastProbeTime() *timestamp.Timestamp {
	if x != nil {
		return x.LastProbeTime
	}
	return nil
}

func (x *IstioCondition) GetLastTransitionTime() *timestamp.Timestamp {
	if x != nil {
		return x.LastTransitionTime
	}
	return nil
}

func (x *IstioCondition) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *IstioCondition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *IstioCondition) GetObservedGeneration() int64 {
	if x != nil {
		return x.ObservedGeneration
	}
	return 0
}

var File_meta_v1alpha1_status_proto protoreflect.FileDescriptor

const file_meta_v1alpha1_status_proto_rawDesc = "" +
	"\n" +
	"\x1ameta/v1alpha1/status.proto\x12\x13istio.meta.v1alpha1\x1a\x1fanalysis/v1alpha1/message.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xe2\x01\n" +
	"\vIstioStatus\x12C\n" +
	"\n" +
	"conditions\x18\x01 \x03(\v2#.istio.meta.v1alpha1.IstioConditionR\n" +
	"conditions\x12]\n" +
	"\x13validation_messages\x18\x02 \x03(\v2,.istio.analysis.v1alpha1.AnalysisMessageBaseR\x12validationMessages\x12/\n" +
	"\x13observed_generation\x18\x03 \x01(\x03R\x12observedGeneration\"\xb1\x02\n" +
	"\x0eIstioCondition\x12\x12\n" +
	"\x04type\x18\x01 \x01(\tR\x04type\x12\x16\n" +
	"\x06status\x18\x02 \x01(\tR\x06status\x12B\n" +
	"\x0flast_probe_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\rlastProbeTime\x12L\n" +
	"\x14last_transition_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\x12lastTransitionTime\x12\x16\n" +
	"\x06reason\x18\x05 \x01(\tR\x06reason\x12\x18\n" +
	"\amessage\x18\x06 \x01(\tR\amessage\x12/\n" +
	"\x13observed_generation\x18\a \x01(\x03R\x12observedGenerationB\x1cZ\x1aistio.io/api/meta/v1alpha1b\x06proto3"

var (
	file_meta_v1alpha1_status_proto_rawDescOnce sync.Once
	file_meta_v1alpha1_status_proto_rawDescData []byte
)

func file_meta_v1alpha1_status_proto_rawDescGZIP() []byte {
	file_meta_v1alpha1_status_proto_rawDescOnce.Do(func() {
		file_meta_v1alpha1_status_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_meta_v1alpha1_status_proto_rawDesc), len(file_meta_v1alpha1_status_proto_rawDesc)))
	})
	return file_meta_v1alpha1_status_proto_rawDescData
}

var file_meta_v1alpha1_status_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_meta_v1alpha1_status_proto_goTypes = []any{
	(*IstioStatus)(nil),                  // 0: istio.meta.v1alpha1.IstioStatus
	(*IstioCondition)(nil),               // 1: istio.meta.v1alpha1.IstioCondition
	(*v1alpha1.AnalysisMessageBase)(nil), // 2: istio.analysis.v1alpha1.AnalysisMessageBase
	(*timestamp.Timestamp)(nil),          // 3: google.protobuf.Timestamp
}
var file_meta_v1alpha1_status_proto_depIdxs = []int32{
	1, // 0: istio.meta.v1alpha1.IstioStatus.conditions:type_name -> istio.meta.v1alpha1.IstioCondition
	2, // 1: istio.meta.v1alpha1.IstioStatus.validation_messages:type_name -> istio.analysis.v1alpha1.AnalysisMessageBase
	3, // 2: istio.meta.v1alpha1.IstioCondition.last_probe_time:type_name -> google.protobuf.Timestamp
	3, // 3: istio.meta.v1alpha1.IstioCondition.last_transition_time:type_name -> google.protobuf.Timestamp
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_meta_v1alpha1_status_proto_init() }
func file_meta_v1alpha1_status_proto_init() {
	if File_meta_v1alpha1_status_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_meta_v1alpha1_status_proto_rawDesc), len(file_meta_v1alpha1_status_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_meta_v1alpha1_status_proto_goTypes,
		DependencyIndexes: file_meta_v1alpha1_status_proto_depIdxs,
		MessageInfos:      file_meta_v1alpha1_status_proto_msgTypes,
	}.Build()
	File_meta_v1alpha1_status_proto = out.File
	file_meta_v1alpha1_status_proto_goTypes = nil
	file_meta_v1alpha1_status_proto_depIdxs = nil
}
