#ifndef SBK_KJOBWRAPPER_H
#define SBK_KJOBWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kjob.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KJobWrapper : public KJob
{
public:
    KJobWrapper(::QObject * parent = nullptr);
    KJobWrapper(const KJobWrapper &) = delete;
    KJobWrapper& operator=(const KJobWrapper &) = delete;
    KJobWrapper(KJobWrapper &&) = delete;
    KJobWrapper& operator=(KJobWrapper &&) = delete;
    ~KJobWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool doKill() override;
    bool doResume() override;
    bool doSuspend() override;
    ::QString errorString() const override;
    static ::QString sbk_o_errorString(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void start() override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 12> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KJOBWRAPPER_H
