
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kmacroexpanderbase_wrapper.h"

// Wrappers providing overrides
#include "kmacroexpanderbase_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qchar.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMacroExpanderBase_Type = nullptr;
static PyTypeObject *Sbk_KMacroExpanderBase_TypeF(void)
{
    return _Sbk_KMacroExpanderBase_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMacroExpanderBaseWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMacroExpanderBaseWrapper::KMacroExpanderBaseWrapper(::QChar c) : KMacroExpanderBase(c)
{
}

int KMacroExpanderBaseWrapper::expandEscapedMacro(const ::QString & str, int pos, ::QStringList & ret)
{
    static const char *funcName = "expandEscapedMacro";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMacroExpanderBase_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMacroExpanderBase::expandEscapedMacro(str, pos, ret);
    }
    return sbk_o_expandEscapedMacro("KMacroExpanderBase", funcName, gil, pyOverride, str, pos, ret);
}

int KMacroExpanderBaseWrapper::sbk_o_expandEscapedMacro(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & str, int pos, ::QStringList & ret)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &str),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &pos),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &ret)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiN)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &str),
        pos,
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &ret)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int KMacroExpanderBaseWrapper::expandPlainMacro(const ::QString & str, int pos, ::QStringList & ret)
{
    static const char *funcName = "expandPlainMacro";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMacroExpanderBase_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMacroExpanderBase::expandPlainMacro(str, pos, ret);
    }
    return KMacroExpanderBaseWrapper::sbk_o_expandEscapedMacro("KMacroExpanderBase", funcName, gil, pyOverride, str, pos, ret);
}

KMacroExpanderBaseWrapper::~KMacroExpanderBaseWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMacroExpanderBase_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMacroExpanderBase_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMacroExpanderBase >()))
        return -1;

    KMacroExpanderBaseWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);

    if (PyArg_ParseTuple(args, "|O:KMacroExpanderBase", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMacroExpanderBase::KMacroExpanderBase(QChar=)
    if (numArgs == 0) {
        overloadId = 0; // KMacroExpanderBase(QChar)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[0])))) {
        overloadId = 0; // KMacroExpanderBase(QChar)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);
            }
        }
        ::QChar cppArg0 = QLatin1Char('%');
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KMacroExpanderBase(QChar)
            cptr = new KMacroExpanderBaseWrapper(cppArg0);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMacroExpanderBase >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KMacroExpanderBaseFunc_escapeChar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMacroExpanderBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // escapeChar()const
        QChar cppResult = const_cast<const ::KMacroExpanderBase *>(cppSelf)->escapeChar();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMacroExpanderBaseFunc_expandEscapedMacro(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMacroExpanderBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "expandEscapedMacro", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMacroExpanderBase::expandEscapedMacro(QString,int,QStringList&)->int
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        overloadId = 0; // expandEscapedMacro(QString,int,QStringList&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "expandEscapedMacro", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // expandEscapedMacro(QString,int,QStringList&)
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMacroExpanderBase::expandEscapedMacro(cppArg0, cppArg1, cppArg2)
                : cppSelf->expandEscapedMacro(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMacroExpanderBaseFunc_expandMacros(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMacroExpanderBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMacroExpanderBase::expandMacros(QString&)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // expandMacros(QString&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "expandMacros", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // expandMacros(QString&)
            cppSelf->expandMacros(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMacroExpanderBaseFunc_expandMacrosShellQuote(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMacroExpanderBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "expandMacrosShellQuote", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMacroExpanderBase::expandMacrosShellQuote(QString&)->bool
    // 1: KMacroExpanderBase::expandMacrosShellQuote(QString&,int&)->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // expandMacrosShellQuote(QString&)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // expandMacrosShellQuote(QString&,int&)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "expandMacrosShellQuote", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // expandMacrosShellQuote(QString &str)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacrosShellQuote(QString&)
                bool cppResult = cppSelf->expandMacrosShellQuote(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // expandMacrosShellQuote(QString &str, int &pos)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacrosShellQuote(QString&,int&)
                bool cppResult = cppSelf->expandMacrosShellQuote(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMacroExpanderBaseFunc_expandPlainMacro(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMacroExpanderBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "expandPlainMacro", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMacroExpanderBase::expandPlainMacro(QString,int,QStringList&)->int
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        overloadId = 0; // expandPlainMacro(QString,int,QStringList&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "expandPlainMacro", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // expandPlainMacro(QString,int,QStringList&)
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMacroExpanderBase::expandPlainMacro(cppArg0, cppArg1, cppArg2)
                : cppSelf->expandPlainMacro(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMacroExpanderBaseFunc_setEscapeChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMacroExpanderBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMacroExpanderBase::setEscapeChar(QChar)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArg)))) {
        overloadId = 0; // setEscapeChar(QChar)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEscapeChar", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]);

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEscapeChar(QChar)
            cppSelf->setEscapeChar(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KMacroExpanderBase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMacroExpanderBase_methods[] = {
    {"escapeChar", reinterpret_cast<PyCFunction>(Sbk_KMacroExpanderBaseFunc_escapeChar), METH_NOARGS, nullptr},
    {"expandEscapedMacro", reinterpret_cast<PyCFunction>(Sbk_KMacroExpanderBaseFunc_expandEscapedMacro), METH_VARARGS, nullptr},
    {"expandMacros", reinterpret_cast<PyCFunction>(Sbk_KMacroExpanderBaseFunc_expandMacros), METH_O, nullptr},
    {"expandMacrosShellQuote", reinterpret_cast<PyCFunction>(Sbk_KMacroExpanderBaseFunc_expandMacrosShellQuote), METH_VARARGS, nullptr},
    {"expandPlainMacro", reinterpret_cast<PyCFunction>(Sbk_KMacroExpanderBaseFunc_expandPlainMacro), METH_VARARGS, nullptr},
    {"setEscapeChar", reinterpret_cast<PyCFunction>(Sbk_KMacroExpanderBaseFunc_setEscapeChar), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMacroExpanderBase_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMacroExpanderBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMacroExpanderBaseWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMacroExpanderBase_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMacroExpanderBase_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMacroExpanderBase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMacroExpanderBase_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMacroExpanderBase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMacroExpanderBase_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMacroExpanderBase_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMacroExpanderBase_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMacroExpanderBase_spec = {
    "1:KCoreAddons.KMacroExpanderBase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMacroExpanderBase_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMacroExpanderBase_PythonToCpp_KMacroExpanderBase_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMacroExpanderBase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMacroExpanderBase_PythonToCpp_KMacroExpanderBase_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMacroExpanderBase_TypeF()))
        return KMacroExpanderBase_PythonToCpp_KMacroExpanderBase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMacroExpanderBase_PTR_CppToPython_KMacroExpanderBase(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KMacroExpanderBase_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KMacroExpanderBase *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KMacroExpanderBase_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMacroExpanderBase_SignatureStrings[] = {
    "KCoreAddons.KMacroExpanderBase(self,c:QChar=QLatin1Char('%'))",
    "KCoreAddons.KMacroExpanderBase.escapeChar(self)->QChar",
    "KCoreAddons.KMacroExpanderBase.expandEscapedMacro(self,str:QString,pos:int,ret:QStringList)->int",
    "KCoreAddons.KMacroExpanderBase.expandMacros(self,str:QString)",
    "1:KCoreAddons.KMacroExpanderBase.expandMacrosShellQuote(self,str:QString)->bool",
    "0:KCoreAddons.KMacroExpanderBase.expandMacrosShellQuote(self,str:QString,pos:int)->bool",
    "KCoreAddons.KMacroExpanderBase.expandPlainMacro(self,str:QString,pos:int,ret:QStringList)->int",
    "KCoreAddons.KMacroExpanderBase.setEscapeChar(self,c:QChar)",
    nullptr}; // Sentinel
#else
static constexpr size_t KMacroExpanderBase_SignatureByteSize = 188;
static constexpr uint8_t KMacroExpanderBase_SignatureBytes[188] = {
    0x78, 0xda, 0xb5, 0x92, 0x51, 0x0b, 0x82, 0x30, 0x10, 0xc7, 0xdf, 0xf7, 0x3d, 0x42, 0x07, 0x2a,
    0xf9, 0x3a, 0x48, 0x28, 0xf1, 0x49, 0x83, 0x86, 0x9f, 0x60, 0xe9, 0x95, 0x83, 0xb1, 0xc9, 0x6e,
    0x41, 0x1f, 0x3f, 0x5d, 0xec, 0x21, 0x84, 0x32, 0xa8, 0xb7, 0xdb, 0x7f, 0xf7, 0xff, 0xdd, 0xed,
    0x76, 0x75, 0x69, 0x2c, 0xec, 0xfb, 0xde, 0x68, 0xcc, 0xea, 0xa3, 0xe8, 0xac, 0xa9, 0xee, 0xa3,
    0xd0, 0x3d, 0xd8, 0x83, 0x40, 0x88, 0x11, 0xd4, 0x25, 0xe9, 0x18, 0x2f, 0x07, 0x61, 0x77, 0xbc,
    0x11, 0x4e, 0xea, 0x7c, 0x8e, 0xe3, 0x68, 0x13, 0x51, 0x4a, 0xea, 0xb7, 0xee, 0x0c, 0xb0, 0x13,
    0x23, 0xf8, 0xfc, 0x19, 0x44, 0xd3, 0xc2, 0x83, 0x3e, 0xda, 0xfc, 0xa1, 0xf2, 0xe6, 0xde, 0x5f,
    0x3f, 0xfb, 0x40, 0x67, 0x19, 0x6f, 0x9d, 0x95, 0xfa, 0x9a, 0x8c, 0x06, 0x99, 0xd4, 0x2e, 0xb1,
    0xe0, 0x82, 0xd6, 0x48, 0x74, 0x53, 0x89, 0x49, 0x5d, 0x57, 0xc0, 0xeb, 0xb8, 0x40, 0x53, 0x92,
    0xb3, 0x2f, 0xfc, 0xed, 0x00, 0x4a, 0xf1, 0x9b, 0x71, 0xb0, 0x24, 0xa5, 0xc5, 0xd9, 0x18, 0x45,
    0xb6, 0x3f, 0xe2, 0x85, 0x47, 0x07, 0xee, 0x2a, 0xea, 0x49, 0x09, 0xa9, 0xff, 0x31, 0x44, 0x04,
    0x57, 0xbd, 0xfe, 0x6f, 0x58, 0x14, 0x4a, 0x1e, 0x4e, 0x71, 0xd9, 0xb5
};
#endif

PyTypeObject *init_KMacroExpanderBase(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX].type;

    Shiboken::AutoDecRef Sbk_KMacroExpanderBase_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KMacroExpanderBase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMacroExpanderBase",
        "KMacroExpanderBase*",
        &Sbk_KMacroExpanderBase_spec,
        &Shiboken::callCppDestructor< KMacroExpanderBase >,
        Sbk_KMacroExpanderBase_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KMacroExpanderBase_Type; // references _Sbk_KMacroExpanderBase_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMacroExpanderBase_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMacroExpanderBase_SignatureBytes, KMacroExpanderBase_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMacroExpanderBase_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMacroExpanderBase_PythonToCpp_KMacroExpanderBase_PTR,
        is_KMacroExpanderBase_PythonToCpp_KMacroExpanderBase_PTR_Convertible,
        KMacroExpanderBase_PTR_CppToPython_KMacroExpanderBase);

    Shiboken::Conversions::registerConverterName(converter, "KMacroExpanderBase");
    Shiboken::Conversions::registerConverterName(converter, "KMacroExpanderBase*");
    Shiboken::Conversions::registerConverterName(converter, "KMacroExpanderBase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMacroExpanderBase).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMacroExpanderBaseWrapper).name());

    qRegisterMetaType< ::KMacroExpanderBase *>();

    return pyType;
}
