#ifndef SBK_KDRAGWIDGETDECORATORBASEWRAPPER_H
#define SBK_KDRAGWIDGETDECORATORBASEWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kdragwidgetdecorator.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KDragWidgetDecoratorBaseWrapper : public KDragWidgetDecoratorBase
{
public:
    KDragWidgetDecoratorBaseWrapper(::QWidget * parent = nullptr);
    KDragWidgetDecoratorBaseWrapper(const KDragWidgetDecoratorBaseWrapper &) = delete;
    KDragWidgetDecoratorBaseWrapper& operator=(const KDragWidgetDecoratorBaseWrapper &) = delete;
    KDragWidgetDecoratorBaseWrapper(KDragWidgetDecoratorBaseWrapper &&) = delete;
    KDragWidgetDecoratorBaseWrapper& operator=(KDragWidgetDecoratorBaseWrapper &&) = delete;
    ~KDragWidgetDecoratorBaseWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    ::QDrag * dragObject() override;
    static ::QDrag * sbk_o_dragObject(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void startDrag() override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 9> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KDRAGWIDGETDECORATORBASEWRAPPER_H
