
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktoggleaction_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <kguiitem.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KToggleAction_Type = nullptr;
static PyTypeObject *Sbk_KToggleAction_TypeF(void)
{
    return _Sbk_KToggleAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KToggleActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KToggleActionWrapper::KToggleActionWrapper(::QObject * parent) : KToggleAction(parent)
{
}

KToggleActionWrapper::KToggleActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent) : KToggleAction(icon, text, parent)
{
}

KToggleActionWrapper::KToggleActionWrapper(const ::QString & text, ::QObject * parent) : KToggleAction(text, parent)
{
}

void KToggleActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KToggleAction", funcName, gil, pyOverride, event);
}

void KToggleActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToggleAction", funcName, gil, pyOverride, signal);
}

void KToggleActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KToggleAction", funcName, gil, pyOverride, event);
}

void KToggleActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToggleAction", funcName, gil, pyOverride, signal);
}

bool KToggleActionWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAction::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KToggleAction", funcName, gil, pyOverride, arg__1);
}

bool KToggleActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KToggleAction", funcName, gil, pyOverride, watched, event);
}

void KToggleActionWrapper::slotToggled(bool checked)
{
    static const char *funcName = "slotToggled";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToggleAction::slotToggled(checked);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KToggleAction", funcName, gil, pyOverride, checked);
}

void KToggleActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleAction_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KToggleAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KToggleActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KToggleAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KToggleActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KToggleAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KToggleActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KToggleActionWrapper *>(this));
    }
    return KToggleAction::qt_metacast(_clname);
}

KToggleActionWrapper::~KToggleActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KToggleAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KToggleAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KToggleAction >()))
        return -1;

    KToggleActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KToggleAction", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KToggleAction::KToggleAction(QObject*)
    // 1: KToggleAction::KToggleAction(QIcon,QString,QObject*)
    // 2: KToggleAction::KToggleAction(QString,QObject*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 1; // KToggleAction(QIcon,QString,QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KToggleAction(QObject*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 2; // KToggleAction(QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KToggleAction(QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KToggleAction(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KToggleActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KToggleActionWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KToggleAction(const QIcon &icon, const QString &text, QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KToggleAction(QIcon,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KToggleActionWrapper(*cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KToggleActionWrapper(*cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 2: // KToggleAction(const QString &text, QObject *parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KToggleAction(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KToggleActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KToggleActionWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KToggleAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KToggleActionFunc_setCheckedState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToggleAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KToggleAction::setCheckedState(KGuiItem)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArg)))) {
        overloadId = 0; // setCheckedState(KGuiItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCheckedState", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KGuiItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCheckedState(KGuiItem)
            cppSelf->setCheckedState(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KToggleActionFunc_slotToggled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToggleAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KToggleAction::slotToggled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // slotToggled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotToggled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotToggled(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToggleAction::slotToggled(cppArg0)
                : cppSelf->slotToggled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KToggleAction_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KToggleAction_methods[] = {
    {"setCheckedState", reinterpret_cast<PyCFunction>(Sbk_KToggleActionFunc_setCheckedState), METH_O, nullptr},
    {"slotToggled", reinterpret_cast<PyCFunction>(Sbk_KToggleActionFunc_slotToggled), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KToggleAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KToggleAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KToggleActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KToggleAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KToggleAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KToggleAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KToggleAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KToggleAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KToggleAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KToggleAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KToggleAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KToggleAction_spec = {
    "1:KWidgetsAddons.KToggleAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KToggleAction_slots
};

} //extern "C"

static void *Sbk_KToggleAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KToggleAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KToggleAction_PythonToCpp_KToggleAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KToggleAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KToggleAction_PythonToCpp_KToggleAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KToggleAction_TypeF()))
        return KToggleAction_PythonToCpp_KToggleAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KToggleAction_PTR_CppToPython_KToggleAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KToggleAction *>(const_cast<void *>(cppIn)), Sbk_KToggleAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KToggleAction_SignatureStrings[] = {
    "2:KWidgetsAddons.KToggleAction(self,parent:PySide6.QtCore.QObject)",
    "1:KWidgetsAddons.KToggleAction(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,parent:PySide6.QtCore.QObject)",
    "0:KWidgetsAddons.KToggleAction(self,text:QString,parent:PySide6.QtCore.QObject)",
    "KWidgetsAddons.KToggleAction.setCheckedState(self,checkedItem:KWidgetsAddons.KGuiItem)",
    "KWidgetsAddons.KToggleAction.slotToggled(self,checked:bool)",
    nullptr}; // Sentinel
#else
static constexpr size_t KToggleAction_SignatureByteSize = 180;
static constexpr uint8_t KToggleAction_SignatureBytes[180] = {
    0x78, 0xda, 0x95, 0xcf, 0xb1, 0x0a, 0xc2, 0x30, 0x14, 0x85, 0xe1, 0xbd, 0x4f, 0xe1, 0x68, 0xa1,
    0x04, 0x75, 0x70, 0xc8, 0x56, 0x3a, 0x48, 0xe9, 0x60, 0x43, 0x15, 0x07, 0x71, 0x68, 0x93, 0x6b,
    0x8c, 0xa6, 0x49, 0x69, 0xae, 0xd0, 0xbe, 0xbd, 0x91, 0x0e, 0xa2, 0x82, 0xad, 0xeb, 0xcf, 0xcd,
    0xc7, 0xc9, 0x8a, 0x66, 0x07, 0x25, 0x24, 0xa0, 0x8b, 0x85, 0xb0, 0xc6, 0x91, 0x6c, 0x67, 0xa5,
    0xd4, 0x10, 0x73, 0x54, 0xd6, 0xcc, 0x1d, 0xe8, 0x73, 0xd4, 0x94, 0x2d, 0x18, 0xa4, 0x79, 0x5f,
    0x28, 0x01, 0x6b, 0xc2, 0x30, 0xb1, 0x2d, 0x10, 0xb6, 0xad, 0xae, 0xc0, 0x31, 0x0c, 0x96, 0x13,
    0x08, 0xc5, 0xad, 0xa1, 0xd8, 0x37, 0xca, 0x48, 0xb2, 0x37, 0x3e, 0x1f, 0x5f, 0xda, 0xe6, 0xae,
    0x08, 0x4b, 0xfd, 0x41, 0x34, 0xfb, 0x88, 0xb9, 0xea, 0xea, 0xb2, 0x39, 0x45, 0x08, 0x1d, 0x52,
    0x56, 0x60, 0xeb, 0x9f, 0x8f, 0xad, 0x59, 0x4c, 0x58, 0xf3, 0x8f, 0xf7, 0x4b, 0x23, 0x0e, 0x30,
    0xb9, 0x00, 0xbf, 0x81, 0x28, 0xb0, 0x44, 0x18, 0x74, 0x3e, 0x94, 0x14, 0xa1, 0xfe, 0xda, 0xe2,
    0xbf, 0xf5, 0xec, 0x63, 0xac, 0xb6, 0x38, 0x04, 0xf1, 0x46, 0xd2, 0xca, 0x5a, 0x1d, 0x06, 0x0f,
    0x72, 0x01, 0x9e, 0x3f
};
#endif

PyTypeObject *init_KToggleAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KToggleAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]))));

    _Sbk_KToggleAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KToggleAction",
        "KToggleAction*",
        &Sbk_KToggleAction_spec,
        &Shiboken::callCppDestructor< KToggleAction >,
        Sbk_KToggleAction_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KToggleAction_Type; // references _Sbk_KToggleAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KToggleAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KToggleAction_SignatureBytes, KToggleAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KToggleAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KToggleAction_PythonToCpp_KToggleAction_PTR,
        is_KToggleAction_PythonToCpp_KToggleAction_PTR_Convertible,
        KToggleAction_PTR_CppToPython_KToggleAction);

    Shiboken::Conversions::registerConverterName(converter, "KToggleAction");
    Shiboken::Conversions::registerConverterName(converter, "KToggleAction*");
    Shiboken::Conversions::registerConverterName(converter, "KToggleAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KToggleAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KToggleActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KToggleAction_TypeF(), &Sbk_KToggleAction_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KToggleAction::staticMetaObject, sizeof(KToggleActionWrapper));

    return pyType;
}
