// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module func_table
//
// (impl) generated by ../mesa-25.3.2/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.3.2/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.3.2/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /build/lib32-mesa/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//

#include "VkEncoder.h"
#include "ResourceTracker.h"
#include "gfxstream_vk_entrypoints.h"
#include "gfxstream_vk_private.h"

#include "goldfish_vk_private_defs.h"

#include <cstring>

// Stuff we are not going to use but if included,
// will cause compile errors. These are Android Vulkan
// required extensions, but the approach will be to
// implement them completely on the guest side.
#undef VK_KHR_android_surface
#if defined(LINUX_GUEST_BUILD) || DETECT_OS_FUCHSIA || DETECT_OS_WINDOWS
#undef VK_ANDROID_native_buffer
#endif
#ifdef VK_VERSION_1_0
void gfxstream_vk_GetPhysicalDeviceFeatures(
    VkPhysicalDevice physicalDevice,
    VkPhysicalDeviceFeatures* pFeatures)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceFeatures");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceFeatures(gfxstream_physicalDevice->internal_object, pFeatures, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceFormatProperties(
    VkPhysicalDevice physicalDevice,
    VkFormat format,
    VkFormatProperties* pFormatProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceFormatProperties");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceFormatProperties(gfxstream_physicalDevice->internal_object, format, pFormatProperties, true /* do lock */);
    }
}
VkResult gfxstream_vk_GetPhysicalDeviceImageFormatProperties(
    VkPhysicalDevice physicalDevice,
    VkFormat format,
    VkImageType type,
    VkImageTiling tiling,
    VkImageUsageFlags usage,
    VkImageCreateFlags flags,
    VkImageFormatProperties* pImageFormatProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceImageFormatProperties");
    VkResult vkGetPhysicalDeviceImageFormatProperties_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetPhysicalDeviceImageFormatProperties_VkResult_return = vkEnc->vkGetPhysicalDeviceImageFormatProperties(gfxstream_physicalDevice->internal_object, format, type, tiling, usage, flags, pImageFormatProperties, true /* do lock */);
    }
    return vkGetPhysicalDeviceImageFormatProperties_VkResult_return;
}
void gfxstream_vk_GetPhysicalDeviceQueueFamilyProperties(
    VkPhysicalDevice physicalDevice,
    uint32_t* pQueueFamilyPropertyCount,
    VkQueueFamilyProperties* pQueueFamilyProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceQueueFamilyProperties");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceQueueFamilyProperties(gfxstream_physicalDevice->internal_object, pQueueFamilyPropertyCount, pQueueFamilyProperties, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceMemoryProperties(
    VkPhysicalDevice physicalDevice,
    VkPhysicalDeviceMemoryProperties* pMemoryProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceMemoryProperties");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceMemoryProperties(gfxstream_physicalDevice->internal_object, pMemoryProperties, true /* do lock */);
    }
}
VkResult gfxstream_vk_EnumerateDeviceLayerProperties(
    VkPhysicalDevice physicalDevice,
    uint32_t* pPropertyCount,
    VkLayerProperties* pProperties)
{
    MESA_TRACE_SCOPE("vkEnumerateDeviceLayerProperties");
    VkResult vkEnumerateDeviceLayerProperties_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnumerateDeviceLayerProperties_VkResult_return = vkEnc->vkEnumerateDeviceLayerProperties(gfxstream_physicalDevice->internal_object, pPropertyCount, pProperties, true /* do lock */);
    }
    return vkEnumerateDeviceLayerProperties_VkResult_return;
}
VkResult gfxstream_vk_QueueSubmit(
    VkQueue queue,
    uint32_t submitCount,
    const VkSubmitInfo* pSubmits,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkQueueSubmit");
    VkResult vkQueueSubmit_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkSubmitInfo> internal_pSubmits(submitCount);
        std::vector<std::vector<VkSemaphore>> internal_VkSubmitInfo_pWaitSemaphores;
        std::vector<std::vector<VkCommandBuffer>> internal_VkSubmitInfo_pCommandBuffers;
        std::vector<std::vector<VkSemaphore>> internal_VkSubmitInfo_pSignalSemaphores;
        for (uint32_t i = 0; i < submitCount; ++i)
        {
            internal_pSubmits[i] = pSubmits[i];
            /* VkSubmitInfo::pWaitSemaphores */
            internal_VkSubmitInfo_pWaitSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkSubmitInfo_pWaitSemaphores[i] = transformVkSemaphoreList(internal_pSubmits[i].pWaitSemaphores, internal_pSubmits[i].waitSemaphoreCount);
            internal_pSubmits[i].pWaitSemaphores = internal_VkSubmitInfo_pWaitSemaphores[i].data();
            internal_pSubmits[i].waitSemaphoreCount = internal_VkSubmitInfo_pWaitSemaphores[i].size();
            /* VkSubmitInfo::pCommandBuffers */
            internal_VkSubmitInfo_pCommandBuffers.push_back(std::vector<VkCommandBuffer>());
            internal_VkSubmitInfo_pCommandBuffers[i].resize(internal_pSubmits[i].commandBufferCount);
            for (uint32_t j = 0; j < internal_pSubmits[i].commandBufferCount; ++j)
            {
                VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_pCommandBuffers, internal_pSubmits[i].pCommandBuffers[j]);
                internal_VkSubmitInfo_pCommandBuffers[i][j] = gfxstream_pCommandBuffers->internal_object;
            }
            internal_pSubmits[i].pCommandBuffers = internal_VkSubmitInfo_pCommandBuffers[i].data();
            /* VkSubmitInfo::pSignalSemaphores */
            internal_VkSubmitInfo_pSignalSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkSubmitInfo_pSignalSemaphores[i] = transformVkSemaphoreList(internal_pSubmits[i].pSignalSemaphores, internal_pSubmits[i].signalSemaphoreCount);
            internal_pSubmits[i].pSignalSemaphores = internal_VkSubmitInfo_pSignalSemaphores[i].data();
            internal_pSubmits[i].signalSemaphoreCount = internal_VkSubmitInfo_pSignalSemaphores[i].size();
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkQueueSubmit_VkResult_return = resources->on_vkQueueSubmit(vkEnc, VK_SUCCESS, gfxstream_queue->internal_object, submitCount, internal_pSubmits.data(), gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE);
    }
    return vkQueueSubmit_VkResult_return;
}
VkResult gfxstream_vk_QueueWaitIdle(
    VkQueue queue)
{
    MESA_TRACE_SCOPE("vkQueueWaitIdle");
    VkResult vkQueueWaitIdle_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkQueueWaitIdle_VkResult_return = resources->on_vkQueueWaitIdle(vkEnc, VK_SUCCESS, gfxstream_queue->internal_object);
    }
    return vkQueueWaitIdle_VkResult_return;
}
VkResult gfxstream_vk_DeviceWaitIdle(
    VkDevice device)
{
    MESA_TRACE_SCOPE("vkDeviceWaitIdle");
    VkResult vkDeviceWaitIdle_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkDeviceWaitIdle_VkResult_return = vkEnc->vkDeviceWaitIdle(gfxstream_device->internal_object, true /* do lock */);
    }
    return vkDeviceWaitIdle_VkResult_return;
}
void gfxstream_vk_FreeMemory(
    VkDevice device,
    VkDeviceMemory memory,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkFreeMemory");
    if (VK_NULL_HANDLE == memory)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkFreeMemory(vkEnc, gfxstream_device->internal_object, memory, pAllocator);
    }
}
VkResult gfxstream_vk_MapMemory(
    VkDevice device,
    VkDeviceMemory memory,
    VkDeviceSize offset,
    VkDeviceSize size,
    VkMemoryMapFlags flags,
    void** ppData)
{
    MESA_TRACE_SCOPE("vkMapMemory");
    VkResult vkMapMemory_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkMapMemory_VkResult_return = vkEnc->vkMapMemory(gfxstream_device->internal_object, memory, offset, size, flags, ppData, true /* do lock */);
    }
    return vkMapMemory_VkResult_return;
}
void gfxstream_vk_UnmapMemory(
    VkDevice device,
    VkDeviceMemory memory)
{
    MESA_TRACE_SCOPE("vkUnmapMemory");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkUnmapMemory(gfxstream_device->internal_object, memory, true /* do lock */);
    }
}
VkResult gfxstream_vk_FlushMappedMemoryRanges(
    VkDevice device,
    uint32_t memoryRangeCount,
    const VkMappedMemoryRange* pMemoryRanges)
{
    MESA_TRACE_SCOPE("vkFlushMappedMemoryRanges");
    VkResult vkFlushMappedMemoryRanges_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkFlushMappedMemoryRanges_VkResult_return = vkEnc->vkFlushMappedMemoryRanges(gfxstream_device->internal_object, memoryRangeCount, pMemoryRanges, true /* do lock */);
    }
    return vkFlushMappedMemoryRanges_VkResult_return;
}
VkResult gfxstream_vk_InvalidateMappedMemoryRanges(
    VkDevice device,
    uint32_t memoryRangeCount,
    const VkMappedMemoryRange* pMemoryRanges)
{
    MESA_TRACE_SCOPE("vkInvalidateMappedMemoryRanges");
    VkResult vkInvalidateMappedMemoryRanges_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkInvalidateMappedMemoryRanges_VkResult_return = vkEnc->vkInvalidateMappedMemoryRanges(gfxstream_device->internal_object, memoryRangeCount, pMemoryRanges, true /* do lock */);
    }
    return vkInvalidateMappedMemoryRanges_VkResult_return;
}
void gfxstream_vk_GetDeviceMemoryCommitment(
    VkDevice device,
    VkDeviceMemory memory,
    VkDeviceSize* pCommittedMemoryInBytes)
{
    MESA_TRACE_SCOPE("vkGetDeviceMemoryCommitment");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceMemoryCommitment(gfxstream_device->internal_object, memory, pCommittedMemoryInBytes, true /* do lock */);
    }
}
VkResult gfxstream_vk_BindBufferMemory(
    VkDevice device,
    VkBuffer buffer,
    VkDeviceMemory memory,
    VkDeviceSize memoryOffset)
{
    MESA_TRACE_SCOPE("vkBindBufferMemory");
    VkResult vkBindBufferMemory_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkBindBufferMemory_VkResult_return = vkEnc->vkBindBufferMemory(gfxstream_device->internal_object, gfxstream_buffer->internal_object, memory, memoryOffset, true /* do lock */);
    }
    return vkBindBufferMemory_VkResult_return;
}
VkResult gfxstream_vk_BindImageMemory(
    VkDevice device,
    VkImage image,
    VkDeviceMemory memory,
    VkDeviceSize memoryOffset)
{
    MESA_TRACE_SCOPE("vkBindImageMemory");
    VkResult vkBindImageMemory_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkBindImageMemory_VkResult_return = resources->on_vkBindImageMemory(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, image, memory, memoryOffset);
    }
    return vkBindImageMemory_VkResult_return;
}
void gfxstream_vk_GetBufferMemoryRequirements(
    VkDevice device,
    VkBuffer buffer,
    VkMemoryRequirements* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetBufferMemoryRequirements");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkGetBufferMemoryRequirements(vkEnc, gfxstream_device->internal_object, gfxstream_buffer->internal_object, pMemoryRequirements);
    }
}
void gfxstream_vk_GetImageMemoryRequirements(
    VkDevice device,
    VkImage image,
    VkMemoryRequirements* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetImageMemoryRequirements");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkGetImageMemoryRequirements(vkEnc, gfxstream_device->internal_object, image, pMemoryRequirements);
    }
}
void gfxstream_vk_GetImageSparseMemoryRequirements(
    VkDevice device,
    VkImage image,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements* pSparseMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetImageSparseMemoryRequirements");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetImageSparseMemoryRequirements(gfxstream_device->internal_object, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceSparseImageFormatProperties(
    VkPhysicalDevice physicalDevice,
    VkFormat format,
    VkImageType type,
    VkSampleCountFlagBits samples,
    VkImageUsageFlags usage,
    VkImageTiling tiling,
    uint32_t* pPropertyCount,
    VkSparseImageFormatProperties* pProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceSparseImageFormatProperties");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceSparseImageFormatProperties(gfxstream_physicalDevice->internal_object, format, type, samples, usage, tiling, pPropertyCount, pProperties, true /* do lock */);
    }
}
VkResult gfxstream_vk_QueueBindSparse(
    VkQueue queue,
    uint32_t bindInfoCount,
    const VkBindSparseInfo* pBindInfo,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkQueueBindSparse");
    VkResult vkQueueBindSparse_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkBindSparseInfo> internal_pBindInfo(bindInfoCount);
        std::vector<std::vector<VkSemaphore>> internal_VkBindSparseInfo_pWaitSemaphores;
        std::vector<std::vector<VkSparseBufferMemoryBindInfo>> internal_VkBindSparseInfo_pBufferBinds;
        std::vector<std::vector<VkSemaphore>> internal_VkBindSparseInfo_pSignalSemaphores;
        for (uint32_t i = 0; i < bindInfoCount; ++i)
        {
            internal_pBindInfo[i] = pBindInfo[i];
            /* VkBindSparseInfo::pWaitSemaphores */
            internal_VkBindSparseInfo_pWaitSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkBindSparseInfo_pWaitSemaphores[i] = transformVkSemaphoreList(internal_pBindInfo[i].pWaitSemaphores, internal_pBindInfo[i].waitSemaphoreCount);
            internal_pBindInfo[i].pWaitSemaphores = internal_VkBindSparseInfo_pWaitSemaphores[i].data();
            internal_pBindInfo[i].waitSemaphoreCount = internal_VkBindSparseInfo_pWaitSemaphores[i].size();
            /* VkBindSparseInfo::pBufferBinds */
            internal_VkBindSparseInfo_pBufferBinds.push_back(std::vector<VkSparseBufferMemoryBindInfo>());
            internal_VkBindSparseInfo_pBufferBinds[i].resize(internal_pBindInfo[i].bufferBindCount);
            for (uint32_t j = 0; j < internal_pBindInfo[i].bufferBindCount; ++j)
            {
                internal_VkBindSparseInfo_pBufferBinds[i][j] = internal_pBindInfo[i].pBufferBinds[j];
                /* VkSparseBufferMemoryBindInfo::buffer */
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkBindSparseInfo_pBufferBinds[i][j].buffer);
                internal_VkBindSparseInfo_pBufferBinds[i][j].buffer = gfxstream_buffer->internal_object;
            }
            internal_pBindInfo[i].pBufferBinds = internal_VkBindSparseInfo_pBufferBinds[i].data();
            /* VkBindSparseInfo::pSignalSemaphores */
            internal_VkBindSparseInfo_pSignalSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkBindSparseInfo_pSignalSemaphores[i] = transformVkSemaphoreList(internal_pBindInfo[i].pSignalSemaphores, internal_pBindInfo[i].signalSemaphoreCount);
            internal_pBindInfo[i].pSignalSemaphores = internal_VkBindSparseInfo_pSignalSemaphores[i].data();
            internal_pBindInfo[i].signalSemaphoreCount = internal_VkBindSparseInfo_pSignalSemaphores[i].size();
        }
        vkQueueBindSparse_VkResult_return = vkEnc->vkQueueBindSparse(gfxstream_queue->internal_object, bindInfoCount, internal_pBindInfo.data(), gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE, true /* do lock */);
    }
    return vkQueueBindSparse_VkResult_return;
}
VkResult gfxstream_vk_CreateFence(
    VkDevice device,
    const VkFenceCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkFence* pFence)
{
    MESA_TRACE_SCOPE("vkCreateFence");
    VkResult vkCreateFence_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    struct gfxstream_vk_fence *gfxstream_pFence = (gfxstream_vk_fence *)vk_object_zalloc(&gfxstream_device->vk, pAllocator, sizeof(gfxstream_vk_fence), VK_OBJECT_TYPE_FENCE);
    vkCreateFence_VkResult_return = gfxstream_pFence ? VK_SUCCESS : VK_ERROR_OUT_OF_HOST_MEMORY;
    if (VK_SUCCESS == vkCreateFence_VkResult_return)
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateFence_VkResult_return = resources->on_vkCreateFence(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, &gfxstream_pFence->internal_object);
    }
    *pFence = gfxstream_vk_fence_to_handle(gfxstream_pFence);
    return vkCreateFence_VkResult_return;
}
void gfxstream_vk_DestroyFence(
    VkDevice device,
    VkFence fence,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyFence");
    if (VK_NULL_HANDLE == fence)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyFence(gfxstream_device->internal_object, gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE, pAllocator, true /* do lock */);
    }
    vk_object_free(&gfxstream_device->vk, pAllocator, (void *)gfxstream_fence);
}
VkResult gfxstream_vk_ResetFences(
    VkDevice device,
    uint32_t fenceCount,
    const VkFence* pFences)
{
    MESA_TRACE_SCOPE("vkResetFences");
    VkResult vkResetFences_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkFence> internal_pFences(fenceCount);
        internal_pFences = transformVkFenceList(pFences, fenceCount);
        pFences = internal_pFences.data();
        fenceCount = internal_pFences.size();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkResetFences_VkResult_return = resources->on_vkResetFences(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, fenceCount, internal_pFences.data());
    }
    return vkResetFences_VkResult_return;
}
VkResult gfxstream_vk_GetFenceStatus(
    VkDevice device,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkGetFenceStatus");
    VkResult vkGetFenceStatus_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetFenceStatus_VkResult_return = resources->on_vkGetFenceStatus(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, gfxstream_fence->internal_object);
    }
    return vkGetFenceStatus_VkResult_return;
}
VkResult gfxstream_vk_WaitForFences(
    VkDevice device,
    uint32_t fenceCount,
    const VkFence* pFences,
    VkBool32 waitAll,
    uint64_t timeout)
{
    MESA_TRACE_SCOPE("vkWaitForFences");
    VkResult vkWaitForFences_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkFence> internal_pFences(fenceCount);
        internal_pFences = transformVkFenceList(pFences, fenceCount);
        pFences = internal_pFences.data();
        fenceCount = internal_pFences.size();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkWaitForFences_VkResult_return = resources->on_vkWaitForFences(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, fenceCount, internal_pFences.data(), waitAll, timeout);
    }
    return vkWaitForFences_VkResult_return;
}
VkResult gfxstream_vk_CreateSemaphore(
    VkDevice device,
    const VkSemaphoreCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkSemaphore* pSemaphore)
{
    MESA_TRACE_SCOPE("vkCreateSemaphore");
    VkResult vkCreateSemaphore_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    struct gfxstream_vk_semaphore *gfxstream_pSemaphore = (gfxstream_vk_semaphore *)vk_object_zalloc(&gfxstream_device->vk, pAllocator, sizeof(gfxstream_vk_semaphore), VK_OBJECT_TYPE_SEMAPHORE);
    vkCreateSemaphore_VkResult_return = gfxstream_pSemaphore ? VK_SUCCESS : VK_ERROR_OUT_OF_HOST_MEMORY;
    if (VK_SUCCESS == vkCreateSemaphore_VkResult_return)
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateSemaphore_VkResult_return = resources->on_vkCreateSemaphore(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, &gfxstream_pSemaphore->internal_object);
    }
    *pSemaphore = gfxstream_vk_semaphore_to_handle(gfxstream_pSemaphore);
    return vkCreateSemaphore_VkResult_return;
}
void gfxstream_vk_DestroySemaphore(
    VkDevice device,
    VkSemaphore semaphore,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroySemaphore");
    if (VK_NULL_HANDLE == semaphore)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_semaphore, gfxstream_semaphore, semaphore);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkDestroySemaphore(vkEnc, gfxstream_device->internal_object, gfxstream_semaphore ? gfxstream_semaphore->internal_object : VK_NULL_HANDLE, pAllocator);
    }
    vk_object_free(&gfxstream_device->vk, pAllocator, (void *)gfxstream_semaphore);
}
VkResult gfxstream_vk_CreateEvent(
    VkDevice device,
    const VkEventCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkEvent* pEvent)
{
    MESA_TRACE_SCOPE("vkCreateEvent");
    VkResult vkCreateEvent_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateEvent_VkResult_return = vkEnc->vkCreateEvent(gfxstream_device->internal_object, pCreateInfo, pAllocator, pEvent, true /* do lock */);
    }
    return vkCreateEvent_VkResult_return;
}
void gfxstream_vk_DestroyEvent(
    VkDevice device,
    VkEvent event,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyEvent");
    if (VK_NULL_HANDLE == event)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyEvent(gfxstream_device->internal_object, event, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_GetEventStatus(
    VkDevice device,
    VkEvent event)
{
    MESA_TRACE_SCOPE("vkGetEventStatus");
    VkResult vkGetEventStatus_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetEventStatus_VkResult_return = vkEnc->vkGetEventStatus(gfxstream_device->internal_object, event, true /* do lock */);
    }
    return vkGetEventStatus_VkResult_return;
}
VkResult gfxstream_vk_SetEvent(
    VkDevice device,
    VkEvent event)
{
    MESA_TRACE_SCOPE("vkSetEvent");
    VkResult vkSetEvent_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkSetEvent_VkResult_return = vkEnc->vkSetEvent(gfxstream_device->internal_object, event, true /* do lock */);
    }
    return vkSetEvent_VkResult_return;
}
VkResult gfxstream_vk_ResetEvent(
    VkDevice device,
    VkEvent event)
{
    MESA_TRACE_SCOPE("vkResetEvent");
    VkResult vkResetEvent_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkResetEvent_VkResult_return = vkEnc->vkResetEvent(gfxstream_device->internal_object, event, true /* do lock */);
    }
    return vkResetEvent_VkResult_return;
}
VkResult gfxstream_vk_CreateQueryPool(
    VkDevice device,
    const VkQueryPoolCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkQueryPool* pQueryPool)
{
    MESA_TRACE_SCOPE("vkCreateQueryPool");
    VkResult vkCreateQueryPool_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateQueryPool_VkResult_return = vkEnc->vkCreateQueryPool(gfxstream_device->internal_object, pCreateInfo, pAllocator, pQueryPool, true /* do lock */);
    }
    return vkCreateQueryPool_VkResult_return;
}
void gfxstream_vk_DestroyQueryPool(
    VkDevice device,
    VkQueryPool queryPool,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyQueryPool");
    if (VK_NULL_HANDLE == queryPool)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyQueryPool(gfxstream_device->internal_object, queryPool, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_GetQueryPoolResults(
    VkDevice device,
    VkQueryPool queryPool,
    uint32_t firstQuery,
    uint32_t queryCount,
    size_t dataSize,
    void* pData,
    VkDeviceSize stride,
    VkQueryResultFlags flags)
{
    MESA_TRACE_SCOPE("vkGetQueryPoolResults");
    VkResult vkGetQueryPoolResults_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetQueryPoolResults_VkResult_return = vkEnc->vkGetQueryPoolResults(gfxstream_device->internal_object, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags, true /* do lock */);
    }
    return vkGetQueryPoolResults_VkResult_return;
}
VkResult gfxstream_vk_CreateBuffer(
    VkDevice device,
    const VkBufferCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkBuffer* pBuffer)
{
    MESA_TRACE_SCOPE("vkCreateBuffer");
    VkResult vkCreateBuffer_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    struct gfxstream_vk_buffer *gfxstream_pBuffer = (gfxstream_vk_buffer *)vk_object_zalloc(&gfxstream_device->vk, pAllocator, sizeof(gfxstream_vk_buffer), VK_OBJECT_TYPE_BUFFER);
    vkCreateBuffer_VkResult_return = gfxstream_pBuffer ? VK_SUCCESS : VK_ERROR_OUT_OF_HOST_MEMORY;
    if (VK_SUCCESS == vkCreateBuffer_VkResult_return)
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateBuffer_VkResult_return = resources->on_vkCreateBuffer(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, &gfxstream_pBuffer->internal_object);
    }
    *pBuffer = gfxstream_vk_buffer_to_handle(gfxstream_pBuffer);
    return vkCreateBuffer_VkResult_return;
}
void gfxstream_vk_DestroyBuffer(
    VkDevice device,
    VkBuffer buffer,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyBuffer");
    if (VK_NULL_HANDLE == buffer)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkDestroyBuffer(vkEnc, gfxstream_device->internal_object, gfxstream_buffer ? gfxstream_buffer->internal_object : VK_NULL_HANDLE, pAllocator);
    }
    vk_object_free(&gfxstream_device->vk, pAllocator, (void *)gfxstream_buffer);
}
VkResult gfxstream_vk_CreateBufferView(
    VkDevice device,
    const VkBufferViewCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkBufferView* pView)
{
    MESA_TRACE_SCOPE("vkCreateBufferView");
    VkResult vkCreateBufferView_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBufferViewCreateInfo> internal_pCreateInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pCreateInfo[i] = pCreateInfo[i];
            /* VkBufferViewCreateInfo::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pCreateInfo[i].buffer);
            internal_pCreateInfo[i].buffer = gfxstream_buffer->internal_object;
        }
        vkCreateBufferView_VkResult_return = vkEnc->vkCreateBufferView(gfxstream_device->internal_object, internal_pCreateInfo.data(), pAllocator, pView, true /* do lock */);
    }
    return vkCreateBufferView_VkResult_return;
}
void gfxstream_vk_DestroyBufferView(
    VkDevice device,
    VkBufferView bufferView,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyBufferView");
    if (VK_NULL_HANDLE == bufferView)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyBufferView(gfxstream_device->internal_object, bufferView, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateImage(
    VkDevice device,
    const VkImageCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkImage* pImage)
{
    MESA_TRACE_SCOPE("vkCreateImage");
    VkResult vkCreateImage_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateImage_VkResult_return = resources->on_vkCreateImage(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, pImage);
    }
    return vkCreateImage_VkResult_return;
}
void gfxstream_vk_DestroyImage(
    VkDevice device,
    VkImage image,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyImage");
    if (VK_NULL_HANDLE == image)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkDestroyImage(vkEnc, gfxstream_device->internal_object, image, pAllocator);
    }
}
void gfxstream_vk_GetImageSubresourceLayout(
    VkDevice device,
    VkImage image,
    const VkImageSubresource* pSubresource,
    VkSubresourceLayout* pLayout)
{
    MESA_TRACE_SCOPE("vkGetImageSubresourceLayout");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetImageSubresourceLayout(gfxstream_device->internal_object, image, pSubresource, pLayout, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateImageView(
    VkDevice device,
    const VkImageViewCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkImageView* pView)
{
    MESA_TRACE_SCOPE("vkCreateImageView");
    VkResult vkCreateImageView_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateImageView_VkResult_return = resources->on_vkCreateImageView(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, pView);
    }
    return vkCreateImageView_VkResult_return;
}
void gfxstream_vk_DestroyImageView(
    VkDevice device,
    VkImageView imageView,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyImageView");
    if (VK_NULL_HANDLE == imageView)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyImageView(gfxstream_device->internal_object, imageView, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateShaderModule(
    VkDevice device,
    const VkShaderModuleCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkShaderModule* pShaderModule)
{
    MESA_TRACE_SCOPE("vkCreateShaderModule");
    VkResult vkCreateShaderModule_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateShaderModule_VkResult_return = vkEnc->vkCreateShaderModule(gfxstream_device->internal_object, pCreateInfo, pAllocator, pShaderModule, true /* do lock */);
    }
    return vkCreateShaderModule_VkResult_return;
}
void gfxstream_vk_DestroyShaderModule(
    VkDevice device,
    VkShaderModule shaderModule,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyShaderModule");
    if (VK_NULL_HANDLE == shaderModule)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyShaderModule(gfxstream_device->internal_object, shaderModule, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreatePipelineCache(
    VkDevice device,
    const VkPipelineCacheCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkPipelineCache* pPipelineCache)
{
    MESA_TRACE_SCOPE("vkCreatePipelineCache");
    VkResult vkCreatePipelineCache_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreatePipelineCache_VkResult_return = vkEnc->vkCreatePipelineCache(gfxstream_device->internal_object, pCreateInfo, pAllocator, pPipelineCache, true /* do lock */);
    }
    return vkCreatePipelineCache_VkResult_return;
}
void gfxstream_vk_DestroyPipelineCache(
    VkDevice device,
    VkPipelineCache pipelineCache,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyPipelineCache");
    if (VK_NULL_HANDLE == pipelineCache)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyPipelineCache(gfxstream_device->internal_object, pipelineCache, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_GetPipelineCacheData(
    VkDevice device,
    VkPipelineCache pipelineCache,
    size_t* pDataSize,
    void* pData)
{
    MESA_TRACE_SCOPE("vkGetPipelineCacheData");
    VkResult vkGetPipelineCacheData_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetPipelineCacheData_VkResult_return = vkEnc->vkGetPipelineCacheData(gfxstream_device->internal_object, pipelineCache, pDataSize, pData, true /* do lock */);
    }
    return vkGetPipelineCacheData_VkResult_return;
}
VkResult gfxstream_vk_MergePipelineCaches(
    VkDevice device,
    VkPipelineCache dstCache,
    uint32_t srcCacheCount,
    const VkPipelineCache* pSrcCaches)
{
    MESA_TRACE_SCOPE("vkMergePipelineCaches");
    VkResult vkMergePipelineCaches_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkMergePipelineCaches_VkResult_return = vkEnc->vkMergePipelineCaches(gfxstream_device->internal_object, dstCache, srcCacheCount, pSrcCaches, true /* do lock */);
    }
    return vkMergePipelineCaches_VkResult_return;
}
VkResult gfxstream_vk_CreateGraphicsPipelines(
    VkDevice device,
    VkPipelineCache pipelineCache,
    uint32_t createInfoCount,
    const VkGraphicsPipelineCreateInfo* pCreateInfos,
    const VkAllocationCallbacks* pAllocator,
    VkPipeline* pPipelines)
{
    MESA_TRACE_SCOPE("vkCreateGraphicsPipelines");
    VkResult vkCreateGraphicsPipelines_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateGraphicsPipelines_VkResult_return = resources->on_vkCreateGraphicsPipelines(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    }
    return vkCreateGraphicsPipelines_VkResult_return;
}
VkResult gfxstream_vk_CreateComputePipelines(
    VkDevice device,
    VkPipelineCache pipelineCache,
    uint32_t createInfoCount,
    const VkComputePipelineCreateInfo* pCreateInfos,
    const VkAllocationCallbacks* pAllocator,
    VkPipeline* pPipelines)
{
    MESA_TRACE_SCOPE("vkCreateComputePipelines");
    VkResult vkCreateComputePipelines_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateComputePipelines_VkResult_return = vkEnc->vkCreateComputePipelines(gfxstream_device->internal_object, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, true /* do lock */);
    }
    return vkCreateComputePipelines_VkResult_return;
}
void gfxstream_vk_DestroyPipeline(
    VkDevice device,
    VkPipeline pipeline,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyPipeline");
    if (VK_NULL_HANDLE == pipeline)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyPipeline(gfxstream_device->internal_object, pipeline, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreatePipelineLayout(
    VkDevice device,
    const VkPipelineLayoutCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkPipelineLayout* pPipelineLayout)
{
    MESA_TRACE_SCOPE("vkCreatePipelineLayout");
    VkResult vkCreatePipelineLayout_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreatePipelineLayout_VkResult_return = vkEnc->vkCreatePipelineLayout(gfxstream_device->internal_object, pCreateInfo, pAllocator, pPipelineLayout, true /* do lock */);
    }
    return vkCreatePipelineLayout_VkResult_return;
}
void gfxstream_vk_DestroyPipelineLayout(
    VkDevice device,
    VkPipelineLayout pipelineLayout,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyPipelineLayout");
    if (VK_NULL_HANDLE == pipelineLayout)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyPipelineLayout(gfxstream_device->internal_object, pipelineLayout, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateSampler(
    VkDevice device,
    const VkSamplerCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkSampler* pSampler)
{
    MESA_TRACE_SCOPE("vkCreateSampler");
    VkResult vkCreateSampler_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateSampler_VkResult_return = resources->on_vkCreateSampler(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, pSampler);
    }
    return vkCreateSampler_VkResult_return;
}
void gfxstream_vk_DestroySampler(
    VkDevice device,
    VkSampler sampler,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroySampler");
    if (VK_NULL_HANDLE == sampler)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroySampler(gfxstream_device->internal_object, sampler, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateDescriptorSetLayout(
    VkDevice device,
    const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkDescriptorSetLayout* pSetLayout)
{
    MESA_TRACE_SCOPE("vkCreateDescriptorSetLayout");
    VkResult vkCreateDescriptorSetLayout_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateDescriptorSetLayout_VkResult_return = resources->on_vkCreateDescriptorSetLayout(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, pSetLayout);
    }
    return vkCreateDescriptorSetLayout_VkResult_return;
}
void gfxstream_vk_DestroyDescriptorSetLayout(
    VkDevice device,
    VkDescriptorSetLayout descriptorSetLayout,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyDescriptorSetLayout");
    if (VK_NULL_HANDLE == descriptorSetLayout)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkDestroyDescriptorSetLayout(vkEnc, gfxstream_device->internal_object, descriptorSetLayout, pAllocator);
    }
}
VkResult gfxstream_vk_CreateDescriptorPool(
    VkDevice device,
    const VkDescriptorPoolCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkDescriptorPool* pDescriptorPool)
{
    MESA_TRACE_SCOPE("vkCreateDescriptorPool");
    VkResult vkCreateDescriptorPool_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateDescriptorPool_VkResult_return = resources->on_vkCreateDescriptorPool(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, pDescriptorPool);
    }
    return vkCreateDescriptorPool_VkResult_return;
}
void gfxstream_vk_DestroyDescriptorPool(
    VkDevice device,
    VkDescriptorPool descriptorPool,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyDescriptorPool");
    if (VK_NULL_HANDLE == descriptorPool)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkDestroyDescriptorPool(vkEnc, gfxstream_device->internal_object, descriptorPool, pAllocator);
    }
}
VkResult gfxstream_vk_ResetDescriptorPool(
    VkDevice device,
    VkDescriptorPool descriptorPool,
    VkDescriptorPoolResetFlags flags)
{
    MESA_TRACE_SCOPE("vkResetDescriptorPool");
    VkResult vkResetDescriptorPool_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkResetDescriptorPool_VkResult_return = resources->on_vkResetDescriptorPool(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, descriptorPool, flags);
    }
    return vkResetDescriptorPool_VkResult_return;
}
VkResult gfxstream_vk_AllocateDescriptorSets(
    VkDevice device,
    const VkDescriptorSetAllocateInfo* pAllocateInfo,
    VkDescriptorSet* pDescriptorSets)
{
    MESA_TRACE_SCOPE("vkAllocateDescriptorSets");
    VkResult vkAllocateDescriptorSets_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkAllocateDescriptorSets_VkResult_return = resources->on_vkAllocateDescriptorSets(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pAllocateInfo, pDescriptorSets);
    }
    return vkAllocateDescriptorSets_VkResult_return;
}
VkResult gfxstream_vk_FreeDescriptorSets(
    VkDevice device,
    VkDescriptorPool descriptorPool,
    uint32_t descriptorSetCount,
    const VkDescriptorSet* pDescriptorSets)
{
    MESA_TRACE_SCOPE("vkFreeDescriptorSets");
    VkResult vkFreeDescriptorSets_VkResult_return = (VkResult)0;
    if (VK_NULL_HANDLE == pDescriptorSets)
    {
        return vkFreeDescriptorSets_VkResult_return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkFreeDescriptorSets_VkResult_return = resources->on_vkFreeDescriptorSets(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, descriptorPool, descriptorSetCount, pDescriptorSets);
    }
    return vkFreeDescriptorSets_VkResult_return;
}
VkResult gfxstream_vk_CreateFramebuffer(
    VkDevice device,
    const VkFramebufferCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkFramebuffer* pFramebuffer)
{
    MESA_TRACE_SCOPE("vkCreateFramebuffer");
    VkResult vkCreateFramebuffer_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateFramebuffer_VkResult_return = vkEnc->vkCreateFramebuffer(gfxstream_device->internal_object, pCreateInfo, pAllocator, pFramebuffer, true /* do lock */);
    }
    return vkCreateFramebuffer_VkResult_return;
}
void gfxstream_vk_DestroyFramebuffer(
    VkDevice device,
    VkFramebuffer framebuffer,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyFramebuffer");
    if (VK_NULL_HANDLE == framebuffer)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyFramebuffer(gfxstream_device->internal_object, framebuffer, pAllocator, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateRenderPass(
    VkDevice device,
    const VkRenderPassCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkRenderPass* pRenderPass)
{
    MESA_TRACE_SCOPE("vkCreateRenderPass");
    VkResult vkCreateRenderPass_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateRenderPass_VkResult_return = vkEnc->vkCreateRenderPass(gfxstream_device->internal_object, pCreateInfo, pAllocator, pRenderPass, true /* do lock */);
    }
    return vkCreateRenderPass_VkResult_return;
}
void gfxstream_vk_DestroyRenderPass(
    VkDevice device,
    VkRenderPass renderPass,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyRenderPass");
    if (VK_NULL_HANDLE == renderPass)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyRenderPass(gfxstream_device->internal_object, renderPass, pAllocator, true /* do lock */);
    }
}
void gfxstream_vk_GetRenderAreaGranularity(
    VkDevice device,
    VkRenderPass renderPass,
    VkExtent2D* pGranularity)
{
    MESA_TRACE_SCOPE("vkGetRenderAreaGranularity");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetRenderAreaGranularity(gfxstream_device->internal_object, renderPass, pGranularity, true /* do lock */);
    }
}
VkResult gfxstream_vk_BeginCommandBuffer(
    VkCommandBuffer commandBuffer,
    const VkCommandBufferBeginInfo* pBeginInfo)
{
    MESA_TRACE_SCOPE("vkBeginCommandBuffer");
    VkResult vkBeginCommandBuffer_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkBeginCommandBuffer_VkResult_return = resources->on_vkBeginCommandBuffer(vkEnc, VK_SUCCESS, gfxstream_commandBuffer->internal_object, pBeginInfo);
    }
    return vkBeginCommandBuffer_VkResult_return;
}
VkResult gfxstream_vk_EndCommandBuffer(
    VkCommandBuffer commandBuffer)
{
    MESA_TRACE_SCOPE("vkEndCommandBuffer");
    VkResult vkEndCommandBuffer_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkEndCommandBuffer_VkResult_return = resources->on_vkEndCommandBuffer(vkEnc, VK_SUCCESS, gfxstream_commandBuffer->internal_object);
    }
    return vkEndCommandBuffer_VkResult_return;
}
VkResult gfxstream_vk_ResetCommandBuffer(
    VkCommandBuffer commandBuffer,
    VkCommandBufferResetFlags flags)
{
    MESA_TRACE_SCOPE("vkResetCommandBuffer");
    VkResult vkResetCommandBuffer_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkResetCommandBuffer_VkResult_return = resources->on_vkResetCommandBuffer(vkEnc, VK_SUCCESS, gfxstream_commandBuffer->internal_object, flags);
    }
    return vkResetCommandBuffer_VkResult_return;
}
void gfxstream_vk_CmdBindPipeline(
    VkCommandBuffer commandBuffer,
    VkPipelineBindPoint pipelineBindPoint,
    VkPipeline pipeline)
{
    MESA_TRACE_SCOPE("vkCmdBindPipeline");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBindPipeline(gfxstream_commandBuffer->internal_object, pipelineBindPoint, pipeline, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetViewport(
    VkCommandBuffer commandBuffer,
    uint32_t firstViewport,
    uint32_t viewportCount,
    const VkViewport* pViewports)
{
    MESA_TRACE_SCOPE("vkCmdSetViewport");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetViewport(gfxstream_commandBuffer->internal_object, firstViewport, viewportCount, pViewports, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetScissor(
    VkCommandBuffer commandBuffer,
    uint32_t firstScissor,
    uint32_t scissorCount,
    const VkRect2D* pScissors)
{
    MESA_TRACE_SCOPE("vkCmdSetScissor");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetScissor(gfxstream_commandBuffer->internal_object, firstScissor, scissorCount, pScissors, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetLineWidth(
    VkCommandBuffer commandBuffer,
    float lineWidth)
{
    MESA_TRACE_SCOPE("vkCmdSetLineWidth");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetLineWidth(gfxstream_commandBuffer->internal_object, lineWidth, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthBias(
    VkCommandBuffer commandBuffer,
    float depthBiasConstantFactor,
    float depthBiasClamp,
    float depthBiasSlopeFactor)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthBias");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthBias(gfxstream_commandBuffer->internal_object, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetBlendConstants(
    VkCommandBuffer commandBuffer,
    const float blendConstants[4])
{
    MESA_TRACE_SCOPE("vkCmdSetBlendConstants");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetBlendConstants(gfxstream_commandBuffer->internal_object, blendConstants, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthBounds(
    VkCommandBuffer commandBuffer,
    float minDepthBounds,
    float maxDepthBounds)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthBounds");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthBounds(gfxstream_commandBuffer->internal_object, minDepthBounds, maxDepthBounds, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetStencilCompareMask(
    VkCommandBuffer commandBuffer,
    VkStencilFaceFlags faceMask,
    uint32_t compareMask)
{
    MESA_TRACE_SCOPE("vkCmdSetStencilCompareMask");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetStencilCompareMask(gfxstream_commandBuffer->internal_object, faceMask, compareMask, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetStencilWriteMask(
    VkCommandBuffer commandBuffer,
    VkStencilFaceFlags faceMask,
    uint32_t writeMask)
{
    MESA_TRACE_SCOPE("vkCmdSetStencilWriteMask");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetStencilWriteMask(gfxstream_commandBuffer->internal_object, faceMask, writeMask, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetStencilReference(
    VkCommandBuffer commandBuffer,
    VkStencilFaceFlags faceMask,
    uint32_t reference)
{
    MESA_TRACE_SCOPE("vkCmdSetStencilReference");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetStencilReference(gfxstream_commandBuffer->internal_object, faceMask, reference, true /* do lock */);
    }
}
void gfxstream_vk_CmdBindDescriptorSets(
    VkCommandBuffer commandBuffer,
    VkPipelineBindPoint pipelineBindPoint,
    VkPipelineLayout layout,
    uint32_t firstSet,
    uint32_t descriptorSetCount,
    const VkDescriptorSet* pDescriptorSets,
    uint32_t dynamicOffsetCount,
    const uint32_t* pDynamicOffsets)
{
    MESA_TRACE_SCOPE("vkCmdBindDescriptorSets");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkCmdBindDescriptorSets(vkEnc, gfxstream_commandBuffer->internal_object, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
    }
}
void gfxstream_vk_CmdBindIndexBuffer(
    VkCommandBuffer commandBuffer,
    VkBuffer buffer,
    VkDeviceSize offset,
    VkIndexType indexType)
{
    MESA_TRACE_SCOPE("vkCmdBindIndexBuffer");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBindIndexBuffer(gfxstream_commandBuffer->internal_object, gfxstream_buffer ? gfxstream_buffer->internal_object : VK_NULL_HANDLE, offset, indexType, true /* do lock */);
    }
}
void gfxstream_vk_CmdBindVertexBuffers(
    VkCommandBuffer commandBuffer,
    uint32_t firstBinding,
    uint32_t bindingCount,
    const VkBuffer* pBuffers,
    const VkDeviceSize* pOffsets)
{
    MESA_TRACE_SCOPE("vkCmdBindVertexBuffers");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkBuffer> internal_pBuffers(bindingCount);
        for (uint32_t i = 0; i < bindingCount; ++i)
        {
            if (pBuffers)
            {
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_pBuffers, pBuffers[i]);
                internal_pBuffers[i] = gfxstream_pBuffers->internal_object;
            }
        }
        vkEnc->vkCmdBindVertexBuffers(gfxstream_commandBuffer->internal_object, firstBinding, bindingCount, internal_pBuffers.data(), pOffsets, true /* do lock */);
    }
}
void gfxstream_vk_CmdDraw(
    VkCommandBuffer commandBuffer,
    uint32_t vertexCount,
    uint32_t instanceCount,
    uint32_t firstVertex,
    uint32_t firstInstance)
{
    MESA_TRACE_SCOPE("vkCmdDraw");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDraw(gfxstream_commandBuffer->internal_object, vertexCount, instanceCount, firstVertex, firstInstance, true /* do lock */);
    }
}
void gfxstream_vk_CmdDrawIndexed(
    VkCommandBuffer commandBuffer,
    uint32_t indexCount,
    uint32_t instanceCount,
    uint32_t firstIndex,
    int32_t vertexOffset,
    uint32_t firstInstance)
{
    MESA_TRACE_SCOPE("vkCmdDrawIndexed");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDrawIndexed(gfxstream_commandBuffer->internal_object, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance, true /* do lock */);
    }
}
void gfxstream_vk_CmdDrawIndirect(
    VkCommandBuffer commandBuffer,
    VkBuffer buffer,
    VkDeviceSize offset,
    uint32_t drawCount,
    uint32_t stride)
{
    MESA_TRACE_SCOPE("vkCmdDrawIndirect");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDrawIndirect(gfxstream_commandBuffer->internal_object, gfxstream_buffer->internal_object, offset, drawCount, stride, true /* do lock */);
    }
}
void gfxstream_vk_CmdDrawIndexedIndirect(
    VkCommandBuffer commandBuffer,
    VkBuffer buffer,
    VkDeviceSize offset,
    uint32_t drawCount,
    uint32_t stride)
{
    MESA_TRACE_SCOPE("vkCmdDrawIndexedIndirect");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDrawIndexedIndirect(gfxstream_commandBuffer->internal_object, gfxstream_buffer->internal_object, offset, drawCount, stride, true /* do lock */);
    }
}
void gfxstream_vk_CmdDispatch(
    VkCommandBuffer commandBuffer,
    uint32_t groupCountX,
    uint32_t groupCountY,
    uint32_t groupCountZ)
{
    MESA_TRACE_SCOPE("vkCmdDispatch");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDispatch(gfxstream_commandBuffer->internal_object, groupCountX, groupCountY, groupCountZ, true /* do lock */);
    }
}
void gfxstream_vk_CmdDispatchIndirect(
    VkCommandBuffer commandBuffer,
    VkBuffer buffer,
    VkDeviceSize offset)
{
    MESA_TRACE_SCOPE("vkCmdDispatchIndirect");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDispatchIndirect(gfxstream_commandBuffer->internal_object, gfxstream_buffer->internal_object, offset, true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyBuffer(
    VkCommandBuffer commandBuffer,
    VkBuffer srcBuffer,
    VkBuffer dstBuffer,
    uint32_t regionCount,
    const VkBufferCopy* pRegions)
{
    MESA_TRACE_SCOPE("vkCmdCopyBuffer");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_srcBuffer, srcBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, dstBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdCopyBuffer(gfxstream_commandBuffer->internal_object, gfxstream_srcBuffer->internal_object, gfxstream_dstBuffer->internal_object, regionCount, pRegions, true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyImage(
    VkCommandBuffer commandBuffer,
    VkImage srcImage,
    VkImageLayout srcImageLayout,
    VkImage dstImage,
    VkImageLayout dstImageLayout,
    uint32_t regionCount,
    const VkImageCopy* pRegions)
{
    MESA_TRACE_SCOPE("vkCmdCopyImage");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdCopyImage(gfxstream_commandBuffer->internal_object, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, true /* do lock */);
    }
}
void gfxstream_vk_CmdBlitImage(
    VkCommandBuffer commandBuffer,
    VkImage srcImage,
    VkImageLayout srcImageLayout,
    VkImage dstImage,
    VkImageLayout dstImageLayout,
    uint32_t regionCount,
    const VkImageBlit* pRegions,
    VkFilter filter)
{
    MESA_TRACE_SCOPE("vkCmdBlitImage");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBlitImage(gfxstream_commandBuffer->internal_object, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter, true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyBufferToImage(
    VkCommandBuffer commandBuffer,
    VkBuffer srcBuffer,
    VkImage dstImage,
    VkImageLayout dstImageLayout,
    uint32_t regionCount,
    const VkBufferImageCopy* pRegions)
{
    MESA_TRACE_SCOPE("vkCmdCopyBufferToImage");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_srcBuffer, srcBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdCopyBufferToImage(gfxstream_commandBuffer->internal_object, gfxstream_srcBuffer->internal_object, dstImage, dstImageLayout, regionCount, pRegions, true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyImageToBuffer(
    VkCommandBuffer commandBuffer,
    VkImage srcImage,
    VkImageLayout srcImageLayout,
    VkBuffer dstBuffer,
    uint32_t regionCount,
    const VkBufferImageCopy* pRegions)
{
    MESA_TRACE_SCOPE("vkCmdCopyImageToBuffer");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, dstBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdCopyImageToBuffer(gfxstream_commandBuffer->internal_object, srcImage, srcImageLayout, gfxstream_dstBuffer->internal_object, regionCount, pRegions, true /* do lock */);
    }
}
void gfxstream_vk_CmdUpdateBuffer(
    VkCommandBuffer commandBuffer,
    VkBuffer dstBuffer,
    VkDeviceSize dstOffset,
    VkDeviceSize dataSize,
    const void* pData)
{
    MESA_TRACE_SCOPE("vkCmdUpdateBuffer");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, dstBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdUpdateBuffer(gfxstream_commandBuffer->internal_object, gfxstream_dstBuffer->internal_object, dstOffset, dataSize, pData, true /* do lock */);
    }
}
void gfxstream_vk_CmdFillBuffer(
    VkCommandBuffer commandBuffer,
    VkBuffer dstBuffer,
    VkDeviceSize dstOffset,
    VkDeviceSize size,
    uint32_t data)
{
    MESA_TRACE_SCOPE("vkCmdFillBuffer");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, dstBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdFillBuffer(gfxstream_commandBuffer->internal_object, gfxstream_dstBuffer->internal_object, dstOffset, size, data, true /* do lock */);
    }
}
void gfxstream_vk_CmdClearColorImage(
    VkCommandBuffer commandBuffer,
    VkImage image,
    VkImageLayout imageLayout,
    const VkClearColorValue* pColor,
    uint32_t rangeCount,
    const VkImageSubresourceRange* pRanges)
{
    MESA_TRACE_SCOPE("vkCmdClearColorImage");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkCmdClearColorImage(vkEnc, gfxstream_commandBuffer->internal_object, image, imageLayout, pColor, rangeCount, pRanges);
    }
}
void gfxstream_vk_CmdClearDepthStencilImage(
    VkCommandBuffer commandBuffer,
    VkImage image,
    VkImageLayout imageLayout,
    const VkClearDepthStencilValue* pDepthStencil,
    uint32_t rangeCount,
    const VkImageSubresourceRange* pRanges)
{
    MESA_TRACE_SCOPE("vkCmdClearDepthStencilImage");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdClearDepthStencilImage(gfxstream_commandBuffer->internal_object, image, imageLayout, pDepthStencil, rangeCount, pRanges, true /* do lock */);
    }
}
void gfxstream_vk_CmdClearAttachments(
    VkCommandBuffer commandBuffer,
    uint32_t attachmentCount,
    const VkClearAttachment* pAttachments,
    uint32_t rectCount,
    const VkClearRect* pRects)
{
    MESA_TRACE_SCOPE("vkCmdClearAttachments");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdClearAttachments(gfxstream_commandBuffer->internal_object, attachmentCount, pAttachments, rectCount, pRects, true /* do lock */);
    }
}
void gfxstream_vk_CmdResolveImage(
    VkCommandBuffer commandBuffer,
    VkImage srcImage,
    VkImageLayout srcImageLayout,
    VkImage dstImage,
    VkImageLayout dstImageLayout,
    uint32_t regionCount,
    const VkImageResolve* pRegions)
{
    MESA_TRACE_SCOPE("vkCmdResolveImage");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdResolveImage(gfxstream_commandBuffer->internal_object, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetEvent(
    VkCommandBuffer commandBuffer,
    VkEvent event,
    VkPipelineStageFlags stageMask)
{
    MESA_TRACE_SCOPE("vkCmdSetEvent");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetEvent(gfxstream_commandBuffer->internal_object, event, stageMask, true /* do lock */);
    }
}
void gfxstream_vk_CmdResetEvent(
    VkCommandBuffer commandBuffer,
    VkEvent event,
    VkPipelineStageFlags stageMask)
{
    MESA_TRACE_SCOPE("vkCmdResetEvent");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdResetEvent(gfxstream_commandBuffer->internal_object, event, stageMask, true /* do lock */);
    }
}
void gfxstream_vk_CmdWaitEvents(
    VkCommandBuffer commandBuffer,
    uint32_t eventCount,
    const VkEvent* pEvents,
    VkPipelineStageFlags srcStageMask,
    VkPipelineStageFlags dstStageMask,
    uint32_t memoryBarrierCount,
    const VkMemoryBarrier* pMemoryBarriers,
    uint32_t bufferMemoryBarrierCount,
    const VkBufferMemoryBarrier* pBufferMemoryBarriers,
    uint32_t imageMemoryBarrierCount,
    const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    MESA_TRACE_SCOPE("vkCmdWaitEvents");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkBufferMemoryBarrier> internal_pBufferMemoryBarriers(bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; ++i)
        {
            internal_pBufferMemoryBarriers[i] = pBufferMemoryBarriers[i];
            /* VkBufferMemoryBarrier::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pBufferMemoryBarriers[i].buffer);
            internal_pBufferMemoryBarriers[i].buffer = gfxstream_buffer->internal_object;
        }
        vkEnc->vkCmdWaitEvents(gfxstream_commandBuffer->internal_object, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, internal_pBufferMemoryBarriers.data(), imageMemoryBarrierCount, pImageMemoryBarriers, true /* do lock */);
    }
}
void gfxstream_vk_CmdPipelineBarrier(
    VkCommandBuffer commandBuffer,
    VkPipelineStageFlags srcStageMask,
    VkPipelineStageFlags dstStageMask,
    VkDependencyFlags dependencyFlags,
    uint32_t memoryBarrierCount,
    const VkMemoryBarrier* pMemoryBarriers,
    uint32_t bufferMemoryBarrierCount,
    const VkBufferMemoryBarrier* pBufferMemoryBarriers,
    uint32_t imageMemoryBarrierCount,
    const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    MESA_TRACE_SCOPE("vkCmdPipelineBarrier");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkBufferMemoryBarrier> internal_pBufferMemoryBarriers(bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; ++i)
        {
            internal_pBufferMemoryBarriers[i] = pBufferMemoryBarriers[i];
            /* VkBufferMemoryBarrier::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pBufferMemoryBarriers[i].buffer);
            internal_pBufferMemoryBarriers[i].buffer = gfxstream_buffer->internal_object;
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkCmdPipelineBarrier(vkEnc, gfxstream_commandBuffer->internal_object, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, internal_pBufferMemoryBarriers.data(), imageMemoryBarrierCount, pImageMemoryBarriers);
    }
}
void gfxstream_vk_CmdBeginQuery(
    VkCommandBuffer commandBuffer,
    VkQueryPool queryPool,
    uint32_t query,
    VkQueryControlFlags flags)
{
    MESA_TRACE_SCOPE("vkCmdBeginQuery");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBeginQuery(gfxstream_commandBuffer->internal_object, queryPool, query, flags, true /* do lock */);
    }
}
void gfxstream_vk_CmdEndQuery(
    VkCommandBuffer commandBuffer,
    VkQueryPool queryPool,
    uint32_t query)
{
    MESA_TRACE_SCOPE("vkCmdEndQuery");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdEndQuery(gfxstream_commandBuffer->internal_object, queryPool, query, true /* do lock */);
    }
}
void gfxstream_vk_CmdResetQueryPool(
    VkCommandBuffer commandBuffer,
    VkQueryPool queryPool,
    uint32_t firstQuery,
    uint32_t queryCount)
{
    MESA_TRACE_SCOPE("vkCmdResetQueryPool");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdResetQueryPool(gfxstream_commandBuffer->internal_object, queryPool, firstQuery, queryCount, true /* do lock */);
    }
}
void gfxstream_vk_CmdWriteTimestamp(
    VkCommandBuffer commandBuffer,
    VkPipelineStageFlagBits pipelineStage,
    VkQueryPool queryPool,
    uint32_t query)
{
    MESA_TRACE_SCOPE("vkCmdWriteTimestamp");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdWriteTimestamp(gfxstream_commandBuffer->internal_object, pipelineStage, queryPool, query, true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyQueryPoolResults(
    VkCommandBuffer commandBuffer,
    VkQueryPool queryPool,
    uint32_t firstQuery,
    uint32_t queryCount,
    VkBuffer dstBuffer,
    VkDeviceSize dstOffset,
    VkDeviceSize stride,
    VkQueryResultFlags flags)
{
    MESA_TRACE_SCOPE("vkCmdCopyQueryPoolResults");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, dstBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdCopyQueryPoolResults(gfxstream_commandBuffer->internal_object, queryPool, firstQuery, queryCount, gfxstream_dstBuffer->internal_object, dstOffset, stride, flags, true /* do lock */);
    }
}
void gfxstream_vk_CmdPushConstants(
    VkCommandBuffer commandBuffer,
    VkPipelineLayout layout,
    VkShaderStageFlags stageFlags,
    uint32_t offset,
    uint32_t size,
    const void* pValues)
{
    MESA_TRACE_SCOPE("vkCmdPushConstants");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdPushConstants(gfxstream_commandBuffer->internal_object, layout, stageFlags, offset, size, pValues, true /* do lock */);
    }
}
void gfxstream_vk_CmdBeginRenderPass(
    VkCommandBuffer commandBuffer,
    const VkRenderPassBeginInfo* pRenderPassBegin,
    VkSubpassContents contents)
{
    MESA_TRACE_SCOPE("vkCmdBeginRenderPass");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBeginRenderPass(gfxstream_commandBuffer->internal_object, pRenderPassBegin, contents, true /* do lock */);
    }
}
void gfxstream_vk_CmdNextSubpass(
    VkCommandBuffer commandBuffer,
    VkSubpassContents contents)
{
    MESA_TRACE_SCOPE("vkCmdNextSubpass");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdNextSubpass(gfxstream_commandBuffer->internal_object, contents, true /* do lock */);
    }
}
void gfxstream_vk_CmdEndRenderPass(
    VkCommandBuffer commandBuffer)
{
    MESA_TRACE_SCOPE("vkCmdEndRenderPass");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdEndRenderPass(gfxstream_commandBuffer->internal_object, true /* do lock */);
    }
}
void gfxstream_vk_CmdExecuteCommands(
    VkCommandBuffer commandBuffer,
    uint32_t commandBufferCount,
    const VkCommandBuffer* pCommandBuffers)
{
    MESA_TRACE_SCOPE("vkCmdExecuteCommands");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkCommandBuffer> internal_pCommandBuffers(commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; ++i)
        {
            VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_pCommandBuffers, pCommandBuffers[i]);
            internal_pCommandBuffers[i] = gfxstream_pCommandBuffers->internal_object;
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkCmdExecuteCommands(vkEnc, gfxstream_commandBuffer->internal_object, commandBufferCount, internal_pCommandBuffers.data());
    }
}
#endif
#ifdef VK_VERSION_1_1
VkResult gfxstream_vk_BindBufferMemory2(
    VkDevice device,
    uint32_t bindInfoCount,
    const VkBindBufferMemoryInfo* pBindInfos)
{
    MESA_TRACE_SCOPE("vkBindBufferMemory2");
    VkResult vkBindBufferMemory2_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBindBufferMemoryInfo> internal_pBindInfos(bindInfoCount);
        for (uint32_t i = 0; i < bindInfoCount; ++i)
        {
            internal_pBindInfos[i] = pBindInfos[i];
            /* VkBindBufferMemoryInfo::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pBindInfos[i].buffer);
            internal_pBindInfos[i].buffer = gfxstream_buffer->internal_object;
        }
        vkBindBufferMemory2_VkResult_return = vkEnc->vkBindBufferMemory2(gfxstream_device->internal_object, bindInfoCount, internal_pBindInfos.data(), true /* do lock */);
    }
    return vkBindBufferMemory2_VkResult_return;
}
VkResult gfxstream_vk_BindImageMemory2(
    VkDevice device,
    uint32_t bindInfoCount,
    const VkBindImageMemoryInfo* pBindInfos)
{
    MESA_TRACE_SCOPE("vkBindImageMemory2");
    VkResult vkBindImageMemory2_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkBindImageMemory2_VkResult_return = resources->on_vkBindImageMemory2(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, bindInfoCount, pBindInfos);
    }
    return vkBindImageMemory2_VkResult_return;
}
void gfxstream_vk_GetDeviceGroupPeerMemoryFeatures(
    VkDevice device,
    uint32_t heapIndex,
    uint32_t localDeviceIndex,
    uint32_t remoteDeviceIndex,
    VkPeerMemoryFeatureFlags* pPeerMemoryFeatures)
{
    MESA_TRACE_SCOPE("vkGetDeviceGroupPeerMemoryFeatures");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceGroupPeerMemoryFeatures(gfxstream_device->internal_object, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDeviceMask(
    VkCommandBuffer commandBuffer,
    uint32_t deviceMask)
{
    MESA_TRACE_SCOPE("vkCmdSetDeviceMask");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDeviceMask(gfxstream_commandBuffer->internal_object, deviceMask, true /* do lock */);
    }
}
void gfxstream_vk_CmdDispatchBase(
    VkCommandBuffer commandBuffer,
    uint32_t baseGroupX,
    uint32_t baseGroupY,
    uint32_t baseGroupZ,
    uint32_t groupCountX,
    uint32_t groupCountY,
    uint32_t groupCountZ)
{
    MESA_TRACE_SCOPE("vkCmdDispatchBase");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDispatchBase(gfxstream_commandBuffer->internal_object, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ, true /* do lock */);
    }
}
void gfxstream_vk_GetImageMemoryRequirements2(
    VkDevice device,
    const VkImageMemoryRequirementsInfo2* pInfo,
    VkMemoryRequirements2* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetImageMemoryRequirements2");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkGetImageMemoryRequirements2(vkEnc, gfxstream_device->internal_object, pInfo, pMemoryRequirements);
    }
}
void gfxstream_vk_GetBufferMemoryRequirements2(
    VkDevice device,
    const VkBufferMemoryRequirementsInfo2* pInfo,
    VkMemoryRequirements2* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetBufferMemoryRequirements2");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBufferMemoryRequirementsInfo2> internal_pInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pInfo[i] = pInfo[i];
            /* VkBufferMemoryRequirementsInfo2::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pInfo[i].buffer);
            internal_pInfo[i].buffer = gfxstream_buffer->internal_object;
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkGetBufferMemoryRequirements2(vkEnc, gfxstream_device->internal_object, internal_pInfo.data(), pMemoryRequirements);
    }
}
void gfxstream_vk_GetImageSparseMemoryRequirements2(
    VkDevice device,
    const VkImageSparseMemoryRequirementsInfo2* pInfo,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetImageSparseMemoryRequirements2");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetImageSparseMemoryRequirements2(gfxstream_device->internal_object, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceFeatures2(
    VkPhysicalDevice physicalDevice,
    VkPhysicalDeviceFeatures2* pFeatures)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceFeatures2");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceFeatures2(gfxstream_physicalDevice->internal_object, pFeatures, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceProperties2(
    VkPhysicalDevice physicalDevice,
    VkPhysicalDeviceProperties2* pProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceProperties2");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceProperties2(gfxstream_physicalDevice->internal_object, pProperties, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceFormatProperties2(
    VkPhysicalDevice physicalDevice,
    VkFormat format,
    VkFormatProperties2* pFormatProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceFormatProperties2");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkGetPhysicalDeviceFormatProperties2(vkEnc, gfxstream_physicalDevice->internal_object, format, pFormatProperties);
    }
}
VkResult gfxstream_vk_GetPhysicalDeviceImageFormatProperties2(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
    VkImageFormatProperties2* pImageFormatProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceImageFormatProperties2");
    VkResult vkGetPhysicalDeviceImageFormatProperties2_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetPhysicalDeviceImageFormatProperties2_VkResult_return = resources->on_vkGetPhysicalDeviceImageFormatProperties2(vkEnc, VK_SUCCESS, gfxstream_physicalDevice->internal_object, pImageFormatInfo, pImageFormatProperties);
    }
    return vkGetPhysicalDeviceImageFormatProperties2_VkResult_return;
}
void gfxstream_vk_GetPhysicalDeviceQueueFamilyProperties2(
    VkPhysicalDevice physicalDevice,
    uint32_t* pQueueFamilyPropertyCount,
    VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceQueueFamilyProperties2");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceQueueFamilyProperties2(gfxstream_physicalDevice->internal_object, pQueueFamilyPropertyCount, pQueueFamilyProperties, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceMemoryProperties2(
    VkPhysicalDevice physicalDevice,
    VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceMemoryProperties2");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceMemoryProperties2(gfxstream_physicalDevice->internal_object, pMemoryProperties, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceSparseImageFormatProperties2(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
    uint32_t* pPropertyCount,
    VkSparseImageFormatProperties2* pProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceSparseImageFormatProperties2");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceSparseImageFormatProperties2(gfxstream_physicalDevice->internal_object, pFormatInfo, pPropertyCount, pProperties, true /* do lock */);
    }
}
void gfxstream_vk_TrimCommandPool(
    VkDevice device,
    VkCommandPool commandPool,
    VkCommandPoolTrimFlags flags)
{
    MESA_TRACE_SCOPE("vkTrimCommandPool");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_command_pool, gfxstream_commandPool, commandPool);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkTrimCommandPool(gfxstream_device->internal_object, gfxstream_commandPool->internal_object, flags, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateSamplerYcbcrConversion(
    VkDevice device,
    const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkSamplerYcbcrConversion* pYcbcrConversion)
{
    MESA_TRACE_SCOPE("vkCreateSamplerYcbcrConversion");
    VkResult vkCreateSamplerYcbcrConversion_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreateSamplerYcbcrConversion_VkResult_return = resources->on_vkCreateSamplerYcbcrConversion(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, pYcbcrConversion);
    }
    return vkCreateSamplerYcbcrConversion_VkResult_return;
}
void gfxstream_vk_DestroySamplerYcbcrConversion(
    VkDevice device,
    VkSamplerYcbcrConversion ycbcrConversion,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroySamplerYcbcrConversion");
    if (VK_NULL_HANDLE == ycbcrConversion)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkDestroySamplerYcbcrConversion(vkEnc, gfxstream_device->internal_object, ycbcrConversion, pAllocator);
    }
}
VkResult gfxstream_vk_CreateDescriptorUpdateTemplate(
    VkDevice device,
    const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate)
{
    MESA_TRACE_SCOPE("vkCreateDescriptorUpdateTemplate");
    VkResult vkCreateDescriptorUpdateTemplate_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateDescriptorUpdateTemplate_VkResult_return = vkEnc->vkCreateDescriptorUpdateTemplate(gfxstream_device->internal_object, pCreateInfo, pAllocator, pDescriptorUpdateTemplate, true /* do lock */);
    }
    return vkCreateDescriptorUpdateTemplate_VkResult_return;
}
void gfxstream_vk_DestroyDescriptorUpdateTemplate(
    VkDevice device,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyDescriptorUpdateTemplate");
    if (VK_NULL_HANDLE == descriptorUpdateTemplate)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyDescriptorUpdateTemplate(gfxstream_device->internal_object, descriptorUpdateTemplate, pAllocator, true /* do lock */);
    }
}
void gfxstream_vk_UpdateDescriptorSetWithTemplate(
    VkDevice device,
    VkDescriptorSet descriptorSet,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    const void* pData)
{
    MESA_TRACE_SCOPE("vkUpdateDescriptorSetWithTemplate");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkUpdateDescriptorSetWithTemplate(vkEnc, gfxstream_device->internal_object, descriptorSet, descriptorUpdateTemplate, pData);
    }
}
void gfxstream_vk_GetPhysicalDeviceExternalBufferProperties(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
    VkExternalBufferProperties* pExternalBufferProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceExternalBufferProperties");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkGetPhysicalDeviceExternalBufferProperties(vkEnc, gfxstream_physicalDevice->internal_object, pExternalBufferInfo, pExternalBufferProperties);
    }
}
void gfxstream_vk_GetPhysicalDeviceExternalFenceProperties(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
    VkExternalFenceProperties* pExternalFenceProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceExternalFenceProperties");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkGetPhysicalDeviceExternalFenceProperties(vkEnc, gfxstream_physicalDevice->internal_object, pExternalFenceInfo, pExternalFenceProperties);
    }
}
void gfxstream_vk_GetPhysicalDeviceExternalSemaphoreProperties(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceExternalSemaphoreProperties");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceExternalSemaphoreProperties(gfxstream_physicalDevice->internal_object, pExternalSemaphoreInfo, pExternalSemaphoreProperties, true /* do lock */);
    }
}
void gfxstream_vk_GetDescriptorSetLayoutSupport(
    VkDevice device,
    const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
    VkDescriptorSetLayoutSupport* pSupport)
{
    MESA_TRACE_SCOPE("vkGetDescriptorSetLayoutSupport");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDescriptorSetLayoutSupport(gfxstream_device->internal_object, pCreateInfo, pSupport, true /* do lock */);
    }
}
#endif
#ifdef VK_VERSION_1_2
void gfxstream_vk_CmdDrawIndirectCount(
    VkCommandBuffer commandBuffer,
    VkBuffer buffer,
    VkDeviceSize offset,
    VkBuffer countBuffer,
    VkDeviceSize countBufferOffset,
    uint32_t maxDrawCount,
    uint32_t stride)
{
    MESA_TRACE_SCOPE("vkCmdDrawIndirectCount");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_countBuffer, countBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDrawIndirectCount(gfxstream_commandBuffer->internal_object, gfxstream_buffer->internal_object, offset, gfxstream_countBuffer->internal_object, countBufferOffset, maxDrawCount, stride, true /* do lock */);
    }
}
void gfxstream_vk_CmdDrawIndexedIndirectCount(
    VkCommandBuffer commandBuffer,
    VkBuffer buffer,
    VkDeviceSize offset,
    VkBuffer countBuffer,
    VkDeviceSize countBufferOffset,
    uint32_t maxDrawCount,
    uint32_t stride)
{
    MESA_TRACE_SCOPE("vkCmdDrawIndexedIndirectCount");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_countBuffer, countBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDrawIndexedIndirectCount(gfxstream_commandBuffer->internal_object, gfxstream_buffer->internal_object, offset, gfxstream_countBuffer->internal_object, countBufferOffset, maxDrawCount, stride, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateRenderPass2(
    VkDevice device,
    const VkRenderPassCreateInfo2* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkRenderPass* pRenderPass)
{
    MESA_TRACE_SCOPE("vkCreateRenderPass2");
    VkResult vkCreateRenderPass2_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateRenderPass2_VkResult_return = vkEnc->vkCreateRenderPass2(gfxstream_device->internal_object, pCreateInfo, pAllocator, pRenderPass, true /* do lock */);
    }
    return vkCreateRenderPass2_VkResult_return;
}
void gfxstream_vk_CmdBeginRenderPass2(
    VkCommandBuffer commandBuffer,
    const VkRenderPassBeginInfo* pRenderPassBegin,
    const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    MESA_TRACE_SCOPE("vkCmdBeginRenderPass2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBeginRenderPass2(gfxstream_commandBuffer->internal_object, pRenderPassBegin, pSubpassBeginInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdNextSubpass2(
    VkCommandBuffer commandBuffer,
    const VkSubpassBeginInfo* pSubpassBeginInfo,
    const VkSubpassEndInfo* pSubpassEndInfo)
{
    MESA_TRACE_SCOPE("vkCmdNextSubpass2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdNextSubpass2(gfxstream_commandBuffer->internal_object, pSubpassBeginInfo, pSubpassEndInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdEndRenderPass2(
    VkCommandBuffer commandBuffer,
    const VkSubpassEndInfo* pSubpassEndInfo)
{
    MESA_TRACE_SCOPE("vkCmdEndRenderPass2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdEndRenderPass2(gfxstream_commandBuffer->internal_object, pSubpassEndInfo, true /* do lock */);
    }
}
void gfxstream_vk_ResetQueryPool(
    VkDevice device,
    VkQueryPool queryPool,
    uint32_t firstQuery,
    uint32_t queryCount)
{
    MESA_TRACE_SCOPE("vkResetQueryPool");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkResetQueryPool(gfxstream_device->internal_object, queryPool, firstQuery, queryCount, true /* do lock */);
    }
}
VkResult gfxstream_vk_GetSemaphoreCounterValue(
    VkDevice device,
    VkSemaphore semaphore,
    uint64_t* pValue)
{
    MESA_TRACE_SCOPE("vkGetSemaphoreCounterValue");
    VkResult vkGetSemaphoreCounterValue_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_semaphore, gfxstream_semaphore, semaphore);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetSemaphoreCounterValue_VkResult_return = vkEnc->vkGetSemaphoreCounterValue(gfxstream_device->internal_object, gfxstream_semaphore->internal_object, pValue, true /* do lock */);
    }
    return vkGetSemaphoreCounterValue_VkResult_return;
}
VkResult gfxstream_vk_WaitSemaphores(
    VkDevice device,
    const VkSemaphoreWaitInfo* pWaitInfo,
    uint64_t timeout)
{
    MESA_TRACE_SCOPE("vkWaitSemaphores");
    VkResult vkWaitSemaphores_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkSemaphoreWaitInfo> internal_pWaitInfo(1);
        std::vector<std::vector<VkSemaphore>> internal_VkSemaphoreWaitInfo_pSemaphores;
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pWaitInfo[i] = pWaitInfo[i];
            /* VkSemaphoreWaitInfo::pSemaphores */
            internal_VkSemaphoreWaitInfo_pSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkSemaphoreWaitInfo_pSemaphores[i] = transformVkSemaphoreList(internal_pWaitInfo[i].pSemaphores, internal_pWaitInfo[i].semaphoreCount);
            internal_pWaitInfo[i].pSemaphores = internal_VkSemaphoreWaitInfo_pSemaphores[i].data();
            internal_pWaitInfo[i].semaphoreCount = internal_VkSemaphoreWaitInfo_pSemaphores[i].size();
        }
        vkWaitSemaphores_VkResult_return = vkEnc->vkWaitSemaphores(gfxstream_device->internal_object, internal_pWaitInfo.data(), timeout, true /* do lock */);
    }
    return vkWaitSemaphores_VkResult_return;
}
VkResult gfxstream_vk_SignalSemaphore(
    VkDevice device,
    const VkSemaphoreSignalInfo* pSignalInfo)
{
    MESA_TRACE_SCOPE("vkSignalSemaphore");
    VkResult vkSignalSemaphore_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkSemaphoreSignalInfo> internal_pSignalInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pSignalInfo[i] = pSignalInfo[i];
            /* VkSemaphoreSignalInfo::semaphore */
            VK_FROM_HANDLE(gfxstream_vk_semaphore, gfxstream_semaphore, internal_pSignalInfo[i].semaphore);
            internal_pSignalInfo[i].semaphore = gfxstream_semaphore->internal_object;
        }
        vkSignalSemaphore_VkResult_return = vkEnc->vkSignalSemaphore(gfxstream_device->internal_object, internal_pSignalInfo.data(), true /* do lock */);
    }
    return vkSignalSemaphore_VkResult_return;
}
VkDeviceAddress gfxstream_vk_GetBufferDeviceAddress(
    VkDevice device,
    const VkBufferDeviceAddressInfo* pInfo)
{
    MESA_TRACE_SCOPE("vkGetBufferDeviceAddress");
    VkDeviceAddress vkGetBufferDeviceAddress_VkDeviceAddress_return = (VkDeviceAddress)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBufferDeviceAddressInfo> internal_pInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pInfo[i] = pInfo[i];
            /* VkBufferDeviceAddressInfo::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pInfo[i].buffer);
            internal_pInfo[i].buffer = gfxstream_buffer->internal_object;
        }
        vkGetBufferDeviceAddress_VkDeviceAddress_return = vkEnc->vkGetBufferDeviceAddress(gfxstream_device->internal_object, internal_pInfo.data(), true /* do lock */);
    }
    return vkGetBufferDeviceAddress_VkDeviceAddress_return;
}
uint64_t gfxstream_vk_GetBufferOpaqueCaptureAddress(
    VkDevice device,
    const VkBufferDeviceAddressInfo* pInfo)
{
    MESA_TRACE_SCOPE("vkGetBufferOpaqueCaptureAddress");
    uint64_t vkGetBufferOpaqueCaptureAddress_uint64_t_return = (uint64_t)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBufferDeviceAddressInfo> internal_pInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pInfo[i] = pInfo[i];
            /* VkBufferDeviceAddressInfo::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pInfo[i].buffer);
            internal_pInfo[i].buffer = gfxstream_buffer->internal_object;
        }
        vkGetBufferOpaqueCaptureAddress_uint64_t_return = vkEnc->vkGetBufferOpaqueCaptureAddress(gfxstream_device->internal_object, internal_pInfo.data(), true /* do lock */);
    }
    return vkGetBufferOpaqueCaptureAddress_uint64_t_return;
}
uint64_t gfxstream_vk_GetDeviceMemoryOpaqueCaptureAddress(
    VkDevice device,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    MESA_TRACE_SCOPE("vkGetDeviceMemoryOpaqueCaptureAddress");
    uint64_t vkGetDeviceMemoryOpaqueCaptureAddress_uint64_t_return = (uint64_t)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetDeviceMemoryOpaqueCaptureAddress_uint64_t_return = vkEnc->vkGetDeviceMemoryOpaqueCaptureAddress(gfxstream_device->internal_object, pInfo, true /* do lock */);
    }
    return vkGetDeviceMemoryOpaqueCaptureAddress_uint64_t_return;
}
#endif
#ifdef VK_VERSION_1_3
VkResult gfxstream_vk_GetPhysicalDeviceToolProperties(
    VkPhysicalDevice physicalDevice,
    uint32_t* pToolCount,
    VkPhysicalDeviceToolProperties* pToolProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceToolProperties");
    VkResult vkGetPhysicalDeviceToolProperties_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetPhysicalDeviceToolProperties_VkResult_return = vkEnc->vkGetPhysicalDeviceToolProperties(gfxstream_physicalDevice->internal_object, pToolCount, pToolProperties, true /* do lock */);
    }
    return vkGetPhysicalDeviceToolProperties_VkResult_return;
}
VkResult gfxstream_vk_CreatePrivateDataSlot(
    VkDevice device,
    const VkPrivateDataSlotCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkPrivateDataSlot* pPrivateDataSlot)
{
    MESA_TRACE_SCOPE("vkCreatePrivateDataSlot");
    VkResult vkCreatePrivateDataSlot_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreatePrivateDataSlot_VkResult_return = resources->on_vkCreatePrivateDataSlot(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, pPrivateDataSlot);
    }
    return vkCreatePrivateDataSlot_VkResult_return;
}
void gfxstream_vk_DestroyPrivateDataSlot(
    VkDevice device,
    VkPrivateDataSlot privateDataSlot,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyPrivateDataSlot");
    if (VK_NULL_HANDLE == privateDataSlot)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkDestroyPrivateDataSlot(vkEnc, gfxstream_device->internal_object, privateDataSlot, pAllocator);
    }
}
VkResult gfxstream_vk_SetPrivateData(
    VkDevice device,
    VkObjectType objectType,
    uint64_t objectHandle,
    VkPrivateDataSlot privateDataSlot,
    uint64_t data)
{
    MESA_TRACE_SCOPE("vkSetPrivateData");
    VkResult vkSetPrivateData_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkSetPrivateData_VkResult_return = resources->on_vkSetPrivateData(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, objectType, objectHandle, privateDataSlot, data);
    }
    return vkSetPrivateData_VkResult_return;
}
void gfxstream_vk_GetPrivateData(
    VkDevice device,
    VkObjectType objectType,
    uint64_t objectHandle,
    VkPrivateDataSlot privateDataSlot,
    uint64_t* pData)
{
    MESA_TRACE_SCOPE("vkGetPrivateData");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkGetPrivateData(vkEnc, gfxstream_device->internal_object, objectType, objectHandle, privateDataSlot, pData);
    }
}
void gfxstream_vk_CmdSetEvent2(
    VkCommandBuffer commandBuffer,
    VkEvent event,
    const VkDependencyInfo* pDependencyInfo)
{
    MESA_TRACE_SCOPE("vkCmdSetEvent2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkDependencyInfo> internal_pDependencyInfo(1);
        std::vector<std::vector<VkBufferMemoryBarrier2>> internal_VkDependencyInfo_pBufferMemoryBarriers;
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pDependencyInfo[i] = pDependencyInfo[i];
            /* VkDependencyInfo::pBufferMemoryBarriers */
            internal_VkDependencyInfo_pBufferMemoryBarriers.push_back(std::vector<VkBufferMemoryBarrier2>());
            internal_VkDependencyInfo_pBufferMemoryBarriers[i].resize(internal_pDependencyInfo[i].bufferMemoryBarrierCount);
            for (uint32_t j = 0; j < internal_pDependencyInfo[i].bufferMemoryBarrierCount; ++j)
            {
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j] = internal_pDependencyInfo[i].pBufferMemoryBarriers[j];
                /* VkBufferMemoryBarrier2::buffer */
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer);
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer = gfxstream_buffer->internal_object;
            }
            internal_pDependencyInfo[i].pBufferMemoryBarriers = internal_VkDependencyInfo_pBufferMemoryBarriers[i].data();
        }
        vkEnc->vkCmdSetEvent2(gfxstream_commandBuffer->internal_object, event, internal_pDependencyInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdResetEvent2(
    VkCommandBuffer commandBuffer,
    VkEvent event,
    VkPipelineStageFlags2 stageMask)
{
    MESA_TRACE_SCOPE("vkCmdResetEvent2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdResetEvent2(gfxstream_commandBuffer->internal_object, event, stageMask, true /* do lock */);
    }
}
void gfxstream_vk_CmdWaitEvents2(
    VkCommandBuffer commandBuffer,
    uint32_t eventCount,
    const VkEvent* pEvents,
    const VkDependencyInfo* pDependencyInfos)
{
    MESA_TRACE_SCOPE("vkCmdWaitEvents2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkDependencyInfo> internal_pDependencyInfos(eventCount);
        std::vector<std::vector<VkBufferMemoryBarrier2>> internal_VkDependencyInfo_pBufferMemoryBarriers;
        for (uint32_t i = 0; i < eventCount; ++i)
        {
            internal_pDependencyInfos[i] = pDependencyInfos[i];
            /* VkDependencyInfo::pBufferMemoryBarriers */
            internal_VkDependencyInfo_pBufferMemoryBarriers.push_back(std::vector<VkBufferMemoryBarrier2>());
            internal_VkDependencyInfo_pBufferMemoryBarriers[i].resize(internal_pDependencyInfos[i].bufferMemoryBarrierCount);
            for (uint32_t j = 0; j < internal_pDependencyInfos[i].bufferMemoryBarrierCount; ++j)
            {
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j] = internal_pDependencyInfos[i].pBufferMemoryBarriers[j];
                /* VkBufferMemoryBarrier2::buffer */
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer);
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer = gfxstream_buffer->internal_object;
            }
            internal_pDependencyInfos[i].pBufferMemoryBarriers = internal_VkDependencyInfo_pBufferMemoryBarriers[i].data();
        }
        vkEnc->vkCmdWaitEvents2(gfxstream_commandBuffer->internal_object, eventCount, pEvents, internal_pDependencyInfos.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdPipelineBarrier2(
    VkCommandBuffer commandBuffer,
    const VkDependencyInfo* pDependencyInfo)
{
    MESA_TRACE_SCOPE("vkCmdPipelineBarrier2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkDependencyInfo> internal_pDependencyInfo(1);
        std::vector<std::vector<VkBufferMemoryBarrier2>> internal_VkDependencyInfo_pBufferMemoryBarriers;
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pDependencyInfo[i] = pDependencyInfo[i];
            /* VkDependencyInfo::pBufferMemoryBarriers */
            internal_VkDependencyInfo_pBufferMemoryBarriers.push_back(std::vector<VkBufferMemoryBarrier2>());
            internal_VkDependencyInfo_pBufferMemoryBarriers[i].resize(internal_pDependencyInfo[i].bufferMemoryBarrierCount);
            for (uint32_t j = 0; j < internal_pDependencyInfo[i].bufferMemoryBarrierCount; ++j)
            {
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j] = internal_pDependencyInfo[i].pBufferMemoryBarriers[j];
                /* VkBufferMemoryBarrier2::buffer */
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer);
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer = gfxstream_buffer->internal_object;
            }
            internal_pDependencyInfo[i].pBufferMemoryBarriers = internal_VkDependencyInfo_pBufferMemoryBarriers[i].data();
        }
        vkEnc->vkCmdPipelineBarrier2(gfxstream_commandBuffer->internal_object, internal_pDependencyInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdWriteTimestamp2(
    VkCommandBuffer commandBuffer,
    VkPipelineStageFlags2 stage,
    VkQueryPool queryPool,
    uint32_t query)
{
    MESA_TRACE_SCOPE("vkCmdWriteTimestamp2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdWriteTimestamp2(gfxstream_commandBuffer->internal_object, stage, queryPool, query, true /* do lock */);
    }
}
VkResult gfxstream_vk_QueueSubmit2(
    VkQueue queue,
    uint32_t submitCount,
    const VkSubmitInfo2* pSubmits,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkQueueSubmit2");
    VkResult vkQueueSubmit2_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkSubmitInfo2> internal_pSubmits(submitCount);
        std::vector<std::vector<VkSemaphoreSubmitInfo>> internal_VkSubmitInfo2_pWaitSemaphoreInfos;
        std::vector<std::vector<VkCommandBufferSubmitInfo>> internal_VkSubmitInfo2_pCommandBufferInfos;
        std::vector<std::vector<VkSemaphoreSubmitInfo>> internal_VkSubmitInfo2_pSignalSemaphoreInfos;
        for (uint32_t i = 0; i < submitCount; ++i)
        {
            internal_pSubmits[i] = pSubmits[i];
            /* VkSubmitInfo2::pWaitSemaphoreInfos */
            internal_VkSubmitInfo2_pWaitSemaphoreInfos.push_back(std::vector<VkSemaphoreSubmitInfo>());
            internal_VkSubmitInfo2_pWaitSemaphoreInfos[i] = transformVkSemaphoreSubmitInfoList(internal_pSubmits[i].pWaitSemaphoreInfos, internal_pSubmits[i].waitSemaphoreInfoCount);
            internal_pSubmits[i].pWaitSemaphoreInfos = internal_VkSubmitInfo2_pWaitSemaphoreInfos[i].data();
            internal_pSubmits[i].waitSemaphoreInfoCount = internal_VkSubmitInfo2_pWaitSemaphoreInfos[i].size();
            /* VkSubmitInfo2::pCommandBufferInfos */
            internal_VkSubmitInfo2_pCommandBufferInfos.push_back(std::vector<VkCommandBufferSubmitInfo>());
            internal_VkSubmitInfo2_pCommandBufferInfos[i].resize(internal_pSubmits[i].commandBufferInfoCount);
            for (uint32_t j = 0; j < internal_pSubmits[i].commandBufferInfoCount; ++j)
            {
                internal_VkSubmitInfo2_pCommandBufferInfos[i][j] = internal_pSubmits[i].pCommandBufferInfos[j];
                /* VkCommandBufferSubmitInfo::commandBuffer */
                VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, internal_VkSubmitInfo2_pCommandBufferInfos[i][j].commandBuffer);
                internal_VkSubmitInfo2_pCommandBufferInfos[i][j].commandBuffer = gfxstream_commandBuffer->internal_object;
            }
            internal_pSubmits[i].pCommandBufferInfos = internal_VkSubmitInfo2_pCommandBufferInfos[i].data();
            /* VkSubmitInfo2::pSignalSemaphoreInfos */
            internal_VkSubmitInfo2_pSignalSemaphoreInfos.push_back(std::vector<VkSemaphoreSubmitInfo>());
            internal_VkSubmitInfo2_pSignalSemaphoreInfos[i] = transformVkSemaphoreSubmitInfoList(internal_pSubmits[i].pSignalSemaphoreInfos, internal_pSubmits[i].signalSemaphoreInfoCount);
            internal_pSubmits[i].pSignalSemaphoreInfos = internal_VkSubmitInfo2_pSignalSemaphoreInfos[i].data();
            internal_pSubmits[i].signalSemaphoreInfoCount = internal_VkSubmitInfo2_pSignalSemaphoreInfos[i].size();
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkQueueSubmit2_VkResult_return = resources->on_vkQueueSubmit2(vkEnc, VK_SUCCESS, gfxstream_queue->internal_object, submitCount, internal_pSubmits.data(), gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE);
    }
    return vkQueueSubmit2_VkResult_return;
}
void gfxstream_vk_CmdCopyBuffer2(
    VkCommandBuffer commandBuffer,
    const VkCopyBufferInfo2* pCopyBufferInfo)
{
    MESA_TRACE_SCOPE("vkCmdCopyBuffer2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkCopyBufferInfo2> internal_pCopyBufferInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pCopyBufferInfo[i] = pCopyBufferInfo[i];
            /* VkCopyBufferInfo2::srcBuffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_srcBuffer, internal_pCopyBufferInfo[i].srcBuffer);
            internal_pCopyBufferInfo[i].srcBuffer = gfxstream_srcBuffer->internal_object;
            /* VkCopyBufferInfo2::dstBuffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, internal_pCopyBufferInfo[i].dstBuffer);
            internal_pCopyBufferInfo[i].dstBuffer = gfxstream_dstBuffer->internal_object;
        }
        vkEnc->vkCmdCopyBuffer2(gfxstream_commandBuffer->internal_object, internal_pCopyBufferInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyImage2(
    VkCommandBuffer commandBuffer,
    const VkCopyImageInfo2* pCopyImageInfo)
{
    MESA_TRACE_SCOPE("vkCmdCopyImage2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdCopyImage2(gfxstream_commandBuffer->internal_object, pCopyImageInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyBufferToImage2(
    VkCommandBuffer commandBuffer,
    const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    MESA_TRACE_SCOPE("vkCmdCopyBufferToImage2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkCopyBufferToImageInfo2> internal_pCopyBufferToImageInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pCopyBufferToImageInfo[i] = pCopyBufferToImageInfo[i];
            /* VkCopyBufferToImageInfo2::srcBuffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_srcBuffer, internal_pCopyBufferToImageInfo[i].srcBuffer);
            internal_pCopyBufferToImageInfo[i].srcBuffer = gfxstream_srcBuffer->internal_object;
        }
        vkEnc->vkCmdCopyBufferToImage2(gfxstream_commandBuffer->internal_object, internal_pCopyBufferToImageInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyImageToBuffer2(
    VkCommandBuffer commandBuffer,
    const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    MESA_TRACE_SCOPE("vkCmdCopyImageToBuffer2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkCopyImageToBufferInfo2> internal_pCopyImageToBufferInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pCopyImageToBufferInfo[i] = pCopyImageToBufferInfo[i];
            /* VkCopyImageToBufferInfo2::dstBuffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, internal_pCopyImageToBufferInfo[i].dstBuffer);
            internal_pCopyImageToBufferInfo[i].dstBuffer = gfxstream_dstBuffer->internal_object;
        }
        vkEnc->vkCmdCopyImageToBuffer2(gfxstream_commandBuffer->internal_object, internal_pCopyImageToBufferInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdBlitImage2(
    VkCommandBuffer commandBuffer,
    const VkBlitImageInfo2* pBlitImageInfo)
{
    MESA_TRACE_SCOPE("vkCmdBlitImage2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBlitImage2(gfxstream_commandBuffer->internal_object, pBlitImageInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdResolveImage2(
    VkCommandBuffer commandBuffer,
    const VkResolveImageInfo2* pResolveImageInfo)
{
    MESA_TRACE_SCOPE("vkCmdResolveImage2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdResolveImage2(gfxstream_commandBuffer->internal_object, pResolveImageInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdBeginRendering(
    VkCommandBuffer commandBuffer,
    const VkRenderingInfo* pRenderingInfo)
{
    MESA_TRACE_SCOPE("vkCmdBeginRendering");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBeginRendering(gfxstream_commandBuffer->internal_object, pRenderingInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdEndRendering(
    VkCommandBuffer commandBuffer)
{
    MESA_TRACE_SCOPE("vkCmdEndRendering");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdEndRendering(gfxstream_commandBuffer->internal_object, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetCullMode(
    VkCommandBuffer commandBuffer,
    VkCullModeFlags cullMode)
{
    MESA_TRACE_SCOPE("vkCmdSetCullMode");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetCullMode(gfxstream_commandBuffer->internal_object, cullMode, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetFrontFace(
    VkCommandBuffer commandBuffer,
    VkFrontFace frontFace)
{
    MESA_TRACE_SCOPE("vkCmdSetFrontFace");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetFrontFace(gfxstream_commandBuffer->internal_object, frontFace, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetPrimitiveTopology(
    VkCommandBuffer commandBuffer,
    VkPrimitiveTopology primitiveTopology)
{
    MESA_TRACE_SCOPE("vkCmdSetPrimitiveTopology");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetPrimitiveTopology(gfxstream_commandBuffer->internal_object, primitiveTopology, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetViewportWithCount(
    VkCommandBuffer commandBuffer,
    uint32_t viewportCount,
    const VkViewport* pViewports)
{
    MESA_TRACE_SCOPE("vkCmdSetViewportWithCount");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetViewportWithCount(gfxstream_commandBuffer->internal_object, viewportCount, pViewports, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetScissorWithCount(
    VkCommandBuffer commandBuffer,
    uint32_t scissorCount,
    const VkRect2D* pScissors)
{
    MESA_TRACE_SCOPE("vkCmdSetScissorWithCount");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetScissorWithCount(gfxstream_commandBuffer->internal_object, scissorCount, pScissors, true /* do lock */);
    }
}
void gfxstream_vk_CmdBindVertexBuffers2(
    VkCommandBuffer commandBuffer,
    uint32_t firstBinding,
    uint32_t bindingCount,
    const VkBuffer* pBuffers,
    const VkDeviceSize* pOffsets,
    const VkDeviceSize* pSizes,
    const VkDeviceSize* pStrides)
{
    MESA_TRACE_SCOPE("vkCmdBindVertexBuffers2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkBuffer> internal_pBuffers(bindingCount);
        for (uint32_t i = 0; i < bindingCount; ++i)
        {
            if (pBuffers)
            {
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_pBuffers, pBuffers[i]);
                internal_pBuffers[i] = gfxstream_pBuffers->internal_object;
            }
        }
        vkEnc->vkCmdBindVertexBuffers2(gfxstream_commandBuffer->internal_object, firstBinding, bindingCount, internal_pBuffers.data(), pOffsets, pSizes, pStrides, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthTestEnable(
    VkCommandBuffer commandBuffer,
    VkBool32 depthTestEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthTestEnable");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthTestEnable(gfxstream_commandBuffer->internal_object, depthTestEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthWriteEnable(
    VkCommandBuffer commandBuffer,
    VkBool32 depthWriteEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthWriteEnable");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthWriteEnable(gfxstream_commandBuffer->internal_object, depthWriteEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthCompareOp(
    VkCommandBuffer commandBuffer,
    VkCompareOp depthCompareOp)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthCompareOp");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthCompareOp(gfxstream_commandBuffer->internal_object, depthCompareOp, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthBoundsTestEnable(
    VkCommandBuffer commandBuffer,
    VkBool32 depthBoundsTestEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthBoundsTestEnable");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthBoundsTestEnable(gfxstream_commandBuffer->internal_object, depthBoundsTestEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetStencilTestEnable(
    VkCommandBuffer commandBuffer,
    VkBool32 stencilTestEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetStencilTestEnable");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetStencilTestEnable(gfxstream_commandBuffer->internal_object, stencilTestEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetStencilOp(
    VkCommandBuffer commandBuffer,
    VkStencilFaceFlags faceMask,
    VkStencilOp failOp,
    VkStencilOp passOp,
    VkStencilOp depthFailOp,
    VkCompareOp compareOp)
{
    MESA_TRACE_SCOPE("vkCmdSetStencilOp");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetStencilOp(gfxstream_commandBuffer->internal_object, faceMask, failOp, passOp, depthFailOp, compareOp, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetRasterizerDiscardEnable(
    VkCommandBuffer commandBuffer,
    VkBool32 rasterizerDiscardEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetRasterizerDiscardEnable");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetRasterizerDiscardEnable(gfxstream_commandBuffer->internal_object, rasterizerDiscardEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthBiasEnable(
    VkCommandBuffer commandBuffer,
    VkBool32 depthBiasEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthBiasEnable");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthBiasEnable(gfxstream_commandBuffer->internal_object, depthBiasEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetPrimitiveRestartEnable(
    VkCommandBuffer commandBuffer,
    VkBool32 primitiveRestartEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetPrimitiveRestartEnable");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetPrimitiveRestartEnable(gfxstream_commandBuffer->internal_object, primitiveRestartEnable, true /* do lock */);
    }
}
void gfxstream_vk_GetDeviceBufferMemoryRequirements(
    VkDevice device,
    const VkDeviceBufferMemoryRequirements* pInfo,
    VkMemoryRequirements2* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetDeviceBufferMemoryRequirements");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceBufferMemoryRequirements(gfxstream_device->internal_object, pInfo, pMemoryRequirements, true /* do lock */);
    }
}
void gfxstream_vk_GetDeviceImageMemoryRequirements(
    VkDevice device,
    const VkDeviceImageMemoryRequirements* pInfo,
    VkMemoryRequirements2* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetDeviceImageMemoryRequirements");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceImageMemoryRequirements(gfxstream_device->internal_object, pInfo, pMemoryRequirements, true /* do lock */);
    }
}
void gfxstream_vk_GetDeviceImageSparseMemoryRequirements(
    VkDevice device,
    const VkDeviceImageMemoryRequirements* pInfo,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetDeviceImageSparseMemoryRequirements");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceImageSparseMemoryRequirements(gfxstream_device->internal_object, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements, true /* do lock */);
    }
}
#endif
#ifdef VK_VERSION_1_4
void gfxstream_vk_CmdSetLineStipple(
    VkCommandBuffer commandBuffer,
    uint32_t lineStippleFactor,
    uint16_t lineStipplePattern)
{
    MESA_TRACE_SCOPE("vkCmdSetLineStipple");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetLineStipple(gfxstream_commandBuffer->internal_object, lineStippleFactor, lineStipplePattern, true /* do lock */);
    }
}
VkResult gfxstream_vk_MapMemory2(
    VkDevice device,
    const VkMemoryMapInfo* pMemoryMapInfo,
    void** ppData)
{
    MESA_TRACE_SCOPE("vkMapMemory2");
    VkResult vkMapMemory2_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkMapMemory2_VkResult_return = vkEnc->vkMapMemory2(gfxstream_device->internal_object, pMemoryMapInfo, ppData, true /* do lock */);
    }
    return vkMapMemory2_VkResult_return;
}
VkResult gfxstream_vk_UnmapMemory2(
    VkDevice device,
    const VkMemoryUnmapInfo* pMemoryUnmapInfo)
{
    MESA_TRACE_SCOPE("vkUnmapMemory2");
    VkResult vkUnmapMemory2_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkUnmapMemory2_VkResult_return = vkEnc->vkUnmapMemory2(gfxstream_device->internal_object, pMemoryUnmapInfo, true /* do lock */);
    }
    return vkUnmapMemory2_VkResult_return;
}
void gfxstream_vk_CmdBindIndexBuffer2(
    VkCommandBuffer commandBuffer,
    VkBuffer buffer,
    VkDeviceSize offset,
    VkDeviceSize size,
    VkIndexType indexType)
{
    MESA_TRACE_SCOPE("vkCmdBindIndexBuffer2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBindIndexBuffer2(gfxstream_commandBuffer->internal_object, gfxstream_buffer ? gfxstream_buffer->internal_object : VK_NULL_HANDLE, offset, size, indexType, true /* do lock */);
    }
}
void gfxstream_vk_GetRenderingAreaGranularity(
    VkDevice device,
    const VkRenderingAreaInfo* pRenderingAreaInfo,
    VkExtent2D* pGranularity)
{
    MESA_TRACE_SCOPE("vkGetRenderingAreaGranularity");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetRenderingAreaGranularity(gfxstream_device->internal_object, pRenderingAreaInfo, pGranularity, true /* do lock */);
    }
}
void gfxstream_vk_GetDeviceImageSubresourceLayout(
    VkDevice device,
    const VkDeviceImageSubresourceInfo* pInfo,
    VkSubresourceLayout2* pLayout)
{
    MESA_TRACE_SCOPE("vkGetDeviceImageSubresourceLayout");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceImageSubresourceLayout(gfxstream_device->internal_object, pInfo, pLayout, true /* do lock */);
    }
}
void gfxstream_vk_GetImageSubresourceLayout2(
    VkDevice device,
    VkImage image,
    const VkImageSubresource2* pSubresource,
    VkSubresourceLayout2* pLayout)
{
    MESA_TRACE_SCOPE("vkGetImageSubresourceLayout2");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetImageSubresourceLayout2(gfxstream_device->internal_object, image, pSubresource, pLayout, true /* do lock */);
    }
}
void gfxstream_vk_CmdPushDescriptorSet(
    VkCommandBuffer commandBuffer,
    VkPipelineBindPoint pipelineBindPoint,
    VkPipelineLayout layout,
    uint32_t set,
    uint32_t descriptorWriteCount,
    const VkWriteDescriptorSet* pDescriptorWrites)
{
    MESA_TRACE_SCOPE("vkCmdPushDescriptorSet");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkWriteDescriptorSet> internal_pDescriptorWrites(descriptorWriteCount);
        std::vector<std::vector<VkDescriptorBufferInfo>> internal_VkWriteDescriptorSet_pBufferInfo;
        for (uint32_t i = 0; i < descriptorWriteCount; ++i)
        {
            internal_pDescriptorWrites[i] = pDescriptorWrites[i];
            /* VkWriteDescriptorSet::pBufferInfo */
            internal_VkWriteDescriptorSet_pBufferInfo.push_back(std::vector<VkDescriptorBufferInfo>());
            internal_VkWriteDescriptorSet_pBufferInfo[i].resize(internal_pDescriptorWrites[i].descriptorCount);
            for (uint32_t j = 0; j < internal_pDescriptorWrites[i].descriptorCount; ++j)
            {
                if (internal_pDescriptorWrites[i].pBufferInfo)
                {
                    internal_VkWriteDescriptorSet_pBufferInfo[i][j] = internal_pDescriptorWrites[i].pBufferInfo[j];
                    /* VkDescriptorBufferInfo::buffer */
                    if (internal_VkWriteDescriptorSet_pBufferInfo[i][j].buffer)
                    {
                        VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkWriteDescriptorSet_pBufferInfo[i][j].buffer);
                        internal_VkWriteDescriptorSet_pBufferInfo[i][j].buffer = gfxstream_buffer->internal_object;
                    }
                }
            }
            internal_pDescriptorWrites[i].pBufferInfo = internal_VkWriteDescriptorSet_pBufferInfo[i].data();
        }
        vkEnc->vkCmdPushDescriptorSet(gfxstream_commandBuffer->internal_object, pipelineBindPoint, layout, set, descriptorWriteCount, internal_pDescriptorWrites.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdPushDescriptorSetWithTemplate(
    VkCommandBuffer commandBuffer,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    VkPipelineLayout layout,
    uint32_t set,
    const void* pData)
{
    MESA_TRACE_SCOPE("vkCmdPushDescriptorSetWithTemplate");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdPushDescriptorSetWithTemplate(gfxstream_commandBuffer->internal_object, descriptorUpdateTemplate, layout, set, pData, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetRenderingAttachmentLocations(
    VkCommandBuffer commandBuffer,
    const VkRenderingAttachmentLocationInfo* pLocationInfo)
{
    MESA_TRACE_SCOPE("vkCmdSetRenderingAttachmentLocations");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetRenderingAttachmentLocations(gfxstream_commandBuffer->internal_object, pLocationInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetRenderingInputAttachmentIndices(
    VkCommandBuffer commandBuffer,
    const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo)
{
    MESA_TRACE_SCOPE("vkCmdSetRenderingInputAttachmentIndices");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetRenderingInputAttachmentIndices(gfxstream_commandBuffer->internal_object, pInputAttachmentIndexInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdBindDescriptorSets2(
    VkCommandBuffer commandBuffer,
    const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo)
{
    MESA_TRACE_SCOPE("vkCmdBindDescriptorSets2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBindDescriptorSets2(gfxstream_commandBuffer->internal_object, pBindDescriptorSetsInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdPushConstants2(
    VkCommandBuffer commandBuffer,
    const VkPushConstantsInfo* pPushConstantsInfo)
{
    MESA_TRACE_SCOPE("vkCmdPushConstants2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdPushConstants2(gfxstream_commandBuffer->internal_object, pPushConstantsInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdPushDescriptorSet2(
    VkCommandBuffer commandBuffer,
    const VkPushDescriptorSetInfo* pPushDescriptorSetInfo)
{
    MESA_TRACE_SCOPE("vkCmdPushDescriptorSet2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkPushDescriptorSetInfo> internal_pPushDescriptorSetInfo(1);
        std::vector<std::vector<VkWriteDescriptorSet>> internal_VkPushDescriptorSetInfo_pDescriptorWrites;
        std::vector<std::vector<VkDescriptorBufferInfo>> internal_VkWriteDescriptorSet_pBufferInfo;
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pPushDescriptorSetInfo[i] = pPushDescriptorSetInfo[i];
            /* VkPushDescriptorSetInfo::pDescriptorWrites */
            internal_VkPushDescriptorSetInfo_pDescriptorWrites.push_back(std::vector<VkWriteDescriptorSet>());
            internal_VkPushDescriptorSetInfo_pDescriptorWrites[i].resize(internal_pPushDescriptorSetInfo[i].descriptorWriteCount);
            for (uint32_t j = 0; j < internal_pPushDescriptorSetInfo[i].descriptorWriteCount; ++j)
            {
                internal_VkPushDescriptorSetInfo_pDescriptorWrites[i][j] = internal_pPushDescriptorSetInfo[i].pDescriptorWrites[j];
                /* VkWriteDescriptorSet::pBufferInfo */
                internal_VkWriteDescriptorSet_pBufferInfo.push_back(std::vector<VkDescriptorBufferInfo>());
                internal_VkWriteDescriptorSet_pBufferInfo[j].resize(internal_VkPushDescriptorSetInfo_pDescriptorWrites[i][j].descriptorCount);
                for (uint32_t k = 0; k < internal_VkPushDescriptorSetInfo_pDescriptorWrites[i][j].descriptorCount; ++k)
                {
                    if (internal_VkPushDescriptorSetInfo_pDescriptorWrites[i][j].pBufferInfo)
                    {
                        internal_VkWriteDescriptorSet_pBufferInfo[j][k] = internal_VkPushDescriptorSetInfo_pDescriptorWrites[i][j].pBufferInfo[k];
                        /* VkDescriptorBufferInfo::buffer */
                        if (internal_VkWriteDescriptorSet_pBufferInfo[j][k].buffer)
                        {
                            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkWriteDescriptorSet_pBufferInfo[j][k].buffer);
                            internal_VkWriteDescriptorSet_pBufferInfo[j][k].buffer = gfxstream_buffer->internal_object;
                        }
                    }
                }
                internal_VkPushDescriptorSetInfo_pDescriptorWrites[i][j].pBufferInfo = internal_VkWriteDescriptorSet_pBufferInfo[j].data();
            }
            internal_pPushDescriptorSetInfo[i].pDescriptorWrites = internal_VkPushDescriptorSetInfo_pDescriptorWrites[i].data();
        }
        vkEnc->vkCmdPushDescriptorSet2(gfxstream_commandBuffer->internal_object, internal_pPushDescriptorSetInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdPushDescriptorSetWithTemplate2(
    VkCommandBuffer commandBuffer,
    const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo)
{
    MESA_TRACE_SCOPE("vkCmdPushDescriptorSetWithTemplate2");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdPushDescriptorSetWithTemplate2(gfxstream_commandBuffer->internal_object, pPushDescriptorSetWithTemplateInfo, true /* do lock */);
    }
}
VkResult gfxstream_vk_CopyMemoryToImage(
    VkDevice device,
    const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo)
{
    MESA_TRACE_SCOPE("vkCopyMemoryToImage");
    VkResult vkCopyMemoryToImage_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCopyMemoryToImage_VkResult_return = vkEnc->vkCopyMemoryToImage(gfxstream_device->internal_object, pCopyMemoryToImageInfo, true /* do lock */);
    }
    return vkCopyMemoryToImage_VkResult_return;
}
VkResult gfxstream_vk_CopyImageToMemory(
    VkDevice device,
    const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo)
{
    MESA_TRACE_SCOPE("vkCopyImageToMemory");
    VkResult vkCopyImageToMemory_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCopyImageToMemory_VkResult_return = vkEnc->vkCopyImageToMemory(gfxstream_device->internal_object, pCopyImageToMemoryInfo, true /* do lock */);
    }
    return vkCopyImageToMemory_VkResult_return;
}
VkResult gfxstream_vk_CopyImageToImage(
    VkDevice device,
    const VkCopyImageToImageInfo* pCopyImageToImageInfo)
{
    MESA_TRACE_SCOPE("vkCopyImageToImage");
    VkResult vkCopyImageToImage_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCopyImageToImage_VkResult_return = vkEnc->vkCopyImageToImage(gfxstream_device->internal_object, pCopyImageToImageInfo, true /* do lock */);
    }
    return vkCopyImageToImage_VkResult_return;
}
VkResult gfxstream_vk_TransitionImageLayout(
    VkDevice device,
    uint32_t transitionCount,
    const VkHostImageLayoutTransitionInfo* pTransitions)
{
    MESA_TRACE_SCOPE("vkTransitionImageLayout");
    VkResult vkTransitionImageLayout_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkTransitionImageLayout_VkResult_return = vkEnc->vkTransitionImageLayout(gfxstream_device->internal_object, transitionCount, pTransitions, true /* do lock */);
    }
    return vkTransitionImageLayout_VkResult_return;
}
#endif
#ifdef VK_KHR_android_surface
VkResult gfxstream_vk_CreateAndroidSurfaceKHR(
    VkInstance instance,
    const VkAndroidSurfaceCreateInfoKHR* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkSurfaceKHR* pSurface)
{
    MESA_TRACE_SCOPE("vkCreateAndroidSurfaceKHR");
    VkResult vkCreateAndroidSurfaceKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_instance, gfxstream_instance, instance);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateAndroidSurfaceKHR_VkResult_return = vkEnc->vkCreateAndroidSurfaceKHR(gfxstream_instance->internal_object, pCreateInfo, pAllocator, pSurface, true /* do lock */);
    }
    return vkCreateAndroidSurfaceKHR_VkResult_return;
}
#endif
#ifdef VK_KHR_dynamic_rendering
void gfxstream_vk_CmdBeginRenderingKHR(
    VkCommandBuffer commandBuffer,
    const VkRenderingInfo* pRenderingInfo)
{
    MESA_TRACE_SCOPE("vkCmdBeginRenderingKHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBeginRenderingKHR(gfxstream_commandBuffer->internal_object, pRenderingInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdEndRenderingKHR(
    VkCommandBuffer commandBuffer)
{
    MESA_TRACE_SCOPE("vkCmdEndRenderingKHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdEndRenderingKHR(gfxstream_commandBuffer->internal_object, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_get_physical_device_properties2
void gfxstream_vk_GetPhysicalDeviceFeatures2KHR(
    VkPhysicalDevice physicalDevice,
    VkPhysicalDeviceFeatures2* pFeatures)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceFeatures2KHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceFeatures2KHR(gfxstream_physicalDevice->internal_object, pFeatures, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceProperties2KHR(
    VkPhysicalDevice physicalDevice,
    VkPhysicalDeviceProperties2* pProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceProperties2KHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceProperties2KHR(gfxstream_physicalDevice->internal_object, pProperties, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceFormatProperties2KHR(
    VkPhysicalDevice physicalDevice,
    VkFormat format,
    VkFormatProperties2* pFormatProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceFormatProperties2KHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceFormatProperties2KHR(gfxstream_physicalDevice->internal_object, format, pFormatProperties, true /* do lock */);
    }
}
VkResult gfxstream_vk_GetPhysicalDeviceImageFormatProperties2KHR(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
    VkImageFormatProperties2* pImageFormatProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceImageFormatProperties2KHR");
    VkResult vkGetPhysicalDeviceImageFormatProperties2KHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetPhysicalDeviceImageFormatProperties2KHR_VkResult_return = vkEnc->vkGetPhysicalDeviceImageFormatProperties2KHR(gfxstream_physicalDevice->internal_object, pImageFormatInfo, pImageFormatProperties, true /* do lock */);
    }
    return vkGetPhysicalDeviceImageFormatProperties2KHR_VkResult_return;
}
void gfxstream_vk_GetPhysicalDeviceQueueFamilyProperties2KHR(
    VkPhysicalDevice physicalDevice,
    uint32_t* pQueueFamilyPropertyCount,
    VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceQueueFamilyProperties2KHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceQueueFamilyProperties2KHR(gfxstream_physicalDevice->internal_object, pQueueFamilyPropertyCount, pQueueFamilyProperties, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceMemoryProperties2KHR(
    VkPhysicalDevice physicalDevice,
    VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceMemoryProperties2KHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceMemoryProperties2KHR(gfxstream_physicalDevice->internal_object, pMemoryProperties, true /* do lock */);
    }
}
void gfxstream_vk_GetPhysicalDeviceSparseImageFormatProperties2KHR(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
    uint32_t* pPropertyCount,
    VkSparseImageFormatProperties2* pProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceSparseImageFormatProperties2KHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceSparseImageFormatProperties2KHR(gfxstream_physicalDevice->internal_object, pFormatInfo, pPropertyCount, pProperties, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_maintenance1
void gfxstream_vk_TrimCommandPoolKHR(
    VkDevice device,
    VkCommandPool commandPool,
    VkCommandPoolTrimFlags flags)
{
    MESA_TRACE_SCOPE("vkTrimCommandPoolKHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_command_pool, gfxstream_commandPool, commandPool);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkTrimCommandPoolKHR(gfxstream_device->internal_object, gfxstream_commandPool->internal_object, flags, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_external_memory_capabilities
void gfxstream_vk_GetPhysicalDeviceExternalBufferPropertiesKHR(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
    VkExternalBufferProperties* pExternalBufferProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceExternalBufferPropertiesKHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceExternalBufferPropertiesKHR(gfxstream_physicalDevice->internal_object, pExternalBufferInfo, pExternalBufferProperties, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_external_memory_fd
VkResult gfxstream_vk_GetMemoryFdKHR(
    VkDevice device,
    const VkMemoryGetFdInfoKHR* pGetFdInfo,
    int* pFd)
{
    MESA_TRACE_SCOPE("vkGetMemoryFdKHR");
    VkResult vkGetMemoryFdKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetMemoryFdKHR_VkResult_return = resources->on_vkGetMemoryFdKHR(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pGetFdInfo, pFd);
    }
    return vkGetMemoryFdKHR_VkResult_return;
}
VkResult gfxstream_vk_GetMemoryFdPropertiesKHR(
    VkDevice device,
    VkExternalMemoryHandleTypeFlagBits handleType,
    int fd,
    VkMemoryFdPropertiesKHR* pMemoryFdProperties)
{
    MESA_TRACE_SCOPE("vkGetMemoryFdPropertiesKHR");
    VkResult vkGetMemoryFdPropertiesKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetMemoryFdPropertiesKHR_VkResult_return = resources->on_vkGetMemoryFdPropertiesKHR(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, handleType, fd, pMemoryFdProperties);
    }
    return vkGetMemoryFdPropertiesKHR_VkResult_return;
}
#endif
#ifdef VK_KHR_external_semaphore_capabilities
void gfxstream_vk_GetPhysicalDeviceExternalSemaphorePropertiesKHR(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceExternalSemaphorePropertiesKHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceExternalSemaphorePropertiesKHR(gfxstream_physicalDevice->internal_object, pExternalSemaphoreInfo, pExternalSemaphoreProperties, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_external_semaphore_fd
VkResult gfxstream_vk_ImportSemaphoreFdKHR(
    VkDevice device,
    const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo)
{
    MESA_TRACE_SCOPE("vkImportSemaphoreFdKHR");
    VkResult vkImportSemaphoreFdKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkImportSemaphoreFdInfoKHR> internal_pImportSemaphoreFdInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pImportSemaphoreFdInfo[i] = pImportSemaphoreFdInfo[i];
            /* VkImportSemaphoreFdInfoKHR::semaphore */
            VK_FROM_HANDLE(gfxstream_vk_semaphore, gfxstream_semaphore, internal_pImportSemaphoreFdInfo[i].semaphore);
            internal_pImportSemaphoreFdInfo[i].semaphore = gfxstream_semaphore->internal_object;
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkImportSemaphoreFdKHR_VkResult_return = resources->on_vkImportSemaphoreFdKHR(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, internal_pImportSemaphoreFdInfo.data());
    }
    return vkImportSemaphoreFdKHR_VkResult_return;
}
VkResult gfxstream_vk_GetSemaphoreFdKHR(
    VkDevice device,
    const VkSemaphoreGetFdInfoKHR* pGetFdInfo,
    int* pFd)
{
    MESA_TRACE_SCOPE("vkGetSemaphoreFdKHR");
    VkResult vkGetSemaphoreFdKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkSemaphoreGetFdInfoKHR> internal_pGetFdInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pGetFdInfo[i] = pGetFdInfo[i];
            /* VkSemaphoreGetFdInfoKHR::semaphore */
            VK_FROM_HANDLE(gfxstream_vk_semaphore, gfxstream_semaphore, internal_pGetFdInfo[i].semaphore);
            internal_pGetFdInfo[i].semaphore = gfxstream_semaphore->internal_object;
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetSemaphoreFdKHR_VkResult_return = resources->on_vkGetSemaphoreFdKHR(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, internal_pGetFdInfo.data(), pFd);
    }
    return vkGetSemaphoreFdKHR_VkResult_return;
}
#endif
#ifdef VK_KHR_descriptor_update_template
VkResult gfxstream_vk_CreateDescriptorUpdateTemplateKHR(
    VkDevice device,
    const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate)
{
    MESA_TRACE_SCOPE("vkCreateDescriptorUpdateTemplateKHR");
    VkResult vkCreateDescriptorUpdateTemplateKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateDescriptorUpdateTemplateKHR_VkResult_return = vkEnc->vkCreateDescriptorUpdateTemplateKHR(gfxstream_device->internal_object, pCreateInfo, pAllocator, pDescriptorUpdateTemplate, true /* do lock */);
    }
    return vkCreateDescriptorUpdateTemplateKHR_VkResult_return;
}
void gfxstream_vk_DestroyDescriptorUpdateTemplateKHR(
    VkDevice device,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyDescriptorUpdateTemplateKHR");
    if (VK_NULL_HANDLE == descriptorUpdateTemplate)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroyDescriptorUpdateTemplateKHR(gfxstream_device->internal_object, descriptorUpdateTemplate, pAllocator, true /* do lock */);
    }
}
void gfxstream_vk_UpdateDescriptorSetWithTemplateKHR(
    VkDevice device,
    VkDescriptorSet descriptorSet,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    const void* pData)
{
    MESA_TRACE_SCOPE("vkUpdateDescriptorSetWithTemplateKHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkUpdateDescriptorSetWithTemplateKHR(gfxstream_device->internal_object, descriptorSet, descriptorUpdateTemplate, pData, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_create_renderpass2
VkResult gfxstream_vk_CreateRenderPass2KHR(
    VkDevice device,
    const VkRenderPassCreateInfo2* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkRenderPass* pRenderPass)
{
    MESA_TRACE_SCOPE("vkCreateRenderPass2KHR");
    VkResult vkCreateRenderPass2KHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateRenderPass2KHR_VkResult_return = vkEnc->vkCreateRenderPass2KHR(gfxstream_device->internal_object, pCreateInfo, pAllocator, pRenderPass, true /* do lock */);
    }
    return vkCreateRenderPass2KHR_VkResult_return;
}
void gfxstream_vk_CmdBeginRenderPass2KHR(
    VkCommandBuffer commandBuffer,
    const VkRenderPassBeginInfo* pRenderPassBegin,
    const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    MESA_TRACE_SCOPE("vkCmdBeginRenderPass2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBeginRenderPass2KHR(gfxstream_commandBuffer->internal_object, pRenderPassBegin, pSubpassBeginInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdNextSubpass2KHR(
    VkCommandBuffer commandBuffer,
    const VkSubpassBeginInfo* pSubpassBeginInfo,
    const VkSubpassEndInfo* pSubpassEndInfo)
{
    MESA_TRACE_SCOPE("vkCmdNextSubpass2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdNextSubpass2KHR(gfxstream_commandBuffer->internal_object, pSubpassBeginInfo, pSubpassEndInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdEndRenderPass2KHR(
    VkCommandBuffer commandBuffer,
    const VkSubpassEndInfo* pSubpassEndInfo)
{
    MESA_TRACE_SCOPE("vkCmdEndRenderPass2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdEndRenderPass2KHR(gfxstream_commandBuffer->internal_object, pSubpassEndInfo, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_external_fence_capabilities
void gfxstream_vk_GetPhysicalDeviceExternalFencePropertiesKHR(
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
    VkExternalFenceProperties* pExternalFenceProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceExternalFencePropertiesKHR");
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPhysicalDeviceExternalFencePropertiesKHR(gfxstream_physicalDevice->internal_object, pExternalFenceInfo, pExternalFenceProperties, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_external_fence_fd
VkResult gfxstream_vk_ImportFenceFdKHR(
    VkDevice device,
    const VkImportFenceFdInfoKHR* pImportFenceFdInfo)
{
    MESA_TRACE_SCOPE("vkImportFenceFdKHR");
    VkResult vkImportFenceFdKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkImportFenceFdInfoKHR> internal_pImportFenceFdInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pImportFenceFdInfo[i] = pImportFenceFdInfo[i];
            /* VkImportFenceFdInfoKHR::fence */
            VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, internal_pImportFenceFdInfo[i].fence);
            internal_pImportFenceFdInfo[i].fence = gfxstream_fence->internal_object;
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkImportFenceFdKHR_VkResult_return = resources->on_vkImportFenceFdKHR(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, internal_pImportFenceFdInfo.data());
    }
    return vkImportFenceFdKHR_VkResult_return;
}
VkResult gfxstream_vk_GetFenceFdKHR(
    VkDevice device,
    const VkFenceGetFdInfoKHR* pGetFdInfo,
    int* pFd)
{
    MESA_TRACE_SCOPE("vkGetFenceFdKHR");
    VkResult vkGetFenceFdKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkFenceGetFdInfoKHR> internal_pGetFdInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pGetFdInfo[i] = pGetFdInfo[i];
            /* VkFenceGetFdInfoKHR::fence */
            VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, internal_pGetFdInfo[i].fence);
            internal_pGetFdInfo[i].fence = gfxstream_fence->internal_object;
        }
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetFenceFdKHR_VkResult_return = resources->on_vkGetFenceFdKHR(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, internal_pGetFdInfo.data(), pFd);
    }
    return vkGetFenceFdKHR_VkResult_return;
}
#endif
#ifdef VK_KHR_get_memory_requirements2
void gfxstream_vk_GetImageMemoryRequirements2KHR(
    VkDevice device,
    const VkImageMemoryRequirementsInfo2* pInfo,
    VkMemoryRequirements2* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetImageMemoryRequirements2KHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetImageMemoryRequirements2KHR(gfxstream_device->internal_object, pInfo, pMemoryRequirements, true /* do lock */);
    }
}
void gfxstream_vk_GetBufferMemoryRequirements2KHR(
    VkDevice device,
    const VkBufferMemoryRequirementsInfo2* pInfo,
    VkMemoryRequirements2* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetBufferMemoryRequirements2KHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBufferMemoryRequirementsInfo2> internal_pInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pInfo[i] = pInfo[i];
            /* VkBufferMemoryRequirementsInfo2::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pInfo[i].buffer);
            internal_pInfo[i].buffer = gfxstream_buffer->internal_object;
        }
        vkEnc->vkGetBufferMemoryRequirements2KHR(gfxstream_device->internal_object, internal_pInfo.data(), pMemoryRequirements, true /* do lock */);
    }
}
void gfxstream_vk_GetImageSparseMemoryRequirements2KHR(
    VkDevice device,
    const VkImageSparseMemoryRequirementsInfo2* pInfo,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetImageSparseMemoryRequirements2KHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetImageSparseMemoryRequirements2KHR(gfxstream_device->internal_object, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
VkResult gfxstream_vk_CreateSamplerYcbcrConversionKHR(
    VkDevice device,
    const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkSamplerYcbcrConversion* pYcbcrConversion)
{
    MESA_TRACE_SCOPE("vkCreateSamplerYcbcrConversionKHR");
    VkResult vkCreateSamplerYcbcrConversionKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateSamplerYcbcrConversionKHR_VkResult_return = vkEnc->vkCreateSamplerYcbcrConversionKHR(gfxstream_device->internal_object, pCreateInfo, pAllocator, pYcbcrConversion, true /* do lock */);
    }
    return vkCreateSamplerYcbcrConversionKHR_VkResult_return;
}
void gfxstream_vk_DestroySamplerYcbcrConversionKHR(
    VkDevice device,
    VkSamplerYcbcrConversion ycbcrConversion,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroySamplerYcbcrConversionKHR");
    if (VK_NULL_HANDLE == ycbcrConversion)
    {
        return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkDestroySamplerYcbcrConversionKHR(gfxstream_device->internal_object, ycbcrConversion, pAllocator, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_bind_memory2
VkResult gfxstream_vk_BindBufferMemory2KHR(
    VkDevice device,
    uint32_t bindInfoCount,
    const VkBindBufferMemoryInfo* pBindInfos)
{
    MESA_TRACE_SCOPE("vkBindBufferMemory2KHR");
    VkResult vkBindBufferMemory2KHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBindBufferMemoryInfo> internal_pBindInfos(bindInfoCount);
        for (uint32_t i = 0; i < bindInfoCount; ++i)
        {
            internal_pBindInfos[i] = pBindInfos[i];
            /* VkBindBufferMemoryInfo::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pBindInfos[i].buffer);
            internal_pBindInfos[i].buffer = gfxstream_buffer->internal_object;
        }
        vkBindBufferMemory2KHR_VkResult_return = vkEnc->vkBindBufferMemory2KHR(gfxstream_device->internal_object, bindInfoCount, internal_pBindInfos.data(), true /* do lock */);
    }
    return vkBindBufferMemory2KHR_VkResult_return;
}
VkResult gfxstream_vk_BindImageMemory2KHR(
    VkDevice device,
    uint32_t bindInfoCount,
    const VkBindImageMemoryInfo* pBindInfos)
{
    MESA_TRACE_SCOPE("vkBindImageMemory2KHR");
    VkResult vkBindImageMemory2KHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkBindImageMemory2KHR_VkResult_return = vkEnc->vkBindImageMemory2KHR(gfxstream_device->internal_object, bindInfoCount, pBindInfos, true /* do lock */);
    }
    return vkBindImageMemory2KHR_VkResult_return;
}
#endif
#ifdef VK_KHR_maintenance3
void gfxstream_vk_GetDescriptorSetLayoutSupportKHR(
    VkDevice device,
    const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
    VkDescriptorSetLayoutSupport* pSupport)
{
    MESA_TRACE_SCOPE("vkGetDescriptorSetLayoutSupportKHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDescriptorSetLayoutSupportKHR(gfxstream_device->internal_object, pCreateInfo, pSupport, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_buffer_device_address
VkDeviceAddress gfxstream_vk_GetBufferDeviceAddressKHR(
    VkDevice device,
    const VkBufferDeviceAddressInfo* pInfo)
{
    MESA_TRACE_SCOPE("vkGetBufferDeviceAddressKHR");
    VkDeviceAddress vkGetBufferDeviceAddressKHR_VkDeviceAddress_return = (VkDeviceAddress)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBufferDeviceAddressInfo> internal_pInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pInfo[i] = pInfo[i];
            /* VkBufferDeviceAddressInfo::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pInfo[i].buffer);
            internal_pInfo[i].buffer = gfxstream_buffer->internal_object;
        }
        vkGetBufferDeviceAddressKHR_VkDeviceAddress_return = vkEnc->vkGetBufferDeviceAddressKHR(gfxstream_device->internal_object, internal_pInfo.data(), true /* do lock */);
    }
    return vkGetBufferDeviceAddressKHR_VkDeviceAddress_return;
}
uint64_t gfxstream_vk_GetBufferOpaqueCaptureAddressKHR(
    VkDevice device,
    const VkBufferDeviceAddressInfo* pInfo)
{
    MESA_TRACE_SCOPE("vkGetBufferOpaqueCaptureAddressKHR");
    uint64_t vkGetBufferOpaqueCaptureAddressKHR_uint64_t_return = (uint64_t)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkBufferDeviceAddressInfo> internal_pInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pInfo[i] = pInfo[i];
            /* VkBufferDeviceAddressInfo::buffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pInfo[i].buffer);
            internal_pInfo[i].buffer = gfxstream_buffer->internal_object;
        }
        vkGetBufferOpaqueCaptureAddressKHR_uint64_t_return = vkEnc->vkGetBufferOpaqueCaptureAddressKHR(gfxstream_device->internal_object, internal_pInfo.data(), true /* do lock */);
    }
    return vkGetBufferOpaqueCaptureAddressKHR_uint64_t_return;
}
uint64_t gfxstream_vk_GetDeviceMemoryOpaqueCaptureAddressKHR(
    VkDevice device,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    MESA_TRACE_SCOPE("vkGetDeviceMemoryOpaqueCaptureAddressKHR");
    uint64_t vkGetDeviceMemoryOpaqueCaptureAddressKHR_uint64_t_return = (uint64_t)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetDeviceMemoryOpaqueCaptureAddressKHR_uint64_t_return = vkEnc->vkGetDeviceMemoryOpaqueCaptureAddressKHR(gfxstream_device->internal_object, pInfo, true /* do lock */);
    }
    return vkGetDeviceMemoryOpaqueCaptureAddressKHR_uint64_t_return;
}
#endif
#ifdef VK_KHR_pipeline_executable_properties
VkResult gfxstream_vk_GetPipelineExecutablePropertiesKHR(
    VkDevice device,
    const VkPipelineInfoKHR* pPipelineInfo,
    uint32_t* pExecutableCount,
    VkPipelineExecutablePropertiesKHR* pProperties)
{
    MESA_TRACE_SCOPE("vkGetPipelineExecutablePropertiesKHR");
    VkResult vkGetPipelineExecutablePropertiesKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetPipelineExecutablePropertiesKHR_VkResult_return = vkEnc->vkGetPipelineExecutablePropertiesKHR(gfxstream_device->internal_object, pPipelineInfo, pExecutableCount, pProperties, true /* do lock */);
    }
    return vkGetPipelineExecutablePropertiesKHR_VkResult_return;
}
VkResult gfxstream_vk_GetPipelineExecutableStatisticsKHR(
    VkDevice device,
    const VkPipelineExecutableInfoKHR* pExecutableInfo,
    uint32_t* pStatisticCount,
    VkPipelineExecutableStatisticKHR* pStatistics)
{
    MESA_TRACE_SCOPE("vkGetPipelineExecutableStatisticsKHR");
    VkResult vkGetPipelineExecutableStatisticsKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetPipelineExecutableStatisticsKHR_VkResult_return = vkEnc->vkGetPipelineExecutableStatisticsKHR(gfxstream_device->internal_object, pExecutableInfo, pStatisticCount, pStatistics, true /* do lock */);
    }
    return vkGetPipelineExecutableStatisticsKHR_VkResult_return;
}
VkResult gfxstream_vk_GetPipelineExecutableInternalRepresentationsKHR(
    VkDevice device,
    const VkPipelineExecutableInfoKHR* pExecutableInfo,
    uint32_t* pInternalRepresentationCount,
    VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations)
{
    MESA_TRACE_SCOPE("vkGetPipelineExecutableInternalRepresentationsKHR");
    VkResult vkGetPipelineExecutableInternalRepresentationsKHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetPipelineExecutableInternalRepresentationsKHR_VkResult_return = vkEnc->vkGetPipelineExecutableInternalRepresentationsKHR(gfxstream_device->internal_object, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations, true /* do lock */);
    }
    return vkGetPipelineExecutableInternalRepresentationsKHR_VkResult_return;
}
#endif
#ifdef VK_KHR_synchronization2
void gfxstream_vk_CmdSetEvent2KHR(
    VkCommandBuffer commandBuffer,
    VkEvent event,
    const VkDependencyInfo* pDependencyInfo)
{
    MESA_TRACE_SCOPE("vkCmdSetEvent2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkDependencyInfo> internal_pDependencyInfo(1);
        std::vector<std::vector<VkBufferMemoryBarrier2>> internal_VkDependencyInfo_pBufferMemoryBarriers;
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pDependencyInfo[i] = pDependencyInfo[i];
            /* VkDependencyInfo::pBufferMemoryBarriers */
            internal_VkDependencyInfo_pBufferMemoryBarriers.push_back(std::vector<VkBufferMemoryBarrier2>());
            internal_VkDependencyInfo_pBufferMemoryBarriers[i].resize(internal_pDependencyInfo[i].bufferMemoryBarrierCount);
            for (uint32_t j = 0; j < internal_pDependencyInfo[i].bufferMemoryBarrierCount; ++j)
            {
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j] = internal_pDependencyInfo[i].pBufferMemoryBarriers[j];
                /* VkBufferMemoryBarrier2::buffer */
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer);
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer = gfxstream_buffer->internal_object;
            }
            internal_pDependencyInfo[i].pBufferMemoryBarriers = internal_VkDependencyInfo_pBufferMemoryBarriers[i].data();
        }
        vkEnc->vkCmdSetEvent2KHR(gfxstream_commandBuffer->internal_object, event, internal_pDependencyInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdResetEvent2KHR(
    VkCommandBuffer commandBuffer,
    VkEvent event,
    VkPipelineStageFlags2 stageMask)
{
    MESA_TRACE_SCOPE("vkCmdResetEvent2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdResetEvent2KHR(gfxstream_commandBuffer->internal_object, event, stageMask, true /* do lock */);
    }
}
void gfxstream_vk_CmdWaitEvents2KHR(
    VkCommandBuffer commandBuffer,
    uint32_t eventCount,
    const VkEvent* pEvents,
    const VkDependencyInfo* pDependencyInfos)
{
    MESA_TRACE_SCOPE("vkCmdWaitEvents2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkDependencyInfo> internal_pDependencyInfos(eventCount);
        std::vector<std::vector<VkBufferMemoryBarrier2>> internal_VkDependencyInfo_pBufferMemoryBarriers;
        for (uint32_t i = 0; i < eventCount; ++i)
        {
            internal_pDependencyInfos[i] = pDependencyInfos[i];
            /* VkDependencyInfo::pBufferMemoryBarriers */
            internal_VkDependencyInfo_pBufferMemoryBarriers.push_back(std::vector<VkBufferMemoryBarrier2>());
            internal_VkDependencyInfo_pBufferMemoryBarriers[i].resize(internal_pDependencyInfos[i].bufferMemoryBarrierCount);
            for (uint32_t j = 0; j < internal_pDependencyInfos[i].bufferMemoryBarrierCount; ++j)
            {
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j] = internal_pDependencyInfos[i].pBufferMemoryBarriers[j];
                /* VkBufferMemoryBarrier2::buffer */
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer);
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer = gfxstream_buffer->internal_object;
            }
            internal_pDependencyInfos[i].pBufferMemoryBarriers = internal_VkDependencyInfo_pBufferMemoryBarriers[i].data();
        }
        vkEnc->vkCmdWaitEvents2KHR(gfxstream_commandBuffer->internal_object, eventCount, pEvents, internal_pDependencyInfos.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdPipelineBarrier2KHR(
    VkCommandBuffer commandBuffer,
    const VkDependencyInfo* pDependencyInfo)
{
    MESA_TRACE_SCOPE("vkCmdPipelineBarrier2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkDependencyInfo> internal_pDependencyInfo(1);
        std::vector<std::vector<VkBufferMemoryBarrier2>> internal_VkDependencyInfo_pBufferMemoryBarriers;
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pDependencyInfo[i] = pDependencyInfo[i];
            /* VkDependencyInfo::pBufferMemoryBarriers */
            internal_VkDependencyInfo_pBufferMemoryBarriers.push_back(std::vector<VkBufferMemoryBarrier2>());
            internal_VkDependencyInfo_pBufferMemoryBarriers[i].resize(internal_pDependencyInfo[i].bufferMemoryBarrierCount);
            for (uint32_t j = 0; j < internal_pDependencyInfo[i].bufferMemoryBarrierCount; ++j)
            {
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j] = internal_pDependencyInfo[i].pBufferMemoryBarriers[j];
                /* VkBufferMemoryBarrier2::buffer */
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer);
                internal_VkDependencyInfo_pBufferMemoryBarriers[i][j].buffer = gfxstream_buffer->internal_object;
            }
            internal_pDependencyInfo[i].pBufferMemoryBarriers = internal_VkDependencyInfo_pBufferMemoryBarriers[i].data();
        }
        vkEnc->vkCmdPipelineBarrier2KHR(gfxstream_commandBuffer->internal_object, internal_pDependencyInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdWriteTimestamp2KHR(
    VkCommandBuffer commandBuffer,
    VkPipelineStageFlags2 stage,
    VkQueryPool queryPool,
    uint32_t query)
{
    MESA_TRACE_SCOPE("vkCmdWriteTimestamp2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdWriteTimestamp2KHR(gfxstream_commandBuffer->internal_object, stage, queryPool, query, true /* do lock */);
    }
}
VkResult gfxstream_vk_QueueSubmit2KHR(
    VkQueue queue,
    uint32_t submitCount,
    const VkSubmitInfo2* pSubmits,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkQueueSubmit2KHR");
    VkResult vkQueueSubmit2KHR_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkSubmitInfo2> internal_pSubmits(submitCount);
        std::vector<std::vector<VkSemaphoreSubmitInfo>> internal_VkSubmitInfo2_pWaitSemaphoreInfos;
        std::vector<std::vector<VkCommandBufferSubmitInfo>> internal_VkSubmitInfo2_pCommandBufferInfos;
        std::vector<std::vector<VkSemaphoreSubmitInfo>> internal_VkSubmitInfo2_pSignalSemaphoreInfos;
        for (uint32_t i = 0; i < submitCount; ++i)
        {
            internal_pSubmits[i] = pSubmits[i];
            /* VkSubmitInfo2::pWaitSemaphoreInfos */
            internal_VkSubmitInfo2_pWaitSemaphoreInfos.push_back(std::vector<VkSemaphoreSubmitInfo>());
            internal_VkSubmitInfo2_pWaitSemaphoreInfos[i] = transformVkSemaphoreSubmitInfoList(internal_pSubmits[i].pWaitSemaphoreInfos, internal_pSubmits[i].waitSemaphoreInfoCount);
            internal_pSubmits[i].pWaitSemaphoreInfos = internal_VkSubmitInfo2_pWaitSemaphoreInfos[i].data();
            internal_pSubmits[i].waitSemaphoreInfoCount = internal_VkSubmitInfo2_pWaitSemaphoreInfos[i].size();
            /* VkSubmitInfo2::pCommandBufferInfos */
            internal_VkSubmitInfo2_pCommandBufferInfos.push_back(std::vector<VkCommandBufferSubmitInfo>());
            internal_VkSubmitInfo2_pCommandBufferInfos[i].resize(internal_pSubmits[i].commandBufferInfoCount);
            for (uint32_t j = 0; j < internal_pSubmits[i].commandBufferInfoCount; ++j)
            {
                internal_VkSubmitInfo2_pCommandBufferInfos[i][j] = internal_pSubmits[i].pCommandBufferInfos[j];
                /* VkCommandBufferSubmitInfo::commandBuffer */
                VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, internal_VkSubmitInfo2_pCommandBufferInfos[i][j].commandBuffer);
                internal_VkSubmitInfo2_pCommandBufferInfos[i][j].commandBuffer = gfxstream_commandBuffer->internal_object;
            }
            internal_pSubmits[i].pCommandBufferInfos = internal_VkSubmitInfo2_pCommandBufferInfos[i].data();
            /* VkSubmitInfo2::pSignalSemaphoreInfos */
            internal_VkSubmitInfo2_pSignalSemaphoreInfos.push_back(std::vector<VkSemaphoreSubmitInfo>());
            internal_VkSubmitInfo2_pSignalSemaphoreInfos[i] = transformVkSemaphoreSubmitInfoList(internal_pSubmits[i].pSignalSemaphoreInfos, internal_pSubmits[i].signalSemaphoreInfoCount);
            internal_pSubmits[i].pSignalSemaphoreInfos = internal_VkSubmitInfo2_pSignalSemaphoreInfos[i].data();
            internal_pSubmits[i].signalSemaphoreInfoCount = internal_VkSubmitInfo2_pSignalSemaphoreInfos[i].size();
        }
        vkQueueSubmit2KHR_VkResult_return = vkEnc->vkQueueSubmit2KHR(gfxstream_queue->internal_object, submitCount, internal_pSubmits.data(), gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE, true /* do lock */);
    }
    return vkQueueSubmit2KHR_VkResult_return;
}
#endif
#ifdef VK_KHR_copy_commands2
void gfxstream_vk_CmdCopyBuffer2KHR(
    VkCommandBuffer commandBuffer,
    const VkCopyBufferInfo2* pCopyBufferInfo)
{
    MESA_TRACE_SCOPE("vkCmdCopyBuffer2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkCopyBufferInfo2> internal_pCopyBufferInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pCopyBufferInfo[i] = pCopyBufferInfo[i];
            /* VkCopyBufferInfo2::srcBuffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_srcBuffer, internal_pCopyBufferInfo[i].srcBuffer);
            internal_pCopyBufferInfo[i].srcBuffer = gfxstream_srcBuffer->internal_object;
            /* VkCopyBufferInfo2::dstBuffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, internal_pCopyBufferInfo[i].dstBuffer);
            internal_pCopyBufferInfo[i].dstBuffer = gfxstream_dstBuffer->internal_object;
        }
        vkEnc->vkCmdCopyBuffer2KHR(gfxstream_commandBuffer->internal_object, internal_pCopyBufferInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyImage2KHR(
    VkCommandBuffer commandBuffer,
    const VkCopyImageInfo2* pCopyImageInfo)
{
    MESA_TRACE_SCOPE("vkCmdCopyImage2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdCopyImage2KHR(gfxstream_commandBuffer->internal_object, pCopyImageInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyBufferToImage2KHR(
    VkCommandBuffer commandBuffer,
    const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    MESA_TRACE_SCOPE("vkCmdCopyBufferToImage2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkCopyBufferToImageInfo2> internal_pCopyBufferToImageInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pCopyBufferToImageInfo[i] = pCopyBufferToImageInfo[i];
            /* VkCopyBufferToImageInfo2::srcBuffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_srcBuffer, internal_pCopyBufferToImageInfo[i].srcBuffer);
            internal_pCopyBufferToImageInfo[i].srcBuffer = gfxstream_srcBuffer->internal_object;
        }
        vkEnc->vkCmdCopyBufferToImage2KHR(gfxstream_commandBuffer->internal_object, internal_pCopyBufferToImageInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdCopyImageToBuffer2KHR(
    VkCommandBuffer commandBuffer,
    const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    MESA_TRACE_SCOPE("vkCmdCopyImageToBuffer2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkCopyImageToBufferInfo2> internal_pCopyImageToBufferInfo(1);
        for (uint32_t i = 0; i < 1; ++i)
        {
            internal_pCopyImageToBufferInfo[i] = pCopyImageToBufferInfo[i];
            /* VkCopyImageToBufferInfo2::dstBuffer */
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_dstBuffer, internal_pCopyImageToBufferInfo[i].dstBuffer);
            internal_pCopyImageToBufferInfo[i].dstBuffer = gfxstream_dstBuffer->internal_object;
        }
        vkEnc->vkCmdCopyImageToBuffer2KHR(gfxstream_commandBuffer->internal_object, internal_pCopyImageToBufferInfo.data(), true /* do lock */);
    }
}
void gfxstream_vk_CmdBlitImage2KHR(
    VkCommandBuffer commandBuffer,
    const VkBlitImageInfo2* pBlitImageInfo)
{
    MESA_TRACE_SCOPE("vkCmdBlitImage2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBlitImage2KHR(gfxstream_commandBuffer->internal_object, pBlitImageInfo, true /* do lock */);
    }
}
void gfxstream_vk_CmdResolveImage2KHR(
    VkCommandBuffer commandBuffer,
    const VkResolveImageInfo2* pResolveImageInfo)
{
    MESA_TRACE_SCOPE("vkCmdResolveImage2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdResolveImage2KHR(gfxstream_commandBuffer->internal_object, pResolveImageInfo, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_maintenance4
void gfxstream_vk_GetDeviceBufferMemoryRequirementsKHR(
    VkDevice device,
    const VkDeviceBufferMemoryRequirements* pInfo,
    VkMemoryRequirements2* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetDeviceBufferMemoryRequirementsKHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceBufferMemoryRequirementsKHR(gfxstream_device->internal_object, pInfo, pMemoryRequirements, true /* do lock */);
    }
}
void gfxstream_vk_GetDeviceImageMemoryRequirementsKHR(
    VkDevice device,
    const VkDeviceImageMemoryRequirements* pInfo,
    VkMemoryRequirements2* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetDeviceImageMemoryRequirementsKHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceImageMemoryRequirementsKHR(gfxstream_device->internal_object, pInfo, pMemoryRequirements, true /* do lock */);
    }
}
void gfxstream_vk_GetDeviceImageSparseMemoryRequirementsKHR(
    VkDevice device,
    const VkDeviceImageMemoryRequirements* pInfo,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkGetDeviceImageSparseMemoryRequirementsKHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceImageSparseMemoryRequirementsKHR(gfxstream_device->internal_object, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_maintenance5
void gfxstream_vk_CmdBindIndexBuffer2KHR(
    VkCommandBuffer commandBuffer,
    VkBuffer buffer,
    VkDeviceSize offset,
    VkDeviceSize size,
    VkIndexType indexType)
{
    MESA_TRACE_SCOPE("vkCmdBindIndexBuffer2KHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, buffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBindIndexBuffer2KHR(gfxstream_commandBuffer->internal_object, gfxstream_buffer ? gfxstream_buffer->internal_object : VK_NULL_HANDLE, offset, size, indexType, true /* do lock */);
    }
}
void gfxstream_vk_GetRenderingAreaGranularityKHR(
    VkDevice device,
    const VkRenderingAreaInfo* pRenderingAreaInfo,
    VkExtent2D* pGranularity)
{
    MESA_TRACE_SCOPE("vkGetRenderingAreaGranularityKHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetRenderingAreaGranularityKHR(gfxstream_device->internal_object, pRenderingAreaInfo, pGranularity, true /* do lock */);
    }
}
void gfxstream_vk_GetDeviceImageSubresourceLayoutKHR(
    VkDevice device,
    const VkDeviceImageSubresourceInfo* pInfo,
    VkSubresourceLayout2* pLayout)
{
    MESA_TRACE_SCOPE("vkGetDeviceImageSubresourceLayoutKHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetDeviceImageSubresourceLayoutKHR(gfxstream_device->internal_object, pInfo, pLayout, true /* do lock */);
    }
}
void gfxstream_vk_GetImageSubresourceLayout2KHR(
    VkDevice device,
    VkImage image,
    const VkImageSubresource2* pSubresource,
    VkSubresourceLayout2* pLayout)
{
    MESA_TRACE_SCOPE("vkGetImageSubresourceLayout2KHR");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetImageSubresourceLayout2KHR(gfxstream_device->internal_object, image, pSubresource, pLayout, true /* do lock */);
    }
}
#endif
#ifdef VK_KHR_line_rasterization
void gfxstream_vk_CmdSetLineStippleKHR(
    VkCommandBuffer commandBuffer,
    uint32_t lineStippleFactor,
    uint16_t lineStipplePattern)
{
    MESA_TRACE_SCOPE("vkCmdSetLineStippleKHR");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetLineStippleKHR(gfxstream_commandBuffer->internal_object, lineStippleFactor, lineStipplePattern, true /* do lock */);
    }
}
#endif
#ifdef VK_ANDROID_native_buffer
VkResult gfxstream_vk_GetSwapchainGrallocUsageANDROID(
    VkDevice device,
    VkFormat format,
    VkImageUsageFlags imageUsage,
    int* grallocUsage)
{
    MESA_TRACE_SCOPE("vkGetSwapchainGrallocUsageANDROID");
    VkResult vkGetSwapchainGrallocUsageANDROID_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetSwapchainGrallocUsageANDROID_VkResult_return = vkEnc->vkGetSwapchainGrallocUsageANDROID(gfxstream_device->internal_object, format, imageUsage, grallocUsage, true /* do lock */);
    }
    return vkGetSwapchainGrallocUsageANDROID_VkResult_return;
}
VkResult gfxstream_vk_AcquireImageANDROID(
    VkDevice device,
    VkImage image,
    int nativeFenceFd,
    VkSemaphore semaphore,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkAcquireImageANDROID");
    VkResult vkAcquireImageANDROID_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_semaphore, gfxstream_semaphore, semaphore);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkAcquireImageANDROID_VkResult_return = vkEnc->vkAcquireImageANDROID(gfxstream_device->internal_object, image, nativeFenceFd, gfxstream_semaphore ? gfxstream_semaphore->internal_object : VK_NULL_HANDLE, gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE, true /* do lock */);
    }
    return vkAcquireImageANDROID_VkResult_return;
}
VkResult gfxstream_vk_QueueSignalReleaseImageANDROID(
    VkQueue queue,
    uint32_t waitSemaphoreCount,
    const VkSemaphore* pWaitSemaphores,
    VkImage image,
    int* pNativeFenceFd)
{
    MESA_TRACE_SCOPE("vkQueueSignalReleaseImageANDROID");
    VkResult vkQueueSignalReleaseImageANDROID_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkSemaphore> internal_pWaitSemaphores(waitSemaphoreCount);
        internal_pWaitSemaphores = transformVkSemaphoreList(pWaitSemaphores, waitSemaphoreCount);
        pWaitSemaphores = internal_pWaitSemaphores.data();
        waitSemaphoreCount = internal_pWaitSemaphores.size();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkQueueSignalReleaseImageANDROID_VkResult_return = resources->on_vkQueueSignalReleaseImageANDROID(vkEnc, VK_SUCCESS, gfxstream_queue->internal_object, waitSemaphoreCount, internal_pWaitSemaphores.data(), image, pNativeFenceFd);
    }
    return vkQueueSignalReleaseImageANDROID_VkResult_return;
}
VkResult gfxstream_vk_GetSwapchainGrallocUsage2ANDROID(
    VkDevice device,
    VkFormat format,
    VkImageUsageFlags imageUsage,
    VkSwapchainImageUsageFlagsANDROID swapchainImageUsage,
    uint64_t* grallocConsumerUsage,
    uint64_t* grallocProducerUsage)
{
    MESA_TRACE_SCOPE("vkGetSwapchainGrallocUsage2ANDROID");
    VkResult vkGetSwapchainGrallocUsage2ANDROID_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetSwapchainGrallocUsage2ANDROID_VkResult_return = vkEnc->vkGetSwapchainGrallocUsage2ANDROID(gfxstream_device->internal_object, format, imageUsage, swapchainImageUsage, grallocConsumerUsage, grallocProducerUsage, true /* do lock */);
    }
    return vkGetSwapchainGrallocUsage2ANDROID_VkResult_return;
}
#endif
#ifdef VK_EXT_transform_feedback
void gfxstream_vk_CmdBindTransformFeedbackBuffersEXT(
    VkCommandBuffer commandBuffer,
    uint32_t firstBinding,
    uint32_t bindingCount,
    const VkBuffer* pBuffers,
    const VkDeviceSize* pOffsets,
    const VkDeviceSize* pSizes)
{
    MESA_TRACE_SCOPE("vkCmdBindTransformFeedbackBuffersEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkBuffer> internal_pBuffers(bindingCount);
        for (uint32_t i = 0; i < bindingCount; ++i)
        {
            VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_pBuffers, pBuffers[i]);
            internal_pBuffers[i] = gfxstream_pBuffers->internal_object;
        }
        vkEnc->vkCmdBindTransformFeedbackBuffersEXT(gfxstream_commandBuffer->internal_object, firstBinding, bindingCount, internal_pBuffers.data(), pOffsets, pSizes, true /* do lock */);
    }
}
void gfxstream_vk_CmdEndTransformFeedbackEXT(
    VkCommandBuffer commandBuffer,
    uint32_t firstCounterBuffer,
    uint32_t counterBufferCount,
    const VkBuffer* pCounterBuffers,
    const VkDeviceSize* pCounterBufferOffsets)
{
    MESA_TRACE_SCOPE("vkCmdEndTransformFeedbackEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkBuffer> internal_pCounterBuffers(counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; ++i)
        {
            if (pCounterBuffers)
            {
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_pCounterBuffers, pCounterBuffers[i]);
                internal_pCounterBuffers[i] = gfxstream_pCounterBuffers->internal_object;
            }
        }
        vkEnc->vkCmdEndTransformFeedbackEXT(gfxstream_commandBuffer->internal_object, firstCounterBuffer, counterBufferCount, internal_pCounterBuffers.data(), pCounterBufferOffsets, true /* do lock */);
    }
}
void gfxstream_vk_CmdBeginQueryIndexedEXT(
    VkCommandBuffer commandBuffer,
    VkQueryPool queryPool,
    uint32_t query,
    VkQueryControlFlags flags,
    uint32_t index)
{
    MESA_TRACE_SCOPE("vkCmdBeginQueryIndexedEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdBeginQueryIndexedEXT(gfxstream_commandBuffer->internal_object, queryPool, query, flags, index, true /* do lock */);
    }
}
void gfxstream_vk_CmdEndQueryIndexedEXT(
    VkCommandBuffer commandBuffer,
    VkQueryPool queryPool,
    uint32_t query,
    uint32_t index)
{
    MESA_TRACE_SCOPE("vkCmdEndQueryIndexedEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdEndQueryIndexedEXT(gfxstream_commandBuffer->internal_object, queryPool, query, index, true /* do lock */);
    }
}
void gfxstream_vk_CmdDrawIndirectByteCountEXT(
    VkCommandBuffer commandBuffer,
    uint32_t instanceCount,
    uint32_t firstInstance,
    VkBuffer counterBuffer,
    VkDeviceSize counterBufferOffset,
    uint32_t counterOffset,
    uint32_t vertexStride)
{
    MESA_TRACE_SCOPE("vkCmdDrawIndirectByteCountEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_counterBuffer, counterBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdDrawIndirectByteCountEXT(gfxstream_commandBuffer->internal_object, instanceCount, firstInstance, gfxstream_counterBuffer->internal_object, counterBufferOffset, counterOffset, vertexStride, true /* do lock */);
    }
}
#endif
#ifdef VK_ANDROID_external_memory_android_hardware_buffer
VkResult gfxstream_vk_GetAndroidHardwareBufferPropertiesANDROID(
    VkDevice device,
    const AHardwareBuffer* buffer,
    VkAndroidHardwareBufferPropertiesANDROID* pProperties)
{
    MESA_TRACE_SCOPE("vkGetAndroidHardwareBufferPropertiesANDROID");
    VkResult vkGetAndroidHardwareBufferPropertiesANDROID_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetAndroidHardwareBufferPropertiesANDROID_VkResult_return = resources->on_vkGetAndroidHardwareBufferPropertiesANDROID(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, buffer, pProperties);
    }
    return vkGetAndroidHardwareBufferPropertiesANDROID_VkResult_return;
}
VkResult gfxstream_vk_GetMemoryAndroidHardwareBufferANDROID(
    VkDevice device,
    const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo,
    AHardwareBuffer** pBuffer)
{
    MESA_TRACE_SCOPE("vkGetMemoryAndroidHardwareBufferANDROID");
    VkResult vkGetMemoryAndroidHardwareBufferANDROID_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetMemoryAndroidHardwareBufferANDROID_VkResult_return = resources->on_vkGetMemoryAndroidHardwareBufferANDROID(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pInfo, pBuffer);
    }
    return vkGetMemoryAndroidHardwareBufferANDROID_VkResult_return;
}
#endif
#ifdef VK_EXT_image_drm_format_modifier
VkResult gfxstream_vk_GetImageDrmFormatModifierPropertiesEXT(
    VkDevice device,
    VkImage image,
    VkImageDrmFormatModifierPropertiesEXT* pProperties)
{
    MESA_TRACE_SCOPE("vkGetImageDrmFormatModifierPropertiesEXT");
    VkResult vkGetImageDrmFormatModifierPropertiesEXT_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkGetImageDrmFormatModifierPropertiesEXT_VkResult_return = resources->on_vkGetImageDrmFormatModifierPropertiesEXT(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, image, pProperties);
    }
    return vkGetImageDrmFormatModifierPropertiesEXT_VkResult_return;
}
#endif
#ifdef VK_EXT_tooling_info
VkResult gfxstream_vk_GetPhysicalDeviceToolPropertiesEXT(
    VkPhysicalDevice physicalDevice,
    uint32_t* pToolCount,
    VkPhysicalDeviceToolProperties* pToolProperties)
{
    MESA_TRACE_SCOPE("vkGetPhysicalDeviceToolPropertiesEXT");
    VkResult vkGetPhysicalDeviceToolPropertiesEXT_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_physical_device, gfxstream_physicalDevice, physicalDevice);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetPhysicalDeviceToolPropertiesEXT_VkResult_return = vkEnc->vkGetPhysicalDeviceToolPropertiesEXT(gfxstream_physicalDevice->internal_object, pToolCount, pToolProperties, true /* do lock */);
    }
    return vkGetPhysicalDeviceToolPropertiesEXT_VkResult_return;
}
#endif
#ifdef VK_EXT_line_rasterization
void gfxstream_vk_CmdSetLineStippleEXT(
    VkCommandBuffer commandBuffer,
    uint32_t lineStippleFactor,
    uint16_t lineStipplePattern)
{
    MESA_TRACE_SCOPE("vkCmdSetLineStippleEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetLineStippleEXT(gfxstream_commandBuffer->internal_object, lineStippleFactor, lineStipplePattern, true /* do lock */);
    }
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void gfxstream_vk_CmdSetCullModeEXT(
    VkCommandBuffer commandBuffer,
    VkCullModeFlags cullMode)
{
    MESA_TRACE_SCOPE("vkCmdSetCullModeEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetCullModeEXT(gfxstream_commandBuffer->internal_object, cullMode, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetFrontFaceEXT(
    VkCommandBuffer commandBuffer,
    VkFrontFace frontFace)
{
    MESA_TRACE_SCOPE("vkCmdSetFrontFaceEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetFrontFaceEXT(gfxstream_commandBuffer->internal_object, frontFace, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetPrimitiveTopologyEXT(
    VkCommandBuffer commandBuffer,
    VkPrimitiveTopology primitiveTopology)
{
    MESA_TRACE_SCOPE("vkCmdSetPrimitiveTopologyEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetPrimitiveTopologyEXT(gfxstream_commandBuffer->internal_object, primitiveTopology, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetViewportWithCountEXT(
    VkCommandBuffer commandBuffer,
    uint32_t viewportCount,
    const VkViewport* pViewports)
{
    MESA_TRACE_SCOPE("vkCmdSetViewportWithCountEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetViewportWithCountEXT(gfxstream_commandBuffer->internal_object, viewportCount, pViewports, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetScissorWithCountEXT(
    VkCommandBuffer commandBuffer,
    uint32_t scissorCount,
    const VkRect2D* pScissors)
{
    MESA_TRACE_SCOPE("vkCmdSetScissorWithCountEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetScissorWithCountEXT(gfxstream_commandBuffer->internal_object, scissorCount, pScissors, true /* do lock */);
    }
}
void gfxstream_vk_CmdBindVertexBuffers2EXT(
    VkCommandBuffer commandBuffer,
    uint32_t firstBinding,
    uint32_t bindingCount,
    const VkBuffer* pBuffers,
    const VkDeviceSize* pOffsets,
    const VkDeviceSize* pSizes,
    const VkDeviceSize* pStrides)
{
    MESA_TRACE_SCOPE("vkCmdBindVertexBuffers2EXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        std::vector<VkBuffer> internal_pBuffers(bindingCount);
        for (uint32_t i = 0; i < bindingCount; ++i)
        {
            if (pBuffers)
            {
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_pBuffers, pBuffers[i]);
                internal_pBuffers[i] = gfxstream_pBuffers->internal_object;
            }
        }
        vkEnc->vkCmdBindVertexBuffers2EXT(gfxstream_commandBuffer->internal_object, firstBinding, bindingCount, internal_pBuffers.data(), pOffsets, pSizes, pStrides, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthTestEnableEXT(
    VkCommandBuffer commandBuffer,
    VkBool32 depthTestEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthTestEnableEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthTestEnableEXT(gfxstream_commandBuffer->internal_object, depthTestEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthWriteEnableEXT(
    VkCommandBuffer commandBuffer,
    VkBool32 depthWriteEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthWriteEnableEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthWriteEnableEXT(gfxstream_commandBuffer->internal_object, depthWriteEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthCompareOpEXT(
    VkCommandBuffer commandBuffer,
    VkCompareOp depthCompareOp)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthCompareOpEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthCompareOpEXT(gfxstream_commandBuffer->internal_object, depthCompareOp, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthBoundsTestEnableEXT(
    VkCommandBuffer commandBuffer,
    VkBool32 depthBoundsTestEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthBoundsTestEnableEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthBoundsTestEnableEXT(gfxstream_commandBuffer->internal_object, depthBoundsTestEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetStencilTestEnableEXT(
    VkCommandBuffer commandBuffer,
    VkBool32 stencilTestEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetStencilTestEnableEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetStencilTestEnableEXT(gfxstream_commandBuffer->internal_object, stencilTestEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetStencilOpEXT(
    VkCommandBuffer commandBuffer,
    VkStencilFaceFlags faceMask,
    VkStencilOp failOp,
    VkStencilOp passOp,
    VkStencilOp depthFailOp,
    VkCompareOp compareOp)
{
    MESA_TRACE_SCOPE("vkCmdSetStencilOpEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetStencilOpEXT(gfxstream_commandBuffer->internal_object, faceMask, failOp, passOp, depthFailOp, compareOp, true /* do lock */);
    }
}
#endif
#ifdef VK_EXT_host_image_copy
VkResult gfxstream_vk_CopyMemoryToImageEXT(
    VkDevice device,
    const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo)
{
    MESA_TRACE_SCOPE("vkCopyMemoryToImageEXT");
    VkResult vkCopyMemoryToImageEXT_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCopyMemoryToImageEXT_VkResult_return = vkEnc->vkCopyMemoryToImageEXT(gfxstream_device->internal_object, pCopyMemoryToImageInfo, true /* do lock */);
    }
    return vkCopyMemoryToImageEXT_VkResult_return;
}
VkResult gfxstream_vk_CopyImageToMemoryEXT(
    VkDevice device,
    const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo)
{
    MESA_TRACE_SCOPE("vkCopyImageToMemoryEXT");
    VkResult vkCopyImageToMemoryEXT_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCopyImageToMemoryEXT_VkResult_return = vkEnc->vkCopyImageToMemoryEXT(gfxstream_device->internal_object, pCopyImageToMemoryInfo, true /* do lock */);
    }
    return vkCopyImageToMemoryEXT_VkResult_return;
}
VkResult gfxstream_vk_CopyImageToImageEXT(
    VkDevice device,
    const VkCopyImageToImageInfo* pCopyImageToImageInfo)
{
    MESA_TRACE_SCOPE("vkCopyImageToImageEXT");
    VkResult vkCopyImageToImageEXT_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCopyImageToImageEXT_VkResult_return = vkEnc->vkCopyImageToImageEXT(gfxstream_device->internal_object, pCopyImageToImageInfo, true /* do lock */);
    }
    return vkCopyImageToImageEXT_VkResult_return;
}
VkResult gfxstream_vk_TransitionImageLayoutEXT(
    VkDevice device,
    uint32_t transitionCount,
    const VkHostImageLayoutTransitionInfo* pTransitions)
{
    MESA_TRACE_SCOPE("vkTransitionImageLayoutEXT");
    VkResult vkTransitionImageLayoutEXT_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkTransitionImageLayoutEXT_VkResult_return = vkEnc->vkTransitionImageLayoutEXT(gfxstream_device->internal_object, transitionCount, pTransitions, true /* do lock */);
    }
    return vkTransitionImageLayoutEXT_VkResult_return;
}
void gfxstream_vk_GetImageSubresourceLayout2EXT(
    VkDevice device,
    VkImage image,
    const VkImageSubresource2* pSubresource,
    VkSubresourceLayout2* pLayout)
{
    MESA_TRACE_SCOPE("vkGetImageSubresourceLayout2EXT");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetImageSubresourceLayout2EXT(gfxstream_device->internal_object, image, pSubresource, pLayout, true /* do lock */);
    }
}
#endif
#ifdef VK_EXT_private_data
VkResult gfxstream_vk_CreatePrivateDataSlotEXT(
    VkDevice device,
    const VkPrivateDataSlotCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkPrivateDataSlot* pPrivateDataSlot)
{
    MESA_TRACE_SCOPE("vkCreatePrivateDataSlotEXT");
    VkResult vkCreatePrivateDataSlotEXT_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        vkCreatePrivateDataSlotEXT_VkResult_return = resources->on_vkCreatePrivateDataSlotEXT(vkEnc, VK_SUCCESS, gfxstream_device->internal_object, pCreateInfo, pAllocator, pPrivateDataSlot);
    }
    return vkCreatePrivateDataSlotEXT_VkResult_return;
}
void gfxstream_vk_DestroyPrivateDataSlotEXT(
    VkDevice device,
    VkPrivateDataSlot privateDataSlot,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkDestroyPrivateDataSlotEXT");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        auto resources = gfxstream::vk::ResourceTracker::get();
        resources->on_vkDestroyPrivateDataSlotEXT(vkEnc, gfxstream_device->internal_object, privateDataSlot, pAllocator);
    }
}
VkResult gfxstream_vk_SetPrivateDataEXT(
    VkDevice device,
    VkObjectType objectType,
    uint64_t objectHandle,
    VkPrivateDataSlot privateDataSlot,
    uint64_t data)
{
    MESA_TRACE_SCOPE("vkSetPrivateDataEXT");
    VkResult vkSetPrivateDataEXT_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkSetPrivateDataEXT_VkResult_return = vkEnc->vkSetPrivateDataEXT(gfxstream_device->internal_object, objectType, objectHandle, privateDataSlot, data, true /* do lock */);
    }
    return vkSetPrivateDataEXT_VkResult_return;
}
void gfxstream_vk_GetPrivateDataEXT(
    VkDevice device,
    VkObjectType objectType,
    uint64_t objectHandle,
    VkPrivateDataSlot privateDataSlot,
    uint64_t* pData)
{
    MESA_TRACE_SCOPE("vkGetPrivateDataEXT");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetPrivateDataEXT(gfxstream_device->internal_object, objectType, objectHandle, privateDataSlot, pData, true /* do lock */);
    }
}
#endif
#ifdef VK_EXT_extended_dynamic_state2
void gfxstream_vk_CmdSetPatchControlPointsEXT(
    VkCommandBuffer commandBuffer,
    uint32_t patchControlPoints)
{
    MESA_TRACE_SCOPE("vkCmdSetPatchControlPointsEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetPatchControlPointsEXT(gfxstream_commandBuffer->internal_object, patchControlPoints, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetRasterizerDiscardEnableEXT(
    VkCommandBuffer commandBuffer,
    VkBool32 rasterizerDiscardEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetRasterizerDiscardEnableEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetRasterizerDiscardEnableEXT(gfxstream_commandBuffer->internal_object, rasterizerDiscardEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetDepthBiasEnableEXT(
    VkCommandBuffer commandBuffer,
    VkBool32 depthBiasEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetDepthBiasEnableEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetDepthBiasEnableEXT(gfxstream_commandBuffer->internal_object, depthBiasEnable, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetLogicOpEXT(
    VkCommandBuffer commandBuffer,
    VkLogicOp logicOp)
{
    MESA_TRACE_SCOPE("vkCmdSetLogicOpEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetLogicOpEXT(gfxstream_commandBuffer->internal_object, logicOp, true /* do lock */);
    }
}
void gfxstream_vk_CmdSetPrimitiveRestartEnableEXT(
    VkCommandBuffer commandBuffer,
    VkBool32 primitiveRestartEnable)
{
    MESA_TRACE_SCOPE("vkCmdSetPrimitiveRestartEnableEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetPrimitiveRestartEnableEXT(gfxstream_commandBuffer->internal_object, primitiveRestartEnable, true /* do lock */);
    }
}
#endif
#ifdef VK_EXT_color_write_enable
void gfxstream_vk_CmdSetColorWriteEnableEXT(
    VkCommandBuffer commandBuffer,
    uint32_t attachmentCount,
    const VkBool32* pColorWriteEnables)
{
    MESA_TRACE_SCOPE("vkCmdSetColorWriteEnableEXT");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCmdSetColorWriteEnableEXT(gfxstream_commandBuffer->internal_object, attachmentCount, pColorWriteEnables, true /* do lock */);
    }
}
#endif
#ifdef VK_GOOGLE_gfxstream
VkResult gfxstream_vk_MapMemoryIntoAddressSpaceGOOGLE(
    VkDevice device,
    VkDeviceMemory memory,
    uint64_t* pAddress)
{
    MESA_TRACE_SCOPE("vkMapMemoryIntoAddressSpaceGOOGLE");
    VkResult vkMapMemoryIntoAddressSpaceGOOGLE_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkMapMemoryIntoAddressSpaceGOOGLE_VkResult_return = vkEnc->vkMapMemoryIntoAddressSpaceGOOGLE(gfxstream_device->internal_object, memory, pAddress, true /* do lock */);
    }
    return vkMapMemoryIntoAddressSpaceGOOGLE_VkResult_return;
}
void gfxstream_vk_UpdateDescriptorSetWithTemplateSizedGOOGLE(
    VkDevice device,
    VkDescriptorSet descriptorSet,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    uint32_t imageInfoCount,
    uint32_t bufferInfoCount,
    uint32_t bufferViewCount,
    const uint32_t* pImageInfoEntryIndices,
    const uint32_t* pBufferInfoEntryIndices,
    const uint32_t* pBufferViewEntryIndices,
    const VkDescriptorImageInfo* pImageInfos,
    const VkDescriptorBufferInfo* pBufferInfos,
    const VkBufferView* pBufferViews)
{
    MESA_TRACE_SCOPE("vkUpdateDescriptorSetWithTemplateSizedGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkDescriptorBufferInfo> internal_pBufferInfos(bufferInfoCount);
        for (uint32_t i = 0; i < bufferInfoCount; ++i)
        {
            if (pBufferInfos)
            {
                internal_pBufferInfos[i] = pBufferInfos[i];
                /* VkDescriptorBufferInfo::buffer */
                if (internal_pBufferInfos[i].buffer)
                {
                    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pBufferInfos[i].buffer);
                    internal_pBufferInfos[i].buffer = gfxstream_buffer->internal_object;
                }
            }
        }
        vkEnc->vkUpdateDescriptorSetWithTemplateSizedGOOGLE(gfxstream_device->internal_object, descriptorSet, descriptorUpdateTemplate, imageInfoCount, bufferInfoCount, bufferViewCount, pImageInfoEntryIndices, pBufferInfoEntryIndices, pBufferViewEntryIndices, pImageInfos, internal_pBufferInfos.data(), pBufferViews, true /* do lock */);
    }
}
void gfxstream_vk_BeginCommandBufferAsyncGOOGLE(
    VkCommandBuffer commandBuffer,
    const VkCommandBufferBeginInfo* pBeginInfo)
{
    MESA_TRACE_SCOPE("vkBeginCommandBufferAsyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkBeginCommandBufferAsyncGOOGLE(gfxstream_commandBuffer->internal_object, pBeginInfo, true /* do lock */);
    }
}
void gfxstream_vk_EndCommandBufferAsyncGOOGLE(
    VkCommandBuffer commandBuffer)
{
    MESA_TRACE_SCOPE("vkEndCommandBufferAsyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkEndCommandBufferAsyncGOOGLE(gfxstream_commandBuffer->internal_object, true /* do lock */);
    }
}
void gfxstream_vk_ResetCommandBufferAsyncGOOGLE(
    VkCommandBuffer commandBuffer,
    VkCommandBufferResetFlags flags)
{
    MESA_TRACE_SCOPE("vkResetCommandBufferAsyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkResetCommandBufferAsyncGOOGLE(gfxstream_commandBuffer->internal_object, flags, true /* do lock */);
    }
}
void gfxstream_vk_CommandBufferHostSyncGOOGLE(
    VkCommandBuffer commandBuffer,
    uint32_t needHostSync,
    uint32_t sequenceNumber)
{
    MESA_TRACE_SCOPE("vkCommandBufferHostSyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getCommandBufferEncoder(gfxstream_commandBuffer->internal_object);
        vkEnc->vkCommandBufferHostSyncGOOGLE(gfxstream_commandBuffer->internal_object, needHostSync, sequenceNumber, true /* do lock */);
    }
}
VkResult gfxstream_vk_CreateImageWithRequirementsGOOGLE(
    VkDevice device,
    const VkImageCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkImage* pImage,
    VkMemoryRequirements* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkCreateImageWithRequirementsGOOGLE");
    VkResult vkCreateImageWithRequirementsGOOGLE_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateImageWithRequirementsGOOGLE_VkResult_return = vkEnc->vkCreateImageWithRequirementsGOOGLE(gfxstream_device->internal_object, pCreateInfo, pAllocator, pImage, pMemoryRequirements, true /* do lock */);
    }
    return vkCreateImageWithRequirementsGOOGLE_VkResult_return;
}
VkResult gfxstream_vk_CreateBufferWithRequirementsGOOGLE(
    VkDevice device,
    const VkBufferCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkBuffer* pBuffer,
    VkMemoryRequirements* pMemoryRequirements)
{
    MESA_TRACE_SCOPE("vkCreateBufferWithRequirementsGOOGLE");
    VkResult vkCreateBufferWithRequirementsGOOGLE_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    struct gfxstream_vk_buffer *gfxstream_pBuffer = (gfxstream_vk_buffer *)vk_object_zalloc(&gfxstream_device->vk, pAllocator, sizeof(gfxstream_vk_buffer), VK_OBJECT_TYPE_BUFFER);
    vkCreateBufferWithRequirementsGOOGLE_VkResult_return = gfxstream_pBuffer ? VK_SUCCESS : VK_ERROR_OUT_OF_HOST_MEMORY;
    if (VK_SUCCESS == vkCreateBufferWithRequirementsGOOGLE_VkResult_return)
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkCreateBufferWithRequirementsGOOGLE_VkResult_return = vkEnc->vkCreateBufferWithRequirementsGOOGLE(gfxstream_device->internal_object, pCreateInfo, pAllocator, &gfxstream_pBuffer->internal_object, pMemoryRequirements, true /* do lock */);
    }
    *pBuffer = gfxstream_vk_buffer_to_handle(gfxstream_pBuffer);
    return vkCreateBufferWithRequirementsGOOGLE_VkResult_return;
}
VkResult gfxstream_vk_GetMemoryHostAddressInfoGOOGLE(
    VkDevice device,
    VkDeviceMemory memory,
    uint64_t* pAddress,
    uint64_t* pSize,
    uint64_t* pHostmemId)
{
    MESA_TRACE_SCOPE("vkGetMemoryHostAddressInfoGOOGLE");
    VkResult vkGetMemoryHostAddressInfoGOOGLE_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetMemoryHostAddressInfoGOOGLE_VkResult_return = vkEnc->vkGetMemoryHostAddressInfoGOOGLE(gfxstream_device->internal_object, memory, pAddress, pSize, pHostmemId, true /* do lock */);
    }
    return vkGetMemoryHostAddressInfoGOOGLE_VkResult_return;
}
VkResult gfxstream_vk_FreeMemorySyncGOOGLE(
    VkDevice device,
    VkDeviceMemory memory,
    const VkAllocationCallbacks* pAllocator)
{
    MESA_TRACE_SCOPE("vkFreeMemorySyncGOOGLE");
    VkResult vkFreeMemorySyncGOOGLE_VkResult_return = (VkResult)0;
    if (VK_NULL_HANDLE == memory)
    {
        return vkFreeMemorySyncGOOGLE_VkResult_return;
    }
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkFreeMemorySyncGOOGLE_VkResult_return = vkEnc->vkFreeMemorySyncGOOGLE(gfxstream_device->internal_object, memory, pAllocator, true /* do lock */);
    }
    return vkFreeMemorySyncGOOGLE_VkResult_return;
}
void gfxstream_vk_QueueHostSyncGOOGLE(
    VkQueue queue,
    uint32_t needHostSync,
    uint32_t sequenceNumber)
{
    MESA_TRACE_SCOPE("vkQueueHostSyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        vkEnc->vkQueueHostSyncGOOGLE(gfxstream_queue->internal_object, needHostSync, sequenceNumber, true /* do lock */);
    }
}
void gfxstream_vk_QueueSubmitAsyncGOOGLE(
    VkQueue queue,
    uint32_t submitCount,
    const VkSubmitInfo* pSubmits,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkQueueSubmitAsyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkSubmitInfo> internal_pSubmits(submitCount);
        std::vector<std::vector<VkSemaphore>> internal_VkSubmitInfo_pWaitSemaphores;
        std::vector<std::vector<VkCommandBuffer>> internal_VkSubmitInfo_pCommandBuffers;
        std::vector<std::vector<VkSemaphore>> internal_VkSubmitInfo_pSignalSemaphores;
        for (uint32_t i = 0; i < submitCount; ++i)
        {
            internal_pSubmits[i] = pSubmits[i];
            /* VkSubmitInfo::pWaitSemaphores */
            internal_VkSubmitInfo_pWaitSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkSubmitInfo_pWaitSemaphores[i] = transformVkSemaphoreList(internal_pSubmits[i].pWaitSemaphores, internal_pSubmits[i].waitSemaphoreCount);
            internal_pSubmits[i].pWaitSemaphores = internal_VkSubmitInfo_pWaitSemaphores[i].data();
            internal_pSubmits[i].waitSemaphoreCount = internal_VkSubmitInfo_pWaitSemaphores[i].size();
            /* VkSubmitInfo::pCommandBuffers */
            internal_VkSubmitInfo_pCommandBuffers.push_back(std::vector<VkCommandBuffer>());
            internal_VkSubmitInfo_pCommandBuffers[i].resize(internal_pSubmits[i].commandBufferCount);
            for (uint32_t j = 0; j < internal_pSubmits[i].commandBufferCount; ++j)
            {
                VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_pCommandBuffers, internal_pSubmits[i].pCommandBuffers[j]);
                internal_VkSubmitInfo_pCommandBuffers[i][j] = gfxstream_pCommandBuffers->internal_object;
            }
            internal_pSubmits[i].pCommandBuffers = internal_VkSubmitInfo_pCommandBuffers[i].data();
            /* VkSubmitInfo::pSignalSemaphores */
            internal_VkSubmitInfo_pSignalSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkSubmitInfo_pSignalSemaphores[i] = transformVkSemaphoreList(internal_pSubmits[i].pSignalSemaphores, internal_pSubmits[i].signalSemaphoreCount);
            internal_pSubmits[i].pSignalSemaphores = internal_VkSubmitInfo_pSignalSemaphores[i].data();
            internal_pSubmits[i].signalSemaphoreCount = internal_VkSubmitInfo_pSignalSemaphores[i].size();
        }
        vkEnc->vkQueueSubmitAsyncGOOGLE(gfxstream_queue->internal_object, submitCount, internal_pSubmits.data(), gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE, true /* do lock */);
    }
}
void gfxstream_vk_QueueWaitIdleAsyncGOOGLE(
    VkQueue queue)
{
    MESA_TRACE_SCOPE("vkQueueWaitIdleAsyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        vkEnc->vkQueueWaitIdleAsyncGOOGLE(gfxstream_queue->internal_object, true /* do lock */);
    }
}
void gfxstream_vk_QueueBindSparseAsyncGOOGLE(
    VkQueue queue,
    uint32_t bindInfoCount,
    const VkBindSparseInfo* pBindInfo,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkQueueBindSparseAsyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkBindSparseInfo> internal_pBindInfo(bindInfoCount);
        std::vector<std::vector<VkSemaphore>> internal_VkBindSparseInfo_pWaitSemaphores;
        std::vector<std::vector<VkSparseBufferMemoryBindInfo>> internal_VkBindSparseInfo_pBufferBinds;
        std::vector<std::vector<VkSemaphore>> internal_VkBindSparseInfo_pSignalSemaphores;
        for (uint32_t i = 0; i < bindInfoCount; ++i)
        {
            internal_pBindInfo[i] = pBindInfo[i];
            /* VkBindSparseInfo::pWaitSemaphores */
            internal_VkBindSparseInfo_pWaitSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkBindSparseInfo_pWaitSemaphores[i] = transformVkSemaphoreList(internal_pBindInfo[i].pWaitSemaphores, internal_pBindInfo[i].waitSemaphoreCount);
            internal_pBindInfo[i].pWaitSemaphores = internal_VkBindSparseInfo_pWaitSemaphores[i].data();
            internal_pBindInfo[i].waitSemaphoreCount = internal_VkBindSparseInfo_pWaitSemaphores[i].size();
            /* VkBindSparseInfo::pBufferBinds */
            internal_VkBindSparseInfo_pBufferBinds.push_back(std::vector<VkSparseBufferMemoryBindInfo>());
            internal_VkBindSparseInfo_pBufferBinds[i].resize(internal_pBindInfo[i].bufferBindCount);
            for (uint32_t j = 0; j < internal_pBindInfo[i].bufferBindCount; ++j)
            {
                internal_VkBindSparseInfo_pBufferBinds[i][j] = internal_pBindInfo[i].pBufferBinds[j];
                /* VkSparseBufferMemoryBindInfo::buffer */
                VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkBindSparseInfo_pBufferBinds[i][j].buffer);
                internal_VkBindSparseInfo_pBufferBinds[i][j].buffer = gfxstream_buffer->internal_object;
            }
            internal_pBindInfo[i].pBufferBinds = internal_VkBindSparseInfo_pBufferBinds[i].data();
            /* VkBindSparseInfo::pSignalSemaphores */
            internal_VkBindSparseInfo_pSignalSemaphores.push_back(std::vector<VkSemaphore>());
            internal_VkBindSparseInfo_pSignalSemaphores[i] = transformVkSemaphoreList(internal_pBindInfo[i].pSignalSemaphores, internal_pBindInfo[i].signalSemaphoreCount);
            internal_pBindInfo[i].pSignalSemaphores = internal_VkBindSparseInfo_pSignalSemaphores[i].data();
            internal_pBindInfo[i].signalSemaphoreCount = internal_VkBindSparseInfo_pSignalSemaphores[i].size();
        }
        vkEnc->vkQueueBindSparseAsyncGOOGLE(gfxstream_queue->internal_object, bindInfoCount, internal_pBindInfo.data(), gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE, true /* do lock */);
    }
}
void gfxstream_vk_GetLinearImageLayoutGOOGLE(
    VkDevice device,
    VkFormat format,
    VkDeviceSize* pOffset,
    VkDeviceSize* pRowPitchAlignment)
{
    MESA_TRACE_SCOPE("vkGetLinearImageLayoutGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetLinearImageLayoutGOOGLE(gfxstream_device->internal_object, format, pOffset, pRowPitchAlignment, true /* do lock */);
    }
}
void gfxstream_vk_GetLinearImageLayout2GOOGLE(
    VkDevice device,
    const VkImageCreateInfo* pCreateInfo,
    VkDeviceSize* pOffset,
    VkDeviceSize* pRowPitchAlignment)
{
    MESA_TRACE_SCOPE("vkGetLinearImageLayout2GOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkGetLinearImageLayout2GOOGLE(gfxstream_device->internal_object, pCreateInfo, pOffset, pRowPitchAlignment, true /* do lock */);
    }
}
void gfxstream_vk_QueueFlushCommandsGOOGLE(
    VkQueue queue,
    VkCommandBuffer commandBuffer,
    VkDeviceSize dataSize,
    const void* pData)
{
    MESA_TRACE_SCOPE("vkQueueFlushCommandsGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        vkEnc->vkQueueFlushCommandsGOOGLE(gfxstream_queue->internal_object, gfxstream_commandBuffer->internal_object, dataSize, pData, true /* do lock */);
    }
}
void gfxstream_vk_QueueCommitDescriptorSetUpdatesGOOGLE(
    VkQueue queue,
    uint32_t descriptorPoolCount,
    const VkDescriptorPool* pDescriptorPools,
    uint32_t descriptorSetCount,
    const VkDescriptorSetLayout* pSetLayouts,
    const uint64_t* pDescriptorSetPoolIds,
    const uint32_t* pDescriptorSetWhichPool,
    const uint32_t* pDescriptorSetPendingAllocation,
    const uint32_t* pDescriptorWriteStartingIndices,
    uint32_t pendingDescriptorWriteCount,
    const VkWriteDescriptorSet* pPendingDescriptorWrites)
{
    MESA_TRACE_SCOPE("vkQueueCommitDescriptorSetUpdatesGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkWriteDescriptorSet> internal_pPendingDescriptorWrites(pendingDescriptorWriteCount);
        std::vector<std::vector<VkDescriptorBufferInfo>> internal_VkWriteDescriptorSet_pBufferInfo;
        for (uint32_t i = 0; i < pendingDescriptorWriteCount; ++i)
        {
            internal_pPendingDescriptorWrites[i] = pPendingDescriptorWrites[i];
            /* VkWriteDescriptorSet::pBufferInfo */
            internal_VkWriteDescriptorSet_pBufferInfo.push_back(std::vector<VkDescriptorBufferInfo>());
            internal_VkWriteDescriptorSet_pBufferInfo[i].resize(internal_pPendingDescriptorWrites[i].descriptorCount);
            for (uint32_t j = 0; j < internal_pPendingDescriptorWrites[i].descriptorCount; ++j)
            {
                if (internal_pPendingDescriptorWrites[i].pBufferInfo)
                {
                    internal_VkWriteDescriptorSet_pBufferInfo[i][j] = internal_pPendingDescriptorWrites[i].pBufferInfo[j];
                    /* VkDescriptorBufferInfo::buffer */
                    if (internal_VkWriteDescriptorSet_pBufferInfo[i][j].buffer)
                    {
                        VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_VkWriteDescriptorSet_pBufferInfo[i][j].buffer);
                        internal_VkWriteDescriptorSet_pBufferInfo[i][j].buffer = gfxstream_buffer->internal_object;
                    }
                }
            }
            internal_pPendingDescriptorWrites[i].pBufferInfo = internal_VkWriteDescriptorSet_pBufferInfo[i].data();
        }
        vkEnc->vkQueueCommitDescriptorSetUpdatesGOOGLE(gfxstream_queue->internal_object, descriptorPoolCount, pDescriptorPools, descriptorSetCount, pSetLayouts, pDescriptorSetPoolIds, pDescriptorSetWhichPool, pDescriptorSetPendingAllocation, pDescriptorWriteStartingIndices, pendingDescriptorWriteCount, internal_pPendingDescriptorWrites.data(), true /* do lock */);
    }
}
void gfxstream_vk_CollectDescriptorPoolIdsGOOGLE(
    VkDevice device,
    VkDescriptorPool descriptorPool,
    uint32_t* pPoolIdCount,
    uint64_t* pPoolIds)
{
    MESA_TRACE_SCOPE("vkCollectDescriptorPoolIdsGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkCollectDescriptorPoolIdsGOOGLE(gfxstream_device->internal_object, descriptorPool, pPoolIdCount, pPoolIds, true /* do lock */);
    }
}
void gfxstream_vk_QueueSignalReleaseImageANDROIDAsyncGOOGLE(
    VkQueue queue,
    uint32_t waitSemaphoreCount,
    const VkSemaphore* pWaitSemaphores,
    VkImage image)
{
    MESA_TRACE_SCOPE("vkQueueSignalReleaseImageANDROIDAsyncGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkSemaphore> internal_pWaitSemaphores(waitSemaphoreCount);
        internal_pWaitSemaphores = transformVkSemaphoreList(pWaitSemaphores, waitSemaphoreCount);
        pWaitSemaphores = internal_pWaitSemaphores.data();
        waitSemaphoreCount = internal_pWaitSemaphores.size();
        vkEnc->vkQueueSignalReleaseImageANDROIDAsyncGOOGLE(gfxstream_queue->internal_object, waitSemaphoreCount, internal_pWaitSemaphores.data(), image, true /* do lock */);
    }
}
void gfxstream_vk_QueueFlushCommandsFromAuxMemoryGOOGLE(
    VkQueue queue,
    VkCommandBuffer commandBuffer,
    VkDeviceMemory deviceMemory,
    VkDeviceSize dataOffset,
    VkDeviceSize dataSize)
{
    MESA_TRACE_SCOPE("vkQueueFlushCommandsFromAuxMemoryGOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, commandBuffer);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        vkEnc->vkQueueFlushCommandsFromAuxMemoryGOOGLE(gfxstream_queue->internal_object, gfxstream_commandBuffer->internal_object, deviceMemory, dataOffset, dataSize, true /* do lock */);
    }
}
VkResult gfxstream_vk_GetBlobGOOGLE(
    VkDevice device,
    VkDeviceMemory memory)
{
    MESA_TRACE_SCOPE("vkGetBlobGOOGLE");
    VkResult vkGetBlobGOOGLE_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetBlobGOOGLE_VkResult_return = vkEnc->vkGetBlobGOOGLE(gfxstream_device->internal_object, memory, true /* do lock */);
    }
    return vkGetBlobGOOGLE_VkResult_return;
}
void gfxstream_vk_UpdateDescriptorSetWithTemplateSized2GOOGLE(
    VkDevice device,
    VkDescriptorSet descriptorSet,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    uint32_t imageInfoCount,
    uint32_t bufferInfoCount,
    uint32_t bufferViewCount,
    uint32_t inlineUniformBlockCount,
    const uint32_t* pImageInfoEntryIndices,
    const uint32_t* pBufferInfoEntryIndices,
    const uint32_t* pBufferViewEntryIndices,
    const VkDescriptorImageInfo* pImageInfos,
    const VkDescriptorBufferInfo* pBufferInfos,
    const VkBufferView* pBufferViews,
    const uint8_t* pInlineUniformBlockData)
{
    MESA_TRACE_SCOPE("vkUpdateDescriptorSetWithTemplateSized2GOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        std::vector<VkDescriptorBufferInfo> internal_pBufferInfos(bufferInfoCount);
        for (uint32_t i = 0; i < bufferInfoCount; ++i)
        {
            if (pBufferInfos)
            {
                internal_pBufferInfos[i] = pBufferInfos[i];
                /* VkDescriptorBufferInfo::buffer */
                if (internal_pBufferInfos[i].buffer)
                {
                    VK_FROM_HANDLE(gfxstream_vk_buffer, gfxstream_buffer, internal_pBufferInfos[i].buffer);
                    internal_pBufferInfos[i].buffer = gfxstream_buffer->internal_object;
                }
            }
        }
        vkEnc->vkUpdateDescriptorSetWithTemplateSized2GOOGLE(gfxstream_device->internal_object, descriptorSet, descriptorUpdateTemplate, imageInfoCount, bufferInfoCount, bufferViewCount, inlineUniformBlockCount, pImageInfoEntryIndices, pBufferInfoEntryIndices, pBufferViewEntryIndices, pImageInfos, internal_pBufferInfos.data(), pBufferViews, pInlineUniformBlockData, true /* do lock */);
    }
}
void gfxstream_vk_QueueSubmitAsync2GOOGLE(
    VkQueue queue,
    uint32_t submitCount,
    const VkSubmitInfo2* pSubmits,
    VkFence fence)
{
    MESA_TRACE_SCOPE("vkQueueSubmitAsync2GOOGLE");
    VK_FROM_HANDLE(gfxstream_vk_queue, gfxstream_queue, queue);
    VK_FROM_HANDLE(gfxstream_vk_fence, gfxstream_fence, fence);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getQueueEncoder(gfxstream_queue->internal_object);
        std::vector<VkSubmitInfo2> internal_pSubmits(submitCount);
        std::vector<std::vector<VkSemaphoreSubmitInfo>> internal_VkSubmitInfo2_pWaitSemaphoreInfos;
        std::vector<std::vector<VkCommandBufferSubmitInfo>> internal_VkSubmitInfo2_pCommandBufferInfos;
        std::vector<std::vector<VkSemaphoreSubmitInfo>> internal_VkSubmitInfo2_pSignalSemaphoreInfos;
        for (uint32_t i = 0; i < submitCount; ++i)
        {
            internal_pSubmits[i] = pSubmits[i];
            /* VkSubmitInfo2::pWaitSemaphoreInfos */
            internal_VkSubmitInfo2_pWaitSemaphoreInfos.push_back(std::vector<VkSemaphoreSubmitInfo>());
            internal_VkSubmitInfo2_pWaitSemaphoreInfos[i] = transformVkSemaphoreSubmitInfoList(internal_pSubmits[i].pWaitSemaphoreInfos, internal_pSubmits[i].waitSemaphoreInfoCount);
            internal_pSubmits[i].pWaitSemaphoreInfos = internal_VkSubmitInfo2_pWaitSemaphoreInfos[i].data();
            internal_pSubmits[i].waitSemaphoreInfoCount = internal_VkSubmitInfo2_pWaitSemaphoreInfos[i].size();
            /* VkSubmitInfo2::pCommandBufferInfos */
            internal_VkSubmitInfo2_pCommandBufferInfos.push_back(std::vector<VkCommandBufferSubmitInfo>());
            internal_VkSubmitInfo2_pCommandBufferInfos[i].resize(internal_pSubmits[i].commandBufferInfoCount);
            for (uint32_t j = 0; j < internal_pSubmits[i].commandBufferInfoCount; ++j)
            {
                internal_VkSubmitInfo2_pCommandBufferInfos[i][j] = internal_pSubmits[i].pCommandBufferInfos[j];
                /* VkCommandBufferSubmitInfo::commandBuffer */
                VK_FROM_HANDLE(gfxstream_vk_command_buffer, gfxstream_commandBuffer, internal_VkSubmitInfo2_pCommandBufferInfos[i][j].commandBuffer);
                internal_VkSubmitInfo2_pCommandBufferInfos[i][j].commandBuffer = gfxstream_commandBuffer->internal_object;
            }
            internal_pSubmits[i].pCommandBufferInfos = internal_VkSubmitInfo2_pCommandBufferInfos[i].data();
            /* VkSubmitInfo2::pSignalSemaphoreInfos */
            internal_VkSubmitInfo2_pSignalSemaphoreInfos.push_back(std::vector<VkSemaphoreSubmitInfo>());
            internal_VkSubmitInfo2_pSignalSemaphoreInfos[i] = transformVkSemaphoreSubmitInfoList(internal_pSubmits[i].pSignalSemaphoreInfos, internal_pSubmits[i].signalSemaphoreInfoCount);
            internal_pSubmits[i].pSignalSemaphoreInfos = internal_VkSubmitInfo2_pSignalSemaphoreInfos[i].data();
            internal_pSubmits[i].signalSemaphoreInfoCount = internal_VkSubmitInfo2_pSignalSemaphoreInfos[i].size();
        }
        vkEnc->vkQueueSubmitAsync2GOOGLE(gfxstream_queue->internal_object, submitCount, internal_pSubmits.data(), gfxstream_fence ? gfxstream_fence->internal_object : VK_NULL_HANDLE, true /* do lock */);
    }
}
VkResult gfxstream_vk_GetSemaphoreGOOGLE(
    VkDevice device,
    VkSemaphore semaphore,
    uint64_t syncId)
{
    MESA_TRACE_SCOPE("vkGetSemaphoreGOOGLE");
    VkResult vkGetSemaphoreGOOGLE_VkResult_return = (VkResult)0;
    VK_FROM_HANDLE(gfxstream_vk_device, gfxstream_device, device);
    VK_FROM_HANDLE(gfxstream_vk_semaphore, gfxstream_semaphore, semaphore);
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkGetSemaphoreGOOGLE_VkResult_return = vkEnc->vkGetSemaphoreGOOGLE(gfxstream_device->internal_object, gfxstream_semaphore->internal_object, syncId, true /* do lock */);
    }
    return vkGetSemaphoreGOOGLE_VkResult_return;
}
void gfxstream_vk_TraceAsyncGOOGLE(
    uint64_t id)
{
    MESA_TRACE_SCOPE("vkTraceAsyncGOOGLE");
    {
        auto vkEnc = gfxstream::vk::ResourceTracker::getThreadLocalEncoder();
        vkEnc->vkTraceAsyncGOOGLE(id, true /* do lock */);
    }
}
#endif
