#include "nv_push_cla0b5.h"

#include <stdio.h>





const char *P_PARSE_NV90B5_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NV90B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVA0B5_MTHD(uint16_t idx)
{
    switch (idx) {

  
        
    case NVA0B5_NOP:

        
    case NVA0B5_PM_TRIGGER:

        
    case NVA0B5_SET_SEMAPHORE_A:

        
    case NVA0B5_SET_SEMAPHORE_B:

        
    case NVA0B5_SET_SEMAPHORE_PAYLOAD:

        
    case NVA0B5_SET_RENDER_ENABLE_A:

        
    case NVA0B5_SET_RENDER_ENABLE_B:

        
    case NVA0B5_SET_RENDER_ENABLE_C:

        
    case NVA0B5_OFFSET_IN_UPPER:

        
    case NVA0B5_OFFSET_IN_LOWER:

        
    case NVA0B5_OFFSET_OUT_UPPER:

        
    case NVA0B5_OFFSET_OUT_LOWER:

        
    case NVA0B5_PITCH_IN:

        
    case NVA0B5_PITCH_OUT:

        
    case NVA0B5_LINE_LENGTH_IN:

        
    case NVA0B5_LINE_COUNT:

        
    case NVA0B5_SET_REMAP_CONST_A:

        
    case NVA0B5_SET_REMAP_CONST_B:

        
    case NVA0B5_SET_REMAP_COMPONENTS:

        
    case NVA0B5_SET_DST_BLOCK_SIZE:

        
    case NVA0B5_SET_DST_WIDTH:

        
    case NVA0B5_SET_DST_HEIGHT:

        
    case NVA0B5_SET_DST_DEPTH:

        
    case NVA0B5_SET_DST_LAYER:

        
    case NVA0B5_SET_DST_ORIGIN:

        
    case NVA0B5_SET_SRC_BLOCK_SIZE:

        
    case NVA0B5_SET_SRC_WIDTH:

        
    case NVA0B5_SET_SRC_HEIGHT:

        
    case NVA0B5_SET_SRC_DEPTH:

        
    case NVA0B5_SET_SRC_LAYER:

        
    case NVA0B5_SET_SRC_ORIGIN:

        
    case NVA0B5_PM_TRIGGER_END:


    return P_PARSE_NV90B5_MTHD(idx);

                                    case NVA0B5_SET_SRC_PHYS_MODE:
        return "NVA0B5_SET_SRC_PHYS_MODE";
    case NVA0B5_SET_DST_PHYS_MODE:
        return "NVA0B5_SET_DST_PHYS_MODE";
    case NVA0B5_LAUNCH_DMA:
        return "NVA0B5_LAUNCH_DMA";
                                                                                                
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVA0B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
        
    case NVA0B5_NOP:

        
    case NVA0B5_PM_TRIGGER:

        
    case NVA0B5_SET_SEMAPHORE_A:

        
    case NVA0B5_SET_SEMAPHORE_B:

        
    case NVA0B5_SET_SEMAPHORE_PAYLOAD:

        
    case NVA0B5_SET_RENDER_ENABLE_A:

        
    case NVA0B5_SET_RENDER_ENABLE_B:

        
    case NVA0B5_SET_RENDER_ENABLE_C:

        
    case NVA0B5_OFFSET_IN_UPPER:

        
    case NVA0B5_OFFSET_IN_LOWER:

        
    case NVA0B5_OFFSET_OUT_UPPER:

        
    case NVA0B5_OFFSET_OUT_LOWER:

        
    case NVA0B5_PITCH_IN:

        
    case NVA0B5_PITCH_OUT:

        
    case NVA0B5_LINE_LENGTH_IN:

        
    case NVA0B5_LINE_COUNT:

        
    case NVA0B5_SET_REMAP_CONST_A:

        
    case NVA0B5_SET_REMAP_CONST_B:

        
    case NVA0B5_SET_REMAP_COMPONENTS:

        
    case NVA0B5_SET_DST_BLOCK_SIZE:

        
    case NVA0B5_SET_DST_WIDTH:

        
    case NVA0B5_SET_DST_HEIGHT:

        
    case NVA0B5_SET_DST_DEPTH:

        
    case NVA0B5_SET_DST_LAYER:

        
    case NVA0B5_SET_DST_ORIGIN:

        
    case NVA0B5_SET_SRC_BLOCK_SIZE:

        
    case NVA0B5_SET_SRC_WIDTH:

        
    case NVA0B5_SET_SRC_HEIGHT:

        
    case NVA0B5_SET_SRC_DEPTH:

        
    case NVA0B5_SET_SRC_LAYER:

        
    case NVA0B5_SET_SRC_ORIGIN:

        
    case NVA0B5_PM_TRIGGER_END:


    P_DUMP_NV90B5_MTHD_DATA(fp, idx, data, prefix);
    break;

                                  
    case NVA0B5_SET_SRC_PHYS_MODE:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.TARGET = ", prefix);
        switch (parsed) {
        case NVA0B5_SET_SRC_PHYS_MODE_TARGET_LOCAL_FB:
            fprintf(fp, "LOCAL_FB\n");
            break;
        case NVA0B5_SET_SRC_PHYS_MODE_TARGET_COHERENT_SYSMEM:
            fprintf(fp, "COHERENT_SYSMEM\n");
            break;
        case NVA0B5_SET_SRC_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM:
            fprintf(fp, "NONCOHERENT_SYSMEM\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVA0B5_SET_DST_PHYS_MODE:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.TARGET = ", prefix);
        switch (parsed) {
        case NVA0B5_SET_DST_PHYS_MODE_TARGET_LOCAL_FB:
            fprintf(fp, "LOCAL_FB\n");
            break;
        case NVA0B5_SET_DST_PHYS_MODE_TARGET_COHERENT_SYSMEM:
            fprintf(fp, "COHERENT_SYSMEM\n");
            break;
        case NVA0B5_SET_DST_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM:
            fprintf(fp, "NONCOHERENT_SYSMEM\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVA0B5_LAUNCH_DMA:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.DATA_TRANSFER_TYPE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED:
            fprintf(fp, "PIPELINED\n");
            break;
        case NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED:
            fprintf(fp, "NON_PIPELINED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_ENABLE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_FLUSH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA0B5_LAUNCH_DMA_FLUSH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 2) - 1);
        fprintf(fp, "%s.SEMAPHORE_TYPE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE:
            fprintf(fp, "RELEASE_ONE_WORD_SEMAPHORE\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE:
            fprintf(fp, "RELEASE_FOUR_WORD_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING:
            fprintf(fp, "BLOCKING\n");
            break;
        case NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING:
            fprintf(fp, "NON_BLOCKING\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVA0B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVA0B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.MULTI_LINE_ENABLE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA0B5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.REMAP_ENABLE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_REMAP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA0B5_LAUNCH_DMA_REMAP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.BYPASS_L2 = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_BYPASS_L2_USE_PTE_SETTING:
            fprintf(fp, "USE_PTE_SETTING\n");
            break;
        case NVA0B5_LAUNCH_DMA_BYPASS_L2_FORCE_VOLATILE:
            fprintf(fp, "FORCE_VOLATILE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_TYPE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_SRC_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NVA0B5_LAUNCH_DMA_SRC_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_TYPE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_DST_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NVA0B5_LAUNCH_DMA_DST_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 14) & ((1u << 4) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMIN:
            fprintf(fp, "IMIN\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMAX:
            fprintf(fp, "IMAX\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IXOR:
            fprintf(fp, "IXOR\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IAND:
            fprintf(fp, "IAND\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IOR:
            fprintf(fp, "IOR\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IADD:
            fprintf(fp, "IADD\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INC:
            fprintf(fp, "INC\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_DEC:
            fprintf(fp, "DEC\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FADD:
            fprintf(fp, "FADD\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMIN:
            fprintf(fp, "FMIN\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMAX:
            fprintf(fp, "FMAX\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMUL:
            fprintf(fp, "FMUL\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMUL:
            fprintf(fp, "IMUL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 18) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION_SIGN = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 19) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
